#!/usr/bin/perl

package eBay::API::XML::Call::GetProductSellingPages;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetProductSellingPages.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetProductSellingPages

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetProductSellingPages inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetProductSellingPages::GetProductSellingPagesRequestType;
use eBay::API::XML::Call::GetProductSellingPages::GetProductSellingPagesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetProductSellingPages';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetProductSellingPages::GetProductSellingPagesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetProductSellingPages::GetProductSellingPagesResponseType';
}

#
# input properties
#

=head2 setProduct()

A catalog product identifies a prototype description
of a well-known type of item, such as a popular book.
As this call supports batch requests, you can pass in an array of products
to retrieve data for several products at the same time.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrGPSellP
Title: Retrieving a Product's Item Specifics

  RequiredInput: Yes
#    Argument: reference to an array  
                      of 'ns:ProductType'

=cut
       
sub setProduct {
   my $self   = shift;
   my $pProduct = shift;
   $self->getRequestDataType()->setProduct($pProduct);
}

=head2 setUseCase()

Specifies the context in which the call is being executed, which will imply
certain validation rules. Use this property to make sure you retrieve the
appropriate version of product information and attribute meta-data
when you are listing, revising, or relisting an item with Pre-filled Item Information.
Valid values:<br>
<b>SYI</b> = Sell Your Item. Use before adding an item. Causes the response to include the
latest product ID in the system (given an ID specified in the Products element)
and the corresponding characteristic meta-data.<br>
<b>RYI</b> = Revise Your Item. Use this before revising an item. Causes the response to return
the product ID, attribute data, and other data associated with the version of the product
that you pass in the Products element. This is useful in case the product ID or associated data
has changed in the system since the item was originally listed. When revising
an item, this helps you make changes that are consistent with the original listing.<br>
<b>RELIST</b> = Use this before relisting an item. Causes the response to include the
latest product ID in the system (given an ID specified in the Products element)
and the corresponding characteristic meta-data. (Same as SYI).

  RequiredInput: Yes
#    Argument: 'ns:ProductUseCaseCodeType'

=cut
       
sub setUseCase {
   my $self   = shift;
   my $sUseCase = shift;
   $self->getRequestDataType()->setUseCase($sUseCase);
}



#
# output properties
#

=head2 getProductSellingPagesData()

A string containing a list of all the attributes that are applicable
to the products specified in the request, along with related meta-data.
The meta-data specifies the pre-filled values of each attribute, the
possible values of attributes that are not pre-filled, the logic for presenting
the attributes to a user, and rules for validating the user's selections.
<br><br>
For backward compatibility, this data is in
the same XML format that was used in the Legacy XML API so that you can
apply the same Item Specifics XSL stylesheet to it. That is, individual
elements are not described using the unified schema format.
<br><br>
The data is based on the GetAttributesCS response (AttributeData), with
additional information that is specific to catalog products.
Product and attribute information is nested within a set of Product tags.
The product-specific data is merged into the attribute data so that the same
XSL stylesheet used to render the results of GetAttributeCS can be used to render
catalog product data. See GetAttributesXSL.
<br><br>
See the Attribute Meta-Data Model section of the eBay Web Services guide
for information about each element in the ProductSellingPagesData string.
<br><br>
Because the content is returned as a string, the XML markup elements are escaped with
character entity references (e.g.,&amp;lt;eBay&amp;gt;&amp;lt;Attributes&amp;gt;...).
See the appendices in the eBay Web Services guide for general information about
string data types.

  Returned: Always
#    Returns: 'xs:string'

=cut
       
sub getProductSellingPagesData {
   my $self = shift;
   return $self->getResponseDataType()->getProductSellingPagesData();
}





1;   
