#!/usr/bin/perl

package eBay::API::XML::Call::GetPictureManagerOptions::GetPictureManagerOptionsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetPictureManagerOptionsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetPictureManagerOptions::GetPictureManagerOptionsResponseType

=head1 DESCRIPTION

Returns a list of Picture Manager options and allowed values.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetPictureManagerOptions::GetPictureManagerOptionsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::PictureManagerPictureDisplayType;
use eBay::API::XML::DataType::PictureManagerSubscriptionType;


my @gaProperties = ( [ 'PictureType', 'ns:PictureManagerPictureDisplayType', '1'
	     ,'eBay::API::XML::DataType::PictureManagerPictureDisplayType', '1' ]
	, [ 'Subscription', 'ns:PictureManagerSubscriptionType', '1'
	     ,'eBay::API::XML::DataType::PictureManagerSubscriptionType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setPictureType()

A global definition for displaying pictures, with a maximum size.

#    Argument: reference to an array  
                      of 'ns:PictureManagerPictureDisplayType'

=cut

sub setPictureType {
  my $self = shift;
  $self->{'PictureType'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getPictureType()

  Returned: Always
#    Returns: reference to an array  
                      of 'ns:PictureManagerPictureDisplayType'

=cut

sub getPictureType {
  my $self = shift;
  return $self->_getDataTypeArray('PictureType');
}


=head2 setSubscription()

A type of Picture Manager subscription, with a subscription level, fee,
and allowed storage size.

#    Argument: reference to an array  
                      of 'ns:PictureManagerSubscriptionType'

=cut

sub setSubscription {
  my $self = shift;
  $self->{'Subscription'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSubscription()

  Returned: Always
#    Returns: reference to an array  
                      of 'ns:PictureManagerSubscriptionType'

=cut

sub getSubscription {
  my $self = shift;
  return $self->_getDataTypeArray('Subscription');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
