#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 210_Slurm-SACluster-echo.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Cluster;

my $testDir = dirname(abs_path($0));
our $num_tests_run = 0;

require "$testDir/helpers/echo-help.pl";

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/echo_cmdline");
my $sacluster = 'Slurm::Sacctmgr::Cluster';

my $results;
my $args;
my $err;
my $argstr;
my (@temp, @temp2);
my ($temp, $temp2);

#Test various commands with echo sacctmgr


my @listtmp1 = ( 'list', 'cluster', 'format=classification,cluster,controlhost,controlport,cpucount,flags,nodecount,nodenames,pluginidselect,rpc' );
my @listtmp2 = ( '--parsable2', '--noheader', '--readonly' );
@temp = ( cluster=>'yottascale', );
$results = $sacluster->sacctmgr_list($sa,@temp);
$results = $sacluster->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single cluster');

@temp = ( cluster => 'yottascale', controlhost=>'ys-master1'  );
$results = $sacluster->sacctmgr_list($sa,@temp);
$results = $sacluster->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list cluster multi-fields');


@temp = ( cluster=>'yottascale', controlhost=>'ys-master1', controlport=>6817, rpc=>7168, 
	nodecount=>1000000, cpucount=>20000000, nodenames=>'compute-[0-99999]' );
$results = $sacluster->sacctmgr_add($sa,@temp);
$results = $sacluster->_ebadddel_last_raw_output;
$args = [ '-i', 'add', 'cluster', hash_to_arglist_lexical(@temp) ];
check_results($args, $results, 'sacctmgr_add cluster');

note('Ignore output to stderr about return value from sacctmgr_modify');
@temp = ( cluster=>'yottascale',  );
@temp2 = ( classification => 'virtual' );
$temp = { @temp }; 
$temp2 = { @temp2 };
$results = $sacluster->sacctmgr_modify($sa,$temp, $temp2);
$results = $sacluster->_ebmod_last_raw_output;
$args = [ '-i', 'modify', 'cluster', 'where',  hash_to_arglist(@temp), 'set', hash_to_arglist(@temp2) ];
check_results($args, $results, 'sacctmgr_modify cluster');

@temp = ( cluster=>'yottascale', );
$results = $sacluster->sacctmgr_delete($sa,@temp);
$results = $sacluster->_ebadddel_last_raw_output;
$args = [ '-i', 'delete', 'cluster', 'where', hash_to_arglist(@temp) ];
check_results($args, $results, 'sacctmgr_delete cluster');


#Now verify that nothing is run when we are in debug mode
note('The remaining tests generate [DRYRUN] lines, which you can ignore');
note('We just want to make sure they dont actually _do_ anything');
$sa->dryrun(1);

@temp = ( cluster=>'yottascale', controlhost=>'ys-master1', controlport=>6817, rpc=>7168, 
	nodecount=>1000000, cpucount=>20000000, nodenames=>'compute-[0-99999]' );
$results = $sacluster->sacctmgr_add($sa,@temp);
$results =$sacluster->_ebadddel_last_raw_output; 
is_deeply( $results, [], "sacctmgr_add cluster (dryrun mode)");
$num_tests_run++;

@temp = ( cluster=>'yottascale',  );
@temp2 = ( classification => 'virtual' );
$temp = { @temp }; 
$temp2 = { @temp2 };
$results = $sacluster->sacctmgr_modify($sa,$temp, $temp2);
$results = $sacluster->_ebmod_last_raw_output;
is_deeply( $results, [], "sacctmgr_modify cluster (dryrun mode)");
$num_tests_run++;

@temp = ( cluster=>'yottascale', );
$results = $sacluster->sacctmgr_delete($sa,@temp);
$results = $sacluster->_ebadddel_last_raw_output;
is_deeply( $results, [], "sacctmgr_delete cluster (dryrun mode)");
$num_tests_run++;

#This one actually _should_ run, as is just a list
@temp = ( name=>'payerle', );
$results = $sacluster->sacctmgr_list($sa,@temp);
$results = $sacluster->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single cluster (dryrun mode)');

done_testing($num_tests_run);

