/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.plantuml.api.Performance;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;

public class ProcessRunnerOld2 {
    public static long TIMEOUT = 900000L;
    private static final long LOCK_WAITING_TIMEOUT = -1L;
    private final String[] cmd;
    private String error;
    private String out;
    private volatile ProcessState state = ProcessState.INIT;
    private final Lock changeState = new ReentrantLock();
    private static final Lock oneSingleProcess = new ReentrantLock();
    private static volatile MainThread runningThread;

    public ProcessRunnerOld2(String[] stringArray) {
        this.cmd = stringArray;
    }

    public ProcessState run(byte[] byArray, OutputStream outputStream) {
        return this.run(byArray, outputStream, null);
    }

    public ProcessState run(byte[] byArray, OutputStream outputStream, File file) {
        if (this.state != ProcessState.INIT) {
            throw new IllegalStateException();
        }
        this.state = ProcessState.RUNNING;
        MainThread mainThread = new MainThread(this.cmd, file, outputStream, byArray);
        try {
            this.doTheJob(mainThread);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (this.state == ProcessState.TERMINATED_OK) {
            assert (mainThread != null);
            this.error = mainThread.getError();
            this.out = mainThread.getOut();
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTheJobWithLock(MainThread mainThread) throws InterruptedException {
        while (true) {
            MainThread mainThread2 = runningThread;
            boolean bl = oneSingleProcess.tryLock(-1L, TimeUnit.MILLISECONDS);
            if (bl) {
                try {
                    runningThread = mainThread;
                    this.doTheJob(mainThread);
                    runningThread = null;
                    Object var5_4 = null;
                    oneSingleProcess.unlock();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    oneSingleProcess.unlock();
                    throw throwable;
                }
                return;
            }
            if (mainThread2 != runningThread) continue;
            Performance.incDotInterruption3();
            mainThread2.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTheJob(MainThread mainThread) throws InterruptedException {
        Object v1;
        block7: {
            try {
                mainThread.start();
                mainThread.join(TIMEOUT);
                Object var3_2 = null;
                this.changeState.lock();
            }
            catch (Throwable throwable) {
                Object v0;
                Object var3_3 = null;
                this.changeState.lock();
                try {
                    if (this.state == ProcessState.RUNNING) {
                        this.state = ProcessState.TIMEOUT;
                        mainThread.cancel();
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var5_7 = v0;
                this.changeState.unlock();
                throw throwable;
            }
            try {
                if (this.state == ProcessState.RUNNING) {
                    this.state = ProcessState.TIMEOUT;
                    mainThread.cancel();
                }
                v1 = null;
                break block7;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var5_6 = v1;
        this.changeState.unlock();
    }

    public final String getError() {
        return this.error;
    }

    public final String getOut() {
        return this.out;
    }

    private void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    class ThreadStream
    extends Thread {
        private volatile InputStream streamToRead;
        private volatile OutputStream redirection;
        private volatile StringBuffer sb = new StringBuffer();

        ThreadStream(InputStream inputStream, OutputStream outputStream) {
            this.streamToRead = inputStream;
            this.redirection = outputStream;
        }

        public String getString() {
            return this.sb.toString();
        }

        public void cancel() {
            assert (ProcessRunnerOld2.this.state == ProcessState.TIMEOUT);
            this.interrupt();
            this.sb = null;
            this.streamToRead = null;
            this.redirection = null;
        }

        public void run() {
            int n = 0;
            try {
                while ((n = this.streamToRead.read()) != -1) {
                    if (ProcessRunnerOld2.this.state == ProcessState.TIMEOUT) {
                        return;
                    }
                    if (this.redirection == null) {
                        this.sb.append((char)n);
                        continue;
                    }
                    this.redirection.write(n);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.sb.append('\n');
                this.sb.append(throwable.toString());
            }
        }
    }

    class MainThread
    extends Thread {
        private final String[] cmd;
        private final File dir;
        private final OutputStream redirection;
        private final byte[] in;
        private volatile Process process;
        private volatile ThreadStream errorStream;
        private volatile ThreadStream outStream;

        public MainThread(String[] stringArray, File file, OutputStream outputStream, byte[] byArray) {
            this.cmd = stringArray;
            this.dir = file;
            this.redirection = outputStream;
            this.in = byArray;
        }

        public String getOut() {
            return this.outStream.getString();
        }

        public String getError() {
            return this.errorStream.getString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block17: {
                block14: {
                    this.runInternal();
                    if (ProcessRunnerOld2.this.state != ProcessState.RUNNING) break block14;
                    int n = this.joinInternal();
                }
                Object var3_3 = null;
                ProcessRunnerOld2.this.changeState.lock();
                try {
                    if (ProcessRunnerOld2.this.state == ProcessState.RUNNING) {
                        ProcessRunnerOld2.this.state = ProcessState.TERMINATED_OK;
                    }
                    Object var5_6 = null;
                    ProcessRunnerOld2.this.changeState.unlock();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    ProcessRunnerOld2.this.changeState.unlock();
                    throw throwable;
                }
                if (this.process != null) {
                    this.process.destroy();
                    ProcessRunnerOld2.this.close(this.process.getErrorStream());
                    ProcessRunnerOld2.this.close(this.process.getOutputStream());
                    ProcessRunnerOld2.this.close(this.process.getInputStream());
                }
                break block17;
                {
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        Object var3_4 = null;
                        ProcessRunnerOld2.this.changeState.lock();
                        try {
                            if (ProcessRunnerOld2.this.state == ProcessState.RUNNING) {
                                ProcessRunnerOld2.this.state = ProcessState.TERMINATED_OK;
                            }
                            Object var5_8 = null;
                            ProcessRunnerOld2.this.changeState.unlock();
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            ProcessRunnerOld2.this.changeState.unlock();
                            throw throwable;
                        }
                        if (this.process != null) {
                            this.process.destroy();
                            ProcessRunnerOld2.this.close(this.process.getErrorStream());
                            ProcessRunnerOld2.this.close(this.process.getOutputStream());
                            ProcessRunnerOld2.this.close(this.process.getInputStream());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    ProcessRunnerOld2.this.changeState.lock();
                    try {
                        if (ProcessRunnerOld2.this.state == ProcessState.RUNNING) {
                            ProcessRunnerOld2.this.state = ProcessState.TERMINATED_OK;
                        }
                        Object var5_10 = null;
                        ProcessRunnerOld2.this.changeState.unlock();
                    }
                    catch (Throwable throwable2) {
                        Object var5_11 = null;
                        ProcessRunnerOld2.this.changeState.unlock();
                        throw throwable2;
                    }
                    if (this.process != null) {
                        this.process.destroy();
                        ProcessRunnerOld2.this.close(this.process.getErrorStream());
                        ProcessRunnerOld2.this.close(this.process.getOutputStream());
                        ProcessRunnerOld2.this.close(this.process.getInputStream());
                    }
                    throw throwable;
                }
            }
        }

        private void cancel() {
            assert (ProcessRunnerOld2.this.changeState.tryLock());
            assert (ProcessRunnerOld2.this.state == ProcessState.TIMEOUT);
            if (this.process != null) {
                this.errorStream.cancel();
                this.outStream.cancel();
                this.process.destroy();
                this.interrupt();
                ProcessRunnerOld2.this.close(this.process.getErrorStream());
                ProcessRunnerOld2.this.close(this.process.getOutputStream());
                ProcessRunnerOld2.this.close(this.process.getInputStream());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runInternal() {
            try {
                this.process = Runtime.getRuntime().exec(this.cmd, null, this.dir);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Performance.incDotInterruption1();
                ProcessRunnerOld2.this.changeState.lock();
                try {
                    ProcessRunnerOld2.this.state = ProcessState.IO_EXCEPTION1;
                    Object var3_3 = null;
                    ProcessRunnerOld2.this.changeState.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    ProcessRunnerOld2.this.changeState.unlock();
                    throw throwable;
                }
                iOException.printStackTrace();
                return;
            }
            this.errorStream = new ThreadStream(this.process.getErrorStream(), null);
            this.outStream = new ThreadStream(this.process.getInputStream(), this.redirection);
            this.errorStream.start();
            this.outStream.start();
            if (this.in != null) {
                OutputStream outputStream = this.process.getOutputStream();
                try {
                    try {
                        outputStream.write(this.in);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        outputStream.close();
                        throw throwable;
                    }
                    outputStream.close();
                    {
                    }
                }
                catch (IOException iOException) {
                    Performance.incDotInterruption2();
                    ProcessRunnerOld2.this.changeState.lock();
                    try {
                        ProcessRunnerOld2.this.state = ProcessState.IO_EXCEPTION2;
                        Object var7_10 = null;
                        ProcessRunnerOld2.this.changeState.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        ProcessRunnerOld2.this.changeState.unlock();
                        throw throwable;
                    }
                    iOException.printStackTrace();
                }
            }
        }

        public int joinInternal() throws InterruptedException {
            this.errorStream.join();
            this.outStream.join();
            int n = this.process.waitFor();
            return n;
        }
    }
}

