package xDash::Logger::Dumb;
# Copyright 2005 Jerzy Wachowiak

use strict;
use vars qw( $VERSION );

$VERSION = '1.00';

# Dumb provides the base class for loggers doing nothing but 
# needed for interfaces implemented in subclases.

# PUBLIC methods (convention: capital first letter)

sub new {

    my $class = shift;
    my $self = {};
    $self->{VERSION} = $VERSION;
    bless ( $self, $class );
    return $self;
}

sub Open { return 1 }
#Contract: 
#	[1] Dummy method for subclasses 
#       [2] Open()  always suceeds (true)

sub Log { return 1 }
#Contract: 
#	[1] Dummy method for subclasses
#	[2] Log() always suceeds (true)

sub Close { return 1 }
#Contract: 
#	[1] Dummy method for subclasses
#	[2] Close() always suceeds (true)

1;
__END__
######################## User Documentation ##################

=pod

=head1 NAME

xDash::Logger::Dumb - Base class for EventLogger, ErrorLogger, MessageLogger and EmergencyLogger

=head1 SYNOPSIS

 package MessageLogger;
 # Uncomment the 1.line and comment out 2.line & 3.line below after debugging.
 use base xDash::Logger::Dumb;
 #use base xDash::Logger::File;
 #sub Open { shift->SUPER::Open( STDOUT ) }

=head1 DESCRIPTION

The module is developed in the object orientated way. It can be used as the 
base class for logging tasks, which have to implement a 
fixed set of methods called by the derived class C<EventLogger>, 
C<ErrorLogger>, C<MessageLogger> and C<EmergencyLogger>
hard coded in C<xDash::Sender>, C<xDash::Receiver> and C<xDash::Archivist> 
(driver pattern). By deriving from the class, you have not to implement explicit 
any methods as nothing should be logged (dumb logger).
The synopsis above is an example of the client script generated by 
the F<xdscr> after debugging. 

=head1 BUGS

Any suggestions for improvement are welcomed!

If a bug is detected or nonconforming behavior, 
please send an error report to <jwach@cpan.org>.

=head1 COPYRIGHT

Copyright 2005 Jerzy Wachowiak <jwach@cpan.org>

This library is free software; you can redistribute it and/or modify
it under the terms of the Apache 2.0 license attached to the module.

=head1 SEE ALSO

=over

=item L<xDash::Sender>

=item L<xDash::Receiver>

=item L<xDash::Archivist>

=back

=cut
