# Generated by default/object.tt
package Paws::MediaConnect::ResourceSpecification;
  use Moose;
  has ReservedBitrate => (is => 'ro', isa => 'Int', request_name => 'reservedBitrate', traits => ['NameInRequest']);
  has ResourceType => (is => 'ro', isa => 'Str', request_name => 'resourceType', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConnect::ResourceSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConnect::ResourceSpecification object:

  $service_obj->Method(Att1 => { ReservedBitrate => $value, ..., ResourceType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConnect::ResourceSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->ReservedBitrate

=head1 DESCRIPTION

A definition of what is being billed for, including the type and
amount.

=head1 ATTRIBUTES


=head2 ReservedBitrate => Int

The amount of outbound bandwidth that is discounted in the offering.


=head2 B<REQUIRED> ResourceType => Str

The type of resource and the unit that is being billed for.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConnect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

