# Generated by default/object.tt
package Paws::ManagedBlockchain::Member;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreationDate => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has FrameworkAttributes => (is => 'ro', isa => 'Paws::ManagedBlockchain::MemberFrameworkAttributes');
  has Id => (is => 'ro', isa => 'Str');
  has KmsKeyArn => (is => 'ro', isa => 'Str');
  has LogPublishingConfiguration => (is => 'ro', isa => 'Paws::ManagedBlockchain::MemberLogPublishingConfiguration');
  has Name => (is => 'ro', isa => 'Str');
  has NetworkId => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'Paws::ManagedBlockchain::OutputTagMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ManagedBlockchain::Member

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ManagedBlockchain::Member object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ManagedBlockchain::Member object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Member configuration properties.

Applies only to Hyperledger Fabric.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the member. For more information
about ARNs and their format, see Amazon Resource Names (ARNs)
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
in the I<AWS General Reference>.


=head2 CreationDate => Str

The date and time that the member was created.


=head2 Description => Str

An optional description for the member.


=head2 FrameworkAttributes => L<Paws::ManagedBlockchain::MemberFrameworkAttributes>

Attributes relevant to a member for the blockchain framework that the
Managed Blockchain network uses.


=head2 Id => Str

The unique identifier of the member.


=head2 KmsKeyArn => Str

The Amazon Resource Name (ARN) of the customer managed key in AWS Key
Management Service (AWS KMS) that the member uses for encryption at
rest. If the value of this parameter is C<"AWS Owned KMS Key">, the
member uses an AWS owned KMS key for encryption. This parameter is
inherited by the nodes that this member owns.


=head2 LogPublishingConfiguration => L<Paws::ManagedBlockchain::MemberLogPublishingConfiguration>

Configuration properties for logging events associated with a member.


=head2 Name => Str

The name of the member.


=head2 NetworkId => Str

The unique identifier of the network to which the member belongs.


=head2 Status => Str

The status of a member.

=over

=item *

C<CREATING> - The AWS account is in the process of creating a member.

=item *

C<AVAILABLE> - The member has been created and can participate in the
network.

=item *

C<CREATE_FAILED> - The AWS account attempted to create a member and
creation failed.

=item *

C<UPDATING> - The member is in the process of being updated.

=item *

C<DELETING> - The member and all associated resources are in the
process of being deleted. Either the AWS account that owns the member
deleted it, or the member is being deleted as the result of an
C<APPROVED> C<PROPOSAL> to remove the member.

=item *

C<DELETED> - The member can no longer participate on the network and
all associated resources are deleted. Either the AWS account that owns
the member deleted it, or the member is being deleted as the result of
an C<APPROVED> C<PROPOSAL> to remove the member.

=item *

C<INACCESSIBLE_ENCRYPTION_KEY> - The member is impaired and might not
function as expected because it cannot access the specified customer
managed key in AWS KMS for encryption at rest. Either the KMS key was
disabled or deleted, or the grants on the key were revoked.

The effect of disabling or deleting a key, or revoking a grant is not
immediate. The member resource might take some time to find that the
key is inaccessible. When a resource is in this state, we recommend
deleting and recreating the resource.

=back



=head2 Tags => L<Paws::ManagedBlockchain::OutputTagMap>

Tags assigned to the member. Tags consist of a key and optional value.
For more information about tags, see Tagging Resources
(https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
in the I<Amazon Managed Blockchain Hyperledger Fabric Developer Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ManagedBlockchain>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

