package Google::Ads::AdWords::v201109_1::AdTypeSearchParameter;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201109_1' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109_1::SearchParameter);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SearchParameter__Type_of :ATTR(:get<SearchParameter__Type>);
my %adTypes_of :ATTR(:get<adTypes>);

__PACKAGE__->_factory(
    [ qw(        SearchParameter__Type
        adTypes

    ) ],
    {
        'SearchParameter__Type' => \%SearchParameter__Type_of,
        'adTypes' => \%adTypes_of,
    },
    {
        'SearchParameter__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'adTypes' => 'Google::Ads::AdWords::v201109_1::SiteConstants::AdType',
    },
    {

        'SearchParameter__Type' => 'SearchParameter.Type',
        'adTypes' => 'adTypes',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::AdTypeSearchParameter

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AdTypeSearchParameter from the namespace https://adwords.google.com/api/adwords/o/v201109_1.

A {@link SearchParameter} for {@code PLACEMENT} {@link IdeaType}s used to filter the results by the {@link AdType}. <p>This element is supported by following {@link IdeaType}s: PLACEMENT. <p>This element is supported by following {@link RequestType}s: IDEAS. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * adTypes




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109_1::AdTypeSearchParameter
   adTypes => $some_value, # SiteConstants.AdType
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

