package Google::Ads::AdWords::v201109_1::Account;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201109_1' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %customerId_of :ATTR(:get<customerId>);
my %login_of :ATTR(:get<login>);
my %companyName_of :ATTR(:get<companyName>);
my %canManageClients_of :ATTR(:get<canManageClients>);
my %currencyCode_of :ATTR(:get<currencyCode>);
my %dateTimeZone_of :ATTR(:get<dateTimeZone>);

__PACKAGE__->_factory(
    [ qw(        customerId
        login
        companyName
        canManageClients
        currencyCode
        dateTimeZone

    ) ],
    {
        'customerId' => \%customerId_of,
        'login' => \%login_of,
        'companyName' => \%companyName_of,
        'canManageClients' => \%canManageClients_of,
        'currencyCode' => \%currencyCode_of,
        'dateTimeZone' => \%dateTimeZone_of,
    },
    {
        'customerId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'login' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'companyName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'canManageClients' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'currencyCode' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'dateTimeZone' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'customerId' => 'customerId',
        'login' => 'login',
        'companyName' => 'companyName',
        'canManageClients' => 'canManageClients',
        'currencyCode' => 'currencyCode',
        'dateTimeZone' => 'dateTimeZone',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::Account

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Account from the namespace https://adwords.google.com/api/adwords/mcm/v201109_1.

Represents a single AdWords account. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * customerId


=item * login


=item * companyName


=item * canManageClients


=item * currencyCode


=item * dateTimeZone




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109_1::Account
   customerId =>  $some_value, # long
   login =>  $some_value, # string
   companyName =>  $some_value, # string
   canManageClients =>  $some_value, # boolean
   currencyCode =>  $some_value, # string
   dateTimeZone =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

