#!/usr/bin/env perl
use strict;
use warnings;
use Test::More 'no_plan';
use Test::Exception;

use Dependency::Resolver;
use Dependency::Resolver::Node;


my $node = "Dependency::Resolver::Node";


#          A
#         / \
#        v   v
#        D   B
#        ^  /\
#         \v  v
#          C->E


my $a = $node->new( name => 'a' );
my $b = $node->new( name => 'b' );
my $c = $node->new( name => 'c' );
my $d = $node->new( name => 'd' );
my $e = $node->new( name => 'e' );

$a->addEdge($b);    # a depends on b
$a->addEdge($d);    # a depends on d
$b->addEdge($c);    # b depends on c
$b->addEdge($e);    # b depends on e
$c->addEdge($d);    # c depends on d
$c->addEdge($e);    # c depends on e


my $resolver = Dependency::Resolver->new;

my $resolved = $resolver->dep_resolv($a);

is_deeply( $resolved, [ $d, $e, $c, $b, $a ], 'return the expected nodes');

$d->addEdge($b);
dies_ok { $resolver->dep_resolv($a) } 'dep_resolv die with a circular dependency';
