;; py.scm -- PinYin table for uim.

;; This file is generated from zh-py.mim in m17n-lib.

;; zh-py.mim -- Chinese input method with Pinyin sequence
;; Copyright (C) 2003, 2004, 2005
;;   National Institute of Advanced Industrial Science and Technology (AIST)
;;   Registration Number H15PRO112

;; This file is part of the m17n database; a sub-part of the m17n
;; library.

;; The m17n library is free software; you can redistribute it and/or
;; modify it under the terms of the GNU Lesser General Public License
;; as published by the Free Software Foundation; either version 2.1 of
;; the License, or (at your option) any later version.

;; The m17n library is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; Lesser General Public License for more details.

;; You should have received a copy of the GNU Lesser General Public License
;; along with the m17n library; if not, see <https://www.gnu.org/licenses/>.

;; The map "pinyin" was generated from the "Unihan database" belonging
;; to the "Unicode Character Database", and that part is governed by
;; the "Unicode Copyright" (see the file UNIDATA/copyright.html).


 ;; Big table of Pinyin vs the corresponding Chinese characters.  This
 ;; part is generated automatically from the Unihan database
 ;; "Unihan.txt" using the entries kMandarin and kHanyuPinlu.

(define py-rule
  '(
  ((("a")) ("啊" "呵" "阿" "吖" "嗄" "腌" "锕" "錒"))
  ((("a" "i")) ("爱" "哎" "挨" "碍" "哀" "矮" "癌" "埃" "蔼" "隘" "唉" "皑" "艾" "呆" "诶" "捱" "嗳" "嗌" "嫒" "瑷" "暧" "砹" "锿" "霭" "㑸" "㕌" "㗒" "㗨" "㘷" "㝵" "㝶" "㢊" "㤅" "㱯" "㿄" "䀳" "䅬" "䑂" "䔽" "䝽" "䠹" "䨠" "䬵" "䶣" "伌" "佁" "僾" "叆" "啀" "嘊" "噯" "堨" "塧" "壒" "娭" "娾" "嬡" "嵦" "愛" "懓" "懝" "戹" "敱" "敳" "昹" "曖" "欸" "毐" "濭" "獃" "璦" "皚" "皧" "瞹" "砨" "硋" "硙" "磑" "礙" "薆" "藹" "誒" "譪" "賹" "躷" "銰" "鎄" "鑀" "閡" "阨" "阸" "靄" "靉" "餲" "馤" "騃" "鴱"))
  ((("a" "n")) ("安" "按" "岸" "暗" "案" "俺" "氨" "鹌" "黯" "鞍" "胺" "厂" "广" "盒" "阴" "谙" "埯" "揞" "犴" "庵" "桉" "腌" "铵" "蝻" "㜝" "㟁" "㱘" "㸩" "㽢" "䁆" "䅁" "䅖" "䎏" "䎨" "䜙" "䬓" "䮗" "䯥" "侒" "儑" "匎" "匼" "厈" "唵" "啽" "垵" "堓" "媕" "峎" "峖" "晻" "洝" "玵" "痷" "盦" "盫" "罯" "腤" "荌" "菴" "萻" "葊" "蓭" "誝" "諳" "豻" "鉗" "銨" "錌" "闇" "阥" "陰" "隂" "隌" "雸" "鞌" "韽" "頇" "馣" "鮟" "鵪" "鶕" "黬"))
  ((("a" "n" "g")) ("昂" "肮" "盎" "仰" "腌" "㦹" "㭿" "㼜" "䀚" "䍩" "䒢" "䩕" "䬓" "䭹" "䭺" "卬" "岇" "昻" "枊" "軮" "醠" "雵" "骯"))
  ((("a" "o")) ("傲" "袄" "凹" "熬" "敖" "翱" "奥" "懊" "澳" "棍" "浇" "嚣" "坳" "拗" "嗷" "岙" "廒" "遨" "媪" "骜" "獒" "燠" "聱" "螯" "鏊" "鳌" "鏖" "㑃" "㕭" "㘬" "㘭" "㜜" "㜩" "㟼" "㠂" "㠗" "㤇" "㥿" "㿰" "䁱" "䐿" "䚫" "䜒" "䞝" "䥝" "䦋" "䫨" "䮯" "䯠" "䴈" "䵅" "厫" "嗸" "圫" "垇" "墺" "奡" "奧" "媼" "嫯" "嶅" "嶴" "慠" "扷" "抝" "摮" "擙" "柪" "梎" "滶" "澆" "爊" "狕" "獓" "璈" "磝" "磽" "翺" "芺" "蔜" "襖" "詏" "謷" "謸" "軪" "镺" "隞" "隩" "驁" "鰲" "鴁" "鷔" "鼇" "𥜌" "𦪈" "𩼈"))
  ((("b" "a")) ("把" "吧" "罢" "八" "爸" "巴" "拔" "扒" "霸" "叭" "坝" "笆" "芭" "捌" "疤" "跋" "靶" "耙" "伯" "湃" "茇" "菝" "萆" "岜" "灞" "杷" "钯" "钹" "粑" "鲅" "魃" "㔜" "㖠" "㞎" "㧊" "㶚" "䃻" "䆉" "䇑" "䎬" "䎱" "䟦" "䥯" "䩗" "䩻" "䰾" "䱝" "䳁" "䳊" "仈" "叐" "哵" "坺" "垻" "墢" "壩" "夿" "妭" "峇" "弝" "抜" "朳" "欛" "炦" "犮" "猈" "玐" "癹" "秡" "罷" "羓" "胈" "覇" "詙" "豝" "軷" "釟" "鈀" "鈸" "颰" "馛" "鮁" "鮊" "鲃" "鲌" "鼥"))
  ((("b" "a" "i")) ("百" "白" "摆" "败" "拜" "柏" "掰" "罢" "佰" "稗" "伯" "派" "薜" "捭" "呗" "鞴" "㗑" "㗗" "㠔" "㼟" "㼣" "㿟" "䒔" "䙓" "䢙" "䥯" "䳆" "䴽" "唄" "庍" "拝" "擺" "敗" "栢" "棑" "矲" "粨" "粺" "絔" "罷" "蛽" "襬" "贁"))
  ((("b" "a" "n")) ("办" "半" "般" "板" "班" "搬" "伴" "版" "拌" "瓣" "扮" "扳" "颁" "斑" "绊" "辨" "阪" "坂" "钣" "瘢" "癍" "舨" "㚘" "㩯" "㪵" "㸞" "㺜" "䉽" "䕰" "䬳" "埿" "姅" "岅" "怑" "攽" "斒" "昄" "朌" "湴" "秚" "粄" "絆" "肦" "虨" "蝂" "螌" "褩" "辦" "辬" "辯" "鈑" "鉡" "闆" "靽" "頒" "魬"))
  ((("b" "a" "n" "g")) ("帮" "膀" "棒" "绑" "傍" "榜" "磅" "邦" "梆" "蚌" "镑" "谤" "纺" "旁" "蒡" "浜" "氆" "螃" "㔙" "㭋" "㮄" "㯁" "㾦" "䂜" "䎧" "䖫" "䟺" "䧛" "䰷" "並" "垹" "埲" "塝" "幇" "幚" "幫" "挷" "捠" "搒" "棓" "牓" "玤" "稖" "竝" "紡" "綁" "縍" "艕" "蜯" "謗" "邫" "鎊" "鞤" "髈"))
  ((("b" "a" "o")) ("报" "保" "包" "抱" "宝" "爆" "暴" "胞" "饱" "薄" "堡" "雹" "豹" "苞" "褒" "剥" "鲍" "刨" "炮" "袍" "曝" "瀑" "勹" "裒" "苴" "葆" "掊" "孢" "脬" "煲" "鸨" "褓" "褴" "趵" "龅" "㙅" "㙸" "㫧" "㲏" "㲒" "㵡" "㻄" "㿺" "䈏" "䎂" "䤖" "䥤" "䨌" "䨔" "䪨" "䭋" "䳈" "䳰" "䴐" "儤" "剝" "勽" "堢" "報" "嫑" "宲" "寚" "寳" "寶" "忁" "怉" "抔" "曓" "枹" "犦" "珤" "瓟" "窇" "笣" "緥" "菢" "蕔" "虣" "袌" "襃" "賲" "鉋" "鑤" "铇" "闁" "靌" "鞄" "飽" "駂" "骲" "鮑" "鳵" "鴇" "鸔"))
  ((("b" "e" "i")) ("被" "备" "北" "背" "倍" "悲" "杯" "辈" "碑" "贝" "呗" "臂" "卑" "狈" "拔" "跋" "钡" "惫" "焙" "波" "排" "葡" "菩" "孛" "陂" "邶" "埤" "萆" "蓓" "庳" "悖" "碚" "鹎" "褙" "蜚" "鐾" "鞴" "㓈" "㔨" "㛝" "㣁" "㤳" "㰆" "㱯" "㶔" "㷶" "㸢" "㸬" "㸽" "㻗" "㼎" "㾱" "䁅" "䋳" "䔒" "䟺" "䠙" "䡶" "䩀" "䰽" "伓" "俻" "偝" "偹" "備" "僃" "唄" "壀" "岥" "愂" "憊" "揹" "昁" "杮" "桮" "梖" "棓" "椑" "牬" "犕" "犤" "狽" "珼" "琲" "痺" "盃" "禆" "箄" "簰" "糒" "紴" "絥" "綼" "藣" "誖" "貝" "軰" "輩" "郥" "鄁" "鉳" "鋇" "錃" "鞁" "韛" "骳" "鵯"))
  ((("b" "e" "n")) ("本" "奔" "笨" "苯" "夯" "体" "畚" "坌" "贲" "锛" "㡷" "㤓" "㨧" "㮺" "㱵" "䬱" "倴" "夲" "奙" "捹" "撪" "栟" "桳" "楍" "泍" "渀" "燌" "犇" "獖" "蟦" "賁" "軬" "輽" "逩" "錛" "鐼"))
  ((("b" "e" "n" "g")) ("甭" "蹦" "崩" "绷" "泵" "榜" "蚌" "迸" "抨" "堋" "唪" "嘣" "甏" "㑟" "㛝" "㱶" "㷯" "䋽" "䙀" "䨻" "䩬" "䭰" "䳞" "伻" "埲" "塴" "嵭" "挷" "搒" "槰" "玤" "琫" "祊" "絣" "綳" "繃" "菶" "螷" "蠯" "誁" "跰" "逬" "錋" "鏰" "镚" "閍" "鞛" "𢏳"))
  ((("b" "i")) ("比" "必" "笔" "鼻" "避" "毕" "壁" "闭" "逼" "臂" "彼" "蔽" "币" "碧" "辟" "毙" "鄙" "痹" "被" "蓖" "毖" "庇" "敝" "弊" "陛" "波" "肥" "费" "拂" "服" "秘" "泌" "脾" "瞥" "匕" "俾" "陂" "陴" "埤" "芘" "荜" "荸" "菝" "萆" "薜" "蘖" "吡" "哔" "狴" "庳" "愎" "滗" "濞" "弼" "妣" "婢" "嬖" "纰" "璧" "枇" "檗" "殍" "贲" "睥" "畀" "铋" "秕" "馥" "裨" "蚍" "筚" "箅" "篦" "舭" "襞" "跛" "跸" "鐾" "髀" "㓖" "㕭" "㗉" "㘠" "㘩" "㙄" "㚰" "㠲" "㡀" "㡙" "㢰" "㢶" "㢸" "㧙" "㪏" "㪤" "㮄" "㮰" "㮿" "㯇" "㱸" "㳼" "㵥" "㵨" "㷶" "㹃" "㻫" "㻶" "㿫" "䀣" "䁅" "䁹" "䃾" "䄶" "䇷" "䊧" "䋔" "䌟" "䎵" "䏢" "䏶" "䐿" "䕗" "䖩" "䘡" "䟆" "䟤" "䠋" "䣥" "䦘" "䧗" "䨆" "䩛" "䪐" "䫁" "䫾" "䬛" "䭮" "䮡" "䯗" "䵄" "佊" "佖" "偪" "咇" "啚" "嗶" "坒" "堛" "壀" "夶" "奰" "妼" "屄" "幣" "廦" "弻" "彃" "怭" "愊" "斃" "朼" "枈" "柀" "柲" "梐" "楅" "檘" "毴" "沘" "湢" "滭" "潷" "煏" "熚" "獘" "獙" "珌" "畁" "畢" "疕" "疪" "痺" "皀" "皕" "睤" "稫" "筆" "箄" "箆" "篳" "粃" "粊" "紕" "綼" "縪" "繴" "罷" "罼" "聛" "肸" "肹" "腷" "苾" "蓽" "蜌" "螕" "螷" "袐" "襣" "觱" "詖" "诐" "豍" "貏" "貱" "費" "賁" "贔" "赑" "蹕" "躃" "躄" "邲" "鄨" "鄪" "鉍" "鎞" "鏎" "鐴" "閇" "閉" "閟" "鞞" "鞸" "韠" "颷" "飶" "饆" "馝" "駜" "驆" "骳" "髲" "魓" "魮" "鮅" "鰏" "鲾" "鵖" "鷝" "鷩" "鸊" "鼊" "𡚁"))
  ((("b" "i" "a" "n")) ("边" "变" "便" "遍" "编" "辩" "扁" "辫" "辨" "鞭" "匾" "蝙" "贬" "卞" "弁" "苄" "忭" "汴" "缏" "煸" "砭" "碥" "稹" "窆" "褊" "笾" "鳊" "㝸" "㣐" "㦚" "㭓" "㲢" "㳎" "㳒" "㴜" "㵷" "㺹" "㻞" "䁵" "䉸" "䒪" "䛒" "䡢" "䪻" "匥" "変" "徧" "惼" "抃" "揙" "昪" "汳" "牑" "猵" "獱" "玣" "甂" "稨" "箯" "籩" "糄" "編" "緶" "艑" "萹" "藊" "覍" "變" "貶" "辡" "辧" "辮" "辯" "辺" "邉" "邊" "釆" "鍽" "閞" "鯾" "鯿" "鴘"))
  ((("b" "i" "a" "o")) ("表" "标" "苞" "彪" "膘" "漂" "剽" "婊" "嫖" "骠" "杓" "飑" "飙" "飚" "焱" "灬" "镖" "镳" "瘭" "裱" "鳔" "髟" "鏖" "㟽" "㠒" "㧼" "㯱" "㯹" "䔸" "䞄" "俵" "儦" "墂" "幖" "徱" "摽" "標" "檦" "滮" "瀌" "熛" "爂" "猋" "磦" "穮" "脿" "臕" "蔈" "藨" "褾" "覅" "諘" "謤" "贆" "錶" "鏢" "鑣" "颩" "颮" "飆" "飇" "飈" "飍" "驃" "驫" "骉" "鰾" "麃" "麅"))
  ((("b" "i" "e")) ("别" "憋" "瘪" "鳖" "秘" "蹩" "㓖" "㜩" "㢼" "㱸" "㲢" "㿜" "䇷" "䉲" "䋢" "䏟" "䠥" "䭱" "別" "彆" "徶" "癟" "莂" "虌" "蛂" "蟞" "襒" "鱉" "鷩" "鼈" "龞" "𢠳" "𤺓"))
  ((("b" "i" "n")) ("滨" "宾" "彬" "斌" "濒" "摈" "份" "频" "傧" "禀" "豳" "浜" "缤" "玢" "槟" "殡" "膑" "镔" "髌" "鬓" "䐔" "䳁" "儐" "擯" "攽" "梹" "椕" "檳" "殯" "汃" "濱" "瀕" "獱" "瑸" "璸" "矉" "繽" "臏" "蠙" "豩" "賓" "賔" "邠" "鑌" "霦" "頻" "顮" "馪" "驞" "髕" "髩" "鬂" "鬢"))
  ((("b" "i" "n" "g")) ("并" "病" "兵" "冰" "饼" "丙" "柄" "迸" "秉" "炳" "屏" "禀" "冫" "邴" "摒" "廪" "枋" "槟" "燹" "㓈" "㨀" "䈂" "䋑" "䓑" "䗒" "䴵" "並" "仌" "併" "倂" "偋" "傡" "寎" "屛" "幷" "怲" "抦" "掤" "昞" "昺" "栟" "栤" "梹" "棅" "檳" "氷" "琕" "癛" "癝" "眪" "稟" "窉" "竝" "絣" "綆" "苪" "蛃" "鈵" "鉼" "陃" "靐" "鞞" "餅" "餠" "鮩" "鵧" "𠊧"))
  ((("b" "o")) ("玻" "剥" "播" "伯" "博" "波" "脖" "拨" "勃" "膊" "薄" "搏" "驳" "卜" "簸" "舶" "泊" "跛" "白" "柏" "百" "佰" "般" "雹" "暴" "爆" "菠" "钵" "铂" "箔" "帛" "渤" "簿" "发" "番" "拍" "潘" "跑" "泼" "魄" "菩" "蒲" "瀑" "孛" "亳" "荸" "菔" "蕃" "薜" "蘖" "啵" "饽" "悖" "泺" "溥" "艴" "檗" "掰" "擘" "礴" "钹" "鹁" "趵" "踣" "鲅" "㑟" "㔜" "㖕" "㗘" "㙸" "㝿" "㟑" "㧳" "㩧" "㩭" "㪍" "㬍" "㬧" "㱟" "㴾" "㶿" "㹀" "㼎" "㼣" "䂍" "䊿" "䍨" "䍸" "䑈" "䒄" "䗚" "䙏" "䞳" "䟆" "䟛" "䟦" "䢌" "䢪" "䥬" "䨌" "䪇" "䪬" "䫊" "䬪" "䭦" "䭯" "䮀" "䮂" "䯋" "䰊" "䰷" "䳁" "䵄" "䶈" "侼" "僰" "剝" "哱" "嚗" "坺" "墢" "壆" "孹" "嶏" "嶓" "彂" "愽" "懪" "挀" "挬" "撥" "敀" "曓" "柭" "栢" "桲" "欂" "浡" "潑" "濼" "煿" "牔" "犦" "犻" "猼" "瓝" "瓟" "疈" "癶" "發" "盋" "砵" "碆" "磻" "礴" "箥" "簙" "糪" "繴" "缽" "胉" "艊" "苩" "茀" "葧" "蔔" "蘗" "蚾" "袚" "袯" "襏" "襮" "誖" "謈" "譒" "豰" "踄" "蹳" "郣" "鈸" "鉑" "鉢" "鋍" "鎛" "鑮" "镈" "餑" "餺" "馎" "馞" "駁" "駊" "駮" "驋" "髆" "髉" "鮁" "鮊" "鱍" "鲌" "鵓"))
  ((("b" "u")) ("不" "部" "步" "布" "补" "捕" "怖" "哺" "埠" "薄" "堡" "卜" "簿" "附" "扑" "菩" "埔" "卩" "卟" "惚" "溥" "逋" "瓿" "晡" "钚" "钸" "醭" "鞴" "㘵" "㙛" "㚴" "㨐" "㳍" "㻉" "㾟" "䀯" "䊇" "䋠" "䍌" "䏽" "䑰" "䒈" "䝵" "䪁" "䪔" "䬏" "䳝" "䴝" "䴺" "佈" "吥" "咘" "埗" "峬" "庯" "悑" "捗" "擈" "歨" "歩" "篰" "纀" "荹" "蔀" "補" "誧" "轐" "郶" "鈈" "鈽" "餔" "餢" "鮬" "鳪" "鵏"))
  ((("c" "a")) ("擦" "蔡" "拆" "嚓" "礤" "䟃" "䵽" "囃" "磣"))
  ((("c" "a" "i")) ("才" "材" "采" "菜" "财" "彩" "猜" "踩" "裁" "睬" "蔡" "㒲" "㥒" "䌨" "䌽" "䐆" "䣋" "䰂" "䴭" "䴺" "倸" "埰" "婇" "寀" "採" "棌" "溨" "犲" "綵" "縩" "纔" "財" "跐" "跴" "釆"))
  ((("c" "a" "n")) ("参" "残" "蚕" "惨" "餐" "灿" "惭" "掺" "孱" "骖" "璨" "昝" "粲" "黪" "㘔" "㛑" "㜗" "㣓" "㥇" "㦧" "㨻" "㱚" "㺑" "㻮" "㽩" "㿊" "䅟" "䍼" "䏼" "䑶" "䗝" "䗞" "䘉" "䙁" "䛹" "䝳" "䣟" "䫮" "䬫" "䳻" "傪" "參" "叄" "叅" "喰" "嬠" "嬱" "慘" "慙" "慚" "憯" "摻" "朁" "殘" "淺" "湌" "澯" "燦" "穇" "蓡" "薒" "蝅" "蠶" "蠺" "謲" "飡" "驂" "鰺" "黲"))
  ((("c" "a" "n" "g")) ("藏" "舱" "苍" "仓" "沧" "伧" "臧" "㵴" "㶓" "䅮" "䢢" "仺" "倉" "傖" "凔" "匨" "嵢" "滄" "獊" "艙" "蒼" "蔵" "螥" "賶" "鑶" "鶬" "鸧"))
  ((("c" "a" "o")) ("草" "操" "槽" "糙" "嘈" "曹" "澡" "造" "漕" "屮" "螬" "艚" "㜖" "㯥" "㽩" "䄚" "䏆" "䐬" "䒃" "䒑" "傮" "嶆" "愺" "慅" "慥" "懆" "撡" "曺" "肏" "艸" "蓸" "褿" "襙" "鄵" "鏪" "騲"))
  ((("c" "e")) ("策" "测" "侧" "册" "厕" "赦" "栅" "恻" "㥽" "㨲" "㩍" "䇲" "䈟" "䊂" "䔴" "䜺" "側" "冊" "厠" "嫧" "廁" "惻" "憡" "拺" "敇" "柵" "測" "溭" "畟" "矠" "笧" "筞" "筴" "箣" "粣" "茦" "荝" "萗" "萴" "蓛" "遪" "頙"))
  ((("c" "e" "n")) ("参" "岑" "涔" "㞥" "㻸" "䃡" "䅾" "䤁" "䨙" "䯔" "䲋" "參" "叄" "叅" "埁" "嵾" "梣" "梫" "橬" "硶" "笒" "篸"))
  ((("c" "e" "n" "g")) ("层" "曾" "蹭" "噌" "缯" "㣒" "㬝" "䁬" "䉕" "層" "嶒" "曽" "碀" "竲" "繒" "鄫"))
  ((("c" "h" "a")) ("查" "察" "差" "茶" "插" "诧" "刹" "叉" "茬" "碴" "搽" "岔" "蜡" "喳" "苴" "荼" "搋" "吒" "咤" "嚓" "馇" "汊" "姹" "杈" "楂" "槎" "檫" "锸" "镲" "痄" "衩" "㛳" "㢉" "㢎" "㢒" "㣾" "㤞" "㪯" "㫅" "䁟" "䆛" "䊬" "䑘" "䒲" "䓭" "䕓" "䟕" "䡨" "䤩" "䰈" "䲦" "䶪" "侘" "偛" "剎" "嗏" "垞" "奼" "嫅" "嵖" "扠" "扱" "挿" "揷" "擑" "査" "疀" "秅" "紁" "肞" "臿" "艖" "荖" "訍" "詧" "詫" "蹅" "釵" "銟" "鍤" "鑔" "靫" "餷" "𦉆"))
  ((("c" "h" "a" "i")) ("柴" "拆" "差" "豺" "叉" "侪" "茈" "钗" "瘥" "虿" "㑪" "㳗" "㾹" "䓱" "䘍" "䡨" "儕" "喍" "囆" "犲" "祡" "芆" "茝" "蠆" "袃" "釵" "靫" "齜"))
  ((("c" "h" "a" "n")) ("产" "颤" "蝉" "缠" "铲" "搀" "阐" "馋" "掺" "谗" "单" "掸" "渐" "苫" "沾" "冁" "谄" "蒇" "廛" "忏" "潺" "澶" "孱" "羼" "婵" "骣" "觇" "禅" "蟾" "躔" "㔆" "㙴" "㙻" "㢆" "㢟" "㦃" "㬄" "㯆" "㵌" "㶣" "㸥" "㹌" "㹽" "㺥" "䀡" "䂁" "䊲" "䐮" "䑎" "䜛" "䠨" "䡪" "䡲" "䣑" "䤘" "䤫" "䥀" "䧯" "䩶" "䪜" "䱿" "䳻" "䴺" "䴼" "䵐" "丳" "僝" "儃" "儳" "刬" "剗" "剷" "劖" "啴" "單" "嘽" "嚵" "囅" "嬋" "嵼" "巉" "幝" "幨" "惉" "懴" "懺" "摌" "摻" "撣" "攙" "旵" "梴" "棎" "欃" "毚" "浐" "湹" "滻" "漸" "潹" "瀍" "瀺" "灛" "煘" "燀" "獑" "產" "産" "硟" "磛" "禪" "簅" "緾" "繟" "繵" "纏" "纒" "脠" "艬" "蕆" "螹" "蟬" "蟺" "袩" "裧" "襜" "襝" "覘" "誗" "諂" "譂" "讇" "讒" "讖" "辿" "鄽" "酁" "鉆" "鋋" "鋓" "鏟" "鑱" "镵" "閳" "闡" "韂" "顫" "饞" "驏" "𤮭"))
  ((("c" "h" "a" "n" "g")) ("常" "长" "场" "厂" "唱" "肠" "倡" "尝" "敞" "畅" "偿" "昌" "猖" "尚" "裳" "倘" "淌" "伥" "鬯" "苌" "菖" "徜" "怅" "惝" "阊" "娼" "嫦" "昶" "氅" "鲳" "㙊" "㦂" "㫤" "䕋" "䗅" "䠀" "䠆" "䩨" "䯴" "仧" "倀" "僘" "償" "兏" "厰" "嘗" "嚐" "場" "塲" "尙" "廠" "悵" "戃" "晿" "暢" "淐" "焻" "玚" "琩" "瑒" "瑺" "瓺" "甞" "畼" "脹" "腸" "膓" "萇" "裮" "誯" "鋹" "鋿" "錩" "鏛" "锠" "長" "镸" "閶" "闛" "韔" "鯧" "鱨" "鲿" "鷩" "鼚" "𢠵"))
  ((("c" "h" "a" "o")) ("朝" "超" "潮" "吵" "抄" "嘲" "巢" "钞" "炒" "绰" "剿" "怊" "晁" "焯" "耖" "㶤" "㷅" "䄻" "䎐" "䏚" "䬤" "䰫" "仦" "仯" "勦" "巐" "巣" "弨" "樔" "欩" "濤" "煼" "眧" "禉" "窲" "紹" "綽" "縐" "繛" "罺" "觘" "訬" "謅" "謿" "趠" "轈" "鄛" "鈔" "麨" "鼂" "鼌"))
  ((("c" "h" "e")) ("车" "彻" "撤" "扯" "拆" "掣" "澈" "池" "尺" "辙" "坼" "屮" "砗" "㔭" "㥉" "㨋" "㬚" "㯙" "㱌" "㵃" "㵔" "㾝" "㿭" "䁤" "䋲" "䑲" "䒆" "䚢" "䛸" "䜠" "䞣" "䤁" "䧪" "䨁" "䰩" "伡" "俥" "偖" "勶" "呫" "唓" "徹" "撦" "烲" "爡" "瞮" "硨" "硩" "聅" "莗" "蛼" "詀" "車" "轍" "迠"))
  ((("c" "h" "e" "n")) ("沉" "晨" "趁" "尘" "衬" "陈" "称" "臣" "忱" "郴" "辰" "橙" "秤" "闯" "沈" "湛" "疹" "伧" "谌" "谶" "抻" "嗔" "宸" "琛" "榇" "肜" "胂" "碜" "眈" "龀" "㕴" "㧱" "㫳" "㲀" "㴴" "㽸" "䆣" "䒞" "䗞" "䚘" "䜟" "䞋" "䟢" "䢅" "䢈" "䢻" "䣅" "䤟" "䫖" "儬" "儭" "嚫" "塵" "墋" "夦" "屒" "愖" "捵" "敐" "曟" "桭" "梣" "棽" "樄" "櫬" "瀋" "煁" "疢" "瞋" "硶" "磣" "祳" "稱" "綝" "縝" "茞" "莀" "莐" "蔯" "薼" "藽" "螴" "襯" "訦" "諃" "諶" "謓" "讖" "賝" "贂" "趂" "趻" "踸" "軙" "迧" "鈂" "鍖" "闖" "陳" "霃" "鷐" "麎" "齓" "齔"))
  ((("c" "h" "e" "n" "g")) ("成" "程" "城" "称" "承" "乘" "诚" "盛" "呈" "撑" "惩" "秤" "橙" "澄" "逞" "骋" "盯" "枪" "抢" "趟" "醒" "丞" "伧" "郢" "埕" "噌" "浈" "枨" "柽" "樘" "晟" "塍" "瞠" "铖" "铛" "裎" "蛏" "酲" "㐼" "㞼" "㨃" "㲂" "㼩" "䀕" "䁎" "䁤" "䄇" "䆑" "䆵" "䆸" "䇸" "䔲" "䗊" "䚘" "䞓" "䧕" "䫆" "䮪" "乗" "侱" "偁" "傖" "埥" "堘" "塖" "塣" "娍" "宬" "峸" "庱" "徎" "悜" "憆" "憕" "懲" "挰" "掁" "揨" "搶" "撐" "撜" "朾" "梬" "棖" "棦" "椉" "槍" "橕" "檉" "泟" "洆" "浾" "湞" "澂" "瀓" "爯" "牚" "珵" "珹" "琤" "睈" "稱" "穪" "窚" "竀" "筬" "絾" "緽" "脀" "脭" "荿" "虰" "蟶" "誠" "赪" "赬" "郕" "鋮" "鎗" "鏿" "鐺" "阷" "靗" "頳" "饓" "騁" "騬"))
  ((("c" "h" "i")) ("吃" "持" "尺" "迟" "翅" "齿" "池" "耻" "驰" "斥" "哧" "赤" "蚩" "茬" "痴" "匙" "弛" "侈" "炽" "哆" "离" "莉" "蛇" "移" "治" "傺" "郗" "坻" "墀" "芪" "茌" "搋" "叱" "啻" "嗤" "彳" "饬" "沱" "媸" "敕" "胝" "眙" "眵" "瘛" "褫" "螭" "笞" "篪" "豉" "踅" "踟" "魑" "㒆" "㓼" "㓾" "㔑" "㔭" "㘜" "㙜" "㞴" "㞿" "㟂" "㡿" "㢁" "㢋" "㢮" "㥉" "㮛" "㱀" "㳏" "㶴" "㽚" "䇼" "䈕" "䊼" "䐤" "䑛" "䔟" "䗖" "䙙" "䛂" "䜄" "䜵" "䜻" "䞾" "䟷" "䠠" "䤲" "䪧" "䮈" "䮻" "䰡" "䰩" "䳵" "䶔" "䶵" "乿" "佁" "侙" "倁" "勅" "勑" "叺" "呎" "呞" "喫" "嘨" "噄" "垑" "奓" "姼" "岻" "彨" "彲" "彽" "徥" "徲" "恀" "恜" "恥" "慗" "憏" "懘" "扡" "抶" "拸" "摛" "攡" "杘" "杝" "栻" "欫" "欼" "歭" "歯" "汦" "泜" "淔" "滯" "灻" "烾" "熾" "瓻" "痓" "痸" "瘈" "癡" "瞝" "祇" "竾" "筂" "箈" "箎" "粎" "糦" "紕" "絺" "翄" "翤" "翨" "耛" "胣" "胵" "荎" "蚇" "蚳" "袳" "裭" "觢" "訵" "誃" "誺" "謘" "謻" "貾" "赿" "趍" "趩" "跮" "踶" "迣" "遅" "遟" "遫" "遲" "鉓" "鉹" "銐" "鍉" "離" "飭" "飾" "饎" "馳" "驪" "骴" "鴟" "鵄" "鵣" "鶒" "鷘" "黐" "齒" "齝" "𤆍"))
  ((("c" "h" "o" "n" "g")) ("虫" "冲" "充" "重" "崇" "憧" "宠" "茧" "酮" "涌" "盅" "种" "桩" "茺" "忡" "潼" "铳" "舂" "艟" "㓼" "㓽" "㧤" "㹐" "䌬" "䖝" "䳯" "嘃" "埫" "寵" "崈" "徸" "憃" "揰" "摏" "樁" "橦" "沖" "浺" "漴" "爞" "珫" "痋" "種" "罿" "翀" "蝩" "蟲" "衝" "衶" "褈" "蹖" "銃" "隀" "𠖥" "𢥞" "𣀒" "𧘂"))
  ((("c" "h" "o" "u")) ("抽" "臭" "仇" "愁" "瞅" "丑" "踌" "绸" "酬" "稠" "畴" "筹" "搐" "俦" "帱" "惆" "焘" "瘳" "雠" "㐜" "㘜" "㛶" "㤽" "㦞" "㨶" "㵞" "㿧" "䇺" "䊭" "䌧" "䌷" "䓓" "䔏" "䛬" "䥒" "䪮" "䲖" "丒" "侴" "偢" "儔" "吜" "嚋" "婤" "嬦" "幬" "怞" "懤" "搊" "杻" "杽" "栦" "椆" "殠" "燽" "燾" "牰" "犨" "犫" "疇" "皗" "盩" "矁" "篘" "簉" "籌" "紬" "絒" "綢" "臰" "菗" "薵" "裯" "詶" "謅" "讎" "讐" "躊" "酧" "醜" "醻" "鈕" "雔" "霌" "魗" "鯈" "𢭆"))
  ((("c" "h" "u")) ("出" "处" "除" "初" "础" "楚" "触" "厨" "储" "躇" "锄" "畜" "矗" "橱" "雏" "滁" "搐" "硫" "淑" "絮" "著" "祝" "亍" "刍" "怵" "憷" "绌" "杵" "楮" "樗" "褚" "蜍" "蹰" "黜" "㔘" "㕏" "㕑" "㗰" "㘜" "㙇" "㜗" "㡡" "㤕" "㤘" "㶆" "㹼" "㼥" "䅳" "䊰" "䎝" "䎤" "䖏" "䙕" "䙘" "䜴" "䟞" "䟣" "䠂" "䠧" "䦌" "䧁" "䮞" "俶" "傗" "儊" "儲" "処" "岀" "幮" "廚" "拀" "敊" "斣" "斶" "曯" "椘" "槒" "檚" "櫉" "櫥" "欪" "歜" "泏" "滀" "濋" "犓" "琡" "礎" "禇" "竌" "竐" "篨" "絀" "耝" "耡" "臅" "芻" "荲" "蒢" "蒭" "蕏" "藸" "處" "觸" "詘" "諸" "豖" "貙" "趎" "踀" "躕" "遚" "鄐" "鉏" "鋤" "閦" "雛" "鶵" "麆" "齣" "齭" "齼" "𦷝"))
  ((("c" "h" "u" "a")) ("䏆" "䫄" "欻" "歘"))
  ((("c" "h" "u" "a" "i")) ("揣" "搋" "啜" "嘬" "踹" "蹉" "㪓" "㪜" "㱀" "䦟" "䦤" "䦷" "䴝" "腄" "膗"))
  ((("c" "h" "u" "a" "n")) ("船" "传" "穿" "串" "喘" "川" "椽" "舛" "遄" "巛" "氚" "钏" "舡" "㯌" "㱛" "㼷" "䁣" "伝" "傳" "僢" "圌" "堾" "暷" "歂" "汌" "玔" "瑏" "篅" "腨" "舩" "荈" "諯" "賗" "輲" "釧"))
  ((("c" "h" "u" "a" "n" "g")) ("创" "床" "窗" "闯" "疮" "幢" "葱" "囱" "撞" "怆" "疒" "舂" "㡖" "㵂" "䃥" "䆫" "䇬" "䎫" "䚒" "䡴" "䭚" "刅" "刱" "剏" "剙" "創" "噇" "囪" "愴" "戧" "摐" "摤" "橦" "漺" "牀" "牎" "牕" "獊" "瘡" "磢" "窓" "窻" "闖"))
  ((("c" "h" "u" "i")) ("吹" "垂" "捶" "锤" "炊" "椎" "陲" "棰" "槌" "㓃" "㝽" "㥨" "㩾" "䄲" "䍋" "䕓" "䞼" "䳠" "倕" "圌" "埀" "搥" "桘" "湷" "箠" "篅" "腄" "菙" "郵" "錘" "鎚" "顀" "魋" "龡"))
  ((("c" "h" "u" "n")) ("春" "纯" "唇" "鹑" "淳" "椿" "醇" "蠢" "莼" "沌" "肫" "㖺" "㝄" "㝇" "㵮" "㸪" "㿤" "䄝" "䏛" "䏝" "䐇" "䐏" "䓐" "䔚" "䞐" "䣨" "䣩" "䥎" "䦮" "䫃" "䮞" "偆" "堾" "媋" "惷" "憌" "旾" "暙" "杶" "橁" "櫄" "浱" "湻" "滣" "漘" "睶" "箺" "純" "脣" "膞" "膥" "芚" "萅" "萶" "蒓" "蓴" "踳" "輇" "輴" "醕" "錞" "陙" "鯙" "鰆" "鶉" "鶞"))
  ((("c" "h" "u" "o")) ("躇" "戳" "绰" "簇" "淖" "醛" "缀" "荃" "蔟" "啜" "辶" "辍" "焯" "踔" "踱" "龊" "㚟" "㲋" "䂐" "䃗" "䄪" "䆯" "䇍" "䋘" "䍳" "䓎" "䮕" "嚽" "娖" "婥" "婼" "惙" "擉" "歠" "涰" "犳" "珿" "畷" "磭" "綴" "綽" "繛" "腏" "諁" "趠" "輟" "辵" "逴" "酫" "醊" "鎈" "鏃" "鑡" "齪" "齱" "齹"))
  ((("c" "i")) ("次" "此" "刺" "磁" "词" "瓷" "伺" "辞" "雌" "慈" "差" "疵" "茨" "赐" "兹" "滋" "茈" "呲" "嵯" "祠" "恣" "鹚" "蚝" "螅" "粢" "糍" "趑" "訾" "㓨" "㘂" "㘹" "㞖" "㠿" "㡹" "㢀" "㤵" "㩞" "㹂" "䂣" "䆅" "䈘" "䓧" "䖪" "䗹" "䛐" "䦻" "䧳" "䨏" "䭣" "䯸" "䰍" "䲿" "䳄" "䳐" "佌" "佽" "偨" "刾" "垐" "嬨" "嵳" "庛" "朿" "柌" "泚" "濨" "玆" "玼" "珁" "甆" "皉" "礠" "秶" "紪" "絘" "茊" "茲" "莿" "薋" "薺" "蛓" "螆" "蠀" "詞" "賜" "赼" "趀" "跐" "辝" "辤" "辭" "郪" "飺" "餈" "骴" "髊" "鶿" "鷀"))
  ((("c" "o" "n" "g")) ("从" "匆" "聪" "丛" "囱" "葱" "窗" "苁" "淙" "骢" "琮" "璁" "枞" "㗰" "㼻" "䆫" "䉘" "䕺" "䳷" "叢" "囪" "婃" "孮" "従" "徖" "從" "忩" "怱" "悤" "悰" "慒" "憁" "暰" "棇" "樅" "樬" "樷" "欉" "漎" "漗" "潀" "灇" "焧" "燪" "爜" "牎" "牕" "瑽" "瞛" "窓" "窼" "篵" "緫" "縦" "縱" "繱" "聡" "聦" "聰" "蓯" "蔥" "藂" "蟌" "誴" "謥" "賨" "賩" "錝" "鍐" "鍯" "鏓" "鏦" "騘" "驄"))
  ((("c" "o" "u")) ("凑" "簇" "趣" "揍" "族" "蔟" "楱" "辏" "腠" "㫶" "傶" "湊" "藪" "趨" "輳"))
  ((("c" "u")) ("粗" "促" "醋" "簇" "错" "趋" "趣" "数" "卒" "蔟" "徂" "猝" "槭" "殂" "酢" "蹙" "蹴" "㗤" "㤘" "㰗" "䃚" "䎌" "䓚" "䙯" "䛤" "䟟" "䠓" "䠞" "䢐" "䥄" "䥘" "䬨" "噈" "塶" "憱" "數" "梀" "殧" "瘄" "瘯" "皶" "縐" "縬" "脨" "觕" "豠" "趗" "趨" "踧" "蹵" "錯" "顣" "麁" "麄" "麤" "鼀"))
  ((("c" "u" "a" "n")) ("窜" "蹿" "篡" "蹲" "攒" "汆" "撺" "爨" "镩" "㠝" "㭫" "㵀" "㸑" "䆘" "䞼" "䰖" "劗" "巑" "攛" "攢" "櫕" "殩" "濽" "熶" "竄" "簒" "躥" "鋑" "鑹"))
  ((("c" "u" "i")) ("脆" "摧" "催" "粹" "崔" "瘁" "淬" "翠" "橇" "洒" "衰" "萃" "啐" "悴" "璀" "榱" "毳" "隹" "㝮" "㥞" "㧘" "㯔" "㯜" "㱖" "㳃" "㵏" "㷃" "㷪" "䂱" "䃀" "䄟" "䆊" "䊫" "䔴" "䢪" "䧽" "伜" "倅" "凗" "啛" "嗺" "墔" "崒" "崪" "忰" "慛" "槯" "漼" "焠" "獕" "琗" "疩" "皠" "磪" "竁" "竴" "粋" "紣" "綷" "縗" "缞" "翆" "脃" "脺" "膬" "膵" "臎" "趡" "踤" "鏙" "顇"))
  ((("c" "u" "n")) ("村" "存" "寸" "蹲" "浚" "忖" "皴" "䍎" "刌" "吋" "墫" "壿" "拵" "澊" "籿" "袸" "踆" "邨"))
  ((("c" "u" "o")) ("错" "措" "挫" "搓" "摧" "磋" "撮" "昔" "厝" "嵯" "脞" "锉" "矬" "痤" "瘥" "鹾" "蹉" "㟇" "㭫" "㽨" "䂳" "䐣" "䐤" "䑘" "䟶" "䠡" "䣜" "䥘" "䰈" "䱜" "䴾" "侳" "剉" "剒" "嵳" "歵" "營" "瑳" "睉" "縒" "莝" "莡" "蒫" "蓌" "蔖" "虘" "躦" "逪" "遳" "鄼" "醝" "銼" "錯" "鹺" "齚" "齰"))
  ((("d" "a")) ("大" "打" "达" "答" "搭" "瘩" "耷" "胆" "哒" "嗒" "怛" "妲" "沓" "疸" "褡" "笪" "靼" "鞑" "㙮" "㜓" "㟷" "㯚" "㾑" "㿯" "䃮" "䐊" "䑽" "䩢" "䳴" "䵣" "劄" "匒" "呾" "噠" "墶" "搨" "撘" "汏" "溚" "炟" "畗" "畣" "眔" "箚" "繨" "羍" "荅" "荙" "薘" "蟽" "褟" "觰" "詚" "跶" "躂" "迖" "逹" "達" "酂" "酇" "鎝" "鐽" "韃"))
  ((("d" "a" "i")) ("代" "带" "待" "袋" "大" "戴" "呆" "逮" "歹" "傣" "殆" "贷" "怠" "递" "毒" "隶" "埭" "甙" "呔" "岱" "迨" "逯" "骀" "绐" "玳" "棣" "黛" "㐲" "㞭" "㫹" "㯂" "㶡" "㻖" "㿃" "䈆" "䒫" "䚞" "䚟" "䲦" "叇" "嘚" "帒" "帯" "帶" "廗" "懛" "曃" "柋" "歺" "汏" "瀻" "獃" "瑇" "箈" "簤" "紿" "緿" "艜" "蝳" "襶" "詒" "貸" "跢" "蹛" "軑" "軚" "軩" "載" "轪" "遝" "遞" "釱" "霴" "靆" "馱" "駘" "騃" "黱" "𦄂"))
  ((("d" "a" "n")) ("但" "单" "弹" "担" "蛋" "淡" "胆" "诞" "旦" "耽" "丹" "氮" "郸" "掸" "惮" "赡" "石" "潭" "蜒" "詹" "湛" "儋" "萏" "啖" "澹" "澶" "檐" "殚" "赕" "膻" "眈" "钽" "疸" "瘅" "聃" "箪" "㔊" "㕪" "㗖" "㡺" "㫜" "㱽" "㲷" "㵅" "㺗" "㽎" "䃫" "䄷" "䉞" "䉷" "䨢" "䨵" "䩥" "䭛" "䮰" "䱋" "䳉" "亶" "伔" "僤" "刐" "勯" "匰" "単" "唌" "啗" "啿" "單" "噉" "噡" "嚪" "妉" "媅" "帎" "弾" "彈" "惔" "憚" "憺" "撢" "撣" "擔" "暺" "柦" "殫" "沊" "潬" "澸" "燀" "狚" "玬" "瓭" "甔" "疍" "癉" "癚" "砃" "禫" "窞" "簞" "紞" "耼" "聸" "腅" "膽" "舕" "蜑" "蟺" "衴" "襌" "覘" "觛" "訑" "誕" "贉" "贍" "躭" "鄲" "酖" "鉭" "霮" "頕" "餤" "饏" "馾" "駳" "髧" "鴠" "黕" "黮" "黵"))
  ((("d" "a" "n" "g")) ("党" "当" "挡" "荡" "档" "铛" "谠" "凼" "菪" "宕" "砀" "裆" "䑗" "䣊" "䣣" "䦒" "偒" "儅" "噹" "圵" "垱" "壋" "婸" "嵣" "愓" "擋" "攩" "檔" "欓" "氹" "潒" "澢" "灙" "燙" "玚" "珰" "瑒" "璗" "璫" "瓽" "當" "瘍" "盪" "瞊" "碭" "礑" "筜" "簜" "簹" "艡" "蕩" "蘯" "蟷" "襠" "譡" "讜" "趤" "逿" "鐺" "闣" "雼" "黨"))
  ((("d" "a" "o")) ("到" "道" "导" "倒" "刀" "岛" "稻" "盗" "捣" "悼" "蹈" "祷" "陶" "刂" "叨" "帱" "忉" "洮" "氘" "纛" "㔑" "㠀" "㨶" "㿒" "䆃" "䊭" "䌦" "䣣" "䧂" "䮻" "䲽" "噵" "壔" "導" "島" "嶋" "嶌" "嶹" "幍" "幬" "捯" "搗" "擣" "朷" "梼" "檤" "檮" "濤" "燾" "瓙" "盜" "禂" "禱" "稲" "翿" "舠" "菿" "衜" "衟" "裯" "軇" "釖" "隝" "隯" "魛" "鱽" "鳥"))
  ((("d" "e")) ("的" "地" "得" "德" "登" "底" "陟" "锝" "㝵" "㝶" "㤫" "㥀" "㥁" "㯖" "䙷" "䙸" "嘚" "墬" "徳" "恴" "惪" "淂" "鍀"))
  ((("d" "e" "i")) ("得" "䮻" "哋"))
  ((("d" "e" "n")) ("参" "參" "扽"))
  ((("d" "e" "n" "g")) ("等" "灯" "登" "凳" "瞪" "蹬" "橙" "澄" "邓" "噔" "嶝" "戥" "磴" "眙" "镫" "簦" "䒭" "䠬" "䮴" "僜" "墱" "嬁" "𣎳" "櫈" "燈" "璒" "竳" "覴" "豋" "鄧" "鐙" "隥" "霯"))
  ((("d" "i")) ("地" "第" "敌" "底" "低" "帝" "弟" "的" "抵" "滴" "递" "堤" "涤" "嘀" "缔" "笛" "逮" "迪" "狄" "翟" "嫡" "蒂" "隶" "芍" "提" "题" "蹄" "逐" "氐" "籴" "诋" "谛" "邸" "坻" "莜" "荻" "娣" "柢" "棣" "觌" "胝" "砥" "碲" "睇" "镝" "羝" "骶" "㡳" "㢩" "㣙" "㦅" "㪆" "㭽" "㰅" "㹍" "㼵" "䀸" "䀿" "䂡" "䊮" "䍕" "䏑" "䑭" "䑯" "䗖" "䞶" "䟡" "䢑" "䣌" "䧝" "䨀" "䨢" "䨤" "䩘" "䩚" "䮤" "䯼" "䱃" "䱱" "䲦" "䴞" "䵠" "䶍" "仢" "仾" "偙" "僀" "呧" "哋" "唙" "啇" "啲" "嚁" "坔" "坘" "埅" "埊" "埞" "墆" "墑" "墬" "奃" "媞" "嵽" "嶳" "廸" "弤" "怟" "慸" "拞" "掋" "揥" "摕" "敵" "旳" "杕" "梊" "梑" "楴" "樀" "泜" "浟" "渧" "滌" "滺" "潪" "焍" "牴" "玓" "珶" "甋" "疐" "眡" "磾" "祶" "禘" "篴" "籊" "糴" "約" "締" "聜" "肑" "腣" "苐" "苖" "茋" "菂" "菧" "蔋" "蔐" "蔕" "藋" "藡" "虳" "蝃" "螮" "袛" "覿" "觝" "詆" "諦" "豴" "赿" "趆" "踧" "踶" "蹏" "蹢" "軑" "軧" "轪" "逓" "遞" "適" "遰" "釱" "鉪" "鍉" "鏑" "阺" "隄" "靮" "鞮" "頔" "題" "馰" "髢" "鬄" "鸐"))
  ((("d" "i" "a")) ("嗲"))
  ((("d" "i" "a" "n")) ("点" "电" "店" "典" "颠" "殿" "淀" "甸" "奠" "垫" "佃" "惦" "踮" "掂" "滇" "碘" "靛" "拈" "涎" "沾" "阽" "坫" "巅" "玷" "钿" "癜" "癫" "蜓" "簟" "㓠" "㚲" "㝪" "㞟" "㥆" "㵤" "㶘" "㸃" "㼭" "䍄" "䓦" "䟍" "䧃" "䩚" "傎" "厧" "嚸" "墊" "壂" "奌" "婝" "婰" "嵮" "巓" "巔" "扂" "攧" "敁" "敟" "槇" "槙" "橂" "澱" "琔" "琠" "痁" "痶" "瘨" "癲" "磹" "蒧" "蕇" "蜔" "蹎" "鈿" "電" "顚" "顛" "驔" "點" "齻"))
  ((("d" "i" "a" "o")) ("掉" "调" "钓" "吊" "雕" "叼" "稠" "碉" "凋" "刁" "敦" "鸟" "跳" "莜" "钌" "铞" "铫" "蜩" "踔" "貂" "鲷" "㒛" "㪕" "㹿" "䂪" "䂽" "䄪" "䄷" "䉆" "䔙" "䠼" "䳝" "䵲" "伄" "奝" "屌" "弔" "彫" "扚" "殦" "汈" "琱" "瘹" "盄" "瞗" "矵" "窎" "窵" "竨" "綢" "蓧" "藋" "虭" "蛁" "訋" "誂" "調" "趙" "軺" "釕" "釣" "銚" "銱" "鋽" "錭" "鑃" "魡" "鮉" "鯛" "鳥" "鳭" "鵰" "鼦" "𨍳"))
  ((("d" "i" "e")) ("爹" "跌" "叠" "蝶" "碟" "迭" "谍" "涉" "踢" "至" "窒" "佚" "垤" "堞" "揲" "喋" "渫" "轶" "牒" "瓞" "褶" "耋" "蹀" "鲽" "鳎" "㑙" "㥈" "㦶" "㩸" "㩹" "㫼" "㬪" "㭯" "㲲" "㲳" "㷸" "㻡" "䏲" "䘭" "䞇" "䞕" "䠟" "䪥" "䮢" "䲀" "䳀" "䳻" "䴑" "咥" "啑" "墆" "峌" "嵽" "恎" "惵" "戜" "挕" "攧" "昳" "曡" "柣" "楪" "殜" "氎" "渉" "牃" "畳" "疉" "疊" "眣" "眰" "絰" "绖" "耊" "聑" "胅" "臷" "艓" "苵" "蜨" "螲" "褋" "褺" "褻" "詄" "諜" "趃" "跕" "跮" "軼" "鐵" "镻" "鰈" "鰨" "𢶣"))
  ((("d" "i" "n" "g")) ("定" "顶" "订" "盯" "钉" "叮" "丁" "锭" "鼎" "汀" "仃" "葶" "啶" "玎" "腚" "碇" "町" "铤" "疔" "耵" "酊" "㝎" "㝪" "㫀" "㴿" "㼗" "奵" "娗" "婈" "嵿" "帄" "庰" "忊" "椗" "檙" "濎" "矴" "碠" "磸" "艼" "薡" "訂" "釘" "鋌" "錠" "鐤" "靪" "頂" "顁" "飣" "饤" "鼑" "𩠑" "𪔂"))
  ((("d" "i" "u")) ("丢" "铥" "丟" "銩" "颩"))
  ((("d" "o" "n" "g")) ("动" "东" "懂" "冬" "洞" "冻" "董" "栋" "侗" "恫" "酮" "筒" "垌" "咚" "岽" "峒" "氡" "胨" "胴" "硐" "甬" "鸫" "㑈" "㓊" "㖦" "㗢" "㜱" "㢥" "㨂" "㼯" "䂢" "䅍" "䍶" "䞒" "䵔" "倲" "働" "凍" "動" "埬" "墥" "娻" "嬞" "峝" "崠" "崬" "戙" "挏" "昸" "東" "棟" "氭" "涷" "湩" "眮" "笗" "筩" "箽" "腖" "苳" "菄" "蕫" "蝀" "衕" "諌" "霘" "駧" "鯟" "鶇" "鼕"))
  ((("d" "o" "u")) ("都" "斗" "豆" "抖" "逗" "兜" "陡" "蚪" "痘" "读" "逾" "蔸" "渎" "窦" "窬" "篼" "㛒" "㞳" "㢄" "㨮" "㪷" "㷆" "䄈" "䇺" "䕆" "䕱" "䛠" "䬦" "兠" "吺" "唗" "唞" "敨" "枓" "枡" "梪" "橷" "毭" "浢" "瀆" "竇" "脰" "荳" "讀" "郖" "鋀" "閗" "闘" "阧" "餖" "饾" "鬥" "鬦" "鬪" "鬬" "鬭" "都"))
  ((("d" "u")) ("度" "读" "独" "毒" "渡" "肚" "都" "堵" "督" "镀" "杜" "赌" "犊" "睹" "妒" "顿" "芏" "嘟" "渎" "椟" "橐" "牍" "碡" "蠹" "竺" "笃" "纛" "髑" "黩" "㓃" "㱩" "㸿" "㹍" "㾄" "䀾" "䄍" "䅊" "䈞" "䐗" "䓯" "䙱" "䟻" "䢱" "䪅" "䫳" "䮷" "䲧" "儥" "凟" "匵" "厾" "喥" "妬" "嬻" "帾" "斁" "暏" "櫝" "殬" "殰" "涜" "瀆" "牘" "犢" "獨" "琽" "瓄" "皾" "秺" "竇" "篤" "簬" "簵" "荰" "蝳" "螙" "蠧" "裻" "襡" "覩" "詫" "読" "讀" "讟" "豄" "賭" "贕" "醏" "錖" "鍍" "鍺" "鑟" "閬" "闍" "阇" "陼" "靯" "韇" "韣" "韥" "頓" "騳" "黷" "都"))
  ((("d" "u" "a" "n")) ("断" "段" "短" "端" "锻" "缎" "椴" "煅" "簖" "踹" "㫁" "㱭" "䠪" "偳" "剬" "塅" "媏" "斷" "毈" "瑖" "碫" "籪" "緞" "耑" "腶" "葮" "褍" "躖" "鍛" "鍴"))
  ((("d" "u" "i")) ("对" "队" "堆" "兑" "敦" "锐" "追" "槌" "怼" "憝" "碓" "镦" "㙂" "㟋" "㠚" "㨃" "㬣" "㳔" "㵽" "䇏" "䇤" "䔪" "䨴" "䨺" "䬈" "䬽" "䯟" "兊" "兌" "垖" "塠" "対" "對" "嵟" "憞" "懟" "桘" "濧" "濻" "瀩" "痽" "磓" "祋" "綐" "薱" "譈" "轛" "銳" "鋭" "錞" "鐓" "鐜" "陮" "隊" "頧" "𠂤"))
  ((("d" "u" "n")) ("盾" "顿" "吨" "蹲" "墩" "敦" "囤" "钝" "遁" "沌" "豚" "炖" "砘" "礅" "盹" "趸" "㬿" "䤜" "伅" "噸" "墪" "崸" "庉" "弴" "惇" "扽" "撉" "撴" "潡" "燉" "犜" "腞" "蜳" "踲" "蹾" "躉" "逇" "遯" "鈍" "鐓" "頓" "驐" "鶨" "𣎴"))
  ((("d" "u" "o")) ("多" "夺" "躲" "朵" "踱" "哆" "跺" "度" "掇" "垛" "舵" "剁" "惰" "堕" "隋" "陀" "驮" "泽" "锗" "咄" "哚" "沲" "沱" "缍" "柁" "棰" "铎" "裰" "㔍" "㖼" "㙐" "㛆" "㛊" "㣞" "㥩" "㧷" "㻔" "㻧" "䁟" "䄍" "䅜" "䍴" "䐾" "䑨" "䒳" "䙃" "䙟" "䙤" "䠤" "䤪" "䤻" "䩔" "䩣" "䫂" "䯬" "亸" "凙" "刴" "剟" "剫" "嚉" "嚲" "垜" "埵" "墮" "墯" "夛" "奪" "奲" "媠" "尮" "崜" "嶞" "徳" "悳" "憜" "挅" "挆" "敓" "敚" "敠" "敪" "朶" "杕" "柂" "柮" "桗" "椯" "橢" "毲" "澤" "炧" "炨" "痑" "痥" "綞" "茤" "莌" "袳" "襗" "趓" "跥" "躱" "軃" "鄲" "鈬" "錞" "鍺" "鐸" "陊" "陏" "飿" "饳" "馱" "鬌" "鮵" "鵽" "點" "𢜬" "𥞛"))
  ((("e")) ("略" "饿" "恶" "额" "哦" "掠" "鹅" "呃" "愕" "鳄" "峨" "俄" "蛾" "阿" "隘" "胺" "歹" "讹" "娥" "厄" "扼" "遏" "鄂" "蛤" "哑" "邑" "鬲" "噩" "谔" "垩" "苊" "莪" "萼" "猗" "阏" "屙" "婀" "轭" "腭" "硪" "钶" "锇" "锷" "鹗" "疴" "颚" "㓵" "㔩" "㕎" "㖾" "㗁" "㗉" "㟧" "㠋" "㡋" "㦍" "㧖" "㩵" "㮙" "㱦" "㷈" "㼂" "㼢" "㼰" "䄉" "䆓" "䑥" "䑪" "䓊" "䔾" "䕏" "䖸" "䙳" "䛖" "䝈" "䞩" "䣞" "䩹" "䫷" "䱮" "䳗" "䳘" "䳬" "偔" "僫" "儑" "卾" "吪" "呝" "咢" "咹" "啞" "噁" "囮" "圔" "堊" "堨" "堮" "妸" "妿" "娿" "婐" "岋" "峉" "峩" "崿" "嶭" "悪" "惡" "戹" "搤" "搹" "枙" "櫮" "涐" "湂" "玀" "珴" "琧" "痾" "皒" "睋" "砐" "硆" "磀" "蕚" "蘁" "蚅" "蝁" "覨" "訛" "詻" "誐" "誒" "諤" "譌" "讍" "豟" "貖" "軛" "軶" "迗" "遌" "遻" "鈋" "鈳" "鋨" "鍔" "鑩" "閼" "阨" "阸" "隲" "頞" "頟" "額" "顎" "餓" "餩" "騀" "魤" "魥" "鰐" "鱷" "鵝" "鵞" "鶚" "齃" "齶"))
  ((("e" "i")) ("诶" "欸" "誒"))
  ((("e" "n")) ("恩" "蒽" "摁" "䅰" "䊐" "䬶" "䭓" "䭡" "奀" "煾"))
  ((("e" "n" "g")) ("鞥"))
  ((("e" "r")) ("而" "二" "儿" "耳" "尔" "饵" "洱" "贰" "佴" "濡" "迩" "珥" "铒" "鸸" "鲕" "㒃" "㖇" "㚷" "㛅" "㜨" "㢽" "㧫" "㮕" "䋙" "䋩" "䌺" "䎟" "䎠" "䎶" "䏪" "䣵" "䮘" "侕" "儞" "児" "兒" "刵" "咡" "唲" "尒" "尓" "峏" "弍" "弐" "栭" "栮" "樲" "檽" "毦" "洏" "渳" "爾" "眲" "耏" "聏" "胹" "腝" "臑" "荋" "薾" "衈" "袻" "誀" "貮" "貳" "輀" "轜" "邇" "鉺" "陑" "隭" "餌" "駬" "髵" "鮞" "鴯"))
  ((("f" "a")) ("发" "法" "乏" "伐" "阀" "罚" "拨" "筏" "珐" "泛" "垡" "砝" "㕹" "㘺" "㛲" "㳒" "䂲" "䇅" "䒥" "䣹" "佱" "傠" "姂" "彂" "撥" "栰" "橃" "沷" "灋" "琺" "疺" "発" "發" "瞂" "罰" "罸" "茷" "蕟" "藅" "閥" "髪" "髮"))
  ((("f" "a" "n")) ("反" "饭" "翻" "犯" "范" "泛" "凡" "繁" "番" "烦" "返" "帆" "贩" "藩" "樊" "矾" "钒" "潘" "蕃" "蘩" "拚" "幡" "梵" "燔" "畈" "袢" "蟠" "蹯" "㕨" "㝃" "㠶" "㤆" "㳎" "㴀" "㶗" "㸋" "㺕" "㼝" "㽹" "㾱" "䀀" "䀟" "䉊" "䉒" "䊩" "䋣" "䋦" "䌓" "䐪" "䒠" "䒦" "䕰" "䛀" "䡊" "䣲" "䪛" "䪤" "䫶" "䭵" "䮳" "仮" "僠" "凢" "凣" "勫" "噃" "墦" "奿" "嬎" "嬏" "忛" "憣" "旙" "旛" "杋" "柉" "棥" "橎" "氾" "汎" "滼" "瀪" "瀿" "煩" "犿" "璠" "瓪" "畨" "盕" "礬" "笲" "笵" "範" "籓" "籵" "緐" "繙" "羳" "膰" "舧" "薠" "蠜" "襎" "觙" "訉" "販" "軓" "軡" "軬" "轓" "鄤" "釩" "鐇" "颿" "飜" "飯" "飰" "魬" "鱕" "鷭" "飯"))
  ((("f" "a" "n" "g")) ("方" "放" "房" "防" "仿" "纺" "访" "妨" "坊" "肪" "芳" "匚" "邡" "彷" "枋" "钫" "舫" "鲂" "㑂" "㕫" "㤃" "㧍" "㯐" "䉊" "䢍" "䦈" "䲱" "倣" "埅" "旊" "昉" "昘" "汸" "淓" "牥" "瓬" "眆" "紡" "蚄" "訪" "趽" "鈁" "髣" "魴" "鰟" "鳑" "鴋" "鶭"))
  ((("f" "e")) ("䒈"))
  ((("f" "e" "i")) ("飞" "非" "费" "肥" "匪" "废" "肺" "沸" "啡" "菲" "诽" "吠" "裴" "芾" "狒" "悱" "淝" "妃" "绯" "榧" "贲" "腓" "斐" "扉" "祓" "砩" "镄" "痱" "蜚" "篚" "翡" "霏" "鲱" "㓈" "㔗" "㥱" "㩌" "㭭" "㵒" "㸬" "㹃" "㾱" "䀟" "䆏" "䈈" "䉬" "䍨" "䑔" "䒈" "䕁" "䕠" "䚨" "䛍" "䞳" "䠊" "䤵" "䨽" "䨾" "䰁" "俷" "剕" "厞" "墢" "奜" "婓" "屝" "廃" "廢" "昲" "曊" "朏" "杮" "棐" "櫠" "渄" "濷" "猆" "疿" "癈" "紼" "緋" "胇" "胏" "茷" "萉" "蕜" "蕟" "蜰" "蟦" "裶" "誹" "費" "賁" "郿" "鐨" "陫" "靅" "靟" "飛" "飝" "餥" "馡" "騑" "騛" "髴" "鯡" "鼣"))
  ((("f" "e" "n")) ("分" "奋" "粉" "愤" "纷" "份" "忿" "吩" "坟" "粪" "氛" "颁" "芬" "酚" "焚" "汾" "盼" "偾" "拚" "瀵" "玢" "棼" "贲" "燔" "鲼" "鼢" "㖹" "㥹" "㮥" "㱵" "㷊" "㸮" "㻞" "㿎" "䀟" "䢍" "䩿" "䯨" "䴅" "僨" "兝" "坆" "坋" "墳" "奮" "妢" "岎" "帉" "幩" "弅" "憤" "昐" "朆" "朌" "枌" "梤" "棻" "橨" "歕" "濆" "炃" "燌" "燓" "獖" "砏" "秎" "糞" "紛" "羒" "羵" "翂" "肦" "膹" "蒶" "蕡" "蚠" "蚡" "衯" "訜" "豮" "豶" "賁" "轒" "鈖" "鐼" "隫" "雰" "頒" "餴" "饙" "馚" "馩" "魵" "鱝" "鳻" "黂" "黺" "鼖" "𦐈"))
  ((("f" "e" "n" "g")) ("风" "封" "丰" "疯" "蜂" "峰" "缝" "锋" "逢" "奉" "凤" "讽" "蚌" "泛" "方" "枫" "烽" "冯" "俸" "酆" "葑" "唪" "沣" "逄" "砜" "㡝" "㦀" "㵯" "䏎" "䙜" "䟪" "䩬" "䩼" "䵄" "仹" "偑" "僼" "凨" "凬" "凮" "堸" "堼" "夆" "妦" "寷" "峯" "崶" "捀" "摓" "桻" "楓" "檒" "氾" "汎" "沨" "浲" "渢" "湗" "漨" "灃" "焨" "煈" "熢" "犎" "猦" "甮" "瘋" "盽" "碸" "篈" "綘" "縫" "艂" "莑" "蘴" "蠭" "覂" "諷" "豊" "豐" "賵" "赗" "鄷" "鋒" "鏠" "靊" "風" "飌" "馮" "鳯" "鳳" "鴌" "鵬" "麷"))
  ((("f" "o")) ("佛" "㤇" "仏" "坲"))
  ((("f" "o" "u")) ("否" "不" "缶" "䬏" "䳕" "剻" "哹" "復" "椱" "殕" "竎" "紑" "缹" "缻" "芣" "裦" "雬" "鴀"))
  ((("f" "u")) ("复" "服" "父" "府" "夫" "负" "妇" "富" "副" "佛" "傅" "福" "浮" "附" "幅" "伏" "肤" "腐" "符" "付" "咐" "扶" "斧" "袱" "缚" "辐" "俘" "辅" "覆" "腹" "俯" "敷" "孵" "蝠" "抚" "甫" "赴" "凫" "蔽" "沸" "拂" "氟" "涪" "弗" "釜" "脯" "腑" "赋" "阜" "讣" "仆" "莆" "匐" "阝" "郛" "芙" "芾" "苻" "茯" "莩" "菔" "拊" "掊" "呋" "呒" "幞" "怫" "溥" "滏" "宓" "艴" "孚" "驸" "绂" "绋" "桴" "赙" "祓" "砩" "黻" "黼" "罘" "稃" "馥" "蚨" "蜉" "蝮" "麸" "趺" "跗" "鲋" "鳆" "鞴" "㓡" "㕮" "㗘" "㙏" "㚆" "㚕" "㜑" "㝿" "㞎" "㟊" "㠅" "㡝" "㤔" "㤱" "㪄" "㫙" "㬼" "㳇" "㵗" "㷆" "㽬" "㾈" "㾱" "䂤" "䃽" "䋨" "䋹" "䌗" "䌿" "䍌" "䍖" "䎅" "䑧" "䒀" "䒄" "䒇" "䓛" "䔰" "䕎" "䗄" "䘀" "䘄" "䘠" "䝾" "䞜" "䞞" "䞯" "䞸" "䟔" "䟮" "䠵" "䡍" "䥤" "䦣" "䧞" "䨗" "䨱" "䩉" "䪙" "䫍" "䫝" "䬪" "䭮" "䭸" "䮛" "䯱" "䯽" "䳝" "䵗" "䵾" "乀" "乶" "伕" "俌" "俛" "偩" "冨" "冹" "刜" "咈" "嘸" "嚩" "圑" "坿" "垘" "垺" "妋" "姇" "婏" "婦" "媍" "嬔" "尃" "岪" "峊" "巿" "帗" "弣" "彿" "復" "怤" "懯" "払" "抙" "捬" "撫" "旉" "暊" "枎" "枹" "柎" "柫" "栿" "棴" "榑" "泭" "洑" "澓" "炥" "烰" "焤" "玞" "玸" "琈" "甶" "畉" "畐" "畗" "癁" "盙" "砆" "祔" "秿" "稪" "笰" "筟" "箙" "簠" "粰" "糐" "紨" "紱" "紼" "絥" "綍" "綒" "緮" "縛" "纀" "罦" "翇" "胕" "膚" "艀" "芣" "茀" "荴" "萯" "葍" "蕧" "虙" "蚥" "蚹" "蛗" "蜅" "蝜" "衭" "袚" "袝" "複" "褔" "襆" "訃" "詂" "諨" "豧" "負" "賦" "賻" "踾" "軵" "輔" "輹" "輻" "邞" "郙" "鄜" "釡" "鈇" "鉘" "鉜" "錇" "鍑" "鍢" "陚" "韍" "韨" "頫" "颫" "駙" "髴" "鬴" "鮄" "鮒" "鯆" "鰒" "鳧" "鳬" "鳺" "鴔" "鵩" "鶝" "麩" "麬" "麱" "福" "𦱖" "𧌓"))
  ((("g" "a")) ("噶" "嘎" "胳" "咖" "轧" "伽" "尬" "尕" "尜" "旮" "钆" "骱" "嘠" "玍" "軋" "釓" "錷" "𠁥"))
  ((("g" "a" "i")) ("改" "该" "概" "盖" "溉" "钙" "骸" "阂" "芥" "汽" "丐" "陔" "垓" "戤" "赅" "胲" "㕢" "㧉" "㮣" "䏗" "䪱" "乢" "侅" "匃" "匄" "姟" "峐" "忋" "摡" "晐" "槩" "槪" "漑" "瓂" "畡" "祴" "絠" "絯" "荄" "葢" "蓋" "該" "豥" "賅" "賌" "郂" "鈣" "閡" "隑" "𠁥" "𩕭"))
  ((("g" "a" "n")) ("干" "感" "赶" "敢" "杆" "肝" "甘" "竿" "秆" "柑" "赣" "汗" "迁" "乾" "坩" "苷" "尴" "擀" "泔" "淦" "澉" "绀" "橄" "旰" "矸" "疳" "酐" "㺂" "䃭" "䇞" "䔈" "䤗" "䯎" "䲺" "䵟" "乹" "亁" "仠" "倝" "凎" "凲" "尲" "尶" "尷" "嵅" "幹" "忓" "扞" "攼" "桿" "榦" "檊" "汵" "涻" "漧" "灨" "玕" "皯" "盰" "稈" "筸" "簳" "粓" "紺" "芉" "虷" "蜬" "衦" "詌" "贑" "贛" "趕" "迀" "釬" "骭" "鱤" "鳡" "鳱"))
  ((("g" "a" "n" "g")) ("刚" "钢" "纲" "岗" "港" "缸" "冈" "肮" "肛" "杠" "扛" "亢" "戆" "罡" "颃" "筻" "舡" "㟠" "㟵" "㽘" "䴚" "冮" "剛" "堈" "堽" "岡" "崗" "戅" "戇" "掆" "摃" "棡" "槓" "溝" "焵" "牨" "犅" "疘" "矼" "碙" "笐" "綱" "罁" "罓" "釭" "鋼" "鎠" "阬" "頏"))
  ((("g" "a" "o")) ("高" "告" "搞" "稿" "膏" "糕" "羔" "篙" "皋" "镐" "浩" "咎" "睾" "诰" "郜" "蒿" "藁" "缟" "桕" "槔" "槁" "杲" "锆" "㚏" "㚖" "㾸" "䗣" "䨢" "叝" "吿" "夰" "暠" "槀" "槹" "橰" "檺" "櫜" "滜" "煰" "皐" "皜" "睪" "祮" "祰" "禞" "稁" "稾" "笴" "筶" "縞" "羙" "臯" "菒" "藳" "誥" "鋯" "鎬" "餻" "髙" "鯌" "鷎" "鼛" "𦤎"))
  ((("g" "e")) ("个" "革" "各" "哥" "歌" "格" "隔" "割" "胳" "搁" "骼" "疙" "鸽" "噶" "盖" "戈" "葛" "蛤" "阁" "铬" "浩" "菏" "合" "咯" "烙" "屹" "鬲" "仡" "哿" "圪" "塥" "嗝" "阖" "纥" "搿" "膈" "砝" "硌" "镉" "袼" "颌" "虼" "舸" "髂" "㗆" "㝓" "㠷" "㦴" "㨰" "㪾" "㵧" "㷴" "䆟" "䈓" "䐙" "䕻" "䗘" "䘁" "䛋" "䛿" "䢔" "䧄" "䨣" "䩐" "䪂" "䪺" "䫦" "佮" "個" "匌" "呄" "嗰" "嶱" "愅" "戓" "戨" "扢" "挌" "擖" "擱" "敋" "槅" "渮" "滆" "滒" "牁" "牫" "牱" "犵" "獦" "笴" "箇" "紇" "肐" "臵" "茖" "葢" "蓋" "蛒" "裓" "觡" "諽" "謌" "輵" "轕" "郃" "鉀" "鉻" "鉿" "鎘" "鎶" "閘" "閣" "閤" "闔" "鞈" "鞷" "韐" "韚" "頜" "鮯" "鰪" "鴚" "鴿" "麧" "齃" "𪃿"))
  ((("g" "e" "i")) ("给" "胲" "給"))
  ((("g" "e" "n")) ("跟" "根" "哏" "痕" "亘" "茛" "艮" "㫔" "㮓" "䫀" "亙" "刯" "剆"))
  ((("g" "e" "n" "g")) ("更" "耕" "梗" "哽" "庚" "羹" "埂" "耿" "粳" "颈" "炔" "邢" "硬" "亘" "赓" "绠" "炅" "鲠" "㾘" "䋁" "䌄" "䨣" "䱍" "䱎" "䱭" "䱴" "亙" "堩" "峺" "挭" "揯" "搄" "暅" "浭" "畊" "秔" "稉" "絙" "絚" "綆" "緪" "縆" "羮" "莄" "菮" "賡" "郠" "頸" "骾" "鯁" "鶊" "鹒"))
  ((("g" "o" "n" "g")) ("工" "共" "公" "功" "攻" "供" "巩" "贡" "拱" "宫" "弓" "躬" "汞" "蚣" "赣" "恭" "龚" "虹" "红" "廾" "珙" "肱" "蛩" "觥" "㓋" "㔶" "㤨" "㧬" "㫒" "㭟" "㯯" "㺬" "㼦" "䂬" "䇨" "䔈" "䡗" "䢚" "䱋" "匑" "厷" "唝" "嗊" "塨" "宮" "幊" "愩" "拲" "杛" "栱" "澒" "灨" "玜" "疘" "碽" "穬" "篢" "糼" "紅" "羾" "蛬" "觵" "貢" "贑" "贛" "躳" "輁" "釭" "銾" "鋛" "鞏" "魟" "龏" "龔"))
  ((("g" "o" "u")) ("够" "构" "狗" "沟" "钩" "勾" "购" "苟" "垢" "拘" "句" "佝" "诟" "岣" "逅" "遘" "媾" "缑" "枸" "觏" "彀" "耩" "笱" "篝" "鞲" "骺" "㗕" "㜌" "㝅" "㝤" "㨌" "㳶" "㺃" "䃓" "䝭" "䞀" "傋" "冓" "坸" "夠" "姤" "搆" "撀" "構" "溝" "煹" "玽" "痀" "穀" "緱" "耇" "耈" "耉" "芶" "茩" "蚼" "褠" "覯" "訽" "詬" "豰" "豿" "購" "軥" "鈎" "鉤" "雊" "韝" "鴝" "鷇"))
  ((("g" "u")) ("古" "姑" "故" "固" "顾" "鼓" "股" "骨" "谷" "估" "孤" "雇" "咕" "钴" "菇" "辜" "皋" "箍" "沽" "蛊" "滑" "家" "贾" "角" "苦" "嘏" "诂" "菰" "呱" "崮" "汩" "梏" "轱" "牯" "牿" "胍" "臌" "毂" "瞽" "罟" "锢" "瓠" "鸪" "鹄" "痼" "蛄" "酤" "觚" "鲴" "骰" "鹘" "㒴" "㚉" "㧽" "㯏" "㼋" "㽽" "㾶" "䀇" "䀜" "䀦" "䀰" "䅽" "䊺" "䍍" "䍛" "䐨" "䓛" "䓢" "䜼" "䡩" "䮩" "䵻" "䶜" "僱" "凅" "唂" "唃" "堌" "夃" "嫴" "尳" "崓" "怘" "愲" "扢" "抇" "搰" "杚" "柧" "棝" "榖" "榾" "橭" "泒" "淈" "濲" "瀔" "焸" "狜" "皷" "皼" "盬" "祻" "稒" "穀" "笟" "箛" "糓" "縎" "罛" "羖" "脵" "苽" "蓇" "薣" "蛌" "蠱" "詁" "賈" "軱" "轂" "鈲" "鈷" "錮" "離" "頋" "顧" "餶" "馉" "鮕" "鯝" "鴣" "鵠" "鶮" "鶻" "鼔"))
  ((("g" "u" "a")) ("挂" "瓜" "刮" "寡" "褂" "剐" "括" "舌" "适" "蜗" "卦" "诖" "呱" "栝" "胍" "脶" "鸹" "聒" "㒷" "䈑" "冎" "剮" "劀" "叧" "啩" "坬" "懖" "捖" "掛" "桰" "煱" "瘑" "筈" "絓" "緺" "罣" "罫" "腡" "葀" "蝸" "詿" "趏" "踻" "銽" "頢" "颳" "騧" "髺" "鴰"))
  ((("g" "u" "a" "i")) ("怪" "拐" "乖" "掴" "㧔" "㷇" "㽇" "䂯" "䊽" "叏" "夬" "恠" "旝" "枴" "柺" "癐" "箉" "罫"))
  ((("g" "u" "a" "n")) ("关" "观" "管" "官" "馆" "惯" "灌" "贯" "罐" "棺" "串" "冠" "纶" "斡" "倌" "莞" "菅" "掼" "擐" "浣" "涫" "脘" "盥" "鹳" "矜" "缶" "鳏" "㮡" "㴦" "䂯" "䌯" "䎚" "䏓" "䗆" "䗰" "䘾" "䙛" "䙮" "䝺" "䦎" "䩪" "䪀" "䲘" "丱" "悹" "悺" "慣" "摜" "樌" "櫬" "毌" "泴" "淪" "潅" "澣" "爟" "琯" "瓘" "痯" "瘝" "癏" "矔" "礶" "祼" "筦" "綸" "罆" "舘" "蒄" "覌" "観" "觀" "謴" "貫" "輨" "遦" "錧" "鏆" "鑵" "関" "闗" "關" "雚" "館" "鰥" "鱞" "鱹" "鳤" "鸛" "館"))
  ((("g" "u" "a" "n" "g")) ("光" "广" "逛" "横" "咣" "犷" "潢" "桄" "胱" "㫛" "䍍" "侊" "俇" "僙" "垙" "姯" "広" "廣" "櫎" "洸" "灮" "炗" "炛" "烡" "獷" "珖" "臦" "臩" "茪" "輄" "迋" "銧" "黆"))
  ((("g" "u" "i")) ("规" "鬼" "贵" "柜" "归" "轨" "跪" "闺" "诡" "硅" "龟" "概" "瑰" "圭" "癸" "桂" "刽" "会" "撅" "傀" "祈" "炔" "洼" "匦" "匮" "刿" "隗" "庋" "宄" "妫" "桧" "炅" "晷" "眭" "皈" "簋" "蹶" "觖" "鲑" "鳜" "㔳" "㙺" "㧪" "㨳" "㩻" "㪈" "㱦" "㲹" "㸵" "䁛" "䃽" "䇈" "䌆" "䍯" "䍷" "䐴" "䖯" "䙆" "䝿" "䞈" "䞨" "䠩" "䣀" "䤥" "䯣" "䰎" "䳏" "亀" "佹" "劊" "劌" "匭" "匱" "厬" "垝" "姽" "媯" "媿" "嫢" "嬀" "嶡" "巂" "巜" "帰" "庪" "廆" "恑" "摫" "撌" "攰" "攱" "敮" "昋" "暩" "會" "朹" "椝" "槻" "槼" "檜" "櫃" "歸" "氿" "溈" "溎" "潙" "珪" "璝" "瓌" "瞆" "瞶" "祪" "禬" "窐" "筀" "繪" "膭" "茥" "蓕" "蛫" "蟡" "袿" "襘" "規" "觤" "詭" "貴" "趹" "軌" "邽" "郌" "鐀" "閨" "陒" "鞼" "騩" "鬶" "鬹" "鮭" "鱖" "鱥" "龜"))
  ((("g" "u" "n")) ("滚" "棍" "辊" "浑" "混" "丨" "衮" "绲" "磙" "鲧" "㔳" "㙥" "㨰" "㫎" "㯻" "䃂" "䎾" "䙛" "䜇" "䵪" "掍" "渾" "滾" "璭" "睔" "睴" "緄" "蓘" "蔉" "袞" "袬" "裩" "裷" "輥" "錕" "鮌" "鯀" "鰥"))
  ((("g" "u" "o")) ("国" "过" "果" "锅" "裹" "郭" "活" "涡" "馘" "蠃" "埚" "掴" "呙" "帼" "崞" "猓" "椁" "虢" "聒" "蜮" "蜾" "蝈" "㕵" "㖪" "㚍" "㞅" "㳀" "㶁" "䂸" "䆐" "䐸" "䙨" "䤋" "䬎" "䴹" "啯" "嘓" "囯" "囶" "囻" "圀" "國" "堝" "墎" "幗" "惈" "慖" "摑" "敋" "槨" "淉" "渦" "漍" "濄" "簂" "粿" "綶" "緺" "聝" "腂" "腘" "膕" "菓" "蝸" "蟈" "輠" "過" "鈛" "錁" "鍋" "鐹" "餜" "馃"))
  ((("h" "a")) ("哈" "蛤" "虾" "獬" "铪" "奤" "蝦" "鉿" "𠀀"))
  ((("h" "a" "i")) ("还" "孩" "海" "害" "咳" "嗨" "骸" "氦" "亥" "骇" "胲" "颏" "醢" "㕢" "㜾" "㤥" "㦟" "㧡" "㨟" "㱚" "㺔" "䂤" "䇋" "䍖" "䠹" "䠽" "䯐" "䱺" "咍" "嗐" "烸" "還" "酼" "閡" "頦" "餀" "饚" "駭" "𠀅" "𥩲"))
  ((("h" "a" "n")) ("喊" "含" "汉" "寒" "焊" "旱" "汗" "憾" "撼" "捍" "厂" "干" "酣" "憨" "邯" "韩" "涵" "函" "罕" "翰" "悍" "邗" "菡" "撖" "擀" "犴" "阚" "泔" "澉" "瀚" "旰" "晗" "焓" "顸" "颌" "颔" "蚶" "酐" "鼾" "㑵" "㒈" "㖤" "㘎" "㘕" "㘚" "㙈" "㙔" "㙳" "㜦" "㟏" "㟔" "㢨" "㨔" "㪋" "㮀" "㲦" "㵄" "㵎" "㶰" "㸁" "㺖" "㼨" "㽉" "㽳" "䁔" "䈄" "䌍" "䍐" "䍑" "䎏" "䎯" "䏎" "䏷" "䐄" "䓍" "䓿" "䕿" "䖔" "䗙" "䗣" "䘶" "䛞" "䤴" "䥁" "䦈" "䧲" "䨡" "䫲" "䮧" "䶃" "佄" "傼" "凾" "厈" "哻" "唅" "嚂" "圅" "垾" "壏" "娢" "娨" "嫨" "屽" "崡" "幹" "扞" "攌" "晘" "晥" "暵" "梒" "椷" "歛" "浛" "浫" "涆" "淊" "漢" "澏" "澣" "灘" "炶" "熯" "猂" "琀" "甝" "皔" "睅" "筨" "肣" "莟" "蔊" "虷" "蛿" "蜭" "螒" "譀" "谽" "豃" "豻" "貋" "軒" "釬" "鈐" "銲" "鋎" "鋡" "閈" "闞" "闬" "雗" "韓" "頇" "頜" "頷" "顄" "顉" "馠" "馯" "駻" "鬫" "魽" "鳱" "鶾"))
  ((("h" "a" "n" "g")) ("行" "航" "肮" "夯" "杭" "狠" "炕" "吭" "狼" "巷" "沆" "绗" "桁" "颃" "酐" "㤚" "䀪" "䘕" "䟘" "䢚" "䣈" "䦳" "䲳" "䴂" "斻" "汻" "笐" "筕" "絎" "苀" "蚢" "貥" "迒" "頏" "魧" "鴴" "鸻"))
  ((("h" "a" "o")) ("好" "号" "毫" "耗" "豪" "壕" "浩" "皋" "镐" "嚎" "郝" "貉" "涸" "睾" "蒿" "薅" "嗥" "嚆" "濠" "灏" "昊" "皓" "颢" "蚝" "㕺" "㘪" "㙱" "㚪" "㝀" "㞻" "㠙" "㩝" "㬔" "㬶" "㵆" "䒵" "䚽" "䝞" "䝥" "䧚" "䧫" "䪽" "䬉" "䯫" "侾" "傐" "儫" "勂" "呺" "哠" "嘷" "噑" "峼" "恏" "悎" "昦" "晧" "暠" "暤" "暭" "曍" "椃" "淏" "滈" "滜" "澔" "瀥" "灝" "獆" "獋" "獔" "皜" "皞" "皡" "皥" "睪" "秏" "籇" "聕" "茠" "薃" "薧" "藃" "號" "蠔" "諕" "譹" "貈" "鄗" "鎬" "顥" "鰝"))
  ((("h" "e")) ("和" "合" "河" "何" "喝" "盒" "荷" "核" "呵" "贺" "嗬" "褐" "盖" "硅" "害" "菏" "禾" "貉" "阂" "涸" "赫" "鹤" "黑" "霍" "钾" "苛" "渴" "洽" "吓" "蝎" "诃" "劾" "壑" "藿" "嗑" "阖" "纥" "曷" "盍" "耠" "颌" "蚵" "翮" "㓭" "㔠" "㕡" "㕰" "㙳" "㥺" "㦦" "㪉" "㬞" "㭘" "㭱" "㮝" "㮫" "㲦" "㵑" "㷎" "㷤" "㹇" "㻧" "㿣" "䃒" "䅂" "䎋" "䒩" "䓼" "䕣" "䙓" "䚂" "䞦" "䢔" "䢗" "䪚" "䫘" "䮤" "䯨" "䳚" "䳽" "䴳" "䵱" "䶅" "佫" "俰" "凅" "厒" "咊" "哬" "啝" "喛" "嗃" "嚇" "姀" "峆" "嵑" "廅" "惒" "抲" "敆" "暍" "柇" "楁" "槅" "欱" "毼" "滆" "澕" "焃" "煂" "熆" "熇" "爀" "犵" "狢" "猲" "癋" "皬" "盇" "盉" "碋" "礉" "秴" "篕" "籺" "紇" "繳" "翯" "萂" "葢" "蒚" "蓋" "螛" "蠚" "袔" "覈" "訶" "訸" "詥" "貈" "賀" "輅" "轄" "郃" "釛" "鉀" "鉌" "閡" "閤" "闔" "隺" "靎" "靏" "鞨" "頜" "餄" "餲" "饸" "鬩" "魺" "鲄" "鵠" "鶡" "鶴" "鸖" "鹖" "麧" "齕" "龁" "龢" "鶴"))
  ((("h" "e" "i")) ("黑" "嘿" "嗨" "潶" "黒"))
  ((("h" "e" "n")) ("很" "恨" "狠" "痕" "哏" "艮" "㯊" "䓳" "佷" "噷" "拫" "詪" "鞎"))
  ((("h" "e" "n" "g")) ("哼" "横" "衡" "恒" "亨" "行" "黉" "訇" "蘅" "绗" "珩" "桁" "㔰" "㶇" "䄓" "䒛" "䬖" "䬝" "䯒" "啈" "姮" "恆" "悙" "揘" "撔" "楻" "橫" "澋" "絎" "胻" "脝" "誙" "諻" "鐄" "鑅" "韹" "鴴" "鸻" "黌"))
  ((("h" "o" "n" "g")) ("红" "轰" "洪" "宏" "哄" "烘" "触" "缸" "港" "虹" "鸿" "弘" "汪" "黉" "訇" "讧" "荭" "蕻" "薨" "闳" "泓" "洚" "㖓" "㢬" "㬴" "㶹" "㷎" "䀧" "䂫" "䃔" "䆖" "䉺" "䍔" "䜫" "䞑" "䡌" "䡏" "䧆" "䨎" "䩑" "䪦" "䫹" "䫺" "䬝" "䲨" "仜" "叿" "吰" "吽" "呍" "唝" "嗊" "垬" "妅" "娂" "宖" "峵" "嵤" "彋" "揈" "晎" "汯" "浤" "渱" "渹" "潂" "澒" "灴" "焢" "玒" "瓨" "硔" "硡" "竑" "竤" "篊" "粠" "紅" "紘" "紭" "綋" "纮" "翃" "翝" "耾" "舼" "苰" "葒" "葓" "訌" "謍" "谹" "谼" "谾" "軣" "輷" "轟" "鈜" "鉷" "鋐" "鍙" "鍧" "閎" "閧" "霟" "鞃" "顭" "鬨" "魟" "鴻" "黌"))
  ((("h" "o" "u")) ("后" "候" "厚" "猴" "吼" "喉" "侯" "堠" "後" "逅" "灬" "瘊" "篌" "糇" "鲎" "骺" "㕈" "㖃" "㗋" "㤧" "㫗" "㬋" "㮢" "㸸" "㺅" "䂉" "䗔" "䙈" "䞀" "䞧" "䡩" "䪷" "䫛" "䫺" "䳧" "吽" "呴" "垕" "帿" "洉" "犼" "睺" "矦" "缿" "翭" "腄" "茩" "葔" "詬" "豞" "郈" "鄇" "銗" "鍭" "餱" "鮜" "鯸" "鱟" "鲘" "齁" "𪖙"))
  ((("h" "u")) ("忽" "护" "呼" "乎" "互" "湖" "胡" "虎" "户" "糊" "壶" "蝴" "葫" "狐" "瑚" "唬" "惚" "抚" "核" "弧" "沪" "戏" "许" "羽" "芋" "冱" "芴" "唿" "囫" "岵" "猢" "怙" "汩" "浒" "滹" "琥" "槲" "轷" "胍" "觳" "烀" "煳" "戽" "扈" "祜" "瓠" "鹄" "鹕" "鹱" "虍" "笏" "酏" "醐" "斛" "鹘" "㕆" "㗅" "㦿" "㧽" "㨭" "㪶" "㫚" "㯛" "㷤" "㸦" "㹱" "㺉" "㽇" "㾰" "㿥" "䁫" "䇘" "䈸" "䉉" "䉿" "䊀" "䊺" "䍓" "䎁" "䔯" "䕶" "䗂" "䚛" "䛎" "䞱" "䠒" "䧼" "䨥" "䨼" "䩴" "䪝" "䭅" "䭌" "䭍" "䮸" "䲵" "䵻" "乕" "冴" "匢" "匫" "啒" "喖" "嘑" "嘝" "嚛" "垀" "壷" "壺" "婟" "媩" "嫭" "嫮" "寣" "峘" "帍" "幠" "弖" "戯" "戱" "戶" "戸" "抇" "搰" "摢" "撫" "擭" "昈" "昒" "曶" "枑" "楛" "楜" "槴" "欻" "歑" "沍" "泘" "淴" "滬" "滸" "濩" "瀫" "烼" "焀" "熩" "瓳" "箶" "簄" "絗" "綔" "縠" "膴" "芐" "苸" "萀" "蔛" "蔰" "虖" "虝" "螜" "衚" "許" "謼" "護" "豰" "軤" "鄠" "鈷" "鍸" "雐" "韄" "頀" "頶" "餬" "鬍" "魱" "鰗" "鱯" "鳠" "鳸" "鴩" "鵠" "鶘" "鶦" "鶻" "鸌"))
  ((("h" "u" "a")) ("话" "化" "花" "画" "划" "滑" "哗" "华" "猾" "桦" "豁" "狯" "骅" "砉" "铧" "稞" "踝" "㓰" "㕦" "㕲" "㕷" "㚌" "㟆" "㠏" "㠢" "㦊" "㦎" "㩇" "㭉" "㮯" "䅿" "䇈" "䊐" "䏦" "䔢" "䔯" "䛡" "䠉" "䱻" "䴳" "䶤" "劃" "咶" "嘩" "婳" "嫿" "嬅" "崋" "搳" "摦" "杹" "槬" "樺" "澅" "澮" "獪" "畫" "畵" "磆" "繣" "罫" "舙" "芲" "華" "蕐" "蘤" "蘳" "螖" "觟" "話" "諣" "譁" "譮" "輠" "釫" "鋘" "錵" "鏵" "驊" "鮭" "鷨" "𢄶"))
  ((("h" "u" "a" "i")) ("坏" "怀" "徊" "槐" "淮" "孬" "踝" "㜳" "㠢" "䃶" "䈭" "䴜" "佪" "咶" "壊" "壞" "懐" "懷" "櫰" "瀤" "竵" "耲" "蘹" "蘾" "褢" "褱" "諙"))
  ((("h" "u" "a" "n")) ("换" "环" "欢" "缓" "还" "幻" "唤" "患" "灌" "桓" "痪" "豢" "焕" "涣" "宦" "皖" "眩" "郇" "奂" "垸" "苋" "萑" "擐" "圜" "獾" "洹" "浣" "漶" "寰" "逭" "缳" "瑗" "脘" "锾" "鲩" "鬟" "㓉" "㔳" "㕕" "㠢" "㡲" "㢰" "㣪" "㦥" "㪱" "㬇" "㬊" "㵹" "㶎" "㹖" "㼫" "㿪" "䀓" "䀨" "䁔" "䆠" "䈠" "䊐" "䍺" "䒛" "䝠" "䠉" "䥧" "䦡" "䭴" "䮝" "䯘" "䴟" "唍" "喚" "喛" "嚾" "奐" "嬛" "寏" "峘" "嵈" "愌" "懁" "懽" "捖" "換" "攌" "梙" "槵" "歓" "歡" "渙" "潅" "澣" "澴" "烉" "煥" "犿" "狟" "獂" "瑍" "環" "瓛" "瘓" "睆" "糫" "綄" "緩" "繯" "羦" "肒" "荁" "莧" "萈" "藧" "讙" "豲" "貆" "貛" "輐" "轘" "還" "酄" "鍰" "鐶" "镮" "闤" "阛" "雈" "驩" "鯇" "鯶" "鰀" "鴅" "鵍" "鸛"))
  ((("h" "u" "a" "n" "g")) ("黄" "慌" "皇" "蝗" "荒" "晃" "煌" "磺" "恍" "谎" "凰" "惶" "横" "簧" "幌" "芒" "茫" "隍" "徨" "湟" "潢" "遑" "璜" "肓" "癀" "蟥" "篁" "鳇" "㞷" "㤺" "㨪" "㬻" "㾠" "㾮" "䁜" "䄓" "䅣" "䊗" "䊣" "䌙" "䍿" "䐠" "䐵" "䑟" "䞹" "䪄" "䮲" "䳨" "偟" "兤" "喤" "嚝" "堭" "塃" "墴" "媓" "宺" "崲" "巟" "怳" "愰" "撗" "晄" "曂" "朚" "榥" "櫎" "洸" "滉" "炾" "熀" "熿" "爌" "獚" "瑝" "皝" "皩" "穔" "艎" "葟" "衁" "詤" "謊" "趪" "軦" "鍠" "鎤" "锽" "餭" "騜" "鰉" "鱑" "鷬" "黃" "𣄙" "𪏙"))
  ((("h" "u" "i")) ("会" "回" "挥" "灰" "恢" "辉" "毁" "汇" "慧" "悔" "绘" "虫" "堕" "徊" "徽" "蛔" "卉" "惠" "晦" "贿" "秽" "烩" "讳" "诲" "戏" "诙" "茴" "荟" "蕙" "咴" "哕" "喙" "悝" "隳" "洄" "浍" "彗" "缋" "珲" "桧" "晖" "恚" "眭" "钺" "皓" "虺" "蝰" "蟪" "麾" "㑰" "㑹" "㒑" "㜇" "㞧" "㤬" "㥣" "㨤" "㨹" "㩓" "㩨" "㬩" "㰥" "㱱" "㷄" "㷐" "㻅" "㽇" "䂕" "䃣" "䅏" "䇻" "䌇" "䍷" "䎚" "䏨" "䕇" "䙌" "䙡" "䛛" "䛼" "䜋" "䠉" "䤧" "䧥" "䩈" "䫖" "䫭" "䰎" "䵻" "佪" "僡" "儶" "匯" "叀" "嘒" "噅" "噕" "噦" "噧" "嚖" "囘" "囬" "圚" "墮" "墯" "婎" "嬇" "寭" "幑" "廆" "廻" "廽" "彙" "彚" "恛" "恵" "憓" "戯" "戱" "拻" "揮" "撝" "暉" "暳" "會" "楎" "槥" "橞" "檓" "檜" "櫘" "殨" "毀" "毇" "沬" "泋" "洃" "渙" "湏" "滙" "潓" "澮" "濊" "瀈" "烜" "烠" "烣" "煇" "煒" "燬" "燴" "獩" "琿" "璯" "痐" "瞺" "禈" "禬" "穢" "篲" "絵" "繐" "繢" "繪" "翙" "翚" "翬" "翽" "芔" "蔧" "薈" "薉" "藱" "蚘" "蛕" "蜖" "螝" "袆" "褘" "詯" "詼" "誨" "諱" "譓" "譭" "譿" "豗" "賄" "輝" "輠" "迴" "逥" "違" "鉞" "鏸" "鐬" "鑴" "闠" "阓" "隓" "靧" "韋" "韢" "頮" "顪" "颒" "餯" "饖" "鮰" "鰴" "𠧩"))
  ((("h" "u" "n")) ("混" "昏" "浑" "婚" "魂" "棍" "荤" "昆" "诨" "馄" "阍" "溷" "珲" "㑮" "㕵" "㥵" "㨡" "㨰" "㮯" "㯻" "䅙" "䅱" "䊐" "䐊" "䚠" "䛰" "䧰" "䫟" "䮝" "䰟" "䴷" "俒" "倱" "圂" "堚" "忶" "惛" "惽" "慁" "掍" "敯" "昬" "梡" "棔" "棞" "楎" "殙" "涽" "渾" "湣" "焄" "焜" "焝" "琿" "睔" "睧" "睯" "祵" "緄" "緡" "繉" "葷" "觨" "諢" "轋" "閽" "顐" "餛" "餫" "鯶" "鼲"))
  ((("h" "u" "o")) ("活" "或" "火" "伙" "货" "获" "和" "豁" "祸" "惑" "硅" "霍" "越" "劐" "壑" "藿" "攉" "嚯" "夥" "砉" "钬" "锪" "镬" "瓠" "鹱" "耠" "蠖" "㓉" "㕡" "㗲" "㘞" "㚌" "㦜" "㦯" "㨯" "㨰" "㩇" "㯉" "㯛" "㶡" "㸌" "䁨" "䂄" "䄀" "䄆" "䄑" "䉟" "䋭" "䐸" "䣶" "䦚" "䨥" "䯏" "䰥" "佸" "剨" "咊" "咟" "嗀" "嚄" "嚿" "奯" "彟" "彠" "捇" "掝" "擭" "旤" "曤" "楇" "檴" "沎" "湱" "濊" "濩" "瀖" "獲" "瓁" "癨" "眓" "矆" "矐" "矱" "礊" "禍" "秮" "秳" "穫" "耯" "臒" "臛" "艧" "萿" "蓃" "謋" "讗" "豰" "貨" "過" "邩" "鈥" "鍃" "鑊" "閄" "雘" "霩" "靃" "韄" "頀" "騞" "鱯" "鳠" "鸌" "龢" "嗀"))
  ((("j" "i")) ("己" "机" "几" "级" "计" "济" "极" "基" "记" "集" "及" "技" "际" "击" "急" "积" "即" "纪" "激" "继" "既" "鸡" "季" "挤" "绩" "寄" "迹" "给" "剂" "寂" "疾" "肌" "辑" "圾" "脊" "饥" "籍" "讥" "系" "吉" "吃" "疵" "革" "隔" "畸" "稽" "箕" "姬" "缉" "棘" "汲" "嫉" "蓟" "冀" "伎" "祭" "悸" "忌" "妓" "秸" "洁" "结" "藉" "近" "居" "蜡" "期" "其" "棋" "奇" "齐" "骑" "揖" "丌" "亟" "乩" "剞" "佶" "偈" "脔" "诘" "郅" "墼" "芨" "芰" "荠" "萁" "蒺" "蕺" "掎" "叽" "咭" "哜" "唧" "岌" "嵴" "猗" "洎" "彐" "屐" "骥" "畿" "玑" "楫" "殛" "戟" "戢" "赍" "觊" "犄" "齑" "矶" "睽" "羁" "嵇" "稷" "瘠" "瘵" "虮" "笈" "笄" "粢" "暨" "跻" "跽" "霁" "瞿" "鲚" "鲫" "髻" "麂" "㑧" "㑵" "㒫" "㔕" "㖢" "㗊" "㗱" "㘍" "㙨" "㙫" "㚡" "㞃" "㞆" "㞛" "㞦" "㠍" "㠎" "㠖" "㠱" "㡇" "㡭" "㡮" "㡶" "㤂" "㥍" "㥛" "㦸" "㧀" "㨈" "㭰" "㭲" "㮟" "㮨" "㰟" "㱞" "㱦" "㱯" "㲅" "㲺" "㳵" "㴉" "㴕" "㸄" "㹄" "㻑" "㻷" "㽺" "㾊" "㾒" "㾵" "䁒" "䆅" "䋟" "䍤" "䍯" "䐀" "䐕" "䐚" "䒁" "䓧" "䓫" "䓽" "䗁" "䚐" "䛋" "䜞" "䝸" "䞘" "䟌" "䠏" "䢋" "䢳" "䣢" "䤒" "䤠" "䦇" "䦈" "䨖" "䩐" "䩯" "䮺" "䯂" "䰏" "䰥" "䲯" "䳭" "䶓" "䶩" "丮" "亼" "伋" "偮" "僟" "兾" "刉" "刏" "剤" "劑" "勣" "卙" "卽" "唶" "喞" "喫" "嗘" "嘰" "嚌" "坖" "垍" "堲" "塈" "塉" "墍" "妀" "姞" "姫" "尐" "峜" "嵆" "嵠" "嶯" "幾" "庪" "庴" "彑" "彶" "忣" "惎" "愱" "憿" "懻" "揤" "撃" "撠" "擊" "擠" "擮" "攲" "旡" "旣" "曁" "朞" "枅" "梞" "楖" "極" "槉" "樍" "機" "橶" "檕" "檝" "檱" "檵" "櫅" "櫭" "毄" "泲" "済" "湒" "漃" "漈" "潗" "濈" "濟" "瀱" "焏" "犱" "狤" "猤" "玘" "璣" "璾" "痵" "瘈" "癠" "皀" "皍" "瞡" "磯" "礏" "禝" "禨" "秶" "稘" "稩" "穄" "穊" "積" "穖" "穧" "筓" "箿" "簊" "紀" "紒" "級" "結" "給" "継" "緁" "緝" "績" "繫" "繼" "罽" "羇" "羈" "耤" "耭" "聻" "膌" "臮" "艻" "茍" "茤" "莋" "葪" "蓻" "蔇" "蕀" "薊" "薺" "蘄" "蘎" "蘮" "蘻" "虀" "蛣" "蝍" "螏" "蟣" "蟻" "蟿" "裚" "褀" "襀" "襋" "覉" "覊" "覘" "覬" "覿" "觙" "觭" "計" "訐" "記" "誋" "諅" "諆" "譏" "譤" "賫" "賷" "跡" "踑" "踖" "踦" "蹐" "蹟" "躋" "躤" "躸" "輯" "轚" "邔" "郆" "鈒" "鈘" "銈" "銡" "錤" "鍓" "鏶" "鐖" "鑇" "鑙" "钑" "際" "隮" "雞" "雦" "雧" "霵" "霽" "鞊" "鞿" "韲" "飢" "饑" "騎" "驥" "鬾" "魕" "魝" "魢" "鮆" "鯚" "鯽" "鰶" "鰿" "鱀" "鱭" "鱾" "鳮" "鴶" "鵋" "鶏" "鶺" "鷄" "鸄" "鹡" "麡" "齊" "齌" "齎" "齏" "𠼻" "𡜱" "𣪠" "𥡴" "𨸚"))
  ((("j" "i" "a")) ("家" "加" "价" "架" "假" "稼" "夹" "甲" "驾" "嫁" "佳" "颊" "茄" "嘉" "枷" "荚" "贾" "钾" "夏" "挟" "嘏" "伽" "郏" "葭" "拮" "岬" "浃" "迦" "珈" "柙" "戛" "胛" "恝" "铗" "铪" "镓" "痂" "瘕" "袷" "颉" "蛱" "笳" "袈" "跏" "骱" "㔠" "㕅" "㪴" "㮖" "㼪" "㿓" "䀫" "䀹" "䁍" "䇲" "䑝" "䕛" "䛟" "䢔" "䩡" "乫" "仮" "価" "傢" "價" "叚" "唊" "圿" "埉" "夾" "婽" "幏" "徦" "戞" "扴" "拁" "挾" "揳" "斚" "斝" "梜" "椵" "榎" "榢" "槚" "檟" "毠" "泇" "浹" "犌" "猳" "玾" "睱" "硈" "筴" "耞" "脥" "腵" "舺" "莢" "蛺" "蝦" "裌" "豭" "貑" "賈" "跲" "郟" "鉀" "鉫" "鉿" "鋏" "鎵" "鞂" "鞈" "頡" "頬" "頰" "餄" "饸" "駕" "駱" "鴐" "鴚" "鵊" "麚"))
  ((("j" "i" "a" "n")) ("见" "间" "建" "件" "坚" "渐" "简" "检" "践" "减" "艰" "肩" "尖" "健" "监" "歼" "箭" "拣" "剑" "键" "兼" "剪" "鉴" "碱" "贱" "捡" "溅" "煎" "舰" "奸" "荐" "茧" "俭" "笺" "缄" "柬" "硷" "槛" "饯" "涧" "沮" "齐" "钱" "纤" "湛" "僭" "谏" "谫" "谮" "茛" "菅" "蒹" "搛" "囝" "犴" "湔" "蹇" "謇" "缣" "枧" "楗" "戋" "戬" "牮" "犍" "毽" "腱" "睑" "锏" "鹣" "裥" "笕" "箴" "翦" "趼" "踺" "鲣" "鞯" "㓺" "㔋" "㔓" "㣤" "㦗" "㨴" "㨵" "㯺" "㰄" "㱯" "㳨" "㵎" "㶕" "㺂" "㺝" "㽉" "䄯" "䅐" "䇟" "䉍" "䛳" "䞼" "䟅" "䟢" "䟰" "䤔" "䥜" "䧖" "䩆" "䬻" "䭈" "䭕" "䭠" "䮿" "䯛" "䯡" "䵖" "䵛" "䵡" "䵤" "䶠" "侟" "俴" "俿" "倹" "偂" "僣" "儉" "冿" "剣" "剱" "劍" "劎" "劒" "劔" "劗" "囏" "堅" "堿" "姦" "姧" "寋" "帴" "弿" "徤" "惤" "戔" "戩" "挸" "揀" "揃" "揵" "撿" "擶" "旔" "暕" "枅" "栫" "梘" "検" "椷" "椾" "榗" "樫" "檢" "檻" "櫼" "殲" "洊" "淺" "減" "湕" "漸" "澗" "濫" "濺" "瀐" "瀳" "瀸" "瀽" "熞" "熸" "牋" "猏" "玪" "珔" "瑊" "瑐" "監" "睷" "瞯" "瞷" "瞼" "碊" "磵" "礆" "礛" "筧" "箋" "篯" "簡" "籛" "糋" "絸" "緘" "縑" "繝" "繭" "纖" "聻" "臶" "艦" "艱" "菺" "葌" "蔪" "蕑" "蕳" "薦" "藆" "虃" "螹" "蠒" "襇" "襉" "襺" "見" "覵" "覸" "諌" "諓" "諫" "謭" "譖" "譼" "譾" "豜" "豣" "賎" "賤" "趝" "跈" "踐" "軒" "釼" "鈃" "銒" "鋻" "錢" "鍳" "鍵" "鎫" "鏨" "鏩" "鐗" "鐧" "鑑" "鑒" "鑬" "鑯" "鑳" "钘" "閒" "間" "險" "靬" "鞬" "韀" "韉" "顅" "餞" "餰" "馢" "騝" "騫" "鬋" "魐" "魙" "鰎" "鰔" "鰜" "鰹" "鳒" "鳽" "鵳" "鶼" "鹸" "鹻" "鹼" "麉" "齊" "𢆞"))
  ((("j" "i" "a" "n" "g")) ("将" "讲" "江" "降" "匠" "奖" "酱" "僵" "浆" "缰" "桨" "疆" "姜" "虹" "蒋" "强" "茳" "洚" "绛" "犟" "礓" "襁" "耩" "糨" "豇" "㢡" "㯍" "䁰" "䉃" "䋌" "䒂" "䙹" "䞪" "䥒" "傹" "勥" "匞" "塂" "壃" "夅" "奨" "奬" "將" "嵹" "弜" "弶" "強" "彊" "摪" "摾" "槳" "橿" "殭" "滰" "漿" "獎" "瓨" "畕" "畺" "疅" "糡" "紅" "絳" "繈" "繦" "繮" "翞" "膙" "葁" "蔃" "蔣" "薑" "螀" "螿" "袶" "講" "謽" "醤" "醬" "韁" "顜" "鱂" "鳉" "𢘸" "𤕭" "𤕯"))
  ((("j" "i" "a" "o")) ("叫" "教" "较" "交" "脚" "角" "觉" "焦" "骄" "浇" "搅" "胶" "轿" "郊" "剿" "狡" "缴" "蕉" "椒" "娇" "窖" "饺" "酵" "激" "礁" "嚼" "铰" "矫" "侥" "绞" "纠" "校" "咬" "佼" "僬" "艽" "荞" "茭" "菽" "挢" "噍" "峤" "徼" "湫" "姣" "敫" "爝" "皎" "鹪" "蛟" "醮" "跤" "鲛" "㠐" "㩭" "㩰" "㬭" "㭂" "㰾" "㱶" "㳅" "㽱" "㽲" "㿟" "䀊" "䁶" "䂃" "䆗" "䘨" "䚩" "䠛" "䢪" "䣤" "䥞" "䪒" "䴔" "䴛" "僥" "儌" "劋" "勦" "呌" "嘂" "嘄" "嘐" "嘦" "噭" "嫶" "嬌" "嬓" "孂" "峧" "嶕" "嶠" "徺" "憍" "憿" "挍" "捁" "摷" "撟" "撹" "攪" "敎" "敽" "敿" "斅" "斆" "斠" "晈" "暞" "曒" "樔" "湬" "滘" "漅" "漖" "潐" "澆" "灂" "灚" "烄" "焳" "煍" "燋" "珓" "璬" "皛" "皦" "皭" "矯" "穚" "窌" "筊" "簥" "糺" "絞" "繳" "腳" "膠" "膲" "臫" "芁" "茮" "蕎" "藠" "虠" "蟂" "蟜" "蟭" "覐" "覺" "訆" "詨" "譑" "譥" "賋" "趭" "踋" "較" "轇" "轎" "醶" "釂" "鉸" "鐎" "顜" "餃" "驕" "鮫" "鱎" "鴵" "鵁" "鷍" "鷦" "鷮" "齩" "𠞰" "𨺹"))
  ((("j" "i" "e")) ("阶" "解" "结" "界" "接" "节" "街" "姐" "借" "介" "揭" "洁" "届" "截" "戒" "竭" "杰" "捷" "睫" "皆" "诫" "概" "籍" "家" "价" "秸" "劫" "桔" "藉" "芥" "疥" "楷" "渴" "拾" "械" "祖" "偕" "偈" "讦" "诘" "卩" "苴" "葜" "拮" "喈" "嗟" "獬" "廨" "婕" "孑" "栉" "桀" "砝" "碣" "锴" "疖" "袷" "颉" "蚧" "羯" "鲒" "骱" "髻" "㑘" "㑵" "㓗" "㓤" "㔾" "㘶" "㛃" "㝌" "㝏" "㞯" "㠍" "㠹" "㦢" "㨗" "㨩" "㨰" "㮞" "㮮" "㸄" "㸅" "㾏" "㿍" "䀷" "䁓" "䂃" "䂒" "䂝" "䂶" "䅥" "䇒" "䌖" "䔿" "䕙" "䗻" "䘁" "䛺" "䞦" "䟌" "䣠" "䥛" "䯰" "䰺" "䱄" "䲙" "䲸" "丯" "倢" "偼" "傑" "價" "刦" "刧" "刼" "劼" "卪" "吤" "唶" "喼" "堦" "堺" "媎" "寁" "屆" "岊" "岕" "崨" "嵑" "嵥" "巀" "幯" "庎" "徣" "悈" "扻" "抾" "掲" "搩" "擑" "擳" "昅" "栨" "椄" "楐" "楬" "楶" "榤" "檞" "櫛" "櫭" "毑" "洯" "湝" "滐" "潔" "瀄" "犗" "犵" "玠" "琾" "瑎" "畍" "癤" "砎" "稭" "箑" "節" "紇" "紒" "結" "絜" "繲" "罝" "耤" "脻" "腉" "艥" "莭" "菨" "葪" "蓵" "薢" "蛣" "蜐" "蝔" "蠘" "蠞" "蠽" "衱" "袺" "裓" "褯" "觧" "訐" "詰" "誡" "誱" "謯" "趌" "踕" "躤" "迼" "鉣" "鍇" "鍻" "鎅" "鐑" "階" "頡" "飷" "騔" "魀" "魪" "鮚" "鶛" "鶡" "鹖" "𡽱"))
  ((("j" "i" "n")) ("进" "今" "紧" "近" "金" "仅" "斤" "劲" "尽" "巾" "禁" "筋" "浸" "锦" "津" "谨" "襟" "靳" "晋" "烬" "肋" "湛" "卺" "荩" "堇" "噤" "馑" "廑" "妗" "缙" "瑾" "槿" "赆" "觐" "钅" "衿" "矜" "㝻" "㦗" "㨷" "㬐" "㬜" "㯲" "㯸" "㰹" "㱈" "㴆" "㶦" "㶳" "㹏" "㻸" "䀆" "䆮" "䉷" "䋮" "䌍" "䌝" "䐶" "䑤" "䒺" "䖐" "䗯" "䝲" "䢻" "䤐" "䥆" "䫴" "䭙" "䶖" "伒" "侭" "僅" "僸" "儘" "凚" "劤" "勁" "厪" "嚍" "埐" "墐" "嫤" "嬧" "寖" "嶜" "巹" "惍" "慬" "搢" "晉" "暜" "枃" "歏" "殣" "浕" "溍" "漌" "濅" "濜" "燼" "珒" "琎" "瑧" "瑨" "璡" "璶" "瘽" "盡" "祲" "紟" "緊" "縉" "肵" "荕" "菫" "菳" "蓳" "藎" "覲" "觔" "訡" "謹" "賮" "贐" "進" "釿" "鋟" "錦" "靲" "饉" "鹶" "黅" "齽" "𠬶"))
  ((("j" "i" "n" "g")) ("经" "睛" "精" "静" "惊" "竟" "景" "镜" "境" "警" "净" "井" "敬" "竞" "径" "鲸" "晶" "腈" "茎" "颈" "憬" "劲" "荆" "兢" "京" "粳" "痉" "靖" "青" "氏" "烃" "醒" "刭" "儆" "阱" "陉" "菁" "獍" "泾" "迳" "弪" "婧" "檠" "晟" "肼" "胫" "旌" "蜻" "箐" "靓" "黥" "㕋" "㘫" "㢣" "㣏" "㬌" "㵾" "㹵" "䑤" "䔔" "䜘" "䡖" "䴖" "䵞" "丼" "亰" "俓" "倞" "傹" "凈" "剄" "勁" "坕" "坙" "妌" "婙" "婛" "宑" "巠" "幜" "弳" "徑" "憼" "擏" "旍" "暻" "曔" "桱" "梷" "殑" "汬" "浄" "涇" "淨" "澋" "濪" "瀞" "烴" "燛" "猄" "獷" "璟" "璥" "痙" "秔" "稉" "穽" "竧" "竫" "競" "竸" "経" "經" "聙" "脛" "荊" "莖" "葏" "葝" "蟼" "誩" "踁" "逕" "鏡" "陘" "靚" "靜" "頚" "頸" "驚" "鯨" "鵛" "鶁" "鶄" "麖" "麠" "鼱" "靖" "精" "𦀇"))
  ((("j" "i" "o" "n" "g")) ("炯" "窘" "冂" "垧" "迥" "炅" "扃" "㑋" "㓏" "㖥" "㢠" "㤯" "㷗" "㷡" "䌹" "䐃" "䢛" "侰" "僒" "冋" "冏" "囧" "坰" "埛" "幜" "檾" "泂" "澃" "瀅" "烱" "煚" "煛" "熒" "熲" "皛" "絅" "綗" "蘏" "蘔" "褧" "逈" "鎣" "顈" "颎" "駉" "駫"))
  ((("j" "i" "u")) ("就" "九" "究" "旧" "久" "酒" "救" "纠" "舅" "揪" "啾" "玖" "韭" "灸" "厩" "臼" "咎" "疚" "僦" "艽" "阄" "湫" "缪" "柩" "桕" "鸠" "鹫" "蝤" "赳" "鬏" "㝌" "㠇" "㡱" "㧕" "㩆" "㲃" "㶭" "㺩" "㺵" "㼋" "䅢" "䆒" "䊆" "䊘" "䓘" "䛮" "䠓" "䡂" "䬨" "䳎" "䳔" "丩" "乆" "乣" "勼" "匓" "匛" "匶" "奺" "媨" "廄" "廏" "廐" "慦" "捄" "揂" "揫" "摎" "朻" "柾" "樛" "牞" "畂" "稵" "糺" "糾" "紤" "繆" "舊" "舏" "萛" "觓" "轇" "醔" "镹" "韮" "鬮" "鯦" "鳩" "鷲" "麔" "齨"))
  ((("j" "u")) ("据" "具" "句" "举" "局" "巨" "居" "距" "剧" "聚" "拒" "橘" "矩" "鞠" "拘" "俱" "惧" "咀" "锯" "桔" "菊" "驹" "车" "柜" "狙" "疽" "沮" "踞" "炬" "且" "蛆" "渠" "租" "足" "倨" "讵" "鄹" "苣" "苴" "莒" "菹" "掬" "遽" "屦" "鬻" "琚" "枸" "椐" "榘" "榉" "犋" "飓" "钜" "锔" "窭" "裾" "趄" "醵" "踽" "龃" "雎" "瞿" "鞫" "㕢" "㘌" "㘲" "㜘" "㞐" "㞫" "㠪" "㥌" "㨿" "㩀" "㩴" "㪯" "㬬" "㮂" "㳥" "㹼" "㽤" "䃊" "䄔" "䅓" "䆽" "䈮" "䋰" "䎤" "䏱" "䕮" "䗇" "䛯" "䜯" "䡞" "䢹" "䣰" "䤎" "䪕" "䰬" "䱟" "䱡" "䳔" "䴗" "䵕" "䶙" "䶥" "侷" "倶" "偊" "冣" "凥" "処" "刟" "劇" "勮" "匊" "埧" "埾" "壉" "姖" "娵" "婅" "寠" "屨" "岠" "岨" "崌" "巈" "弆" "怇" "怚" "愳" "懅" "懼" "抅" "拠" "挙" "挶" "捄" "據" "擧" "昛" "柤" "梮" "椇" "椈" "楀" "檋" "櫸" "欅" "歫" "毩" "毱" "泃" "泦" "洰" "涺" "淗" "湨" "澽" "焗" "焣" "犑" "狊" "痀" "眗" "砠" "秬" "窶" "竘" "筥" "箤" "簍" "簴" "籧" "粔" "粷" "絇" "繘" "罝" "耟" "腒" "舉" "艍" "萭" "葅" "蒟" "蔞" "蘜" "虡" "蚷" "蜛" "蝺" "袓" "詎" "諊" "貗" "趜" "跔" "跙" "跼" "踘" "踙" "蹫" "躆" "躹" "車" "軥" "輂" "邭" "郹" "鄒" "鄓" "鉅" "鉏" "鋤" "鋦" "鋸" "鐻" "閰" "陱" "雛" "颶" "駏" "駒" "駶" "驕" "驧" "鮈" "鮔" "鲏" "鴡" "鵙" "鵴" "鶋" "鶌" "鶪" "鼳" "齟"))
  ((("j" "u" "a" "n")) ("卷" "倦" "绢" "鹃" "捐" "圈" "娟" "眷" "阮" "蕊" "身" "眩" "甄" "鄄" "狷" "泫" "涓" "桊" "蠲" "锩" "镌" "蜷" "隽" "㢧" "㢾" "㪻" "㯞" "㷷" "䄅" "䌸" "䐪" "䖭" "䚈" "䡓" "䳪" "剶" "劵" "勌" "勬" "埢" "姢" "婘" "巻" "帣" "悁" "慻" "捲" "朘" "淃" "獧" "琄" "瓹" "睊" "睠" "絭" "絹" "罥" "羂" "脧" "腃" "臇" "菤" "裐" "鋗" "錈" "鎸" "鐫" "雋" "鞙" "韏" "飬" "鬳" "鵑" "𠔉" "𩜇"))
  ((("j" "u" "e")) ("决" "觉" "绝" "撅" "嚼" "角" "掘" "脚" "较" "攫" "抉" "倔" "爵" "诀" "狂" "蛙" "穴" "厥" "劂" "谲" "矍" "蕨" "蕞" "嗟" "噘" "噱" "崛" "獗" "阙" "孓" "珏" "柽" "梏" "桷" "橛" "觳" "爝" "镢" "蠼" "蹶" "觖" "鳜" "㓸" "㔃" "㔢" "㔳" "㟲" "㤜" "㩱" "㭈" "㭰" "㭾" "㰐" "㵐" "㷾" "㸕" "㹟" "㻕" "㻡" "䀗" "䁷" "䆕" "䆢" "䇶" "䈑" "䋉" "䍊" "䍳" "䏐" "䏣" "䐘" "䖼" "䘿" "䙠" "䝌" "䞵" "䞷" "䟾" "䠇" "䡈" "䣤" "䦆" "䦼" "亅" "傕" "僪" "刔" "勪" "咑" "啳" "孒" "屩" "屫" "崫" "嵑" "嶥" "弡" "彏" "憠" "憰" "戄" "抇" "挗" "捔" "撧" "斍" "橜" "欔" "欮" "殌" "氒" "決" "泬" "潏" "焆" "焳" "熦" "爑" "爴" "玃" "玦" "玨" "瑴" "璚" "疦" "瘚" "矞" "矡" "砄" "絕" "絶" "腳" "臄" "芵" "蕝" "蚗" "蟨" "蟩" "覐" "覚" "覺" "觼" "訣" "譎" "谻" "貜" "赽" "趹" "踋" "蹷" "蹻" "躩" "較" "逫" "鈌" "鐍" "鐝" "钁" "镼" "闋" "闕" "駃" "鱊" "鱖" "鴂" "鴃" "鷢" "龣" "𠢤" "𧽸" "𩪗"))
  ((("j" "u" "n")) ("军" "均" "菌" "君" "峻" "龟" "钧" "俊" "竣" "浚" "郡" "骏" "訇" "捃" "狻" "逡" "睃" "皲" "筠" "隽" "麇" "㑺" "㒞" "㓴" "㕙" "㝦" "㢠" "㤯" "㴫" "㻒" "㽙" "䇹" "䕑" "䜭" "䝌" "䝍" "儁" "呁" "姰" "寯" "懏" "攈" "攟" "晙" "桾" "殾" "汮" "濬" "焌" "珺" "畯" "皸" "皹" "碅" "箘" "箟" "莙" "菎" "葰" "蔨" "蚐" "蜠" "袀" "覠" "軍" "鈞" "銁" "銞" "陖" "雋" "頵" "餕" "馂" "駿" "鮶" "鲪" "鵔" "鵘" "麏" "麕" "龜"))
  ((("k" "a")) ("卡" "咖" "喀" "咯" "佧" "咔" "胩" "髂" "鉲"))
  ((("k" "a" "i")) ("开" "慨" "揩" "楷" "凯" "咳" "渴" "岂" "剀" "垲" "蒈" "忾" "恺" "溘" "铠" "锎" "锴" "雉" "㗆" "㡁" "㲉" "㳀" "䁗" "䐩" "䒓" "䡷" "䫦" "凱" "剴" "勓" "嘅" "塏" "奒" "愒" "愷" "愾" "暟" "欬" "炌" "炏" "烗" "痎" "礚" "豈" "輆" "鍇" "鎧" "鐦" "開" "閡" "闓" "闿" "颽" "𩋧"))
  ((("k" "a" "n")) ("看" "砍" "刊" "堪" "槛" "勘" "坎" "侃" "莰" "阚" "戡" "龛" "瞰" "㙳" "㵎" "㸝" "䀍" "䖔" "䘓" "䫲" "䬻" "䳚" "䶫" "偘" "冚" "刋" "埳" "塪" "墈" "崁" "嵁" "惂" "栞" "檻" "欿" "歁" "歞" "監" "矙" "磡" "竷" "薟" "衎" "譼" "輡" "轁" "轗" "闞" "顑" "餡" "鬫" "龕"))
  ((("k" "a" "n" "g")) ("抗" "炕" "康" "扛" "慷" "肮" "杭" "荒" "糠" "亢" "伉" "闶" "沆" "钪" "㰠" "䡉" "䲘" "匟" "囥" "嫝" "忼" "摃" "槺" "漮" "犺" "砊" "穅" "粇" "躿" "邟" "鈧" "鏮" "閌" "骯" "鱇"))
  ((("k" "a" "o")) ("靠" "考" "烤" "拷" "尻" "栲" "槁" "犒" "铐" "㼥" "䎋" "䐧" "䘓" "䯪" "丂" "攷" "槀" "洘" "燺" "稁" "薧" "藳" "銬" "髛" "鮳" "鲓" "鷱" "𥬯"))
  ((("k" "e")) ("可" "科" "刻" "客" "课" "颗" "克" "棵" "壳" "渴" "咳" "磕" "瞌" "蝌" "果" "呵" "荷" "喀" "坷" "苛" "柯" "哿" "嗑" "岢" "恪" "溘" "骒" "缂" "珂" "轲" "氪" "碣" "盍" "钶" "铪" "锞" "稞" "疴" "窠" "颏" "蚵" "髁" "㒆" "㒞" "㕉" "㕎" "㝓" "㞹" "㤩" "㥛" "㪃" "㪙" "㪡" "㪼" "㰤" "㲉" "㲺" "㵣" "㼎" "㾧" "䁍" "䋉" "䕣" "䗘" "䘁" "䙐" "䶗" "兣" "剋" "勀" "勊" "匼" "垎" "堁" "娔" "尅" "峇" "嶱" "愘" "愙" "揢" "搕" "敤" "榼" "樖" "欬" "殻" "殼" "渇" "炣" "犐" "痾" "砢" "碦" "礍" "礚" "簻" "緙" "胢" "萪" "薖" "衉" "課" "趷" "軻" "醘" "鈳" "鉿" "錁" "錒" "閜" "頦" "顆" "騍" "龕"))
  ((("k" "e" "n")) ("肯" "恳" "啃" "垦" "狠" "裉" "颀" "龈" "㸧" "墾" "懇" "掯" "珢" "硍" "肎" "肻" "褃" "豤" "錹" "頎" "齗" "齦" "龂"))
  ((("k" "e" "n" "g")) ("坑" "吭" "胫" "硎" "铿" "䡰" "劥" "坈" "奟" "妔" "挳" "摼" "牼" "硁" "硜" "硻" "脛" "誙" "鉺" "銵" "鍞" "鏗" "阬"))
  ((("k" "o" "n" "g")) ("空" "控" "孔" "恐" "腔" "倥" "崆" "穹" "箜" "㑋" "㤟" "㸜" "埪" "悾" "涳" "矼" "硿" "錓" "鞚" "鵼"))
  ((("k" "o" "u")) ("口" "扣" "寇" "抠" "挎" "佝" "芤" "蔻" "叩" "筘" "㓂" "㔚" "㰯" "㲄" "㽛" "䍍" "䧆" "䳟" "䳹" "冦" "剾" "劶" "宼" "彄" "怐" "摳" "敂" "毆" "溝" "滱" "瞉" "窛" "簆" "蔲" "袧" "釦" "鏂" "鷇" "𦶲"))
  ((("k" "u")) ("苦" "哭" "库" "裤" "酷" "枯" "窟" "挎" "跨" "圣" "刳" "堀" "喾" "绔" "轱" "骷" "㒂" "㠸" "䇢" "䊿" "䔯" "俈" "嚳" "圐" "庫" "扝" "桍" "楛" "焅" "瘔" "矻" "秙" "窋" "絝" "綯" "绹" "胐" "袴" "褲" "趶" "跍" "軲" "郀" "顝" "鮬"))
  ((("k" "u" "a")) ("跨" "夸" "垮" "挎" "胯" "侉" "锞" "髁" "㐄" "㡁" "䋀" "䦚" "咵" "姱" "恗" "晇" "荂" "誇" "銙" "錁" "骻"))
  ((("k" "u" "a" "i")) ("快" "块" "筷" "会" "侩" "魁" "蒯" "郐" "蒉" "呙" "哙" "狯" "浍" "栝" "桧" "脍" "㔞" "㙕" "㙗" "㟴" "㧟" "㨤" "㫎" "㬮" "㭈" "㱮" "㻅" "䈛" "䓒" "䭝" "䯤" "䶐" "儈" "凷" "噲" "塊" "墤" "巜" "廥" "擓" "旝" "會" "檜" "欳" "澮" "獪" "禬" "糩" "膾" "蕢" "鄶" "駃" "鬠" "鱠" "鲙"))
  ((("k" "u" "a" "n")) ("宽" "款" "棵" "颗" "髋" "㮯" "㯘" "䕀" "䤭" "䥗" "䲌" "寛" "寬" "梡" "欵" "歀" "窾" "臗" "顆" "髖"))
  ((("k" "u" "a" "n" "g")) ("况" "矿" "狂" "筐" "框" "眶" "旷" "逛" "磺" "匡" "诓" "诳" "邝" "圹" "夼" "哐" "湟" "纩" "贶" "㑌" "㔞" "㤮" "㫛" "㾠" "䂄" "䊯" "䵃" "俇" "儣" "劻" "匩" "卝" "壙" "岲" "恇" "懬" "懭" "抂" "昿" "曠" "況" "洭" "爌" "眖" "矌" "硄" "礦" "穬" "絖" "纊" "誆" "誑" "貺" "躀" "軭" "迋" "邼" "鄺" "鉱" "鑛" "鵟" "黋"))
  ((("k" "u" "i")) ("亏" "愧" "盔" "葵" "溃" "踩" "归" "岿" "窥" "奎" "魁" "傀" "馈" "顷" "馗" "匮" "夔" "隗" "蒉" "揆" "喹" "喟" "悝" "愦" "逵" "暌" "睽" "聩" "蝰" "篑" "臾" "跬" "觖" "㒑" "㕟" "㙓" "㙺" "㚍" "㚝" "㛻" "㟴" "㡭" "㤬" "㧉" "㨒" "㰐" "㱮" "㷇" "㾠" "䁛" "䇻" "䈐" "䍪" "䏗" "䕚" "䕫" "䖯" "䙆" "䙌" "䙡" "䟸" "䠑" "䤆" "䦱" "䧶" "䫥" "䯓" "䯣" "䰎" "䳫" "刲" "匱" "嘳" "媿" "尯" "巋" "憒" "戣" "撌" "晆" "楏" "楑" "槶" "樻" "櫆" "歸" "湀" "潰" "煃" "犪" "瞆" "瞶" "磈" "窺" "簣" "籄" "聧" "聭" "聵" "腃" "茥" "蔮" "蕢" "藈" "蘬" "蘷" "虁" "虧" "規" "蹞" "躨" "鄈" "鍨" "鍷" "鐀" "鑎" "闋" "闚" "頃" "頄" "頍" "頯" "餽" "饋" "騤" "騩" "骙" "鮭"))
  ((("k" "u" "n")) ("困" "昆" "捆" "混" "坤" "悃" "阃" "巛" "琨" "锟" "醌" "鲲" "髡" "麇" "㕎" "㩲" "㫻" "䠅" "堃" "壸" "壼" "婫" "崐" "崑" "惃" "晜" "梱" "涃" "焜" "猑" "瑻" "睏" "硱" "祵" "稇" "稛" "綑" "菎" "蜫" "裈" "裍" "褌" "貇" "錕" "閫" "閸" "頑" "餛" "騉" "髠" "髨" "鯤" "鰥" "鵾" "鶤" "鹍" "齫" "齳"))
  ((("k" "u" "o")) ("括" "扩" "阔" "廓" "适" "栝" "蛞" "㗥" "㣪" "㨯" "㪙" "䄆" "䄑" "䙃" "䟯" "䦢" "䯺" "噋" "姡" "彉" "彍" "拡" "挄" "擃" "擴" "漷" "濶" "秮" "筈" "鄺" "闊" "霩" "鞟" "鞹" "髺" "鬠"))
  ((("l" "a")) ("啦" "拉" "蜡" "垃" "喇" "辣" "落" "腊" "蓝" "剌" "摺" "邋" "旯" "砬" "瘌" "癞" "㕇" "㸊" "㻋" "㻝" "䀳" "䂰" "䃳" "䏀" "䓥" "䗶" "䝓" "䟑" "䪉" "䱫" "䶛" "嘑" "嚹" "揦" "揧" "搚" "擸" "攋" "柆" "楋" "爉" "瓎" "癩" "磖" "翋" "臈" "臘" "菈" "藍" "藞" "蝋" "蝲" "蠟" "辢" "鑞" "镴" "鞡" "鬎" "鯻" "癩"))
  ((("l" "a" "i")) ("来" "赖" "莱" "崃" "徕" "涞" "濑" "赉" "睐" "铼" "癞" "籁" "黧" "㚓" "㠣" "㥎" "㸊" "㾢" "䀳" "䂾" "䄤" "䅘" "䋱" "䓶" "䚅" "䠭" "䧒" "䲚" "來" "俫" "倈" "勑" "唻" "娕" "婡" "孻" "崍" "庲" "徠" "梾" "棶" "櫴" "淶" "瀨" "瀬" "猍" "琜" "癩" "睞" "筙" "箂" "籟" "萊" "藾" "襰" "賚" "賴" "逨" "郲" "錸" "頼" "顂" "騋" "鯠" "鵣" "鶆" "麳"))
  ((("l" "a" "n")) ("蓝" "烂" "篮" "拦" "览" "栏" "懒" "滥" "郴" "婪" "阑" "兰" "澜" "谰" "揽" "缆" "啉" "岚" "廪" "漤" "榄" "斓" "罱" "镧" "褴" "㑣" "㔋" "㘓" "㘕" "㛦" "㜮" "㞩" "㦨" "㨫" "㩜" "㰖" "㱫" "㳕" "䃹" "䆾" "䊖" "䌫" "䍀" "䑌" "䦨" "䧒" "䪍" "䰐" "䲚" "䳿" "儖" "厱" "嚂" "囒" "壈" "壏" "嬾" "孄" "孏" "嵐" "幱" "惏" "懢" "懶" "擥" "攔" "攬" "斕" "暕" "欄" "欖" "欗" "浨" "漣" "濫" "瀾" "灆" "灠" "灡" "煉" "燗" "燣" "燷" "爁" "爛" "爤" "璼" "瓓" "礛" "礷" "籃" "籣" "糷" "繿" "纜" "葻" "藍" "蘫" "蘭" "襕" "襤" "襴" "覧" "覽" "譋" "讕" "躝" "連" "醂" "鑭" "钄" "闌" "韊" "顲" "𡒄"))
  ((("l" "a" "n" "g")) ("浪" "狼" "朗" "羹" "琅" "榔" "廊" "郎" "莨" "蒗" "啷" "阆" "锒" "稂" "螂" "踉" "㓪" "㙟" "㝗" "㟍" "㢃" "㫰" "㮾" "㱢" "㾗" "㾿" "䀶" "䁁" "䃹" "䆡" "䍚" "䕞" "䡙" "䯖" "䱶" "俍" "勆" "哴" "埌" "塱" "嫏" "崀" "朖" "朤" "桹" "樃" "欴" "烺" "瑯" "硠" "筤" "羮" "艆" "蓈" "蓢" "蜋" "誏" "躴" "郞" "鋃" "鎯" "閬"))
  ((("l" "a" "o")) ("老" "劳" "捞" "牢" "佬" "姥" "酪" "烙" "涝" "潦" "落" "络" "蓼" "唠" "崂" "獠" "栎" "栳" "铑" "铹" "痨" "耢" "醪" "㗦" "㞠" "㟉" "㟙" "㟹" "㧯" "㨓" "䃕" "䇭" "䕩" "䜎" "䝁" "䝤" "䲏" "䳓" "䵏" "僗" "労" "勞" "咾" "哰" "嘮" "嫪" "嶗" "恅" "憥" "憦" "撈" "橑" "橯" "櫟" "浶" "澇" "狫" "癆" "磱" "窂" "簝" "簩" "絡" "耮" "荖" "蟧" "軂" "轑" "銠" "鐒" "髝"))
  ((("l" "e")) ("了" "乐" "勒" "肋" "仂" "捋" "叻" "泐" "鳓" "㔹" "㖀" "㦡" "㨋" "哷" "屴" "忇" "扐" "朸" "楽" "樂" "氻" "玏" "砳" "竻" "簕" "脟" "艻" "阞" "韷" "頱" "餎" "饹" "鰳" "𡃖"))
  ((("l" "e" "i")) ("类" "泪" "累" "雷" "垒" "勒" "磊" "镭" "蕾" "儡" "擂" "肋" "羸" "诔" "埒" "嘞" "漯" "嫘" "缧" "檑" "耒" "酹" "㑍" "㒍" "㒦" "㔣" "㙼" "㡞" "㭩" "㰐" "㲕" "㲺" "㴃" "㵢" "㵽" "㶟" "㹎" "㻋" "㼍" "㿔" "䉂" "䉓" "䉪" "䍣" "䍥" "䐯" "䒹" "䛶" "䢮" "䣂" "䣦" "䨓" "䮑" "䴎" "傫" "儽" "厽" "囄" "壘" "壨" "攂" "樏" "櫐" "櫑" "欙" "洡" "涙" "淚" "灅" "瓃" "畾" "瘣" "癗" "磥" "礌" "礧" "礨" "禷" "絫" "縲" "纇" "纍" "纝" "罍" "蕌" "藟" "蘱" "蘲" "蘽" "虆" "蠝" "誄" "讄" "轠" "銇" "錑" "鐳" "鑘" "鑸" "靁" "頛" "頪" "類" "颣" "鸓" "鼺" "𩔗"))
  ((("l" "e" "n" "g")) ("冷" "愣" "棱" "楞" "塄" "䉄" "䚏" "䬋" "䮚" "倰" "堎" "崚" "睖" "碐" "稜" "薐" "踜" "輘"))
  ((("l" "i")) ("里" "力" "理" "利" "立" "历" "离" "例" "哩" "丽" "璃" "厉" "礼" "粒" "励" "隶" "厘" "李" "黎" "荔" "沥" "狸" "篱" "梨" "鹂" "鲤" "犁" "砾" "类" "漓" "莉" "吏" "栗" "傈" "俐" "痢" "泣" "鬲" "俪" "俚" "郦" "坜" "苈" "莅" "蓠" "藜" "捩" "呖" "唳" "喱" "猁" "悝" "溧" "澧" "逦" "娌" "嫠" "骊" "缡" "珞" "枥" "栎" "轹" "牦" "戾" "砺" "砬" "硌" "詈" "罹" "锂" "镉" "疠" "疬" "蛎" "蜊" "蠡" "笠" "篥" "粝" "翮" "酾" "醴" "跞" "雳" "霾" "鲡" "鳢" "髦" "黧" "㑦" "㒧" "㒿" "㓯" "㔏" "㕸" "㗚" "㘑" "㟳" "㠟" "㠣" "㡂" "㤡" "㤦" "㥎" "㦒" "㧰" "㬏" "㮚" "㯤" "㰀" "㰚" "㱹" "㴃" "㴝" "㷰" "㷴" "㸚" "㹈" "㺡" "㻎" "㻺" "㼖" "㽁" "㽝" "㾐" "㾖" "㿛" "㿨" "䁻" "䃯" "䄜" "䅄" "䅻" "䇐" "䉫" "䊍" "䊪" "䋥" "䍠" "䍥" "䍦" "䍽" "䓞" "䔁" "䔆" "䔉" "䔣" "䔧" "䕻" "䖥" "䖽" "䖿" "䗍" "䗶" "䘈" "䙰" "䚏" "䚕" "䟏" "䟐" "䡃" "䣓" "䣫" "䤙" "䤚" "䥶" "䧉" "䬅" "䬆" "䮋" "䮥" "䰛" "䰜" "䱘" "䲞" "䴄" "䴡" "䴻" "䵓" "䵩" "䶘" "儮" "儷" "兣" "凓" "刕" "剓" "剺" "劙" "勵" "厤" "厯" "厲" "叓" "唎" "嚟" "嚦" "囄" "囇" "塛" "壢" "婯" "孋" "孷" "屴" "岦" "峛" "峢" "峲" "巁" "廲" "悡" "悧" "悷" "慄" "戻" "搮" "摛" "擽" "攊" "攡" "攦" "攭" "斄" "暦" "曆" "曞" "朸" "杝" "栛" "栵" "梩" "梸" "棃" "棙" "樆" "櫔" "櫟" "櫪" "欐" "欚" "歴" "歷" "氂" "沴" "浬" "浰" "涖" "淚" "漦" "濼" "濿" "瀝" "灑" "灕" "爄" "爏" "犂" "犛" "犡" "珕" "琍" "瑮" "瓅" "瓈" "瓑" "瓥" "癘" "癧" "皪" "盠" "盭" "睝" "矋" "砅" "磿" "礪" "礫" "礰" "禮" "禲" "秜" "秝" "穲" "筣" "籬" "粍" "粚" "粴" "糎" "糲" "綟" "縭" "纅" "纚" "脷" "艃" "苙" "茘" "菞" "蒞" "蔾" "薶" "藶" "蘺" "蚸" "蛠" "蜧" "蝕" "蝷" "蟍" "蟸" "蠇" "蠣" "蠫" "裏" "裡" "褵" "謧" "讈" "豊" "貍" "赲" "躒" "轢" "轣" "迣" "邌" "邐" "酈" "醨" "釃" "釐" "鉝" "鋫" "鋰" "錅" "鎘" "鏫" "鑗" "鑠" "隷" "隸" "離" "雴" "靂" "靋" "類" "颯" "騹" "驪" "鬁" "鯉" "鯬" "鱧" "鱱" "鱳" "鱺" "鳨" "鴗" "鵹" "鷅" "鷑" "鸝" "麗" "麜" "黐" "礼" "𠩺" "𥝢" "𩔗"))
  ((("l" "i" "a")) ("俩" "倆"))
  ((("l" "i" "a" "n")) ("连" "脸" "联" "炼" "练" "怜" "帘" "镰" "廉" "恋" "链" "捡" "栏" "莲" "涟" "敛" "零" "碾" "粘" "羸" "苓" "莶" "蔹" "奁" "潋" "濂" "娈" "琏" "楝" "殓" "臁" "膦" "瞵" "裢" "裣" "蠊" "鲢" "㓎" "㜃" "㜕" "㜻" "㝺" "㟀" "㡘" "㢘" "㥕" "㦁" "㦑" "㪘" "㪝" "㯬" "㰈" "㰸" "㱨" "㶌" "㶑" "㺦" "㼑" "㼓" "㾾" "䁠" "䃛" "䆂" "䇜" "䌞" "䏈" "䐄" "䙺" "䥥" "䨬" "䭑" "亷" "僆" "劆" "匲" "匳" "嗹" "噒" "堜" "奩" "奱" "媡" "嫾" "嬚" "孌" "慩" "憐" "戀" "摙" "撿" "攣" "斂" "梿" "槤" "櫣" "欄" "歛" "殮" "浰" "涊" "淰" "湅" "溓" "漣" "澰" "濓" "瀲" "煉" "熑" "燫" "瑓" "璉" "磏" "稴" "簾" "籢" "籨" "練" "縺" "纞" "羷" "翴" "聫" "聮" "聯" "膁" "臉" "萰" "蓮" "薕" "薟" "蘝" "蘞" "螊" "褳" "襝" "覝" "謰" "譧" "蹥" "連" "鄻" "錬" "鍊" "鎌" "鏈" "鐮" "鬑" "鰊" "鰱" "𢅏"))
  ((("l" "i" "a" "n" "g")) ("两" "量" "亮" "粮" "良" "辆" "凉" "梁" "谅" "晾" "惊" "俩" "粱" "墚" "莨" "阆" "椋" "踉" "魉" "㒳" "㔝" "㹁" "㾗" "䀶" "䁁" "䓣" "䝶" "䠃" "䣼" "䩫" "䭪" "両" "倆" "倞" "兩" "哴" "唡" "啢" "喨" "悢" "掚" "樑" "涼" "湸" "糧" "綡" "緉" "脼" "蜽" "裲" "諒" "蹣" "輌" "輛" "輬" "辌" "鍄" "靚" "駺" "魎"))
  ((("l" "i" "a" "o")) ("料" "了" "疗" "僚" "辽" "聊" "撩" "撂" "乐" "燎" "寥" "潦" "镣" "廖" "蓼" "尥" "嘹" "獠" "寮" "缪" "缭" "钌" "鹨" "鹩" "㙩" "㜃" "㝋" "㞠" "㡻" "㨓" "㵳" "㶫" "㺒" "䄦" "䉼" "䍡" "䎆" "䑠" "䕞" "䜍" "䜮" "䝀" "䢧" "䣈" "䨅" "䩍" "嫽" "尞" "尦" "屪" "嵺" "嶚" "嶛" "廫" "憀" "憭" "摎" "敹" "暸" "樂" "橑" "漻" "炓" "熮" "爒" "璙" "療" "瞭" "窷" "簝" "繆" "繚" "翏" "膋" "膫" "蟉" "蟟" "豂" "賿" "蹘" "蹽" "轑" "遼" "鄝" "釕" "鐐" "镽" "顟" "飂" "飉" "髎" "鷚" "鷯"))
  ((("l" "i" "e")) ("烈" "列" "猎" "裂" "咧" "劣" "膊" "累" "冽" "埒" "捩" "洌" "邋" "戾" "趔" "躐" "鬣" "㤠" "㧜" "㬯" "㭞" "㯿" "㲱" "㸊" "㸹" "㻺" "㼲" "㽟" "䁽" "䅀" "䉭" "䓟" "䜲" "䝓" "䟩" "䟹" "䪉" "䮋" "䴕" "䶛" "儠" "劽" "埓" "姴" "巤" "挒" "擸" "浖" "煭" "爉" "犣" "獵" "痎" "睙" "聗" "脟" "茢" "蛚" "蛶" "迾" "颲" "鬛" "鮤" "鱲" "鴷" "𤢪"))
  ((("l" "i" "n")) ("林" "临" "淋" "邻" "磷" "琳" "霖" "鳞" "凛" "赁" "吝" "禀" "蔺" "啉" "嶙" "廪" "懔" "遴" "檩" "辚" "膦" "瞵" "粼" "躏" "麟" "㐭" "㔂" "㖁" "㖼" "㝝" "㝺" "㨆" "㷠" "䉮" "䕲" "䗲" "䚏" "䚬" "䟹" "䢧" "䢯" "䫐" "䫰" "䮼" "亃" "僯" "凜" "厸" "壣" "廩" "恡" "悋" "惏" "懍" "撛" "斴" "晽" "暽" "橉" "檁" "滲" "潾" "澟" "瀶" "焛" "燐" "獜" "璘" "甐" "疄" "痳" "癛" "癝" "矝" "碄" "稟" "箖" "粦" "綝" "繗" "罧" "翷" "臨" "菻" "藺" "賃" "蹸" "躙" "躪" "轔" "轥" "鄰" "鏻" "閵" "隣" "驎" "鱗" "麐"))
  ((("l" "i" "n" "g")) ("领" "另" "令" "零" "灵" "铃" "岭" "龄" "陵" "伶" "玲" "棱" "磷" "拎" "菱" "羚" "凌" "酃" "苓" "呤" "囹" "泠" "绫" "柃" "棂" "瓴" "聆" "蛉" "翎" "鲮" "㖫" "㡵" "㥄" "㦭" "㪮" "㬡" "㭩" "㯪" "㱥" "㲆" "㸳" "㻏" "㾉" "䄥" "䈊" "䉁" "䉖" "䉹" "䌢" "䍅" "䔖" "䕘" "䖅" "䙥" "䚖" "䠲" "䡼" "䡿" "䧙" "䨩" "䯍" "䰱" "䴇" "䴒" "䴫" "倰" "刢" "坽" "夌" "姈" "孁" "岺" "嶺" "彾" "掕" "昤" "朎" "櫺" "欞" "淩" "澪" "炩" "燯" "爧" "狑" "琌" "皊" "睖" "砱" "碐" "祾" "秢" "稜" "竛" "笭" "紷" "綾" "舲" "蔆" "蕶" "蘦" "衑" "袊" "裬" "詅" "跉" "軨" "輘" "醽" "釘" "鈴" "錂" "閝" "阾" "霊" "霛" "霝" "靈" "領" "駖" "魿" "鯪" "鴒" "鸰" "鹷" "麢" "齡" "齢" "龗"))
  ((("l" "i" "u")) ("流" "六" "留" "榴" "柳" "溜" "硫" "泵" "聊" "琉" "馏" "刘" "瘤" "碌" "陆" "铆" "游" "蒌" "蓼" "泖" "浏" "遛" "骝" "绺" "旒" "熘" "锍" "镏" "鎏" "㐬" "㙀" "㝋" "㧕" "㨨" "㳅" "㵳" "㶯" "㽌" "㽞" "䄂" "䉧" "䉹" "䋷" "䒥" "䗜" "䚧" "䝀" "䬟" "䭷" "䰘" "䱖" "䱞" "䶉" "劉" "嚠" "坴" "塯" "媹" "嬼" "嵧" "廇" "懰" "摎" "斿" "旈" "栁" "桺" "橊" "橮" "沠" "漻" "澑" "瀏" "珋" "瑠" "瑬" "璢" "畂" "畄" "畱" "疁" "癅" "磂" "磟" "綹" "罶" "羀" "翏" "膢" "蒥" "蓅" "蔞" "藰" "蟉" "裗" "蹓" "鉚" "鋶" "鎦" "鏐" "鐂" "镠" "陸" "雡" "霤" "飀" "飂" "飅" "飗" "飹" "餾" "駠" "駵" "騮" "驑" "鬸" "鰡" "鶹" "鷚" "鹠" "麍"))
  ((("l" "o")) ("咯"))
  ((("l" "o" "n" "g")) ("龙" "拢" "隆" "笼" "胧" "垄" "咙" "窿" "珑" "聋" "陇" "弄" "垅" "茏" "泷" "栊" "砻" "癃" "㑝" "㙙" "㚅" "㛞" "㝫" "㟖" "㡣" "㢅" "㦕" "㰍" "㳥" "㴳" "䃧" "䆍" "䏊" "䙪" "䡁" "䥢" "䪊" "儱" "哢" "嚨" "壟" "壠" "屸" "嶐" "巃" "巄" "徿" "挵" "攏" "昽" "曨" "朧" "梇" "櫳" "湰" "滝" "漋" "瀧" "爖" "瓏" "眬" "矓" "硦" "礱" "礲" "竉" "竜" "篢" "篭" "簼" "籠" "聾" "蕯" "蘢" "蝕" "蠪" "蠬" "衖" "襱" "豅" "贚" "躘" "鏧" "鑨" "隴" "霳" "靇" "鸗" "龍" "龒" "龓"))
  ((("l" "o" "u")) ("楼" "漏" "喽" "搂" "陋" "牢" "娄" "篓" "露" "偻" "蒌" "嵝" "镂" "瘘" "窭" "耧" "蝼" "髅" "㔷" "㟺" "㡞" "㥪" "㪹" "㲎" "㺏" "䁖" "䄛" "䅹" "䝏" "䣚" "䫫" "䮫" "䱾" "僂" "剅" "嘍" "囉" "塿" "婁" "寠" "屚" "嶁" "廔" "慺" "摟" "樓" "溇" "漊" "熡" "甊" "瘺" "瘻" "瞜" "窶" "簍" "耬" "膢" "艛" "蔞" "螻" "謱" "軁" "遱" "鏤" "鞻" "髏" "鷜"))
  ((("l" "u")) ("路" "露" "陆" "炉" "录" "芦" "虏" "碌" "鹿" "谷" "角" "酪" "六" "卢" "颅" "庐" "掳" "卤" "鲁" "麓" "赂" "潞" "禄" "戮" "绿" "垆" "蓼" "撸" "噜" "泸" "渌" "漉" "逯" "璐" "栌" "橹" "轳" "辂" "辘" "胪" "镥" "鸬" "鹭" "瘳" "簏" "舻" "鲈" "㓐" "㔪" "㖨" "㛬" "㜙" "㟤" "㠠" "㢚" "㢳" "㦇" "㪐" "㪖" "㪭" "㪹" "㫽" "㭔" "㯝" "㯟" "㯭" "㱺" "㼾" "㿖" "䃙" "䌒" "䍡" "䎑" "䎼" "䐂" "䕡" "䘵" "䚄" "䟿" "䡎" "䡜" "䩮" "䮉" "䰕" "䱚" "䲐" "䴪" "侓" "僇" "剹" "勎" "勠" "嚕" "嚧" "圥" "垏" "塷" "壚" "娽" "峍" "廘" "廬" "彔" "摝" "擄" "擼" "攎" "曥" "椂" "樐" "樚" "櫓" "櫨" "氌" "淕" "淥" "滷" "瀂" "瀘" "熝" "爐" "獹" "玈" "琭" "璷" "瓐" "甪" "盝" "盧" "睩" "矑" "硉" "硵" "磟" "磠" "祿" "稑" "穋" "箓" "簬" "簵" "簶" "籙" "籚" "粶" "綠" "纑" "罏" "膔" "臚" "艣" "艪" "艫" "菉" "蓾" "蔍" "蕗" "蘆" "虂" "虜" "螰" "蠦" "觮" "觻" "賂" "趢" "踛" "蹗" "輅" "轆" "轤" "醁" "錄" "録" "錴" "鏀" "鏕" "鏴" "鐪" "鑥" "鑪" "陸" "顱" "騄" "騼" "髗" "魯" "魲" "鯥" "鱸" "鵦" "鵱" "鷺" "鸕" "鹵" "黸" "𡀔"))
  ((("l" "u" "a" "n")) ("乱" "卵" "峦" "挛" "孪" "滦" "脔" "娈" "栾" "鸾" "銮" "㝈" "㡩" "㰸" "㱍" "㼑" "䖂" "䚕" "䜌" "亂" "圝" "圞" "孌" "孿" "巒" "攣" "曫" "欒" "灓" "灤" "癴" "癵" "羉" "脟" "臠" "薍" "虊" "釠" "鑾" "鵉" "鸞"))
  ((("l" "u" "e")) ("掠" "略" "锊"))
  ((("l" "u" "n")) ("论" "轮" "纶" "抡" "伦" "仑" "沦" "囵" "㕢" "㖮" "㷍" "䈁" "䑳" "侖" "倫" "圇" "埨" "婨" "崘" "崙" "惀" "掄" "棆" "淪" "溣" "碖" "稐" "綸" "耣" "腀" "菕" "蜦" "論" "踚" "輪" "錀" "陯" "鯩"))
  ((("l" "u" "o")) ("落" "骆" "锣" "络" "萝" "逻" "骡" "箩" "铬" "果" "酪" "烙" "乐" "碌" "路" "螺" "罗" "裸" "洛" "烁" "倮" "蠃" "荦" "捋" "摞" "猓" "猡" "泺" "漯" "珞" "椤" "橐" "氇" "脶" "硌" "镙" "瘰" "袼" "蜾" "蠡" "跞" "雒" "㑩" "㒩" "㓢" "㕵" "㖀" "㦬" "㩡" "㪾" "㮝" "㰁" "㱻" "㴖" "㵣" "㼈" "㽋" "㾖" "㿚" "䀩" "䃕" "䇔" "䈁" "䈷" "䉓" "䉿" "䊨" "䌱" "䌴" "䎅" "䙨" "䯁" "䲞" "儸" "啰" "嗠" "囉" "峈" "擽" "攞" "曪" "樂" "欏" "氌" "濼" "爍" "犖" "玀" "癳" "砢" "礫" "笿" "籮" "絡" "纙" "羅" "腡" "臝" "蓏" "蔂" "蘿" "蝸" "蟸" "覙" "覶" "覼" "詻" "躒" "躶" "邏" "鉻" "鎯" "鏍" "鑼" "饠" "駱" "騾" "驘" "鮥" "鴼" "鵅" "鸁"))
  ((("l" "v")) ("律" "绿" "率" "旅" "虑" "驴" "铝" "缕" "累" "垒" "鹿" "录" "吕" "侣" "履" "屡" "氯" "滤" "偻" "捋" "嵝" "闾" "榈" "膂" "稆" "瘘" "褛" "㔧" "㠥" "㡞" "㢳" "㭚" "㲶" "㻲" "㾔" "䔞" "䕡" "䝏" "䢖" "䣚" "䥨" "䮉" "䮫" "侶" "僂" "儢" "勴" "呂" "壘" "寽" "屢" "嵂" "嶁" "慮" "挔" "捛" "攞" "梠" "樓" "櫖" "櫚" "氀" "溇" "漊" "濾" "爈" "瘻" "祣" "穞" "穭" "箻" "簍" "絽" "綠" "緑" "縷" "膐" "膟" "膢" "臚" "葎" "蔞" "藘" "褸" "謱" "郘" "鋁" "録" "鏤" "鑢" "閭" "鞻" "馿" "驢" "魯"))
  ((("l" "v" "e")) ("撂" "率" "掠" "略" "锊" "㑼" "㔀" "㗉" "㨼" "䂮" "䌎" "䛚" "䤚" "䤣" "剠" "圙" "擽" "畧" "稤" "藥" "鋝" "鋢"))
  ((("m")) ("呒"))
  ((("m" "a")) ("吗" "妈" "马" "嘛" "骂" "麻" "码" "蚂" "蟆" "抹" "貉" "玛" "么" "靡" "摩" "唛" "犸" "嬷" "杩" "麽" "㐷" "㑻" "㜫" "㦄" "㨸" "㾺" "䗫" "䠋" "䠨" "䣕" "䣖" "䧞" "䯦" "䳸" "傌" "嗎" "嘜" "嚜" "媽" "嬤" "孖" "帓" "擵" "攠" "榪" "溤" "犘" "獁" "瑪" "痲" "睰" "碼" "祃" "禡" "罵" "菻" "蔴" "螞" "蟇" "貈" "鎷" "閁" "馬" "駡" "驀" "鰢" "鷌" "麼" "𥉵"))
  ((("m" "a" "i")) ("买" "卖" "麦" "脉" "埋" "迈" "狸" "派" "劢" "荬" "霾" "㜥" "㦟" "㼮" "䁲" "䈿" "䘑" "䚑" "䜕" "䨪" "䨫" "䮮" "䳸" "佅" "勱" "嘪" "売" "眿" "脈" "蕒" "薶" "蝐" "衇" "貍" "買" "賣" "邁" "霡" "霢" "鷶" "麥"))
  ((("m" "a" "n")) ("满" "慢" "漫" "馒" "瞒" "埋" "蛮" "蔓" "曼" "谩" "墁" "幔" "缦" "熳" "镘" "颟" "螨" "蹒" "鳗" "鞔" "㒼" "㗄" "㗈" "㙢" "㛧" "㡢" "㬅" "㵘" "䅼" "䊡" "䐽" "䑱" "䒥" "䕕" "䛲" "䜱" "䝡" "䝢" "䟂" "䡬" "䨫" "䯶" "䰋" "僈" "姏" "嫚" "屘" "悗" "慲" "摱" "槾" "樠" "満" "滿" "澫" "澷" "獌" "璊" "瞞" "矕" "縵" "蔄" "蟎" "蠻" "襔" "謾" "蹣" "鄤" "鏋" "鏝" "顢" "饅" "鬗" "鬘" "鮸" "鰻"))
  ((("m" "a" "n" "g")) ("忙" "茫" "盲" "芒" "氓" "龙" "莽" "蒙" "邙" "瞢" "漭" "硭" "蟒" "㙁" "㜃" "㝑" "㟌" "㟐" "㟿" "㡛" "㬒" "㵃" "㻊" "䀮" "䁳" "䅒" "䈍" "䒎" "䓼" "䖟" "䙪" "䟥" "䵨" "厖" "吂" "哤" "壾" "奀" "娏" "尨" "庬" "恾" "杗" "杧" "汒" "浝" "牤" "牻" "狵" "痝" "盳" "矒" "硥" "笀" "茻" "莾" "蘉" "蛖" "蠎" "釯" "鋩" "铓" "駹" "鼆" "龍"))
  ((("m" "a" "o")) ("毛" "矛" "帽" "冒" "貌" "猫" "贸" "茂" "茅" "髦" "牦" "耗" "锚" "铆" "卯" "牟" "袤" "茆" "峁" "泖" "瑁" "昴" "耄" "旄" "懋" "瞀" "蝥" "蟊" "㒵" "㒻" "㚹" "㝟" "㡌" "㧇" "㧌" "㪞" "㫯" "㬒" "㮘" "㲠" "㴘" "㹈" "㺺" "㿞" "䀤" "䅦" "䋃" "䓮" "䖥" "䡚" "䫉" "䭷" "兞" "冇" "冐" "堥" "夘" "媌" "媢" "嫹" "戼" "暓" "枆" "柕" "楙" "毣" "毷" "氂" "渵" "犛" "皃" "眊" "瞐" "笷" "罞" "艒" "芼" "萺" "蓩" "覒" "貓" "貿" "軞" "鄮" "酕" "鉚" "錨" "髳" "鶜"))
  ((("m" "e")) ("么" "没" "麽" "嚜" "麼"))
  ((("m" "e" "i")) ("没" "每" "美" "煤" "妹" "眉" "梅" "霉" "昧" "枚" "镁" "酶" "玫" "媒" "寐" "媚" "靡" "糜" "迷" "谜" "莓" "嵋" "猸" "浼" "湄" "瑁" "楣" "镅" "鹛" "袂" "魅" "㙁" "㜫" "㡌" "㭑" "㶬" "㺳" "䀛" "䀜" "䆀" "䉋" "䊈" "䊊" "䍙" "䒽" "䓺" "䜸" "䞼" "䤂" "䰨" "䰪" "䵢" "侎" "凂" "呅" "堳" "塺" "媄" "媺" "嬍" "嵄" "徾" "抺" "挴" "攗" "栂" "楳" "槑" "毎" "沒" "沬" "渼" "湈" "煝" "燘" "珻" "瑂" "痗" "眛" "睂" "睸" "祙" "禖" "穈" "篃" "脄" "脢" "腜" "膴" "苺" "葿" "蝐" "蝞" "謎" "跊" "郿" "鋂" "鎂" "鎇" "韎" "鬽" "鶥" "黣" "黴" "𪃏"))
  ((("m" "e" "n")) ("们" "门" "闷" "瞒" "满" "扪" "汶" "焖" "懑" "钔" "鞔" "㙢" "㡈" "㥃" "㦖" "㨺" "㱪" "㵍" "㻊" "䊟" "䝧" "䫒" "亹" "們" "悗" "悶" "懣" "捫" "暪" "樠" "滿" "燜" "璊" "瞞" "穈" "菛" "虋" "鍆" "門" "閅"))
  ((("m" "e" "n" "g")) ("猛" "梦" "盟" "蒙" "朦" "氓" "萌" "檬" "锰" "孟" "勐" "苎" "甍" "瞢" "懵" "礞" "瞑" "虻" "蜢" "蟒" "蟊" "蠓" "艋" "艨" "黾" "㙹" "㚞" "㜴" "㝱" "㠓" "㩚" "㻊" "㽇" "䀄" "䁅" "䇇" "䉚" "䏵" "䑃" "䑅" "䒐" "䓝" "䖟" "䗈" "䙦" "䙩" "䝢" "䟥" "䠢" "䤓" "䥂" "䥰" "䰒" "䲛" "䴌" "䴿" "䵆" "儚" "冡" "夢" "夣" "尨" "幪" "懜" "懞" "曚" "橗" "氋" "溕" "濛" "獴" "瓾" "甿" "矇" "矒" "莔" "萠" "蕄" "蝱" "蠎" "鄳" "鄸" "錳" "雺" "霥" "霧" "霿" "靀" "饛" "鯍" "鯭" "鸏" "鹲" "黽" "鼆"))
  ((("m" "i")) ("米" "密" "秘" "迷" "蜜" "眯" "弥" "泌" "辟" "醚" "靡" "糜" "谜" "觅" "幂" "日" "芈" "佴" "冖" "谧" "蘼" "咪" "嘧" "猕" "汨" "溟" "宓" "弭" "脒" "祢" "敉" "糸" "縻" "麋" "㘠" "㜆" "㜷" "㝥" "㟜" "㠧" "㣆" "㥝" "㦄" "㨠" "㨺" "㩢" "㫘" "㰽" "㳴" "㳽" "㴵" "㵋" "㵥" "㸏" "㸓" "䀣" "䁇" "䈿" "䉲" "䉾" "䊫" "䊳" "䋛" "䋳" "䌏" "䌐" "䌕" "䌘" "䌩" "䍘" "䕳" "䕷" "䖑" "䛉" "䛑" "䛧" "䣥" "䣾" "䤉" "䤍" "䥸" "䪾" "䭧" "䭩" "䮭" "䱊" "䴢" "侎" "冞" "冪" "塓" "孊" "宻" "峚" "幎" "幦" "彌" "戂" "擟" "擵" "攠" "榓" "樒" "檷" "櫁" "沕" "沵" "洣" "淧" "淿" "渳" "滵" "漞" "濔" "濗" "瀰" "灖" "熐" "爢" "狝" "獮" "獼" "瓕" "眫" "瞇" "祕" "禰" "簚" "籋" "罙" "羃" "羋" "葞" "蒾" "蔝" "蔤" "藌" "蘪" "蠠" "覓" "覔" "覛" "詸" "謎" "謐" "醾" "醿" "釄" "銤" "鑖" "镾" "鸍" "麊" "麑" "麛" "鼏" "𨢥"))
  ((("m" "i" "a" "n")) ("面" "棉" "免" "眠" "勉" "绵" "冕" "娩" "缅" "沔" "泯" "渑" "湎" "宀" "腼" "眄" "瞑" "黾" "㐷" "㒙" "㛯" "㝃" "㝰" "㤁" "㥝" "㨺" "㫘" "㬆" "㮌" "㰃" "㴐" "㻰" "䀎" "䃇" "䌏" "䏃" "䛉" "䤄" "䫵" "䰓" "丏" "俛" "偭" "勔" "厸" "喕" "婂" "媔" "嬵" "愐" "檰" "櫋" "汅" "澠" "矈" "矊" "矏" "糆" "絻" "綿" "緜" "緡" "緬" "臱" "芇" "莬" "葂" "蝒" "醎" "靣" "靦" "鮸" "麪" "麫" "麵" "麺" "黽"))
  ((("m" "i" "a" "o")) ("秒" "妙" "苗" "描" "庙" "渺" "瞄" "钞" "猫" "藐" "喵" "邈" "缈" "缪" "杪" "淼" "眇" "鹋" "蜱" "㑤" "㠺" "㦝" "㷅" "䁧" "䅺" "䖢" "劰" "媌" "庿" "廟" "玅" "竗" "篎" "紗" "緢" "緲" "繆" "訬" "鈔" "鱙" "鶓"))
  ((("m" "i" "e")) ("灭" "蔑" "乜" "芈" "咩" "蠛" "篾" "㒝" "㩢" "䁾" "䈼" "䌩" "䘊" "䩏" "吀" "哶" "孭" "幭" "懱" "搣" "櫗" "滅" "烕" "眜" "礣" "羋" "薎" "衊" "覕" "鑖" "鱴" "鴓"))
  ((("m" "i" "n")) ("民" "敏" "抿" "昏" "眠" "皿" "悯" "闽" "绳" "苠" "岷" "闵" "汶" "泯" "渑" "缗" "玟" "珉" "愍" "黾" "鳘" "㞶" "㟩" "㟭" "㢯" "㥸" "㨉" "㬆" "㮌" "䁕" "䂥" "䃉" "䋋" "䝧" "䞀" "䟨" "䡅" "䡑" "䡻" "䪸" "䲄" "䶔" "僶" "冺" "刡" "勄" "姄" "崏" "忞" "忟" "怋" "慜" "憫" "捪" "敃" "敯" "旻" "旼" "昬" "暋" "湣" "潣" "澠" "琘" "瑉" "痻" "盿" "砇" "碈" "笢" "簢" "緍" "緡" "繩" "罠" "賯" "鈱" "錉" "鍲" "閔" "閩" "閺" "鰵" "黽"))
  ((("m" "i" "n" "g")) ("命" "明" "名" "鸣" "萌" "盟" "皿" "螟" "铭" "冥" "茗" "溟" "暝" "瞑" "酩" "㝠" "㟰" "㫥" "䄙" "䆨" "䆩" "䊅" "䒌" "䤉" "䫤" "䳟" "佲" "凕" "姳" "嫇" "慏" "朙" "榠" "洺" "猽" "眀" "眳" "蓂" "覭" "詺" "鄍" "銘" "鳴"))
  ((("m" "i" "u")) ("谬" "缪" "繆" "謬"))
  ((("m" "o")) ("模" "摸" "默" "漠" "磨" "膜" "魔" "末" "抹" "墨" "没" "莫" "寞" "陌" "沫" "摩" "蘑" "百" "貉" "嘿" "脉" "冒" "么" "靡" "藐" "摹" "帕" "袜" "万" "无" "谟" "茉" "蓦" "馍" "嫫" "殁" "镆" "秣" "瘼" "耱" "蟆" "貊" "貘" "麽" "㜥" "㠢" "㱄" "㱳" "㶬" "㷬" "㷵" "㹮" "㾺" "䁼" "䁿" "䃺" "䉑" "䌕" "䏞" "䒬" "䘃" "䘑" "䜆" "䤉" "䩋" "䬴" "䭩" "䮬" "䯢" "䱅" "䳟" "䳮" "䴲" "冐" "劘" "嗼" "嚜" "嚤" "嚰" "圽" "塺" "塻" "妺" "嫼" "帞" "庅" "慔" "懡" "擵" "攠" "昩" "暯" "枺" "橅" "歾" "歿" "沒" "洦" "湐" "瀎" "無" "爅" "獏" "皌" "眜" "眽" "瞙" "砞" "礳" "粖" "糢" "絈" "縸" "纆" "脈" "莈" "藦" "蛨" "蟔" "衇" "袹" "覛" "謨" "謩" "貃" "貈" "鄚" "銆" "鏌" "霡" "靺" "鞨" "饃" "饝" "驀" "髍" "鬕" "魩" "麼" "黙" "𠬛"))
  ((("m" "o" "u")) ("某" "谋" "冒" "牟" "毋" "侔" "袤" "厶" "哞" "缪" "眸" "瞀" "蛑" "蝥" "鍪" "㖼" "㭌" "㼋" "䋷" "䍒" "䏬" "䗋" "䥐" "䦈" "䱕" "劺" "恈" "愗" "敄" "桙" "洠" "瞴" "繆" "蟱" "謀" "踇" "鉾" "霿" "鞪" "鴾" "麰"))
  ((("m" "u")) ("目" "母" "木" "幕" "亩" "牧" "模" "慕" "墓" "姆" "拇" "牡" "穆" "姥" "莫" "牟" "暮" "募" "睦" "仫" "坶" "苜" "沐" "缪" "毪" "钼" "鹜" "㒇" "㙁" "㜈" "㟂" "㣎" "㧅" "㫛" "㾇" "䀲" "䁼" "䊾" "䑵" "䥈" "䧔" "䮸" "䱯" "峔" "幙" "恈" "楘" "橅" "毣" "氁" "炑" "牳" "狇" "獏" "畂" "畆" "畒" "畝" "畞" "畮" "砪" "縸" "繆" "胟" "艒" "莯" "蚞" "譕" "鉧" "鉬" "雮" "霂" "鞪" "鶩"))
  ((("n")) ("嗯" "唔" "㐻"))
  ((("n" "a")) ("那" "哪" "拿" "纳" "呐" "钠" "娜" "南" "絮" "讷" "捺" "肭" "镎" "衲" "箬" "㗙" "㙁" "㧱" "㨥" "㭯" "㴸" "䀑" "䅞" "䇣" "䇱" "䈫" "䎎" "䏧" "䖓" "䖧" "䛔" "䞕" "䟜" "䪏" "䫱" "䱹" "乸" "內" "吶" "嗱" "妠" "拏" "挐" "淰" "痆" "笝" "納" "蒳" "袦" "訤" "訥" "誽" "豽" "貀" "軜" "鈉" "鎿" "雫" "靹" "魶"))
  ((("n" "a" "i")) ("奶" "耐" "乃" "奈" "氖" "能" "鼐" "佴" "艿" "萘" "柰" "㚷" "㜨" "㜷" "㮈" "㮏" "㲡" "㾍" "䅞" "䍲" "䘅" "䯮" "䱞" "倷" "儞" "妳" "嬭" "廼" "摨" "榒" "渿" "熋" "疓" "耏" "螚" "褦" "迺" "釢" "錼"))
  ((("n" "a" "n")) ("难" "南" "男" "喃" "囝" "囡" "楠" "腩" "罱" "蝻" "赧" "㓓" "㫱" "㬮" "㽖" "䁪" "䈒" "䊖" "䔜" "䔳" "䕼" "䛁" "䶲" "侽" "奻" "娚" "婻" "戁" "揇" "暔" "枏" "枬" "柟" "湳" "灘" "畘" "莮" "萳" "諵" "難"))
  ((("n" "a" "n" "g")) ("囊" "攮" "囔" "馕" "曩" "㒄" "㶞" "䂇" "乪" "儾" "嚢" "孃" "欜" "灢" "蠰" "饢" "齉"))
  ((("n" "a" "o")) ("脑" "闹" "恼" "挠" "淖" "孬" "垴" "呶" "猱" "瑙" "桡" "硇" "铙" "蛲" "㑎" "㛴" "㞪" "㧘" "㺀" "㺁" "䃩" "䄩" "䑋" "䙹" "䛝" "䜀" "䜧" "䫸" "䴃" "匘" "堖" "夒" "嫐" "峱" "嶩" "巎" "巙" "怓" "悩" "惱" "憹" "撓" "橈" "澆" "獶" "獿" "碯" "繷" "腝" "腦" "臑" "蟯" "詉" "譊" "鐃" "閙" "髐" "鬧" "𡿺" "𢜸" "𥑪"))
  ((("n" "e")) ("呐" "呢" "哪" "那" "讷" "疔" "䅞" "䎪" "䭆" "䭚" "吶" "眲" "訥"))
  ((("n" "e" "i")) ("内" "哪" "那" "馁" "㐻" "㕯" "㖏" "㘨" "㨅" "㼏" "䇣" "䜆" "䡾" "䲎" "䳖" "內" "娞" "氝" "脮" "腇" "餒" "餧" "鮾" "鯘"))
  ((("n" "e" "n")) ("嫩" "恁" "㒄" "㜛" "㯎" "㶧" "嫰" "黁" "齳" "𡞾"))
  ((("n" "e" "n" "g")) ("能" "而" "耐" "㲌" "㴰" "䏻" "䘅" "䪏" "嬣" "薴"))
  ((("n" "g")) ("嗯" "唔" "㐻" "㕶"))
  ((("n" "i")) ("你" "泥" "拟" "呢" "妮" "霓" "倪" "尼" "匿" "腻" "逆" "溺" "疑" "伲" "坭" "嶷" "猊" "怩" "昵" "旎" "祢" "慝" "睨" "铌" "鲵" "㞾" "㠜" "㣇" "㥾" "㦐" "㧱" "㪒" "㮞" "㲡" "㲻" "㵫" "㹸" "䀑" "䁥" "䍲" "䕥" "䘌" "䘦" "䘽" "䛏" "䝚" "䦵" "䧇" "䭲" "䮘" "䰯" "䵑" "䵒" "伱" "儗" "儞" "埿" "堄" "妳" "婗" "嫟" "嬺" "孴" "屔" "屰" "惄" "愵" "抳" "掜" "擬" "晲" "暱" "柅" "殢" "氼" "沵" "淣" "濔" "濘" "灄" "狋" "狔" "痆" "禰" "秜" "籾" "糑" "縌" "胒" "膩" "臡" "苨" "薿" "蚭" "蜺" "衵" "觬" "貎" "跜" "輗" "迡" "郳" "鈮" "鉨" "隬" "馜" "鯓" "鯢" "鷁" "鷊" "鹝" "鹢" "麑" "齯"))
  ((("n" "i" "a" "n")) ("年" "念" "黏" "碾" "捻" "撵" "廿" "蔫" "拈" "粘" "辗" "埝" "廾" "辇" "鲇" "鲶" "㘝" "㞋" "㮟" "㲽" "䄭" "䄹" "䚓" "䟢" "䧔" "䩞" "䬯" "卄" "唸" "姩" "撚" "攆" "棯" "涊" "淰" "溓" "秊" "秥" "簐" "艌" "跈" "蹍" "蹨" "躎" "輦" "輾" "鮎" "鯰" "鼰" "齞"))
  ((("n" "i" "a" "n" "g")) ("娘" "酿" "䖆" "嬢" "孃" "醸" "釀"))
  ((("n" "i" "a" "o")) ("鸟" "尿" "溺" "氽" "茑" "嬲" "脲" "袅" "㒟" "㜵" "㞙" "㠡" "㭤" "㳮" "㼭" "䃵" "䐁" "䙚" "䦊" "䮍" "嫋" "嬝" "樢" "蔦" "裊" "褭" "鳥" "𢶑" "𢸣"))
  ((("n" "i" "e")) ("捏" "泥" "捻" "聂" "孽" "啮" "镊" "镍" "涅" "摄" "乜" "陧" "蘖" "嗫" "颞" "臬" "蹑" "㖕" "㖖" "㘝" "㘿" "㙞" "㚔" "㜦" "㜸" "㟧" "㡪" "㩶" "㮆" "㴪" "㸎" "䂼" "䄒" "䌜" "䜓" "䞕" "䯀" "䯅" "䯵" "喦" "噛" "嚙" "囁" "囓" "圼" "孼" "峊" "嵲" "嶭" "帇" "惗" "掜" "揑" "摂" "摰" "攝" "敜" "枿" "棿" "槷" "槸" "櫱" "湼" "疌" "篞" "糱" "糵" "聶" "臲" "苶" "菍" "蠥" "諗" "踂" "踗" "躡" "鈢" "鉨" "鉩" "錜" "鎳" "鑈" "鑷" "钀" "闑" "隉" "顳" "齧"))
  ((("n" "i" "n")) ("您" "恁" "㤛" "䋻" "䚾" "䛘" "囜" "拰"))
  ((("n" "i" "n" "g")) ("凝" "拧" "宁" "咛" "冰" "泥" "柠" "狞" "泞" "攘" "疑" "佞" "甯" "聍" "㝕" "㣷" "㩶" "㲰" "㿦" "䔭" "䗿" "䭢" "侫" "儜" "嚀" "寍" "寕" "寗" "寜" "寧" "擰" "橣" "檸" "濘" "獰" "矃" "聹" "苧" "薴" "鑏" "鬡" "鸋"))
  ((("n" "i" "u")) ("牛" "扭" "纽" "钮" "拗" "狃" "忸" "妞" "蚴" "㺲" "䀔" "䂇" "䋴" "䏔" "䒜" "䤔" "䮗" "抝" "杻" "炄" "紐" "莥" "衂" "鈕" "靵"))
  ((("n" "o" "n" "g")) ("农" "弄" "浓" "脓" "侬" "哝" "㶶" "㺜" "䁸" "䂇" "䢉" "䵜" "儂" "噥" "挊" "挵" "檂" "欁" "濃" "癑" "禯" "秾" "穠" "膿" "蕽" "襛" "譨" "農" "辳" "醲" "鬞" "齈"))
  ((("n" "o" "u")) ("耨" "㕢" "㝹" "䅶" "䔈" "䘫" "䨲" "䫖" "䰭" "啂" "槈" "檽" "獳" "穀" "羺" "譨" "譳" "鎒" "鐞"))
  ((("n" "u")) ("努" "怒" "奴" "褥" "帑" "弩" "胬" "孥" "驽" "㚢" "䢞" "䢪" "伮" "抐" "挐" "搙" "砮" "笯" "蒘" "駑" "鴑"))
  ((("n" "u" "a" "n")) ("暖" "濡" "㬉" "䎡" "䙇" "偄" "渜" "煖" "煗" "餪"))
  ((("n" "u" "e")) ("虐" "疟"))
  ((("n" "u" "n")) ("嫩" "嫰" "黁"))
  ((("n" "u" "o")) ("那" "娜" "难" "挪" "懦" "糯" "诺" "需" "傩" "搦" "喏" "濡" "砹" "锘" "㐡" "㑚" "㔮" "㖠" "㛂" "㡅" "㰙" "䇔" "䎟" "䚥" "儺" "愞" "懧" "挼" "捼" "掿" "搻" "撋" "梛" "橠" "砈" "稬" "穤" "糥" "袳" "諾" "蹃" "逽" "郍" "鍩" "難"))
  ((("n" "v")) ("女" "絮" "狃" "忸" "肭" "恧" "钕" "衄" "㮟" "㵖" "䖡" "䘐" "䚼" "䶊" "朒" "籹" "衂" "釹"))
  ((("n" "v" "e")) ("虐" "疟" "乇" "谑" "䖈" "䖋" "䨋" "瘧" "硸" "謔"))
  ((("o")) ("喔" "噢" "哦"))
  ((("o" "u")) ("偶" "欧" "鸥" "殴" "藕" "呕" "沤" "区" "禺" "讴" "怄" "渥" "瓯" "眍" "耦" "㒖" "㛏" "㸸" "㼴" "䌂" "䌔" "䚆" "䯚" "區" "吘" "吽" "嘔" "塸" "慪" "櫙" "歐" "毆" "漚" "熰" "甌" "瞘" "紆" "腢" "蕅" "謳" "鏂" "鴎" "鷗" "齵"))
  ((("p" "a")) ("怕" "爬" "啪" "趴" "帕" "芭" "扒" "耙" "琶" "派" "葩" "杷" "钯" "筢" "㞎" "䎬" "䎱" "䯲" "䶕" "夿" "妑" "帊" "掱" "汃" "潖" "皅" "舥" "蚆" "袙" "跁" "鈀"))
  ((("p" "a" "i")) ("派" "排" "拍" "牌" "徘" "湃" "脾" "迫" "俳" "蒎" "哌" "㭛" "㵺" "䃻" "䖰" "䮘" "䱝" "俖" "廹" "棑" "汖" "猅" "箄" "篺" "簰" "簲" "腗" "輫" "鎃" "𠂢"))
  ((("p" "a" "n")) ("判" "盘" "盼" "叛" "攀" "畔" "扳" "般" "拌" "伴" "番" "樊" "繁" "潘" "磐" "胖" "片" "鄱" "弁" "拚" "爿" "泮" "皤" "袢" "襻" "蟠" "蹒" "㐴" "㩯" "㳪" "㵗" "䃑" "䃲" "䈲" "䋣" "䙃" "䙪" "䰉" "䰔" "冸" "坢" "奤" "媻" "幋" "抃" "搫" "柈" "槃" "沜" "洀" "溿" "瀊" "瀋" "炍" "牉" "畨" "盤" "眅" "砏" "砙" "磻" "緐" "縏" "蒰" "螌" "覍" "詊" "跘" "蹣" "鋬" "鎜" "鑻" "鞶" "頄" "頖"))
  ((("p" "a" "n" "g")) ("旁" "胖" "乓" "庞" "榜" "膀" "磅" "傍" "方" "房" "仿" "逢" "耪" "蒡" "彷" "滂" "逄" "螃" "㑂" "㜊" "㝑" "㤶" "㥬" "㫄" "䂇" "䅭" "䒍" "䠙" "䨦" "䮾" "倣" "厐" "厖" "嗙" "夆" "嫎" "尨" "庬" "徬" "炐" "篣" "肨" "胮" "膖" "舽" "覫" "鎊" "雱" "霶" "騯" "髈" "鰟" "鳑" "龎" "龐"))
  ((("p" "a" "o")) ("跑" "炮" "泡" "抛" "袍" "咆" "刨" "苞" "胞" "匏" "狍" "庖" "脬" "疱" "趵" "龅" "㘐" "㚿" "㯡" "䛌" "䠙" "䩝" "䶌" "垉" "奅" "拋" "摽" "炰" "爮" "皰" "砲" "礟" "礮" "藨" "軳" "鉋" "鑤" "靤" "鞄" "颮" "髱" "鮑" "麃" "麅" "麭" "齙"))
  ((("p" "e" "i")) ("配" "培" "陪" "呸" "佩" "赔" "沛" "啡" "肺" "坏" "徘" "胚" "裴" "邳" "茇" "辔" "帔" "淠" "艴" "妃" "旆" "碚" "锫" "蜚" "醅" "霈" "㟝" "㣆" "㤄" "㧩" "㨐" "㫲" "㳈" "㸬" "㾦" "䂜" "䊃" "䕗" "䟺" "䡊" "䣙" "䪹" "䫊" "䫠" "䲹" "伂" "垺" "妚" "姵" "娝" "岯" "怌" "斾" "昢" "朏" "柸" "毰" "浿" "珮" "琣" "笩" "肧" "胐" "苝" "衃" "裵" "賠" "輫" "轡" "錇" "阫" "陫" "馷"))
  ((("p" "e" "n")) ("盆" "喷" "汾" "湓" "㾦" "呠" "喯" "噴" "歕" "濆" "瓫" "翉" "翸" "葐"))
  ((("p" "e" "n" "g")) ("朋" "碰" "捧" "棚" "膨" "蓬" "怦" "篷" "砰" "澎" "迸" "逢" "亨" "抨" "烹" "彭" "硼" "鹏" "苹" "堋" "嘭" "甏" "蟛" "㑟" "㔙" "㘐" "㛔" "㥊" "㮄" "㮟" "㱶" "㼞" "䄘" "䋽" "䡫" "䰃" "䴶" "䵄" "倗" "傰" "匉" "埄" "塜" "塳" "弸" "恲" "憉" "挷" "掽" "搒" "梈" "椖" "椪" "樥" "泙" "淎" "淜" "漰" "痭" "皏" "硑" "磞" "稝" "竼" "篣" "纄" "芃" "菶" "蟚" "踫" "軯" "軿" "輣" "錋" "鑝" "閛" "韸" "韼" "駍" "驡" "髼" "鬅" "鬔" "鵬" "𡗗"))
  ((("p" "i")) ("批" "皮" "披" "脾" "匹" "疲" "辟" "屁" "譬" "坯" "劈" "啤" "罢" "蚌" "被" "比" "番" "否" "坏" "砒" "霹" "琵" "毗" "痞" "僻" "丕" "仳" "陂" "陴" "邳" "郫" "鄱" "圮" "埤" "鼙" "芘" "苤" "萆" "蕃" "薜" "擗" "噼" "庀" "淠" "濞" "媲" "纰" "枇" "甓" "睥" "罴" "铍" "痦" "癖" "裨" "疋" "蚍" "蜱" "螵" "篦" "貔" "㔃" "㔥" "㡙" "㨽" "㮰" "㯅" "㱟" "㳪" "㵨" "㼰" "㿙" "䏘" "䑀" "䑄" "䖩" "䗄" "䚰" "䚹" "䠘" "䡟" "䡶" "䤏" "䤨" "䪐" "䫌" "䰦" "䴙" "䴽" "伾" "噽" "嚭" "壀" "嫓" "岥" "崥" "怶" "悂" "憵" "抷" "揊" "旇" "朇" "椑" "毘" "渒" "潎" "澼" "炋" "焷" "犤" "狉" "狓" "玭" "疈" "磇" "礔" "礕" "秛" "秠" "笓" "紕" "罷" "羆" "翍" "耚" "肶" "脴" "腗" "膍" "苉" "蚽" "螷" "諀" "豼" "豾" "釽" "鈈" "鈚" "鈹" "鉟" "銔" "銢" "錍" "鎞" "闢" "阰" "隦" "鞞" "頗" "駓" "髬" "髲" "魮" "魾" "鮍" "鲏" "鴄" "鷿" "鸊"))
  ((("p" "i" "a" "n")) ("片" "篇" "偏" "骗" "便" "扁" "辨" "辩" "谝" "骈" "缏" "犏" "胼" "褊" "蝙" "翩" "蹁" "㓲" "㛹" "㸤" "㼐" "䏒" "䮁" "囨" "媥" "楄" "楩" "玭" "甂" "緶" "腁" "萹" "覑" "諚" "諞" "貵" "賆" "跰" "輧" "辯" "頨" "駢" "騈" "騗" "騙" "骿" "鶣"))
  ((("p" "i" "a" "o")) ("票" "飘" "漂" "瓢" "膘" "朴" "剽" "莩" "嘌" "嫖" "骠" "缥" "殍" "瞟" "螵" "髟" "㩠" "㬓" "㯱" "㲏" "㵱" "㹾" "㺓" "㼼" "䏇" "䕯" "䴩" "僄" "勡" "彯" "徱" "慓" "摽" "旚" "淲" "犥" "皫" "竂" "篻" "縹" "翲" "臕" "蔈" "薸" "藨" "蚫" "醥" "闝" "顠" "飃" "飄" "驃" "魒" "麃"))
  ((("p" "i" "e")) ("瞥" "瘪" "撇" "丿" "苤" "氕" "䥕" "嫳" "撆" "暼" "潎" "癟" "覕" "鐅"))
  ((("p" "i" "n")) ("品" "拼" "贫" "频" "泵" "聘" "苹" "拚" "姘" "嫔" "榀" "牝" "颦" "㰋" "㲏" "㻞" "䀻" "嚬" "娦" "嬪" "涄" "獱" "玭" "琕" "矉" "礗" "薲" "蘋" "蠙" "貧" "頻" "顰"))
  ((("p" "i" "n" "g")) ("平" "评" "凭" "瓶" "苹" "乒" "屏" "秤" "冯" "砰" "聘" "坪" "萍" "俜" "娉" "枰" "鲆" "㲏" "㵗" "㺸" "㻂" "䈂" "䍈" "䓑" "䶄" "凴" "呯" "屛" "帡" "帲" "幈" "慿" "憑" "泙" "洴" "淜" "焩" "玶" "甁" "甹" "砯" "竮" "箳" "簈" "缾" "聠" "胓" "艵" "荓" "蓱" "蘋" "蚲" "蛢" "評" "軿" "輧" "郱" "頩" "馮" "鮃" "鵧" "𠗦" "𦚓"))
  ((("p" "o")) ("破" "迫" "坡" "婆" "颇" "泼" "泊" "魄" "霸" "膊" "番" "繁" "拍" "粕" "朴" "叵" "陂" "鄱" "泺" "溥" "珀" "攴" "钋" "钷" "皤" "笸" "跛" "㛘" "㜑" "㨇" "㩯" "㰴" "䄸" "䎅" "䎊" "䘠" "䞟" "䣪" "䣮" "䦌" "䨰" "䪖" "䪙" "䮘" "䯙" "嘙" "嚩" "尀" "岥" "岶" "廹" "桲" "櫇" "溌" "潑" "濼" "炇" "烞" "狛" "猼" "癹" "砶" "緐" "蒪" "蔢" "覇" "酦" "醗" "醱" "釙" "鉕" "鏺" "頗" "駊"))
  ((("p" "o" "u")) ("剖" "部" "涪" "附" "培" "裒" "掊" "瓿" "锫" "踣" "㕻" "㟝" "㧵" "㰴" "㼜" "䎧" "䯽" "䳝" "勏" "咅" "哣" "垺" "堷" "婄" "廍" "抔" "抙" "捊" "棓" "犃" "蔀" "錇"))
  ((("p" "u")) ("普" "扑" "铺" "朴" "葡" "脯" "瀑" "菩" "剥" "堡" "暴" "扶" "甫" "仆" "莆" "蒲" "埔" "圃" "浦" "谱" "曝" "匍" "苻" "噗" "溥" "濮" "璞" "攴" "氆" "镤" "镨" "醭" "蹼" "㒒" "㙸" "㬥" "㯷" "㲫" "㹒" "㺪" "䈬" "䈻" "䑑" "䔕" "䗱" "䧤" "䪬" "䲕" "䴆" "僕" "圤" "墣" "抪" "撲" "擈" "樸" "檏" "毞" "潽" "烳" "獛" "痡" "瞨" "穙" "箁" "纀" "舖" "舗" "菐" "蒱" "襆" "襥" "誧" "諩" "譜" "轐" "酺" "鋪" "鏷" "鐠" "陠" "鯆"))
  ((("q" "i")) ("起" "气" "其" "期" "七" "器" "汽" "奇" "企" "旗" "齐" "骑" "漆" "妻" "启" "欺" "戚" "岂" "弃" "砌" "棋" "凄" "泣" "崎" "沏" "甭" "刺" "逗" "畸" "稽" "缉" "伎" "栖" "柒" "歧" "畦" "脐" "祈" "祁" "乞" "契" "迄" "讫" "切" "湿" "示" "溪" "枝" "亟" "亓" "俟" "偈" "圻" "芑" "芪" "荠" "萁" "萋" "葺" "蕲" "嘁" "屺" "岐" "汔" "淇" "骐" "绮" "琪" "琦" "杞" "桤" "槭" "耆" "赍" "挈" "欹" "祺" "憩" "碛" "颀" "虮" "蛴" "蜞" "粞" "綦" "綮" "趿" "蹊" "鳍" "麒" "㒅" "㓗" "㓞" "㔑" "㖢" "㘍" "㙨" "㜎" "㝄" "㞓" "㞚" "㞿" "㟓" "㟚" "㟢" "㠍" "㠎" "㠱" "㣬" "㥓" "㦢" "㩩" "㩽" "㫅" "㫓" "㮑" "㯦" "㹄" "㼤" "㾨" "䀈" "䀙" "䁈" "䁉" "䄎" "䄢" "䄫" "䅤" "䅲" "䉝" "䉻" "䋯" "䌌" "䎢" "䏅" "䏌" "䏠" "䏿" "䐡" "䐤" "䑴" "䒗" "䒻" "䓅" "䓫" "䔇" "䔾" "䙄" "䚉" "䚍" "䛛" "䛴" "䞚" "䟄" "䟚" "䠞" "䡋" "䡔" "䢀" "䧘" "䧵" "䩓" "䫔" "䬣" "䭫" "䭬" "䭶" "䭼" "䯥" "䰇" "䰍" "䰴" "䱈" "䲬" "䳢" "䶒" "䶓" "䶞" "亝" "倛" "僛" "刾" "剘" "呇" "呮" "咠" "唘" "唭" "啓" "啔" "啟" "噐" "埼" "墄" "墘" "夡" "娸" "婍" "岓" "嵠" "帺" "徛" "忔" "忯" "悽" "愒" "愭" "慼" "慽" "憇" "懠" "掑" "掲" "摖" "攲" "敧" "斉" "斊" "旂" "晵" "暣" "朞" "栔" "桼" "棄" "棊" "棨" "棲" "榿" "槣" "檱" "檵" "櫀" "気" "氣" "淒" "湆" "湇" "溼" "漬" "濕" "濝" "濟" "炁" "焏" "犵" "猉" "玂" "玘" "璂" "甈" "畁" "疷" "盀" "盵" "矵" "碁" "碕" "碶" "磎" "磜" "磧" "磩" "礘" "祇" "禥" "竐" "竒" "粸" "綥" "綨" "綺" "緀" "緁" "緝" "纃" "罊" "翗" "肵" "臍" "艩" "芞" "萕" "薺" "藄" "蘄" "蚑" "蚔" "蚚" "蜝" "蟣" "蟿" "蠐" "衹" "袳" "裿" "觭" "訖" "諆" "諬" "諿" "谿" "豈" "賫" "賷" "跂" "踑" "踦" "軙" "軝" "迉" "邔" "郪" "鄿" "釮" "錡" "錤" "鏚" "锜" "闙" "陭" "隑" "霋" "頎" "顣" "饑" "騎" "騏" "騹" "鬐" "鬿" "魌" "鮨" "鯕" "鰭" "鲯" "鵸" "鶀" "鶈" "鸂" "鼜" "齊" "齌" "齎" "𠀁" "𣪠"))
  ((("q" "i" "a")) ("恰" "掐" "卡" "洽" "葜" "疴" "袷" "髂" "㓞" "㓣" "㓤" "㡊" "㤉" "㦴" "㰤" "㵄" "䁍" "䂒" "䜑" "䠍" "䨐" "䯊" "䶗" "䶝" "匼" "圶" "帢" "楬" "殎" "跒" "酠" "鮚" "𠜼"))
  ((("q" "i" "a" "n")) ("前" "千" "钱" "牵" "浅" "签" "铅" "欠" "潜" "迁" "遣" "谦" "歉" "钳" "嵌" "谴" "柑" "赶" "渐" "筋" "扦" "钎" "仟" "乾" "黔" "堑" "纤" "倩" "佥" "阡" "芊" "芡" "茜" "荨" "掮" "撖" "岍" "悭" "慊" "涔" "骞" "搴" "褰" "蹇" "缱" "椠" "犍" "肷" "腱" "愆" "钤" "锓" "虔" "箝" "羟" "㐸" "㜞" "㝿" "㟻" "㡊" "㡨" "㥞" "㦮" "㧄" "㨜" "㩮" "㪠" "㯠" "㸫" "㹂" "䁮" "䃛" "䅐" "䅾" "䆂" "䈤" "䈴" "䊴" "䋮" "䍉" "䑶" "䔔" "䕭" "䖍" "䙺" "䢪" "䤘" "䥅" "䦲" "䨿" "䪈" "䫡" "䭠" "䭤" "䯡" "䵖" "乹" "仱" "傔" "僉" "儙" "兛" "刋" "厱" "唊" "嗛" "圱" "圲" "塹" "壍" "奷" "婜" "媊" "孅" "孯" "岒" "嵰" "幵" "忴" "悓" "慳" "扲" "拑" "拪" "挳" "掔" "揵" "撁" "攐" "攑" "攓" "杄" "棈" "榩" "槏" "槧" "檶" "櫏" "欦" "歬" "汘" "汧" "淺" "漧" "漸" "潛" "濳" "濽" "灊" "煔" "燂" "燅" "燖" "爓" "牽" "皘" "篏" "篟" "簽" "籤" "粁" "綪" "縴" "繾" "羥" "脥" "膁" "臤" "葥" "葴" "蒨" "蔳" "蕁" "蚈" "蜸" "諐" "謙" "譣" "譴" "谸" "輤" "遷" "釺" "鈆" "鈐" "鉆" "鉗" "鉛" "銭" "鋟" "錢" "鍼" "鐱" "雂" "韆" "顩" "騚" "騫" "鬜" "鬝" "鬵" "鰬" "鵮" "鶼" "鹐" "黚" "齦"))
  ((("q" "i" "a" "n" "g")) ("强" "枪" "墙" "抢" "腔" "将" "疆" "控" "呛" "羌" "蔷" "丬" "爿" "戕" "嫱" "樯" "戗" "炝" "锖" "锵" "镪" "襁" "蜣" "箐" "羟" "跫" "跄" "㛨" "㩖" "䅚" "䵁" "傸" "勥" "唴" "啌" "嗆" "墏" "墻" "嬙" "將" "嵹" "嶈" "廧" "弜" "強" "彊" "戧" "搶" "斨" "椌" "槍" "檣" "溬" "漒" "熗" "牄" "牆" "猐" "玱" "瑲" "矼" "磢" "篬" "繈" "繦" "羗" "羥" "羫" "羻" "艢" "薔" "蘠" "謒" "蹌" "蹡" "軖" "錆" "鎗" "鏘" "鏹" "鶬" "鸧" "𤕭"))
  ((("q" "i" "a" "o")) ("桥" "瞧" "悄" "巧" "敲" "壳" "翘" "锹" "峭" "蕉" "焦" "橇" "乔" "侨" "鞘" "撬" "俏" "窍" "雀" "硝" "招" "劁" "诮" "谯" "荞" "茭" "峤" "愀" "憔" "缲" "樵" "毳" "硗" "舄" "醮" "跷" "跤" "鞒" "㚁" "㚽" "㝯" "㡑" "㢗" "㤍" "㨽" "㩰" "㪣" "㱶" "㴥" "䀉" "䃝" "䆻" "䇌" "䎗" "䏆" "䩌" "䱁" "䲾" "丂" "僑" "僺" "喬" "嘺" "墝" "墧" "墽" "嵪" "嶠" "嶣" "帩" "幧" "撽" "橋" "殻" "殼" "燆" "燋" "癄" "睄" "硚" "碻" "磽" "礄" "竅" "箾" "簥" "繑" "繰" "翹" "舃" "荍" "蕎" "藮" "誚" "譙" "趫" "趬" "踍" "蹺" "蹻" "躈" "郻" "鄡" "鄥" "釥" "銚" "鍫" "鍬" "鏒" "鐈" "鐰" "陗" "鞽" "韒" "頝" "顦" "驕" "骹" "髚" "髜"))
  ((("q" "i" "e")) ("且" "切" "窃" "怯" "担" "捷" "沏" "契" "砌" "茄" "伽" "郄" "蕺" "唼" "惬" "慊" "渫" "妾" "挈" "脞" "锲" "箧" "趄" "㓶" "㗫" "㙻" "㚗" "㛍" "㛙" "㤲" "㥦" "㫸" "㰰" "㰼" "㹤" "㼤" "㾀" "㾜" "䌌" "䟙" "䤿" "䦧" "䫔" "䬊" "䶗" "匧" "嗛" "悏" "愜" "朅" "洯" "淁" "癿" "穕" "竊" "笡" "篋" "緁" "藒" "蛣" "蛪" "踥" "鍥" "鯜" "鰈"))
  ((("q" "i" "n")) ("亲" "侵" "勤" "琴" "钦" "浸" "秦" "芹" "擒" "禽" "寝" "沁" "渗" "芩" "蓁" "揿" "吣" "嗪" "噙" "廑" "溱" "槿" "檎" "锓" "衿" "矜" "覃" "螓" "衾" "㓎" "㕋" "㘦" "㛙" "㝲" "㞬" "㢙" "㤈" "㩒" "㪁" "㮗" "㱽" "㾛" "䅾" "䇒" "䈜" "䔷" "䖌" "䠴" "䢈" "䥅" "䥆" "䦦" "䶖" "厪" "吢" "唚" "坅" "媇" "嫀" "寑" "寖" "寢" "寴" "嵚" "嶔" "庈" "慬" "懃" "懄" "抋" "捦" "搇" "撳" "斳" "昑" "曋" "梣" "梫" "櫬" "欽" "滲" "澿" "瀙" "珡" "琹" "綅" "耹" "菣" "菦" "菫" "蘄" "蚙" "螼" "蠄" "親" "誛" "赺" "赾" "鈙" "鉆" "鋟" "雂" "靲" "頜" "顉" "顩" "駸" "骎" "鮼" "鳹" "鵭"))
  ((("q" "i" "n" "g")) ("情" "轻" "青" "清" "请" "倾" "晴" "庆" "顷" "蜻" "氢" "鲸" "精" "亲" "卿" "擎" "氰" "倩" "苘" "圊" "檠" "磬" "罄" "箐" "綮" "謦" "鲭" "黥" "㔀" "㢣" "㩩" "㯳" "㵾" "㷫" "䋜" "䋯" "䌠" "䔛" "䝼" "䞍" "䯧" "䲔" "䵞" "傾" "凊" "剠" "勍" "啨" "夝" "寈" "庼" "廎" "慶" "掅" "擏" "暒" "樈" "檾" "殑" "殸" "氫" "汫" "涇" "淸" "渹" "漀" "狅" "甠" "碃" "磘" "親" "請" "軽" "輕" "郬" "鑋" "靑" "靘" "頃" "鯖" "鯨" "晴"))
  ((("q" "i" "o" "n" "g")) ("穷" "鞠" "琼" "邛" "芎" "苘" "茕" "穹" "蛩" "筇" "跫" "銎" "㑋" "㒌" "㤨" "㧭" "㮪" "㵌" "㷀" "㼇" "䅃" "䆳" "䊄" "䓖" "䛪" "䠻" "䧆" "儝" "匔" "卭" "嬛" "宆" "惸" "桏" "棾" "橩" "焪" "焭" "煢" "璚" "瓊" "睘" "瞏" "窮" "竆" "笻" "藑" "藭" "蛬" "赹" "輁"))
  ((("q" "i" "u")) ("求" "球" "秋" "丘" "蚯" "仇" "龟" "邱" "囚" "酋" "泅" "馗" "俅" "氽" "巯" "艽" "犰" "湫" "逑" "遒" "楸" "赇" "钆" "虬" "蝤" "裘" "糗" "鳅" "鼽" "㐀" "㐤" "㕤" "㛏" "㞗" "㟈" "㤹" "㥢" "㧄" "㧨" "㭝" "㲹" "㷕" "㺫" "㼒" "䆋" "䊆" "䊵" "䎿" "䔔" "䜪" "䞭" "䟬" "䟵" "䠗" "䣇" "䤛" "丠" "厹" "叴" "唒" "坵" "媝" "崷" "巰" "恘" "扏" "捄" "搝" "朹" "梂" "殏" "毬" "汓" "浗" "渞" "煪" "玌" "璆" "皳" "盚" "秌" "穐" "篍" "紌" "絿" "緧" "肍" "脙" "苬" "莍" "萩" "蓲" "虯" "蛷" "蝵" "螑" "蟗" "蠤" "觓" "觩" "訄" "訅" "賕" "趥" "逎" "釓" "釚" "銶" "鞦" "鞧" "頄" "頯" "鮂" "鯄" "鰌" "鰍" "鰽" "鱃" "鳩" "鶖" "鹙" "龜" "龝" "𠀉" "𩝠"))
  ((("q" "u")) ("去" "区" "取" "趣" "曲" "渠" "娶" "屈" "趋" "岖" "驱" "蛆" "躯" "鞠" "蜡" "龋" "戌" "虚" "絮" "诎" "劬" "凵" "苣" "蕖" "蘧" "衢" "阒" "遽" "璩" "枸" "觑" "氍" "朐" "祛" "磲" "鸲" "癯" "蛐" "蠼" "麴" "瞿" "鞫" "黢" "㖆" "㚁" "㜹" "㠊" "㣄" "㤲" "㧁" "㪯" "㫢" "㯫" "㰦" "㲘" "㽛" "䀠" "䁦" "䂂" "䅓" "䆽" "䋧" "䌌" "䏣" "䒧" "䗇" "䝣" "䞤" "䟊" "䠐" "䠓" "䢗" "䪨" "䵶" "䶚" "伹" "佉" "佢" "刞" "匤" "匷" "區" "厺" "呿" "坥" "岴" "嶇" "忂" "憈" "懅" "戵" "抾" "敺" "斪" "欋" "毆" "浀" "淭" "湨" "灈" "璖" "痀" "砠" "竘" "竬" "筁" "籧" "紶" "組" "絇" "翑" "翵" "胊" "胠" "脥" "臞" "菃" "葋" "蚷" "螶" "蟝" "蠷" "袪" "覰" "覷" "覻" "詓" "詘" "誳" "豦" "趍" "趨" "躣" "軀" "軥" "鉤" "鐻" "鑺" "镼" "閴" "闃" "阹" "駆" "駈" "騶" "驅" "髷" "魼" "鰸" "鱋" "鴝" "鶌" "鸜" "麮" "麯" "麹" "鼁" "鼩" "齲" "𪍸"))
  ((("q" "u" "a" "n")) ("全" "权" "圈" "劝" "拳" "泉" "犬" "纯" "卷" "颧" "醛" "痊" "券" "诠" "荃" "獾" "悛" "绻" "桊" "辁" "畎" "铨" "蜷" "筌" "鬈" "㒰" "㟨" "㟫" "㩲" "䀬" "䄐" "䅚" "䊎" "䌯" "䑏" "䟒" "䠰" "佺" "劵" "勧" "勸" "呟" "啳" "圏" "奆" "姾" "婘" "孉" "峑" "巏" "弮" "恮" "惓" "捲" "搼" "棬" "権" "權" "汱" "洤" "湶" "烇" "牶" "牷" "犈" "玔" "琄" "瑔" "甽" "硂" "箞" "純" "絟" "絭" "綣" "縓" "腃" "荈" "葲" "虇" "蠸" "觠" "詃" "詮" "謜" "跧" "踡" "輇" "銓" "鐉" "顴" "駩" "騡" "鰁" "鳈" "鷤" "鸛" "齤"))
  ((("q" "u" "e")) ("却" "确" "缺" "雀" "鹊" "猎" "欠" "炔" "瘸" "榷" "芍" "郄" "攉" "阕" "阙" "觳" "悫" "舭" "㕁" "㩁" "㰌" "㱋" "㱿" "㴶" "㹤" "㹱" "㾡" "䀇" "䇎" "䍳" "䢧" "䦬" "䧿" "䱜" "䲵" "卻" "咑" "埆" "塙" "墧" "寉" "崅" "愨" "慤" "搉" "殻" "毃" "灍" "燩" "獡" "琷" "皵" "硞" "碏" "確" "碻" "礐" "礭" "舃" "蒛" "趞" "闋" "闕" "鳥" "鵲" "𩨭"))
  ((("q" "u" "n")) ("群" "裙" "遁" "逡" "蝽" "麇" "㪊" "㿏" "䆽" "䭽" "囷" "夋" "宭" "峮" "帬" "杶" "漘" "羣" "裠" "踆" "輴" "錞" "鰆" "麕"))
  ((("r")) ("儿" "兒"))
  ((("r" "a" "n")) ("然" "燃" "染" "冉" "苒" "蚺" "髯" "㒄" "㚩" "㜣" "㯗" "㲯" "㸐" "㹱" "㾆" "㿵" "䇋" "䎃" "䑙" "䒣" "䔳" "䖄" "䣸" "䤡" "䫇" "䰯" "䳿" "䶲" "冄" "呥" "嘫" "姌" "媣" "橪" "珃" "繎" "肰" "蚒" "蚦" "蛅" "衻" "袇" "袡" "髥" "𤡮"))
  ((("r" "a" "n" "g")) ("让" "嚷" "壤" "瓤" "攘" "镶" "禳" "穰" "㚂" "䉴" "䑋" "儴" "勷" "壌" "孃" "懹" "瀼" "爙" "獽" "穣" "纕" "蘘" "蠰" "譲" "讓" "躟" "鑲" "鬤"))
  ((("r" "a" "o")) ("绕" "扰" "饶" "荛" "娆" "桡" "蛲" "㑱" "㹛" "䫞" "嬈" "挐" "擾" "橈" "繚" "繞" "蕘" "蟯" "襓" "遶" "隢" "顤" "饒"))
  ((("r" "e")) ("热" "惹" "若" "喏" "㻰" "渃" "焫" "熱" "爇"))
  ((("r" "e" "n")) ("人" "认" "任" "忍" "韧" "赁" "壬" "仁" "刃" "妊" "纫" "亻" "仞" "荏" "葚" "饪" "轫" "恁" "稔" "衽" "㠴" "㣼" "㤛" "㲽" "㶵" "㸾" "䀔" "䀼" "䄒" "䇮" "䋕" "䌾" "䏕" "䏰" "䚾" "䛘" "䭃" "䴦" "仭" "刄" "姙" "屻" "忈" "忎" "扨" "朲" "杒" "栠" "栣" "梕" "棯" "涊" "牣" "秂" "秹" "紉" "紝" "絍" "纴" "肕" "腍" "芢" "荵" "袵" "訒" "認" "讱" "賃" "軔" "軠" "鈓" "銋" "靭" "靱" "韌" "飪" "餁" "魜" "鴹" "鵀"))
  ((("r" "e" "n" "g")) ("仍" "扔" "耳" "艿" "穰" "㭁" "㺱" "䄧" "䚮" "礽" "芿" "辸" "陾"))
  ((("r" "i")) ("日" "䒤" "囸" "氜" "衵" "釰" "鈤" "馹" "驲"))
  ((("r" "o" "n" "g")) ("容" "荣" "溶" "绒" "融" "熔" "茸" "榕" "隔" "戎" "蓉" "冗" "颂" "讼" "嵘" "狨" "肜" "蝾" "㘇" "㝐" "㣑" "㭜" "㲓" "㲝" "㲨" "㺎" "㼸" "䄧" "䇀" "䇯" "䈶" "䋴" "䘬" "䠜" "䡆" "䡥" "䢇" "䤊" "䩸" "傇" "傛" "媶" "宂" "嶸" "搑" "曧" "栄" "榮" "榵" "毧" "氄" "滽" "瀜" "烿" "爃" "瑢" "穁" "絨" "縙" "縟" "羢" "茙" "螎" "蠑" "褣" "訟" "軵" "鎔" "镕" "頌" "駥" "髶" "鰫" "鴧" "鷛"))
  ((("r" "o" "u")) ("肉" "柔" "揉" "扰" "糅" "蹂" "鞣" "㖻" "㮟" "㽥" "䄾" "䋴" "䐓" "䢇" "䥆" "䧷" "䰆" "媃" "宍" "擾" "楺" "沑" "渘" "煣" "瑈" "瓇" "禸" "粈" "脜" "腬" "葇" "蝚" "輮" "鍒" "鍕" "韖" "騥" "鰇" "鶔"))
  ((("r" "u")) ("如" "入" "乳" "辱" "蠕" "女" "肉" "茹" "儒" "孺" "汝" "褥" "需" "蓐" "薷" "嚅" "洳" "溽" "濡" "缛" "铷" "襦" "颥" "㦺" "㨌" "㨎" "㱶" "㹘" "㼋" "㾒" "䋈" "䋴" "䐓" "䘫" "䞕" "䤉" "䫱" "䰭" "䰰" "侞" "傉" "嗕" "媷" "帤" "挐" "擩" "曘" "桇" "渪" "燸" "筎" "縟" "繻" "肗" "臑" "蕠" "蝡" "袽" "邚" "鄏" "醹" "銣" "鑐" "顬" "鱬" "鴽"))
  ((("r" "u" "a" "n")) ("软" "蠕" "阮" "需" "濡" "朊" "㓴" "㜛" "㨎" "㮕" "㼱" "㽭" "䆓" "䎡" "䓴" "䙃" "䙇" "䞂" "䪀" "䪭" "堧" "壖" "媆" "撋" "瑌" "瓀" "盶" "碝" "礝" "緛" "耎" "腝" "蝡" "軟" "輭"))
  ((("r" "u" "i")) ("锐" "兑" "蕊" "瑞" "芮" "蕤" "枘" "睿" "蚋" "㓹" "㕙" "㛱" "㨅" "㪫" "㮃" "㲊" "㹘" "㻔" "䂱" "䅑" "䇤" "䌼" "䍴" "䓲" "䞩" "䦌" "䳠" "叡" "壡" "惢" "擩" "桵" "橤" "汭" "甤" "綏" "緌" "繠" "蕋" "蘂" "蘃" "蜹" "鈉" "銳" "鋭"))
  ((("r" "u" "n")) ("润" "闰" "㝄" "㠈" "䏕" "䦞" "橍" "潤" "犉" "瞤" "膶" "閏" "閠"))
  ((("r" "u" "o")) ("弱" "若" "挪" "偌" "芮" "箬" "㬉" "䐞" "叒" "婼" "挼" "捼" "楉" "渃" "焫" "爇" "篛" "蒻" "蠚" "鄀" "鰙" "鰯" "鶸"))
  ((("s" "a")) ("撒" "洒" "萨" "蔡" "杀" "些" "卅" "仨" "檫" "挲" "脎" "飒" "趿" "㒎" "㪪" "㳐" "㽂" "䊛" "䑥" "䓲" "䘮" "䙣" "䬃" "摋" "攃" "櫒" "殺" "潵" "灑" "薩" "躠" "鈒" "鎝" "钑" "闟" "靸" "颯" "馺" "𥋌"))
  ((("s" "a" "i")) ("赛" "塞" "腮" "鳃" "思" "蓑" "噻" "㗷" "㘔" "䈢" "僿" "嗮" "愢" "揌" "毢" "毸" "簺" "賽" "顋" "鰓"))
  ((("s" "a" "n")) ("三" "散" "伞" "参" "粪" "叁" "馓" "毵" "糁" "㤾" "㧲" "㪔" "㪚" "䀐" "䉈" "䊉" "䫅" "䫩" "仐" "俕" "傘" "參" "叄" "嘇" "弎" "攕" "毿" "潵" "犙" "粣" "糂" "糝" "糣" "糤" "繖" "蔘" "鏾" "閐" "饊" "鬖"))
  ((("s" "a" "n" "g")) ("嗓" "丧" "桑" "搡" "磉" "颡" "䘮" "䡦" "䫙" "喪" "桒" "褬" "鎟" "顙"))
  ((("s" "a" "o")) ("嫂" "扫" "搔" "骚" "艘" "燥" "埽" "缫" "缲" "臊" "瘙" "鳋" "㛮" "㿋" "䐹" "䕅" "䖣" "喿" "慅" "掃" "掻" "氉" "溞" "矂" "繅" "繰" "颾" "騒" "騷" "鰠" "鰺" "鱢" "𦞣"))
  ((("s" "e")) ("色" "塞" "泣" "蔷" "瑟" "涩" "啬" "槭" "铯" "穑" "㒊" "㥶" "㮦" "㱇" "㴔" "㺩" "㻎" "㻭" "㽇" "䉢" "䊂" "䔼" "䨛" "嗇" "懎" "歮" "歰" "漬" "澀" "澁" "濇" "瀒" "璱" "穡" "繬" "翜" "薔" "譅" "趇" "轖" "鉍" "銫" "鎩" "雭" "飋"))
  ((("s" "e" "n")) ("森" "洒" "摻" "曑" "椮" "槮" "滲" "甧" "穼" "篸" "蔘" "襂"))
  ((("s" "e" "n" "g")) ("僧" "鬙"))
  ((("s" "h" "a")) ("沙" "杀" "啥" "纱" "傻" "砂" "刹" "煞" "厦" "霎" "莎" "杉" "赊" "栅" "唼" "嗄" "挲" "歃" "铩" "痧" "裟" "鲨" "㚫" "㛼" "㰱" "㵤" "䀉" "䈉" "䝊" "䬊" "䮜" "䯫" "䵘" "䶎" "乷" "倽" "儍" "剎" "唦" "啑" "喢" "帴" "帹" "廈" "擑" "柵" "桬" "榝" "樧" "檆" "歰" "殺" "猀" "硰" "箑" "粆" "紗" "翜" "翣" "萐" "蔱" "訯" "賒" "鎩" "閯" "閷" "霅" "髿" "魦" "鮻" "鯊" "鯋" "𠚺" "𧜁"))
  ((("s" "h" "a" "i")) ("晒" "筛" "色" "杀" "酾" "㩄" "㬠" "䵘" "曬" "殺" "篩" "繺" "纚" "釃" "閷"))
  ((("s" "h" "a" "n")) ("山" "闪" "善" "衫" "扇" "杉" "珊" "掺" "颤" "单" "掸" "苫" "删" "煽" "陕" "擅" "赡" "膳" "汕" "缮" "檀" "栅" "詹" "剡" "讪" "鄯" "埏" "芟" "彡" "潸" "澹" "姗" "嬗" "骟" "膻" "禅" "钐" "疝" "蟮" "舢" "跚" "鳝" "髟" "㚒" "㚲" "㣌" "㣣" "㨛" "㪎" "㪨" "㬭" "㱚" "㱯" "㴸" "㶒" "㹽" "㾆" "䄠" "䆄" "䗞" "䚲" "䛸" "䠾" "䡪" "䥇" "䦂" "䦅" "䱇" "䱉" "䴮" "傓" "僐" "刪" "剼" "單" "墠" "墡" "姍" "幓" "挻" "掞" "搧" "摲" "摻" "撣" "晱" "柵" "椫" "樿" "橏" "檆" "潬" "澘" "灗" "烻" "煔" "熌" "狦" "痁" "睒" "磰" "禪" "穇" "笘" "縿" "繕" "羴" "羶" "脠" "蟬" "蟺" "襂" "覢" "訕" "謆" "譱" "贍" "赸" "軕" "邖" "醦" "釤" "銏" "鐥" "閃" "陝" "陿" "顫" "饍" "騸" "鯅" "鱓" "鱔" "鱣" "鳣" "𠚹"))
  ((("s" "h" "a" "n" "g")) ("上" "商" "伤" "尚" "赏" "裳" "晌" "墒" "汤" "垧" "绱" "殇" "熵" "觞" "䬕" "丄" "傷" "姠" "尙" "愓" "慯" "扄" "曏" "殤" "湯" "滳" "漡" "蔏" "螪" "蠰" "觴" "謪" "賞" "銄" "鑜" "鬺"))
  ((("s" "h" "a" "o")) ("少" "烧" "绍" "稍" "哨" "梢" "捎" "鞘" "芍" "勺" "韶" "邵" "招" "召" "劭" "苕" "溲" "潲" "杓" "蛸" "笤" "筲" "艄" "㪢" "㲈" "㷹" "㸛" "䏴" "䒚" "䔠" "䙼" "䬰" "佋" "卲" "娋" "弰" "旓" "焼" "燒" "燿" "牊" "玿" "睄" "竰" "紹" "綃" "綤" "莦" "袑" "輎" "颵" "髾"))
  ((("s" "h" "e")) ("社" "设" "射" "摄" "蛇" "舍" "舌" "涉" "折" "碟" "睫" "杀" "奢" "赊" "赦" "慑" "拾" "邪" "叶" "厍" "佘" "揲" "猞" "滠" "歙" "畲" "铊" "蛞" "麝" "㒤" "㢵" "㭙" "㰒" "㴇" "㵃" "䀅" "䀹" "䁋" "䁯" "䂠" "䄕" "䌰" "䏴" "䕣" "䜆" "䜓" "䞌" "䠟" "䠶" "䤁" "䤮" "䬷" "䰥" "䵥" "厙" "奓" "弽" "慴" "懾" "捨" "摂" "摵" "攝" "栜" "檨" "欇" "殺" "渉" "灄" "畬" "聶" "葉" "蔎" "虵" "蛥" "蠂" "設" "譇" "讋" "賒" "賖" "輋" "釶" "鉇" "鉈" "鍦" "闍" "阇" "韘" "騇" "𧵳"))
  ((("s" "h" "e" "i")) ("谁" "誰"))
  ((("s" "h" "e" "n")) ("什" "甚" "身" "神" "深" "伸" "婶" "审" "慎" "渗" "参" "申" "绅" "呻" "砷" "娠" "沈" "肾" "信" "震" "诜" "谂" "莘" "葚" "抻" "吲" "哂" "渖" "椹" "胂" "矧" "蜃" "糁" "㔤" "㚞" "㛙" "㜤" "㥲" "㰂" "㰮" "㱯" "㵊" "㵕" "㶒" "㾕" "䄕" "䆦" "䚓" "䧵" "䫖" "䰠" "伔" "侁" "侺" "兟" "參" "叄" "妽" "姺" "嬸" "宷" "審" "屾" "峷" "弞" "愼" "扟" "抌" "搷" "昚" "柛" "棽" "椮" "槮" "氠" "涁" "淰" "滲" "瀋" "煁" "燊" "珅" "甡" "瘆" "瘎" "瘮" "眒" "眘" "瞫" "矤" "籶" "籸" "紳" "綝" "罙" "罧" "脤" "腎" "葠" "蓡" "蔘" "薓" "裑" "襂" "襳" "覾" "訠" "訦" "訷" "詵" "諗" "諶" "讅" "谉" "邥" "鉮" "鋠" "頣" "頥" "駪" "魫" "鯵" "鰺" "鲹" "鵢" "黮" "神"))
  ((("s" "h" "e" "n" "g")) ("生" "声" "胜" "省" "剩" "升" "牲" "绳" "盛" "圣" "乘" "甸" "甥" "嵊" "渑" "晟" "眚" "笙" "㗂" "㞼" "㹌" "㼳" "㾪" "䁞" "䇸" "䋲" "䎴" "䚇" "䞉" "䪿" "䱆" "乗" "偗" "剰" "勝" "呏" "墭" "憴" "斘" "昇" "晠" "椉" "榺" "殅" "泩" "渻" "湦" "溗" "澠" "焺" "狌" "珄" "琞" "甡" "畻" "箵" "繩" "聖" "聲" "苼" "蕂" "譝" "貹" "賸" "鉎" "阩" "陞" "鱦" "鵿" "鼪"))
  ((("s" "h" "i")) ("是" "时" "十" "事" "实" "使" "世" "师" "石" "识" "史" "市" "始" "似" "式" "失" "士" "示" "势" "室" "视" "试" "适" "食" "施" "湿" "诗" "驶" "释" "蚀" "拾" "饰" "氏" "逝" "誓" "狮" "侍" "尸" "屎" "匙" "拭" "弛" "郝" "赫" "舍" "甚" "虱" "什" "矢" "柿" "嗜" "噬" "仕" "恃" "硕" "提" "嘘" "液" "泽" "肢" "汁" "殖" "峙" "谥" "埘" "莳" "蓍" "弑" "饣" "轼" "耆" "贳" "炻" "礻" "铈" "铊" "螫" "舐" "筮" "豉" "酾" "豕" "鲥" "鲺" "㒾" "㔺" "㕜" "㖷" "㫅" "㫑" "㮶" "㱁" "㳏" "㵓" "㶴" "㸷" "㹝" "㹬" "㹷" "䁺" "䂖" "䂠" "䄷" "䈕" "䊓" "䏡" "䑛" "䒨" "䖨" "䛈" "䜴" "䜵" "䜻" "䟗" "䤭" "䤱" "䦠" "䦹" "䩃" "䭄" "䰄" "䲽" "䴓" "䶡" "䶵" "丗" "乨" "乭" "亊" "佀" "兘" "冟" "勢" "卋" "卶" "叓" "呞" "呩" "咶" "埶" "塒" "奭" "嬕" "実" "宩" "寔" "實" "屍" "峕" "崼" "師" "弒" "忕" "恀" "戠" "戺" "揓" "旹" "昰" "時" "枾" "柹" "栻" "榯" "檡" "浉" "湁" "湜" "湤" "溡" "溮" "溼" "澤" "澨" "濕" "灑" "烒" "獅" "眂" "眎" "睗" "碩" "祏" "笶" "箷" "篩" "簭" "絁" "繹" "纚" "翨" "舓" "葹" "蒒" "蒔" "蝕" "蝨" "褷" "襫" "襹" "視" "試" "詩" "諟" "諡" "謚" "識" "貰" "跩" "跱" "軾" "遈" "適" "遰" "遾" "邿" "醳" "釃" "釈" "釋" "釶" "鈟" "鈰" "鉂" "鉃" "鉇" "鉈" "鉐" "鉽" "銴" "鍉" "鍦" "鎩" "飠" "飭" "飾" "餙" "餝" "駛" "鯴" "鯷" "鰣" "鰤" "鳀" "鳲" "鳾" "鶳" "鸤" "鼫" "鼭" "齛" "𠀍" "𢂑" "𥐘"))
  ((("s" "h" "o" "u")) ("手" "受" "收" "首" "守" "授" "瘦" "售" "兽" "寿" "熟" "狩" "绶" "艏" "㖟" "㝊" "㥅" "䛵" "䭭" "収" "垨" "壽" "夀" "掱" "涭" "濤" "獸" "璹" "痩" "綬" "荍" "鏉"))
  ((("s" "h" "u")) ("书" "数" "术" "树" "熟" "属" "输" "束" "叔" "舒" "述" "殊" "鼠" "蔬" "梳" "竖" "署" "疏" "枢" "薯" "暑" "除" "抒" "淑" "赎" "孰" "曙" "蜀" "黍" "戍" "墅" "庶" "漱" "恕" "透" "俞" "朱" "倏" "塾" "荼" "菽" "摅" "沭" "涑" "澍" "姝" "纾" "杼" "樗" "毹" "腧" "殳" "秫" "疋" "蜍" "㒔" "㛸" "㜐" "㟬" "㣽" "㫹" "㯮" "㳆" "㵂" "㶖" "㷂" "㻿" "㽰" "㾁" "䃞" "䆝" "䉀" "䎉" "䑕" "䘤" "䙱" "䜹" "䝂" "䝪" "䞖" "䠱" "䠼" "䢞" "䢤" "䩱" "䩳" "䭭" "䴰" "侸" "俆" "倐" "儵" "兪" "凁" "埱" "婌" "尌" "尗" "屬" "庻" "掓" "摴" "攄" "數" "書" "朮" "杸" "樜" "樞" "樹" "橾" "潄" "潻" "濖" "焂" "璹" "疎" "癙" "盨" "竪" "籔" "紓" "絉" "綀" "翛" "荗" "蒁" "薥" "藪" "藷" "虪" "術" "袕" "裋" "襡" "襩" "豎" "贖" "跾" "踈" "軗" "輸" "鄃" "鉥" "錰" "鏣" "鐲" "钃" "陎" "鮛" "鵨" "鶐" "鷸" "鸀" "鼡" "𠲿" "𡱆"))
  ((("s" "h" "u" "a")) ("刷" "唰" "耍" "涮" "誜"))
  ((("s" "h" "u" "a" "i")) ("摔" "率" "甩" "蟀" "衰" "帅" "䢦" "卛" "咰" "孈" "帥" "綏" "縗" "繂" "缞"))
  ((("s" "h" "u" "a" "n")) ("拴" "汕" "栓" "揎" "闩" "涮" "踹" "䧠" "閂"))
  ((("s" "h" "u" "a" "n" "g")) ("双" "霜" "爽" "泷" "淙" "孀" "㦼" "㼽" "䔪" "䗮" "䡯" "䫪" "塽" "孇" "慡" "樉" "欆" "滝" "瀧" "灀" "礵" "縔" "艭" "雙" "騻" "驦" "骦" "鷞" "鸘" "鹴"))
  ((("s" "h" "u" "i")) ("水" "谁" "睡" "税" "说" "蜕" "㔑" "㝽" "㥨" "㽷" "䭨" "䲧" "娷" "帨" "挩" "涗" "涚" "瞓" "祱" "稅" "脽" "蛻" "裞" "說" "説" "誰"))
  ((("s" "h" "u" "n")) ("顺" "盾" "吮" "瞬" "舜" "㥧" "㯗" "䀢" "䀵" "䑞" "䞐" "䴄" "揗" "楯" "橓" "眴" "瞚" "蕣" "賰" "輴" "順" "鬊"))
  ((("s" "h" "u" "o")) ("说" "烁" "芍" "数" "帅" "硕" "朔" "溯" "蒴" "搠" "濯" "妁" "杓" "槊" "铄" "㮶" "㸛" "䀥" "䁻" "䈾" "䌃" "哾" "帥" "愬" "揱" "數" "欶" "洬" "燿" "爍" "爚" "獡" "療" "矟" "碩" "箾" "藥" "說" "説" "鎙" "鑠"))
  ((("s" "i")) ("四" "思" "死" "似" "司" "丝" "私" "斯" "撕" "饲" "嘶" "赐" "食" "肆" "寺" "嗣" "伺" "巳" "肄" "厮" "俟" "兕" "厶" "苡" "菥" "咝" "饴" "汜" "泗" "澌" "姒" "驷" "纟" "缌" "祀" "祠" "锶" "雉" "鸶" "耜" "蛳" "笥" "糸" "㐌" "㕽" "㚶" "㜦" "㣈" "㭒" "㸻" "㹑" "㾅" "䂖" "䃽" "䇃" "䎣" "䏤" "䦙" "亖" "佀" "佁" "偲" "儩" "凘" "噝" "娰" "媤" "孠" "廝" "杫" "枱" "柶" "梩" "楒" "榹" "泀" "泤" "洍" "涘" "瀃" "燍" "牭" "磃" "禗" "禠" "禩" "竢" "簛" "籭" "糹" "絲" "緦" "罳" "肂" "蕬" "蕼" "虒" "蜤" "螄" "蟖" "蟴" "覗" "貄" "賜" "釲" "鈻" "鉰" "鋖" "鍶" "鐁" "颸" "飔" "飤" "飴" "飼" "駟" "騦" "鷥" "鼶" "飼"))
  ((("s" "o" "n" "g")) ("送" "松" "耸" "颂" "讼" "诵" "怂" "宋" "纵" "凇" "菘" "崧" "嵩" "忪" "悚" "淞" "锶" "竦" "㕬" "㧐" "㨦" "㩳" "㮸" "䉥" "䛦" "䜬" "䢠" "倯" "傱" "娀" "嵷" "庺" "愯" "慫" "憽" "捒" "枀" "柗" "梥" "楤" "樬" "檧" "漎" "濍" "硹" "縱" "聳" "蜙" "訟" "誦" "鍶" "鏓" "頌" "餸" "駷" "鬆"))
  ((("s" "o" "u")) ("搜" "嗽" "艘" "漱" "擞" "叟" "薮" "嗖" "嗾" "馊" "涑" "溲" "飕" "瞍" "锼" "螋" "㖩" "㛐" "㟬" "㵻" "䈹" "䉤" "䏂" "䮟" "傁" "叜" "廀" "廋" "捜" "摉" "擻" "櫢" "滫" "潄" "獀" "瘶" "籔" "膄" "蒐" "藪" "鄋" "醙" "鎪" "颼" "餿" "騪" "𢲷" "𥈟"))
  ((("s" "u")) ("速" "诉" "素" "肃" "塑" "宿" "俗" "苏" "酥" "粟" "僳" "溯" "缩" "夙" "谡" "蔌" "蓿" "嗉" "愫" "涑" "簌" "觫" "稣" "㑉" "㑛" "㓘" "㔄" "㕖" "㜚" "㝛" "㥛" "㨞" "㩋" "㪩" "㬘" "㯈" "㴋" "㴑" "㴼" "䃤" "䅇" "䇤" "䌚" "䎘" "䏋" "䑿" "䔎" "䘻" "䛾" "䥔" "䩳" "傃" "囌" "塐" "嫊" "愬" "憟" "栜" "榡" "樕" "橚" "櫯" "殐" "泝" "溸" "溹" "潥" "玊" "珟" "璛" "甦" "碿" "穌" "窣" "粛" "縤" "縮" "肅" "膆" "藗" "蘇" "蘓" "蜶" "訴" "誎" "謖" "趚" "蹜" "遡" "遬" "鋉" "餗" "驌" "骕" "鱐" "鷫" "鹔"))
  ((("s" "u" "a" "n")) ("算" "酸" "蒜" "选" "撰" "狻" "㔯" "㱹" "匴" "痠" "祘" "笇" "筭" "篹" "選"))
  ((("s" "u" "i")) ("随" "虽" "岁" "碎" "隧" "穗" "粹" "队" "尿" "莎" "隋" "绥" "髓" "遂" "祟" "蓑" "谇" "荽" "濉" "邃" "彗" "攵" "燧" "眭" "睢" "㒸" "㞸" "㥞" "㴚" "㵦" "㻟" "㻪" "㻽" "䅑" "䅗" "䆳" "䉌" "䍁" "䔹" "䜆" "䜔" "䠔" "䡵" "䢫" "䤭" "䥙" "䭉" "䯝" "䲀" "亗" "倠" "哸" "埣" "夊" "嬘" "嵗" "巂" "旞" "檅" "檖" "歲" "歳" "毸" "浽" "滖" "澻" "瀡" "煫" "熣" "璲" "瓍" "睟" "砕" "禭" "穂" "穟" "篲" "綏" "縗" "繀" "繐" "繸" "膸" "芕" "荾" "葰" "蔧" "襚" "誶" "譢" "賥" "遀" "遺" "鐆" "鐩" "隊" "隨" "雖" "雟" "靃" "鞖" "髄" "𡑞"))
  ((("s" "u" "n")) ("损" "孙" "餐" "笋" "荪" "狲" "飧" "榫" "跣" "隼" "㔼" "㡄" "㦏" "㰂" "䁚" "䐣" "孫" "愻" "損" "搎" "栒" "槂" "潠" "猻" "筍" "箰" "簨" "蓀" "蕵" "薞" "鎨" "飡" "飱" "鶽"))
  ((("s" "u" "o")) ("所" "缩" "索" "锁" "嗦" "琐" "霍" "莎" "沙" "衰" "蓑" "梭" "唆" "牺" "些" "唢" "嗍" "逡" "娑" "桫" "挲" "睃" "羧" "㪽" "㮦" "䂹" "䅴" "䈗" "䌇" "䐝" "䖛" "䗢" "䞆" "䞽" "䣔" "䵀" "傞" "嗩" "惢" "挱" "摍" "摵" "擌" "暛" "樎" "洓" "溑" "溹" "犧" "獻" "瑣" "璅" "瘷" "簑" "簔" "縮" "莏" "褨" "趖" "蹜" "逤" "鎍" "鎖" "鎻" "鏁" "鏼" "髿" "𧴪"))
  ((("t" "a")) ("他" "她" "它" "踏" "塔" "塌" "蹋" "搭" "达" "獭" "挞" "拓" "嗒" "闼" "溻" "漯" "遢" "榻" "沓" "铊" "趿" "鳎" "㒓" "㗳" "㛥" "㣛" "㣵" "㧺" "㭼" "㯓" "㳠" "㳫" "㹺" "㺚" "㿹" "䂿" "䈋" "䈳" "䌈" "䍇" "䍝" "䎓" "䑜" "䑽" "䓠" "䜚" "䠅" "䪚" "䳴" "䵬" "䶀" "䶁" "亣" "傝" "嚃" "嚺" "墖" "崉" "搨" "撻" "榙" "橽" "毾" "涾" "澾" "濌" "濕" "牠" "狧" "獺" "祂" "禢" "羍" "荅" "誻" "譶" "跶" "蹹" "躂" "躢" "迖" "達" "遝" "鉈" "錔" "鎉" "鑉" "闒" "闟" "闥" "阘" "靸" "鞈" "鞜" "鞳" "韃" "鮙" "鰨" "龖" "龘"))
  ((("t" "a" "i")) ("太" "台" "态" "抬" "胎" "汰" "大" "能" "苔" "泰" "酞" "邰" "薹" "呔" "骀" "肽" "炱" "钛" "跆" "鲐" "㑷" "㒗" "㘆" "㙜" "㙵" "㣍" "㥭" "㬃" "㷘" "㸀" "䈚" "䑓" "䢰" "䣭" "儓" "冭" "囼" "坮" "夳" "奤" "嬯" "孡" "忕" "忲" "態" "擡" "斄" "旲" "曃" "枱" "檯" "汏" "溙" "炲" "燤" "箈" "籉" "臺" "舦" "菭" "詒" "鈦" "颱" "駘" "鮐"))
  ((("t" "a" "n")) ("谈" "叹" "探" "坦" "炭" "摊" "滩" "碳" "弹" "贪" "潭" "毯" "痰" "胆" "淡" "沈" "坍" "瘫" "坛" "檀" "谭" "袒" "舔" "炎" "湛" "郯" "荨" "蕈" "澹" "昙" "赕" "膻" "忐" "眈" "钽" "锬" "镡" "覃" "㒎" "㛶" "㪔" "㫜" "㲜" "㲭" "㵃" "㵅" "㶒" "㷋" "㺥" "㽎" "㽑" "䀡" "䃪" "䆱" "䉡" "䊤" "䏙" "䐺" "䕊" "䗊" "䜖" "䞡" "䢻" "䦔" "䨢" "倓" "傝" "僋" "儃" "啴" "嗿" "嘆" "嘽" "嘾" "埮" "墰" "墵" "壇" "壜" "婒" "彈" "怹" "惔" "憛" "憳" "憻" "抩" "撢" "擹" "攤" "曇" "榃" "橝" "歎" "湠" "漢" "灘" "璮" "癉" "癱" "禪" "禫" "緂" "罈" "罎" "舑" "舕" "舚" "艢" "菼" "蕁" "藫" "蟫" "襢" "談" "譚" "譠" "貚" "貪" "賧" "贉" "醈" "醓" "醰" "鉭" "錟" "鐔" "餤" "驔" "黮"))
  ((("t" "a" "n" "g")) ("躺" "堂" "糖" "趟" "塘" "倘" "汤" "烫" "膛" "淌" "搪" "挡" "棠" "唐" "傥" "帑" "饧" "惝" "溏" "瑭" "樘" "铴" "镗" "耥" "螗" "螳" "羰" "醣" "㑽" "㒉" "㙶" "㜍" "㦂" "㭻" "㲥" "㼒" "㼺" "㿩" "䅯" "䉎" "䌅" "䕋" "䟖" "䣘" "䧜" "伖" "偒" "傏" "儻" "劏" "啺" "嘡" "坣" "戃" "摚" "摥" "擋" "攩" "曭" "榶" "橖" "湯" "漟" "煻" "燙" "爣" "矘" "磄" "禟" "篖" "糃" "糛" "膅" "蓎" "蕩" "薚" "蝪" "赯" "踼" "蹚" "逿" "鄌" "鎕" "鎲" "鏜" "鐋" "鐺" "钂" "镋" "閶" "闛" "隚" "餳" "餹" "饄" "鶶" "鼞" "𢠵" "𧼮" "𨌩"))
  ((("t" "a" "o")) ("讨" "套" "逃" "掏" "桃" "萄" "淘" "陶" "涛" "滔" "绸" "绦" "挑" "跳" "鼗" "叨" "啕" "洮" "韬" "焘" "饕" "㚐" "㹗" "䄻" "䚯" "䚵" "䛌" "䛬" "䬞" "䱇" "䵚" "匋" "咷" "夲" "嫍" "弢" "慆" "搯" "梼" "槄" "檮" "濤" "燾" "瑫" "祹" "籌" "絛" "綢" "綯" "縚" "縧" "绹" "翢" "蜪" "裪" "討" "詜" "謟" "轁" "迯" "醄" "鋾" "錭" "鞀" "鞉" "鞱" "韜" "飸" "饀" "駣" "騊"))
  ((("t" "e")) ("特" "贷" "忒" "忑" "慝" "铽" "㥂" "㧹" "棏" "犆" "職" "脦" "蚮" "螣" "蟘" "貣" "貸" "鋱" "鴏"))
  ((("t" "e" "i")) ("忒"))
  ((("t" "e" "n" "g")) ("疼" "腾" "藤" "誊" "滕" "䒅" "䕨" "䠮" "䲍" "䲢" "儯" "幐" "漛" "籐" "籘" "縢" "膯" "蕛" "螣" "謄" "邆" "駦" "騰" "驣" "鰧" "鼟"))
  ((("t" "i")) ("体" "题" "提" "替" "踢" "梯" "屉" "惕" "蹄" "涕" "剔" "啼" "达" "堤" "狄" "弟" "肆" "锑" "嚏" "剃" "锡" "倜" "谛" "荑" "悌" "逖" "绨" "缇" "棣" "睇" "鹈" "裼" "醍" "㖒" "㖷" "㗣" "㡗" "㣢" "㬱" "㯩" "䅠" "䈕" "䌡" "䎮" "䔶" "䗖" "䙗" "䚣" "䛱" "䝰" "䞶" "䢰" "䣠" "䣡" "䣽" "䧅" "䨑" "䪆" "䫮" "䬫" "䬾" "䯜" "䱱" "䴘" "䶍" "䶏" "䶑" "俤" "俶" "偍" "厗" "嗁" "嚔" "媂" "媞" "屜" "崹" "悐" "惖" "惿" "挮" "掦" "揥" "擿" "歒" "殢" "洟" "漽" "珶" "瑅" "睼" "碮" "禔" "禵" "稊" "籊" "綈" "緹" "罤" "苐" "蕛" "薙" "蝭" "褅" "褆" "詆" "諦" "謕" "趧" "趯" "踶" "蹏" "躍" "躰" "軆" "迏" "迖" "逷" "遆" "達" "適" "銻" "錫" "鍗" "鐟" "隄" "題" "騠" "骵" "體" "髢" "髰" "鬀" "鬄" "鮧" "鮷" "鯷" "鳀" "鵜" "鶗" "鶙" "鷈" "鷉" "鷤" "鼶" "𡲕"))
  ((("t" "i" "a" "n")) ("天" "田" "添" "甜" "填" "舔" "蚕" "颠" "滇" "佃" "甸" "苫" "恬" "腆" "沾" "掭" "嗔" "忝" "阗" "栝" "殄" "町" "畋" "钿" "锘" "蚺" "㐁" "㑷" "㖭" "㙉" "㤁" "㥏" "㧂" "㧱" "㮇" "㶺" "䄕" "䄹" "䄼" "䄽" "䏦" "䐌" "䑚" "䟧" "䠄" "䡒" "䡘" "䣯" "䣶" "䥖" "䧃" "䩄" "䩞" "倎" "兲" "唺" "塡" "婖" "屇" "悿" "搷" "晪" "沗" "沺" "淟" "湉" "煔" "瑱" "璳" "甛" "畑" "盷" "睓" "磌" "窴" "紾" "緂" "胋" "舚" "菾" "蚦" "覥" "觍" "賟" "酟" "鈿" "錪" "鍩" "鎭" "鎮" "闐" "靔" "靝" "靦" "頲" "顛" "颋" "餂" "鷆" "鷏" "黇" "𧰊"))
  ((("t" "i" "a" "o")) ("条" "跳" "调" "挑" "粜" "眺" "超" "稠" "迢" "赵" "佻" "苕" "祧" "铫" "窕" "蜩" "笤" "踔" "龆" "鲦" "髫" "㑿" "㕮" "㟘" "㩖" "㸠" "䂪" "䎄" "䒒" "䖺" "䟭" "䠷" "䧂" "䩦" "䯾" "䱔" "䳂" "嬥" "宨" "岧" "岹" "庣" "恌" "旫" "晀" "朓" "條" "樤" "祒" "窱" "糶" "絩" "聎" "脁" "脩" "芀" "萔" "蓧" "蓨" "覜" "誂" "調" "趒" "趙" "銚" "鋚" "鎥" "鞗" "頫" "鮡" "鯈" "鰷" "齠"))
  ((("t" "i" "e")) ("铁" "贴" "蝶" "帖" "沾" "萜" "揲" "锇" "餮" "䂿" "䥫" "䩞" "䴴" "䵿" "呫" "怗" "蛈" "貼" "跕" "鉄" "鉆" "銕" "鋨" "鐡" "鐵" "飻" "驖" "鴩"))
  ((("t" "i" "n" "g")) ("听" "停" "挺" "庭" "厅" "亭" "艇" "蜓" "烃" "汀" "廷" "莛" "葶" "婷" "梃" "町" "铤" "耵" "霆" "㹶" "㼗" "䅍" "䋼" "䗴" "䦐" "䫖" "䱓" "䵺" "侹" "厛" "圢" "嵉" "庁" "廰" "廳" "朾" "桯" "楟" "榳" "涏" "渟" "濎" "烴" "烶" "珽" "甼" "筳" "綎" "耓" "聤" "聴" "聼" "聽" "脡" "艼" "蝏" "誔" "諪" "邒" "鋌" "閮" "鞓" "頲" "颋" "鯅" "鼮"))
  ((("t" "o" "n" "g")) ("同" "通" "统" "痛" "铜" "桶" "童" "筒" "侗" "恫" "洞" "桐" "酮" "瞳" "彤" "捅" "重" "佟" "僮" "仝" "垌" "茼" "嗵" "峒" "恸" "潼" "砼" "硐" "艟" "㛚" "㠉" "㠽" "㣚" "㣠" "㤏" "㪌" "㮔" "㸗" "㼧" "㼿" "䂈" "䆚" "䆹" "䮵" "䳋" "䴀" "䶱" "勭" "哃" "姛" "峂" "峝" "庝" "慟" "憅" "晍" "曈" "朣" "樋" "橦" "氃" "浵" "炵" "烔" "熥" "燑" "爞" "犝" "狪" "獞" "痌" "硧" "秱" "穜" "筩" "粡" "絧" "統" "綂" "罿" "膧" "蓪" "蕫" "蘣" "蚒" "衕" "詷" "赨" "迵" "鉖" "鉵" "銅" "餇" "鮦" "鲖" "鼕" "鼨"))
  ((("t" "o" "u")) ("头" "透" "投" "偷" "逗" "愉" "亠" "钭" "骰" "㓱" "㕻" "㖣" "㡏" "㢏" "㤟" "㪗" "㳆" "㼥" "䕱" "䞬" "䟝" "䡩" "䱏" "䵉" "偸" "匬" "坄" "妵" "婾" "媮" "斢" "牏" "紏" "綉" "諭" "諳" "酘" "鈄" "鍮" "頭" "黈"))
  ((("t" "u")) ("土" "图" "突" "途" "徒" "涂" "兔" "吐" "凸" "屠" "秃" "跌" "堍" "芏" "荼" "菟" "钍" "酴" "㭸" "㻌" "㻠" "㻬" "㻯" "䅷" "䖘" "䠈" "䣄" "䣝" "䤅" "䩣" "䭭" "䳜" "䴛" "兎" "凃" "唋" "啚" "図" "圖" "圗" "圡" "堗" "塗" "宊" "峹" "嵞" "嶀" "庩" "廜" "怢" "悇" "捈" "捸" "揬" "梌" "涋" "湥" "潳" "瑹" "痜" "瘏" "禿" "稌" "筡" "腞" "腯" "葖" "蒤" "跿" "釷" "鈯" "鋵" "鍎" "馟" "駼" "鵌" "鵚" "鵵" "鶟" "鷋" "鷵" "鼵" "𨑒"))
  ((("t" "u" "a" "n")) ("团" "揣" "敦" "税" "湍" "砖" "抟" "彖" "疃" "鹑" "㩛" "䊜" "䜝" "䳪" "䵯" "剬" "剸" "団" "團" "慱" "摶" "槫" "漙" "煓" "猯" "畽" "磚" "稅" "篿" "糰" "褖" "貒" "鏄" "鱄" "鶉" "鷻" "黗"))
  ((("t" "u" "i")) ("推" "腿" "退" "税" "颓" "蜕" "褪" "追" "萑" "忒" "煺" "㞂" "㢈" "㢑" "㥆" "㦌" "㰐" "㱣" "㷟" "㾯" "㾼" "㾽" "㿉" "㿗" "䀃" "䅪" "䍾" "䩣" "䫋" "俀" "僓" "墤" "娧" "尵" "弚" "橔" "稅" "穨" "脫" "蓷" "藬" "蘈" "蛻" "蹆" "蹪" "隤" "頹" "頺" "頽" "饋" "駾" "骽" "魋"))
  ((("t" "u" "n")) ("吞" "纯" "敦" "囤" "褪" "屯" "臀" "逐" "氽" "饨" "沌" "暾" "肫" "豚" "炖" "窀" "㖔" "㞘" "㧷" "㩔" "㹠" "㼊" "呑" "啍" "噋" "坉" "忳" "旽" "朜" "涒" "焞" "燉" "純" "臋" "芚" "訰" "豘" "軘" "迍" "霕" "飩" "魨" "鲀"))
  ((("t" "u" "o")) ("脱" "拖" "驼" "托" "妥" "驮" "唾" "椭" "池" "舵" "魄" "蛇" "税" "说" "隋" "绥" "它" "鸵" "陀" "拓" "砖" "乇" "佗" "坨" "摭" "庹" "沲" "沱" "迤" "柝" "柁" "橐" "砣" "铊" "箨" "酏" "酡" "跎" "鼍" "㟎" "㯐" "㰐" "㵃" "㸰" "㸱" "㼠" "㾃" "䍫" "䓕" "䡐" "䪑" "䭾" "䰿" "䲊" "䲦" "䴱" "仛" "侂" "侻" "咃" "堶" "媠" "嫷" "岮" "彵" "扡" "扥" "拕" "挩" "捝" "撱" "杔" "棁" "楕" "槖" "橢" "毤" "毻" "汑" "沰" "涶" "牠" "狏" "矺" "砤" "碢" "磚" "稅" "籜" "紽" "綏" "脫" "舃" "莌" "萚" "蘀" "蟺" "袉" "託" "詑" "說" "説" "讬" "跅" "軃" "迱" "鉈" "阤" "陁" "鞁" "飥" "饦" "馱" "馲" "駄" "駝" "駞" "騨" "驒" "驝" "魠" "鮀" "鰖" "鱓" "鴕" "鵎" "鼉" "鼧" "𥓿"))
  ((("w" "a")) ("挖" "哇" "蛙" "瓦" "娃" "袜" "凹" "洼" "污" "鞋" "佤" "娲" "腽" "鲑" "㒝" "㧚" "㰪" "㼘" "䍪" "䎳" "䚴" "䠚" "劸" "咓" "啘" "嗗" "嗢" "婠" "媧" "徍" "搲" "攨" "汙" "汚" "淴" "溛" "漥" "畖" "穵" "窊" "窐" "窪" "聉" "膃" "襪" "邷" "韈" "韤" "鮭" "鼃" "𩋘"))
  ((("w" "a" "i")) ("外" "歪" "夭" "呙" "崴" "㖞" "㨤" "䠿" "咼" "喎" "懀"))
  ((("w" "a" "n")) ("完" "万" "晚" "碗" "玩" "弯" "挽" "顽" "湾" "惋" "丸" "豌" "关" "贯" "蔓" "娩" "烷" "皖" "宛" "婉" "腕" "剜" "芄" "莞" "菀" "浣" "纨" "绾" "琬" "脘" "畹" "蜿" "箢" "鲩" "鞔" "㜶" "㝃" "㝴" "㸘" "㺜" "㼝" "㽜" "㽹" "㿸" "䂺" "䅋" "䈮" "䏦" "䑱" "䖤" "䗕" "䘼" "䛷" "䝹" "䥑" "䩊" "䯈" "䯛" "䳃" "䵥" "仴" "倇" "刓" "卍" "卐" "埦" "夗" "婠" "帵" "彎" "忨" "抏" "捖" "捥" "晩" "晼" "杬" "梚" "椀" "汍" "涴" "潫" "澣" "灣" "琓" "盌" "睌" "睕" "紈" "綄" "綩" "綰" "翫" "脕" "莧" "莬" "萖" "萬" "薍" "蟃" "貦" "貫" "贎" "踠" "輐" "輓" "鄤" "鋄" "鋔" "錽" "鎫" "関" "頑" "魭" "鯇" "𦙵"))
  ((("w" "a" "n" "g")) ("望" "往" "忘" "王" "网" "亡" "妄" "旺" "枉" "汪" "方" "皇" "芒" "盲" "罔" "尢" "惘" "辋" "魍" "㑌" "㓁" "㔞" "㲿" "㳹" "㴏" "䋄" "䋞" "䒽" "䛃" "䤑" "䰣" "亾" "仼" "兦" "尣" "尩" "尪" "尫" "彺" "徃" "忹" "暀" "朢" "棢" "瀇" "琞" "盳" "網" "罒" "莣" "菵" "蚟" "蛧" "蝄" "誷" "輞" "迋" "迬"))
  ((("w" "e" "i")) ("为" "位" "委" "围" "伟" "微" "维" "卫" "未" "危" "味" "唯" "威" "谓" "尾" "喂" "惟" "违" "胃" "慰" "伪" "纬" "苇" "畏" "偎" "桅" "猬" "巍" "立" "韦" "潍" "萎" "蔚" "魏" "渭" "尉" "遗" "倭" "诿" "阢" "隈" "隗" "圩" "芟" "荽" "葳" "薇" "囗" "帏" "帷" "崴" "嵬" "猗" "猥" "闱" "沩" "洧" "涠" "逶" "娓" "玮" "韪" "軎" "炜" "煨" "熨" "眭" "痿" "艉" "隹" "鲔" "㕒" "㖐" "㛱" "㞇" "㞑" "㟪" "㟴" "㠕" "㢻" "㣲" "㥜" "㥨" "㦣" "㧑" "㨊" "㨒" "㬙" "㭏" "㱬" "㷉" "㸵" "㺔" "㻰" "㾯" "䃬" "䅏" "䇻" "䈧" "䉠" "䍴" "䍷" "䑊" "䓕" "䓺" "䔺" "䗆" "䗽" "䘙" "䙟" "䙿" "䛪" "䜅" "䜜" "䝐" "䞔" "䡺" "䣀" "䥆" "䥩" "䦱" "䧦" "䩈" "䩞" "䪋" "䪘" "䫥" "䬐" "䬑" "䬿" "䭳" "䮹" "䱞" "䲁" "䲘" "䵋" "䵢" "䵳" "亹" "偉" "偽" "僞" "儰" "叞" "喡" "喴" "囲" "圍" "壝" "媁" "媙" "媦" "嬒" "寪" "峗" "峞" "崣" "嵔" "幃" "廆" "彙" "徫" "徻" "愄" "愇" "揋" "斖" "暐" "梶" "椲" "椳" "楲" "欈" "洈" "浘" "渨" "湋" "溈" "溦" "溾" "潙" "潿" "濊" "濰" "濻" "瀢" "為" "烓" "煒" "煟" "熭" "燰" "爲" "犚" "犩" "琟" "瑋" "痏" "癓" "矀" "硊" "硙" "碨" "磈" "磑" "維" "緭" "緯" "罻" "腲" "芕" "芛" "苿" "荱" "菋" "葦" "葨" "蒍" "蓶" "蔿" "薉" "薳" "薶" "藯" "蘤" "蘶" "蜲" "蜼" "蝛" "蝟" "螱" "衛" "衞" "褽" "覣" "覹" "觹" "詴" "諉" "謂" "讆" "讏" "贀" "踓" "躗" "躛" "轊" "違" "遺" "鄬" "醀" "錗" "鍏" "鍡" "鏏" "闈" "隇" "霨" "霺" "韋" "韑" "韙" "韡" "頠" "颹" "餧" "餵" "骩" "骪" "骫" "鮇" "鮠" "鮪" "鰃" "鰄" "鰖" "鳂" "鳚" "鷕"))
  ((("w" "e" "n")) ("问" "文" "温" "稳" "闻" "纹" "蚊" "吻" "瘟" "紊" "限" "眼" "刎" "愠" "阌" "汶" "玟" "珉" "璺" "殁" "笏" "雯" "㒚" "㖧" "㗃" "㝧" "㟩" "㡈" "㳷" "㵮" "㼂" "䎹" "䎽" "䘇" "䦤" "䦷" "䰚" "伆" "呡" "問" "塭" "妏" "彣" "抆" "揾" "搵" "昷" "桽" "歾" "殟" "渂" "溫" "炆" "煴" "熓" "珳" "琝" "瑥" "瘒" "瞃" "穏" "穩" "紋" "絻" "缊" "聞" "肳" "脗" "舋" "芠" "莬" "蕰" "蘊" "蚉" "螡" "蟁" "豱" "輼" "轀" "辒" "閺" "閿" "闅" "闦" "韞" "馧" "馼" "魰" "鰛" "鰮" "鳁" "鳼" "鴍" "鴖" "鼤"))
  ((("w" "e" "n" "g")) ("嗡" "翁" "瓮" "蓊" "蕹" "㘢" "㜲" "䐥" "䤰" "䨴" "勜" "塕" "奣" "嵡" "暡" "浻" "滃" "甕" "瞈" "罋" "聬" "螉" "鎓" "霐" "鶲" "鹟" "齆" "𦧅"))
  ((("w" "o")) ("我" "握" "窝" "卧" "涡" "沃" "蜗" "果" "瘟" "挝" "斡" "夭" "倭" "莴" "喔" "幄" "渥" "肟" "硪" "龌" "㠗" "㠛" "㦱" "㧴" "㱧" "䀑" "䁊" "䁷" "䂺" "䙠" "䠎" "䩊" "䮸" "䰀" "偓" "唩" "婐" "婑" "捰" "捾" "撾" "擭" "楃" "涴" "涹" "渦" "濄" "濣" "焥" "猧" "窩" "緺" "臥" "萵" "蒦" "薶" "蝸" "踒" "齷"))
  ((("w" "u")) ("物" "无" "五" "屋" "误" "务" "武" "午" "伍" "舞" "污" "雾" "乌" "悟" "恶" "侮" "捂" "诬" "呜" "蜈" "母" "亡" "巫" "钨" "芜" "梧" "吾" "吴" "毋" "坞" "戊" "晤" "勿" "兀" "仵" "阢" "邬" "圬" "垭" "芴" "唔" "庑" "怃" "忤" "浯" "渥" "寤" "迕" "妩" "婺" "骛" "杌" "牾" "於" "焐" "瞀" "鹉" "鹜" "痦" "蝥" "笏" "鋈" "鼯" "㐅" "㐳" "㑄" "㒇" "㝟" "㡔" "㤇" "㬳" "㱱" "㵲" "㷻" "㹳" "㻍" "㽾" "䀛" "䃖" "䅶" "䉑" "䍢" "䎸" "䑁" "䒉" "䓊" "䚈" "䛩" "䜑" "䟼" "䡧" "䦍" "䦜" "䨁" "䫓" "䮏" "䳇" "䳱" "亾" "俉" "倵" "儛" "剭" "務" "卼" "吳" "呉" "啎" "嗚" "噁" "塢" "墲" "奦" "娒" "娪" "娬" "媉" "嫵" "屼" "岉" "峿" "嵍" "嵨" "廡" "弙" "忢" "悞" "悮" "惡" "憮" "扝" "扤" "摀" "敄" "旿" "杇" "橆" "歍" "汙" "汚" "沕" "洖" "洿" "溩" "潕" "烏" "無" "熃" "熓" "玝" "珷" "珸" "瑦" "璑" "甒" "矹" "矻" "碔" "祦" "禑" "窏" "窹" "箼" "粅" "腛" "膴" "茣" "莁" "蕪" "蘁" "螐" "誈" "誣" "誤" "躌" "逜" "遻" "郚" "鄔" "鋘" "鋙" "鎢" "铻" "陓" "隖" "霚" "霧" "靰" "騖" "鯃" "鰞" "鴮" "鵐" "鵡" "鶩" "鷡" "鹀" "麌" "鼿" "齀" "齬" "兀"))
  ((("x" "i")) ("西" "细" "习" "席" "系" "喜" "息" "吸" "希" "洗" "戏" "析" "惜" "悉" "牺" "稀" "媳" "袭" "嘻" "溪" "膝" "晰" "隙" "熄" "夕" "锡" "蟋" "犀" "赫" "既" "腊" "猎" "栖" "畦" "洒" "鳃" "屎" "撕" "嘶" "昔" "熙" "硒" "矽" "烯" "汐" "檄" "铣" "携" "僖" "兮" "诶" "隰" "郄" "郗" "茜" "菥" "葸" "蓰" "奚" "唏" "徙" "饩" "阋" "浠" "淅" "澌" "屣" "嬉" "玺" "樨" "曦" "觋" "欷" "歙" "熹" "禊" "禧" "嵇" "皙" "穸" "裼" "褶" "蜥" "蜴" "螅" "舄" "舾" "羲" "粞" "翕" "酾" "醯" "蹊" "鼷" "㑶" "㒆" "㔒" "㗩" "㗲" "㙾" "㚛" "㜎" "㞒" "㠄" "㣟" "㤴" "㤸" "㥡" "㦻" "㩗" "㪪" "㭡" "㱱" "㳀" "㳧" "㵿" "㸍" "㹫" "㽯" "㿇" "䀘" "䂀" "䈪" "䊠" "䏮" "䐼" "䑂" "䒁" "䓇" "䘮" "䙽" "䚂" "䚉" "䚫" "䚷" "䛥" "䜁" "䜣" "䢄" "䦧" "䧍" "䨳" "䩤" "䫔" "䫣" "䮎" "䲪" "䴛" "䵱" "係" "俙" "傒" "僁" "凞" "匸" "卌" "卥" "厀" "呬" "咥" "唽" "喺" "噏" "嚊" "嚱" "囍" "塈" "墍" "壐" "娭" "媐" "嬆" "屃" "屓" "屖" "屭" "嵠" "嶍" "嶲" "巇" "徆" "徯" "忚" "忥" "怬" "怷" "怸" "恄" "恓" "悕" "惁" "憘" "憙" "戯" "戱" "戲" "扢" "扱" "扸" "捿" "摡" "擕" "攜" "攦" "敼" "旣" "晞" "晢" "晳" "暿" "枲" "桸" "棤" "棲" "椞" "椺" "榽" "槢" "橀" "檕" "欯" "歖" "氣" "氥" "滊" "漇" "漝" "潝" "潟" "澙" "濕" "濦" "灑" "焈" "焟" "焬" "煕" "熂" "熈" "熺" "熻" "燨" "爔" "犔" "犧" "狶" "獡" "獥" "獻" "琋" "璽" "瓗" "瘜" "盻" "睎" "睳" "瞦" "矖" "磎" "磶" "稧" "窸" "簁" "糦" "細" "綌" "緆" "縘" "縰" "繋" "繥" "繫" "纚" "绤" "羛" "習" "翖" "肸" "肹" "脅" "舃" "莃" "葈" "蒠" "蒵" "蓆" "蔇" "蕮" "薂" "虩" "螇" "蟢" "蠵" "衋" "襲" "襾" "覀" "覡" "覤" "觹" "觽" "觿" "訢" "誒" "諰" "謑" "謚" "謵" "譆" "谿" "豀" "豨" "豯" "貕" "赥" "赩" "趘" "蹝" "躧" "遟" "遲" "郋" "郤" "鄎" "酅" "釃" "釐" "釳" "釸" "鉨" "鉩" "銑" "錫" "錯" "鎎" "鎴" "鏭" "鑴" "钖" "闟" "隟" "隵" "雟" "霫" "霼" "飁" "餼" "饎" "騱" "騽" "驨" "鬩" "鰓" "鰼" "鱚" "鳛" "鵗" "鸂" "黊" "黖" "齂" "凞" "𠔃" "𥋟"))
  ((("x" "i" "a")) ("下" "夏" "吓" "峡" "瞎" "虾" "狭" "霞" "唬" "假" "洽" "匣" "辖" "暇" "侠" "厦" "挟" "斜" "押" "葭" "呷" "狎" "遐" "瑕" "柙" "毳" "歃" "硖" "瘕" "罅" "黠" "㗇" "㗿" "㘡" "㙈" "㙤" "㥦" "㭱" "㰺" "㵤" "㽠" "㿣" "䒠" "䒩" "䖎" "䖖" "䘥" "䛅" "䦖" "䨐" "䪗" "䫗" "䯟" "䶝" "丅" "俠" "傄" "冾" "叚" "嚇" "夓" "峽" "廈" "懗" "挾" "搳" "敮" "昰" "欱" "炠" "烚" "煆" "煵" "狹" "珨" "疜" "疨" "睱" "硤" "碬" "磍" "祫" "笚" "筪" "給" "縀" "縖" "翈" "舝" "舺" "芐" "蕸" "蝦" "諕" "譹" "谺" "赮" "轄" "郃" "鍜" "鎋" "鏬" "閕" "閜" "陜" "陿" "霅" "颬" "騢" "魻" "鰕" "鶷" "𡨄" "𨻲"))
  ((("x" "i" "a" "n")) ("现" "先" "线" "显" "见" "县" "限" "险" "纤" "鲜" "献" "闲" "陷" "掀" "宪" "嫌" "羡" "仙" "弦" "衔" "咸" "馅" "掺" "肩" "碱" "洒" "省" "铣" "洗" "锨" "贤" "舷" "涎" "腺" "癣" "矣" "冼" "苋" "莶" "藓" "岘" "彡" "猃" "濂" "暹" "娴" "氙" "燹" "祆" "黹" "钐" "锬" "鹇" "痃" "痫" "蚬" "筅" "籼" "酰" "跣" "跹" "霰" "㔓" "㔵" "㘅" "㘋" "㛾" "㜪" "㜷" "㡉" "㡾" "㢺" "㥦" "㦑" "㦓" "㦥" "㧋" "㧥" "㩈" "㩮" "㪇" "㫫" "㬎" "㬗" "㭠" "㭹" "㮭" "㯀" "㯗" "㯠" "㱹" "㲽" "㳄" "㳭" "㵪" "㶍" "㺌" "㽉" "㿅" "䀏" "䁂" "䃱" "䃸" "䄯" "䇒" "䉯" "䉳" "䏹" "䐄" "䒸" "䕔" "䗾" "䘆" "䙹" "䚚" "䜢" "䝨" "䞁" "䡅" "䢾" "䤼" "䥪" "䦘" "䦥" "䧋" "䧟" "䧮" "䨘" "䨷" "䱤" "䲗" "䵇" "䵖" "䵛" "䶟" "䶠" "䶢" "仚" "伣" "俔" "僊" "僩" "僴" "咞" "哯" "唌" "啣" "嗛" "嘕" "垷" "塪" "奾" "姭" "姺" "娊" "娹" "婱" "嫺" "嫻" "嬐" "孅" "尟" "尠" "屳" "峴" "崄" "嶮" "幰" "廯" "忺" "憪" "憲" "憸" "挦" "搟" "摻" "撊" "撏" "攇" "攕" "晅" "晛" "杴" "枮" "橌" "檻" "櫶" "毨" "涀" "澖" "瀗" "灑" "灦" "烍" "燅" "狝" "獫" "獮" "獻" "玁" "珗" "現" "甉" "癇" "癎" "癬" "県" "睍" "瞯" "瞷" "礆" "礥" "祅" "禒" "禰" "秈" "箲" "粯" "糮" "絃" "絤" "綅" "綫" "線" "縣" "纎" "纖" "缐" "羨" "羬" "胘" "脅" "臔" "臽" "苮" "莧" "葴" "蓒" "薟" "藖" "蘐" "蘚" "蘞" "蚿" "蛝" "蜆" "螊" "衘" "袨" "褼" "襳" "見" "覸" "訮" "誢" "諴" "豏" "賢" "贒" "赻" "蹮" "躚" "軐" "軒" "輱" "轞" "釤" "銑" "銛" "銜" "鋧" "錎" "錟" "鍁" "鍌" "鏾" "铦" "閑" "閒" "闞" "陥" "険" "險" "韅" "韯" "韱" "顕" "顯" "餡" "馦" "鮮" "鱻" "鶱" "鷳" "鷴" "鷼" "鹹" "麲" "鼸" "齴" "𠜎"))
  ((("x" "i" "a" "n" "g")) ("想" "象" "向" "相" "响" "乡" "项" "像" "香" "箱" "详" "享" "降" "巷" "橡" "祥" "厢" "镶" "翔" "亨" "攘" "襄" "湘" "洋" "样" "芗" "葙" "饷" "庠" "骧" "缃" "蟓" "舡" "鲞" "飨" "㐮" "㗽" "㟄" "㟟" "䇨" "䊑" "䐟" "䒂" "䔗" "䖮" "䙹" "䛠" "䜶" "䢽" "䣈" "䤔" "䦳" "䴂" "亯" "佭" "勷" "啌" "嚮" "塂" "奛" "嶑" "廂" "忀" "恦" "晑" "曏" "栙" "樣" "欀" "珦" "瓖" "絴" "緗" "纕" "缿" "膷" "萫" "薌" "蚃" "蠁" "襐" "詳" "跭" "郷" "鄉" "鄊" "鄕" "銗" "鐌" "鑲" "闀" "闂" "響" "項" "餉" "饗" "饟" "驤" "鬨" "鮝" "鯗" "鱌" "鱶" "麘" "祥"))
  ((("x" "i" "a" "o")) ("小" "笑" "消" "校" "效" "销" "晓" "肖" "宵" "削" "啸" "哮" "硝" "箫" "胶" "骄" "狡" "酵" "梢" "芍" "萧" "霄" "嚣" "淆" "孝" "爻" "茭" "哓" "潇" "逍" "姣" "骁" "绡" "枭" "枵" "蛸" "筱" "魈" "㑾" "㒆" "㔅" "㗛" "㚣" "㤊" "㩭" "㬵" "㹲" "䇃" "䊥" "䒁" "䒕" "䒝" "䕧" "䠛" "䥵" "䴛" "俲" "傚" "効" "呺" "咲" "啋" "嗃" "嘋" "嘐" "嘨" "嘯" "嘵" "嚻" "囂" "娎" "婋" "宯" "庨" "彇" "恔" "憢" "揱" "撨" "敩" "斅" "斆" "暁" "曉" "梟" "櫹" "歊" "歗" "殽" "毊" "洨" "涍" "潚" "澩" "瀟" "灱" "灲" "烋" "焇" "熽" "猇" "獟" "獢" "痚" "痟" "皛" "皢" "硣" "穘" "窙" "笅" "筿" "箾" "篠" "簘" "簫" "絞" "綃" "翛" "膮" "萷" "蕭" "藃" "藠" "虈" "虓" "蟏" "蟰" "蠨" "訤" "誟" "誵" "謏" "謞" "踃" "較" "郩" "銷" "鞩" "騷" "驍" "驕" "骹" "髇" "髐" "鮹" "鴞" "鸮"))
  ((("x" "i" "e")) ("些" "写" "鞋" "谢" "械" "协" "斜" "歇" "血" "胁" "卸" "携" "挟" "泄" "屑" "溉" "桔" "解" "契" "楔" "蝎" "邪" "谐" "蟹" "懈" "泻" "薛" "耶" "叶" "汁" "偕" "亵" "隰" "勰" "燮" "苴" "薤" "撷" "獬" "廨" "渫" "瀣" "迦" "邂" "绁" "缬" "榭" "榍" "歙" "眭" "颉" "跬" "躞" "鲑" "骱" "㒠" "㓔" "㔎" "㕐" "㖑" "㖿" "㙝" "㙰" "㚗" "㜦" "㝍" "㞒" "㞕" "㢵" "㣯" "㣰" "㥟" "㦪" "㨒" "㨙" "㨝" "㩉" "㩗" "㩦" "㩪" "㭨" "㰔" "㰡" "㳦" "㳿" "㴬" "㴮" "㴽" "㷎" "㸉" "㽊" "㽳" "䀘" "䁯" "䇋" "䉏" "䉣" "䊝" "䍖" "䏮" "䔑" "䕈" "䕵" "䙊" "䙎" "䙝" "䙽" "䚳" "䚸" "䞕" "䡡" "䢡" "䥱" "䥾" "䦏" "䦑" "䦖" "䩤" "䩧" "䪥" "䬅" "䭎" "䲒" "䵦" "伳" "偰" "冩" "劦" "協" "卨" "嗋" "垥" "塮" "奊" "妎" "娎" "媟" "寫" "屟" "屧" "嶰" "徢" "恊" "愶" "慀" "拹" "挾" "揳" "搚" "擑" "擕" "擷" "攜" "斺" "旪" "暬" "檞" "洩" "潰" "澥" "瀉" "灺" "炧" "焎" "熁" "燲" "爕" "猲" "疶" "祄" "禼" "籺" "糏" "紲" "絏" "絜" "絬" "綊" "緤" "緳" "纈" "缷" "翓" "脅" "脇" "脥" "膎" "葉" "薢" "藛" "蝢" "蠍" "蠏" "衸" "衺" "褉" "褻" "襭" "觟" "諜" "諧" "謝" "躠" "鋣" "靾" "鞢" "鞵" "韰" "頁" "頡" "駴" "鮭" "齘" "齥" "龤" "𩋘" "𩋧"))
  ((("x" "i" "n")) ("心" "新" "信" "辛" "欣" "薪" "芯" "寻" "锌" "衅" "款" "亲" "忻" "囟" "馨" "莘" "昕" "歆" "镡" "鑫" "㐰" "㚯" "㛛" "㜦" "㩪" "㭄" "㭡" "㹷" "㻸" "䎣" "䒖" "䚱" "䛨" "䜗" "䜣" "䪿" "䰼" "伈" "伩" "俽" "兓" "卂" "噷" "妡" "孞" "尋" "廞" "惞" "攳" "杺" "桪" "樳" "炘" "焮" "煡" "盺" "脪" "舋" "襑" "親" "訢" "訫" "軐" "鄩" "釁" "鈊" "鋅" "鐔" "阠" "顖" "馸" "骍" "鬵"))
  ((("x" "i" "n" "g")) ("行" "性" "形" "星" "兴" "型" "幸" "姓" "醒" "刑" "猩" "腥" "省" "惺" "邢" "杏" "研" "陉" "馨" "荇" "荥" "擤" "饧" "悻" "硎" "㐩" "㒷" "㓑" "㓝" "㝭" "㣜" "㨘" "㬐" "㮐" "㴆" "㼛" "㼬" "䁄" "䂔" "䋲" "䓷" "䛭" "䣆" "䤯" "䮍" "䰢" "䳙" "侀" "倖" "坓" "垶" "娙" "婞" "嬹" "曐" "桯" "洐" "涬" "渻" "滎" "濴" "烆" "煋" "熒" "狌" "瑆" "皨" "睲" "筕" "箵" "篂" "緈" "胻" "臖" "興" "莕" "蛵" "觪" "觲" "郉" "鈃" "鉶" "銒" "鋞" "鍟" "钘" "铏" "陘" "雽" "餳" "馫" "騂" "鮏" "鯹" "𢜫"))
  ((("x" "i" "o" "n" "g")) ("雄" "胸" "兄" "凶" "熊" "汹" "能" "匈" "芎" "㐫" "䎿" "䧺" "兇" "哅" "夐" "忷" "恟" "敻" "洶" "胷" "訩" "詗" "詾" "讻" "诇" "賯" "赨"))
  ((("x" "i" "u")) ("修" "休" "袖" "秀" "朽" "锈" "绣" "宿" "嗅" "臭" "羞" "莠" "咻" "岫" "馐" "庥" "溴" "煦" "鸺" "貅" "髹" "㗜" "㩰" "㱙" "㾋" "䜬" "俢" "嘼" "峀" "樇" "滫" "烋" "烌" "珛" "琇" "糔" "綇" "綉" "繍" "繡" "脩" "臹" "茠" "蓚" "褎" "褏" "銝" "銹" "鎀" "鏅" "鏥" "鏽" "飍" "饈" "髤" "鵂" "齅" "𦟤"))
  ((("x" "u")) ("许" "需" "须" "续" "序" "绪" "虚" "徐" "吁" "叙" "畜" "蓄" "嘘" "呼" "蔬" "邪" "墟" "戌" "酗" "旭" "恤" "絮" "婿" "于" "余" "屿" "芋" "豫" "馘" "诩" "勖" "圩" "蓿" "咻" "洫" "浒" "溆" "顼" "栩" "旮" "旯" "肷" "煦" "砉" "盱" "胥" "糈" "醑" "雩" "㐨" "㑔" "㑯" "㒷" "㕛" "㖅" "㗵" "㘧" "㚜" "㜅" "㜿" "㞊" "㞰" "㤢" "㥠" "㦌" "㦽" "㰲" "㵰" "㷦" "㺷" "㽳" "㾥" "䂆" "䂸" "䅡" "䋶" "䍱" "䔓" "䘏" "䙒" "䛙" "䜡" "䢕" "䣱" "䣴" "䦗" "䦽" "䧁" "䨆" "䬔" "䱛" "䳳" "伵" "侐" "俆" "偦" "冔" "勗" "卹" "呴" "喣" "嘔" "噓" "垿" "壻" "姁" "媭" "嬃" "嬬" "嶼" "幁" "怴" "慉" "掝" "揟" "敍" "敘" "旴" "昫" "晇" "朂" "楈" "槒" "欨" "欰" "欻" "歔" "歘" "殈" "汿" "沀" "淢" "湑" "滀" "滸" "漵" "潊" "烅" "獝" "珝" "珬" "疞" "盢" "盨" "瞁" "瞲" "矞" "祤" "稰" "稸" "窢" "籲" "緒" "緖" "縃" "繻" "續" "聟" "芌" "芧" "蒣" "蓲" "蕦" "藇" "藚" "虗" "虛" "蝑" "規" "訏" "許" "訹" "詡" "諝" "謳" "譃" "谞" "賉" "鄦" "鉏" "銊" "鑐" "須" "頊" "驉" "鬚" "魆" "魖" "魣" "鱮"))
  ((("x" "u" "a" "n")) ("选" "宣" "旋" "悬" "漩" "绚" "暄" "还" "暖" "券" "县" "轩" "喧" "玄" "癣" "眩" "撰" "儇" "谖" "埙" "萱" "揎" "擐" "馔" "泫" "洵" "涓" "渲" "璇" "楦" "炫" "煊" "碹" "铉" "镟" "痃" "㒸" "㔯" "㔵" "㘣" "㛐" "㜗" "㦏" "㧋" "㧦" "㯀" "㳙" "㳬" "㹡" "㾌" "㿅" "䁢" "䍗" "䍻" "䗠" "䘩" "䝮" "䠣" "䥧" "䧎" "䧟" "䩙" "䩰" "䮄" "䲂" "䲻" "䴉" "䴋" "伭" "佡" "吅" "咺" "喛" "埍" "塇" "塤" "壎" "妶" "媗" "嫙" "弲" "怰" "愃" "愋" "懁" "懸" "昍" "昡" "晅" "暅" "暶" "梋" "楥" "檈" "潠" "烜" "煖" "玆" "玹" "珣" "琁" "琄" "瑄" "璿" "瓊" "癬" "盤" "盷" "眴" "睻" "矎" "禤" "籑" "絢" "絹" "縣" "縼" "繏" "翧" "翾" "萲" "蔙" "蕿" "藼" "蘐" "蜁" "蜎" "蝖" "蠉" "衒" "袨" "誸" "諠" "諼" "譞" "讂" "讙" "贙" "軒" "選" "還" "鉉" "鋗" "鍹" "鏇" "鞙" "颴" "饌" "駽" "鶱" "鹮"))
  ((("x" "u" "e")) ("学" "雪" "血" "削" "靴" "炔" "薛" "穴" "谑" "噱" "泶" "踅" "鳕" "㔧" "㖸" "㙾" "㞽" "㡜" "㦜" "㧒" "㰒" "㶅" "㷤" "㿱" "䀜" "䋉" "䎀" "䒸" "䖼" "䛎" "䜡" "䠼" "䤕" "䨮" "䩈" "䫻" "䫼" "䬂" "䭥" "䱑" "乴" "吙" "吷" "坹" "學" "屵" "岤" "峃" "嶨" "斈" "桖" "泬" "澩" "烕" "燢" "狘" "瞲" "矆" "茓" "蒆" "觷" "謔" "謞" "趐" "辥" "雤" "鞾" "駥" "鱈" "鷽" "鸴" "𥄴" "𦥯"))
  ((("x" "u" "n")) ("迅" "讯" "寻" "训" "循" "旬" "询" "熏" "巡" "汛" "逊" "遁" "荤" "浚" "洒" "孙" "梭" "潭" "勋" "驯" "殉" "巽" "郇" "埙" "荀" "荨" "蕈" "薰" "峋" "徇" "狻" "獯" "恂" "洵" "浔" "逡" "曛" "窨" "醺" "鑫" "鲟" "㚯" "㜄" "㝁" "㟧" "㡄" "㢲" "㨚" "㯠" "㰊" "㰬" "㵌" "㽦" "䃀" "䋸" "䖲" "䘩" "䙉" "䛜" "䞊" "䡅" "䭀" "伨" "侚" "偱" "勛" "勲" "勳" "噀" "噚" "坃" "埈" "塤" "壎" "壦" "奞" "孫" "尋" "巺" "廵" "愻" "挦" "撏" "杊" "枔" "栒" "桪" "槆" "橁" "毥" "潃" "潠" "潯" "灥" "焄" "煇" "燂" "燅" "燖" "燻" "爋" "爓" "狥" "珣" "璕" "畃" "矄" "紃" "絢" "纁" "臐" "葷" "蔒" "蕁" "薫" "蘍" "蟫" "蟳" "訊" "訓" "訙" "詢" "賐" "迿" "遜" "鄩" "鑂" "陖" "韗" "顨" "馴" "駨" "鱏" "鱘" "鵔" "鵕" "𤑕"))
  ((("y" "a")) ("呀" "压" "牙" "鸦" "丫" "崖" "鸭" "押" "讶" "芽" "亚" "轧" "衙" "蚜" "哑" "歇" "邪" "涯" "雅" "厌" "御" "伢" "垭" "揠" "岈" "迓" "娅" "琊" "柙" "桠" "辂" "氩" "砑" "碣" "睚" "痖" "疋" "㝞" "㝦" "㤉" "㧎" "㮞" "㰳" "㼤" "㿿" "䂒" "䄰" "䅉" "䊦" "䍓" "䒁" "䖌" "䝟" "䢝" "䦪" "䧅" "䨙" "䪵" "䫖" "䯉" "䰲" "䵝" "亜" "亞" "俹" "劜" "厊" "厓" "厭" "唖" "啞" "嚈" "圠" "圧" "埡" "堐" "壓" "婭" "孲" "崕" "庌" "庘" "挜" "掗" "枒" "椏" "氬" "浥" "漄" "犽" "猒" "猚" "猰" "玡" "瘂" "稏" "窫" "笌" "聐" "蕥" "襾" "訝" "軋" "輅" "錏" "鐚" "铔" "閘" "雃" "顏" "顔" "鴉" "鴨" "鵪" "鵶" "鶕" "齖" "齾"))
  ((("y" "a" "i")) ("崖" "睚" "厓" "崕"))
  ((("y" "a" "n")) ("眼" "研" "验" "严" "烟" "演" "言" "沿" "颜" "掩" "盐" "岩" "厌" "燕" "延" "炎" "淹" "艳" "焰" "宴" "咽" "檐" "堰" "衍" "癌" "淡" "广" "狠" "蔫" "铅" "涎" "险" "羡" "焉" "阉" "蜒" "阎" "奄" "砚" "雁" "唁" "彦" "谚" "殷" "淫" "厣" "赝" "剡" "俨" "偃" "兖" "讠" "谳" "阽" "郾" "鄢" "埏" "芫" "菸" "崦" "恹" "闫" "阏" "洇" "湮" "滟" "妍" "嫣" "琰" "晏" "氤" "胭" "腌" "焱" "硎" "罨" "鹌" "覃" "筵" "酽" "趼" "魇" "餍" "鼹" "㒆" "㓧" "㕣" "㗴" "㘖" "㘙" "㚧" "㛪" "㡉" "㢂" "㢛" "㦔" "㫃" "㫟" "㬫" "㭺" "㰽" "㱌" "㱘" "㳂" "㶄" "㷔" "㷳" "㷼" "㺂" "㺗" "㿕" "㿼" "䀋" "䀽" "䁙" "䂩" "䂴" "䄋" "䅧" "䅬" "䇾" "䉷" "䊙" "䊻" "䌠" "䌪" "䍾" "䎦" "䑍" "䓂" "䕾" "䖗" "䗡" "䗺" "䘶" "䛳" "䜩" "䞁" "䢥" "䢭" "䣍" "䤷" "䦧" "䦲" "䨄" "䫡" "䭘" "䮗" "䱲" "䲓" "䳛" "䳺" "䴏" "䶫" "䶮" "乵" "偐" "偣" "傿" "儼" "兗" "剦" "匽" "厭" "厳" "厴" "唌" "啱" "喭" "噞" "嚥" "嚴" "塩" "墕" "壛" "壧" "夵" "妟" "姲" "姶" "姸" "娫" "娮" "婩" "嬊" "嬮" "嬿" "孍" "嵃" "嵒" "嵓" "嶖" "巌" "巖" "巗" "巘" "巚" "弇" "彥" "愝" "懕" "懨" "戭" "扊" "抁" "掞" "揅" "揜" "敥" "昖" "晻" "暥" "曕" "曣" "曮" "棪" "椻" "椼" "楌" "檿" "櫩" "歅" "沇" "淊" "渰" "渷" "湺" "滛" "漹" "灎" "灔" "灧" "灩" "烻" "焔" "煙" "燄" "爓" "牪" "狿" "猒" "珚" "琂" "甗" "硏" "硯" "硽" "碞" "礹" "篶" "簷" "綖" "縯" "羨" "臙" "艶" "艷" "莚" "萒" "葕" "蔅" "薟" "虤" "蝘" "裺" "褗" "覎" "觃" "觾" "詽" "諺" "讌" "讞" "豓" "豔" "豣" "贋" "贗" "躽" "這" "遃" "郔" "酀" "酓" "醃" "醼" "釅" "鈆" "鉛" "鋋" "錟" "閆" "閹" "閻" "閼" "闇" "隁" "隒" "險" "靨" "顃" "顏" "顔" "顩" "饜" "騐" "験" "騴" "驗" "驠" "魘" "鮟" "鰋" "鳫" "鴈" "鴳" "鵪" "鶠" "鷃" "鷰" "鹽" "麙" "麣" "黡" "黤" "黫" "黭" "黶" "鼴" "齞" "齴" "龑"))
  ((("y" "a" "n" "g")) ("样" "阳" "养" "央" "洋" "羊" "扬" "氧" "杨" "仰" "秧" "漾" "痒" "汤" "详" "殃" "鸯" "佯" "疡" "英" "徉" "怏" "泱" "炀" "烊" "恙" "蛘" "鞅" "㔦" "㟅" "㦹" "㨾" "㬕" "㺊" "㿮" "䁑" "䇦" "䍩" "䑆" "䒋" "䖹" "䞁" "䬗" "䬬" "䬺" "䭐" "䭥" "䵮" "佒" "傟" "劷" "勨" "卬" "咉" "坱" "垟" "姎" "岟" "崵" "慃" "懩" "抰" "揚" "攁" "敭" "旸" "昜" "暘" "柍" "楊" "様" "樣" "氱" "湯" "瀁" "炴" "煬" "玚" "珜" "瑒" "瘍" "癢" "眏" "眻" "禓" "紻" "羏" "羕" "胦" "蝆" "詇" "詳" "諹" "軮" "輰" "鉠" "鍚" "鐊" "阦" "陽" "霷" "颺" "飏" "飬" "養" "餋" "駚" "鰑" "鴦" "鸉"))
  ((("y" "a" "o")) ("要" "药" "摇" "咬" "腰" "窑" "耀" "吆" "邀" "遥" "谣" "舀" "钥" "侥" "乐" "么" "疟" "陶" "淆" "妖" "瑶" "尧" "姚" "淫" "由" "幼" "夭" "爻" "荛" "崤" "崾" "徭" "徼" "洮" "瀹" "幺" "珧" "杳" "轺" "曜" "肴" "祆" "铫" "鹞" "窈" "窕" "繇" "鳐" "㑸" "㑾" "㓞" "㔽" "㝔" "㞁" "㟱" "㢓" "㤊" "㨱" "㫏" "㫐" "㬭" "㮁" "㴭" "㵸" "㺒" "㿑" "㿢" "䁏" "䁘" "䂚" "䆙" "䆞" "䉰" "䋂" "䋤" "䌊" "䌛" "䍃" "䑬" "䒒" "䔄" "䖴" "䙅" "䚆" "䚺" "䚻" "䠛" "䢣" "䬙" "䭥" "䯚" "䳬" "䴠" "䶧" "仸" "倄" "偠" "傜" "儌" "喓" "嗂" "垚" "堯" "婹" "媱" "嬈" "宎" "尭" "岆" "峣" "嶢" "嶤" "愮" "抭" "揺" "搖" "暚" "枖" "柼" "楆" "榚" "榣" "樂" "殀" "殽" "溔" "滛" "烑" "熎" "燿" "猇" "猶" "猺" "獟" "瑤" "瘧" "眑" "瞭" "矅" "祅" "穾" "窅" "窔" "窯" "窰" "筄" "約" "艞" "苭" "葯" "葽" "蓔" "蕘" "薬" "藥" "蘨" "袎" "覞" "訞" "謠" "謡" "讑" "趭" "軺" "遙" "邎" "銚" "鎐" "鑰" "闄" "隃" "靿" "颻" "飖" "餆" "餚" "騕" "驁" "鰩" "鴁" "鷂" "鷕" "鼼" "齩" "𨍳"))
  ((("y" "e")) ("也" "业" "夜" "爷" "野" "叶" "液" "冶" "页" "咽" "射" "邪" "斜" "椰" "噎" "耶" "掖" "曳" "腋" "拽" "靥" "谒" "邺" "荼" "揶" "揲" "洇" "琊" "晔" "烨" "铘" "㐖" "㓈" "㖡" "㖶" "㗼" "㙒" "㙪" "㜇" "㝣" "㡋" "㥷" "㩎" "㩪" "㪑" "㭨" "㱉" "㱌" "㴸" "㷸" "㸣" "㽢" "䅬" "䈎" "䊦" "䎨" "䓉" "䔑" "䖣" "䝟" "䤳" "䤶" "䥟" "䥡" "䥺" "䧨" "䭎" "䭟" "䲜" "䳖" "䴾" "亱" "倻" "偞" "僷" "吔" "啘" "嘢" "埜" "堨" "墷" "壄" "峫" "嶪" "嶫" "忦" "抴" "捓" "擖" "擛" "擨" "擪" "擫" "暍" "曄" "曅" "曗" "曵" "枼" "枽" "楪" "業" "殗" "殜" "漜" "澲" "煠" "燁" "爗" "爺" "瑘" "皣" "瞱" "瞸" "聶" "葉" "蠮" "謁" "譺" "鄴" "釾" "鋣" "鍱" "鎁" "鎑" "鐷" "閼" "靨" "頁" "餘" "餣" "饁" "馌" "驜" "鵺" "鸈"))
  ((("y" "i")) ("一" "以" "义" "已" "意" "衣" "艺" "议" "易" "医" "依" "益" "移" "亿" "疑" "异" "役" "仪" "忆" "椅" "遗" "译" "宜" "姨" "抑" "乙" "咦" "蚁" "亦" "倚" "谊" "毅" "翼" "屹" "伊" "疫" "艾" "蛾" "疙" "汉" "隶" "汽" "蛇" "射" "施" "食" "释" "台" "尾" "熙" "羡" "泄" "焉" "掖" "曳" "腋" "液" "壹" "揖" "铱" "颐" "夷" "胰" "沂" "彝" "矣" "邑" "臆" "逸" "肄" "裔" "溢" "诣" "翌" "绎" "泽" "治" "刈" "劓" "仡" "佚" "佗" "佾" "诒" "阝" "圯" "埸" "懿" "芸" "苡" "荑" "薏" "弈" "奕" "挹" "弋" "呓" "咿" "嗌" "噫" "峄" "嶷" "猗" "饴" "怿" "怡" "悒" "洫" "渫" "漪" "迤" "驿" "绁" "缢" "殪" "轶" "昱" "贻" "犄" "欹" "旖" "焱" "熠" "硪" "眙" "钇" "镒" "镱" "雉" "痍" "瘗" "癔" "翊" "袂" "蜴" "舣" "羿" "翳" "酏" "黝" "黟" "㐌" "㐹" "㑊" "㑜" "㑥" "㓷" "㔎" "㔕" "㔭" "㔴" "㕈" "㕥" "㖂" "㘁" "㘈" "㘊" "㙠" "㙪" "㙯" "㚤" "㚦" "㛕" "㛳" "㜋" "㜒" "㝖" "㝣" "㞔" "㞾" "㠖" "㠯" "㡫" "㡼" "㢞" "㣂" "㣇" "㣻" "㥴" "㥷" "㦉" "㦤" "㦾" "㩘" "㫊" "㰘" "㰝" "㰻" "㱅" "㱯" "㱲" "㲲" "㲼" "㳑" "㴁" "㴒" "㴔" "㵝" "㵩" "㵫" "㶠" "㸣" "㹑" "㹓" "㹫" "㹭" "㺿" "㼢" "㽈" "㾨" "䁆" "䂽" "䃞" "䄁" "䄩" "䄬" "䄿" "䆿" "䇣" "䇩" "䇵" "䇼" "䉨" "䋚" "䋵" "䌻" "䎈" "䏌" "䐅" "䐖" "䐙" "䑄" "䑛" "䓃" "䓈" "䓹" "䔇" "䔟" "䔬" "䕍" "䕥" "䖁" "䖊" "䖌" "䗑" "䗟" "䗷" "䘝" "䘸" "䚷" "䛖" "䝘" "䝝" "䝯" "䞅" "䢃" "䣡" "䣧" "䣱" "䤭" "䦴" "䧅" "䧇" "䧝" "䧧" "䩟" "䬁" "䬥" "䬮" "䭂" "䭇" "䭞" "䭲" "䭿" "䮊" "䯆" "䰙" "䰯" "䱈" "䱌" "䱒" "䲑" "䳬" "䴊" "䴬" "䵝" "乁" "乂" "亄" "伇" "伿" "佁" "侇" "俋" "偯" "儀" "億" "兿" "冝" "凒" "劮" "勚" "勩" "匜" "吚" "呭" "呹" "唈" "囈" "圛" "垼" "埶" "墿" "壱" "夁" "嫕" "嫛" "嬑" "嬟" "宐" "宧" "寱" "寲" "峓" "崺" "嶧" "嶬" "巸" "帟" "帠" "幆" "庡" "廙" "弌" "弬" "彛" "彜" "彞" "忔" "怈" "恞" "悘" "悥" "憶" "懌" "扅" "扆" "扡" "抴" "拸" "捙" "掜" "撎" "攲" "攺" "敡" "斁" "旑" "昳" "晲" "晹" "暆" "曀" "曎" "杙" "杝" "枍" "枱" "枻" "柂" "栘" "栧" "桋" "棭" "椸" "榏" "槷" "檍" "檥" "檹" "欭" "歋" "歝" "殔" "殹" "毉" "沶" "泆" "洂" "洟" "洢" "浂" "浥" "浳" "湙" "溰" "潩" "澤" "澺" "瀷" "炈" "焈" "焲" "熤" "熪" "熼" "燚" "燡" "燱" "狋" "獈" "玴" "珆" "瑿" "瓵" "異" "痬" "瘞" "瘱" "眤" "眱" "睪" "瞖" "礒" "祎" "禕" "秇" "稦" "穓" "竩" "笖" "簃" "紲" "絏" "維" "綺" "緆" "縊" "繄" "繶" "繹" "羛" "羠" "羨" "義" "肊" "肔" "胣" "膉" "臺" "艗" "艤" "芅" "苅" "苐" "苢" "萓" "蓺" "藙" "藝" "蘙" "虉" "虒" "虵" "蛜" "蛡" "蛦" "螔" "螘" "螠" "蟻" "衪" "袘" "袣" "袲" "裛" "褹" "襼" "觺" "訑" "訲" "訳" "詍" "詒" "詣" "誃" "誒" "誼" "謚" "謻" "譩" "譯" "議" "讉" "讛" "豙" "豛" "豷" "貤" "貽" "跇" "跠" "踦" "軼" "輢" "轙" "迆" "迻" "逘" "遺" "郼" "醫" "醳" "醷" "釋" "釔" "釴" "鈠" "鈶" "鉇" "鉈" "鉯" "銕" "銥" "錡" "鎰" "鏔" "鐿" "锜" "阣" "阤" "陁" "陭" "隿" "霬" "靾" "鞥" "頉" "頤" "顊" "顗" "顡" "飴" "餏" "饐" "饻" "駅" "驛" "骮" "鮧" "鮨" "鯣" "鳦" "鴺" "鶂" "鶃" "鷁" "鷊" "鷖" "鷧" "鷾" "鸃" "鹝" "鹢" "鹥" "黓" "黳" "齮" "齸" "益" "逸" "𣘦" "𥜥" "𩸨"))
  ((("y" "i" "n")) ("因" "音" "引" "印" "银" "阴" "隐" "饮" "吟" "姻" "蚓" "狠" "潭" "听" "烟" "言" "沂" "茵" "荫" "殷" "淫" "寅" "尹" "胤" "鄞" "廴" "圻" "垠" "堙" "芩" "茚" "吲" "喑" "狺" "夤" "洇" "湮" "氤" "铟" "瘾" "窨" "霪" "龈" "鳏" "㐆" "㕂" "㖗" "㗃" "㙬" "㝖" "㝙" "㞤" "㡥" "㣧" "㥯" "㥲" "㥼" "㦩" "㧈" "㪦" "㱃" "㴈" "㴽" "㸒" "㸧" "㹜" "㹞" "㼉" "㾙" "䇙" "䌠" "䌥" "䒡" "䓄" "䕃" "䕾" "䖐" "䖜" "䗞" "䚿" "䜣" "䠴" "䡛" "䡨" "䤃" "䤺" "䨙" "䨸" "䪩" "䲟" "䴛" "䴦" "乚" "侌" "冘" "凐" "唫" "噖" "噾" "嚚" "囙" "圁" "垔" "垽" "堷" "夁" "婣" "婬" "峾" "崟" "崯" "嶾" "廕" "愔" "慇" "慭" "憖" "憗" "懚" "戭" "摿" "斦" "朄" "檃" "檭" "檼" "櫽" "欽" "歅" "殥" "泿" "洕" "淾" "湚" "溵" "滛" "潯" "濥" "濦" "烎" "犾" "狋" "猌" "璌" "瘖" "癊" "癮" "碒" "磤" "禋" "秵" "筃" "紖" "絪" "緸" "縯" "纼" "苂" "荶" "蒑" "蔩" "蔭" "蘟" "螾" "蟫" "裀" "訔" "訚" "訡" "訢" "誾" "諲" "讔" "趛" "酳" "釿" "鈏" "鈝" "銀" "銦" "闉" "阥" "陰" "陻" "隂" "隠" "隱" "霒" "霠" "靷" "鞇" "韽" "韾" "飮" "飲" "馻" "駰" "骃" "鮣" "鰥" "鷣" "黫" "齗" "齦" "龂"))
  ((("y" "i" "n" "g")) ("应" "影" "营" "映" "英" "硬" "迎" "蝇" "婴" "鹰" "萤" "莹" "颖" "逞" "甸" "景" "绳" "樱" "缨" "荧" "赢" "盈" "嬴" "郢" "茔" "荥" "莺" "萦" "蓥" "撄" "嘤" "膺" "滢" "潆" "瀛" "瑛" "璎" "楹" "媵" "鹦" "瘿" "颍" "罂" "㑞" "㕲" "㚞" "㜲" "㢍" "㦹" "㨕" "㬐" "㯋" "㲟" "㴄" "㵬" "㶈" "㹙" "㹚" "㿘" "䀰" "䀴" "䁐" "䁝" "䃷" "䋼" "䑉" "䑍" "䒢" "䔔" "䕦" "䙬" "䚆" "䤝" "䤰" "䨍" "䪯" "䭊" "䭗" "䭘" "䵥" "偀" "僌" "営" "噟" "嚶" "塋" "媖" "嫈" "嬰" "孆" "孾" "巆" "巊" "廮" "応" "應" "摬" "攍" "攖" "暎" "朠" "桜" "梬" "楧" "櫻" "櫿" "浧" "渶" "溁" "滎" "潁" "濙" "濚" "濴" "瀅" "瀠" "瀯" "瀴" "煐" "熒" "營" "瑩" "璄" "瓔" "甇" "甖" "癭" "盁" "矨" "碤" "礯" "禜" "穎" "籝" "籯" "緓" "縈" "繩" "纓" "绬" "罃" "罌" "膡" "莖" "萾" "藀" "蘡" "蛍" "蝧" "蝿" "螢" "蠅" "蠳" "褮" "覮" "謍" "譍" "譻" "賏" "贏" "鍈" "鎣" "鐛" "鑍" "锳" "霙" "鞕" "韺" "頴" "颕" "鴬" "鶧" "鶯" "鷪" "鷹" "鸎" "鸚" "𤇾"))
  ((("y" "o")) ("哟" "育" "唷" "唹" "喲"))
  ((("y" "o" "n" "g")) ("用" "永" "勇" "涌" "拥" "泳" "庸" "佣" "臃" "痈" "雍" "踊" "蛹" "咏" "恿" "俑" "壅" "墉" "蕹" "喁" "慵" "邕" "镛" "甬" "臾" "鳙" "饔" "㐯" "㑙" "㙲" "㝘" "㞲" "㣧" "㦷" "㶲" "㷏" "㽫" "䗤" "䞻" "䮵" "傛" "傭" "勈" "嗈" "噰" "埇" "塎" "嫆" "嫞" "嵱" "廱" "彮" "悀" "惥" "愑" "愹" "慂" "搈" "擁" "柡" "栐" "槦" "湧" "滽" "澭" "瀜" "灉" "牅" "癕" "癰" "硧" "禜" "筩" "苚" "詠" "踴" "郺" "鄘" "醟" "銿" "鏞" "雝" "顒" "颙" "鯒" "鰫" "鱅" "鲬" "鷛" "𠆌"))
  ((("y" "o" "u")) ("有" "又" "由" "油" "右" "友" "游" "优" "尤" "幼" "犹" "邮" "忧" "铀" "悠" "诱" "佑" "泅" "幽" "酉" "釉" "卣" "攸" "侑" "莠" "莜" "莸" "尢" "揄" "呦" "囿" "宥" "柚" "猷" "牖" "铕" "疣" "聱" "蚰" "蚴" "蝣" "蝤" "繇" "鱿" "黝" "鼬" "㑸" "㒡" "㓜" "㔽" "㕗" "㕛" "㕱" "㘥" "㚭" "㛜" "㤑" "㫍" "㮋" "㰶" "㳺" "㶭" "㹨" "㺠" "㻀" "㽕" "㾞" "䀁" "䂚" "䅎" "䆜" "䌊" "䍃" "䑻" "䒒" "䒴" "䖻" "䚃" "䛻" "䞥" "䢊" "䢟" "䬀" "䱂" "䳑" "丣" "亴" "偤" "優" "冘" "唀" "嚘" "囮" "姷" "岰" "峟" "峳" "庮" "怞" "怣" "怮" "憂" "懮" "抭" "斿" "栯" "梄" "梎" "楢" "槱" "櫌" "櫾" "沋" "泑" "浟" "湵" "滺" "瀀" "牰" "狖" "猶" "祐" "禉" "秞" "糿" "纋" "羐" "羑" "耰" "聈" "肬" "苃" "莤" "蕕" "蜏" "褎" "褏" "訧" "誘" "貁" "輏" "輶" "迶" "逌" "逰" "遊" "郵" "鄾" "酭" "鈾" "銪" "駀" "魷" "鮋" "鯈" "鲉" "鴢" "麀" "𡈙" "𩼈"))
  ((("y" "u")) ("于" "与" "育" "雨" "鱼" "余" "语" "遇" "预" "宇" "愈" "域" "玉" "狱" "愉" "欲" "御" "渔" "予" "豫" "誉" "屿" "裕" "羽" "娱" "竽" "郁" "吁" "寓" "舆" "愚" "澳" "谷" "或" "亏" "舒" "王" "蔚" "尉" "污" "梧" "邪" "衙" "迂" "淤" "盂" "榆" "虞" "俞" "逾" "渝" "隅" "禹" "芋" "喻" "峪" "浴" "驭" "苑" "粥" "禺" "毓" "伛" "俣" "谀" "谕" "圩" "萸" "菸" "菀" "蓣" "揄" "喁" "噢" "圄" "圉" "嵛" "狳" "饫" "馀" "庾" "阈" "阏" "汩" "鬻" "妪" "妤" "纡" "瑜" "昱" "觎" "毹" "腴" "腧" "欤" "於" "煜" "煨" "熨" "燠" "肀" "聿" "畲" "钰" "鹆" "鹬" "瘐" "瘀" "窬" "窳" "蜍" "蜮" "蝓" "臾" "舁" "雩" "龉" "㑨" "㒁" "㒜" "㔱" "㙑" "㚜" "㚥" "㝢" "㠘" "㠨" "㡰" "㣃" "㤜" "㤢" "㤤" "㥔" "㥚" "㥥" "㦛" "㦽" "㧒" "㧕" "㪀" "㪌" "㫹" "㬂" "㬰" "㭌" "㮋" "㰲" "㲾" "㳚" "㳛" "㵄" "㶛" "㷉" "㷒" "㹼" "㺄" "㺞" "㺠" "㺮" "㻀" "㻰" "㼌" "㼶" "㽣" "㽳" "䁌" "䁩" "䂊" "䂛" "䃋" "䄏" "䄨" "䆷" "䈅" "䉛" "䋖" "䋭" "䍂" "䍞" "䎉" "䏸" "䐳" "䓊" "䔡" "䖇" "䗨" "䘘" "䘱" "䘻" "䛎" "䛕" "䜡" "䜽" "䞕" "䞝" "䢓" "䢖" "䢩" "䣁" "䤋" "䥏" "䧕" "䨁" "䨒" "䨞" "䩒" "䫻" "䬄" "䬔" "䬛" "䮇" "䮙" "䰥" "䰻" "䱷" "䱾" "䲣" "䳑" "䴁" "䵥" "䵫" "丂" "亐" "伃" "俁" "俼" "偊" "傴" "兪" "哊" "唹" "喅" "喐" "喩" "噊" "噳" "圫" "堉" "堣" "堬" "墺" "奧" "娛" "娯" "婾" "媀" "媮" "嫗" "嬩" "寙" "峿" "崳" "嵎" "嶎" "嶼" "庽" "彧" "忬" "悆" "悇" "惌" "惐" "慾" "懙" "戫" "扜" "扵" "敔" "斔" "斞" "旟" "杅" "栯" "桙" "棛" "棜" "棫" "楀" "楡" "楰" "櫲" "欎" "欝" "欥" "歈" "歟" "歶" "毺" "汙" "汚" "淢" "淯" "湡" "滪" "漁" "潏" "澞" "澦" "灪" "焴" "燏" "爩" "牏" "獄" "獝" "玗" "玙" "琙" "瑀" "璵" "畬" "畭" "痀" "瘉" "癒" "盓" "睮" "矞" "砡" "硢" "硲" "礇" "礖" "礜" "祤" "禦" "秗" "稢" "稶" "穥" "穻" "箊" "篽" "籅" "籞" "籲" "紆" "緎" "緰" "繘" "罭" "罻" "羭" "聥" "與" "艅" "芌" "茟" "茰" "萭" "萮" "蒮" "蓹" "蕍" "蕷" "薁" "藇" "蘌" "蘛" "虶" "蜟" "螤" "螸" "蟈" "衘" "衧" "褕" "覦" "語" "諛" "諭" "謣" "譽" "貐" "踰" "軉" "輍" "輿" "轝" "迃" "逳" "遹" "邘" "鄃" "鄅" "酑" "醧" "釪" "鈺" "銉" "鋊" "鋙" "錥" "鍝" "鐭" "铻" "閼" "閾" "陓" "隃" "隩" "雓" "霱" "預" "飫" "餘" "饇" "馭" "騟" "驈" "骬" "髃" "鬰" "鬱" "魊" "魚" "魣" "鮽" "鰅" "鱊" "鳿" "鴥" "鴪" "鵌" "鵒" "鷠" "鷸" "鸆" "鸒" "麌" "黦" "齬" "齵" "龥" "羽"))
  ((("y" "u" "a" "n")) ("员" "原" "远" "院" "愿" "源" "元" "园" "圆" "援" "猿" "缘" "冤" "怨" "捐" "阮" "身" "宛" "鸳" "渊" "垣" "袁" "辕" "苑" "陨" "垸" "塬" "芫" "菀" "掾" "圜" "沅" "涓" "媛" "瑗" "橼" "爰" "眢" "畹" "鸢" "螈" "箢" "鼋" "㘣" "㛪" "㟲" "㟶" "㤪" "㥐" "㥳" "㭇" "㹉" "㼂" "䅈" "䏍" "䖠" "䖤" "䛄" "䛇" "䝠" "䝹" "䟦" "䣰" "䩩" "䬇" "䬧" "䬼" "䭴" "䲮" "䲻" "䳁" "䳒" "䳣" "傆" "剈" "厡" "厵" "員" "喛" "噮" "囦" "圎" "園" "圓" "夗" "妧" "妴" "媴" "嫄" "嬛" "嬽" "寃" "岏" "悁" "惌" "杬" "棩" "楥" "榞" "榬" "櫞" "淵" "渁" "渆" "渕" "湲" "溒" "灁" "猨" "猭" "獂" "禐" "笎" "緣" "縁" "羱" "肙" "萲" "葾" "蒝" "蒬" "薗" "蚖" "蜎" "蜵" "蝝" "蝯" "衏" "裫" "裷" "褑" "褤" "謜" "豲" "貟" "贠" "轅" "逺" "遠" "邍" "邧" "鋺" "鎱" "隕" "願" "駌" "騵" "魭" "鳶" "鴛" "鵷" "鶢" "鶰" "鹓" "黿" "鼘" "鼝"))
  ((("y" "u" "e")) ("月" "越" "约" "跃" "乐" "悦" "阅" "曰" "兑" "锐" "说" "药" "钥" "岳" "粤" "龠" "哕" "瀹" "栎" "樾" "刖" "钺" "蠖" "㜧" "㜰" "㧒" "㬦" "㭾" "㯞" "㰛" "㵸" "㹊" "䋐" "䋤" "䎀" "䎳" "䒸" "䖃" "䟑" "䟠" "䠯" "䡇" "䢁" "䢲" "䤦" "䥃" "䬂" "䶳" "噦" "妜" "岄" "嶽" "恱" "悅" "戉" "抈" "捳" "曱" "枂" "樂" "櫟" "汋" "泧" "爍" "爚" "狘" "玥" "矱" "礿" "禴" "箹" "篗" "籆" "籥" "籰" "粵" "約" "葯" "蒦" "藥" "蘥" "蚎" "蚏" "蛻" "說" "説" "趯" "跀" "躍" "躒" "軏" "鈅" "鉞" "銳" "鑠" "鑰" "閱" "閲" "鸑" "鸙" "黦"))
  ((("y" "u" "n")) ("运" "云" "允" "匀" "晕" "蕴" "盾" "均" "瘟" "温" "员" "苑" "耘" "郧" "陨" "酝" "韵" "孕" "郓" "芸" "菀" "狁" "恽" "愠" "纭" "韫" "殒" "昀" "氲" "熨" "筠" "㒁" "㚃" "㚞" "㚺" "㜏" "㞌" "㟦" "㩈" "㷉" "䆬" "䇖" "䉙" "䚋" "䞫" "䡝" "䢵" "䤞" "䦾" "䨶" "䩵" "䪳" "䲰" "䵴" "伝" "傊" "勻" "員" "喗" "囩" "夽" "奫" "妘" "惲" "愪" "慍" "抎" "昷" "暈" "枟" "榅" "榲" "橒" "殞" "氳" "沄" "涢" "溳" "澐" "煇" "煴" "煾" "熅" "熉" "玧" "畇" "眃" "磒" "秐" "筼" "篔" "紜" "緷" "緼" "縕" "縜" "缊" "耺" "腪" "荺" "蒀" "蒕" "蒷" "蕓" "蕰" "薀" "藴" "蘊" "蝹" "褞" "貟" "賱" "贇" "贠" "赟" "輑" "運" "鄆" "鄖" "醖" "醞" "鈗" "鋆" "阭" "隕" "雲" "霣" "韗" "韞" "韻" "頵" "餫" "饂" "鶤" "齳"))
  ((("z" "a")) ("杂" "砸" "咂" "咋" "匝" "咱" "扎" "籴" "拶" "唼" "㳨" "䕹" "䞙" "䦈" "䨿" "䪞" "倃" "偺" "囐" "嶻" "帀" "抸" "摣" "沞" "濽" "磼" "紥" "紮" "臜" "臢" "襍" "迊" "鉔" "雑" "雜" "雥" "韴" "魳" "鮺" "鲝"))
  ((("z" "a" "i")) ("在" "再" "灾" "载" "栽" "宰" "崽" "哉" "仔" "甾" "㞨" "㱰" "㴓" "䏁" "䣬" "䮨" "䵧" "侢" "傤" "儎" "扗" "渽" "災" "烖" "縡" "菑" "賳" "載" "酨" "𢦏"))
  ((("z" "a" "n")) ("咱" "赞" "暂" "攒" "拶" "涔" "湔" "瓒" "昝" "簪" "糌" "趱" "錾" "㙻" "㜺" "㟛" "㣅" "㤰" "㳨" "䍝" "䗞" "䙉" "䟃" "䟅" "䥄" "䬤" "䭕" "倃" "偺" "儧" "儹" "兂" "喒" "噆" "囋" "囐" "寁" "撍" "攅" "攢" "暫" "桚" "欑" "沯" "淺" "濺" "濽" "灒" "瓉" "瓚" "礸" "禶" "穳" "篸" "簮" "臜" "臢" "襸" "讃" "讚" "賛" "贊" "趲" "蹔" "鄼" "酂" "酇" "鏨" "鐕" "饡"))
  ((("z" "a" "n" "g")) ("脏" "葬" "藏" "赃" "奘" "驵" "臧" "㘸" "匨" "塟" "弉" "牂" "羘" "臓" "臜" "臟" "臢" "蔵" "賍" "賘" "贓" "贜" "銺" "駔" "髒"))
  ((("z" "a" "o")) ("造" "早" "遭" "糟" "皂" "凿" "躁" "燥" "灶" "澡" "枣" "噪" "槽" "草" "窖" "藻" "蚤" "唣" "缫" "缲" "㲧" "㿷" "䒃" "䖣" "䗢" "䜊" "䥣" "䲃" "傮" "唕" "慥" "梍" "棗" "璪" "皁" "竃" "竈" "簉" "繅" "繰" "艁" "艸" "薻" "譟" "趮" "蹧" "醩" "鑿" "髞" "𡮦"))
  ((("z" "e")) ("则" "责" "择" "侧" "措" "泽" "贼" "咋" "窄" "柞" "仄" "赜" "啧" "帻" "迮" "昃" "稷" "笮" "箦" "舴" "㖽" "㟙" "㢎" "㣱" "㥽" "㮣" "㳁" "㳻" "㻭" "䂝" "䃎" "䅚" "䇥" "䔾" "䕉" "䕪" "䯔" "䰹" "䶡" "䶦" "側" "則" "唶" "嘖" "夨" "崱" "幘" "庂" "戝" "択" "捑" "擇" "昗" "汄" "沢" "溭" "滜" "澤" "皟" "睪" "瞔" "礋" "稄" "簀" "耫" "荝" "萴" "蠈" "蠌" "襗" "諎" "謫" "謮" "責" "賊" "賾" "鰂" "鲗" "齚" "齰"))
  ((("z" "e" "i")) ("贼" "㖽" "戝" "賊" "鯽" "鱡"))
  ((("z" "e" "n")) ("怎" "谮" "䫈" "譖" "譛"))
  ((("z" "e" "n" "g")) ("增" "憎" "曾" "赠" "综" "缯" "甑" "罾" "锃" "㽪" "䇸" "䙢" "䰝" "䵴" "増" "橧" "熷" "璔" "矰" "磳" "綜" "繒" "譄" "贈" "鄫" "鋥" "驓"))
  ((("z" "h" "a")) ("炸" "扎" "眨" "渣" "闸" "查" "碴" "蜡" "喳" "札" "轧" "铡" "栅" "榨" "咋" "乍" "诈" "柞" "苴" "揸" "吒" "咤" "哳" "喋" "猹" "渫" "楂" "槎" "膪" "砟" "痄" "蚱" "笮" "齄" "㑵" "㒀" "㓃" "㔍" "㚫" "㞚" "㡸" "㩹" "㯥" "㱜" "㳐" "㴙" "㷢" "㽪" "䃎" "䄍" "䄰" "䆛" "䋾" "䕢" "䖳" "䙄" "䛽" "䞢" "䢱" "䥷" "䮜" "䱹" "䵙" "䵵" "偧" "剳" "劄" "厏" "奒" "奓" "宱" "扠" "抯" "拃" "挓" "挿" "搾" "摣" "柤" "柵" "査" "樝" "溠" "灹" "煠" "牐" "甴" "皶" "皻" "箚" "簎" "紥" "紮" "苲" "蕏" "虴" "蚻" "蠿" "觰" "詐" "謯" "譗" "軋" "醡" "鍘" "閘" "霅" "鮓" "鰈" "鲊" "齇" "齟"))
  ((("z" "h" "a" "i")) ("摘" "宅" "窄" "债" "柴" "疵" "翟" "祭" "齐" "责" "择" "斋" "寨" "膪" "砦" "瘵" "㟙" "㡯" "㢎" "㩟" "䍉" "䑲" "䓱" "亝" "債" "捚" "擇" "斎" "榸" "礋" "簀" "虒" "責" "鉙" "飵" "駘" "齊" "齋"))
  ((("z" "h" "a" "n")) ("战" "展" "站" "占" "盏" "沾" "崭" "粘" "毡" "瞻" "蘸" "颤" "袒" "詹" "斩" "辗" "栈" "湛" "绽" "谵" "搌" "湔" "澶" "骣" "觇" "旃" "黏" "醮" "躔" "㙴" "㜊" "㞡" "㟞" "㠭" "㣶" "㺘" "㻵" "䁪" "䁴" "䈴" "䋎" "䎒" "䐤" "䗃" "䗞" "䘺" "䟋" "䡀" "䦅" "䧯" "䩅" "䩆" "䪌" "䱠" "䱼" "䳻" "䵣" "佔" "偡" "厃" "噡" "嫸" "嶃" "嶄" "嶘" "嶦" "惉" "戦" "戰" "拃" "摲" "斬" "旜" "栴" "桟" "棧" "椫" "椾" "榐" "樿" "橏" "氈" "氊" "琖" "皽" "盞" "綻" "菚" "薝" "虥" "虦" "蛅" "襢" "覘" "覱" "詀" "謙" "譫" "讝" "趈" "蹍" "蹔" "輚" "輾" "轏" "邅" "醆" "鉆" "霑" "顫" "颭" "飐" "飦" "餰" "饘" "驏" "驙" "魙" "鱣" "鳣" "鸇" "鹯" "點"))
  ((("z" "h" "a" "n" "g")) ("长" "张" "章" "掌" "帐" "仗" "丈" "障" "涨" "胀" "樟" "彰" "漳" "杖" "账" "瘴" "仉" "鄣" "幛" "嶂" "獐" "嫜" "绱" "璋" "蟑" "㕩" "㙊" "㙣" "㢓" "㽴" "仧" "傽" "墇" "帳" "張" "慞" "扙" "暲" "涱" "漲" "痮" "瘬" "瞕" "礃" "粻" "緔" "脹" "蔁" "賬" "遧" "長" "鞝" "餦" "騿" "鱆" "麞" "黨" "𤍤"))
  ((("z" "h" "a" "o")) ("找" "照" "著" "着" "召" "招" "罩" "爪" "朝" "嘲" "淖" "搔" "蚤" "昭" "沼" "赵" "兆" "肇" "抓" "诏" "啁" "濯" "棹" "钊" "笊" "㑿" "㕚" "㡽" "㨄" "㫤" "㷖" "㹿" "㺐" "䃍" "䄻" "䈃" "䈇" "䍜" "䍮" "䑲" "䖺" "䝖" "䧂" "䮓" "垗" "妱" "巶" "旐" "曌" "枛" "柖" "櫂" "炤" "燳" "狣" "瑵" "盄" "瞾" "窼" "箌" "羄" "肁" "肈" "菬" "詔" "謿" "趙" "釗" "鉊" "鍣" "雿" "駋" "鮡" "鳭" "鵃" "鵫" "鸼" "鼂" "鼌"))
  ((("z" "h" "e")) ("这" "著" "着" "者" "哲" "折" "遮" "蔗" "聂" "慑" "摘" "蛰" "辙" "锗" "浙" "乇" "谪" "陬" "耷" "摺" "柘" "辄" "磔" "鹧" "褚" "褶" "蜇" "螫" "赭" "㞏" "㞼" "㡇" "㡳" "㢎" "㦻" "㪿" "㫼" "㭙" "㭯" "㯰" "㵊" "䀅" "䂝" "䂞" "䆛" "䊞" "䊮" "䋲" "䎲" "䏳" "䐑" "䐲" "䓆" "䗖" "䗪" "䙷" "䜆" "䝃" "䝕" "䠦" "䧪" "䩾" "䮰" "䵭" "厇" "啠" "啫" "喆" "嗻" "嚞" "埑" "嫬" "庻" "悊" "慴" "慹" "懾" "晢" "晣" "檡" "歽" "淛" "烢" "瓋" "砓" "禇" "籷" "耴" "聶" "虴" "蟄" "蟅" "襵" "詟" "謫" "謺" "讁" "讋" "讘" "踷" "軼" "輒" "輙" "轍" "這" "適" "銸" "鍺" "鮿" "鷓" "鷙" "鸅" "𧋍"))
  ((("z" "h" "e" "i")) ("这" "這"))
  ((("z" "h" "e" "n")) ("真" "阵" "针" "震" "镇" "珍" "振" "侦" "枕" "诊" "陈" "趁" "滇" "鼎" "斟" "甄" "砧" "臻" "贞" "疹" "圳" "蓁" "浈" "溱" "缜" "桢" "椹" "榛" "轸" "赈" "胗" "朕" "祯" "畛" "稹" "鸩" "箴" "㐱" "㓄" "㛛" "㣀" "㨋" "㪛" "㭫" "㮳" "㯢" "㴨" "㼉" "䀕" "䀼" "䂦" "䂧" "䊶" "䏖" "䑐" "䚯" "䝩" "䟴" "䠴" "䡅" "䡩" "䧵" "䨯" "䪴" "䪾" "䫬" "䲴" "䳲" "䴾" "侲" "偵" "堻" "塦" "媜" "嫃" "寊" "帪" "弫" "抌" "抮" "挋" "揁" "揕" "搸" "敒" "敶" "昣" "晸" "栕" "栚" "桭" "楨" "樼" "湞" "潧" "澵" "獉" "珎" "瑊" "瑱" "甽" "眕" "眞" "眹" "碪" "磌" "禎" "禛" "笉" "籈" "紖" "紾" "絼" "縝" "縥" "纼" "聄" "葴" "蒖" "蒧" "薽" "蜄" "袗" "裖" "診" "誫" "貞" "賑" "軫" "轃" "辴" "迧" "遉" "酖" "酙" "針" "鉁" "錱" "鍖" "鍼" "鎭" "鎮" "鐤" "陣" "陳" "靕" "駗" "鬒" "鮝" "鱵" "鴆" "鷆" "鷏" "黰" "鼑" "𨸬"))
  ((("z" "h" "e" "n" "g")) ("正" "政" "争" "整" "证" "征" "睁" "蒸" "挣" "症" "郑" "怔" "承" "丁" "趟" "侦" "狰" "拯" "帧" "诤" "峥" "徵" "桢" "祯" "瞠" "町" "钲" "铮" "锃" "筝" "鲭" "㐼" "㡠" "㡧" "㱏" "㽀" "䂻" "䈣" "䛫" "䡕" "䥌" "䥭" "䦛" "䦶" "䫆" "佂" "偵" "埩" "姃" "崝" "崢" "幀" "徰" "徴" "愸" "憆" "抍" "掙" "掟" "撜" "晸" "楨" "氶" "炡" "烝" "爭" "猙" "癥" "眐" "睜" "禎" "箏" "篜" "糽" "綪" "聇" "脀" "証" "諍" "證" "踭" "遉" "鄭" "鉦" "鋥" "錚" "鏳" "鬇" "鯖" "鯹" "鴊" "𠔻"))
  ((("z" "h" "i")) ("只" "知" "之" "志" "制" "直" "指" "治" "质" "至" "织" "支" "纸" "止" "值" "致" "枝" "植" "执" "职" "置" "殖" "智" "帜" "脂" "秩" "肢" "蜘" "址" "稚" "掷" "芝" "汁" "迟" "祁" "识" "示" "氏" "拓" "蛰" "吱" "侄" "趾" "旨" "挚" "峙" "炙" "痔" "滞" "窒" "卮" "氐" "陟" "郅" "郦" "埴" "芷" "摭" "帙" "徵" "夂" "忮" "彘" "咫" "骘" "栉" "枳" "栀" "桎" "轵" "轾" "昵" "耆" "贽" "胝" "膣" "祉" "祗" "砥" "黹" "雉" "鸱" "鸷" "痣" "蛭" "絷" "酯" "趵" "跖" "踬" "踯" "豸" "觯" "㕄" "㗌" "㗧" "㘉" "㙷" "㛿" "㜱" "㜼" "㝂" "㡳" "㡶" "㣥" "㥁" "㧻" "㨁" "㨖" "㫑" "㫼" "㬪" "㮹" "㯰" "㲛" "㴛" "㾅" "㿃" "䀸" "䂡" "䄺" "䅩" "䆈" "䇛" "䇽" "䉅" "䉜" "䌤" "䎺" "䏄" "䏑" "䏯" "䐈" "䐭" "䑇" "䑭" "䓌" "䕌" "䘭" "䚇" "䚦" "䚳" "䛗" "䜠" "䝰" "䝷" "䞃" "䞇" "䟈" "䠦" "䡹" "䤠" "䥍" "䦛" "䦯" "䧝" "䩢" "䪒" "䫕" "䬹" "䭁" "䰴" "䱃" "䱥" "䱨" "䲀" "䳅" "䵂" "䶡" "値" "偫" "傂" "儨" "剬" "劕" "劧" "厎" "厔" "咥" "坁" "坧" "垁" "執" "墌" "妷" "姪" "娡" "嬂" "寘" "崻" "巵" "帋" "幟" "庢" "庤" "廌" "徏" "徝" "恉" "慹" "憄" "懥" "懫" "扺" "扻" "抧" "挃" "搘" "搱" "摯" "擲" "擿" "旘" "晊" "晢" "晣" "柣" "栺" "梔" "梽" "椥" "楖" "榰" "樴" "櫍" "櫛" "汥" "沚" "泜" "洔" "洷" "淛" "淽" "滍" "滯" "漐" "潌" "熫" "犆" "狾" "猘" "璏" "瓆" "瓡" "畤" "疐" "疧" "疻" "瘈" "砋" "礩" "祇" "祑" "祬" "禃" "禔" "秇" "秓" "秖" "秪" "秲" "秷" "稙" "稺" "穉" "筫" "紙" "紩" "絼" "綕" "緻" "縶" "織" "翐" "聀" "職" "胑" "胵" "腟" "膱" "臸" "芖" "茝" "藢" "蘵" "螲" "蟄" "蟙" "衹" "衼" "袟" "袠" "製" "褁" "襧" "覟" "觗" "觶" "訨" "誌" "識" "豑" "豒" "貭" "質" "贄" "跱" "踶" "蹛" "蹠" "蹢" "躑" "躓" "軄" "軹" "輊" "迣" "遟" "遲" "酈" "釞" "銍" "鋕" "鑕" "铚" "锧" "阤" "阯" "隻" "馶" "馽" "駤" "騭" "騺" "驇" "鮨" "鯯" "鳩" "鳷" "鴙" "鴟" "鴲" "鵄" "鷙" "鼅"))
  ((("z" "h" "o" "n" "g")) ("中" "种" "重" "众" "钟" "终" "忠" "肿" "董" "童" "盅" "衷" "仲" "冢" "忪" "潼" "锺" "蚣" "螽" "舂" "舯" "踵" "㐺" "㣫" "㲴" "䱰" "䳋" "乑" "伀" "偅" "刣" "喠" "堹" "塚" "妐" "妕" "媑" "尰" "幒" "彸" "柊" "歱" "汷" "泈" "湩" "潨" "炂" "煄" "狆" "瘇" "眾" "祌" "種" "穜" "筗" "籦" "終" "緟" "腫" "茽" "蔠" "蚛" "衆" "衳" "衶" "褈" "諥" "蹱" "鈡" "銿" "鍾" "鐘" "鴤" "鼨" "塚"))
  ((("z" "h" "o" "u")) ("周" "洲" "宙" "皱" "粥" "轴" "州" "昼" "骤" "舟" "帚" "咒" "调" "诌" "肘" "逐" "注" "祝" "啄" "荮" "啁" "鬻" "妯" "驺" "纣" "绉" "胄" "碡" "籀" "舳" "繇" "酎" "㑇" "㑳" "㔌" "㛩" "㝌" "㤘" "㥁" "㥮" "㨶" "㫶" "㲴" "㹐" "㼙" "㾭" "䇠" "䈙" "䋓" "䎻" "䐌" "䐍" "䔭" "䖞" "䛆" "䩜" "䭥" "䶇" "伷" "侜" "僽" "冑" "呪" "咮" "喌" "噣" "婤" "徟" "晝" "晭" "洀" "淍" "烐" "珘" "甃" "疛" "皺" "盩" "睭" "矪" "箒" "籒" "籕" "粙" "紂" "縐" "脽" "菷" "葤" "薵" "詋" "詶" "調" "諏" "謅" "譸" "诪" "賙" "赒" "軸" "輈" "輖" "辀" "週" "鈾" "銂" "駎" "騆" "騶" "驟" "鮦" "鯞" "鲖" "鵃" "鸼" "𤏲"))
  ((("z" "h" "u")) ("主" "住" "助" "注" "逐" "著" "筑" "珠" "竹" "祝" "猪" "株" "柱" "烛" "煮" "铸" "嘱" "蛛" "驻" "诸" "拄" "蛀" "朝" "除" "逗" "宁" "泞" "属" "术" "者" "粥" "轴" "朱" "诛" "瞩" "贮" "茁" "阻" "丶" "伫" "侏" "邾" "苎" "茱" "洙" "渚" "潴" "澍" "鬻" "妯" "杼" "柚" "楮" "槠" "橥" "炷" "铢" "疰" "瘃" "褚" "蚰" "竺" "箸" "舳" "翥" "躅" "麈" "㑏" "㔉" "㝉" "㤖" "㧣" "㫂" "㵭" "㹥" "㺛" "㾻" "㿾" "䇠" "䇡" "䇧" "䌵" "䍆" "䎝" "䎷" "䐢" "䕽" "䘄" "䘚" "䘢" "䝒" "䝬" "䟉" "䠱" "䠼" "䥮" "䪒" "䫖" "䬡" "䭖" "䮱" "䰞" "䳠" "佇" "劚" "劯" "囑" "坾" "壴" "孎" "宔" "寧" "屬" "嵀" "庻" "敱" "斸" "朮" "枓" "柷" "樦" "櫡" "櫧" "櫫" "欘" "殶" "濐" "瀦" "灟" "炢" "煑" "燭" "爥" "牏" "眝" "矚" "砫" "硃" "祩" "禇" "秼" "窋" "竚" "笁" "笜" "筯" "築" "篫" "紵" "紸" "絑" "纻" "罜" "羜" "胑" "膱" "芧" "苧" "茿" "莇" "蓫" "蕏" "蝫" "蠋" "蠩" "蠾" "袾" "註" "詝" "誅" "諔" "諸" "豬" "貯" "趉" "跓" "跦" "軴" "軸" "鉒" "銖" "鋳" "鑄" "钃" "陼" "霔" "飳" "馵" "駐" "騶" "鮢" "鯺" "鱁" "鴸" "鸀" "麆" "鼄" "猪" "諸"))
  ((("z" "h" "u" "a")) ("抓" "爪" "挝" "撾" "檛" "簻" "膼" "髽" "鵽"))
  ((("z" "h" "u" "a" "i")) ("拽" "跩" "𨋯"))
  ((("z" "h" "u" "a" "n")) ("转" "专" "砖" "赚" "传" "湍" "撰" "篆" "抟" "啭" "馔" "沌" "颛" "㑷" "䉵" "䏝" "䚈" "䡱" "䤄" "䧘" "傳" "僎" "剸" "叀" "囀" "堟" "塼" "嫥" "孨" "専" "專" "摶" "灷" "瑑" "瑼" "甎" "磚" "竱" "篹" "篿" "籑" "縳" "耑" "腞" "膞" "蒃" "蟤" "襈" "譔" "賺" "贃" "跧" "転" "轉" "鄟" "顓" "饌" "鱄" "鷒" "𧸖"))
  ((("z" "h" "u" "a" "n" "g")) ("装" "庄" "状" "壮" "撞" "桩" "幢" "妆" "僮" "奘" "戆" "艟" "䚒" "壯" "壵" "妝" "娤" "弉" "戅" "戇" "梉" "樁" "焋" "狀" "粧" "糚" "荘" "莊" "裝" "贛"))
  ((("z" "h" "u" "i")) ("追" "缀" "坠" "揣" "队" "隧" "致" "椎" "锥" "赘" "萑" "惴" "骓" "缒" "槌" "隹" "㝽" "㾽" "㿢" "䃍" "䄌" "䋘" "䨺" "埀" "墜" "娺" "桘" "沝" "甀" "硾" "礈" "窡" "笍" "綴" "縋" "腏" "膇" "諈" "譵" "贅" "醊" "錐" "錣" "鑆" "隊" "餟" "騅" "魋" "鴭" "鵻" "鵽" "𡑞"))
  ((("z" "h" "u" "n")) ("准" "淳" "纯" "顿" "屯" "谆" "肫" "胗" "盹" "窀" "隼" "埻" "宒" "忳" "棆" "湻" "準" "稕" "純" "綧" "衠" "諄" "迍" "頓" "飩" "鶽"))
  ((("z" "h" "u" "o")) ("桌" "著" "着" "捉" "浊" "啄" "茁" "缴" "淖" "勺" "拙" "卓" "琢" "酌" "灼" "倬" "诼" "蕞" "擢" "浞" "涿" "濯" "绌" "棹" "肫" "焯" "禚" "斫" "镯" "箸" "趵" "踔" "躅" "㑁" "㒂" "㓸" "㠚" "㣿" "㧳" "㧻" "㪬" "㭬" "㲋" "㹿" "㺟" "䅵" "䏐" "䐁" "䔲" "䕴" "䙯" "䟾" "䴵" "䵵" "䶂" "丵" "剢" "劅" "叕" "啅" "噣" "圴" "妰" "彴" "撯" "擆" "斀" "斮" "斱" "斲" "斵" "晫" "梲" "棁" "棳" "椓" "槕" "櫂" "櫡" "汋" "泎" "濁" "灂" "炪" "烵" "琸" "畷" "硺" "穛" "穱" "篧" "籗" "籱" "絀" "繳" "罬" "蠗" "諑" "謶" "鋜" "錣" "鐯" "鐲" "鷟" "鸀" "𠭴"))
  ((("z" "i")) ("子" "自" "资" "字" "仔" "紫" "姿" "滋" "籽" "姊" "柴" "疵" "齐" "吱" "兹" "咨" "淄" "孜" "滓" "渍" "谘" "茈" "呲" "嵫" "孳" "缁" "甾" "梓" "辎" "赀" "恣" "眦" "锱" "秭" "鹚" "瘠" "耔" "笫" "粢" "糍" "趑" "觜" "訾" "龇" "鲻" "髭" "㑵" "㜽" "㞨" "㢀" "㧗" "㧘" "㰣" "㰷" "㱴" "㺭" "㾅" "䅆" "䐉" "䔂" "䘣" "䦻" "䴾" "亝" "倳" "剚" "吇" "呰" "啙" "嗞" "姉" "姕" "孖" "孶" "扻" "杍" "栥" "椔" "榟" "湽" "漬" "澬" "牸" "玆" "眥" "矷" "禌" "秄" "秶" "稵" "紎" "純" "緇" "胏" "胔" "胾" "芓" "茊" "茡" "茲" "菑" "葘" "虸" "訿" "諮" "貲" "資" "趦" "載" "輜" "輺" "鄑" "釨" "鈭" "鋅" "錙" "鍿" "鎡" "镃" "頾" "頿" "餈" "鯔" "鴜" "鶅" "鶿" "鷀" "鼒" "齊" "齍" "齜" "𠂔"))
  ((("z" "o" "n" "g")) ("总" "综" "宗" "纵" "踪" "从" "鬃" "棕" "偬" "枞" "腙" "粽" "㢔" "㯶" "㷓" "㹅" "䁓" "䍟" "䎫" "䙕" "䝋" "䡯" "䰌" "倊" "倧" "傯" "堫" "嵏" "嵕" "嵸" "從" "惣" "惾" "愡" "憁" "捴" "揔" "搃" "摠" "昮" "朡" "椶" "樅" "熜" "熧" "猔" "猣" "疭" "瘲" "碂" "磫" "稯" "糉" "糭" "綜" "緃" "総" "緫" "緵" "縂" "縦" "縱" "總" "翪" "艐" "葼" "蓗" "蝬" "豵" "踨" "蹤" "鑁" "騌" "騣" "骔" "鬉" "鬷" "鯮" "鯼"))
  ((("z" "o" "u")) ("走" "奏" "揍" "趣" "诌" "骤" "邹" "族" "诹" "陬" "鄹" "驺" "楱" "鲰" "㔿" "㞫" "㵵" "䠫" "䲀" "媰" "掫" "棷" "棸" "箃" "緅" "菆" "諏" "謅" "赱" "郰" "鄒" "騶" "驟" "鯫" "黀" "齱" "齺"))
  ((("z" "u")) ("组" "族" "祖" "足" "阻" "租" "淬" "咀" "沮" "卒" "诅" "俎" "苴" "菹" "驵" "镞" "蹴" "㞺" "㧻" "㰵" "㲋" "㲞" "㵀" "䅸" "䔃" "䖕" "䙘" "䚝" "䬨" "䯿" "䱣" "卆" "哫" "唨" "崒" "崪" "捽" "柤" "爼" "珇" "稡" "紣" "組" "葅" "蒩" "詛" "謯" "趲" "踤" "踿" "蹵" "鎐" "鏃" "鑿" "靻" "駔"))
  ((("z" "u" "a" "n")) ("钻" "攥" "赚" "纂" "缵" "躜" "㷪" "䂎" "䌣" "䡅" "䤸" "揝" "攢" "篹" "籫" "繤" "纉" "纘" "賺" "贃" "躦" "鑚" "鑽" "饡" "𤎱"))
  ((("z" "u" "i")) ("最" "嘴" "罪" "醉" "咀" "蕞" "羧" "觜" "㝡" "㠑" "㭰" "㰎" "㵃" "䘹" "䮔" "厜" "噿" "嶉" "嶊" "嶵" "晬" "栬" "槜" "樶" "檇" "檌" "洅" "濢" "璻" "祽" "絊" "纗" "脧" "蕝" "蟕" "襊" "辠" "酔" "酨" "酻" "鋷" "錊"))
  ((("z" "u" "n")) ("尊" "遵" "蹲" "撙" "樽" "鳟" "䔿" "僔" "噂" "墫" "壿" "嶟" "捘" "燇" "繜" "罇" "臶" "譐" "跧" "銌" "鐏" "鱒" "鷷"))
  ((("z" "u" "o")) ("作" "做" "坐" "左" "座" "昨" "琢" "撮" "凿" "乍" "佐" "柞" "阼" "唑" "嘬" "怍" "迮" "胙" "祚" "砟" "笮" "酢" "㑅" "㘀" "㘴" "㛗" "㝾" "㣱" "㤰" "㭮" "㶡" "㸲" "䇥" "䋏" "䎰" "䔘" "䜊" "䝫" "䞢" "䞰" "䟄" "䟶" "䦈" "䩦" "䬤" "䯿" "侳" "咗" "唨" "夎" "岝" "岞" "捽" "椊" "毑" "秨" "稓" "筰" "糳" "繓" "苲" "莋" "葃" "葄" "袏" "鈼" "鑿" "飵"))

  ((("1")) ("1"))
  ((("2")) ("2"))
  ((("3")) ("3"))
  ((("4")) ("4"))
  ((("5")) ("5"))
  ((("6")) ("6"))
  ((("7")) ("7"))
  ((("8")) ("8"))
  ((("9")) ("9"))
  ((("0")) ("0"))

  (((",")) ("，"))
  (((".")) ("。"))
  ((("?")) ("？"))
  ((("!")) ("！"))
  ((("\"")) ("”"))
  ((("#")) ("＃"))
  ((("$")) ("＄"))
  ((("%")) ("％"))
  ((("&")) ("＆"))
  ((("'")) ("’"))
  ((("(")) ("（"))
  (((")")) ("）"))
  ((("=")) ("＝"))
  ((("^")) ("＾"))
  ((("\\")) ("＼"))
  ((("|")) ("｜"))
  ((("`")) ("‘"))
  ((("@")) ("＠"))
  ((("+")) ("＋"))
  (((";")) ("；"))
  ((("*")) ("＊"))
  (((":")) ("："))
  ((("}")) ("｝"))
  ((("<")) ("＜"))
  (((">")) ("＞"))
  ((("/")) ("／"))
  ((("_")) ("＿"))
  ))
