from typing import Any

class ResourceAttributesMixin:
    def __getattr__(self, item): ...

class Resource(ResourceAttributesMixin):
    def __init__(self, *args, **kwargs) -> None: ...
    def __call__(self, id: Any | None = ..., format: Any | None = ..., url_override: Any | None = ...): ...
    def as_raw(self): ...
    def get(self, **kwargs): ...
    def options(self, **kwargs): ...
    def head(self, **kwargs): ...
    def post(self, data: Any | None = ..., files: Any | None = ..., **kwargs): ...
    def patch(self, data: Any | None = ..., files: Any | None = ..., **kwargs): ...
    def put(self, data: Any | None = ..., files: Any | None = ..., **kwargs): ...
    def delete(self, **kwargs): ...
    def url(self): ...

class API(ResourceAttributesMixin):
    resource_class: Any
    def __init__(
        self,
        base_url: Any | None = ...,
        auth: Any | None = ...,
        format: Any | None = ...,
        append_slash: bool = ...,
        session: Any | None = ...,
        serializer: Any | None = ...,
        raw: bool = ...,
    ) -> None: ...
