/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* 
 * setup_values.c - Sets up the default values for different parameters
 * of transmission lines
 * This function will undergo major changes in subsequent releases like 
 * allowing default values to be saved and loaded
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "transcalc.h"

void
setup_values (short ttype, trans_value *tvalue)
{

  switch (ttype) {
  case MICROSTRIP :
    /* substrate */
    tvalue->subparams_value[0] = 2.94;
    tvalue->subparams_value[1] = 1.0;
    tvalue->subparams_value[2] = 10.0;
    tvalue->subparams_value[3] = 1.e20;
    tvalue->subparams_value[4] = 0.1;
    tvalue->subparams_value[5] = 4.1e7;
    tvalue->subparams_value[6] = 0.0;
    tvalue->subparams_value[7] = 0.0;
    tvalue->subparams_value[8] = -1.0;   /* -1 implies no value and make widget insensitive*/
    /* component */
    tvalue->component_params_value[0] = 1.0;
    tvalue->component_params_value[1] = -1.0;
    tvalue->component_params_value[2] = -1.0;
    /* physical */
    tvalue->physical_params_value[0] = 10.0;
    tvalue->physical_params_value[1] = 100.0;
    tvalue->physical_params_value[2] = -1.0;
    tvalue->physical_params_value[3] = -1.0;    
    /* electrical */
    tvalue->electrical_params_value[0] = 50.0;    
    tvalue->electrical_params_value[1] = 90.0;    
    tvalue->electrical_params_value[2] = -1.0;    
    tvalue->electrical_params_value[3] = -1.0;    
    break;
    
  case RECTWAVEGUIDE :
    /* substrate */
    tvalue->subparams_value[0] = 1.0;
    tvalue->subparams_value[1] = 1.0;
    tvalue->subparams_value[2] = 4.1e7;
    tvalue->subparams_value[3] = 0.0;
    tvalue->subparams_value[4] = 0.0;
    tvalue->subparams_value[5] = -1.0;
    tvalue->subparams_value[6] = -1.0;
    tvalue->subparams_value[7] = -1.0;
    tvalue->subparams_value[8] = -1.0;
    /* component */
    tvalue->component_params_value[0] = 10.0;
    tvalue->component_params_value[1] = -1.0;
    tvalue->component_params_value[2] = -1.0;
    /* physical */
    tvalue->physical_params_value[0] = 1000.0;
    tvalue->physical_params_value[1] = 500.0;
    tvalue->physical_params_value[2] = 4000.0;
    tvalue->physical_params_value[3] = -1.0;    
    /* electrical */
    tvalue->electrical_params_value[0] = 50.0;    
    tvalue->electrical_params_value[1] = 90.0;    
    tvalue->electrical_params_value[2] = -1.0;    
    tvalue->electrical_params_value[3] = -1.0;    
    break;

  case COAX :
    /* substrate */
    tvalue->subparams_value[0] = 2.1;
    tvalue->subparams_value[1] = 1.0;
    tvalue->subparams_value[2] = 0.002;
    tvalue->subparams_value[3] = 4.1e7;
    tvalue->subparams_value[4] = -1.0;
    tvalue->subparams_value[5] = -1.0;
    tvalue->subparams_value[6] = -1.0;
    tvalue->subparams_value[7] = -1.0;
    tvalue->subparams_value[8] = -1.0;
    /* component */
    tvalue->component_params_value[0] = 10.0;
    tvalue->component_params_value[1] = -1.0;
    tvalue->component_params_value[2] = -1.0;
    /* physical */
    tvalue->physical_params_value[0] = 40.0;
    tvalue->physical_params_value[1] = 134.0;
    tvalue->physical_params_value[2] = 1000.0;
    tvalue->physical_params_value[3] = -1.0;    
    /* electrical */
    tvalue->electrical_params_value[0] = 50.0;    
    tvalue->electrical_params_value[1] = 90.0;    
    tvalue->electrical_params_value[2] = -1.0;    
    tvalue->electrical_params_value[3] = -1.0;    
    break;

  case C_MICROSTRIP :
    /* substrate */
    tvalue->subparams_value[0] = 4.3;
    tvalue->subparams_value[1] = 1.0;
    tvalue->subparams_value[2] = 8.27;
    tvalue->subparams_value[3] = 1.e20;
    tvalue->subparams_value[4] = 0.68;
    tvalue->subparams_value[5] = 4.1e7;
    tvalue->subparams_value[6] = 0.0;
    tvalue->subparams_value[7] = 0.0;
    tvalue->subparams_value[8] = -1.0;   /* -1 implies no value and make widget insensitive*/
    /* component */
    tvalue->component_params_value[0] = 10.0;
    tvalue->component_params_value[1] = -1.0;
    tvalue->component_params_value[2] = -1.0;
    /* physical */
    tvalue->physical_params_value[0] = 8.66;
    tvalue->physical_params_value[1] = 5.31;
    tvalue->physical_params_value[2] = 1000.0;
    tvalue->physical_params_value[3] = -1.0;    
    tvalue->physical_params_value[3] = -1.0;    
    /* electrical */
    tvalue->electrical_params_value[0] = 50.0;    
    tvalue->electrical_params_value[1] = 90.0;    
    tvalue->electrical_params_value[2] = -1.0;    
    tvalue->electrical_params_value[3] = -1.0;    
    break;
  default:
    fprintf(stderr, "setup_values: unknown transmission line type!\n");
  }
}

