# API Reference

```{toctree}
:maxdepth: 3
```

```{eval-rst}
.. module:: simplipy
```

## API

```{eval-rst}
.. automodule:: simplipy.api
   :members:
```

## Websocket Communication

```{eval-rst}
.. autoclass:: simplipy.websocket.WebsocketClient
   :members:
```

```{eval-rst}
.. autoclass:: simplipy.websocket.WebsocketEvent
   :members:
   :undoc-members:
```

## Devices

```{eval-rst}
.. autoclass:: simplipy.device.Device
   :members:
```

```{eval-rst}
.. autoclass:: simplipy.device.DeviceTypes
   :members:
   :undoc-members:
```

```{eval-rst}
.. autoclass:: simplipy.device.DeviceV3
   :members:
```

## Lock

```{eval-rst}
.. autoclass:: simplipy.device.lock.Lock
   :members:
```

```{eval-rst}
.. autoclass:: simplipy.device.lock.LockStates
   :members:
   :undoc-members:
```

## Sensors

```{eval-rst}
.. autoclass:: simplipy.device.sensor.v2.SensorV2
   :members:
```

```{eval-rst}
.. autoclass:: simplipy.device.sensor.v3.SensorV3
   :members:
```

## Systems

```{eval-rst}
.. autoclass:: simplipy.system.System
   :members:
```

```{eval-rst}
.. autoclass:: simplipy.system.v2.SystemV2
   :members:
```

```{eval-rst}
.. autoclass:: simplipy.system.v3.SystemV3
   :members:
```

```{eval-rst}
.. autoclass:: simplipy.system.SystemNotification
   :members:
   :undoc-members:
```

```{eval-rst}
.. autoclass:: simplipy.system.SystemStates
   :members:
   :undoc-members:
```

## Utilities

```{eval-rst}
.. automodule:: simplipy.util
   :members:
```

### `auth`

```{eval-rst}
.. automodule:: simplipy.util.auth
   :members:
```

### `dt`

```{eval-rst}
.. automodule:: simplipy.util.dt
   :members:
```

### `string`

```{eval-rst}
.. automodule:: simplipy.util.string
   :members:
```

## Errors

```{eval-rst}
.. automodule:: simplipy.errors
   :members:
```
