// Copyright 2021 the SVG Types Authors
// SPDX-License-Identifier: Apache-2.0 OR MIT

// This file is autogenerated. Do not edit it!

use crate::Color;

static COLORS: Map<Color> = Map {
    key: 3213172566270843353,
    disps: &[
        (0, 37),
        (0, 74),
        (1, 0),
        (0, 22),
        (0, 92),
        (2, 125),
        (0, 73),
        (0, 8),
        (0, 2),
        (0, 4),
        (26, 16),
        (67, 121),
        (0, 3),
        (0, 4),
        (0, 60),
        (0, 39),
        (0, 130),
        (0, 15),
        (3, 38),
        (0, 136),
        (7, 75),
        (6, 141),
        (7, 67),
        (0, 14),
        (0, 128),
        (27, 111),
        (1, 31),
        (0, 12),
        (2, 49),
        (0, 2),
    ],
    entries: &[
        ("lightgrey", Color { red: 211, green: 211, blue: 211, alpha: 255 }),
        ("lavenderblush", Color { red: 255, green: 240, blue: 245, alpha: 255 }),
        ("deeppink", Color { red: 255, green: 20, blue: 147, alpha: 255 }),
        ("seashell", Color { red: 255, green: 245, blue: 238, alpha: 255 }),
        ("lightsalmon", Color { red: 255, green: 160, blue: 122, alpha: 255 }),
        ("green", Color { red: 0, green: 128, blue: 0, alpha: 255 }),
        ("lightgreen", Color { red: 144, green: 238, blue: 144, alpha: 255 }),
        ("black", Color { red: 0, green: 0, blue: 0, alpha: 255 }),
        ("deepskyblue", Color { red: 0, green: 191, blue: 255, alpha: 255 }),
        ("mistyrose", Color { red: 255, green: 228, blue: 225, alpha: 255 }),
        ("silver", Color { red: 192, green: 192, blue: 192, alpha: 255 }),
        ("dimgray", Color { red: 105, green: 105, blue: 105, alpha: 255 }),
        ("navajowhite", Color { red: 255, green: 222, blue: 173, alpha: 255 }),
        ("royalblue", Color { red: 65, green: 105, blue: 225, alpha: 255 }),
        ("peru", Color { red: 205, green: 133, blue: 63, alpha: 255 }),
        ("darkgrey", Color { red: 169, green: 169, blue: 169, alpha: 255 }),
        ("steelblue", Color { red: 70, green: 130, blue: 180, alpha: 255 }),
        ("teal", Color { red: 0, green: 128, blue: 128, alpha: 255 }),
        ("orangered", Color { red: 255, green: 69, blue: 0, alpha: 255 }),
        ("mediumslateblue", Color { red: 123, green: 104, blue: 238, alpha: 255 }),
        ("blueviolet", Color { red: 138, green: 43, blue: 226, alpha: 255 }),
        ("cornflowerblue", Color { red: 100, green: 149, blue: 237, alpha: 255 }),
        ("cyan", Color { red: 0, green: 255, blue: 255, alpha: 255 }),
        ("beige", Color { red: 245, green: 245, blue: 220, alpha: 255 }),
        ("goldenrod", Color { red: 218, green: 165, blue: 32, alpha: 255 }),
        ("rosybrown", Color { red: 188, green: 143, blue: 143, alpha: 255 }),
        ("yellow", Color { red: 255, green: 255, blue: 0, alpha: 255 }),
        ("blue", Color { red: 0, green: 0, blue: 255, alpha: 255 }),
        ("darkblue", Color { red: 0, green: 0, blue: 139, alpha: 255 }),
        ("aliceblue", Color { red: 240, green: 248, blue: 255, alpha: 255 }),
        ("white", Color { red: 255, green: 255, blue: 255, alpha: 255 }),
        ("mediumblue", Color { red: 0, green: 0, blue: 205, alpha: 255 }),
        ("dodgerblue", Color { red: 30, green: 144, blue: 255, alpha: 255 }),
        ("limegreen", Color { red: 50, green: 205, blue: 50, alpha: 255 }),
        ("purple", Color { red: 128, green: 0, blue: 128, alpha: 255 }),
        ("lightsteelblue", Color { red: 176, green: 196, blue: 222, alpha: 255 }),
        ("lightslategray", Color { red: 119, green: 136, blue: 153, alpha: 255 }),
        ("seagreen", Color { red: 46, green: 139, blue: 87, alpha: 255 }),
        ("mediumvioletred", Color { red: 199, green: 21, blue: 133, alpha: 255 }),
        ("slategrey", Color { red: 112, green: 128, blue: 144, alpha: 255 }),
        ("darkslategrey", Color { red: 47, green: 79, blue: 79, alpha: 255 }),
        ("turquoise", Color { red: 64, green: 224, blue: 208, alpha: 255 }),
        ("paleturquoise", Color { red: 175, green: 238, blue: 238, alpha: 255 }),
        ("lightgoldenrodyellow", Color { red: 250, green: 250, blue: 210, alpha: 255 }),
        ("magenta", Color { red: 255, green: 0, blue: 255, alpha: 255 }),
        ("darkseagreen", Color { red: 143, green: 188, blue: 143, alpha: 255 }),
        ("lightcyan", Color { red: 224, green: 255, blue: 255, alpha: 255 }),
        ("lightcoral", Color { red: 240, green: 128, blue: 128, alpha: 255 }),
        ("mediumseagreen", Color { red: 60, green: 179, blue: 113, alpha: 255 }),
        ("palegoldenrod", Color { red: 238, green: 232, blue: 170, alpha: 255 }),
        ("palegreen", Color { red: 152, green: 251, blue: 152, alpha: 255 }),
        ("darkslateblue", Color { red: 72, green: 61, blue: 139, alpha: 255 }),
        ("moccasin", Color { red: 255, green: 228, blue: 181, alpha: 255 }),
        ("forestgreen", Color { red: 34, green: 139, blue: 34, alpha: 255 }),
        ("darkkhaki", Color { red: 189, green: 183, blue: 107, alpha: 255 }),
        ("chartreuse", Color { red: 127, green: 255, blue: 0, alpha: 255 }),
        ("floralwhite", Color { red: 255, green: 250, blue: 240, alpha: 255 }),
        ("snow", Color { red: 255, green: 250, blue: 250, alpha: 255 }),
        ("fuchsia", Color { red: 255, green: 0, blue: 255, alpha: 255 }),
        ("orchid", Color { red: 218, green: 112, blue: 214, alpha: 255 }),
        ("darkorchid", Color { red: 153, green: 50, blue: 204, alpha: 255 }),
        ("darkred", Color { red: 139, green: 0, blue: 0, alpha: 255 }),
        ("darksalmon", Color { red: 233, green: 150, blue: 122, alpha: 255 }),
        ("crimson", Color { red: 220, green: 20, blue: 60, alpha: 255 }),
        ("lime", Color { red: 0, green: 255, blue: 0, alpha: 255 }),
        ("palevioletred", Color { red: 219, green: 112, blue: 147, alpha: 255 }),
        ("lightseagreen", Color { red: 32, green: 178, blue: 170, alpha: 255 }),
        ("ivory", Color { red: 255, green: 255, blue: 240, alpha: 255 }),
        ("powderblue", Color { red: 176, green: 224, blue: 230, alpha: 255 }),
        ("aquamarine", Color { red: 127, green: 255, blue: 212, alpha: 255 }),
        ("darkturquoise", Color { red: 0, green: 206, blue: 209, alpha: 255 }),
        ("lavender", Color { red: 230, green: 230, blue: 250, alpha: 255 }),
        ("azure", Color { red: 240, green: 255, blue: 255, alpha: 255 }),
        ("mediumturquoise", Color { red: 72, green: 209, blue: 204, alpha: 255 }),
        ("lightgray", Color { red: 211, green: 211, blue: 211, alpha: 255 }),
        ("transparent", Color { red: 0, green: 0, blue: 0, alpha: 0 }),
        ("gainsboro", Color { red: 220, green: 220, blue: 220, alpha: 255 }),
        ("olivedrab", Color { red: 107, green: 142, blue: 35, alpha: 255 }),
        ("papayawhip", Color { red: 255, green: 239, blue: 213, alpha: 255 }),
        ("tomato", Color { red: 255, green: 99, blue: 71, alpha: 255 }),
        ("midnightblue", Color { red: 25, green: 25, blue: 112, alpha: 255 }),
        ("pink", Color { red: 255, green: 192, blue: 203, alpha: 255 }),
        ("yellowgreen", Color { red: 154, green: 205, blue: 50, alpha: 255 }),
        ("slategray", Color { red: 112, green: 128, blue: 144, alpha: 255 }),
        ("red", Color { red: 255, green: 0, blue: 0, alpha: 255 }),
        ("indigo", Color { red: 75, green: 0, blue: 130, alpha: 255 }),
        ("orange", Color { red: 255, green: 165, blue: 0, alpha: 255 }),
        ("grey", Color { red: 128, green: 128, blue: 128, alpha: 255 }),
        ("wheat", Color { red: 245, green: 222, blue: 179, alpha: 255 }),
        ("darkgoldenrod", Color { red: 184, green: 134, blue: 11, alpha: 255 }),
        ("lawngreen", Color { red: 124, green: 252, blue: 0, alpha: 255 }),
        ("lightslategrey", Color { red: 119, green: 136, blue: 153, alpha: 255 }),
        ("burlywood", Color { red: 222, green: 184, blue: 135, alpha: 255 }),
        ("aqua", Color { red: 0, green: 255, blue: 255, alpha: 255 }),
        ("saddlebrown", Color { red: 139, green: 69, blue: 19, alpha: 255 }),
        ("oldlace", Color { red: 253, green: 245, blue: 230, alpha: 255 }),
        ("lightskyblue", Color { red: 135, green: 206, blue: 250, alpha: 255 }),
        ("violet", Color { red: 238, green: 130, blue: 238, alpha: 255 }),
        ("dimgrey", Color { red: 105, green: 105, blue: 105, alpha: 255 }),
        ("darkorange", Color { red: 255, green: 140, blue: 0, alpha: 255 }),
        ("lightblue", Color { red: 173, green: 216, blue: 230, alpha: 255 }),
        ("khaki", Color { red: 240, green: 230, blue: 140, alpha: 255 }),
        ("coral", Color { red: 255, green: 127, blue: 80, alpha: 255 }),
        ("brown", Color { red: 165, green: 42, blue: 42, alpha: 255 }),
        ("mediumpurple", Color { red: 147, green: 112, blue: 219, alpha: 255 }),
        ("linen", Color { red: 250, green: 240, blue: 230, alpha: 255 }),
        ("mediumorchid", Color { red: 186, green: 85, blue: 211, alpha: 255 }),
        ("indianred", Color { red: 205, green: 92, blue: 92, alpha: 255 }),
        ("maroon", Color { red: 128, green: 0, blue: 0, alpha: 255 }),
        ("firebrick", Color { red: 178, green: 34, blue: 34, alpha: 255 }),
        ("skyblue", Color { red: 135, green: 206, blue: 235, alpha: 255 }),
        ("darkgray", Color { red: 169, green: 169, blue: 169, alpha: 255 }),
        ("hotpink", Color { red: 255, green: 105, blue: 180, alpha: 255 }),
        ("olive", Color { red: 128, green: 128, blue: 0, alpha: 255 }),
        ("sienna", Color { red: 160, green: 82, blue: 45, alpha: 255 }),
        ("cadetblue", Color { red: 95, green: 158, blue: 160, alpha: 255 }),
        ("darkslategray", Color { red: 47, green: 79, blue: 79, alpha: 255 }),
        ("slateblue", Color { red: 106, green: 90, blue: 205, alpha: 255 }),
        ("plum", Color { red: 221, green: 160, blue: 221, alpha: 255 }),
        ("mediumspringgreen", Color { red: 0, green: 250, blue: 154, alpha: 255 }),
        ("thistle", Color { red: 216, green: 191, blue: 216, alpha: 255 }),
        ("mintcream", Color { red: 245, green: 255, blue: 250, alpha: 255 }),
        ("darkmagenta", Color { red: 139, green: 0, blue: 139, alpha: 255 }),
        ("lemonchiffon", Color { red: 255, green: 250, blue: 205, alpha: 255 }),
        ("bisque", Color { red: 255, green: 228, blue: 196, alpha: 255 }),
        ("antiquewhite", Color { red: 250, green: 235, blue: 215, alpha: 255 }),
        ("darkgreen", Color { red: 0, green: 100, blue: 0, alpha: 255 }),
        ("whitesmoke", Color { red: 245, green: 245, blue: 245, alpha: 255 }),
        ("lightpink", Color { red: 255, green: 182, blue: 193, alpha: 255 }),
        ("darkcyan", Color { red: 0, green: 139, blue: 139, alpha: 255 }),
        ("tan", Color { red: 210, green: 180, blue: 140, alpha: 255 }),
        ("blanchedalmond", Color { red: 255, green: 235, blue: 205, alpha: 255 }),
        ("honeydew", Color { red: 240, green: 255, blue: 240, alpha: 255 }),
        ("salmon", Color { red: 250, green: 128, blue: 114, alpha: 255 }),
        ("lightyellow", Color { red: 255, green: 255, blue: 224, alpha: 255 }),
        ("springgreen", Color { red: 0, green: 255, blue: 127, alpha: 255 }),
        ("cornsilk", Color { red: 255, green: 248, blue: 220, alpha: 255 }),
        ("sandybrown", Color { red: 244, green: 164, blue: 96, alpha: 255 }),
        ("mediumaquamarine", Color { red: 102, green: 205, blue: 170, alpha: 255 }),
        ("darkviolet", Color { red: 148, green: 0, blue: 211, alpha: 255 }),
        ("darkolivegreen", Color { red: 85, green: 107, blue: 47, alpha: 255 }),
        ("gold", Color { red: 255, green: 215, blue: 0, alpha: 255 }),
        ("peachpuff", Color { red: 255, green: 218, blue: 185, alpha: 255 }),
        ("greenyellow", Color { red: 173, green: 255, blue: 47, alpha: 255 }),
        ("gray", Color { red: 128, green: 128, blue: 128, alpha: 255 }),
        ("navy", Color { red: 0, green: 0, blue: 128, alpha: 255 }),
        ("ghostwhite", Color { red: 248, green: 248, blue: 255, alpha: 255 }),
        ("chocolate", Color { red: 210, green: 105, blue: 30, alpha: 255 }),
    ],
};

pub fn from_str(text: &str) -> Option<Color> {
    COLORS.get(text).cloned()
}

// A stripped down `phf` crate fork.
//
// https://github.com/sfackler/rust-phf

use std::hash::Hasher;

pub struct Map<V: 'static> {
    pub key: u64,
    pub disps: &'static [(u32, u32)],
    pub entries: &'static[(&'static str, V)],
}

impl<V> Map<V> {
    pub fn get(&self, key: &str) -> Option<&V> {
        let hash = hash(key, self.key);
        let index = get_index(hash, self.disps, self.entries.len());
        let entry = &self.entries[index as usize];
        if entry.0 == key {
            Some(&entry.1)
        } else {
            None
        }
    }
}

#[inline]
fn hash(x: &str, key: u64) -> u64 {
    let mut hasher = siphasher::sip::SipHasher13::new_with_keys(0, key);
    hasher.write(x.as_bytes());
    hasher.finish()
}

#[inline]
fn get_index(hash: u64, disps: &[(u32, u32)], len: usize) -> u32 {
    let (g, f1, f2) = split(hash);
    let (d1, d2) = disps[(g % (disps.len() as u32)) as usize];
    displace(f1, f2, d1, d2) % (len as u32)
}

#[inline]
fn split(hash: u64) -> (u32, u32, u32) {
    const BITS: u32 = 21;
    const MASK: u64 = (1 << BITS) - 1;

    ((hash & MASK) as u32,
     ((hash >> BITS) & MASK) as u32,
     ((hash >> (2 * BITS)) & MASK) as u32)
}

#[inline]
fn displace(f1: u32, f2: u32, d1: u32, d2: u32) -> u32 {
    d2 + f1 * d1 + f2
}
