# -*- mode: python; tab-width: 4 -*-

import gtk
import os
import signal
import tempfile
import logging
import sys
import time

from sugar.activity.Activity import Activity


#import ourselves so we can get __file__
import paintActivity

#where are we?
activity_root = os.path.split(paintActivity.__file__)[0]

#chdir here so that relative paths line up, i.e ./bin & ./bin/locale
os.chdir(activity_root) 



class paintActivity(Activity):
	def __init__(self):
		Activity.__init__(self)
	
		self.set_title("Paint")
		self.connect('destroy', self._destroy_cb)
		self.connect('focus-in-event', self._focus_in_cb)
		self.connect('focus-out-event', self._focus_out_cb)


		signal.signal(signal.SIGCHLD, self._sigchild_handler)

		socket = gtk.Socket()
		self.add(socket)
		socket.show()
		socket.connect('plug-removed', self._plug_removed_cb)
		win = socket.get_id()

		pipe = tempfile.mktemp()
		os.mkfifo(pipe, 0600)
		self._pipe=open(pipe, 'r+', 0)

		self._pid = os.fork()
		if self._pid == 0:
			os.execlp('sh', 'sh', '-c',		# sh used to enable shell expansion of wildcards
				'./bin/rgbpaint -u 32 '		# 32MB for undo
				'-browserWindow %i '
				'sugarPipe %s '
				'-d /home/olpc '		# Set starting load/save directory
				'-svg activity/ '		# Use SVG icons
				'-thumbs 80 '			# Use 80x80 thumbnails for stamps
				'-stamps /home/olpc/stamps/*'
				% (win, pipe)
				)

		logging.debug("started rgbpaint, pid %i" % self._pid )



	def share(self):
		Activity.share(self)
		self._pipe.write("SHARE\n")


	def quit_rgbpaint(self):
		if self._pipe:
#			logging.debug("quitting rgbpaint")
			self._pipe.write("QUIT\n")
			self.remove_pipe()
#			time.sleep(10)
#		if self._pid:
#			self.kill_rgbpaint(signal.SIGTERM)
#			time.sleep(3)
#		if self._pid:
#			self.kill_rgbpaint(signal.SIGKILL)

		
	def kill_rgbpaint(self, sig):
		if self._pid:
			logging.debug("kill rgbPaint %i with %i" % (self._pid, sig))
			try:
				os.kill(self._pid, sig)
			except OSError:
				logging.debug("kill failed")


	def remove_pipe(self):
		if self._pipe:
			logging.debug("removing pipe %s" % self._pipe.name)
			os.unlink(self._pipe.name)
			self._pipe = None


	def _plug_removed_cb(self, sock):
		logging.debug("rgbPaint window closed")
		self.remove_pipe()
		self.destroy()
		return False

	
	def _destroy_cb(self, window):
		logging.debug("rgbPaint activity destroyed %r" % window)
		self.quit_rgbpaint()

		
	def _focus_in_cb(self, window, event):
		logging.debug("rgbPaint activated %r %r" % (window, event))
#		self._pipe.write("COLOUR 255 255 0\n")
		self._pipe.write("ACTIVATE\n")

	def _focus_out_cb(self, window, event):
		logging.debug("rgbPaint deactivated %r %r" % (window, event))
#		self._pipe.write("COLOUR 255 0 0\n")
		self._pipe.write("DEACTIVATE\n")


	def _sigchild_handler(self, signum, frame):
		logging.debug("got signal %i %r" % (signum, frame))
		self._pid = 0
