## RabbitMQ 3.8.3

RabbitMQ `3.8.3` is a maintenance release.


### Erlang/OTP Compatibility Notes

This release [**requires Erlang/OTP 21.3**](https://www.rabbitmq.com/which-erlang.html) or later.
`22.x` series is recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.


### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release from `3.7.6` or an older version, extra care has to be taken.

Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later, RabbitMQ **must be upgraded at the same time as Erlang**.
Alternatively the node can be upgraded to `3.7.18` first, then Erlang 21.x or 22.x, then to RabbitMQ 3.8.x.

#### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).



## Changes


### Core Server

#### Bug Fixes

 * Reduced scheduled GC activity in connection socket writer to one run per 1 GiB of data transferred, with an option to change the value or disable scheduled run entirely.
   More frequent binary heap GC runs seem unneccesary on Erlang 22.

   Contributed by Aleksander Nycz.

   GitHub issue: [rabbitmq/rabbitmq-common#343](https://github.com/rabbitmq/rabbitmq-common/pull/343)

 * Eliminated an inefficiency in recovery of quorum queues with a backlog of messages.

   GitHub issue: [rabbitmq/rabbitmq-server#2260](https://github.com/rabbitmq/rabbitmq-server/pull/2260)

 * In a case where a node hosting a quorum queue replica went offline and was removed from the cluster,
   and later came back, quorum queues could enter a loop of Raft leader elections.

   GitHub issue: [rabbitmq/rabbitmq-server#2255](https://github.com/rabbitmq/rabbitmq-server/pull/2255)

 * Quorum queues with a dead lettering could fail to recover.

   GitHub issue: [rabbitmq/rabbitmq-server#2256](https://github.com/rabbitmq/rabbitmq-server/pull/2256)

 * The node now can recover even if virtual host recovery terms file was corrupted.

   Contributed by @tomyouyou.

   GitHub issue: [rabbitmq/rabbitmq-server#2195](https://github.com/rabbitmq/rabbitmq-server/pull/2195)

 * Autoheal could fail to finish if one of its state transitions initiated by a remote node timed out.

   Contributed by @tomyouyou.

   GitHub issue: [rabbitmq/rabbitmq-server#2209](https://github.com/rabbitmq/rabbitmq-server/pull/2209)

 * Syslog client is now started even when Syslog logging is configured only for some log sinks.

   GitHub issue: [rabbitmq/rabbitmq-server#2044](https://github.com/rabbitmq/rabbitmq-server/issues/2044)

 * Policies that quorum queues ignored were still listed as applied to them.

   GitHub issue: [rabbitmq/rabbitmq-server#2210](https://github.com/rabbitmq/rabbitmq-server/pull/2210)

 * If a quorum queue leader rebalancing operation timed out, CLI tools failed with an exception instead of a sensible internal API response.

   Contributed by Gabriele Santomaggio.

   GitHub issue: [rabbitmq/rabbitmq-server#2214](https://github.com/rabbitmq/rabbitmq-server/issues/2214)

 * Handle timeout error on the rebalance function.

   Contributed by Gabriele Santomaggio.

   GitHub issue: [rabbitmq/rabbitmq-server#2218](https://github.com/rabbitmq/rabbitmq-server/pull/2218)

 * Handle and raise protocol error for absent queues assumed to be alive.

   Contributed by Ayanda Dube.

   GitHub issue: [rabbitmq/rabbitmq-server#2233](https://github.com/rabbitmq/rabbitmq-server/pull/2233)

#### Enhancements

 * Some Proxy protocol errors are now logged at debug level.
   This reduces log noise in environments where TCP load balancers and proxies perform health checks by opening a TCP connection but never sending any data.

   GitHub issue: [rabbitmq/rabbitmq-server#2204](https://github.com/rabbitmq/rabbitmq-server/pull/2204)

 * Quorum queue deletion operation no longer supports the "if unused" and "if empty" options.
   They are typically used for transient queues don't make much sense for quorum ones.

   GitHub issue: [rabbitmq/rabbitmq-server#2211](https://github.com/rabbitmq/rabbitmq-server/pull/2211)

 * Do not treat applications that do not depend on rabbit as plugins.
   This is especially important for applications that should not be stopped before rabbit is stopped.

   GitHub Issue: [rabbitmq/rabbitmq-server#2212](https://github.com/rabbitmq/rabbitmq-server/pull/2212)

 * RabbitMQ nodes will now gracefully shutdown when receiving a `SIGTERM` signal.
   Previously the runtime would invoke a default handler that terminates the VM giving RabbitMQ no chance to execute its shutdown steps.

   GitHub issue: [rabbitmq/rabbitmq-server#2222](https://github.com/rabbitmq/rabbitmq-server/issues/2222)

 * Every cluster now features a persistent internal cluster ID that can be used by core features or plugins.
   Unlike the human-readable cluster name, the value cannot be overridden by the user.

   GitHub issue: [rabbitmq/rabbitmq-server#2226](https://github.com/rabbitmq/rabbitmq-server/pull/2226)

 * Speedup execution of boot steps by a factor of 2N, where N is the number of attributes per step.

   Contributed by Ayanda Dube.

   GitHub issue: [rabbitmq/rabbitmq-server#2246](https://github.com/rabbitmq/rabbitmq-server/pull/2246)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-diagnostics status` failed to display the results when executed against a node that had high VM watermark set as an absolute value (using `vm_memory_high_watermark.absolute`).

   GitHub issue: [rabbitmq/rabbitmq-cli#395](https://github.com/rabbitmq/rabbitmq-cli/issues/395)

#### Enhancements

 * New health checks that can be used to determine if it's a good moment to shut down a node for an upgrade.

   ``` sh
   # Exits with a non-zero code if target node hosts leader replica of at least one queue
   # that has out-of-sync mirror.
   rabbitmq-diagnostics check_if_node_is_mirror_sync_critical

   # Exits with a non-zero code if one or more quorum queues will lose online quorum
   # should target node be shut down
   rabbitmq-diagnostics check_if_node_is_quorum_critical
   ```

   GitHub issue: [rabbitmq/rabbitmq-cli#389](https://github.com/rabbitmq/rabbitmq-cli/issues/389)

 * Some proxy protocol errors are now logged at debug level.
 * This reduces log noise in environments where TCP load balancers and proxies perform health checks by opening a TCP connection but never sending any data.

   GitHub issue: [rabbitmq/rabbitmq-server#2204](https://github.com/rabbitmq/rabbitmq-server/pull/2204)


### Management and Management Agent Plugins

#### Bug Fixes

 * Consumer section on individual page was unintentionally hidden.

   GitHub issue: [rabbitmq/rabbitmq-management#758](https://github.com/rabbitmq/rabbitmq-management/issues/758)

 * Fix queue-type select by adding unsafe-inline CSP policy.

   GitHub issue: [rabbitmq/rabbitmq-management#769](https://github.com/rabbitmq/rabbitmq-management/pull/769)

#### Enhancements

 * An undocumented "automagic login" feature on the login form was removed.

   GitHub issue: [rabbitmq/rabbitmq-management#748](https://github.com/rabbitmq/rabbitmq-management/pull/748)

 * A new `POST /login` endpoint can be used by custom management UI login forms to authenticate the user and set the cookie.

   GitHub issue: [rabbitmq/rabbitmq-management#764](https://github.com/rabbitmq/rabbitmq-management/issues/764)

 * A new `POST /rebalance/queues` endpoint that is the HTTP API equivalent of `rabbitmq-queues rebalance`

   GitHub issue: [rabbitmq/rabbitmq-management#782](https://github.com/rabbitmq/rabbitmq-management/issues/782)

 * Warning about a missing `handle.exe` in `PATH` on Windows is now only logged every 10 minutes.

   GitHub issue: [rabbitmq/rabbitmq-management-agent#90](https://github.com/rabbitmq/rabbitmq-management-agent/issues/90)

 * `rabbitmqadmin declare queue` now supports a new `queue_type` parameter to simplify declaration of quorum queues.

   GitHub issue: [rabbitmq/rabbitmq-management#761](https://github.com/rabbitmq/rabbitmq-management/issues/761)

 * HTTP API request log entries now includes acting user.

   GitHub issue: [rabbitmq/rabbitmq-management#760](https://github.com/rabbitmq/rabbitmq-management/issues/760)

 * [Content Security Policy headers](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP) are now also set for static assets such as JavaScript files.

   GitHub issue: [rabbitmq/rabbitmq-management#767](https://github.com/rabbitmq/rabbitmq-management/issues/767)


### Prometheus Plugin

#### Enhancements

 * Add option to aggregate metrics for channels, queues & connections. Metrics are now aggregated by default (safe by default).
   This new behaviour can be disabled via `prometheus.return_per_object_metrics = true` config.

   GitHub issue: [rabbitmq/rabbitmq-prometheus#28](https://github.com/rabbitmq/rabbitmq-prometheus/issues/28)


### Kubernetes Peer Discovery Plugin

#### Enhancements

 * The plugin will now notify [Kubernetes API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.16/#event-v1-core) of node startup and peer stop/unavailability events.

   Contributed by Gabriele Santomaggio.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-k8s#61](https://github.com/rabbitmq/rabbitmq-peer-discovery-k8s/pull/61)


### Etcd Peer Discovery Plugin

#### Bug Fixes

 * Only run healthcheck when backend is configured.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-etcd#21](https://github.com/rabbitmq/rabbitmq-peer-discovery-etcd/pull/21)


### Federation Plugin

#### Bug Fixes

 * Use vhost to delete federated exchange.

   [Reported by Brett Janer](https://groups.google.com/forum/#!topic/rabbitmq-users/nfulekZc_OQ/discussion).

   GitHub issue: [rabbitmq/rabbitmq-federation#99](https://github.com/rabbitmq/rabbitmq-federation/pull/99)

#### Enhancements

 * "Command" operations such as binding propagation now use a separate channel for all links, preventing latency spikes for asynchronous operations (such as message publishing) (a head-of-line blocking problem).

   Contributed by Grigory Starinkin.

   GitHub issue: [rabbitmq/rabbitmq-federation#97](https://github.com/rabbitmq/rabbitmq-federation/pull/97)


### Auth Backend OAuth 2 Plugin

 * Additional scopes can be fetched from a predefined JWT token field.
   Those scopes will be combined with the standard scopes field.

   Contributed by @papugamichal.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-oauth2#41](https://github.com/rabbitmq/rabbitmq-auth-backend-oauth2/pull/41)


### Trust Store Plugin

#### Enhancements

 * HTTPS certificate provider will not longer terminate if upstream service response contains invalid JSON.

   GitHub issue: [rabbitmq/rabbitmq-trust-store#73](https://github.com/rabbitmq/rabbitmq-trust-store/issues/73)


### MQTT Plugin

#### Enhancements

 * Avoid blocking when registering or unregistering a client ID.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#226](https://github.com/rabbitmq/rabbitmq-mqtt/pull/226)


### AMQP 1.0 Client Plugin

#### Enhancements

 * Handle heartbeat in `close_sent/2`.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#44](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/pull/44)



## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.8.3.tar.xz`.



## Dependency upgrades

 * observer-cli was upgraded [from v1.5.2 to v1.5.3](https://github.com/zhongwencool/observer_cli/compare/1.5.2...1.5.3)
 * prometheus.erl was upgraded [from v4.4.0 to v4.5.0](https://github.com/deadtrickster/prometheus.erl/compare/v4.4.0...v4.5.0)
 * ra was upgraded [from v1.0.5 to v1.0.8](https://github.com/rabbitmq/ra/compare/v1.0.5...v1.0.8)
