% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mw-urlencoded.R
\name{mw_urlencoded}
\alias{mw_urlencoded}
\title{Middleware to parse an url-encoded request body}
\usage{
mw_urlencoded(type = "application/x-www-form-urlencoded")
}
\arguments{
\item{type}{Content type to match before parsing. If it does not
match, then the request object is not modified.}
}
\value{
Handler function.
}
\description{
This is typically data from a form. The parsed data is added
as the \code{form} element of the request object.
}
\examples{
app <- new_app()
app$use(mw_urlencoded())
app
}
\seealso{
Other middleware: 
\code{\link{mw_cgi}()},
\code{\link{mw_cookie_parser}()},
\code{\link{mw_etag}()},
\code{\link{mw_json}()},
\code{\link{mw_log}()},
\code{\link{mw_multipart}()},
\code{\link{mw_range_parser}()},
\code{\link{mw_raw}()},
\code{\link{mw_static}()},
\code{\link{mw_text}()}
}
\concept{middleware}
