% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.R
\name{commit}
\alias{commit}
\title{Commit}
\usage{
commit(conn, name, expunge_deletes = FALSE, wait_searcher = TRUE,
  soft_commit = FALSE, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) A collection or core name. Required.}

\item{expunge_deletes}{merge segments with deletes away. Default: \code{FALSE}}

\item{wait_searcher}{block until a new searcher is opened and registered as
the main query searcher, making the changes visible. Default: \code{TRUE}}

\item{soft_commit}{perform a soft commit - this will refresh the 'view' of
the index in a more performant manner, but without "on-disk" guarantees.
Default: \code{FALSE}}

\item{wt}{(character) One of json (default) or xml. If json, uses
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} to parse. If xml, uses \code{\link[xml2:read_xml]{xml2::read_xml()}} to parse}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by
\code{wt} param}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Commit
}
\examples{
\dontrun{
(conn <- SolrClient$new())

conn$commit("gettingstarted")
conn$commit("gettingstarted", wait_searcher = FALSE)

# get xml back
conn$commit("gettingstarted", wt = "xml")
## raw xml
conn$commit("gettingstarted", wt = "xml", raw = TRUE)
}
}
\references{
<>
}
