% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{dimnames.Seurat}
\alias{dimnames.Seurat}
\alias{dimnames<-.Seurat}
\title{Feature and Cell Names}
\usage{
\method{dimnames}{Seurat}(x)

\method{dimnames}{Seurat}(x) <- value
}
\arguments{
\item{x}{A \code{\link{Seurat}} object}

\item{value}{A two-length list with updated feature and/or cells names}
}
\value{
\code{dimnames}: A two-length list with the following values:
\itemize{
 \item A character vector with all features in the
  \link[=DefaultAssay]{default assay}
 \item A character vector with all cells in \code{x}
}

\code{dimnames<-}: \code{x} with the feature and/or cell
names updated to \code{value}
}
\description{
Get and set feature and cell inames in \code{\link{Seurat}} objects
}
\examples{
# Get the feature names of an object
head(rownames(pbmc_small))

# Get the cell names of an object
head(colnames(pbmc_small))

colnames(pbmc_small)[1] <- "newcell"
head(colnames(pbmc_small))

}
\seealso{
Seurat object, validity, and interaction methods
\code{\link{$.Seurat}()},
\code{\link{Seurat-class}},
\code{\link{Seurat-validity}},
\code{\link{[[.Seurat}()},
\code{\link{[[<-,Seurat}},
\code{\link{[[<-,Seurat,NULL}},
\code{\link{dim.Seurat}()},
\code{\link{merge.Seurat}()},
\code{\link{names.Seurat}()},
\code{\link{subset.Seurat}()}


\code{\link{Cells}()},
\code{\link{dimnames.Assay}()},
\code{\link{dimnames.Assay5}()}
}
\concept{dimnames}
\concept{seurat}
