% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/seurat.R
\name{CreateSeuratObject}
\alias{CreateSeuratObject}
\alias{CreateSeuratObject.default}
\alias{CreateSeuratObject.Assay}
\title{Create a \code{Seurat} object}
\usage{
CreateSeuratObject(
  counts,
  project = "CreateSeuratObject",
  assay = "RNA",
  names.field = 1,
  names.delim = "_",
  meta.data = NULL,
  ...
)

\method{CreateSeuratObject}{default}(
  counts,
  project = "SeuratProject",
  assay = "RNA",
  names.field = 1,
  names.delim = "_",
  meta.data = NULL,
  min.cells = 0,
  min.features = 0,
  ...
)

\method{CreateSeuratObject}{Assay}(
  counts,
  project = "SeuratProject",
  assay = "RNA",
  names.field = 1,
  names.delim = "_",
  meta.data = NULL,
  ...
)
}
\arguments{
\item{counts}{Either a \code{\link[base]{matrix}}-like object with
unnormalized data with cells as columns and features as rows or an
\code{\link{Assay}}-derived object}

\item{project}{\link{Project} name for the \code{Seurat} object}

\item{assay}{Name of the initial assay}

\item{names.field}{For the initial identity class for each cell, choose this
field from the cell's name. E.g. If your cells are named as
BARCODE_CLUSTER_CELLTYPE in the input matrix, set \code{names.field} to 3 to
set the initial identities to CELLTYPE.}

\item{names.delim}{For the initial identity class for each cell, choose this
delimiter from the cell's column name. E.g. If your cells are named as
BARCODE-CLUSTER-CELLTYPE, set this to \dQuote{-} to separate the cell name
into its component parts for picking the relevant field.}

\item{meta.data}{Additional cell-level metadata to add to the Seurat object.
Should be a \code{\link[base]{data.frame}} where the rows are cell names and
the columns are additional metadata fields. Row names in the metadata need
to match the column names of the counts matrix.}

\item{...}{Arguments passed to other methods}

\item{min.cells}{Include features detected in at least this many cells. Will
subset the counts matrix as well. To reintroduce excluded features, create a
new object with a lower cutoff.}

\item{min.features}{Include cells where at least this many features are
detected.}
}
\value{
A \code{\link{Seurat}} object
}
\description{
Create a \code{Seurat} object from raw data
}
\note{
In previous versions (<3.0), this function also accepted a parameter to
set the expression threshold for a \sQuote{detected} feature (gene). This
functionality has been removed to simplify the initialization
process/assumptions. If you would still like to impose this threshold for
your particular dataset, simply filter the input expression matrix before
calling this function.
}
\examples{
\dontrun{
pbmc_raw <- read.table(
  file = system.file('extdata', 'pbmc_raw.txt', package = 'Seurat'),
  as.is = TRUE
)
pbmc_small <- CreateSeuratObject(counts = pbmc_raw)
pbmc_small
}

}
\concept{seurat}
