% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-factor.R
\name{as_rvar_factor}
\alias{as_rvar_factor}
\alias{as_rvar_ordered}
\title{Coerce to a factor random variable}
\usage{
as_rvar_factor(x, dim = NULL, dimnames = NULL, nchains = NULL, ...)

as_rvar_ordered(x, dim = NULL, dimnames = NULL, nchains = NULL, ...)
}
\arguments{
\item{x}{(multiple options) An object that can be converted to an \code{\link{rvar}},
such as a vector, array, or an \code{\link{rvar}} itself.}

\item{dim}{(integer vector) One or more integers giving the maximal indices
in each dimension to override the dimensions of the \code{\link{rvar}} to be created
(see \code{\link[=dim]{dim()}}). If \code{NULL} (the default), \code{dim} is determined by the input.
\strong{NOTE:} This argument controls the dimensions of the \code{\link{rvar}}, not the
underlying array, so you cannot change the number of draws using this
argument.}

\item{dimnames}{(list) Character vectors giving the names in each dimension
to override the names of the dimensions of the \code{\link{rvar}} to be created (see
\code{\link[=dimnames]{dimnames()}}). If \code{NULL} (the default), this is determined by the input.
\strong{NOTE:} This argument controls the names of the dimensions of the
\code{\link{rvar}}, not the underlying array.}

\item{nchains}{(positive integer) The number of chains. The default is \code{1}.}

\item{...}{
  Arguments passed on to \code{\link[base:factor]{base::factor}}
  \describe{
    \item{\code{levels}}{an optional vector of the unique values (as character strings)
    that \code{x} might have taken.  The default is the unique set of
    values taken by \code{\link[base]{as.character}(x)}, sorted into
    increasing order \emph{of \code{x}}.  Note that this set can be
    specified as smaller than \code{sort(unique(x))}.}
    \item{\code{labels}}{\emph{either} an optional character vector of
    labels for the levels (in the same order as \code{levels} after
    removing those in \code{exclude}), \emph{or} a character string of
    length 1.  Duplicated values in \code{labels} can be used to map
    different values of \code{x} to the same factor level.}
    \item{\code{exclude}}{a vector of values to be excluded when forming the
    set of levels.  This may be factor with the same level set as \code{x}
    or should be a \code{character}.}
    \item{\code{ordered}}{logical flag to determine if the levels should be regarded
    as ordered (in the order given).}
    \item{\code{nmax}}{an upper bound on the number of levels; see \sQuote{Details}.}
  }}
}
\value{
An object of class \code{"rvar_factor"} or \code{"rvar_ordered"} representing a random variable.
}
\description{
Convert \code{x} to an \code{\link{rvar_factor}} or \code{\link{rvar_ordered}} object.
}
\details{
For objects that are already \code{\link{rvar}}s, returns them (with modified dimensions
if \code{dim} is not \code{NULL}), possibly adding levels using the unique values of the draws of
the \code{rvar} (if the object is not already factor-like).

For numeric, logical, factor, or character vectors or arrays, returns an \code{\link{rvar_factor}}
or \code{\link{rvar_ordered}} with a single draw and the same dimensions as \code{x}. This is in contrast
to the \code{\link[=rvar_factor]{rvar_factor()}} and \code{\link[=rvar_ordered]{rvar_ordered()}} constructors, which treats the first dimension
of \code{x} as the draws dimension. As a result, \code{as_rvar_factor()} and \code{as_rvar_ordered()}
are useful for creating constants.
}
\examples{

# You can use as_rvar_factor() to create "constant" rvars (having only one draw):
x <- as_rvar_factor("a")
x

# Such constants can be of arbitrary shape:
as_rvar_factor(letters[1:4])
as_rvar_ordered(matrix(letters[1:10], nrow = 5))
as_rvar_factor(array(letters[1:12], dim = c(2, 3, 2)))

}
\seealso{
\code{\link[=rvar]{rvar()}}, \code{\link[=rvar_factor]{rvar_factor()}}, and \code{\link[=rvar_ordered]{rvar_ordered()}} to construct \code{\link{rvar}}s directly.
See \code{\link[=rdo]{rdo()}}, \code{\link[=rfun]{rfun()}}, and \code{\link[=rvar_rng]{rvar_rng()}} for higher-level interfaces for creating \code{rvar}s.
}
