% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_zmq_transfers.r
\name{Transfer Functions for Files or Directories}
\alias{Transfer Functions for Files or Directories}
\alias{zmq.senddir}
\alias{zmq.recvdir}
\title{Transfer Functions for Files or Directories}
\usage{
zmq.senddir(
  port,
  infiles,
  verbose = FALSE,
  flags = ZMQ.SR()$BLOCK,
  ctx = NULL,
  socket = NULL
)

zmq.recvdir(
  port,
  endpoint,
  outfile = NULL,
  exdir = NULL,
  verbose = FALSE,
  flags = ZMQ.SR()$BLOCK,
  ctx = NULL,
  socket = NULL
)
}
\arguments{
\item{port}{A valid tcp port to be passed to \code{zmq.sendfile()} and
\code{zmq.recvfile()}.}

\item{infiles}{The name (as a string) vector of the in files to be zipped and to be
sent away.}

\item{verbose}{Logical; determines if a progress bar should be shown.}

\item{flags}{A flag for the method used by \code{zmq_sendfile} and
\code{zmq_recvfile}}

\item{ctx}{A ZMQ ctx. If \code{NULL} (default), the function will initial one at
the beginning and destroy it after finishing file transfer.}

\item{socket}{A ZMQ socket based on \code{ctx}.
If \code{NULL} (default), the function will create one at the beginning
and close it after finishing file transfer.}

\item{endpoint}{A ZMQ socket endpoint to be passed to \code{zmq.sendfile()} and
\code{zmq.recvfile()}.}

\item{outfile}{The name (as a string) of the out file to be saved on the disk.
If \code{outfile = NULL} and \code{exdir = NULL}, a tempfile will be
used and the tempfile nanme will be returned.}

\item{exdir}{The name (as a string) of the out directory to save the unzip files
unzipped from the received \code{outfile}.}
}
\value{
\code{zmq.senddir()} and \code{zmq.recvdir()} return
number of bytes (invisible) in the sent message if successful,
otherwise returns -1 (invisible) and sets \code{errno} to the error
value, see ZeroMQ manual for details.
In addition, \code{zmq.recvdir()} returns a zipped file name in a list.
}
\description{
High level functions calling \code{zmq.sendfile()} and \code{zmq.recvfile()}
to zip, transfer, and unzip small files or directories contains small files.
}
\details{
\code{zmq.senddir()} calls \code{zmq.senddir()}, and
\code{zmq.recvdir()} calls \code{zmq.recvdir()}.
}
\examples{
\dontrun{
### Run the sender and receiver code in separate R sessions.

### Receiver
library(pbdZMQ, quietly = TRUE)
zmq.recvdir(55555, "localhost", outfile = "./backup_2019.zip",
            verbose = TRUE)
### or unzip to exdir
# zmq.recvdir(55555, "localhost", exdir = "./backup_2019", verbose = TRUE)

### Sender
library(pbdZMQ, quietly = TRUE)
zmq.senddir(55555, c("./pbdZMQ/R", "./pbdZMQ/src"), verbose = TRUE)
}

}
\references{
ZeroMQ/4.1.0 API Reference:
\url{https://libzmq.readthedocs.io/en/zeromq4-1/}

Programming with Big Data in R Website: \url{https://pbdr.org/}
}
\seealso{
\code{\link{zmq.sendfile}()}, \code{\link{zmq.recvfile}()}.
}
\author{
Wei-Chen Chen
}
\keyword{programming}
