% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{is_dag}
\alias{is_dag}
\title{Directed acyclic graphs}
\usage{
is_dag(graph)
}
\arguments{
\item{graph}{The input graph. It may be undirected, in which case
\code{FALSE} is reported.}
}
\value{
A logical vector of length one.
}
\description{
This function tests whether the given graph is a DAG, a directed acyclic
graph.
}
\details{
\code{is_dag()} checks whether there is a directed cycle in the graph. If not,
the graph is a DAG.
}
\examples{

g <- make_tree(10)
is_dag(g)
g2 <- g + edge(5, 1)
is_dag(g2)
}
\seealso{
Graph cycles
\code{\link{feedback_arc_set}()},
\code{\link{feedback_vertex_set}()},
\code{\link{find_cycle}()},
\code{\link{girth}()},
\code{\link{has_eulerian_path}()},
\code{\link{is_acyclic}()},
\code{\link{simple_cycles}()}

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{feedback_vertex_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} for the C code, Gabor Csardi
\email{csardi.gabor@gmail.com} for the R interface.
}
\concept{cycles}
\concept{structural.properties}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_is_dag}{\code{is_dag()}}.}

