% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.R
\name{remote_ls}
\alias{remote_ls}
\title{List references in a remote repository}
\usage{
remote_ls(name = NULL, repo = NULL, credentials = NULL)
}
\arguments{
\item{name}{Character vector with the "remote" repository URL to
query or the name of the remote if a \code{repo} argument is
given.}

\item{repo}{an optional repository object used if remotes are
specified by name.}

\item{credentials}{The credentials for remote repository
access. Default is NULL. To use and query an ssh-agent for the
ssh key credentials, let this parameter be NULL (the default).}
}
\value{
Character vector for each reference with the associated
    commit IDs.
}
\description{
Displays references available in a remote repository along with
the associated commit IDs.  Akin to the 'git ls-remote' command.
}
\examples{
\dontrun{
remote_ls("https://github.com/ropensci/git2r")
}
}
