% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{choose_eafdiffplot}
\alias{choose_eafdiffplot}
\alias{choose_eafdiff}
\title{Interactively choose according to empirical attainment function differences}
\usage{
choose_eafdiffplot(
  data.left,
  data.right,
  intervals = 5,
  maximise = c(FALSE, FALSE),
  title.left = deparse(substitute(data.left)),
  title.right = deparse(substitute(data.right)),
  ...
)

choose_eafdiff(x, left = stop("'left' must be either TRUE or FALSE"))
}
\arguments{
\item{data.left, data.right}{Data frames corresponding to the input data of
left and right sides, respectively. Each data frame has at least three
columns, the third one being the set of each point. See also
\code{\link[=read_datasets]{read_datasets()}}.}

\item{intervals}{(\code{integer(1)}|\code{character()}) \cr The absolute range of the
differences \eqn{[0, 1]} is partitioned into the number of intervals
provided. If an integer is provided, then labels for each interval are
computed automatically. If a character vector is provided, its length is
taken as the number of intervals.}

\item{maximise}{(\code{logical()} | \code{logical(1)}) \cr Whether the objectives must be
maximised instead of minimised. Either a single logical value that applies
to all objectives or a vector of logical values, with one value per
objective.}

\item{title.left, title.right}{Title for left and right panels, respectively.}

\item{...}{Other graphical parameters are passed down to
\code{\link[=eafdiffplot]{eafdiffplot()}}.}

\item{x}{(\code{matrix()}) Matrix of rectangles representing EAF differences
(returned by \code{\link[=eafdiff]{eafdiff()}} with \code{rectangles=TRUE}).}

\item{left}{(\code{logical(1)}) With \code{left=TRUE} return the rectangles with
positive differences, otherwise return those with negative differences but
differences are converted to positive.}
}
\value{
\code{matrix} where the first 4 columns give the coordinates of two
corners of each rectangle and the last column. In both cases, the last
column gives the positive differences in favor of the chosen side.
}
\description{
Creates the same plot as \code{\link[=eafdiffplot]{eafdiffplot()}} but waits for the user to click in
one of the sides. Then it returns the rectangles the give the differences in
favour of the chosen side. These rectangles may be used for interactive
decision-making as shown in \citet{DiaLop2020ejor}. The function
\code{\link[=choose_eafdiff]{choose_eafdiff()}} may be used in a non-interactive context.
}
\examples{

\donttest{
extdata_dir <- system.file(package="eaf", "extdata") 
A1 <- read_datasets(file.path(extdata_dir, "wrots_l100w10_dat"))
A2 <- read_datasets(file.path(extdata_dir, "wrots_l10w100_dat"))
if (interactive()) {
  rectangles <- choose_eafdiffplot(A1, A2, intervals = 5)
} else { # Choose A1
  rectangles <- eafdiff(A1, A2, intervals = 5, rectangles = TRUE)
  rectangles <- choose_eafdiff(rectangles, left = TRUE)
}
reference <- c(max(A1[, 1], A2[, 1]), max(A1[, 2], A2[, 2]))
x <- split.data.frame(A1[,1:2], A1[,3])
hv_A1 <- sapply(split.data.frame(A1[, 1:2], A1[, 3]),
                 hypervolume, reference=reference)
hv_A2 <- sapply(split.data.frame(A2[, 1:2], A2[, 3]),
                 hypervolume, reference=reference)
boxplot(list(A1=hv_A1, A2=hv_A2), main = "Hypervolume")

whv_A1 <- sapply(split.data.frame(A1[, 1:2], A1[, 3]),
                 whv_rect, rectangles=rectangles, reference=reference)
whv_A2 <- sapply(split.data.frame(A2[, 1:2], A2[, 3]),
                 whv_rect, rectangles=rectangles, reference=reference)
boxplot(list(A1=whv_A1, A2=whv_A2), main = "Weighted hypervolume")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=read_datasets]{read_datasets()}}, \code{\link[=eafdiffplot]{eafdiffplot()}}, \code{\link[=whv_rect]{whv_rect()}}
}
\concept{eaf}
\concept{eafviz}
