% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-list-fields.R
\docType{data}
\name{spec_sql_list_fields}
\alias{spec_sql_list_fields}
\title{spec_sql_list_fields}
\value{
\code{dbListFields()}
returns a character vector
that enumerates all fields
in the table in the correct order.
This also works for temporary tables if supported by the database.
The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
}
\description{
spec_sql_list_fields
}
\section{Failure modes}{

If the table does not exist, an error is raised.
Invalid types for the \code{name} argument
(e.g., \code{character} of length not equal to one,
or numeric)
lead to an error.
An error is also raised when calling this method for a closed
or invalid connection.
}

\section{Specification}{


The \code{name} argument can be
\itemize{
\item a string
\item the return value of \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}}
\item a value from the \code{table} column from the return value of
\code{\link[DBI:dbListObjects]{DBI::dbListObjects()}} where \code{is_prefix} is \code{FALSE}
}

A column named \code{row_names} is treated like any other column.
}

\seealso{
Other sql specifications: 
\code{\link{spec_sql_append_table}},
\code{\link{spec_sql_create_table}},
\code{\link{spec_sql_exists_table}},
\code{\link{spec_sql_list_objects}},
\code{\link{spec_sql_list_tables}},
\code{\link{spec_sql_quote_identifier}},
\code{\link{spec_sql_quote_literal}},
\code{\link{spec_sql_quote_string}},
\code{\link{spec_sql_read_table}},
\code{\link{spec_sql_remove_table}},
\code{\link{spec_sql_unquote_identifier}},
\code{\link{spec_sql_write_table}}
}
\concept{sql specifications}
