% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ihw_class.R
\docType{class}
\name{ihwResult-class}
\alias{ihwResult-class}
\alias{ihwResult}
\alias{adj_pvalues}
\alias{adj_pvalues,ihwResult-method}
\alias{weights,ihwResult-method}
\alias{thresholds}
\alias{thresholds,ihwResult-method}
\alias{pvalues}
\alias{pvalues,ihwResult-method}
\alias{weighted_pvalues}
\alias{weighted_pvalues,ihwResult-method}
\alias{covariates}
\alias{covariates,ihwResult-method}
\alias{covariate_type}
\alias{covariate_type,ihwResult-method}
\alias{groups_factor}
\alias{groups_factor,ihwResult-method}
\alias{nfolds}
\alias{nfolds,ihwResult-method}
\alias{nbins}
\alias{nbins,ihwResult-method}
\alias{alpha}
\alias{alpha,ihwResult-method}
\alias{rejections}
\alias{rejections,ihwResult-method}
\alias{rejected_hypotheses}
\alias{rejected_hypotheses,ihwResult-method}
\alias{regularization_term}
\alias{regularization_term,ihwResult-method}
\alias{m_groups}
\alias{m_groups,ihwResult-method}
\alias{as.data.frame_ihwResult}
\alias{as.data.frame,ihwResult-method}
\alias{nrow,ihwResult-method}
\alias{show,ihwResult-method}
\title{An S4 class to represent the ihw output.}
\usage{
adj_pvalues(object)

\S4method{adj_pvalues}{ihwResult}(object)

\S4method{weights}{ihwResult}(object, levels_only = FALSE)

thresholds(object, ...)

\S4method{thresholds}{ihwResult}(object, levels_only = FALSE)

pvalues(object)

\S4method{pvalues}{ihwResult}(object)

weighted_pvalues(object)

\S4method{weighted_pvalues}{ihwResult}(object)

covariates(object)

\S4method{covariates}{ihwResult}(object)

covariate_type(object)

\S4method{covariate_type}{ihwResult}(object)

groups_factor(object)

\S4method{groups_factor}{ihwResult}(object)

nfolds(object)

\S4method{nfolds}{ihwResult}(object)

nbins(object)

\S4method{nbins}{ihwResult}(object)

alpha(object)

\S4method{alpha}{ihwResult}(object)

rejections(object, ...)

\S4method{rejections}{ihwResult}(object)

rejected_hypotheses(object, ...)

\S4method{rejected_hypotheses}{ihwResult}(object)

regularization_term(object)

\S4method{regularization_term}{ihwResult}(object)

m_groups(object)

\S4method{m_groups}{ihwResult}(object)

as.data.frame_ihwResult(x, row.names = NULL, optional = FALSE, ...)

\S4method{as.data.frame}{ihwResult}(x, row.names = NULL, optional = FALSE,
  ...)

\S4method{nrow}{ihwResult}(x)

\S4method{show}{ihwResult}(object)
}
\arguments{
\item{object, x}{A ihwResult object as returned by a call to ihw(...)}

\item{levels_only}{Logical, if FALSE, return a vector of weights (thresholds) with one weight
(threshold) for each hypothesis, otherwise return a nfolds x nbins matrix of weights (thresholds)}

\item{...}{Parameters passed in to individual methods}

\item{row.names, optional}{See ?base::as.data.frame for a description of these arguments.}
}
\value{
The different methods applied to an ihwResult object can return the following:

1) A vector
    of length equal to the number of hypotheses tested (e.g. the adjusted p-value or the weight
    of each hypothesis).

2) A matrix of dimension equal to nfolds x nbins (e.g. the weight of
    each stratum, fold combination, set by specifying levels_only=TRUE).

3) A vector of length 1 (usually a parameter of the ihwResult object such as nfolds or
    the total number of rejections).

4) A data.frame (as.data.frame) or just console output (show) for the extended Base generics.

See section below for the individual methods.
}
\description{
An S4 class to represent the ihw output.
}
\section{Methods (by generic)}{
\itemize{
\item \code{adj_pvalues}: Extract adjusted pvalues

\item \code{weights}: Extract weights

\item \code{thresholds}: Calculate ihw thresholds

\item \code{pvalues}: Extract pvalues

\item \code{weighted_pvalues}: Extract weighted pvalues

\item \code{covariates}: Extract covariates

\item \code{covariate_type}: Extract type of covariate ("ordinal" or "nominal")

\item \code{groups_factor}: Extract factor of stratification (grouping) variable

\item \code{nfolds}: Extract number of folds

\item \code{nbins}: Extract number of bins

\item \code{alpha}: Extract nominal significance (alpha) level

\item \code{rejections}: Total number of rejected hypotheses by ihw procedure

\item \code{rejected_hypotheses}: Get a boolean vector of the rejected hypotheses

\item \code{regularization_term}: Extract vector of regularization parameters used for each stratum

\item \code{m_groups}: Extract total number of hypotheses within each stratum

\item \code{as.data.frame}: Coerce ihwResult to data frame

\item \code{nrow}: Return number of p-values

\item \code{show}: Convenience method to show ihwResult object
}}

\section{Slots}{

\describe{
\item{\code{df}}{A data.frame that collects the input data, including the vector of p values and the covariate, the group assignment, as well as outputs (weighted p-values, adjusted p-values)}

\item{\code{weights}}{A (nbins X nfolds) matrix of the weight assigned to each stratum}

\item{\code{alpha}}{Numeric, the nominal significance level at which the FDR is to be controlled}

\item{\code{nbins}}{Integer, number of distinct levels into which the hypotheses were stratified}

\item{\code{nfolds}}{Integer, number of folds for pre-validation procedure}

\item{\code{regularization_term}}{Numeric vector, the final value of the regularization parameter within each fold}

\item{\code{m_groups}}{Integer vector, number of hypotheses tested in each stratum}

\item{\code{penalty}}{Character, "uniform deviation" or "total variation"}

\item{\code{covariate_type}}{Character, "ordinal" or "nominal"}

\item{\code{adjustment_type}}{Character, "BH" or "bonferroni"}

\item{\code{reg_path_information}}{A data.frame, information about the whole regularization path. (Currently not used, thus empty)}

\item{\code{solver_information}}{A list, solver specific output, e.g. were all subproblems solved to optimality? (Currently empty list)}
}}

\examples{

save.seed <- .Random.seed; set.seed(1)
X   <- runif(n = 20000, min = 0.5, max = 4.5)       # Covariate
H   <- rbinom(n = length(X), size = 1, prob = 0.1)  # Is the null hypothesis (mean=0) true or false ?
Z   <- rnorm(n = length(X), mean = H * X)           # Z-score
.Random.seed <- save.seed

pvalue <- 1 - pnorm(Z)                              # pvalue
ihw_res <- ihw(pvalue, covariates = X, alpha = 0.1)
rejections(ihw_res)
colnames(as.data.frame(ihw_res))

}
\seealso{
ihw, plot,ihwResult-method
}
