% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refreshLatest.R
\name{refreshLatest}
\alias{refreshLatest}
\title{Refresh the latest version}
\usage{
refreshLatest(project, asset, url = restUrl(), token = accessToken())
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to a gypsum administrator account.}
}
\value{
String containing the latest version of the project, or \code{NULL} if there are no non-probational versions.
}
\description{
Recompute the latest version of a project's asset.
This is useful on rare occasions where multiple simultaneous uploads cause the latest version to be slightly out of sync.
}
\examples{
if (interactive()) {
    refreshLatest("test-R", "basic")
}

}
\seealso{
\code{\link{fetchLatest}}, to get the latest version without recomputing it.
}
\author{
Aaron Lun
}
