% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abortUpload.R
\name{abortUpload}
\alias{abortUpload}
\title{Abort an upload}
\usage{
abortUpload(init, url = restUrl())
}
\arguments{
\item{init}{List containing \code{abort_url} and \code{session_token}.
This is typically the return value from \code{\link{startUpload}}.}

\item{url}{String containing the URL of the gypsum REST API.}
}
\value{
\code{NULL} is invisibly returned on successful abort.
}
\description{
Abort an upload session, usually after an irrecoverable error.
}
\examples{
tmp <- tempfile()
dir.create(tmp)
write(file=file.path(tmp, "blah.txt"), LETTERS)
dir.create(file.path(tmp, "foo"))
write(file=file.path(tmp, "foo", "bar.txt"), 1:10)

if (interactive()) {
    init <- startUpload(
        project="test-R", 
        asset="upload-abort-check", 
        version="v1", 
        files=list.files(tmp, recursive=TRUE),
        probation=TRUE,
        directory=tmp
    )

    # Aborting the upload.
    abortUpload(init) 
}

}
\seealso{
\code{\link{startUpload}}, to create \code{init}.
}
\author{
Aaron Lun
}
