#!/usr/bin/env python
# Licensed under a 3-clause BSD style license - see LICENSE.rst

import os
import sys

import numpy
from setuptools import Extension, setup


def get_extensions():
    srcdir = os.path.join(os.path.dirname(__file__), 'src')
    cdriz_sources = ['cdrizzleapi.c',
                     'cdrizzleblot.c',
                     'cdrizzlebox.c',
                     'cdrizzlemap.c',
                     'cdrizzleutil.c',
                     os.path.join('tests', 'utest_cdrizzle.c')]
    sources = [os.path.join(srcdir, x) for x in cdriz_sources]

    cfg = {
        'include_dirs': [],
        'libraries': [],
        'define_macros': [],
    }
    cfg['include_dirs'].append(numpy.get_include())
    cfg['include_dirs'].append(srcdir)
    if sys.platform != 'win32':
        cfg['libraries'].append('m')
    if sys.platform == 'win32':
        cfg['define_macros'].append(('WIN32', None))
        cfg['define_macros'].append(('__STDC__', 1))
        cfg['define_macros'].append(('_CRT_SECURE_NO_WARNINGS', None))

    # importing these extension modules is tested in `.github/workflows/build.yml`;
    # when adding new modules here, make sure to add them to the `test_command` entry there
    return [Extension(str('drizzle.cdrizzle'), sources, **cfg)]


setup(
    ext_modules=get_extensions(),
)
