/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class ConnectedCircle
implements UDrawable {
    private final double radius;
    private final List<Double> angles = new ArrayList<Double>();
    private final List<Point2D> points = new ArrayList<Point2D>();

    public ConnectedCircle(double radius) {
        this.radius = radius;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(2.0 * this.radius, 2.0 * this.radius);
        for (Double angle : this.angles) {
            double delta = 30.0;
            UEllipse part = new UEllipse(2.0 * this.radius, 2.0 * this.radius, angle - 30.0, 60.0);
            ug.draw(part);
        }
        ug = ug.apply(HColorUtils.GREEN).apply(HColorUtils.GREEN.bg());
        for (Point2D pt : this.points) {
            UTranslate uTranslate = new UTranslate(pt);
        }
    }

    public void addSecondaryConnection(Point2D pt) {
        this.points.add(pt);
        double angle = Math.atan2(this.radius - pt.getY(), pt.getX() - this.radius);
        angle = angle * 180.0 / Math.PI;
        System.err.println("pt1=" + pt + " " + angle);
        this.angles.add(angle);
    }
}

