/***

  Olive - Non-Linear Video Editor
  Copyright (C) 2023 Olive Studios LLC

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

***/

#ifndef HISTORYWIDGET_H
#define HISTORYWIDGET_H

#include <QTreeView>

#include "undo/undostack.h"

namespace olive {

class HistoryWidget : public QTreeView
{
  Q_OBJECT
public:
  HistoryWidget(QWidget *parent = nullptr);

private:
  UndoStack *stack_;

  size_t current_row_;

private slots:
  void indexChanged(int i);

  void currentRowChanged(const QModelIndex &current, const QModelIndex &previous);

};

}

#endif // HISTORYWIDGET_H
