
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileHiLoAttributes.h
    \brief Definition of HiLo Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef HiLoAttributes_H
#define HiLoAttributes_H

#include "magics.h"
#include "HiLoTechnique.h"
#include "HiLoMarkerBase.h"
namespace magics {

class XmlNode;
class HiLoAttributes 
{
public:
//  --  constructor
    HiLoAttributes();
    
//  --  destructor
    virtual ~HiLoAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HiLoAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	int window_size_;
	double hilo_max_value_;
	double hilo_min_value_;
	double hi_max_value_;
	double hi_min_value_;
	double lo_max_value_;
	double lo_min_value_;
	unique_ptr<HiLoTechnique> type_;
	unique_ptr<HiLoMarkerBase> marker_;
	 

private:
	friend ostream& operator<<(ostream& s,const HiLoAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

