
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GribLoopAttributes.h
    \\brief Definition of GribLoop Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "GribLoopWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


GribLoopWrapper::GribLoopWrapper(): gribloop_(new GribLoop())

{

	
	
	
} 
GribLoopWrapper::GribLoopWrapper(GribLoop* gribloop): gribloop_(gribloop)
{
	
	
} 

GribLoopWrapper::~GribLoopWrapper()
{
	
}

void GribLoopWrapper::set(const MagRequest& request)
{
	
	

	intarray dimension_value;
	for (int i = 0; i < request.countValues("GRIB_DIMENSION"); i++)
		dimension_value.push_back((int)request("GRIB_DIMENSION", i));
	if ( !dimension_value.empty() ) 
		gribloop_->dimension_ = dimension_value;
	longintarray dim_1_value;
	for (int i = 0; i < request.countValues("GRIB_POSITION_1"); i++)
		dim_1_value.push_back((long int)request("GRIB_POSITION_1", i));
	if ( !dim_1_value.empty() ) 
		gribloop_->dim_1_ = dim_1_value;
	longintarray dim_2_value;
	for (int i = 0; i < request.countValues("GRIB_POSITION_2"); i++)
		dim_2_value.push_back((long int)request("GRIB_POSITION_2", i));
	if ( !dim_2_value.empty() ) 
		gribloop_->dim_2_ = dim_2_value;
	longintarray dim_colour_value;
	for (int i = 0; i < request.countValues("GRIB_POSITION_COLOUR"); i++)
		dim_colour_value.push_back((long int)request("GRIB_POSITION_COLOUR", i));
	if ( !dim_colour_value.empty() ) 
		gribloop_->dim_colour_ = dim_colour_value;
	longintarray dim_value;
	for (int i = 0; i < request.countValues("GRIB_POSITION"); i++)
		dim_value.push_back((long int)request("GRIB_POSITION", i));
	if ( !dim_value.empty() ) 
		gribloop_->dim_ = dim_value;
	if  (request.countValues("GRIB_LOOP_PATH") ) {
		string path_value = request("GRIB_LOOP_PATH");
		gribloop_->path_ = path_value;
		}
	if  (request.countValues("GRIB_AUTOMATIC_SCALING") ) {
		string scaling_value = request("GRIB_AUTOMATIC_SCALING");
		gribloop_->scaling_ = MagTranslator<string, bool>()(scaling_value);
		}
	if  (request.countValues("GRIB_AUTOMATIC_DERIVED_SCALING") ) {
		string derived_scaling_value = request("GRIB_AUTOMATIC_DERIVED_SCALING");
		gribloop_->derived_scaling_ = MagTranslator<string, bool>()(derived_scaling_value);
		}
	if  (request.countValues("GRIB_SCALING_FACTOR") ) {
		double scaling_factor_value = request("GRIB_SCALING_FACTOR");
		gribloop_->scaling_factor_ = scaling_factor_value;
		}
	if  (request.countValues("GRIB_SCALING_OFFSET") ) {
		double scaling_offset_value = request("GRIB_SCALING_OFFSET");
		gribloop_->scaling_offset_ = scaling_offset_value;
		}
	if  (request.countValues("GRIB_INTERPOLATION_REGULAR_RESOLUTION") ) {
		double regular_resolution_value = request("GRIB_INTERPOLATION_REGULAR_RESOLUTION");
		gribloop_->regular_resolution_ = regular_resolution_value;
		}
	if  (request.countValues("GRIB_INTERPOLATION_METHOD") ) {
		string interpolation_method_value = request("GRIB_INTERPOLATION_METHOD");
		gribloop_->interpolation_method_ = interpolation_method_value;
		}
	if  (request.countValues("GRIB_INTERPOLATION_METHOD_MISSING_FILL_COUNT") ) {
		int missing_fill_count_value = request("GRIB_INTERPOLATION_METHOD_MISSING_FILL_COUNT");
		gribloop_->missing_fill_count_ = missing_fill_count_value;
		}
	
	
		string address_mode_value = request.countValues("GRIB_FILE_ADDRESS_MODE") ?  (string) request("GRIB_FILE_ADDRESS_MODE") : "record";
	MagLog::debug() << " GRIB_FILE_ADDRESS_MODE set to " << address_mode_value << endl;
	GribAddressModeWrapper* address_mode_wrapper = 0;
	try
	{
		address_mode_wrapper = SimpleFactory<GribAddressModeWrapper>::create(address_mode_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << address_mode_value << "] is not a valid value for address_mode: reset to default -> [record]" << endl;
		address_mode_wrapper = SimpleFactory<GribAddressModeWrapper>::create("record");
	}
	address_mode_wrapper->set(request);
	gribloop_->address_mode_ =  unique_ptr<GribAddressMode>(address_mode_wrapper->object());
	delete address_mode_wrapper;
	
		string step_value = request.countValues("GRIB_LOOP_STEP") ?  (string) request("GRIB_LOOP_STEP") : "loopondate";
	MagLog::debug() << " GRIB_LOOP_STEP set to " << step_value << endl;
	GribLoopStepWrapper* step_wrapper = 0;
	try
	{
		step_wrapper = SimpleFactory<GribLoopStepWrapper>::create(step_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << step_value << "] is not a valid value for step: reset to default -> [loopondate]" << endl;
		step_wrapper = SimpleFactory<GribLoopStepWrapper>::create("loopondate");
	}
	step_wrapper->set(request);
	gribloop_->step_ =  unique_ptr<GribLoopStep>(step_wrapper->object());
	delete step_wrapper;
	
		string wind_mode_value = request.countValues("GRIB_WIND_MODE") ?  (string) request("GRIB_WIND_MODE") : "uv";
	MagLog::debug() << " GRIB_WIND_MODE set to " << wind_mode_value << endl;
	WindModeWrapper* wind_mode_wrapper = 0;
	try
	{
		wind_mode_wrapper = SimpleFactory<WindModeWrapper>::create(wind_mode_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << wind_mode_value << "] is not a valid value for wind_mode: reset to default -> [uv]" << endl;
		wind_mode_wrapper = SimpleFactory<WindModeWrapper>::create("uv");
	}
	wind_mode_wrapper->set(request);
	gribloop_->wind_mode_ =  unique_ptr<WindMode>(wind_mode_wrapper->object());
	delete wind_mode_wrapper;
	
}

void GribLoopWrapper::print(ostream& out)  const
{
	out << "GribLoopWrapper[]";
}


    



#include "GribAddressRecordModeWrapper.h"
static SimpleObjectMaker<GribAddressRecordMode, GribAddressMode> GribLoop_grib_file_address_mode_record ("record");
static SimpleObjectMaker<GribAddressRecordModeWrapper, GribAddressModeWrapper> GribLoop_grib_file_address_mode_record_wrapper ("record");


#include "GribAddressByteModeWrapper.h"
static SimpleObjectMaker<GribAddressByteMode, GribAddressMode> GribLoop_grib_file_address_mode_byte_offset ("byte_offset");
static SimpleObjectMaker<GribAddressByteModeWrapper, GribAddressModeWrapper> GribLoop_grib_file_address_mode_byte_offset_wrapper ("byte_offset");



#include "DateGribLoopStepWrapper.h"
static SimpleObjectMaker<DateGribLoopStep, GribLoopStep> GribLoop_grib_loop_step_loopondate ("loopondate");
static SimpleObjectMaker<DateGribLoopStepWrapper, GribLoopStepWrapper> GribLoop_grib_loop_step_loopondate_wrapper ("loopondate");


#include "ParamGribLoopStepWrapper.h"
static SimpleObjectMaker<ParamGribLoopStep, GribLoopStep> GribLoop_grib_loop_step_looponparam ("looponparam");
static SimpleObjectMaker<ParamGribLoopStepWrapper, GribLoopStepWrapper> GribLoop_grib_loop_step_looponparam_wrapper ("looponparam");



#include "UVWindModeWrapper.h"
static SimpleObjectMaker<UVWindMode, WindMode> GribLoop_grib_wind_mode_uvmode ("uvmode");
static SimpleObjectMaker<UVWindModeWrapper, WindModeWrapper> GribLoop_grib_wind_mode_uvmode_wrapper ("uvmode");


#include "UVWindModeWrapper.h"
static SimpleObjectMaker<UVWindMode, WindMode> GribLoop_grib_wind_mode_uv ("uv");
static SimpleObjectMaker<UVWindModeWrapper, WindModeWrapper> GribLoop_grib_wind_mode_uv_wrapper ("uv");


#include "SDWindModeWrapper.h"
static SimpleObjectMaker<SDWindMode, WindMode> GribLoop_grib_wind_mode_sdmode ("sdmode");
static SimpleObjectMaker<SDWindModeWrapper, WindModeWrapper> GribLoop_grib_wind_mode_sdmode_wrapper ("sdmode");


#include "SDWindModeWrapper.h"
static SimpleObjectMaker<SDWindMode, WindMode> GribLoop_grib_wind_mode_sd ("sd");
static SimpleObjectMaker<SDWindModeWrapper, WindModeWrapper> GribLoop_grib_wind_mode_sd_wrapper ("sd");



