/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2024 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_airy.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t26, t27, t33, t34, t35, t37, t38;
  double t39, t41, t42, t43, t44, t45, t46, t48;
  double t49, t51, t55, tzk0;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t26 = sqrt(sigma[0]);
  t27 = M_CBRT2;
  t33 = t21 / t23 * t26 * t27 / t18 / rho[0] / 0.12e2;
  t34 = pow(t33, params->a2);
  t35 = params->a1 * t34;
  t37 = params->a3 * t34 + 0.1e1;
  t38 = pow(t37, params->a4);
  t39 = 0.1e1 / t38;
  t41 = pow(t33, params->a6);
  t42 = params->a5 * t41;
  t43 = pow(t33, params->a8);
  t44 = params->a7 * t43;
  t45 = 0.1e1 - t42 + t44;
  t46 = pow(t33, params->a10);
  t48 = params->a9 * t46 + 0.1e1;
  t49 = 0.1e1 / t48;
  t51 = t35 * t39 + t45 * t49;
  t55 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t51);
  tzk0 = 0.2e1 * t55;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t26, t27, t33, t34, t35, t37, t38;
  double t39, t41, t42, t43, t44, t45, t46, t48;
  double t49, t51, t55, tzk0;

  double t56, t58, t62, t67, t68, t69, t70, t71;
  double t72, t82, t84, t85, t87, t88, t89, t92;
  double t97, tvrho0, t100, t114, t116, t119, t123, tvsigma0;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t26 = sqrt(sigma[0]);
  t27 = M_CBRT2;
  t33 = t21 / t23 * t26 * t27 / t18 / rho[0] / 0.12e2;
  t34 = pow(t33, params->a2);
  t35 = params->a1 * t34;
  t37 = params->a3 * t34 + 0.1e1;
  t38 = pow(t37, params->a4);
  t39 = 0.1e1 / t38;
  t41 = pow(t33, params->a6);
  t42 = params->a5 * t41;
  t43 = pow(t33, params->a8);
  t44 = params->a7 * t43;
  t45 = 0.1e1 - t42 + t44;
  t46 = pow(t33, params->a10);
  t48 = params->a9 * t46 + 0.1e1;
  t49 = 0.1e1 / t48;
  t51 = t35 * t39 + t45 * t49;
  t55 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t51);
  tzk0 = 0.2e1 * t55;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t56 = t18 * t18;
  t58 = t17 / t56;
  t62 = 0.1e1 / rho[0];
  t67 = t34 * t34;
  t68 = params->a1 * t67;
  t69 = t39 * params->a4;
  t70 = t68 * t69;
  t71 = params->a3 * params->a2;
  t72 = 0.1e1 / t37;
  t82 = 0.4e1 / 0.3e1 * t42 * params->a6 * t62 - 0.4e1 / 0.3e1 * t44 * params->a8 * t62;
  t84 = t48 * t48;
  t85 = 0.1e1 / t84;
  t87 = t45 * t85 * params->a9;
  t88 = t46 * params->a10;
  t89 = t88 * t62;
  t92 = -0.4e1 / 0.3e1 * t35 * params->a2 * t62 * t39 + 0.4e1 / 0.3e1 * t70 * t71 * t62 * t72 + t82 * t49 + 0.4e1 / 0.3e1 * t87 * t89;
  t97 = my_piecewise3(t2, 0, -t6 * t58 * t51 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t92);
  tvrho0 = 0.2e1 * rho[0] * t97 + 0.2e1 * t55;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t100 = 0.1e1 / sigma[0];
  t114 = -t42 * params->a6 * t100 / 0.2e1 + t44 * params->a8 * t100 / 0.2e1;
  t116 = t88 * t100;
  t119 = t35 * params->a2 * t100 * t39 / 0.2e1 - t70 * t71 * t100 * t72 / 0.2e1 + t114 * t49 - t87 * t116 / 0.2e1;
  t123 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t119);
  tvsigma0 = 0.2e1 * rho[0] * t123;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t26, t27, t33, t34, t35, t37, t38;
  double t39, t41, t42, t43, t44, t45, t46, t48;
  double t49, t51, t55, tzk0;

  double t56, t58, t62, t67, t68, t69, t70, t71;
  double t72, t82, t84, t85, t87, t88, t89, t92;
  double t97, tvrho0, t100, t114, t116, t119, t123, tvsigma0;

  double t128, t135, t136, t137, t138, t148, t152, t153;
  double t154, t155, t156, t157, t158, t159, t161, t168;
  double t171, t172, t178, t179, t185, t188, t192, t194;
  double t195, t196, t197, t198, t199, t202, t203, t206;
  double t209, t214, tv2rho20, t220, t221, t226, t229, t232;
  double t234, t239, t242, t246, t249, t254, t257, t260;
  double t265, tv2rhosigma0, t268, t269, t270, t278, t281, t282;
  double t303, t306, t309, t312, t315, t319, tv2sigma20;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t26 = sqrt(sigma[0]);
  t27 = M_CBRT2;
  t33 = t21 / t23 * t26 * t27 / t18 / rho[0] / 0.12e2;
  t34 = pow(t33, params->a2);
  t35 = params->a1 * t34;
  t37 = params->a3 * t34 + 0.1e1;
  t38 = pow(t37, params->a4);
  t39 = 0.1e1 / t38;
  t41 = pow(t33, params->a6);
  t42 = params->a5 * t41;
  t43 = pow(t33, params->a8);
  t44 = params->a7 * t43;
  t45 = 0.1e1 - t42 + t44;
  t46 = pow(t33, params->a10);
  t48 = params->a9 * t46 + 0.1e1;
  t49 = 0.1e1 / t48;
  t51 = t35 * t39 + t45 * t49;
  t55 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t51);
  tzk0 = 0.2e1 * t55;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t56 = t18 * t18;
  t58 = t17 / t56;
  t62 = 0.1e1 / rho[0];
  t67 = t34 * t34;
  t68 = params->a1 * t67;
  t69 = t39 * params->a4;
  t70 = t68 * t69;
  t71 = params->a3 * params->a2;
  t72 = 0.1e1 / t37;
  t82 = 0.4e1 / 0.3e1 * t42 * params->a6 * t62 - 0.4e1 / 0.3e1 * t44 * params->a8 * t62;
  t84 = t48 * t48;
  t85 = 0.1e1 / t84;
  t87 = t45 * t85 * params->a9;
  t88 = t46 * params->a10;
  t89 = t88 * t62;
  t92 = -0.4e1 / 0.3e1 * t35 * params->a2 * t62 * t39 + 0.4e1 / 0.3e1 * t70 * t71 * t62 * t72 + t82 * t49 + 0.4e1 / 0.3e1 * t87 * t89;
  t97 = my_piecewise3(t2, 0, -t6 * t58 * t51 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t92);
  tvrho0 = 0.2e1 * rho[0] * t97 + 0.2e1 * t55;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t100 = 0.1e1 / sigma[0];
  t114 = -t42 * params->a6 * t100 / 0.2e1 + t44 * params->a8 * t100 / 0.2e1;
  t116 = t88 * t100;
  t119 = t35 * params->a2 * t100 * t39 / 0.2e1 - t70 * t71 * t100 * t72 / 0.2e1 + t114 * t49 - t87 * t116 / 0.2e1;
  t123 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t119);
  tvsigma0 = 0.2e1 * rho[0] * t123;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t128 = t17 / t56 / rho[0];
  t135 = params->a2 * params->a2;
  t136 = rho[0] * rho[0];
  t137 = 0.1e1 / t136;
  t138 = t135 * t137;
  t148 = t69 * params->a3 * t72;
  t152 = params->a1 * t67 * t34;
  t153 = params->a4 * params->a4;
  t154 = t39 * t153;
  t155 = t152 * t154;
  t156 = params->a3 * params->a3;
  t157 = t156 * t135;
  t158 = t37 * t37;
  t159 = 0.1e1 / t158;
  t161 = t157 * t137 * t159;
  t168 = t152 * t69;
  t171 = params->a6 * params->a6;
  t172 = t171 * t137;
  t178 = params->a8 * params->a8;
  t179 = t178 * t137;
  t185 = -0.16e2 / 0.9e1 * t42 * t172 - 0.4e1 / 0.3e1 * t42 * params->a6 * t137 + 0.16e2 / 0.9e1 * t44 * t179 + 0.4e1 / 0.3e1 * t44 * params->a8 * t137;
  t188 = t82 * t85 * params->a9;
  t192 = 0.1e1 / t84 / t48;
  t194 = params->a9 * params->a9;
  t195 = t45 * t192 * t194;
  t196 = t46 * t46;
  t197 = params->a10 * params->a10;
  t198 = t196 * t197;
  t199 = t198 * t137;
  t202 = t46 * t197;
  t203 = t202 * t137;
  t206 = t88 * t137;
  t209 = 0.16e2 / 0.9e1 * t35 * t138 * t39 + 0.4e1 / 0.3e1 * t35 * params->a2 * t137 * t39 - 0.16e2 / 0.3e1 * t68 * t138 * t148 + 0.16e2 / 0.9e1 * t155 * t161 - 0.4e1 / 0.3e1 * t70 * t71 * t137 * t72 + 0.16e2 / 0.9e1 * t168 * t161 + t185 * t49 + 0.8e1 / 0.3e1 * t188 * t89 + 0.32e2 / 0.9e1 * t195 * t199 - 0.16e2 / 0.9e1 * t87 * t203 - 0.4e1 / 0.3e1 * t87 * t206;
  t214 = my_piecewise3(t2, 0, t6 * t128 * t51 / 0.12e2 - t6 * t58 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t209);
  tv2rho20 = 0.2e1 * rho[0] * t214 + 0.4e1 * t97;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t220 = t35 * t135;
  t221 = t62 * t100;
  t226 = t68 * t135 * t100;
  t229 = t69 * params->a3 * t62 * t72;
  t232 = t100 * t159;
  t234 = t157 * t232 * t62;
  t239 = t171 * t62;
  t242 = t178 * t62;
  t246 = 0.2e1 / 0.3e1 * t42 * t239 * t100 - 0.2e1 / 0.3e1 * t44 * t242 * t100;
  t249 = t114 * t85 * params->a9;
  t254 = t198 * t221;
  t257 = t202 * t221;
  t260 = -0.2e1 / 0.3e1 * t220 * t221 * t39 + 0.2e1 * t226 * t229 - 0.2e1 / 0.3e1 * t155 * t234 - 0.2e1 / 0.3e1 * t168 * t234 + t246 * t49 + 0.4e1 / 0.3e1 * t249 * t89 - t188 * t116 / 0.2e1 - 0.4e1 / 0.3e1 * t195 * t254 + 0.2e1 / 0.3e1 * t87 * t257;
  t265 = my_piecewise3(t2, 0, -t6 * t58 * t119 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t260);
  tv2rhosigma0 = 0.2e1 * rho[0] * t265 + 0.2e1 * t123;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t268 = sigma[0] * sigma[0];
  t269 = 0.1e1 / t268;
  t270 = t135 * t269;
  t278 = t68 * t270;
  t281 = t269 * t159;
  t282 = t157 * t281;
  t303 = -t42 * t171 * t269 / 0.4e1 + t42 * params->a6 * t269 / 0.2e1 + t44 * t178 * t269 / 0.4e1 - t44 * params->a8 * t269 / 0.2e1;
  t306 = t198 * t269;
  t309 = t202 * t269;
  t312 = t88 * t269;
  t315 = t35 * t270 * t39 / 0.4e1 - t35 * params->a2 * t269 * t39 / 0.2e1 - 0.3e1 / 0.4e1 * t278 * t148 + t155 * t282 / 0.4e1 + t70 * t71 * t269 * t72 / 0.2e1 + t168 * t282 / 0.4e1 + t303 * t49 - t249 * t116 + t195 * t306 / 0.2e1 - t87 * t309 / 0.4e1 + t87 * t312 / 0.2e1;
  t319 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t315);
  tv2sigma20 = 0.2e1 * rho[0] * t319;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t26, t27, t33, t34, t35, t37, t38;
  double t39, t41, t42, t43, t44, t45, t46, t48;
  double t49, t51, t55, tzk0;

  double t56, t58, t62, t67, t68, t69, t70, t71;
  double t72, t82, t84, t85, t87, t88, t89, t92;
  double t97, tvrho0, t100, t114, t116, t119, t123, tvsigma0;

  double t128, t135, t136, t137, t138, t148, t152, t153;
  double t154, t155, t156, t157, t158, t159, t161, t168;
  double t171, t172, t178, t179, t185, t188, t192, t194;
  double t195, t196, t197, t198, t199, t202, t203, t206;
  double t209, t214, tv2rho20, t220, t221, t226, t229, t232;
  double t234, t239, t242, t246, t249, t254, t257, t260;
  double t265, tv2rhosigma0, t268, t269, t270, t278, t281, t282;
  double t303, t306, t309, t312, t315, t319, tv2sigma20;

  double t324, t334, t335, t336, t337, t340, t346, t347;
  double t350, t356, t358, t359, t363, t372, t376, t381;
  double t382, t384, t385, t386, t387, t388, t389, t392;
  double t393, t396, t397, t401, t404, t405, t406, t407;
  double t408, t410, t412, t415, t422, t423, t424, t427;
  double t431, t432, t435, t446, t449, t452, t455, t456;
  double t461, tv3rho30, t471, t478, t485, t488, t495, t496;
  double t497, t501, t504, t507, t511, t518, t521, t522;
  double t524, t525, t528, t529, t531, t539, t540, t542;
  double t543, t546, t557, t560, t563, t566, t567, t572;
  double tv3rho2sigma0, t582, t583, t589, t595, t602, t609, t612;
  double t617, t619, t622, t626, t629, t630, t631, t634;
  double t644, t647, t650, t653, t656, t659, t660, t665;
  double tv3rhosigma20, t669, t670, t674, t677, t680, t683, t712;
  double t714, t715, t720, t721, t722, t727, t730, t733;
  double t745, t748, t751, t753, t754, t758, tv3sigma30;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t26 = sqrt(sigma[0]);
  t27 = M_CBRT2;
  t33 = t21 / t23 * t26 * t27 / t18 / rho[0] / 0.12e2;
  t34 = pow(t33, params->a2);
  t35 = params->a1 * t34;
  t37 = params->a3 * t34 + 0.1e1;
  t38 = pow(t37, params->a4);
  t39 = 0.1e1 / t38;
  t41 = pow(t33, params->a6);
  t42 = params->a5 * t41;
  t43 = pow(t33, params->a8);
  t44 = params->a7 * t43;
  t45 = 0.1e1 - t42 + t44;
  t46 = pow(t33, params->a10);
  t48 = params->a9 * t46 + 0.1e1;
  t49 = 0.1e1 / t48;
  t51 = t35 * t39 + t45 * t49;
  t55 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t51);
  tzk0 = 0.2e1 * t55;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t56 = t18 * t18;
  t58 = t17 / t56;
  t62 = 0.1e1 / rho[0];
  t67 = t34 * t34;
  t68 = params->a1 * t67;
  t69 = t39 * params->a4;
  t70 = t68 * t69;
  t71 = params->a3 * params->a2;
  t72 = 0.1e1 / t37;
  t82 = 0.4e1 / 0.3e1 * t42 * params->a6 * t62 - 0.4e1 / 0.3e1 * t44 * params->a8 * t62;
  t84 = t48 * t48;
  t85 = 0.1e1 / t84;
  t87 = t45 * t85 * params->a9;
  t88 = t46 * params->a10;
  t89 = t88 * t62;
  t92 = -0.4e1 / 0.3e1 * t35 * params->a2 * t62 * t39 + 0.4e1 / 0.3e1 * t70 * t71 * t62 * t72 + t82 * t49 + 0.4e1 / 0.3e1 * t87 * t89;
  t97 = my_piecewise3(t2, 0, -t6 * t58 * t51 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t92);
  tvrho0 = 0.2e1 * rho[0] * t97 + 0.2e1 * t55;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t100 = 0.1e1 / sigma[0];
  t114 = -t42 * params->a6 * t100 / 0.2e1 + t44 * params->a8 * t100 / 0.2e1;
  t116 = t88 * t100;
  t119 = t35 * params->a2 * t100 * t39 / 0.2e1 - t70 * t71 * t100 * t72 / 0.2e1 + t114 * t49 - t87 * t116 / 0.2e1;
  t123 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t119);
  tvsigma0 = 0.2e1 * rho[0] * t123;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t128 = t17 / t56 / rho[0];
  t135 = params->a2 * params->a2;
  t136 = rho[0] * rho[0];
  t137 = 0.1e1 / t136;
  t138 = t135 * t137;
  t148 = t69 * params->a3 * t72;
  t152 = params->a1 * t67 * t34;
  t153 = params->a4 * params->a4;
  t154 = t39 * t153;
  t155 = t152 * t154;
  t156 = params->a3 * params->a3;
  t157 = t156 * t135;
  t158 = t37 * t37;
  t159 = 0.1e1 / t158;
  t161 = t157 * t137 * t159;
  t168 = t152 * t69;
  t171 = params->a6 * params->a6;
  t172 = t171 * t137;
  t178 = params->a8 * params->a8;
  t179 = t178 * t137;
  t185 = -0.16e2 / 0.9e1 * t42 * t172 - 0.4e1 / 0.3e1 * t42 * params->a6 * t137 + 0.16e2 / 0.9e1 * t44 * t179 + 0.4e1 / 0.3e1 * t44 * params->a8 * t137;
  t188 = t82 * t85 * params->a9;
  t192 = 0.1e1 / t84 / t48;
  t194 = params->a9 * params->a9;
  t195 = t45 * t192 * t194;
  t196 = t46 * t46;
  t197 = params->a10 * params->a10;
  t198 = t196 * t197;
  t199 = t198 * t137;
  t202 = t46 * t197;
  t203 = t202 * t137;
  t206 = t88 * t137;
  t209 = 0.16e2 / 0.9e1 * t35 * t138 * t39 + 0.4e1 / 0.3e1 * t35 * params->a2 * t137 * t39 - 0.16e2 / 0.3e1 * t68 * t138 * t148 + 0.16e2 / 0.9e1 * t155 * t161 - 0.4e1 / 0.3e1 * t70 * t71 * t137 * t72 + 0.16e2 / 0.9e1 * t168 * t161 + t185 * t49 + 0.8e1 / 0.3e1 * t188 * t89 + 0.32e2 / 0.9e1 * t195 * t199 - 0.16e2 / 0.9e1 * t87 * t203 - 0.4e1 / 0.3e1 * t87 * t206;
  t214 = my_piecewise3(t2, 0, t6 * t128 * t51 / 0.12e2 - t6 * t58 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t209);
  tv2rho20 = 0.2e1 * rho[0] * t214 + 0.4e1 * t97;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t220 = t35 * t135;
  t221 = t62 * t100;
  t226 = t68 * t135 * t100;
  t229 = t69 * params->a3 * t62 * t72;
  t232 = t100 * t159;
  t234 = t157 * t232 * t62;
  t239 = t171 * t62;
  t242 = t178 * t62;
  t246 = 0.2e1 / 0.3e1 * t42 * t239 * t100 - 0.2e1 / 0.3e1 * t44 * t242 * t100;
  t249 = t114 * t85 * params->a9;
  t254 = t198 * t221;
  t257 = t202 * t221;
  t260 = -0.2e1 / 0.3e1 * t220 * t221 * t39 + 0.2e1 * t226 * t229 - 0.2e1 / 0.3e1 * t155 * t234 - 0.2e1 / 0.3e1 * t168 * t234 + t246 * t49 + 0.4e1 / 0.3e1 * t249 * t89 - t188 * t116 / 0.2e1 - 0.4e1 / 0.3e1 * t195 * t254 + 0.2e1 / 0.3e1 * t87 * t257;
  t265 = my_piecewise3(t2, 0, -t6 * t58 * t119 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t260);
  tv2rhosigma0 = 0.2e1 * rho[0] * t265 + 0.2e1 * t123;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t268 = sigma[0] * sigma[0];
  t269 = 0.1e1 / t268;
  t270 = t135 * t269;
  t278 = t68 * t270;
  t281 = t269 * t159;
  t282 = t157 * t281;
  t303 = -t42 * t171 * t269 / 0.4e1 + t42 * params->a6 * t269 / 0.2e1 + t44 * t178 * t269 / 0.4e1 - t44 * params->a8 * t269 / 0.2e1;
  t306 = t198 * t269;
  t309 = t202 * t269;
  t312 = t88 * t269;
  t315 = t35 * t270 * t39 / 0.4e1 - t35 * params->a2 * t269 * t39 / 0.2e1 - 0.3e1 / 0.4e1 * t278 * t148 + t155 * t282 / 0.4e1 + t70 * t71 * t269 * t72 / 0.2e1 + t168 * t282 / 0.4e1 + t303 * t49 - t249 * t116 + t195 * t306 / 0.2e1 - t87 * t309 / 0.4e1 + t87 * t312 / 0.2e1;
  t319 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t315);
  tv2sigma20 = 0.2e1 * rho[0] * t319;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t324 = t17 / t56 / t136;
  t334 = t171 * params->a6;
  t335 = t136 * rho[0];
  t336 = 0.1e1 / t335;
  t337 = t334 * t336;
  t340 = t171 * t336;
  t346 = t178 * params->a8;
  t347 = t346 * t336;
  t350 = t178 * t336;
  t356 = 0.64e2 / 0.27e2 * t42 * t337 + 0.16e2 / 0.3e1 * t42 * t340 + 0.8e1 / 0.3e1 * t42 * params->a6 * t336 - 0.64e2 / 0.27e2 * t44 * t347 - 0.16e2 / 0.3e1 * t44 * t350 - 0.8e1 / 0.3e1 * t44 * params->a8 * t336;
  t358 = t135 * params->a2;
  t359 = t358 * t336;
  t363 = t135 * t336;
  t372 = t185 * t85 * params->a9;
  t376 = t82 * t192 * t194;
  t381 = t84 * t84;
  t382 = 0.1e1 / t381;
  t384 = t194 * params->a9;
  t385 = t45 * t382 * t384;
  t386 = t196 * t46;
  t387 = t197 * params->a10;
  t388 = t386 * t387;
  t389 = t388 * t336;
  t392 = t196 * t387;
  t393 = t392 * t336;
  t396 = t46 * t387;
  t397 = t396 * t336;
  t401 = t157 * t336 * t159;
  t404 = t67 * t67;
  t405 = params->a1 * t404;
  t406 = t405 * t69;
  t407 = t156 * params->a3;
  t408 = t407 * t358;
  t410 = 0.1e1 / t158 / t37;
  t412 = t408 * t336 * t410;
  t415 = t356 * t49 - 0.64e2 / 0.27e2 * t35 * t359 * t39 - 0.16e2 / 0.3e1 * t35 * t363 * t39 - 0.8e1 / 0.3e1 * t35 * params->a2 * t336 * t39 + 0.4e1 * t372 * t89 + 0.32e2 / 0.3e1 * t376 * t199 - 0.16e2 / 0.3e1 * t188 * t203 + 0.128e3 / 0.9e1 * t385 * t389 - 0.128e3 / 0.9e1 * t195 * t393 + 0.64e2 / 0.27e2 * t87 * t397 - 0.16e2 / 0.3e1 * t168 * t401 + 0.128e3 / 0.27e2 * t406 * t412;
  t422 = t152 * t359;
  t423 = t156 * t159;
  t424 = t154 * t423;
  t427 = t69 * t423;
  t431 = t39 * t153 * params->a4;
  t432 = t405 * t431;
  t435 = t405 * t154;
  t446 = t198 * t336;
  t449 = t202 * t336;
  t452 = t88 * t336;
  t455 = 0.448e3 / 0.27e2 * t68 * t359 * t148 + 0.16e2 * t68 * t363 * t148 - 0.128e3 / 0.9e1 * t422 * t424 - 0.128e3 / 0.9e1 * t422 * t427 + 0.64e2 / 0.27e2 * t432 * t412 + 0.64e2 / 0.9e1 * t435 * t412 - 0.16e2 / 0.3e1 * t155 * t401 + 0.8e1 / 0.3e1 * t70 * t71 * t336 * t72 - 0.4e1 * t188 * t206 - 0.32e2 / 0.3e1 * t195 * t446 + 0.16e2 / 0.3e1 * t87 * t449 + 0.8e1 / 0.3e1 * t87 * t452;
  t456 = t415 + t455;
  t461 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t324 * t51 + t6 * t128 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t58 * t209 - 0.3e1 / 0.8e1 * t6 * t19 * t456);
  tv3rho30 = 0.2e1 * rho[0] * t461 + 0.6e1 * t214;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t471 = t334 * t137;
  t478 = t346 * t137;
  t485 = -0.8e1 / 0.9e1 * t42 * t471 * t100 - 0.2e1 / 0.3e1 * t42 * t172 * t100 + 0.8e1 / 0.9e1 * t44 * t478 * t100 + 0.2e1 / 0.3e1 * t44 * t179 * t100;
  t488 = t114 * t192 * t194;
  t495 = t35 * t358;
  t496 = t137 * t100;
  t497 = t496 * t39;
  t501 = t246 * t85 * params->a9;
  t504 = t198 * t496;
  t507 = t202 * t496;
  t511 = t157 * t232 * t137;
  t518 = t69 * params->a3 * t137 * t72;
  t521 = t358 * t100;
  t522 = t152 * t521;
  t524 = t156 * t137 * t159;
  t525 = t69 * t524;
  t528 = t485 * t49 + 0.32e2 / 0.9e1 * t488 * t199 - 0.16e2 / 0.9e1 * t249 * t203 - t372 * t116 / 0.2e1 + 0.8e1 / 0.9e1 * t495 * t497 + 0.8e1 / 0.3e1 * t501 * t89 + 0.4e1 / 0.3e1 * t195 * t504 - 0.2e1 / 0.3e1 * t87 * t507 + 0.2e1 / 0.3e1 * t155 * t511 + 0.2e1 / 0.3e1 * t168 * t511 - 0.2e1 * t226 * t518 + 0.16e2 / 0.3e1 * t522 * t525;
  t529 = t100 * t410;
  t531 = t408 * t529 * t137;
  t539 = t68 * t358 * t137;
  t540 = t100 * t39;
  t542 = params->a4 * params->a3 * t72;
  t543 = t540 * t542;
  t546 = t154 * t524;
  t557 = t388 * t496;
  t560 = t392 * t496;
  t563 = t396 * t496;
  t566 = -0.8e1 / 0.9e1 * t432 * t531 - 0.8e1 / 0.3e1 * t435 * t531 - 0.16e2 / 0.9e1 * t406 * t531 - 0.56e2 / 0.9e1 * t539 * t543 + 0.16e2 / 0.3e1 * t522 * t546 + 0.2e1 / 0.3e1 * t220 * t497 - 0.4e1 / 0.3e1 * t249 * t206 - 0.8e1 / 0.3e1 * t376 * t254 + 0.4e1 / 0.3e1 * t188 * t257 - 0.16e2 / 0.3e1 * t385 * t557 + 0.16e2 / 0.3e1 * t195 * t560 - 0.8e1 / 0.9e1 * t87 * t563;
  t567 = t528 + t566;
  t572 = my_piecewise3(t2, 0, t6 * t128 * t119 / 0.12e2 - t6 * t58 * t260 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t567);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t572 + 0.4e1 * t265;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t582 = t62 * t269;
  t583 = t582 * t39;
  t589 = t303 * t85 * params->a9;
  t595 = t334 * t62;
  t602 = t346 * t62;
  t609 = t42 * t595 * t269 / 0.3e1 - 0.2e1 / 0.3e1 * t42 * t239 * t269 - t44 * t602 * t269 / 0.3e1 + 0.2e1 / 0.3e1 * t44 * t242 * t269;
  t612 = t157 * t281 * t62;
  t617 = t269 * t410;
  t619 = t408 * t617 * t62;
  t622 = t358 * t269;
  t626 = -t188 * t309 / 0.4e1 + t188 * t312 / 0.2e1 - t495 * t583 / 0.3e1 + 0.2e1 / 0.3e1 * t220 * t583 + 0.4e1 / 0.3e1 * t589 * t89 - t501 * t116 + t376 * t306 / 0.2e1 + t609 * t49 + 0.2e1 / 0.3e1 * t155 * t612 + 0.2e1 / 0.3e1 * t168 * t612 + 0.2e1 / 0.3e1 * t406 * t619 + 0.7e1 / 0.3e1 * t68 * t622 * t229;
  t629 = t152 * t622;
  t630 = t423 * t62;
  t631 = t154 * t630;
  t634 = t69 * t630;
  t644 = t388 * t582;
  t647 = t392 * t582;
  t650 = t396 * t582;
  t653 = t198 * t582;
  t656 = t202 * t582;
  t659 = -0.2e1 * t278 * t229 - 0.2e1 * t629 * t631 - 0.2e1 * t629 * t634 + t432 * t619 / 0.3e1 + t435 * t619 - 0.8e1 / 0.3e1 * t488 * t254 + 0.4e1 / 0.3e1 * t249 * t257 + 0.2e1 * t385 * t644 - 0.2e1 * t195 * t647 + t87 * t650 / 0.3e1 + 0.4e1 / 0.3e1 * t195 * t653 - 0.2e1 / 0.3e1 * t87 * t656;
  t660 = t626 + t659;
  t665 = my_piecewise3(t2, 0, -t6 * t58 * t315 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t660);
  tv3rhosigma20 = 0.2e1 * rho[0] * t665 + 0.2e1 * t319;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t669 = 0.1e1 / t268 / sigma[0];
  t670 = t358 * t669;
  t674 = t388 * t669;
  t677 = t392 * t669;
  t680 = t396 * t669;
  t683 = t135 * t669;
  t712 = -t42 * t334 * t669 / 0.8e1 + 0.3e1 / 0.4e1 * t42 * t171 * t669 - t42 * params->a6 * t669 + t44 * t346 * t669 / 0.8e1 - 0.3e1 / 0.4e1 * t44 * t178 * t669 + t44 * params->a8 * t669;
  t714 = t669 * t410;
  t715 = t408 * t714;
  t720 = t35 * t670 * t39 / 0.8e1 - 0.3e1 / 0.4e1 * t385 * t674 + 0.3e1 / 0.4e1 * t195 * t677 - t87 * t680 / 0.8e1 - 0.3e1 / 0.4e1 * t35 * t683 * t39 + t35 * params->a2 * t669 * t39 - 0.3e1 / 0.2e1 * t589 * t116 + 0.3e1 / 0.2e1 * t488 * t306 - 0.3e1 / 0.4e1 * t249 * t309 + t712 * t49 - t432 * t715 / 0.8e1 - 0.3e1 / 0.8e1 * t435 * t715;
  t721 = t669 * t159;
  t722 = t157 * t721;
  t727 = t68 * t670;
  t730 = t68 * t683;
  t733 = t152 * t670;
  t745 = t198 * t669;
  t748 = t202 * t669;
  t751 = t88 * t669;
  t753 = -0.3e1 / 0.4e1 * t168 * t722 - t406 * t715 / 0.4e1 - 0.7e1 / 0.8e1 * t727 * t148 + 0.9e1 / 0.4e1 * t730 * t148 + 0.3e1 / 0.4e1 * t733 * t424 + 0.3e1 / 0.4e1 * t733 * t427 - 0.3e1 / 0.4e1 * t155 * t722 - t70 * t71 * t669 * t72 + 0.3e1 / 0.2e1 * t249 * t312 - 0.3e1 / 0.2e1 * t195 * t745 + 0.3e1 / 0.4e1 * t87 * t748 - t87 * t751;
  t754 = t720 + t753;
  t758 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t754);
  tv3sigma30 = 0.2e1 * rho[0] * t758;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t26, t27, t33, t34, t35, t37, t38;
  double t39, t41, t42, t43, t44, t45, t46, t48;
  double t49, t51, t55, tzk0;

  double t56, t58, t62, t67, t68, t69, t70, t71;
  double t72, t82, t84, t85, t87, t88, t89, t92;
  double t97, tvrho0, t100, t114, t116, t119, t123, tvsigma0;

  double t128, t135, t136, t137, t138, t148, t152, t153;
  double t154, t155, t156, t157, t158, t159, t161, t168;
  double t171, t172, t178, t179, t185, t188, t192, t194;
  double t195, t196, t197, t198, t199, t202, t203, t206;
  double t209, t214, tv2rho20, t220, t221, t226, t229, t232;
  double t234, t239, t242, t246, t249, t254, t257, t260;
  double t265, tv2rhosigma0, t268, t269, t270, t278, t281, t282;
  double t303, t306, t309, t312, t315, t319, tv2sigma20;

  double t324, t334, t335, t336, t337, t340, t346, t347;
  double t350, t356, t358, t359, t363, t372, t376, t381;
  double t382, t384, t385, t386, t387, t388, t389, t392;
  double t393, t396, t397, t401, t404, t405, t406, t407;
  double t408, t410, t412, t415, t422, t423, t424, t427;
  double t431, t432, t435, t446, t449, t452, t455, t456;
  double t461, tv3rho30, t471, t478, t485, t488, t495, t496;
  double t497, t501, t504, t507, t511, t518, t521, t522;
  double t524, t525, t528, t529, t531, t539, t540, t542;
  double t543, t546, t557, t560, t563, t566, t567, t572;
  double tv3rho2sigma0, t582, t583, t589, t595, t602, t609, t612;
  double t617, t619, t622, t626, t629, t630, t631, t634;
  double t644, t647, t650, t653, t656, t659, t660, t665;
  double tv3rhosigma20, t669, t670, t674, t677, t680, t683, t712;
  double t714, t715, t720, t721, t722, t727, t730, t733;
  double t745, t748, t751, t753, t754, t758, tv3sigma30;

  double t776, t777, t778, t782, t790, t791, t813, t823;
  double t829, t837, t838, t839, t840, t841, t845, t849;
  double t853, t857, t860, t865, t878, t902, t903, t910;
  double t911, t916, t917, t921, t926, t927, t929, t930;
  double t931, t932, t933, t935, t938, t941, t949, t953;
  double t956, t959, t967, t974, tv4rho40, t989, t990, t1004;
  double t1008, t1012, t1019, t1022, t1072, t1090, t1091, t1093;
  double t1097, t1103, t1110, t1114, t1115, t1116, t1119, t1128;
  double t1135, t1158, t1165, tv4rho3sigma0, t1197, t1198, t1206, t1210;
  double t1227, t1258, t1278, t1279, t1280, t1289, t1294, t1295;
  double t1298, t1299, t1302, t1316, t1324, t1331, t1336, t1343;
  double tv4rho2sigma20, t1350, t1351, t1363, t1394, t1426, t1441, t1442;
  double t1444, t1445, t1450, t1451, t1458, t1459, t1464, t1489;
  double t1496, tv4rhosigma30, t1499, t1500, t1501, t1509, t1513, t1534;
  double t1564, t1596, t1597, t1604, t1612, t1613, t1617, t1622;
  double t1630, t1652, t1658, tv4sigma40;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t26 = sqrt(sigma[0]);
  t27 = M_CBRT2;
  t33 = t21 / t23 * t26 * t27 / t18 / rho[0] / 0.12e2;
  t34 = pow(t33, params->a2);
  t35 = params->a1 * t34;
  t37 = params->a3 * t34 + 0.1e1;
  t38 = pow(t37, params->a4);
  t39 = 0.1e1 / t38;
  t41 = pow(t33, params->a6);
  t42 = params->a5 * t41;
  t43 = pow(t33, params->a8);
  t44 = params->a7 * t43;
  t45 = 0.1e1 - t42 + t44;
  t46 = pow(t33, params->a10);
  t48 = params->a9 * t46 + 0.1e1;
  t49 = 0.1e1 / t48;
  t51 = t35 * t39 + t45 * t49;
  t55 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t51);
  tzk0 = 0.2e1 * t55;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t56 = t18 * t18;
  t58 = t17 / t56;
  t62 = 0.1e1 / rho[0];
  t67 = t34 * t34;
  t68 = params->a1 * t67;
  t69 = t39 * params->a4;
  t70 = t68 * t69;
  t71 = params->a3 * params->a2;
  t72 = 0.1e1 / t37;
  t82 = 0.4e1 / 0.3e1 * t42 * params->a6 * t62 - 0.4e1 / 0.3e1 * t44 * params->a8 * t62;
  t84 = t48 * t48;
  t85 = 0.1e1 / t84;
  t87 = t45 * t85 * params->a9;
  t88 = t46 * params->a10;
  t89 = t88 * t62;
  t92 = -0.4e1 / 0.3e1 * t35 * params->a2 * t62 * t39 + 0.4e1 / 0.3e1 * t70 * t71 * t62 * t72 + t82 * t49 + 0.4e1 / 0.3e1 * t87 * t89;
  t97 = my_piecewise3(t2, 0, -t6 * t58 * t51 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t92);
  tvrho0 = 0.2e1 * rho[0] * t97 + 0.2e1 * t55;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t100 = 0.1e1 / sigma[0];
  t114 = -t42 * params->a6 * t100 / 0.2e1 + t44 * params->a8 * t100 / 0.2e1;
  t116 = t88 * t100;
  t119 = t35 * params->a2 * t100 * t39 / 0.2e1 - t70 * t71 * t100 * t72 / 0.2e1 + t114 * t49 - t87 * t116 / 0.2e1;
  t123 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t119);
  tvsigma0 = 0.2e1 * rho[0] * t123;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t128 = t17 / t56 / rho[0];
  t135 = params->a2 * params->a2;
  t136 = rho[0] * rho[0];
  t137 = 0.1e1 / t136;
  t138 = t135 * t137;
  t148 = t69 * params->a3 * t72;
  t152 = params->a1 * t67 * t34;
  t153 = params->a4 * params->a4;
  t154 = t39 * t153;
  t155 = t152 * t154;
  t156 = params->a3 * params->a3;
  t157 = t156 * t135;
  t158 = t37 * t37;
  t159 = 0.1e1 / t158;
  t161 = t157 * t137 * t159;
  t168 = t152 * t69;
  t171 = params->a6 * params->a6;
  t172 = t171 * t137;
  t178 = params->a8 * params->a8;
  t179 = t178 * t137;
  t185 = -0.16e2 / 0.9e1 * t42 * t172 - 0.4e1 / 0.3e1 * t42 * params->a6 * t137 + 0.16e2 / 0.9e1 * t44 * t179 + 0.4e1 / 0.3e1 * t44 * params->a8 * t137;
  t188 = t82 * t85 * params->a9;
  t192 = 0.1e1 / t84 / t48;
  t194 = params->a9 * params->a9;
  t195 = t45 * t192 * t194;
  t196 = t46 * t46;
  t197 = params->a10 * params->a10;
  t198 = t196 * t197;
  t199 = t198 * t137;
  t202 = t46 * t197;
  t203 = t202 * t137;
  t206 = t88 * t137;
  t209 = 0.16e2 / 0.9e1 * t35 * t138 * t39 + 0.4e1 / 0.3e1 * t35 * params->a2 * t137 * t39 - 0.16e2 / 0.3e1 * t68 * t138 * t148 + 0.16e2 / 0.9e1 * t155 * t161 - 0.4e1 / 0.3e1 * t70 * t71 * t137 * t72 + 0.16e2 / 0.9e1 * t168 * t161 + t185 * t49 + 0.8e1 / 0.3e1 * t188 * t89 + 0.32e2 / 0.9e1 * t195 * t199 - 0.16e2 / 0.9e1 * t87 * t203 - 0.4e1 / 0.3e1 * t87 * t206;
  t214 = my_piecewise3(t2, 0, t6 * t128 * t51 / 0.12e2 - t6 * t58 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t209);
  tv2rho20 = 0.2e1 * rho[0] * t214 + 0.4e1 * t97;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t220 = t35 * t135;
  t221 = t62 * t100;
  t226 = t68 * t135 * t100;
  t229 = t69 * params->a3 * t62 * t72;
  t232 = t100 * t159;
  t234 = t157 * t232 * t62;
  t239 = t171 * t62;
  t242 = t178 * t62;
  t246 = 0.2e1 / 0.3e1 * t42 * t239 * t100 - 0.2e1 / 0.3e1 * t44 * t242 * t100;
  t249 = t114 * t85 * params->a9;
  t254 = t198 * t221;
  t257 = t202 * t221;
  t260 = -0.2e1 / 0.3e1 * t220 * t221 * t39 + 0.2e1 * t226 * t229 - 0.2e1 / 0.3e1 * t155 * t234 - 0.2e1 / 0.3e1 * t168 * t234 + t246 * t49 + 0.4e1 / 0.3e1 * t249 * t89 - t188 * t116 / 0.2e1 - 0.4e1 / 0.3e1 * t195 * t254 + 0.2e1 / 0.3e1 * t87 * t257;
  t265 = my_piecewise3(t2, 0, -t6 * t58 * t119 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t260);
  tv2rhosigma0 = 0.2e1 * rho[0] * t265 + 0.2e1 * t123;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t268 = sigma[0] * sigma[0];
  t269 = 0.1e1 / t268;
  t270 = t135 * t269;
  t278 = t68 * t270;
  t281 = t269 * t159;
  t282 = t157 * t281;
  t303 = -t42 * t171 * t269 / 0.4e1 + t42 * params->a6 * t269 / 0.2e1 + t44 * t178 * t269 / 0.4e1 - t44 * params->a8 * t269 / 0.2e1;
  t306 = t198 * t269;
  t309 = t202 * t269;
  t312 = t88 * t269;
  t315 = t35 * t270 * t39 / 0.4e1 - t35 * params->a2 * t269 * t39 / 0.2e1 - 0.3e1 / 0.4e1 * t278 * t148 + t155 * t282 / 0.4e1 + t70 * t71 * t269 * t72 / 0.2e1 + t168 * t282 / 0.4e1 + t303 * t49 - t249 * t116 + t195 * t306 / 0.2e1 - t87 * t309 / 0.4e1 + t87 * t312 / 0.2e1;
  t319 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t315);
  tv2sigma20 = 0.2e1 * rho[0] * t319;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t324 = t17 / t56 / t136;
  t334 = t171 * params->a6;
  t335 = t136 * rho[0];
  t336 = 0.1e1 / t335;
  t337 = t334 * t336;
  t340 = t171 * t336;
  t346 = t178 * params->a8;
  t347 = t346 * t336;
  t350 = t178 * t336;
  t356 = 0.64e2 / 0.27e2 * t42 * t337 + 0.16e2 / 0.3e1 * t42 * t340 + 0.8e1 / 0.3e1 * t42 * params->a6 * t336 - 0.64e2 / 0.27e2 * t44 * t347 - 0.16e2 / 0.3e1 * t44 * t350 - 0.8e1 / 0.3e1 * t44 * params->a8 * t336;
  t358 = t135 * params->a2;
  t359 = t358 * t336;
  t363 = t135 * t336;
  t372 = t185 * t85 * params->a9;
  t376 = t82 * t192 * t194;
  t381 = t84 * t84;
  t382 = 0.1e1 / t381;
  t384 = t194 * params->a9;
  t385 = t45 * t382 * t384;
  t386 = t196 * t46;
  t387 = t197 * params->a10;
  t388 = t386 * t387;
  t389 = t388 * t336;
  t392 = t196 * t387;
  t393 = t392 * t336;
  t396 = t46 * t387;
  t397 = t396 * t336;
  t401 = t157 * t336 * t159;
  t404 = t67 * t67;
  t405 = params->a1 * t404;
  t406 = t405 * t69;
  t407 = t156 * params->a3;
  t408 = t407 * t358;
  t410 = 0.1e1 / t158 / t37;
  t412 = t408 * t336 * t410;
  t415 = t356 * t49 - 0.64e2 / 0.27e2 * t35 * t359 * t39 - 0.16e2 / 0.3e1 * t35 * t363 * t39 - 0.8e1 / 0.3e1 * t35 * params->a2 * t336 * t39 + 0.4e1 * t372 * t89 + 0.32e2 / 0.3e1 * t376 * t199 - 0.16e2 / 0.3e1 * t188 * t203 + 0.128e3 / 0.9e1 * t385 * t389 - 0.128e3 / 0.9e1 * t195 * t393 + 0.64e2 / 0.27e2 * t87 * t397 - 0.16e2 / 0.3e1 * t168 * t401 + 0.128e3 / 0.27e2 * t406 * t412;
  t422 = t152 * t359;
  t423 = t156 * t159;
  t424 = t154 * t423;
  t427 = t69 * t423;
  t431 = t39 * t153 * params->a4;
  t432 = t405 * t431;
  t435 = t405 * t154;
  t446 = t198 * t336;
  t449 = t202 * t336;
  t452 = t88 * t336;
  t455 = 0.448e3 / 0.27e2 * t68 * t359 * t148 + 0.16e2 * t68 * t363 * t148 - 0.128e3 / 0.9e1 * t422 * t424 - 0.128e3 / 0.9e1 * t422 * t427 + 0.64e2 / 0.27e2 * t432 * t412 + 0.64e2 / 0.9e1 * t435 * t412 - 0.16e2 / 0.3e1 * t155 * t401 + 0.8e1 / 0.3e1 * t70 * t71 * t336 * t72 - 0.4e1 * t188 * t206 - 0.32e2 / 0.3e1 * t195 * t446 + 0.16e2 / 0.3e1 * t87 * t449 + 0.8e1 / 0.3e1 * t87 * t452;
  t456 = t415 + t455;
  t461 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t324 * t51 + t6 * t128 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t58 * t209 - 0.3e1 / 0.8e1 * t6 * t19 * t456);
  tv3rho30 = 0.2e1 * rho[0] * t461 + 0.6e1 * t214;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t471 = t334 * t137;
  t478 = t346 * t137;
  t485 = -0.8e1 / 0.9e1 * t42 * t471 * t100 - 0.2e1 / 0.3e1 * t42 * t172 * t100 + 0.8e1 / 0.9e1 * t44 * t478 * t100 + 0.2e1 / 0.3e1 * t44 * t179 * t100;
  t488 = t114 * t192 * t194;
  t495 = t35 * t358;
  t496 = t137 * t100;
  t497 = t496 * t39;
  t501 = t246 * t85 * params->a9;
  t504 = t198 * t496;
  t507 = t202 * t496;
  t511 = t157 * t232 * t137;
  t518 = t69 * params->a3 * t137 * t72;
  t521 = t358 * t100;
  t522 = t152 * t521;
  t524 = t156 * t137 * t159;
  t525 = t69 * t524;
  t528 = t485 * t49 + 0.32e2 / 0.9e1 * t488 * t199 - 0.16e2 / 0.9e1 * t249 * t203 - t372 * t116 / 0.2e1 + 0.8e1 / 0.9e1 * t495 * t497 + 0.8e1 / 0.3e1 * t501 * t89 + 0.4e1 / 0.3e1 * t195 * t504 - 0.2e1 / 0.3e1 * t87 * t507 + 0.2e1 / 0.3e1 * t155 * t511 + 0.2e1 / 0.3e1 * t168 * t511 - 0.2e1 * t226 * t518 + 0.16e2 / 0.3e1 * t522 * t525;
  t529 = t100 * t410;
  t531 = t408 * t529 * t137;
  t539 = t68 * t358 * t137;
  t540 = t100 * t39;
  t542 = params->a4 * params->a3 * t72;
  t543 = t540 * t542;
  t546 = t154 * t524;
  t557 = t388 * t496;
  t560 = t392 * t496;
  t563 = t396 * t496;
  t566 = -0.8e1 / 0.9e1 * t432 * t531 - 0.8e1 / 0.3e1 * t435 * t531 - 0.16e2 / 0.9e1 * t406 * t531 - 0.56e2 / 0.9e1 * t539 * t543 + 0.16e2 / 0.3e1 * t522 * t546 + 0.2e1 / 0.3e1 * t220 * t497 - 0.4e1 / 0.3e1 * t249 * t206 - 0.8e1 / 0.3e1 * t376 * t254 + 0.4e1 / 0.3e1 * t188 * t257 - 0.16e2 / 0.3e1 * t385 * t557 + 0.16e2 / 0.3e1 * t195 * t560 - 0.8e1 / 0.9e1 * t87 * t563;
  t567 = t528 + t566;
  t572 = my_piecewise3(t2, 0, t6 * t128 * t119 / 0.12e2 - t6 * t58 * t260 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t567);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t572 + 0.4e1 * t265;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t582 = t62 * t269;
  t583 = t582 * t39;
  t589 = t303 * t85 * params->a9;
  t595 = t334 * t62;
  t602 = t346 * t62;
  t609 = t42 * t595 * t269 / 0.3e1 - 0.2e1 / 0.3e1 * t42 * t239 * t269 - t44 * t602 * t269 / 0.3e1 + 0.2e1 / 0.3e1 * t44 * t242 * t269;
  t612 = t157 * t281 * t62;
  t617 = t269 * t410;
  t619 = t408 * t617 * t62;
  t622 = t358 * t269;
  t626 = -t188 * t309 / 0.4e1 + t188 * t312 / 0.2e1 - t495 * t583 / 0.3e1 + 0.2e1 / 0.3e1 * t220 * t583 + 0.4e1 / 0.3e1 * t589 * t89 - t501 * t116 + t376 * t306 / 0.2e1 + t609 * t49 + 0.2e1 / 0.3e1 * t155 * t612 + 0.2e1 / 0.3e1 * t168 * t612 + 0.2e1 / 0.3e1 * t406 * t619 + 0.7e1 / 0.3e1 * t68 * t622 * t229;
  t629 = t152 * t622;
  t630 = t423 * t62;
  t631 = t154 * t630;
  t634 = t69 * t630;
  t644 = t388 * t582;
  t647 = t392 * t582;
  t650 = t396 * t582;
  t653 = t198 * t582;
  t656 = t202 * t582;
  t659 = -0.2e1 * t278 * t229 - 0.2e1 * t629 * t631 - 0.2e1 * t629 * t634 + t432 * t619 / 0.3e1 + t435 * t619 - 0.8e1 / 0.3e1 * t488 * t254 + 0.4e1 / 0.3e1 * t249 * t257 + 0.2e1 * t385 * t644 - 0.2e1 * t195 * t647 + t87 * t650 / 0.3e1 + 0.4e1 / 0.3e1 * t195 * t653 - 0.2e1 / 0.3e1 * t87 * t656;
  t660 = t626 + t659;
  t665 = my_piecewise3(t2, 0, -t6 * t58 * t315 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t660);
  tv3rhosigma20 = 0.2e1 * rho[0] * t665 + 0.2e1 * t319;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t669 = 0.1e1 / t268 / sigma[0];
  t670 = t358 * t669;
  t674 = t388 * t669;
  t677 = t392 * t669;
  t680 = t396 * t669;
  t683 = t135 * t669;
  t712 = -t42 * t334 * t669 / 0.8e1 + 0.3e1 / 0.4e1 * t42 * t171 * t669 - t42 * params->a6 * t669 + t44 * t346 * t669 / 0.8e1 - 0.3e1 / 0.4e1 * t44 * t178 * t669 + t44 * params->a8 * t669;
  t714 = t669 * t410;
  t715 = t408 * t714;
  t720 = t35 * t670 * t39 / 0.8e1 - 0.3e1 / 0.4e1 * t385 * t674 + 0.3e1 / 0.4e1 * t195 * t677 - t87 * t680 / 0.8e1 - 0.3e1 / 0.4e1 * t35 * t683 * t39 + t35 * params->a2 * t669 * t39 - 0.3e1 / 0.2e1 * t589 * t116 + 0.3e1 / 0.2e1 * t488 * t306 - 0.3e1 / 0.4e1 * t249 * t309 + t712 * t49 - t432 * t715 / 0.8e1 - 0.3e1 / 0.8e1 * t435 * t715;
  t721 = t669 * t159;
  t722 = t157 * t721;
  t727 = t68 * t670;
  t730 = t68 * t683;
  t733 = t152 * t670;
  t745 = t198 * t669;
  t748 = t202 * t669;
  t751 = t88 * t669;
  t753 = -0.3e1 / 0.4e1 * t168 * t722 - t406 * t715 / 0.4e1 - 0.7e1 / 0.8e1 * t727 * t148 + 0.9e1 / 0.4e1 * t730 * t148 + 0.3e1 / 0.4e1 * t733 * t424 + 0.3e1 / 0.4e1 * t733 * t427 - 0.3e1 / 0.4e1 * t155 * t722 - t70 * t71 * t669 * t72 + 0.3e1 / 0.2e1 * t249 * t312 - 0.3e1 / 0.2e1 * t195 * t745 + 0.3e1 / 0.4e1 * t87 * t748 - t87 * t751;
  t754 = t720 + t753;
  t758 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t754);
  tv3sigma30 = 0.2e1 * rho[0] * t758;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t776 = t136 * t136;
  t777 = 0.1e1 / t776;
  t778 = t358 * t777;
  t782 = t135 * t777;
  t790 = t135 * t135;
  t791 = t790 * t777;
  t813 = 0.128e3 / 0.9e1 * t35 * t778 * t39 + 0.176e3 / 0.9e1 * t35 * t782 * t39 + 0.8e1 * t35 * params->a2 * t777 * t39 + 0.256e3 / 0.81e2 * t35 * t791 * t39 - 0.176e3 / 0.9e1 * t87 * t202 * t777 - 0.8e1 * t87 * t88 * t777 - 0.8e1 * t372 * t206 - 0.128e3 / 0.3e1 * t376 * t446 + 0.64e2 / 0.3e1 * t188 * t449 - 0.256e3 / 0.3e1 * t385 * t388 * t777 + 0.256e3 / 0.3e1 * t195 * t392 * t777;
  t823 = t185 * t192 * t194;
  t829 = t82 * t382 * t384;
  t837 = t194 * t194;
  t838 = t45 / t381 / t48 * t837;
  t839 = t196 * t196;
  t840 = t197 * t197;
  t841 = t839 * t840;
  t845 = t386 * t840;
  t849 = t196 * t840;
  t853 = t46 * t840;
  t857 = -0.128e3 / 0.9e1 * t87 * t396 * t777 + 0.32e2 / 0.3e1 * t188 * t452 + 0.352e3 / 0.9e1 * t195 * t198 * t777 + 0.64e2 / 0.3e1 * t823 * t199 - 0.32e2 / 0.3e1 * t372 * t203 + 0.512e3 / 0.9e1 * t829 * t389 - 0.512e3 / 0.9e1 * t376 * t393 + 0.2048e4 / 0.27e2 * t838 * t841 * t777 - 0.1024e4 / 0.9e1 * t385 * t845 * t777 + 0.3584e4 / 0.81e2 * t195 * t849 * t777 - 0.256e3 / 0.81e2 * t87 * t853 * t777;
  t860 = t356 * t85 * params->a9;
  t865 = t171 * t171;
  t878 = t178 * t178;
  t902 = t777 * t159;
  t903 = t157 * t902;
  t910 = t777 * t410;
  t911 = t408 * t910;
  t916 = t405 * t791;
  t917 = t407 * t410;
  t921 = 0.16e2 / 0.3e1 * t860 * t89 + 0.256e3 / 0.27e2 * t188 * t397 + (-0.256e3 / 0.81e2 * t42 * t865 * t777 - 0.128e3 / 0.9e1 * t42 * t334 * t777 - 0.176e3 / 0.9e1 * t42 * t171 * t777 - 0.8e1 * t42 * params->a6 * t777 + 0.256e3 / 0.81e2 * t44 * t878 * t777 + 0.128e3 / 0.9e1 * t44 * t346 * t777 + 0.176e3 / 0.9e1 * t44 * t178 * t777 + 0.8e1 * t44 * params->a8 * t777) * t49 - 0.128e4 / 0.27e2 * t68 * t791 * t148 - 0.896e3 / 0.9e1 * t68 * t778 * t148 - 0.176e3 / 0.3e1 * t68 * t782 * t148 + 0.176e3 / 0.9e1 * t155 * t903 - 0.8e1 * t70 * t71 * t777 * t72 - 0.128e3 / 0.9e1 * t432 * t911 + 0.176e3 / 0.9e1 * t168 * t903 - 0.256e4 / 0.81e2 * t916 * t431 * t917;
  t926 = params->a1 * t404 * t34;
  t927 = t153 * t153;
  t929 = t926 * t39 * t927;
  t930 = t156 * t156;
  t931 = t930 * t790;
  t932 = t158 * t158;
  t933 = 0.1e1 / t932;
  t935 = t931 * t777 * t933;
  t938 = t926 * t431;
  t941 = t156 * t358;
  t949 = t407 * t790;
  t953 = t926 * t154;
  t956 = t926 * t69;
  t959 = t152 * t791;
  t967 = -0.256e4 / 0.27e2 * t916 * t154 * t917 + 0.256e3 / 0.81e2 * t929 * t935 + 0.512e3 / 0.27e2 * t938 * t935 + 0.256e3 / 0.3e1 * t168 * t941 * t902 - 0.128e3 / 0.3e1 * t435 * t911 - 0.256e3 / 0.9e1 * t406 * t911 - 0.512e4 / 0.81e2 * t406 * t949 * t910 + 0.2816e4 / 0.81e2 * t953 * t935 + 0.512e3 / 0.27e2 * t956 * t935 + 0.64e4 / 0.81e2 * t959 * t424 + 0.64e4 / 0.81e2 * t959 * t427 + 0.256e3 / 0.3e1 * t152 * t778 * t424;
  t974 = my_piecewise3(t2, 0, 0.1e2 / 0.27e2 * t6 * t17 / t56 / t335 * t51 - 0.5e1 / 0.9e1 * t6 * t324 * t92 + t6 * t128 * t209 / 0.2e1 - t6 * t58 * t456 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t813 + t857 + t921 + t967));
  tv4rho40 = 0.2e1 * rho[0] * t974 + 0.8e1 * t461;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t989 = t336 * t100;
  t990 = t989 * t39;
  t1004 = t485 * t85 * params->a9;
  t1008 = t246 * t192 * t194;
  t1012 = t114 * t382 * t384;
  t1019 = 0.8e1 / 0.3e1 * t249 * t452 - 0.8e1 / 0.3e1 * t495 * t990 - 0.4e1 * t501 * t206 - 0.4e1 / 0.3e1 * t220 * t990 - t860 * t116 / 0.2e1 - 0.32e2 / 0.3e1 * t488 * t446 + 0.16e2 / 0.3e1 * t249 * t449 + 0.4e1 * t1004 * t89 + 0.32e2 / 0.3e1 * t1008 * t199 + 0.128e3 / 0.9e1 * t1012 * t389 - 0.128e3 / 0.9e1 * t488 * t393 - 0.16e2 / 0.3e1 * t501 * t203;
  t1022 = t35 * t790;
  t1072 = 0.64e2 / 0.27e2 * t249 * t397 - 0.32e2 / 0.27e2 * t1022 * t990 + (0.32e2 / 0.27e2 * t42 * t865 * t336 * t100 + 0.8e1 / 0.3e1 * t42 * t337 * t100 + 0.4e1 / 0.3e1 * t42 * t340 * t100 - 0.32e2 / 0.27e2 * t44 * t878 * t336 * t100 - 0.8e1 / 0.3e1 * t44 * t347 * t100 - 0.4e1 / 0.3e1 * t44 * t350 * t100) * t49 + 0.4e1 * t376 * t504 + 0.16e2 * t385 * t388 * t989 - 0.16e2 * t195 * t392 * t989 - 0.2e1 * t188 * t507 + 0.8e1 / 0.3e1 * t87 * t396 * t989 - 0.16e2 * t829 * t557 + 0.16e2 * t376 * t560 - 0.8e1 / 0.3e1 * t188 * t563 - 0.256e3 / 0.9e1 * t838 * t841 * t989 + 0.128e3 / 0.3e1 * t385 * t845 * t989;
  t1090 = t790 * t100;
  t1091 = t405 * t1090;
  t1093 = t407 * t336 * t410;
  t1097 = t529 * t336;
  t1103 = t931 * t100 * t933 * t336;
  t1110 = t790 * t336;
  t1114 = -0.448e3 / 0.27e2 * t195 * t849 * t989 + 0.32e2 / 0.27e2 * t87 * t853 * t989 - 0.8e1 / 0.3e1 * t195 * t198 * t989 + 0.4e1 / 0.3e1 * t87 * t202 * t989 - 0.4e1 * t823 * t254 + 0.2e1 * t372 * t257 + 0.64e3 / 0.27e2 * t1091 * t69 * t1093 + 0.32e3 / 0.27e2 * t432 * t949 * t1097 - 0.32e2 / 0.27e2 * t929 * t1103 - 0.64e2 / 0.9e1 * t938 * t1103 - 0.352e3 / 0.27e2 * t953 * t1103 + 0.16e3 / 0.9e1 * t68 * t1110 * t543;
  t1115 = t232 * t336;
  t1116 = t941 * t1115;
  t1119 = t408 * t1097;
  t1128 = t157 * t1115;
  t1135 = t69 * params->a3 * t336 * t72;
  t1158 = -0.16e2 * t155 * t1116 + 0.8e1 / 0.3e1 * t432 * t1119 + 0.8e1 * t435 * t1119 - 0.16e2 * t168 * t1116 + 0.16e2 / 0.3e1 * t406 * t1119 - 0.4e1 / 0.3e1 * t155 * t1128 - 0.4e1 / 0.3e1 * t168 * t1128 + 0.4e1 * t226 * t1135 - 0.64e2 / 0.9e1 * t956 * t1103 - 0.8e3 / 0.27e2 * t152 * t1110 * t540 * t153 * t156 * t159 + 0.56e2 / 0.3e1 * t68 * t521 * t1135 - 0.8e3 / 0.27e2 * t152 * t1090 * t69 * t156 * t336 * t159 + 0.32e3 / 0.9e1 * t1091 * t154 * t1093;
  t1165 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t324 * t119 + t6 * t128 * t260 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t58 * t567 - 0.3e1 / 0.8e1 * t6 * t19 * (t1019 + t1072 + t1114 + t1158));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t1165 + 0.6e1 * t572;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t1197 = t137 * t269;
  t1198 = t1197 * t39;
  t1206 = t609 * t85 * params->a9;
  t1210 = t303 * t192 * t194;
  t1227 = (-0.4e1 / 0.9e1 * t42 * t865 * t137 * t269 + 0.5e1 / 0.9e1 * t42 * t471 * t269 + 0.2e1 / 0.3e1 * t42 * t172 * t269 + 0.4e1 / 0.9e1 * t44 * t878 * t137 * t269 - 0.5e1 / 0.9e1 * t44 * t478 * t269 - 0.2e1 / 0.3e1 * t44 * t179 * t269) * t49 - 0.5e1 / 0.9e1 * t495 * t1198 - 0.2e1 / 0.3e1 * t220 * t1198 - 0.4e1 / 0.3e1 * t589 * t206 + 0.8e1 / 0.3e1 * t1206 * t89 + 0.32e2 / 0.9e1 * t1210 * t199 - 0.16e2 / 0.9e1 * t589 * t203 - t1004 * t116 + t823 * t306 / 0.2e1 - t372 * t309 / 0.4e1 + t372 * t312 / 0.2e1 + 0.4e1 / 0.9e1 * t1022 * t1198 - 0.1e2 / 0.3e1 * t195 * t392 * t1197;
  t1258 = 0.5e1 / 0.9e1 * t87 * t396 * t1197 - 0.4e1 / 0.3e1 * t195 * t198 * t1197 + 0.2e1 / 0.3e1 * t87 * t202 * t1197 + 0.8e1 / 0.3e1 * t488 * t504 - 0.4e1 / 0.3e1 * t249 * t507 + 0.1e2 / 0.3e1 * t385 * t388 * t1197 - 0.4e1 * t376 * t647 + 0.2e1 / 0.3e1 * t188 * t650 + 0.8e1 / 0.3e1 * t376 * t653 - 0.4e1 / 0.3e1 * t188 * t656 - 0.16e2 / 0.3e1 * t1008 * t254 + 0.8e1 / 0.3e1 * t501 * t257 + 0.4e1 * t829 * t644;
  t1278 = t790 * t269;
  t1279 = t405 * t1278;
  t1280 = t917 * t137;
  t1289 = t931 * t269 * t933 * t137;
  t1294 = t281 * t137;
  t1295 = t941 * t1294;
  t1298 = t617 * t137;
  t1299 = t408 * t1298;
  t1302 = -0.32e2 / 0.3e1 * t1012 * t557 + 0.32e2 / 0.3e1 * t488 * t560 - 0.16e2 / 0.9e1 * t249 * t563 + 0.32e2 / 0.3e1 * t838 * t841 * t1197 - 0.16e2 * t385 * t845 * t1197 + 0.56e2 / 0.9e1 * t195 * t849 * t1197 - 0.4e1 / 0.9e1 * t87 * t853 * t1197 - 0.4e2 / 0.9e1 * t1279 * t431 * t1280 - 0.4e2 / 0.3e1 * t1279 * t154 * t1280 + 0.4e1 / 0.9e1 * t929 * t1289 + 0.8e1 / 0.3e1 * t938 * t1289 - 0.1e2 / 0.3e1 * t155 * t1295 + 0.5e1 / 0.9e1 * t432 * t1299;
  t1316 = t152 * t1278;
  t1324 = t269 * t39 * t542;
  t1331 = t157 * t1294;
  t1336 = 0.5e1 / 0.3e1 * t435 * t1299 - 0.1e2 / 0.3e1 * t168 * t1295 + 0.1e2 / 0.9e1 * t406 * t1299 - 0.8e2 / 0.9e1 * t406 * t949 * t1298 + 0.44e2 / 0.9e1 * t953 * t1289 + 0.8e1 / 0.3e1 * t956 * t1289 + 0.1e3 / 0.9e1 * t1316 * t546 + 0.1e3 / 0.9e1 * t1316 * t525 - 0.2e2 / 0.3e1 * t68 * t790 * t137 * t1324 + 0.35e2 / 0.9e1 * t539 * t1324 + 0.2e1 * t278 * t518 - 0.2e1 / 0.3e1 * t155 * t1331 - 0.2e1 / 0.3e1 * t168 * t1331;
  t1343 = my_piecewise3(t2, 0, t6 * t128 * t315 / 0.12e2 - t6 * t58 * t660 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t1227 + t1258 + t1302 + t1336));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t1343 + 0.4e1 * t665;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t1350 = t62 * t669;
  t1351 = t1350 * t39;
  t1363 = t712 * t85 * params->a9;
  t1394 = -t188 * t751 - t1022 * t1351 / 0.6e1 - 0.3e1 / 0.4e1 * t829 * t674 + 0.3e1 / 0.4e1 * t376 * t677 + 0.3e1 / 0.2e1 * t1008 * t306 - 0.3e1 / 0.4e1 * t501 * t309 + 0.4e1 / 0.3e1 * t1363 * t89 + 0.3e1 / 0.2e1 * t501 * t312 - 0.3e1 / 0.2e1 * t376 * t745 + 0.3e1 / 0.4e1 * t188 * t748 + (t42 * t865 * t62 * t669 / 0.6e1 - t42 * t595 * t669 + 0.4e1 / 0.3e1 * t42 * t239 * t669 - t44 * t878 * t62 * t669 / 0.6e1 + t44 * t602 * t669 - 0.4e1 / 0.3e1 * t44 * t242 * t669) * t49 - t188 * t680 / 0.8e1;
  t1426 = t495 * t1351 - 0.4e1 / 0.3e1 * t220 * t1351 - 0.3e1 / 0.2e1 * t1206 * t116 - 0.8e1 / 0.3e1 * t195 * t198 * t1350 + 0.4e1 / 0.3e1 * t87 * t202 * t1350 - 0.4e1 * t838 * t841 * t1350 + 0.6e1 * t385 * t845 * t1350 - 0.7e1 / 0.3e1 * t195 * t849 * t1350 + t87 * t853 * t1350 / 0.6e1 - 0.4e1 * t1210 * t254 + 0.2e1 * t589 * t257 + 0.6e1 * t1012 * t644 - 0.6e1 * t488 * t647;
  t1441 = t714 * t62;
  t1442 = t408 * t1441;
  t1444 = t721 * t62;
  t1445 = t157 * t1444;
  t1450 = t790 * t669;
  t1451 = t152 * t1450;
  t1458 = t249 * t650 + 0.4e1 * t488 * t653 - 0.2e1 * t249 * t656 - 0.6e1 * t385 * t388 * t1350 + 0.6e1 * t195 * t392 * t1350 - t87 * t396 * t1350 - t432 * t1442 - 0.4e1 / 0.3e1 * t155 * t1445 - 0.4e1 / 0.3e1 * t168 * t1445 - 0.25e2 / 0.6e1 * t1451 * t631 - 0.25e2 / 0.6e1 * t1451 * t634 + 0.6e1 * t733 * t631;
  t1459 = t949 * t1441;
  t1464 = t931 * t669 * t933 * t62;
  t1489 = 0.5e1 * t435 * t1459 - 0.11e2 / 0.6e1 * t953 * t1464 + 0.6e1 * t168 * t941 * t1444 - 0.3e1 * t435 * t1442 - 0.2e1 * t406 * t1442 + 0.1e2 / 0.3e1 * t406 * t1459 - t956 * t1464 + 0.5e1 / 0.2e1 * t68 * t1450 * t229 - 0.7e1 * t727 * t229 + 0.4e1 * t730 * t229 + 0.5e1 / 0.3e1 * t432 * t1459 - t929 * t1464 / 0.6e1 - t938 * t1464;
  t1496 = my_piecewise3(t2, 0, -t6 * t58 * t754 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t1394 + t1426 + t1458 + t1489));
  tv4rhosigma30 = 0.2e1 * rho[0] * t1496 + 0.2e1 * t758;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t1499 = t268 * t268;
  t1500 = 0.1e1 / t1499;
  t1501 = t135 * t1500;
  t1509 = t790 * t1500;
  t1513 = t358 * t1500;
  t1534 = 0.11e2 / 0.4e1 * t35 * t1501 * t39 - 0.3e1 * t35 * params->a2 * t1500 * t39 + t35 * t1509 * t39 / 0.16e2 - 0.3e1 / 0.4e1 * t35 * t1513 * t39 - 0.9e1 / 0.2e1 * t195 * t392 * t1500 + 0.3e1 / 0.4e1 * t87 * t396 * t1500 + 0.3e1 * t589 * t312 - 0.6e1 * t488 * t745 + 0.3e1 * t249 * t748 - 0.4e1 * t249 * t751 + 0.11e2 / 0.2e1 * t195 * t198 * t1500;
  t1564 = -0.11e2 / 0.4e1 * t87 * t202 * t1500 + 0.3e1 * t87 * t88 * t1500 + 0.9e1 / 0.2e1 * t385 * t388 * t1500 - t87 * t853 * t1500 / 0.16e2 - 0.2e1 * t1363 * t116 - 0.3e1 / 0.2e1 * t589 * t309 - 0.3e1 * t1012 * t674 + 0.3e1 / 0.2e1 * t838 * t841 * t1500 - 0.9e1 / 0.4e1 * t385 * t845 * t1500 + 0.3e1 * t488 * t677 + 0.7e1 / 0.8e1 * t195 * t849 * t1500;
  t1596 = t1500 * t159;
  t1597 = t157 * t1596;
  t1604 = t152 * t1509;
  t1612 = t1500 * t410;
  t1613 = t949 * t1612;
  t1617 = t931 * t1500 * t933;
  t1622 = -t249 * t680 / 0.2e1 + 0.3e1 * t1210 * t306 + (-t42 * t865 * t1500 / 0.16e2 + 0.3e1 / 0.4e1 * t42 * t334 * t1500 - 0.11e2 / 0.4e1 * t42 * t171 * t1500 + 0.3e1 * t42 * params->a6 * t1500 + t44 * t878 * t1500 / 0.16e2 - 0.3e1 / 0.4e1 * t44 * t346 * t1500 + 0.11e2 / 0.4e1 * t44 * t178 * t1500 - 0.3e1 * t44 * params->a8 * t1500) * t49 + 0.11e2 / 0.4e1 * t155 * t1597 + 0.3e1 * t70 * t71 * t1500 * t72 + 0.25e2 / 0.16e2 * t1604 * t424 + 0.25e2 / 0.16e2 * t1604 * t427 - 0.9e1 / 0.2e1 * t152 * t1513 * t424 - 0.5e1 / 0.8e1 * t432 * t1613 + t929 * t1617 / 0.16e2 + 0.3e1 / 0.8e1 * t938 * t1617;
  t1630 = t408 * t1612;
  t1652 = -0.15e2 / 0.8e1 * t435 * t1613 + 0.11e2 / 0.16e2 * t953 * t1617 - 0.9e1 / 0.2e1 * t168 * t941 * t1596 + 0.3e1 / 0.2e1 * t406 * t1630 - 0.5e1 / 0.4e1 * t406 * t1613 + 0.3e1 / 0.8e1 * t956 * t1617 + 0.3e1 / 0.4e1 * t432 * t1630 + 0.9e1 / 0.4e1 * t435 * t1630 + 0.11e2 / 0.4e1 * t168 * t1597 - 0.15e2 / 0.16e2 * t68 * t1509 * t148 + 0.21e2 / 0.4e1 * t68 * t1513 * t148 - 0.33e2 / 0.4e1 * t68 * t1501 * t148;
  t1658 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t1534 + t1564 + t1622 + t1652));
  tv4sigma40 = 0.2e1 * rho[0] * t1658;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t35, t40, t41, t42, t44, t45;
  double t46, t48, t49, t50, t51, t52, t53, t55;
  double t56, t58, t62, t63, t64, t66, t67, t68;
  double t69, t71, t72, t73, t74, t79, t80, t81;
  double t83, t84, t85, t87, t88, t89, t90, t91;
  double t92, t94, t95, t97, t101, tzk0;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t33 = t29 / t31;
  t34 = sqrt(sigma[0]);
  t35 = POW_1_3(rho[0]);
  t40 = t33 * t34 / t35 / rho[0] / 0.12e2;
  t41 = pow(t40, params->a2);
  t42 = params->a1 * t41;
  t44 = params->a3 * t41 + 0.1e1;
  t45 = pow(t44, params->a4);
  t46 = 0.1e1 / t45;
  t48 = pow(t40, params->a6);
  t49 = params->a5 * t48;
  t50 = pow(t40, params->a8);
  t51 = params->a7 * t50;
  t52 = 0.1e1 - t49 + t51;
  t53 = pow(t40, params->a10);
  t55 = params->a9 * t53 + 0.1e1;
  t56 = 0.1e1 / t55;
  t58 = t42 * t46 + t52 * t56;
  t62 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t58);
  t63 = rho[1] <= p->dens_threshold;
  t64 = -t16;
  t66 = my_piecewise5(t14, t11, t10, t15, t64 * t7);
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = POW_1_3(t67);
  t71 = my_piecewise3(t68, t22, t69 * t67);
  t72 = t71 * t26;
  t73 = sqrt(sigma[2]);
  t74 = POW_1_3(rho[1]);
  t79 = t33 * t73 / t74 / rho[1] / 0.12e2;
  t80 = pow(t79, params->a2);
  t81 = params->a1 * t80;
  t83 = params->a3 * t80 + 0.1e1;
  t84 = pow(t83, params->a4);
  t85 = 0.1e1 / t84;
  t87 = pow(t79, params->a6);
  t88 = params->a5 * t87;
  t89 = pow(t79, params->a8);
  t90 = params->a7 * t89;
  t91 = 0.1e1 - t88 + t90;
  t92 = pow(t79, params->a10);
  t94 = params->a9 * t92 + 0.1e1;
  t95 = 0.1e1 / t94;
  t97 = t81 * t85 + t91 * t95;
  t101 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t97);
  tzk0 = t62 + t101;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t35, t40, t41, t42, t44, t45;
  double t46, t48, t49, t50, t51, t52, t53, t55;
  double t56, t58, t62, t63, t64, t66, t67, t68;
  double t69, t71, t72, t73, t74, t79, t80, t81;
  double t83, t84, t85, t87, t88, t89, t90, t91;
  double t92, t94, t95, t97, t101, tzk0;

  double t102, t103, t104, t106, t109, t110, t114, t115;
  double t116, t119, t120, t125, t126, t127, t128, t129;
  double t130, t140, t142, t143, t145, t146, t147, t150;
  double t155, t156, t158, t161, t162, t166, t169, t171;
  double tvrho0, t175, t178, t179, t184, t186, t189, t190;
  double t194, t199, t200, t201, t202, t203, t213, t215;
  double t216, t218, t219, t220, t223, t228, tvrho1, t231;
  double t245, t247, t250, t254, tvsigma0, tvsigma1, t255, t269;
  double t271, t274, t278, tvsigma2;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t33 = t29 / t31;
  t34 = sqrt(sigma[0]);
  t35 = POW_1_3(rho[0]);
  t40 = t33 * t34 / t35 / rho[0] / 0.12e2;
  t41 = pow(t40, params->a2);
  t42 = params->a1 * t41;
  t44 = params->a3 * t41 + 0.1e1;
  t45 = pow(t44, params->a4);
  t46 = 0.1e1 / t45;
  t48 = pow(t40, params->a6);
  t49 = params->a5 * t48;
  t50 = pow(t40, params->a8);
  t51 = params->a7 * t50;
  t52 = 0.1e1 - t49 + t51;
  t53 = pow(t40, params->a10);
  t55 = params->a9 * t53 + 0.1e1;
  t56 = 0.1e1 / t55;
  t58 = t42 * t46 + t52 * t56;
  t62 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t58);
  t63 = rho[1] <= p->dens_threshold;
  t64 = -t16;
  t66 = my_piecewise5(t14, t11, t10, t15, t64 * t7);
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = POW_1_3(t67);
  t71 = my_piecewise3(t68, t22, t69 * t67);
  t72 = t71 * t26;
  t73 = sqrt(sigma[2]);
  t74 = POW_1_3(rho[1]);
  t79 = t33 * t73 / t74 / rho[1] / 0.12e2;
  t80 = pow(t79, params->a2);
  t81 = params->a1 * t80;
  t83 = params->a3 * t80 + 0.1e1;
  t84 = pow(t83, params->a4);
  t85 = 0.1e1 / t84;
  t87 = pow(t79, params->a6);
  t88 = params->a5 * t87;
  t89 = pow(t79, params->a8);
  t90 = params->a7 * t89;
  t91 = 0.1e1 - t88 + t90;
  t92 = pow(t79, params->a10);
  t94 = params->a9 * t92 + 0.1e1;
  t95 = 0.1e1 / t94;
  t97 = t81 * t85 + t91 * t95;
  t101 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t97);
  tzk0 = t62 + t101;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t102 = t6 * t6;
  t103 = 0.1e1 / t102;
  t104 = t16 * t103;
  t106 = my_piecewise5(t10, 0, t14, 0, t7 - t104);
  t109 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t106);
  t110 = t109 * t26;
  t114 = t26 * t26;
  t115 = 0.1e1 / t114;
  t116 = t25 * t115;
  t119 = t5 * t116 * t58 / 0.8e1;
  t120 = 0.1e1 / rho[0];
  t125 = t41 * t41;
  t126 = params->a1 * t125;
  t127 = t46 * params->a4;
  t128 = t126 * t127;
  t129 = params->a3 * params->a2;
  t130 = 0.1e1 / t44;
  t140 = 0.4e1 / 0.3e1 * t49 * params->a6 * t120 - 0.4e1 / 0.3e1 * t51 * params->a8 * t120;
  t142 = t55 * t55;
  t143 = 0.1e1 / t142;
  t145 = t52 * t143 * params->a9;
  t146 = t53 * params->a10;
  t147 = t146 * t120;
  t150 = -0.4e1 / 0.3e1 * t42 * params->a2 * t120 * t46 + 0.4e1 / 0.3e1 * t128 * t129 * t120 * t130 + t140 * t56 + 0.4e1 / 0.3e1 * t145 * t147;
  t155 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t58 - t119 - 0.3e1 / 0.8e1 * t5 * t27 * t150);
  t156 = t64 * t103;
  t158 = my_piecewise5(t14, 0, t10, 0, -t7 - t156);
  t161 = my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t158);
  t162 = t161 * t26;
  t166 = t71 * t115;
  t169 = t5 * t166 * t97 / 0.8e1;
  t171 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t97 - t169);
  tvrho0 = t62 + t101 + t6 * (t155 + t171);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t175 = my_piecewise5(t10, 0, t14, 0, -t7 - t104);
  t178 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t175);
  t179 = t178 * t26;
  t184 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t58 - t119);
  t186 = my_piecewise5(t14, 0, t10, 0, t7 - t156);
  t189 = my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t186);
  t190 = t189 * t26;
  t194 = 0.1e1 / rho[1];
  t199 = t80 * t80;
  t200 = params->a1 * t199;
  t201 = t85 * params->a4;
  t202 = t200 * t201;
  t203 = 0.1e1 / t83;
  t213 = 0.4e1 / 0.3e1 * t88 * params->a6 * t194 - 0.4e1 / 0.3e1 * t90 * params->a8 * t194;
  t215 = t94 * t94;
  t216 = 0.1e1 / t215;
  t218 = t91 * t216 * params->a9;
  t219 = t92 * params->a10;
  t220 = t219 * t194;
  t223 = -0.4e1 / 0.3e1 * t81 * params->a2 * t194 * t85 + 0.4e1 / 0.3e1 * t202 * t129 * t194 * t203 + t213 * t95 + 0.4e1 / 0.3e1 * t218 * t220;
  t228 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t97 - t169 - 0.3e1 / 0.8e1 * t5 * t72 * t223);
  tvrho1 = t62 + t101 + t6 * (t184 + t228);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t231 = 0.1e1 / sigma[0];
  t245 = -t49 * params->a6 * t231 / 0.2e1 + t51 * params->a8 * t231 / 0.2e1;
  t247 = t146 * t231;
  t250 = t42 * params->a2 * t231 * t46 / 0.2e1 - t128 * t129 * t231 * t130 / 0.2e1 + t245 * t56 - t145 * t247 / 0.2e1;
  t254 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t250);
  tvsigma0 = t6 * t254;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t255 = 0.1e1 / sigma[2];
  t269 = -t88 * params->a6 * t255 / 0.2e1 + t90 * params->a8 * t255 / 0.2e1;
  t271 = t219 * t255;
  t274 = t81 * params->a2 * t255 * t85 / 0.2e1 - t202 * t129 * t255 * t203 / 0.2e1 + t269 * t95 - t218 * t271 / 0.2e1;
  t278 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t274);
  tvsigma2 = t6 * t278;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t35, t40, t41, t42, t44, t45;
  double t46, t48, t49, t50, t51, t52, t53, t55;
  double t56, t58, t62, t63, t64, t66, t67, t68;
  double t69, t71, t72, t73, t74, t79, t80, t81;
  double t83, t84, t85, t87, t88, t89, t90, t91;
  double t92, t94, t95, t97, t101, tzk0;

  double t102, t103, t104, t106, t109, t110, t114, t115;
  double t116, t119, t120, t125, t126, t127, t128, t129;
  double t130, t140, t142, t143, t145, t146, t147, t150;
  double t155, t156, t158, t161, t162, t166, t169, t171;
  double tvrho0, t175, t178, t179, t184, t186, t189, t190;
  double t194, t199, t200, t201, t202, t203, t213, t215;
  double t216, t218, t219, t220, t223, t228, tvrho1, t231;
  double t245, t247, t250, t254, tvsigma0, tvsigma1, t255, t269;
  double t271, t274, t278, tvsigma2;

  double t281, t282, t283, t286, t287, t288, t291, t295;
  double t296, t300, t302, t308, t309, t312, t314, t316;
  double t317, t318, t319, t329, t333, t334, t335, t336;
  double t337, t338, t339, t340, t342, t349, t352, t353;
  double t359, t360, t366, t369, t373, t375, t376, t377;
  double t378, t379, t380, t383, t384, t387, t390, t395;
  double t396, t397, t398, t401, t404, t408, t409, t413;
  double t415, t417, t420, t422, tv2rho20, t425, t429, t433;
  double t434, t438, t440, t448, t449, t453, t457, t458;
  double t462, t464, t471, t474, tv2rho21, t479, t484, t488;
  double t489, t495, t496, t501, t505, t506, t515, t516;
  double t517, t527, t531, t532, t533, t534, t535, t537;
  double t544, t547, t553, t559, t562, t566, t568, t569;
  double t570, t571, t574, t575, t578, t581, t586, tv2rho22;
  double t594, t595, t596, t601, t604, t607, t609, t614;
  double t617, t621, t624, t629, t632, t635, t640, tv2rhosigma0;
  double tv2rhosigma1, t647, t649, tv2rhosigma2, t655, tv2rhosigma3, tv2rhosigma4, t660;
  double t661, t666, t669, t672, t674, t679, t682, t686;
  double t689, t694, t697, t700, t705, tv2rhosigma5, t707, t708;
  double t709, t717, t720, t721, t742, t745, t748, t751;
  double t754, t758, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t759;
  double t760, t761, t769, t772, t773, t794, t797, t800;
  double t803, t806, t810, tv2sigma25;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t33 = t29 / t31;
  t34 = sqrt(sigma[0]);
  t35 = POW_1_3(rho[0]);
  t40 = t33 * t34 / t35 / rho[0] / 0.12e2;
  t41 = pow(t40, params->a2);
  t42 = params->a1 * t41;
  t44 = params->a3 * t41 + 0.1e1;
  t45 = pow(t44, params->a4);
  t46 = 0.1e1 / t45;
  t48 = pow(t40, params->a6);
  t49 = params->a5 * t48;
  t50 = pow(t40, params->a8);
  t51 = params->a7 * t50;
  t52 = 0.1e1 - t49 + t51;
  t53 = pow(t40, params->a10);
  t55 = params->a9 * t53 + 0.1e1;
  t56 = 0.1e1 / t55;
  t58 = t42 * t46 + t52 * t56;
  t62 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t58);
  t63 = rho[1] <= p->dens_threshold;
  t64 = -t16;
  t66 = my_piecewise5(t14, t11, t10, t15, t64 * t7);
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = POW_1_3(t67);
  t71 = my_piecewise3(t68, t22, t69 * t67);
  t72 = t71 * t26;
  t73 = sqrt(sigma[2]);
  t74 = POW_1_3(rho[1]);
  t79 = t33 * t73 / t74 / rho[1] / 0.12e2;
  t80 = pow(t79, params->a2);
  t81 = params->a1 * t80;
  t83 = params->a3 * t80 + 0.1e1;
  t84 = pow(t83, params->a4);
  t85 = 0.1e1 / t84;
  t87 = pow(t79, params->a6);
  t88 = params->a5 * t87;
  t89 = pow(t79, params->a8);
  t90 = params->a7 * t89;
  t91 = 0.1e1 - t88 + t90;
  t92 = pow(t79, params->a10);
  t94 = params->a9 * t92 + 0.1e1;
  t95 = 0.1e1 / t94;
  t97 = t81 * t85 + t91 * t95;
  t101 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t97);
  tzk0 = t62 + t101;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t102 = t6 * t6;
  t103 = 0.1e1 / t102;
  t104 = t16 * t103;
  t106 = my_piecewise5(t10, 0, t14, 0, t7 - t104);
  t109 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t106);
  t110 = t109 * t26;
  t114 = t26 * t26;
  t115 = 0.1e1 / t114;
  t116 = t25 * t115;
  t119 = t5 * t116 * t58 / 0.8e1;
  t120 = 0.1e1 / rho[0];
  t125 = t41 * t41;
  t126 = params->a1 * t125;
  t127 = t46 * params->a4;
  t128 = t126 * t127;
  t129 = params->a3 * params->a2;
  t130 = 0.1e1 / t44;
  t140 = 0.4e1 / 0.3e1 * t49 * params->a6 * t120 - 0.4e1 / 0.3e1 * t51 * params->a8 * t120;
  t142 = t55 * t55;
  t143 = 0.1e1 / t142;
  t145 = t52 * t143 * params->a9;
  t146 = t53 * params->a10;
  t147 = t146 * t120;
  t150 = -0.4e1 / 0.3e1 * t42 * params->a2 * t120 * t46 + 0.4e1 / 0.3e1 * t128 * t129 * t120 * t130 + t140 * t56 + 0.4e1 / 0.3e1 * t145 * t147;
  t155 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t58 - t119 - 0.3e1 / 0.8e1 * t5 * t27 * t150);
  t156 = t64 * t103;
  t158 = my_piecewise5(t14, 0, t10, 0, -t7 - t156);
  t161 = my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t158);
  t162 = t161 * t26;
  t166 = t71 * t115;
  t169 = t5 * t166 * t97 / 0.8e1;
  t171 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t97 - t169);
  tvrho0 = t62 + t101 + t6 * (t155 + t171);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t175 = my_piecewise5(t10, 0, t14, 0, -t7 - t104);
  t178 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t175);
  t179 = t178 * t26;
  t184 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t58 - t119);
  t186 = my_piecewise5(t14, 0, t10, 0, t7 - t156);
  t189 = my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t186);
  t190 = t189 * t26;
  t194 = 0.1e1 / rho[1];
  t199 = t80 * t80;
  t200 = params->a1 * t199;
  t201 = t85 * params->a4;
  t202 = t200 * t201;
  t203 = 0.1e1 / t83;
  t213 = 0.4e1 / 0.3e1 * t88 * params->a6 * t194 - 0.4e1 / 0.3e1 * t90 * params->a8 * t194;
  t215 = t94 * t94;
  t216 = 0.1e1 / t215;
  t218 = t91 * t216 * params->a9;
  t219 = t92 * params->a10;
  t220 = t219 * t194;
  t223 = -0.4e1 / 0.3e1 * t81 * params->a2 * t194 * t85 + 0.4e1 / 0.3e1 * t202 * t129 * t194 * t203 + t213 * t95 + 0.4e1 / 0.3e1 * t218 * t220;
  t228 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t97 - t169 - 0.3e1 / 0.8e1 * t5 * t72 * t223);
  tvrho1 = t62 + t101 + t6 * (t184 + t228);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t231 = 0.1e1 / sigma[0];
  t245 = -t49 * params->a6 * t231 / 0.2e1 + t51 * params->a8 * t231 / 0.2e1;
  t247 = t146 * t231;
  t250 = t42 * params->a2 * t231 * t46 / 0.2e1 - t128 * t129 * t231 * t130 / 0.2e1 + t245 * t56 - t145 * t247 / 0.2e1;
  t254 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t250);
  tvsigma0 = t6 * t254;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t255 = 0.1e1 / sigma[2];
  t269 = -t88 * params->a6 * t255 / 0.2e1 + t90 * params->a8 * t255 / 0.2e1;
  t271 = t219 * t255;
  t274 = t81 * params->a2 * t255 * t85 / 0.2e1 - t202 * t129 * t255 * t203 / 0.2e1 + t269 * t95 - t218 * t271 / 0.2e1;
  t278 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t274);
  tvsigma2 = t6 * t278;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t281 = t23 * t23;
  t282 = 0.1e1 / t281;
  t283 = t106 * t106;
  t286 = t102 * t6;
  t287 = 0.1e1 / t286;
  t288 = t16 * t287;
  t291 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t103 + 0.2e1 * t288);
  t295 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t282 * t283 + 0.4e1 / 0.3e1 * t23 * t291);
  t296 = t295 * t26;
  t300 = t109 * t115;
  t302 = t5 * t300 * t58;
  t308 = 0.1e1 / t114 / t6;
  t309 = t25 * t308;
  t312 = t5 * t309 * t58 / 0.12e2;
  t314 = t5 * t116 * t150;
  t316 = params->a2 * params->a2;
  t317 = rho[0] * rho[0];
  t318 = 0.1e1 / t317;
  t319 = t316 * t318;
  t329 = t127 * params->a3 * t130;
  t333 = params->a1 * t125 * t41;
  t334 = params->a4 * params->a4;
  t335 = t46 * t334;
  t336 = t333 * t335;
  t337 = params->a3 * params->a3;
  t338 = t337 * t316;
  t339 = t44 * t44;
  t340 = 0.1e1 / t339;
  t342 = t338 * t318 * t340;
  t349 = t333 * t127;
  t352 = params->a6 * params->a6;
  t353 = t352 * t318;
  t359 = params->a8 * params->a8;
  t360 = t359 * t318;
  t366 = -0.16e2 / 0.9e1 * t49 * t353 - 0.4e1 / 0.3e1 * t49 * params->a6 * t318 + 0.16e2 / 0.9e1 * t51 * t360 + 0.4e1 / 0.3e1 * t51 * params->a8 * t318;
  t369 = t140 * t143 * params->a9;
  t373 = 0.1e1 / t142 / t55;
  t375 = params->a9 * params->a9;
  t376 = t52 * t373 * t375;
  t377 = t53 * t53;
  t378 = params->a10 * params->a10;
  t379 = t377 * t378;
  t380 = t379 * t318;
  t383 = t53 * t378;
  t384 = t383 * t318;
  t387 = t146 * t318;
  t390 = 0.16e2 / 0.9e1 * t42 * t319 * t46 + 0.4e1 / 0.3e1 * t42 * params->a2 * t318 * t46 - 0.16e2 / 0.3e1 * t126 * t319 * t329 + 0.16e2 / 0.9e1 * t336 * t342 - 0.4e1 / 0.3e1 * t128 * t129 * t318 * t130 + 0.16e2 / 0.9e1 * t349 * t342 + t366 * t56 + 0.8e1 / 0.3e1 * t369 * t147 + 0.32e2 / 0.9e1 * t376 * t380 - 0.16e2 / 0.9e1 * t145 * t384 - 0.4e1 / 0.3e1 * t145 * t387;
  t395 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t296 * t58 - t302 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t110 * t150 + t312 - t314 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t390);
  t396 = t69 * t69;
  t397 = 0.1e1 / t396;
  t398 = t158 * t158;
  t401 = t64 * t287;
  t404 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t103 + 0.2e1 * t401);
  t408 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t397 * t398 + 0.4e1 / 0.3e1 * t69 * t404);
  t409 = t408 * t26;
  t413 = t161 * t115;
  t415 = t5 * t413 * t97;
  t417 = t71 * t308;
  t420 = t5 * t417 * t97 / 0.12e2;
  t422 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t409 * t97 - t415 / 0.4e1 + t420);
  tv2rho20 = 0.2e1 * t155 + 0.2e1 * t171 + t6 * (t395 + t422);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t425 = t282 * t175;
  t429 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t288);
  t433 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t425 * t106 + 0.4e1 / 0.3e1 * t23 * t429);
  t434 = t433 * t26;
  t438 = t178 * t115;
  t440 = t5 * t438 * t58;
  t448 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t434 * t58 - t440 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t179 * t150 - t302 / 0.8e1 + t312 - t314 / 0.8e1);
  t449 = t397 * t186;
  t453 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t401);
  t457 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t449 * t158 + 0.4e1 / 0.3e1 * t69 * t453);
  t458 = t457 * t26;
  t462 = t189 * t115;
  t464 = t5 * t462 * t97;
  t471 = t5 * t166 * t223;
  t474 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t458 * t97 - t464 / 0.8e1 - t415 / 0.8e1 + t420 - 0.3e1 / 0.8e1 * t5 * t162 * t223 - t471 / 0.8e1);
  tv2rho21 = t155 + t171 + t184 + t228 + t6 * (t448 + t474);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t479 = t175 * t175;
  t484 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t103 + 0.2e1 * t288);
  t488 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t282 * t479 + 0.4e1 / 0.3e1 * t23 * t484);
  t489 = t488 * t26;
  t495 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t489 * t58 - t440 / 0.4e1 + t312);
  t496 = t186 * t186;
  t501 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t103 + 0.2e1 * t401);
  t505 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t397 * t496 + 0.4e1 / 0.3e1 * t69 * t501);
  t506 = t505 * t26;
  t515 = rho[1] * rho[1];
  t516 = 0.1e1 / t515;
  t517 = t316 * t516;
  t527 = t201 * params->a3 * t203;
  t531 = params->a1 * t199 * t80;
  t532 = t85 * t334;
  t533 = t531 * t532;
  t534 = t83 * t83;
  t535 = 0.1e1 / t534;
  t537 = t338 * t516 * t535;
  t544 = t531 * t201;
  t547 = t352 * t516;
  t553 = t359 * t516;
  t559 = -0.16e2 / 0.9e1 * t88 * t547 - 0.4e1 / 0.3e1 * t88 * params->a6 * t516 + 0.16e2 / 0.9e1 * t90 * t553 + 0.4e1 / 0.3e1 * t90 * params->a8 * t516;
  t562 = t213 * t216 * params->a9;
  t566 = 0.1e1 / t215 / t94;
  t568 = t91 * t566 * t375;
  t569 = t92 * t92;
  t570 = t569 * t378;
  t571 = t570 * t516;
  t574 = t92 * t378;
  t575 = t574 * t516;
  t578 = t219 * t516;
  t581 = 0.16e2 / 0.9e1 * t81 * t517 * t85 + 0.4e1 / 0.3e1 * t81 * params->a2 * t516 * t85 - 0.16e2 / 0.3e1 * t200 * t517 * t527 + 0.16e2 / 0.9e1 * t533 * t537 - 0.4e1 / 0.3e1 * t202 * t129 * t516 * t203 + 0.16e2 / 0.9e1 * t544 * t537 + t559 * t95 + 0.8e1 / 0.3e1 * t562 * t220 + 0.32e2 / 0.9e1 * t568 * t571 - 0.16e2 / 0.9e1 * t218 * t575 - 0.4e1 / 0.3e1 * t218 * t578;
  t586 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t506 * t97 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t190 * t223 + t420 - t471 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t72 * t581);
  tv2rho22 = 0.2e1 * t184 + 0.2e1 * t228 + t6 * (t495 + t586);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t594 = t5 * t116 * t250 / 0.8e1;
  t595 = t42 * t316;
  t596 = t120 * t231;
  t601 = t126 * t316 * t231;
  t604 = t127 * params->a3 * t120 * t130;
  t607 = t231 * t340;
  t609 = t338 * t607 * t120;
  t614 = t352 * t120;
  t617 = t359 * t120;
  t621 = 0.2e1 / 0.3e1 * t49 * t614 * t231 - 0.2e1 / 0.3e1 * t51 * t617 * t231;
  t624 = t245 * t143 * params->a9;
  t629 = t379 * t596;
  t632 = t383 * t596;
  t635 = -0.2e1 / 0.3e1 * t595 * t596 * t46 + 0.2e1 * t601 * t604 - 0.2e1 / 0.3e1 * t336 * t609 - 0.2e1 / 0.3e1 * t349 * t609 + t621 * t56 + 0.4e1 / 0.3e1 * t624 * t147 - t369 * t247 / 0.2e1 - 0.4e1 / 0.3e1 * t376 * t629 + 0.2e1 / 0.3e1 * t145 * t632;
  t640 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t250 - t594 - 0.3e1 / 0.8e1 * t5 * t27 * t635);
  tv2rhosigma0 = t6 * t640 + t254;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t647 = t5 * t166 * t274 / 0.8e1;
  t649 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t274 - t647);
  tv2rhosigma2 = t6 * t649 + t278;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t655 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t250 - t594);
  tv2rhosigma3 = t6 * t655 + t254;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t660 = t81 * t316;
  t661 = t194 * t255;
  t666 = t200 * t316 * t255;
  t669 = t201 * params->a3 * t194 * t203;
  t672 = t255 * t535;
  t674 = t338 * t672 * t194;
  t679 = t352 * t194;
  t682 = t359 * t194;
  t686 = 0.2e1 / 0.3e1 * t88 * t679 * t255 - 0.2e1 / 0.3e1 * t90 * t682 * t255;
  t689 = t269 * t216 * params->a9;
  t694 = t570 * t661;
  t697 = t574 * t661;
  t700 = -0.2e1 / 0.3e1 * t660 * t661 * t85 + 0.2e1 * t666 * t669 - 0.2e1 / 0.3e1 * t533 * t674 - 0.2e1 / 0.3e1 * t544 * t674 + t686 * t95 + 0.4e1 / 0.3e1 * t689 * t220 - t562 * t271 / 0.2e1 - 0.4e1 / 0.3e1 * t568 * t694 + 0.2e1 / 0.3e1 * t218 * t697;
  t705 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t274 - t647 - 0.3e1 / 0.8e1 * t5 * t72 * t700);
  tv2rhosigma5 = t6 * t705 + t278;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t707 = sigma[0] * sigma[0];
  t708 = 0.1e1 / t707;
  t709 = t316 * t708;
  t717 = t126 * t709;
  t720 = t708 * t340;
  t721 = t338 * t720;
  t742 = -t49 * t352 * t708 / 0.4e1 + t49 * params->a6 * t708 / 0.2e1 + t51 * t359 * t708 / 0.4e1 - t51 * params->a8 * t708 / 0.2e1;
  t745 = t379 * t708;
  t748 = t383 * t708;
  t751 = t146 * t708;
  t754 = t42 * t709 * t46 / 0.4e1 - t42 * params->a2 * t708 * t46 / 0.2e1 - 0.3e1 / 0.4e1 * t717 * t329 + t336 * t721 / 0.4e1 + t128 * t129 * t708 * t130 / 0.2e1 + t349 * t721 / 0.4e1 + t742 * t56 - t624 * t247 + t376 * t745 / 0.2e1 - t145 * t748 / 0.4e1 + t145 * t751 / 0.2e1;
  t758 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t754);
  tv2sigma20 = t6 * t758;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t759 = sigma[2] * sigma[2];
  t760 = 0.1e1 / t759;
  t761 = t316 * t760;
  t769 = t200 * t761;
  t772 = t760 * t535;
  t773 = t338 * t772;
  t794 = -t88 * t352 * t760 / 0.4e1 + t88 * params->a6 * t760 / 0.2e1 + t90 * t359 * t760 / 0.4e1 - t90 * params->a8 * t760 / 0.2e1;
  t797 = t570 * t760;
  t800 = t574 * t760;
  t803 = t219 * t760;
  t806 = t81 * t761 * t85 / 0.4e1 - t81 * params->a2 * t760 * t85 / 0.2e1 - 0.3e1 / 0.4e1 * t769 * t527 + t533 * t773 / 0.4e1 + t202 * t129 * t760 * t203 / 0.2e1 + t544 * t773 / 0.4e1 + t794 * t95 - t689 * t271 + t568 * t797 / 0.2e1 - t218 * t800 / 0.4e1 + t218 * t803 / 0.2e1;
  t810 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t806);
  tv2sigma25 = t6 * t810;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t35, t40, t41, t42, t44, t45;
  double t46, t48, t49, t50, t51, t52, t53, t55;
  double t56, t58, t62, t63, t64, t66, t67, t68;
  double t69, t71, t72, t73, t74, t79, t80, t81;
  double t83, t84, t85, t87, t88, t89, t90, t91;
  double t92, t94, t95, t97, t101, tzk0;

  double t102, t103, t104, t106, t109, t110, t114, t115;
  double t116, t119, t120, t125, t126, t127, t128, t129;
  double t130, t140, t142, t143, t145, t146, t147, t150;
  double t155, t156, t158, t161, t162, t166, t169, t171;
  double tvrho0, t175, t178, t179, t184, t186, t189, t190;
  double t194, t199, t200, t201, t202, t203, t213, t215;
  double t216, t218, t219, t220, t223, t228, tvrho1, t231;
  double t245, t247, t250, t254, tvsigma0, tvsigma1, t255, t269;
  double t271, t274, t278, tvsigma2;

  double t281, t282, t283, t286, t287, t288, t291, t295;
  double t296, t300, t302, t308, t309, t312, t314, t316;
  double t317, t318, t319, t329, t333, t334, t335, t336;
  double t337, t338, t339, t340, t342, t349, t352, t353;
  double t359, t360, t366, t369, t373, t375, t376, t377;
  double t378, t379, t380, t383, t384, t387, t390, t395;
  double t396, t397, t398, t401, t404, t408, t409, t413;
  double t415, t417, t420, t422, tv2rho20, t425, t429, t433;
  double t434, t438, t440, t448, t449, t453, t457, t458;
  double t462, t464, t471, t474, tv2rho21, t479, t484, t488;
  double t489, t495, t496, t501, t505, t506, t515, t516;
  double t517, t527, t531, t532, t533, t534, t535, t537;
  double t544, t547, t553, t559, t562, t566, t568, t569;
  double t570, t571, t574, t575, t578, t581, t586, tv2rho22;
  double t594, t595, t596, t601, t604, t607, t609, t614;
  double t617, t621, t624, t629, t632, t635, t640, tv2rhosigma0;
  double tv2rhosigma1, t647, t649, tv2rhosigma2, t655, tv2rhosigma3, tv2rhosigma4, t660;
  double t661, t666, t669, t672, t674, t679, t682, t686;
  double t689, t694, t697, t700, t705, tv2rhosigma5, t707, t708;
  double t709, t717, t720, t721, t742, t745, t748, t751;
  double t754, t758, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t759;
  double t760, t761, t769, t772, t773, t794, t797, t800;
  double t803, t806, t810, tv2sigma25;

  double t814, t815, t818, t821, t822, t823, t826, t830;
  double t831, t835, t837, t842, t844, t847, t853, t854;
  double t857, t859, t862, t864, t866, t867, t870, t876;
  double t877, t880, t886, t888, t889, t893, t897, t898;
  double t899, t902, t905, t906, t907, t908, t909, t910;
  double t911, t913, t915, t918, t922, t925, t937, t940;
  double t943, t946, t957, t961, t966, t967, t969, t970;
  double t971, t972, t973, t974, t977, t978, t981, t982;
  double t985, t986, t991, t993, t994, t997, t1000, t1003;
  double t1007, t1008, t1012, t1014, t1016, t1018, t1020, t1023;
  double t1025, tv3rho30, t1028, t1029, t1030, t1033, t1038, t1039;
  double t1041, t1045, t1046, t1050, t1053, t1057, t1059, t1063;
  double t1072, t1073, t1074, t1077, t1082, t1084, t1088, t1089;
  double t1093, t1096, t1097, t1099, t1108, t1110, t1113, tv3rho31;
  double t1116, t1121, t1125, t1129, t1130, t1134, t1136, t1145;
  double t1146, t1151, t1155, t1159, t1160, t1164, t1166, t1173;
  double t1181, t1183, t1184, tv3rho32, t1189, t1196, t1200, t1201;
  double t1208, t1209, t1216, t1220, t1221, t1237, t1242, t1243;
  double t1245, t1246, t1247, t1249, t1250, t1253, t1254, t1257;
  double t1258, t1262, t1265, t1266, t1267, t1269, t1271, t1274;
  double t1278, t1282, t1283, t1284, t1287, t1290, t1291, t1294;
  double t1295, t1298, t1301, t1307, t1310, t1316, t1336, t1339;
  double t1342, t1346, t1349, t1350, t1355, tv3rho33, t1363, t1370;
  double t1372, t1374, t1375, t1376, t1380, t1384, t1391, t1394;
  double t1397, t1404, t1411, t1415, t1419, t1424, t1426, t1429;
  double t1431, t1432, t1433, t1434, t1435, t1438, t1439, t1441;
  double t1442, t1445, t1460, t1463, t1466, t1469, t1470, t1475;
  double tv3rho2sigma0, tv3rho2sigma1, t1482, t1486, t1488, tv3rho2sigma2, t1494, t1502;
  double tv3rho2sigma3, tv3rho2sigma4, t1508, t1515, t1518, tv3rho2sigma5, t1526, tv3rho2sigma6;
  double tv3rho2sigma7, t1537, t1538, t1539, t1543, t1547, t1554, t1557;
  double t1560, t1567, t1574, t1577, t1584, t1587, t1589, t1592;
  double t1599, t1601, t1604, t1605, t1607, t1608, t1611, t1622;
  double t1625, t1628, t1631, t1632, t1637, tv3rho2sigma8, t1644, t1645;
  double t1646, t1652, t1662, t1669, t1676, t1678, t1680, t1683;
  double t1684, t1685, t1686, t1689, t1694, t1697, t1711, t1714;
  double t1717, t1720, t1723, t1726, t1727, t1732, tv3rhosigma20, tv3rhosigma21;
  double tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1739, t1741, tv3rhosigma25, t1747, tv3rhosigma26;
  double tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1752, t1754, t1757, t1758;
  double t1759, t1760, t1763, t1770, t1775, t1780, t1781, t1787;
  double t1790, t1798, t1805, t1812, t1818, t1821, t1824, t1827;
  double t1830, t1833, t1834, t1839, tv3rhosigma211, t1842, t1859, t1861;
  double t1864, t1865, t1868, t1871, t1884, t1887, t1890, t1891;
  double t1894, t1897, t1898, t1907, t1918, t1921, t1924, t1926;
  double t1927, t1931, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t1933, t1934, t1954, t1956, t1957;
  double t1960, t1963, t1976, t1979, t1982, t1985, t1988, t1989;
  double t1992, t1998, t2009, t2012, t2015, t2017, t2018, t2022;
  double tv3sigma39;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t33 = t29 / t31;
  t34 = sqrt(sigma[0]);
  t35 = POW_1_3(rho[0]);
  t40 = t33 * t34 / t35 / rho[0] / 0.12e2;
  t41 = pow(t40, params->a2);
  t42 = params->a1 * t41;
  t44 = params->a3 * t41 + 0.1e1;
  t45 = pow(t44, params->a4);
  t46 = 0.1e1 / t45;
  t48 = pow(t40, params->a6);
  t49 = params->a5 * t48;
  t50 = pow(t40, params->a8);
  t51 = params->a7 * t50;
  t52 = 0.1e1 - t49 + t51;
  t53 = pow(t40, params->a10);
  t55 = params->a9 * t53 + 0.1e1;
  t56 = 0.1e1 / t55;
  t58 = t42 * t46 + t52 * t56;
  t62 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t58);
  t63 = rho[1] <= p->dens_threshold;
  t64 = -t16;
  t66 = my_piecewise5(t14, t11, t10, t15, t64 * t7);
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = POW_1_3(t67);
  t71 = my_piecewise3(t68, t22, t69 * t67);
  t72 = t71 * t26;
  t73 = sqrt(sigma[2]);
  t74 = POW_1_3(rho[1]);
  t79 = t33 * t73 / t74 / rho[1] / 0.12e2;
  t80 = pow(t79, params->a2);
  t81 = params->a1 * t80;
  t83 = params->a3 * t80 + 0.1e1;
  t84 = pow(t83, params->a4);
  t85 = 0.1e1 / t84;
  t87 = pow(t79, params->a6);
  t88 = params->a5 * t87;
  t89 = pow(t79, params->a8);
  t90 = params->a7 * t89;
  t91 = 0.1e1 - t88 + t90;
  t92 = pow(t79, params->a10);
  t94 = params->a9 * t92 + 0.1e1;
  t95 = 0.1e1 / t94;
  t97 = t81 * t85 + t91 * t95;
  t101 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t97);
  tzk0 = t62 + t101;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t102 = t6 * t6;
  t103 = 0.1e1 / t102;
  t104 = t16 * t103;
  t106 = my_piecewise5(t10, 0, t14, 0, t7 - t104);
  t109 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t106);
  t110 = t109 * t26;
  t114 = t26 * t26;
  t115 = 0.1e1 / t114;
  t116 = t25 * t115;
  t119 = t5 * t116 * t58 / 0.8e1;
  t120 = 0.1e1 / rho[0];
  t125 = t41 * t41;
  t126 = params->a1 * t125;
  t127 = t46 * params->a4;
  t128 = t126 * t127;
  t129 = params->a3 * params->a2;
  t130 = 0.1e1 / t44;
  t140 = 0.4e1 / 0.3e1 * t49 * params->a6 * t120 - 0.4e1 / 0.3e1 * t51 * params->a8 * t120;
  t142 = t55 * t55;
  t143 = 0.1e1 / t142;
  t145 = t52 * t143 * params->a9;
  t146 = t53 * params->a10;
  t147 = t146 * t120;
  t150 = -0.4e1 / 0.3e1 * t42 * params->a2 * t120 * t46 + 0.4e1 / 0.3e1 * t128 * t129 * t120 * t130 + t140 * t56 + 0.4e1 / 0.3e1 * t145 * t147;
  t155 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t58 - t119 - 0.3e1 / 0.8e1 * t5 * t27 * t150);
  t156 = t64 * t103;
  t158 = my_piecewise5(t14, 0, t10, 0, -t7 - t156);
  t161 = my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t158);
  t162 = t161 * t26;
  t166 = t71 * t115;
  t169 = t5 * t166 * t97 / 0.8e1;
  t171 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t97 - t169);
  tvrho0 = t62 + t101 + t6 * (t155 + t171);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t175 = my_piecewise5(t10, 0, t14, 0, -t7 - t104);
  t178 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t175);
  t179 = t178 * t26;
  t184 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t58 - t119);
  t186 = my_piecewise5(t14, 0, t10, 0, t7 - t156);
  t189 = my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t186);
  t190 = t189 * t26;
  t194 = 0.1e1 / rho[1];
  t199 = t80 * t80;
  t200 = params->a1 * t199;
  t201 = t85 * params->a4;
  t202 = t200 * t201;
  t203 = 0.1e1 / t83;
  t213 = 0.4e1 / 0.3e1 * t88 * params->a6 * t194 - 0.4e1 / 0.3e1 * t90 * params->a8 * t194;
  t215 = t94 * t94;
  t216 = 0.1e1 / t215;
  t218 = t91 * t216 * params->a9;
  t219 = t92 * params->a10;
  t220 = t219 * t194;
  t223 = -0.4e1 / 0.3e1 * t81 * params->a2 * t194 * t85 + 0.4e1 / 0.3e1 * t202 * t129 * t194 * t203 + t213 * t95 + 0.4e1 / 0.3e1 * t218 * t220;
  t228 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t97 - t169 - 0.3e1 / 0.8e1 * t5 * t72 * t223);
  tvrho1 = t62 + t101 + t6 * (t184 + t228);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t231 = 0.1e1 / sigma[0];
  t245 = -t49 * params->a6 * t231 / 0.2e1 + t51 * params->a8 * t231 / 0.2e1;
  t247 = t146 * t231;
  t250 = t42 * params->a2 * t231 * t46 / 0.2e1 - t128 * t129 * t231 * t130 / 0.2e1 + t245 * t56 - t145 * t247 / 0.2e1;
  t254 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t250);
  tvsigma0 = t6 * t254;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t255 = 0.1e1 / sigma[2];
  t269 = -t88 * params->a6 * t255 / 0.2e1 + t90 * params->a8 * t255 / 0.2e1;
  t271 = t219 * t255;
  t274 = t81 * params->a2 * t255 * t85 / 0.2e1 - t202 * t129 * t255 * t203 / 0.2e1 + t269 * t95 - t218 * t271 / 0.2e1;
  t278 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t274);
  tvsigma2 = t6 * t278;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t281 = t23 * t23;
  t282 = 0.1e1 / t281;
  t283 = t106 * t106;
  t286 = t102 * t6;
  t287 = 0.1e1 / t286;
  t288 = t16 * t287;
  t291 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t103 + 0.2e1 * t288);
  t295 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t282 * t283 + 0.4e1 / 0.3e1 * t23 * t291);
  t296 = t295 * t26;
  t300 = t109 * t115;
  t302 = t5 * t300 * t58;
  t308 = 0.1e1 / t114 / t6;
  t309 = t25 * t308;
  t312 = t5 * t309 * t58 / 0.12e2;
  t314 = t5 * t116 * t150;
  t316 = params->a2 * params->a2;
  t317 = rho[0] * rho[0];
  t318 = 0.1e1 / t317;
  t319 = t316 * t318;
  t329 = t127 * params->a3 * t130;
  t333 = params->a1 * t125 * t41;
  t334 = params->a4 * params->a4;
  t335 = t46 * t334;
  t336 = t333 * t335;
  t337 = params->a3 * params->a3;
  t338 = t337 * t316;
  t339 = t44 * t44;
  t340 = 0.1e1 / t339;
  t342 = t338 * t318 * t340;
  t349 = t333 * t127;
  t352 = params->a6 * params->a6;
  t353 = t352 * t318;
  t359 = params->a8 * params->a8;
  t360 = t359 * t318;
  t366 = -0.16e2 / 0.9e1 * t49 * t353 - 0.4e1 / 0.3e1 * t49 * params->a6 * t318 + 0.16e2 / 0.9e1 * t51 * t360 + 0.4e1 / 0.3e1 * t51 * params->a8 * t318;
  t369 = t140 * t143 * params->a9;
  t373 = 0.1e1 / t142 / t55;
  t375 = params->a9 * params->a9;
  t376 = t52 * t373 * t375;
  t377 = t53 * t53;
  t378 = params->a10 * params->a10;
  t379 = t377 * t378;
  t380 = t379 * t318;
  t383 = t53 * t378;
  t384 = t383 * t318;
  t387 = t146 * t318;
  t390 = 0.16e2 / 0.9e1 * t42 * t319 * t46 + 0.4e1 / 0.3e1 * t42 * params->a2 * t318 * t46 - 0.16e2 / 0.3e1 * t126 * t319 * t329 + 0.16e2 / 0.9e1 * t336 * t342 - 0.4e1 / 0.3e1 * t128 * t129 * t318 * t130 + 0.16e2 / 0.9e1 * t349 * t342 + t366 * t56 + 0.8e1 / 0.3e1 * t369 * t147 + 0.32e2 / 0.9e1 * t376 * t380 - 0.16e2 / 0.9e1 * t145 * t384 - 0.4e1 / 0.3e1 * t145 * t387;
  t395 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t296 * t58 - t302 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t110 * t150 + t312 - t314 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t390);
  t396 = t69 * t69;
  t397 = 0.1e1 / t396;
  t398 = t158 * t158;
  t401 = t64 * t287;
  t404 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t103 + 0.2e1 * t401);
  t408 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t397 * t398 + 0.4e1 / 0.3e1 * t69 * t404);
  t409 = t408 * t26;
  t413 = t161 * t115;
  t415 = t5 * t413 * t97;
  t417 = t71 * t308;
  t420 = t5 * t417 * t97 / 0.12e2;
  t422 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t409 * t97 - t415 / 0.4e1 + t420);
  tv2rho20 = 0.2e1 * t155 + 0.2e1 * t171 + t6 * (t395 + t422);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t425 = t282 * t175;
  t429 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t288);
  t433 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t425 * t106 + 0.4e1 / 0.3e1 * t23 * t429);
  t434 = t433 * t26;
  t438 = t178 * t115;
  t440 = t5 * t438 * t58;
  t448 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t434 * t58 - t440 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t179 * t150 - t302 / 0.8e1 + t312 - t314 / 0.8e1);
  t449 = t397 * t186;
  t453 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t401);
  t457 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t449 * t158 + 0.4e1 / 0.3e1 * t69 * t453);
  t458 = t457 * t26;
  t462 = t189 * t115;
  t464 = t5 * t462 * t97;
  t471 = t5 * t166 * t223;
  t474 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t458 * t97 - t464 / 0.8e1 - t415 / 0.8e1 + t420 - 0.3e1 / 0.8e1 * t5 * t162 * t223 - t471 / 0.8e1);
  tv2rho21 = t155 + t171 + t184 + t228 + t6 * (t448 + t474);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t479 = t175 * t175;
  t484 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t103 + 0.2e1 * t288);
  t488 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t282 * t479 + 0.4e1 / 0.3e1 * t23 * t484);
  t489 = t488 * t26;
  t495 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t489 * t58 - t440 / 0.4e1 + t312);
  t496 = t186 * t186;
  t501 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t103 + 0.2e1 * t401);
  t505 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t397 * t496 + 0.4e1 / 0.3e1 * t69 * t501);
  t506 = t505 * t26;
  t515 = rho[1] * rho[1];
  t516 = 0.1e1 / t515;
  t517 = t316 * t516;
  t527 = t201 * params->a3 * t203;
  t531 = params->a1 * t199 * t80;
  t532 = t85 * t334;
  t533 = t531 * t532;
  t534 = t83 * t83;
  t535 = 0.1e1 / t534;
  t537 = t338 * t516 * t535;
  t544 = t531 * t201;
  t547 = t352 * t516;
  t553 = t359 * t516;
  t559 = -0.16e2 / 0.9e1 * t88 * t547 - 0.4e1 / 0.3e1 * t88 * params->a6 * t516 + 0.16e2 / 0.9e1 * t90 * t553 + 0.4e1 / 0.3e1 * t90 * params->a8 * t516;
  t562 = t213 * t216 * params->a9;
  t566 = 0.1e1 / t215 / t94;
  t568 = t91 * t566 * t375;
  t569 = t92 * t92;
  t570 = t569 * t378;
  t571 = t570 * t516;
  t574 = t92 * t378;
  t575 = t574 * t516;
  t578 = t219 * t516;
  t581 = 0.16e2 / 0.9e1 * t81 * t517 * t85 + 0.4e1 / 0.3e1 * t81 * params->a2 * t516 * t85 - 0.16e2 / 0.3e1 * t200 * t517 * t527 + 0.16e2 / 0.9e1 * t533 * t537 - 0.4e1 / 0.3e1 * t202 * t129 * t516 * t203 + 0.16e2 / 0.9e1 * t544 * t537 + t559 * t95 + 0.8e1 / 0.3e1 * t562 * t220 + 0.32e2 / 0.9e1 * t568 * t571 - 0.16e2 / 0.9e1 * t218 * t575 - 0.4e1 / 0.3e1 * t218 * t578;
  t586 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t506 * t97 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t190 * t223 + t420 - t471 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t72 * t581);
  tv2rho22 = 0.2e1 * t184 + 0.2e1 * t228 + t6 * (t495 + t586);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t594 = t5 * t116 * t250 / 0.8e1;
  t595 = t42 * t316;
  t596 = t120 * t231;
  t601 = t126 * t316 * t231;
  t604 = t127 * params->a3 * t120 * t130;
  t607 = t231 * t340;
  t609 = t338 * t607 * t120;
  t614 = t352 * t120;
  t617 = t359 * t120;
  t621 = 0.2e1 / 0.3e1 * t49 * t614 * t231 - 0.2e1 / 0.3e1 * t51 * t617 * t231;
  t624 = t245 * t143 * params->a9;
  t629 = t379 * t596;
  t632 = t383 * t596;
  t635 = -0.2e1 / 0.3e1 * t595 * t596 * t46 + 0.2e1 * t601 * t604 - 0.2e1 / 0.3e1 * t336 * t609 - 0.2e1 / 0.3e1 * t349 * t609 + t621 * t56 + 0.4e1 / 0.3e1 * t624 * t147 - t369 * t247 / 0.2e1 - 0.4e1 / 0.3e1 * t376 * t629 + 0.2e1 / 0.3e1 * t145 * t632;
  t640 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t250 - t594 - 0.3e1 / 0.8e1 * t5 * t27 * t635);
  tv2rhosigma0 = t6 * t640 + t254;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t647 = t5 * t166 * t274 / 0.8e1;
  t649 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t274 - t647);
  tv2rhosigma2 = t6 * t649 + t278;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t655 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t250 - t594);
  tv2rhosigma3 = t6 * t655 + t254;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t660 = t81 * t316;
  t661 = t194 * t255;
  t666 = t200 * t316 * t255;
  t669 = t201 * params->a3 * t194 * t203;
  t672 = t255 * t535;
  t674 = t338 * t672 * t194;
  t679 = t352 * t194;
  t682 = t359 * t194;
  t686 = 0.2e1 / 0.3e1 * t88 * t679 * t255 - 0.2e1 / 0.3e1 * t90 * t682 * t255;
  t689 = t269 * t216 * params->a9;
  t694 = t570 * t661;
  t697 = t574 * t661;
  t700 = -0.2e1 / 0.3e1 * t660 * t661 * t85 + 0.2e1 * t666 * t669 - 0.2e1 / 0.3e1 * t533 * t674 - 0.2e1 / 0.3e1 * t544 * t674 + t686 * t95 + 0.4e1 / 0.3e1 * t689 * t220 - t562 * t271 / 0.2e1 - 0.4e1 / 0.3e1 * t568 * t694 + 0.2e1 / 0.3e1 * t218 * t697;
  t705 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t274 - t647 - 0.3e1 / 0.8e1 * t5 * t72 * t700);
  tv2rhosigma5 = t6 * t705 + t278;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t707 = sigma[0] * sigma[0];
  t708 = 0.1e1 / t707;
  t709 = t316 * t708;
  t717 = t126 * t709;
  t720 = t708 * t340;
  t721 = t338 * t720;
  t742 = -t49 * t352 * t708 / 0.4e1 + t49 * params->a6 * t708 / 0.2e1 + t51 * t359 * t708 / 0.4e1 - t51 * params->a8 * t708 / 0.2e1;
  t745 = t379 * t708;
  t748 = t383 * t708;
  t751 = t146 * t708;
  t754 = t42 * t709 * t46 / 0.4e1 - t42 * params->a2 * t708 * t46 / 0.2e1 - 0.3e1 / 0.4e1 * t717 * t329 + t336 * t721 / 0.4e1 + t128 * t129 * t708 * t130 / 0.2e1 + t349 * t721 / 0.4e1 + t742 * t56 - t624 * t247 + t376 * t745 / 0.2e1 - t145 * t748 / 0.4e1 + t145 * t751 / 0.2e1;
  t758 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t754);
  tv2sigma20 = t6 * t758;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t759 = sigma[2] * sigma[2];
  t760 = 0.1e1 / t759;
  t761 = t316 * t760;
  t769 = t200 * t761;
  t772 = t760 * t535;
  t773 = t338 * t772;
  t794 = -t88 * t352 * t760 / 0.4e1 + t88 * params->a6 * t760 / 0.2e1 + t90 * t359 * t760 / 0.4e1 - t90 * params->a8 * t760 / 0.2e1;
  t797 = t570 * t760;
  t800 = t574 * t760;
  t803 = t219 * t760;
  t806 = t81 * t761 * t85 / 0.4e1 - t81 * params->a2 * t760 * t85 / 0.2e1 - 0.3e1 / 0.4e1 * t769 * t527 + t533 * t773 / 0.4e1 + t202 * t129 * t760 * t203 / 0.2e1 + t544 * t773 / 0.4e1 + t794 * t95 - t689 * t271 + t568 * t797 / 0.2e1 - t218 * t800 / 0.4e1 + t218 * t803 / 0.2e1;
  t810 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t806);
  tv2sigma25 = t6 * t810;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t814 = 0.1e1 / t281 / t19;
  t815 = t283 * t106;
  t818 = t282 * t106;
  t821 = t102 * t102;
  t822 = 0.1e1 / t821;
  t823 = t16 * t822;
  t826 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t287 - 0.6e1 * t823);
  t830 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t814 * t815 + 0.4e1 / 0.3e1 * t818 * t291 + 0.4e1 / 0.3e1 * t23 * t826);
  t831 = t830 * t26;
  t835 = t295 * t115;
  t837 = t5 * t835 * t58;
  t842 = t109 * t308;
  t844 = t5 * t842 * t58;
  t847 = t5 * t300 * t150;
  t853 = 0.1e1 / t114 / t102;
  t854 = t25 * t853;
  t857 = 0.5e1 / 0.36e2 * t5 * t854 * t58;
  t859 = t5 * t309 * t150;
  t862 = t5 * t116 * t390;
  t864 = t352 * params->a6;
  t866 = 0.1e1 / t317 / rho[0];
  t867 = t864 * t866;
  t870 = t352 * t866;
  t876 = t359 * params->a8;
  t877 = t876 * t866;
  t880 = t359 * t866;
  t886 = 0.64e2 / 0.27e2 * t49 * t867 + 0.16e2 / 0.3e1 * t49 * t870 + 0.8e1 / 0.3e1 * t49 * params->a6 * t866 - 0.64e2 / 0.27e2 * t51 * t877 - 0.16e2 / 0.3e1 * t51 * t880 - 0.8e1 / 0.3e1 * t51 * params->a8 * t866;
  t888 = t316 * params->a2;
  t889 = t888 * t866;
  t893 = t316 * t866;
  t897 = t333 * t889;
  t898 = t337 * t340;
  t899 = t335 * t898;
  t902 = t127 * t898;
  t905 = t125 * t125;
  t906 = params->a1 * t905;
  t907 = t334 * params->a4;
  t908 = t46 * t907;
  t909 = t906 * t908;
  t910 = t337 * params->a3;
  t911 = t910 * t888;
  t913 = 0.1e1 / t339 / t44;
  t915 = t911 * t866 * t913;
  t918 = t906 * t335;
  t922 = t338 * t866 * t340;
  t925 = t906 * t127;
  t937 = t886 * t56 - 0.64e2 / 0.27e2 * t42 * t889 * t46 + 0.16e2 * t126 * t893 * t329 - 0.128e3 / 0.9e1 * t897 * t899 - 0.128e3 / 0.9e1 * t897 * t902 + 0.64e2 / 0.27e2 * t909 * t915 + 0.64e2 / 0.9e1 * t918 * t915 - 0.16e2 / 0.3e1 * t349 * t922 + 0.128e3 / 0.27e2 * t925 * t915 + 0.448e3 / 0.27e2 * t126 * t889 * t329 - 0.16e2 / 0.3e1 * t336 * t922 + 0.8e1 / 0.3e1 * t128 * t129 * t866 * t130;
  t940 = t379 * t866;
  t943 = t383 * t866;
  t946 = t146 * t866;
  t957 = t366 * t143 * params->a9;
  t961 = t140 * t373 * t375;
  t966 = t142 * t142;
  t967 = 0.1e1 / t966;
  t969 = t375 * params->a9;
  t970 = t52 * t967 * t969;
  t971 = t377 * t53;
  t972 = t378 * params->a10;
  t973 = t971 * t972;
  t974 = t973 * t866;
  t977 = t377 * t972;
  t978 = t977 * t866;
  t981 = t53 * t972;
  t982 = t981 * t866;
  t985 = -0.4e1 * t369 * t387 - 0.32e2 / 0.3e1 * t376 * t940 + 0.16e2 / 0.3e1 * t145 * t943 + 0.8e1 / 0.3e1 * t145 * t946 - 0.16e2 / 0.3e1 * t42 * t893 * t46 - 0.8e1 / 0.3e1 * t42 * params->a2 * t866 * t46 + 0.4e1 * t957 * t147 + 0.32e2 / 0.3e1 * t961 * t380 - 0.16e2 / 0.3e1 * t369 * t384 + 0.128e3 / 0.9e1 * t970 * t974 - 0.128e3 / 0.9e1 * t376 * t978 + 0.64e2 / 0.27e2 * t145 * t982;
  t986 = t937 + t985;
  t991 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t831 * t58 - 0.3e1 / 0.8e1 * t837 - 0.9e1 / 0.8e1 * t5 * t296 * t150 + t844 / 0.4e1 - 0.3e1 / 0.4e1 * t847 - 0.9e1 / 0.8e1 * t5 * t110 * t390 - t857 + t859 / 0.4e1 - 0.3e1 / 0.8e1 * t862 - 0.3e1 / 0.8e1 * t5 * t27 * t986);
  t993 = 0.1e1 / t396 / t67;
  t994 = t398 * t158;
  t997 = t397 * t158;
  t1000 = t64 * t822;
  t1003 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t287 - 0.6e1 * t1000);
  t1007 = my_piecewise3(t68, 0, -0.8e1 / 0.27e2 * t993 * t994 + 0.4e1 / 0.3e1 * t997 * t404 + 0.4e1 / 0.3e1 * t69 * t1003);
  t1008 = t1007 * t26;
  t1012 = t408 * t115;
  t1014 = t5 * t1012 * t97;
  t1016 = t161 * t308;
  t1018 = t5 * t1016 * t97;
  t1020 = t71 * t853;
  t1023 = 0.5e1 / 0.36e2 * t5 * t1020 * t97;
  t1025 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1008 * t97 - 0.3e1 / 0.8e1 * t1014 + t1018 / 0.4e1 - t1023);
  tv3rho30 = 0.3e1 * t395 + 0.3e1 * t422 + t6 * (t991 + t1025);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1028 = 0.2e1 * t448;
  t1029 = 0.2e1 * t474;
  t1030 = t814 * t175;
  t1033 = t282 * t429;
  t1038 = 0.2e1 * t287;
  t1039 = 0.6e1 * t823;
  t1041 = my_piecewise5(t10, 0, t14, 0, t1038 - t1039);
  t1045 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t1030 * t283 + 0.8e1 / 0.9e1 * t1033 * t106 + 0.4e1 / 0.9e1 * t425 * t291 + 0.4e1 / 0.3e1 * t23 * t1041);
  t1046 = t1045 * t26;
  t1050 = t433 * t115;
  t1053 = t5 * t1050 * t58 / 0.4e1;
  t1057 = t178 * t308;
  t1059 = t5 * t1057 * t58;
  t1063 = t5 * t438 * t150 / 0.4e1;
  t1072 = -0.3e1 / 0.8e1 * t5 * t1046 * t58 - t1053 - 0.3e1 / 0.4e1 * t5 * t434 * t150 + t1059 / 0.12e2 - t1063 - 0.3e1 / 0.8e1 * t5 * t179 * t390 - t837 / 0.8e1 + t844 / 0.6e1 - t847 / 0.4e1 - t857 + t859 / 0.6e1 - t862 / 0.8e1;
  t1073 = my_piecewise3(t1, 0, t1072);
  t1074 = t993 * t186;
  t1077 = t397 * t453;
  t1082 = 0.6e1 * t1000;
  t1084 = my_piecewise5(t14, 0, t10, 0, -t1038 - t1082);
  t1088 = my_piecewise3(t68, 0, -0.8e1 / 0.27e2 * t1074 * t398 + 0.8e1 / 0.9e1 * t1077 * t158 + 0.4e1 / 0.9e1 * t449 * t404 + 0.4e1 / 0.3e1 * t69 * t1084);
  t1089 = t1088 * t26;
  t1093 = t457 * t115;
  t1096 = t5 * t1093 * t97 / 0.4e1;
  t1097 = t189 * t308;
  t1099 = t5 * t1097 * t97;
  t1108 = t5 * t413 * t223 / 0.4e1;
  t1110 = t5 * t417 * t223;
  t1113 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1089 * t97 - t1096 + t1099 / 0.12e2 - t1014 / 0.8e1 + t1018 / 0.6e1 - t1023 - 0.3e1 / 0.8e1 * t5 * t409 * t223 - t1108 + t1110 / 0.12e2);
  tv3rho31 = t395 + t422 + t1028 + t1029 + t6 * (t1073 + t1113);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1116 = t814 * t479;
  t1121 = t282 * t484;
  t1125 = my_piecewise5(t10, 0, t14, 0, -t1038 - t1039);
  t1129 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t1116 * t106 + 0.8e1 / 0.9e1 * t425 * t429 + 0.4e1 / 0.9e1 * t1121 * t106 + 0.4e1 / 0.3e1 * t23 * t1125);
  t1130 = t1129 * t26;
  t1134 = t488 * t115;
  t1136 = t5 * t1134 * t58;
  t1145 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1130 * t58 - t1136 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t489 * t150 - t1053 + t1059 / 0.6e1 - t1063 + t844 / 0.12e2 - t857 + t859 / 0.12e2);
  t1146 = t993 * t496;
  t1151 = t397 * t501;
  t1155 = my_piecewise5(t14, 0, t10, 0, t1038 - t1082);
  t1159 = my_piecewise3(t68, 0, -0.8e1 / 0.27e2 * t1146 * t158 + 0.8e1 / 0.9e1 * t449 * t453 + 0.4e1 / 0.9e1 * t1151 * t158 + 0.4e1 / 0.3e1 * t69 * t1155);
  t1160 = t1159 * t26;
  t1164 = t505 * t115;
  t1166 = t5 * t1164 * t97;
  t1173 = t5 * t462 * t223;
  t1181 = t5 * t166 * t581;
  t1183 = -0.3e1 / 0.8e1 * t5 * t1160 * t97 - t1166 / 0.8e1 - t1096 + t1099 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t458 * t223 - t1173 / 0.4e1 + t1018 / 0.12e2 - t1023 - t1108 + t1110 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t162 * t581 - t1181 / 0.8e1;
  t1184 = my_piecewise3(t63, 0, t1183);
  tv3rho32 = t1028 + t1029 + t495 + t586 + t6 * (t1145 + t1184);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1189 = t479 * t175;
  t1196 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t287 - 0.6e1 * t823);
  t1200 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t814 * t1189 + 0.4e1 / 0.3e1 * t425 * t484 + 0.4e1 / 0.3e1 * t23 * t1196);
  t1201 = t1200 * t26;
  t1208 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1201 * t58 - 0.3e1 / 0.8e1 * t1136 + t1059 / 0.4e1 - t857);
  t1209 = t496 * t186;
  t1216 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t287 - 0.6e1 * t1000);
  t1220 = my_piecewise3(t68, 0, -0.8e1 / 0.27e2 * t993 * t1209 + 0.4e1 / 0.3e1 * t449 * t501 + 0.4e1 / 0.3e1 * t69 * t1216);
  t1221 = t1220 * t26;
  t1237 = t213 * t566 * t375;
  t1242 = t215 * t215;
  t1243 = 0.1e1 / t1242;
  t1245 = t91 * t1243 * t969;
  t1246 = t569 * t92;
  t1247 = t1246 * t972;
  t1249 = 0.1e1 / t515 / rho[1];
  t1250 = t1247 * t1249;
  t1253 = t569 * t972;
  t1254 = t1253 * t1249;
  t1257 = t92 * t972;
  t1258 = t1257 * t1249;
  t1262 = t338 * t1249 * t535;
  t1265 = t199 * t199;
  t1266 = params->a1 * t1265;
  t1267 = t1266 * t201;
  t1269 = 0.1e1 / t534 / t83;
  t1271 = t911 * t1249 * t1269;
  t1274 = t888 * t1249;
  t1278 = t316 * t1249;
  t1282 = t531 * t1274;
  t1283 = t337 * t535;
  t1284 = t532 * t1283;
  t1287 = t201 * t1283;
  t1290 = t85 * t907;
  t1291 = t1266 * t1290;
  t1294 = 0.32e2 / 0.3e1 * t1237 * t571 - 0.16e2 / 0.3e1 * t562 * t575 + 0.128e3 / 0.9e1 * t1245 * t1250 - 0.128e3 / 0.9e1 * t568 * t1254 + 0.64e2 / 0.27e2 * t218 * t1258 - 0.16e2 / 0.3e1 * t544 * t1262 + 0.128e3 / 0.27e2 * t1267 * t1271 + 0.448e3 / 0.27e2 * t200 * t1274 * t527 + 0.16e2 * t200 * t1278 * t527 - 0.128e3 / 0.9e1 * t1282 * t1284 - 0.128e3 / 0.9e1 * t1282 * t1287 + 0.64e2 / 0.27e2 * t1291 * t1271;
  t1295 = t1266 * t532;
  t1298 = t864 * t1249;
  t1301 = t352 * t1249;
  t1307 = t876 * t1249;
  t1310 = t359 * t1249;
  t1316 = 0.64e2 / 0.27e2 * t88 * t1298 + 0.16e2 / 0.3e1 * t88 * t1301 + 0.8e1 / 0.3e1 * t88 * params->a6 * t1249 - 0.64e2 / 0.27e2 * t90 * t1307 - 0.16e2 / 0.3e1 * t90 * t1310 - 0.8e1 / 0.3e1 * t90 * params->a8 * t1249;
  t1336 = t570 * t1249;
  t1339 = t574 * t1249;
  t1342 = t219 * t1249;
  t1346 = t559 * t216 * params->a9;
  t1349 = 0.64e2 / 0.9e1 * t1295 * t1271 + t1316 * t95 - 0.64e2 / 0.27e2 * t81 * t1274 * t85 - 0.16e2 / 0.3e1 * t533 * t1262 + 0.8e1 / 0.3e1 * t202 * t129 * t1249 * t203 - 0.16e2 / 0.3e1 * t81 * t1278 * t85 - 0.8e1 / 0.3e1 * t81 * params->a2 * t1249 * t85 - 0.4e1 * t562 * t578 - 0.32e2 / 0.3e1 * t568 * t1336 + 0.16e2 / 0.3e1 * t218 * t1339 + 0.8e1 / 0.3e1 * t218 * t1342 + 0.4e1 * t1346 * t220;
  t1350 = t1294 + t1349;
  t1355 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1221 * t97 - 0.3e1 / 0.8e1 * t1166 - 0.9e1 / 0.8e1 * t5 * t506 * t223 + t1099 / 0.4e1 - 0.3e1 / 0.4e1 * t1173 - 0.9e1 / 0.8e1 * t5 * t190 * t581 - t1023 + t1110 / 0.4e1 - 0.3e1 / 0.8e1 * t1181 - 0.3e1 / 0.8e1 * t5 * t72 * t1350);
  tv3rho33 = 0.3e1 * t495 + 0.3e1 * t586 + t6 * (t1208 + t1355);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1363 = t5 * t300 * t250;
  t1370 = t5 * t309 * t250 / 0.12e2;
  t1372 = t5 * t116 * t635;
  t1374 = t42 * t888;
  t1375 = t318 * t231;
  t1376 = t1375 * t46;
  t1380 = t621 * t143 * params->a9;
  t1384 = t245 * t373 * t375;
  t1391 = t379 * t1375;
  t1394 = t383 * t1375;
  t1397 = t864 * t318;
  t1404 = t876 * t318;
  t1411 = -0.8e1 / 0.9e1 * t49 * t1397 * t231 - 0.2e1 / 0.3e1 * t49 * t353 * t231 + 0.8e1 / 0.9e1 * t51 * t1404 * t231 + 0.2e1 / 0.3e1 * t51 * t360 * t231;
  t1415 = t127 * params->a3 * t318 * t130;
  t1419 = t338 * t607 * t318;
  t1424 = t231 * t913;
  t1426 = t911 * t1424 * t318;
  t1429 = 0.8e1 / 0.9e1 * t1374 * t1376 + 0.8e1 / 0.3e1 * t1380 * t147 + 0.32e2 / 0.9e1 * t1384 * t380 - 0.16e2 / 0.9e1 * t624 * t384 - t957 * t247 / 0.2e1 + 0.4e1 / 0.3e1 * t376 * t1391 - 0.2e1 / 0.3e1 * t145 * t1394 + t1411 * t56 - 0.2e1 * t601 * t1415 + 0.2e1 / 0.3e1 * t336 * t1419 + 0.2e1 / 0.3e1 * t349 * t1419 - 0.16e2 / 0.9e1 * t925 * t1426;
  t1431 = t126 * t888 * t318;
  t1432 = t231 * t46;
  t1433 = params->a4 * params->a3;
  t1434 = t1433 * t130;
  t1435 = t1432 * t1434;
  t1438 = t888 * t231;
  t1439 = t333 * t1438;
  t1441 = t337 * t318 * t340;
  t1442 = t335 * t1441;
  t1445 = t127 * t1441;
  t1460 = t973 * t1375;
  t1463 = t977 * t1375;
  t1466 = t981 * t1375;
  t1469 = -0.56e2 / 0.9e1 * t1431 * t1435 + 0.16e2 / 0.3e1 * t1439 * t1442 + 0.16e2 / 0.3e1 * t1439 * t1445 - 0.8e1 / 0.9e1 * t909 * t1426 - 0.8e1 / 0.3e1 * t918 * t1426 + 0.2e1 / 0.3e1 * t595 * t1376 - 0.4e1 / 0.3e1 * t624 * t387 - 0.8e1 / 0.3e1 * t961 * t629 + 0.4e1 / 0.3e1 * t369 * t632 - 0.16e2 / 0.3e1 * t970 * t1460 + 0.16e2 / 0.3e1 * t376 * t1463 - 0.8e1 / 0.9e1 * t145 * t1466;
  t1470 = t1429 + t1469;
  t1475 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t296 * t250 - t1363 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t110 * t635 + t1370 - t1372 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t1470);
  tv3rho2sigma0 = t6 * t1475 + 0.2e1 * t640;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1482 = t5 * t413 * t274;
  t1486 = t5 * t417 * t274 / 0.12e2;
  t1488 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t409 * t274 - t1482 / 0.4e1 + t1486);
  tv3rho2sigma2 = t6 * t1488 + 0.2e1 * t649;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1494 = t5 * t438 * t250;
  t1502 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t434 * t250 - t1494 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t179 * t635 - t1363 / 0.8e1 + t1370 - t1372 / 0.8e1);
  tv3rho2sigma3 = t6 * t1502 + t640 + t655;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1508 = t5 * t462 * t274;
  t1515 = t5 * t166 * t700;
  t1518 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t458 * t274 - t1508 / 0.8e1 - t1482 / 0.8e1 + t1486 - 0.3e1 / 0.8e1 * t5 * t162 * t700 - t1515 / 0.8e1);
  tv3rho2sigma5 = t6 * t1518 + t649 + t705;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1526 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t489 * t250 - t1494 / 0.4e1 + t1370);
  tv3rho2sigma6 = t6 * t1526 + 0.2e1 * t655;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1537 = t81 * t888;
  t1538 = t516 * t255;
  t1539 = t1538 * t85;
  t1543 = t686 * t216 * params->a9;
  t1547 = t269 * t566 * t375;
  t1554 = t570 * t1538;
  t1557 = t574 * t1538;
  t1560 = t864 * t516;
  t1567 = t876 * t516;
  t1574 = -0.8e1 / 0.9e1 * t88 * t1560 * t255 - 0.2e1 / 0.3e1 * t88 * t547 * t255 + 0.8e1 / 0.9e1 * t90 * t1567 * t255 + 0.2e1 / 0.3e1 * t90 * t553 * t255;
  t1577 = t338 * t672 * t516;
  t1584 = t201 * params->a3 * t516 * t203;
  t1587 = t255 * t1269;
  t1589 = t911 * t1587 * t516;
  t1592 = 0.8e1 / 0.9e1 * t1537 * t1539 + 0.8e1 / 0.3e1 * t1543 * t220 + 0.32e2 / 0.9e1 * t1547 * t571 - 0.16e2 / 0.9e1 * t689 * t575 - t1346 * t271 / 0.2e1 + 0.4e1 / 0.3e1 * t568 * t1554 - 0.2e1 / 0.3e1 * t218 * t1557 + t1574 * t95 + 0.2e1 / 0.3e1 * t533 * t1577 + 0.2e1 / 0.3e1 * t544 * t1577 - 0.2e1 * t666 * t1584 - 0.8e1 / 0.9e1 * t1291 * t1589;
  t1599 = t255 * t85;
  t1601 = t1599 * t1433 * t203;
  t1604 = t888 * t255;
  t1605 = t531 * t1604;
  t1607 = t337 * t516 * t535;
  t1608 = t532 * t1607;
  t1611 = t201 * t1607;
  t1622 = t1247 * t1538;
  t1625 = t1253 * t1538;
  t1628 = t1257 * t1538;
  t1631 = -0.8e1 / 0.3e1 * t1295 * t1589 - 0.16e2 / 0.9e1 * t1267 * t1589 - 0.56e2 / 0.9e1 * t200 * t888 * t516 * t1601 + 0.16e2 / 0.3e1 * t1605 * t1608 + 0.16e2 / 0.3e1 * t1605 * t1611 + 0.2e1 / 0.3e1 * t660 * t1539 - 0.4e1 / 0.3e1 * t689 * t578 - 0.8e1 / 0.3e1 * t1237 * t694 + 0.4e1 / 0.3e1 * t562 * t697 - 0.16e2 / 0.3e1 * t1245 * t1622 + 0.16e2 / 0.3e1 * t568 * t1625 - 0.8e1 / 0.9e1 * t218 * t1628;
  t1632 = t1592 + t1631;
  t1637 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t506 * t274 - t1508 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t190 * t700 + t1486 - t1515 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t72 * t1632);
  tv3rho2sigma8 = t6 * t1637 + 0.2e1 * t705;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1644 = t5 * t116 * t754 / 0.8e1;
  t1645 = t120 * t708;
  t1646 = t1645 * t46;
  t1652 = t742 * t143 * params->a9;
  t1662 = t864 * t120;
  t1669 = t876 * t120;
  t1676 = t49 * t1662 * t708 / 0.3e1 - 0.2e1 / 0.3e1 * t49 * t614 * t708 - t51 * t1669 * t708 / 0.3e1 + 0.2e1 / 0.3e1 * t51 * t617 * t708;
  t1678 = t708 * t913;
  t1680 = t911 * t1678 * t120;
  t1683 = t888 * t708;
  t1684 = t333 * t1683;
  t1685 = t898 * t120;
  t1686 = t335 * t1685;
  t1689 = t127 * t1685;
  t1694 = -t1374 * t1646 / 0.3e1 + 0.2e1 / 0.3e1 * t595 * t1646 + 0.4e1 / 0.3e1 * t1652 * t147 - t1380 * t247 + t961 * t745 / 0.2e1 - t369 * t748 / 0.4e1 + t369 * t751 / 0.2e1 + t1676 * t56 + 0.2e1 / 0.3e1 * t925 * t1680 - 0.2e1 * t1684 * t1686 - 0.2e1 * t1684 * t1689 + t909 * t1680 / 0.3e1;
  t1697 = t338 * t720 * t120;
  t1711 = t973 * t1645;
  t1714 = t977 * t1645;
  t1717 = t981 * t1645;
  t1720 = t379 * t1645;
  t1723 = t383 * t1645;
  t1726 = t918 * t1680 + 0.2e1 / 0.3e1 * t336 * t1697 + 0.2e1 / 0.3e1 * t349 * t1697 + 0.7e1 / 0.3e1 * t126 * t1683 * t604 - 0.2e1 * t717 * t604 - 0.8e1 / 0.3e1 * t1384 * t629 + 0.4e1 / 0.3e1 * t624 * t632 + 0.2e1 * t970 * t1711 - 0.2e1 * t376 * t1714 + t145 * t1717 / 0.3e1 + 0.4e1 / 0.3e1 * t376 * t1720 - 0.2e1 / 0.3e1 * t145 * t1723;
  t1727 = t1694 + t1726;
  t1732 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t754 - t1644 - 0.3e1 / 0.8e1 * t5 * t27 * t1727);
  tv3rhosigma20 = t6 * t1732 + t758;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1739 = t5 * t166 * t806 / 0.8e1;
  t1741 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t806 - t1739);
  tv3rhosigma25 = t6 * t1741 + t810;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1747 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t754 - t1644);
  tv3rhosigma26 = t6 * t1747 + t758;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1752 = t760 * t1269;
  t1754 = t911 * t1752 * t194;
  t1757 = t888 * t760;
  t1758 = t531 * t1757;
  t1759 = t1283 * t194;
  t1760 = t532 * t1759;
  t1763 = t201 * t1759;
  t1770 = t338 * t772 * t194;
  t1775 = t200 * t1757;
  t1780 = t194 * t760;
  t1781 = t1780 * t85;
  t1787 = t794 * t216 * params->a9;
  t1790 = 0.2e1 / 0.3e1 * t1267 * t1754 - 0.2e1 * t1758 * t1760 - 0.2e1 * t1758 * t1763 + t1291 * t1754 / 0.3e1 + t1295 * t1754 + 0.2e1 / 0.3e1 * t533 * t1770 + 0.2e1 / 0.3e1 * t544 * t1770 + 0.7e1 / 0.3e1 * t1775 * t669 - 0.2e1 * t769 * t669 - t1537 * t1781 / 0.3e1 + 0.2e1 / 0.3e1 * t660 * t1781 + 0.4e1 / 0.3e1 * t1787 * t220;
  t1798 = t864 * t194;
  t1805 = t876 * t194;
  t1812 = t88 * t1798 * t760 / 0.3e1 - 0.2e1 / 0.3e1 * t88 * t679 * t760 - t90 * t1805 * t760 / 0.3e1 + 0.2e1 / 0.3e1 * t90 * t682 * t760;
  t1818 = t1247 * t1780;
  t1821 = t1253 * t1780;
  t1824 = t1257 * t1780;
  t1827 = t570 * t1780;
  t1830 = t574 * t1780;
  t1833 = -t1543 * t271 + t1237 * t797 / 0.2e1 - t562 * t800 / 0.4e1 + t562 * t803 / 0.2e1 + t1812 * t95 - 0.8e1 / 0.3e1 * t1547 * t694 + 0.4e1 / 0.3e1 * t689 * t697 + 0.2e1 * t1245 * t1818 - 0.2e1 * t568 * t1821 + t218 * t1824 / 0.3e1 + 0.4e1 / 0.3e1 * t568 * t1827 - 0.2e1 / 0.3e1 * t218 * t1830;
  t1834 = t1790 + t1833;
  t1839 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t806 - t1739 - 0.3e1 / 0.8e1 * t5 * t72 * t1834);
  tv3rhosigma211 = t6 * t1839 + t810;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1842 = 0.1e1 / t707 / sigma[0];
  t1859 = -t49 * t864 * t1842 / 0.8e1 + 0.3e1 / 0.4e1 * t49 * t352 * t1842 - t49 * params->a6 * t1842 + t51 * t876 * t1842 / 0.8e1 - 0.3e1 / 0.4e1 * t51 * t359 * t1842 + t51 * params->a8 * t1842;
  t1861 = t1842 * t130;
  t1864 = t1842 * t340;
  t1865 = t338 * t1864;
  t1868 = t981 * t1842;
  t1871 = t316 * t1842;
  t1884 = t973 * t1842;
  t1887 = t977 * t1842;
  t1890 = t888 * t1842;
  t1891 = t333 * t1890;
  t1894 = t1859 * t56 - t128 * t129 * t1861 - 0.3e1 / 0.4e1 * t336 * t1865 - t145 * t1868 / 0.8e1 - 0.3e1 / 0.4e1 * t42 * t1871 * t46 + t42 * params->a2 * t1842 * t46 - 0.3e1 / 0.2e1 * t1652 * t247 + 0.3e1 / 0.2e1 * t1384 * t745 - 0.3e1 / 0.4e1 * t624 * t748 - 0.3e1 / 0.4e1 * t970 * t1884 + 0.3e1 / 0.4e1 * t376 * t1887 + 0.3e1 / 0.4e1 * t1891 * t899;
  t1897 = t1842 * t913;
  t1898 = t911 * t1897;
  t1907 = t126 * t1890;
  t1918 = t379 * t1842;
  t1921 = t383 * t1842;
  t1924 = t146 * t1842;
  t1926 = 0.3e1 / 0.4e1 * t1891 * t902 - t909 * t1898 / 0.8e1 - 0.3e1 / 0.8e1 * t918 * t1898 - 0.3e1 / 0.4e1 * t349 * t1865 - t925 * t1898 / 0.4e1 - 0.7e1 / 0.8e1 * t1907 * t329 + 0.9e1 / 0.4e1 * t126 * t1871 * t329 + t42 * t1890 * t46 / 0.8e1 + 0.3e1 / 0.2e1 * t624 * t751 - 0.3e1 / 0.2e1 * t376 * t1918 + 0.3e1 / 0.4e1 * t145 * t1921 - t145 * t1924;
  t1927 = t1894 + t1926;
  t1931 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1927);
  tv3sigma30 = t6 * t1931;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1933 = 0.1e1 / t759 / sigma[2];
  t1934 = t888 * t1933;
  t1954 = -t88 * t864 * t1933 / 0.8e1 + 0.3e1 / 0.4e1 * t88 * t352 * t1933 - t88 * params->a6 * t1933 + t90 * t876 * t1933 / 0.8e1 - 0.3e1 / 0.4e1 * t90 * t359 * t1933 + t90 * params->a8 * t1933;
  t1956 = t1933 * t535;
  t1957 = t338 * t1956;
  t1960 = t1933 * t203;
  t1963 = t316 * t1933;
  t1976 = t1247 * t1933;
  t1979 = t1253 * t1933;
  t1982 = t1257 * t1933;
  t1985 = t81 * t1934 * t85 / 0.8e1 + t1954 * t95 - 0.3e1 / 0.4e1 * t533 * t1957 - t202 * t129 * t1960 - 0.3e1 / 0.4e1 * t81 * t1963 * t85 + t81 * params->a2 * t1933 * t85 - 0.3e1 / 0.2e1 * t1787 * t271 + 0.3e1 / 0.2e1 * t1547 * t797 - 0.3e1 / 0.4e1 * t689 * t800 - 0.3e1 / 0.4e1 * t1245 * t1976 + 0.3e1 / 0.4e1 * t568 * t1979 - t218 * t1982 / 0.8e1;
  t1988 = t1933 * t1269;
  t1989 = t911 * t1988;
  t1992 = t200 * t1934;
  t1998 = t531 * t1934;
  t2009 = t570 * t1933;
  t2012 = t574 * t1933;
  t2015 = t219 * t1933;
  t2017 = -0.3e1 / 0.4e1 * t544 * t1957 - t1267 * t1989 / 0.4e1 - 0.7e1 / 0.8e1 * t1992 * t527 + 0.9e1 / 0.4e1 * t200 * t1963 * t527 + 0.3e1 / 0.4e1 * t1998 * t1284 + 0.3e1 / 0.4e1 * t1998 * t1287 - t1291 * t1989 / 0.8e1 - 0.3e1 / 0.8e1 * t1295 * t1989 + 0.3e1 / 0.2e1 * t689 * t803 - 0.3e1 / 0.2e1 * t568 * t2009 + 0.3e1 / 0.4e1 * t218 * t2012 - t218 * t2015;
  t2018 = t1985 + t2017;
  t2022 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t2018);
  tv3sigma39 = t6 * t2022;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t35, t40, t41, t42, t44, t45;
  double t46, t48, t49, t50, t51, t52, t53, t55;
  double t56, t58, t62, t63, t64, t66, t67, t68;
  double t69, t71, t72, t73, t74, t79, t80, t81;
  double t83, t84, t85, t87, t88, t89, t90, t91;
  double t92, t94, t95, t97, t101, tzk0;

  double t102, t103, t104, t106, t109, t110, t114, t115;
  double t116, t119, t120, t125, t126, t127, t128, t129;
  double t130, t140, t142, t143, t145, t146, t147, t150;
  double t155, t156, t158, t161, t162, t166, t169, t171;
  double tvrho0, t175, t178, t179, t184, t186, t189, t190;
  double t194, t199, t200, t201, t202, t203, t213, t215;
  double t216, t218, t219, t220, t223, t228, tvrho1, t231;
  double t245, t247, t250, t254, tvsigma0, tvsigma1, t255, t269;
  double t271, t274, t278, tvsigma2;

  double t281, t282, t283, t286, t287, t288, t291, t295;
  double t296, t300, t302, t308, t309, t312, t314, t316;
  double t317, t318, t319, t329, t333, t334, t335, t336;
  double t337, t338, t339, t340, t342, t349, t352, t353;
  double t359, t360, t366, t369, t373, t375, t376, t377;
  double t378, t379, t380, t383, t384, t387, t390, t395;
  double t396, t397, t398, t401, t404, t408, t409, t413;
  double t415, t417, t420, t422, tv2rho20, t425, t429, t433;
  double t434, t438, t440, t448, t449, t453, t457, t458;
  double t462, t464, t471, t474, tv2rho21, t479, t484, t488;
  double t489, t495, t496, t501, t505, t506, t515, t516;
  double t517, t527, t531, t532, t533, t534, t535, t537;
  double t544, t547, t553, t559, t562, t566, t568, t569;
  double t570, t571, t574, t575, t578, t581, t586, tv2rho22;
  double t594, t595, t596, t601, t604, t607, t609, t614;
  double t617, t621, t624, t629, t632, t635, t640, tv2rhosigma0;
  double tv2rhosigma1, t647, t649, tv2rhosigma2, t655, tv2rhosigma3, tv2rhosigma4, t660;
  double t661, t666, t669, t672, t674, t679, t682, t686;
  double t689, t694, t697, t700, t705, tv2rhosigma5, t707, t708;
  double t709, t717, t720, t721, t742, t745, t748, t751;
  double t754, t758, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t759;
  double t760, t761, t769, t772, t773, t794, t797, t800;
  double t803, t806, t810, tv2sigma25;

  double t814, t815, t818, t821, t822, t823, t826, t830;
  double t831, t835, t837, t842, t844, t847, t853, t854;
  double t857, t859, t862, t864, t866, t867, t870, t876;
  double t877, t880, t886, t888, t889, t893, t897, t898;
  double t899, t902, t905, t906, t907, t908, t909, t910;
  double t911, t913, t915, t918, t922, t925, t937, t940;
  double t943, t946, t957, t961, t966, t967, t969, t970;
  double t971, t972, t973, t974, t977, t978, t981, t982;
  double t985, t986, t991, t993, t994, t997, t1000, t1003;
  double t1007, t1008, t1012, t1014, t1016, t1018, t1020, t1023;
  double t1025, tv3rho30, t1028, t1029, t1030, t1033, t1038, t1039;
  double t1041, t1045, t1046, t1050, t1053, t1057, t1059, t1063;
  double t1072, t1073, t1074, t1077, t1082, t1084, t1088, t1089;
  double t1093, t1096, t1097, t1099, t1108, t1110, t1113, tv3rho31;
  double t1116, t1121, t1125, t1129, t1130, t1134, t1136, t1145;
  double t1146, t1151, t1155, t1159, t1160, t1164, t1166, t1173;
  double t1181, t1183, t1184, tv3rho32, t1189, t1196, t1200, t1201;
  double t1208, t1209, t1216, t1220, t1221, t1237, t1242, t1243;
  double t1245, t1246, t1247, t1249, t1250, t1253, t1254, t1257;
  double t1258, t1262, t1265, t1266, t1267, t1269, t1271, t1274;
  double t1278, t1282, t1283, t1284, t1287, t1290, t1291, t1294;
  double t1295, t1298, t1301, t1307, t1310, t1316, t1336, t1339;
  double t1342, t1346, t1349, t1350, t1355, tv3rho33, t1363, t1370;
  double t1372, t1374, t1375, t1376, t1380, t1384, t1391, t1394;
  double t1397, t1404, t1411, t1415, t1419, t1424, t1426, t1429;
  double t1431, t1432, t1433, t1434, t1435, t1438, t1439, t1441;
  double t1442, t1445, t1460, t1463, t1466, t1469, t1470, t1475;
  double tv3rho2sigma0, tv3rho2sigma1, t1482, t1486, t1488, tv3rho2sigma2, t1494, t1502;
  double tv3rho2sigma3, tv3rho2sigma4, t1508, t1515, t1518, tv3rho2sigma5, t1526, tv3rho2sigma6;
  double tv3rho2sigma7, t1537, t1538, t1539, t1543, t1547, t1554, t1557;
  double t1560, t1567, t1574, t1577, t1584, t1587, t1589, t1592;
  double t1599, t1601, t1604, t1605, t1607, t1608, t1611, t1622;
  double t1625, t1628, t1631, t1632, t1637, tv3rho2sigma8, t1644, t1645;
  double t1646, t1652, t1662, t1669, t1676, t1678, t1680, t1683;
  double t1684, t1685, t1686, t1689, t1694, t1697, t1711, t1714;
  double t1717, t1720, t1723, t1726, t1727, t1732, tv3rhosigma20, tv3rhosigma21;
  double tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1739, t1741, tv3rhosigma25, t1747, tv3rhosigma26;
  double tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1752, t1754, t1757, t1758;
  double t1759, t1760, t1763, t1770, t1775, t1780, t1781, t1787;
  double t1790, t1798, t1805, t1812, t1818, t1821, t1824, t1827;
  double t1830, t1833, t1834, t1839, tv3rhosigma211, t1842, t1859, t1861;
  double t1864, t1865, t1868, t1871, t1884, t1887, t1890, t1891;
  double t1894, t1897, t1898, t1907, t1918, t1921, t1924, t1926;
  double t1927, t1931, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t1933, t1934, t1954, t1956, t1957;
  double t1960, t1963, t1976, t1979, t1982, t1985, t1988, t1989;
  double t1992, t1998, t2009, t2012, t2015, t2017, t2018, t2022;
  double tv3sigma39;

  double t2027, t2031, t2035, t2038, t2042, t2043, t2045, t2046;
  double t2052, t2058, t2059, t2062, t2066, t2075, t2081, t2083;
  double t2089, t2092, t2095, t2098, t2104, t2114, t2115, t2116;
  double t2117, t2118, t2119, t2120, t2124, t2128, t2132, t2137;
  double t2142, t2168, t2175, t2178, t2183, t2190, t2191, t2192;
  double t2193, t2194, t2195, t2196, t2198, t2201, t2202, t2207;
  double t2208, t2211, t2212, t2213, t2216, t2221, t2222, t2225;
  double t2227, t2230, t2233, t2257, t2270, t2285, t2291, t2292;
  double t2293, t2295, t2296, t2302, t2307, t2310, t2314, t2321;
  double t2325, t2329, t2334, t2336, tv4rho40, t2343, t2347, t2348;
  double t2351, t2372, t2373, t2375, t2379, t2388, t2394, t2395;
  double t2397, t2408, t2409, t2426, t2428, t2432, t2439, t2443;
  double t2444, t2447, t2456, t2459, t2460, t2462, t2464, t2465;
  double tv4rho41, t2474, t2478, t2493, t2506, t2510, t2519, t2530;
  double t2531, t2540, t2553, t2557, t2564, t2568, t2577, t2580;
  double t2591, t2594, t2596, t2597, tv4rho42, t2618, t2622, t2629;
  double t2640, t2641, t2658, t2662, t2669, t2677, t2686, t2696;
  double t2698, t2699, tv4rho43, t2704, t2709, t2716, t2720, t2729;
  double t2741, t2742, t2743, t2747, t2751, t2760, t2762, t2763;
  double t2764, t2766, t2769, t2772, t2773, t2783, t2784, t2789;
  double t2793, t2797, t2800, t2806, t2814, t2815, t2816, t2819;
  double t2822, t2826, t2880, t2884, t2890, t2894, t2906, t2907;
  double t2908, t2912, t2916, t2920, t2924, t2930, t2935, t2942;
  double t2946, t2957, t2958, tv4rho44, t2966, t2972, t2975, t2982;
  double t2984, t2987, t3011, t3012, t3013, t3018, t3024, t3026;
  double t3039, t3043, t3050, t3051, t3058, t3062, t3069, t3081;
  double t3097, t3125, t3128, t3140, t3144, t3150, t3159, t3162;
  double t3169, tv4rho3sigma0, tv4rho3sigma1, t3176, t3179, t3183, t3185, tv4rho3sigma2;
  double t3187, t3193, t3198, t3202, t3211, t3212, tv4rho3sigma3, tv4rho3sigma4;
  double t3214, t3220, t3222, t3231, t3233, t3236, tv4rho3sigma5, t3242;
  double t3251, tv4rho3sigma6, tv4rho3sigma7, t3257, t3264, t3272, t3274, t3275;
  double tv4rho3sigma8, t3284, tv4rho3sigma9, tv4rho3sigma10, t3301, t3332, t3346, t3349;
  double t3350, t3359, t3360, t3363, t3364, t3370, t3373, t3380;
  double t3397, t3406, t3407, t3410, t3412, t3416, t3422, t3463;
  double t3470, tv4rho3sigma11, t3477, t3484, t3486, t3490, t3522, t3543;
  double t3549, t3554, t3560, t3564, t3565, t3568, t3569, t3574;
  double t3579, t3597, t3606, t3610, t3614, t3648, t3655, tv4rho2sigma20;
  double tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t3662, t3666, t3668, tv4rho2sigma25;
  double t3674, t3682, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t3688;
  double t3695, t3698, tv4rho2sigma211, t3706, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215;
  double tv4rho2sigma216, t3717, t3750, t3771, t3775, t3783, t3789, t3822;
  double t3825, t3834, t3839, t3846, t3855, t3859, t3862, t3863;
  double t3874, t3881, tv4rho2sigma217, t3888, t3891, t3918, t3938, t3948;
  double t3951, t3982, t3988, t3989, t3992, t3993, t4000, t4001;
  double t4006, t4007, t4012, t4019, t4036, t4043, tv4rhosigma30, tv4rhosigma31;
  double tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t4050;
  double t4052, tv4rhosigma39, t4058, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314;
  double tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t4063, t4093, t4130, t4135;
  double t4141, t4157, t4161, t4162, t4167, t4168, t4175, t4176;
  double t4177, t4182, t4185, t4186, t4209, t4216, tv4rhosigma319, t4218;
  double t4219, t4228, t4232, t4278, t4305, t4316, t4325, t4332;
  double t4338, t4341, t4342, t4360, t4361, t4371, t4377, tv4sigma40;
  double tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48;
  double tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t4378, t4379, t4388;
  double t4392, t4437, t4464, t4475, t4476, t4482, t4485, t4486;
  double t4498, t4499, t4504, t4516, t4521, t4531, t4537, tv4sigma414;

  gga_x_airy_params *params;

  assert(p->params != NULL);
  params = (gga_x_airy_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = t28 * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t33 = t29 / t31;
  t34 = sqrt(sigma[0]);
  t35 = POW_1_3(rho[0]);
  t40 = t33 * t34 / t35 / rho[0] / 0.12e2;
  t41 = pow(t40, params->a2);
  t42 = params->a1 * t41;
  t44 = params->a3 * t41 + 0.1e1;
  t45 = pow(t44, params->a4);
  t46 = 0.1e1 / t45;
  t48 = pow(t40, params->a6);
  t49 = params->a5 * t48;
  t50 = pow(t40, params->a8);
  t51 = params->a7 * t50;
  t52 = 0.1e1 - t49 + t51;
  t53 = pow(t40, params->a10);
  t55 = params->a9 * t53 + 0.1e1;
  t56 = 0.1e1 / t55;
  t58 = t42 * t46 + t52 * t56;
  t62 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t58);
  t63 = rho[1] <= p->dens_threshold;
  t64 = -t16;
  t66 = my_piecewise5(t14, t11, t10, t15, t64 * t7);
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = POW_1_3(t67);
  t71 = my_piecewise3(t68, t22, t69 * t67);
  t72 = t71 * t26;
  t73 = sqrt(sigma[2]);
  t74 = POW_1_3(rho[1]);
  t79 = t33 * t73 / t74 / rho[1] / 0.12e2;
  t80 = pow(t79, params->a2);
  t81 = params->a1 * t80;
  t83 = params->a3 * t80 + 0.1e1;
  t84 = pow(t83, params->a4);
  t85 = 0.1e1 / t84;
  t87 = pow(t79, params->a6);
  t88 = params->a5 * t87;
  t89 = pow(t79, params->a8);
  t90 = params->a7 * t89;
  t91 = 0.1e1 - t88 + t90;
  t92 = pow(t79, params->a10);
  t94 = params->a9 * t92 + 0.1e1;
  t95 = 0.1e1 / t94;
  t97 = t81 * t85 + t91 * t95;
  t101 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t97);
  tzk0 = t62 + t101;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t102 = t6 * t6;
  t103 = 0.1e1 / t102;
  t104 = t16 * t103;
  t106 = my_piecewise5(t10, 0, t14, 0, t7 - t104);
  t109 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t106);
  t110 = t109 * t26;
  t114 = t26 * t26;
  t115 = 0.1e1 / t114;
  t116 = t25 * t115;
  t119 = t5 * t116 * t58 / 0.8e1;
  t120 = 0.1e1 / rho[0];
  t125 = t41 * t41;
  t126 = params->a1 * t125;
  t127 = t46 * params->a4;
  t128 = t126 * t127;
  t129 = params->a3 * params->a2;
  t130 = 0.1e1 / t44;
  t140 = 0.4e1 / 0.3e1 * t49 * params->a6 * t120 - 0.4e1 / 0.3e1 * t51 * params->a8 * t120;
  t142 = t55 * t55;
  t143 = 0.1e1 / t142;
  t145 = t52 * t143 * params->a9;
  t146 = t53 * params->a10;
  t147 = t146 * t120;
  t150 = -0.4e1 / 0.3e1 * t42 * params->a2 * t120 * t46 + 0.4e1 / 0.3e1 * t128 * t129 * t120 * t130 + t140 * t56 + 0.4e1 / 0.3e1 * t145 * t147;
  t155 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t58 - t119 - 0.3e1 / 0.8e1 * t5 * t27 * t150);
  t156 = t64 * t103;
  t158 = my_piecewise5(t14, 0, t10, 0, -t7 - t156);
  t161 = my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t158);
  t162 = t161 * t26;
  t166 = t71 * t115;
  t169 = t5 * t166 * t97 / 0.8e1;
  t171 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t97 - t169);
  tvrho0 = t62 + t101 + t6 * (t155 + t171);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t175 = my_piecewise5(t10, 0, t14, 0, -t7 - t104);
  t178 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t175);
  t179 = t178 * t26;
  t184 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t58 - t119);
  t186 = my_piecewise5(t14, 0, t10, 0, t7 - t156);
  t189 = my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t186);
  t190 = t189 * t26;
  t194 = 0.1e1 / rho[1];
  t199 = t80 * t80;
  t200 = params->a1 * t199;
  t201 = t85 * params->a4;
  t202 = t200 * t201;
  t203 = 0.1e1 / t83;
  t213 = 0.4e1 / 0.3e1 * t88 * params->a6 * t194 - 0.4e1 / 0.3e1 * t90 * params->a8 * t194;
  t215 = t94 * t94;
  t216 = 0.1e1 / t215;
  t218 = t91 * t216 * params->a9;
  t219 = t92 * params->a10;
  t220 = t219 * t194;
  t223 = -0.4e1 / 0.3e1 * t81 * params->a2 * t194 * t85 + 0.4e1 / 0.3e1 * t202 * t129 * t194 * t203 + t213 * t95 + 0.4e1 / 0.3e1 * t218 * t220;
  t228 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t97 - t169 - 0.3e1 / 0.8e1 * t5 * t72 * t223);
  tvrho1 = t62 + t101 + t6 * (t184 + t228);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t231 = 0.1e1 / sigma[0];
  t245 = -t49 * params->a6 * t231 / 0.2e1 + t51 * params->a8 * t231 / 0.2e1;
  t247 = t146 * t231;
  t250 = t42 * params->a2 * t231 * t46 / 0.2e1 - t128 * t129 * t231 * t130 / 0.2e1 + t245 * t56 - t145 * t247 / 0.2e1;
  t254 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t250);
  tvsigma0 = t6 * t254;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t255 = 0.1e1 / sigma[2];
  t269 = -t88 * params->a6 * t255 / 0.2e1 + t90 * params->a8 * t255 / 0.2e1;
  t271 = t219 * t255;
  t274 = t81 * params->a2 * t255 * t85 / 0.2e1 - t202 * t129 * t255 * t203 / 0.2e1 + t269 * t95 - t218 * t271 / 0.2e1;
  t278 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t274);
  tvsigma2 = t6 * t278;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t281 = t23 * t23;
  t282 = 0.1e1 / t281;
  t283 = t106 * t106;
  t286 = t102 * t6;
  t287 = 0.1e1 / t286;
  t288 = t16 * t287;
  t291 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t103 + 0.2e1 * t288);
  t295 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t282 * t283 + 0.4e1 / 0.3e1 * t23 * t291);
  t296 = t295 * t26;
  t300 = t109 * t115;
  t302 = t5 * t300 * t58;
  t308 = 0.1e1 / t114 / t6;
  t309 = t25 * t308;
  t312 = t5 * t309 * t58 / 0.12e2;
  t314 = t5 * t116 * t150;
  t316 = params->a2 * params->a2;
  t317 = rho[0] * rho[0];
  t318 = 0.1e1 / t317;
  t319 = t316 * t318;
  t329 = t127 * params->a3 * t130;
  t333 = params->a1 * t125 * t41;
  t334 = params->a4 * params->a4;
  t335 = t46 * t334;
  t336 = t333 * t335;
  t337 = params->a3 * params->a3;
  t338 = t337 * t316;
  t339 = t44 * t44;
  t340 = 0.1e1 / t339;
  t342 = t338 * t318 * t340;
  t349 = t333 * t127;
  t352 = params->a6 * params->a6;
  t353 = t352 * t318;
  t359 = params->a8 * params->a8;
  t360 = t359 * t318;
  t366 = -0.16e2 / 0.9e1 * t49 * t353 - 0.4e1 / 0.3e1 * t49 * params->a6 * t318 + 0.16e2 / 0.9e1 * t51 * t360 + 0.4e1 / 0.3e1 * t51 * params->a8 * t318;
  t369 = t140 * t143 * params->a9;
  t373 = 0.1e1 / t142 / t55;
  t375 = params->a9 * params->a9;
  t376 = t52 * t373 * t375;
  t377 = t53 * t53;
  t378 = params->a10 * params->a10;
  t379 = t377 * t378;
  t380 = t379 * t318;
  t383 = t53 * t378;
  t384 = t383 * t318;
  t387 = t146 * t318;
  t390 = 0.16e2 / 0.9e1 * t42 * t319 * t46 + 0.4e1 / 0.3e1 * t42 * params->a2 * t318 * t46 - 0.16e2 / 0.3e1 * t126 * t319 * t329 + 0.16e2 / 0.9e1 * t336 * t342 - 0.4e1 / 0.3e1 * t128 * t129 * t318 * t130 + 0.16e2 / 0.9e1 * t349 * t342 + t366 * t56 + 0.8e1 / 0.3e1 * t369 * t147 + 0.32e2 / 0.9e1 * t376 * t380 - 0.16e2 / 0.9e1 * t145 * t384 - 0.4e1 / 0.3e1 * t145 * t387;
  t395 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t296 * t58 - t302 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t110 * t150 + t312 - t314 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t390);
  t396 = t69 * t69;
  t397 = 0.1e1 / t396;
  t398 = t158 * t158;
  t401 = t64 * t287;
  t404 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t103 + 0.2e1 * t401);
  t408 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t397 * t398 + 0.4e1 / 0.3e1 * t69 * t404);
  t409 = t408 * t26;
  t413 = t161 * t115;
  t415 = t5 * t413 * t97;
  t417 = t71 * t308;
  t420 = t5 * t417 * t97 / 0.12e2;
  t422 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t409 * t97 - t415 / 0.4e1 + t420);
  tv2rho20 = 0.2e1 * t155 + 0.2e1 * t171 + t6 * (t395 + t422);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t425 = t282 * t175;
  t429 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t288);
  t433 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t425 * t106 + 0.4e1 / 0.3e1 * t23 * t429);
  t434 = t433 * t26;
  t438 = t178 * t115;
  t440 = t5 * t438 * t58;
  t448 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t434 * t58 - t440 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t179 * t150 - t302 / 0.8e1 + t312 - t314 / 0.8e1);
  t449 = t397 * t186;
  t453 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t401);
  t457 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t449 * t158 + 0.4e1 / 0.3e1 * t69 * t453);
  t458 = t457 * t26;
  t462 = t189 * t115;
  t464 = t5 * t462 * t97;
  t471 = t5 * t166 * t223;
  t474 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t458 * t97 - t464 / 0.8e1 - t415 / 0.8e1 + t420 - 0.3e1 / 0.8e1 * t5 * t162 * t223 - t471 / 0.8e1);
  tv2rho21 = t155 + t171 + t184 + t228 + t6 * (t448 + t474);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t479 = t175 * t175;
  t484 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t103 + 0.2e1 * t288);
  t488 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t282 * t479 + 0.4e1 / 0.3e1 * t23 * t484);
  t489 = t488 * t26;
  t495 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t489 * t58 - t440 / 0.4e1 + t312);
  t496 = t186 * t186;
  t501 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t103 + 0.2e1 * t401);
  t505 = my_piecewise3(t68, 0, 0.4e1 / 0.9e1 * t397 * t496 + 0.4e1 / 0.3e1 * t69 * t501);
  t506 = t505 * t26;
  t515 = rho[1] * rho[1];
  t516 = 0.1e1 / t515;
  t517 = t316 * t516;
  t527 = t201 * params->a3 * t203;
  t531 = params->a1 * t199 * t80;
  t532 = t85 * t334;
  t533 = t531 * t532;
  t534 = t83 * t83;
  t535 = 0.1e1 / t534;
  t537 = t338 * t516 * t535;
  t544 = t531 * t201;
  t547 = t352 * t516;
  t553 = t359 * t516;
  t559 = -0.16e2 / 0.9e1 * t88 * t547 - 0.4e1 / 0.3e1 * t88 * params->a6 * t516 + 0.16e2 / 0.9e1 * t90 * t553 + 0.4e1 / 0.3e1 * t90 * params->a8 * t516;
  t562 = t213 * t216 * params->a9;
  t566 = 0.1e1 / t215 / t94;
  t568 = t91 * t566 * t375;
  t569 = t92 * t92;
  t570 = t569 * t378;
  t571 = t570 * t516;
  t574 = t92 * t378;
  t575 = t574 * t516;
  t578 = t219 * t516;
  t581 = 0.16e2 / 0.9e1 * t81 * t517 * t85 + 0.4e1 / 0.3e1 * t81 * params->a2 * t516 * t85 - 0.16e2 / 0.3e1 * t200 * t517 * t527 + 0.16e2 / 0.9e1 * t533 * t537 - 0.4e1 / 0.3e1 * t202 * t129 * t516 * t203 + 0.16e2 / 0.9e1 * t544 * t537 + t559 * t95 + 0.8e1 / 0.3e1 * t562 * t220 + 0.32e2 / 0.9e1 * t568 * t571 - 0.16e2 / 0.9e1 * t218 * t575 - 0.4e1 / 0.3e1 * t218 * t578;
  t586 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t506 * t97 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t190 * t223 + t420 - t471 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t72 * t581);
  tv2rho22 = 0.2e1 * t184 + 0.2e1 * t228 + t6 * (t495 + t586);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t594 = t5 * t116 * t250 / 0.8e1;
  t595 = t42 * t316;
  t596 = t120 * t231;
  t601 = t126 * t316 * t231;
  t604 = t127 * params->a3 * t120 * t130;
  t607 = t231 * t340;
  t609 = t338 * t607 * t120;
  t614 = t352 * t120;
  t617 = t359 * t120;
  t621 = 0.2e1 / 0.3e1 * t49 * t614 * t231 - 0.2e1 / 0.3e1 * t51 * t617 * t231;
  t624 = t245 * t143 * params->a9;
  t629 = t379 * t596;
  t632 = t383 * t596;
  t635 = -0.2e1 / 0.3e1 * t595 * t596 * t46 + 0.2e1 * t601 * t604 - 0.2e1 / 0.3e1 * t336 * t609 - 0.2e1 / 0.3e1 * t349 * t609 + t621 * t56 + 0.4e1 / 0.3e1 * t624 * t147 - t369 * t247 / 0.2e1 - 0.4e1 / 0.3e1 * t376 * t629 + 0.2e1 / 0.3e1 * t145 * t632;
  t640 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t250 - t594 - 0.3e1 / 0.8e1 * t5 * t27 * t635);
  tv2rhosigma0 = t6 * t640 + t254;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t647 = t5 * t166 * t274 / 0.8e1;
  t649 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t274 - t647);
  tv2rhosigma2 = t6 * t649 + t278;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t655 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t250 - t594);
  tv2rhosigma3 = t6 * t655 + t254;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t660 = t81 * t316;
  t661 = t194 * t255;
  t666 = t200 * t316 * t255;
  t669 = t201 * params->a3 * t194 * t203;
  t672 = t255 * t535;
  t674 = t338 * t672 * t194;
  t679 = t352 * t194;
  t682 = t359 * t194;
  t686 = 0.2e1 / 0.3e1 * t88 * t679 * t255 - 0.2e1 / 0.3e1 * t90 * t682 * t255;
  t689 = t269 * t216 * params->a9;
  t694 = t570 * t661;
  t697 = t574 * t661;
  t700 = -0.2e1 / 0.3e1 * t660 * t661 * t85 + 0.2e1 * t666 * t669 - 0.2e1 / 0.3e1 * t533 * t674 - 0.2e1 / 0.3e1 * t544 * t674 + t686 * t95 + 0.4e1 / 0.3e1 * t689 * t220 - t562 * t271 / 0.2e1 - 0.4e1 / 0.3e1 * t568 * t694 + 0.2e1 / 0.3e1 * t218 * t697;
  t705 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t274 - t647 - 0.3e1 / 0.8e1 * t5 * t72 * t700);
  tv2rhosigma5 = t6 * t705 + t278;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t707 = sigma[0] * sigma[0];
  t708 = 0.1e1 / t707;
  t709 = t316 * t708;
  t717 = t126 * t709;
  t720 = t708 * t340;
  t721 = t338 * t720;
  t742 = -t49 * t352 * t708 / 0.4e1 + t49 * params->a6 * t708 / 0.2e1 + t51 * t359 * t708 / 0.4e1 - t51 * params->a8 * t708 / 0.2e1;
  t745 = t379 * t708;
  t748 = t383 * t708;
  t751 = t146 * t708;
  t754 = t42 * t709 * t46 / 0.4e1 - t42 * params->a2 * t708 * t46 / 0.2e1 - 0.3e1 / 0.4e1 * t717 * t329 + t336 * t721 / 0.4e1 + t128 * t129 * t708 * t130 / 0.2e1 + t349 * t721 / 0.4e1 + t742 * t56 - t624 * t247 + t376 * t745 / 0.2e1 - t145 * t748 / 0.4e1 + t145 * t751 / 0.2e1;
  t758 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t754);
  tv2sigma20 = t6 * t758;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t759 = sigma[2] * sigma[2];
  t760 = 0.1e1 / t759;
  t761 = t316 * t760;
  t769 = t200 * t761;
  t772 = t760 * t535;
  t773 = t338 * t772;
  t794 = -t88 * t352 * t760 / 0.4e1 + t88 * params->a6 * t760 / 0.2e1 + t90 * t359 * t760 / 0.4e1 - t90 * params->a8 * t760 / 0.2e1;
  t797 = t570 * t760;
  t800 = t574 * t760;
  t803 = t219 * t760;
  t806 = t81 * t761 * t85 / 0.4e1 - t81 * params->a2 * t760 * t85 / 0.2e1 - 0.3e1 / 0.4e1 * t769 * t527 + t533 * t773 / 0.4e1 + t202 * t129 * t760 * t203 / 0.2e1 + t544 * t773 / 0.4e1 + t794 * t95 - t689 * t271 + t568 * t797 / 0.2e1 - t218 * t800 / 0.4e1 + t218 * t803 / 0.2e1;
  t810 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t806);
  tv2sigma25 = t6 * t810;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t814 = 0.1e1 / t281 / t19;
  t815 = t283 * t106;
  t818 = t282 * t106;
  t821 = t102 * t102;
  t822 = 0.1e1 / t821;
  t823 = t16 * t822;
  t826 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t287 - 0.6e1 * t823);
  t830 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t814 * t815 + 0.4e1 / 0.3e1 * t818 * t291 + 0.4e1 / 0.3e1 * t23 * t826);
  t831 = t830 * t26;
  t835 = t295 * t115;
  t837 = t5 * t835 * t58;
  t842 = t109 * t308;
  t844 = t5 * t842 * t58;
  t847 = t5 * t300 * t150;
  t853 = 0.1e1 / t114 / t102;
  t854 = t25 * t853;
  t857 = 0.5e1 / 0.36e2 * t5 * t854 * t58;
  t859 = t5 * t309 * t150;
  t862 = t5 * t116 * t390;
  t864 = t352 * params->a6;
  t866 = 0.1e1 / t317 / rho[0];
  t867 = t864 * t866;
  t870 = t352 * t866;
  t876 = t359 * params->a8;
  t877 = t876 * t866;
  t880 = t359 * t866;
  t886 = 0.64e2 / 0.27e2 * t49 * t867 + 0.16e2 / 0.3e1 * t49 * t870 + 0.8e1 / 0.3e1 * t49 * params->a6 * t866 - 0.64e2 / 0.27e2 * t51 * t877 - 0.16e2 / 0.3e1 * t51 * t880 - 0.8e1 / 0.3e1 * t51 * params->a8 * t866;
  t888 = t316 * params->a2;
  t889 = t888 * t866;
  t893 = t316 * t866;
  t897 = t333 * t889;
  t898 = t337 * t340;
  t899 = t335 * t898;
  t902 = t127 * t898;
  t905 = t125 * t125;
  t906 = params->a1 * t905;
  t907 = t334 * params->a4;
  t908 = t46 * t907;
  t909 = t906 * t908;
  t910 = t337 * params->a3;
  t911 = t910 * t888;
  t913 = 0.1e1 / t339 / t44;
  t915 = t911 * t866 * t913;
  t918 = t906 * t335;
  t922 = t338 * t866 * t340;
  t925 = t906 * t127;
  t937 = t886 * t56 - 0.64e2 / 0.27e2 * t42 * t889 * t46 + 0.16e2 * t126 * t893 * t329 - 0.128e3 / 0.9e1 * t897 * t899 - 0.128e3 / 0.9e1 * t897 * t902 + 0.64e2 / 0.27e2 * t909 * t915 + 0.64e2 / 0.9e1 * t918 * t915 - 0.16e2 / 0.3e1 * t349 * t922 + 0.128e3 / 0.27e2 * t925 * t915 + 0.448e3 / 0.27e2 * t126 * t889 * t329 - 0.16e2 / 0.3e1 * t336 * t922 + 0.8e1 / 0.3e1 * t128 * t129 * t866 * t130;
  t940 = t379 * t866;
  t943 = t383 * t866;
  t946 = t146 * t866;
  t957 = t366 * t143 * params->a9;
  t961 = t140 * t373 * t375;
  t966 = t142 * t142;
  t967 = 0.1e1 / t966;
  t969 = t375 * params->a9;
  t970 = t52 * t967 * t969;
  t971 = t377 * t53;
  t972 = t378 * params->a10;
  t973 = t971 * t972;
  t974 = t973 * t866;
  t977 = t377 * t972;
  t978 = t977 * t866;
  t981 = t53 * t972;
  t982 = t981 * t866;
  t985 = -0.4e1 * t369 * t387 - 0.32e2 / 0.3e1 * t376 * t940 + 0.16e2 / 0.3e1 * t145 * t943 + 0.8e1 / 0.3e1 * t145 * t946 - 0.16e2 / 0.3e1 * t42 * t893 * t46 - 0.8e1 / 0.3e1 * t42 * params->a2 * t866 * t46 + 0.4e1 * t957 * t147 + 0.32e2 / 0.3e1 * t961 * t380 - 0.16e2 / 0.3e1 * t369 * t384 + 0.128e3 / 0.9e1 * t970 * t974 - 0.128e3 / 0.9e1 * t376 * t978 + 0.64e2 / 0.27e2 * t145 * t982;
  t986 = t937 + t985;
  t991 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t831 * t58 - 0.3e1 / 0.8e1 * t837 - 0.9e1 / 0.8e1 * t5 * t296 * t150 + t844 / 0.4e1 - 0.3e1 / 0.4e1 * t847 - 0.9e1 / 0.8e1 * t5 * t110 * t390 - t857 + t859 / 0.4e1 - 0.3e1 / 0.8e1 * t862 - 0.3e1 / 0.8e1 * t5 * t27 * t986);
  t993 = 0.1e1 / t396 / t67;
  t994 = t398 * t158;
  t997 = t397 * t158;
  t1000 = t64 * t822;
  t1003 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t287 - 0.6e1 * t1000);
  t1007 = my_piecewise3(t68, 0, -0.8e1 / 0.27e2 * t993 * t994 + 0.4e1 / 0.3e1 * t997 * t404 + 0.4e1 / 0.3e1 * t69 * t1003);
  t1008 = t1007 * t26;
  t1012 = t408 * t115;
  t1014 = t5 * t1012 * t97;
  t1016 = t161 * t308;
  t1018 = t5 * t1016 * t97;
  t1020 = t71 * t853;
  t1023 = 0.5e1 / 0.36e2 * t5 * t1020 * t97;
  t1025 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1008 * t97 - 0.3e1 / 0.8e1 * t1014 + t1018 / 0.4e1 - t1023);
  tv3rho30 = 0.3e1 * t395 + 0.3e1 * t422 + t6 * (t991 + t1025);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1028 = 0.2e1 * t448;
  t1029 = 0.2e1 * t474;
  t1030 = t814 * t175;
  t1033 = t282 * t429;
  t1038 = 0.2e1 * t287;
  t1039 = 0.6e1 * t823;
  t1041 = my_piecewise5(t10, 0, t14, 0, t1038 - t1039);
  t1045 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t1030 * t283 + 0.8e1 / 0.9e1 * t1033 * t106 + 0.4e1 / 0.9e1 * t425 * t291 + 0.4e1 / 0.3e1 * t23 * t1041);
  t1046 = t1045 * t26;
  t1050 = t433 * t115;
  t1053 = t5 * t1050 * t58 / 0.4e1;
  t1057 = t178 * t308;
  t1059 = t5 * t1057 * t58;
  t1063 = t5 * t438 * t150 / 0.4e1;
  t1072 = -0.3e1 / 0.8e1 * t5 * t1046 * t58 - t1053 - 0.3e1 / 0.4e1 * t5 * t434 * t150 + t1059 / 0.12e2 - t1063 - 0.3e1 / 0.8e1 * t5 * t179 * t390 - t837 / 0.8e1 + t844 / 0.6e1 - t847 / 0.4e1 - t857 + t859 / 0.6e1 - t862 / 0.8e1;
  t1073 = my_piecewise3(t1, 0, t1072);
  t1074 = t993 * t186;
  t1077 = t397 * t453;
  t1082 = 0.6e1 * t1000;
  t1084 = my_piecewise5(t14, 0, t10, 0, -t1038 - t1082);
  t1088 = my_piecewise3(t68, 0, -0.8e1 / 0.27e2 * t1074 * t398 + 0.8e1 / 0.9e1 * t1077 * t158 + 0.4e1 / 0.9e1 * t449 * t404 + 0.4e1 / 0.3e1 * t69 * t1084);
  t1089 = t1088 * t26;
  t1093 = t457 * t115;
  t1096 = t5 * t1093 * t97 / 0.4e1;
  t1097 = t189 * t308;
  t1099 = t5 * t1097 * t97;
  t1108 = t5 * t413 * t223 / 0.4e1;
  t1110 = t5 * t417 * t223;
  t1113 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1089 * t97 - t1096 + t1099 / 0.12e2 - t1014 / 0.8e1 + t1018 / 0.6e1 - t1023 - 0.3e1 / 0.8e1 * t5 * t409 * t223 - t1108 + t1110 / 0.12e2);
  tv3rho31 = t395 + t422 + t1028 + t1029 + t6 * (t1073 + t1113);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1116 = t814 * t479;
  t1121 = t282 * t484;
  t1125 = my_piecewise5(t10, 0, t14, 0, -t1038 - t1039);
  t1129 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t1116 * t106 + 0.8e1 / 0.9e1 * t425 * t429 + 0.4e1 / 0.9e1 * t1121 * t106 + 0.4e1 / 0.3e1 * t23 * t1125);
  t1130 = t1129 * t26;
  t1134 = t488 * t115;
  t1136 = t5 * t1134 * t58;
  t1145 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1130 * t58 - t1136 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t489 * t150 - t1053 + t1059 / 0.6e1 - t1063 + t844 / 0.12e2 - t857 + t859 / 0.12e2);
  t1146 = t993 * t496;
  t1151 = t397 * t501;
  t1155 = my_piecewise5(t14, 0, t10, 0, t1038 - t1082);
  t1159 = my_piecewise3(t68, 0, -0.8e1 / 0.27e2 * t1146 * t158 + 0.8e1 / 0.9e1 * t449 * t453 + 0.4e1 / 0.9e1 * t1151 * t158 + 0.4e1 / 0.3e1 * t69 * t1155);
  t1160 = t1159 * t26;
  t1164 = t505 * t115;
  t1166 = t5 * t1164 * t97;
  t1173 = t5 * t462 * t223;
  t1181 = t5 * t166 * t581;
  t1183 = -0.3e1 / 0.8e1 * t5 * t1160 * t97 - t1166 / 0.8e1 - t1096 + t1099 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t458 * t223 - t1173 / 0.4e1 + t1018 / 0.12e2 - t1023 - t1108 + t1110 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t162 * t581 - t1181 / 0.8e1;
  t1184 = my_piecewise3(t63, 0, t1183);
  tv3rho32 = t1028 + t1029 + t495 + t586 + t6 * (t1145 + t1184);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1189 = t479 * t175;
  t1196 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t287 - 0.6e1 * t823);
  t1200 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t814 * t1189 + 0.4e1 / 0.3e1 * t425 * t484 + 0.4e1 / 0.3e1 * t23 * t1196);
  t1201 = t1200 * t26;
  t1208 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1201 * t58 - 0.3e1 / 0.8e1 * t1136 + t1059 / 0.4e1 - t857);
  t1209 = t496 * t186;
  t1216 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t287 - 0.6e1 * t1000);
  t1220 = my_piecewise3(t68, 0, -0.8e1 / 0.27e2 * t993 * t1209 + 0.4e1 / 0.3e1 * t449 * t501 + 0.4e1 / 0.3e1 * t69 * t1216);
  t1221 = t1220 * t26;
  t1237 = t213 * t566 * t375;
  t1242 = t215 * t215;
  t1243 = 0.1e1 / t1242;
  t1245 = t91 * t1243 * t969;
  t1246 = t569 * t92;
  t1247 = t1246 * t972;
  t1249 = 0.1e1 / t515 / rho[1];
  t1250 = t1247 * t1249;
  t1253 = t569 * t972;
  t1254 = t1253 * t1249;
  t1257 = t92 * t972;
  t1258 = t1257 * t1249;
  t1262 = t338 * t1249 * t535;
  t1265 = t199 * t199;
  t1266 = params->a1 * t1265;
  t1267 = t1266 * t201;
  t1269 = 0.1e1 / t534 / t83;
  t1271 = t911 * t1249 * t1269;
  t1274 = t888 * t1249;
  t1278 = t316 * t1249;
  t1282 = t531 * t1274;
  t1283 = t337 * t535;
  t1284 = t532 * t1283;
  t1287 = t201 * t1283;
  t1290 = t85 * t907;
  t1291 = t1266 * t1290;
  t1294 = 0.32e2 / 0.3e1 * t1237 * t571 - 0.16e2 / 0.3e1 * t562 * t575 + 0.128e3 / 0.9e1 * t1245 * t1250 - 0.128e3 / 0.9e1 * t568 * t1254 + 0.64e2 / 0.27e2 * t218 * t1258 - 0.16e2 / 0.3e1 * t544 * t1262 + 0.128e3 / 0.27e2 * t1267 * t1271 + 0.448e3 / 0.27e2 * t200 * t1274 * t527 + 0.16e2 * t200 * t1278 * t527 - 0.128e3 / 0.9e1 * t1282 * t1284 - 0.128e3 / 0.9e1 * t1282 * t1287 + 0.64e2 / 0.27e2 * t1291 * t1271;
  t1295 = t1266 * t532;
  t1298 = t864 * t1249;
  t1301 = t352 * t1249;
  t1307 = t876 * t1249;
  t1310 = t359 * t1249;
  t1316 = 0.64e2 / 0.27e2 * t88 * t1298 + 0.16e2 / 0.3e1 * t88 * t1301 + 0.8e1 / 0.3e1 * t88 * params->a6 * t1249 - 0.64e2 / 0.27e2 * t90 * t1307 - 0.16e2 / 0.3e1 * t90 * t1310 - 0.8e1 / 0.3e1 * t90 * params->a8 * t1249;
  t1336 = t570 * t1249;
  t1339 = t574 * t1249;
  t1342 = t219 * t1249;
  t1346 = t559 * t216 * params->a9;
  t1349 = 0.64e2 / 0.9e1 * t1295 * t1271 + t1316 * t95 - 0.64e2 / 0.27e2 * t81 * t1274 * t85 - 0.16e2 / 0.3e1 * t533 * t1262 + 0.8e1 / 0.3e1 * t202 * t129 * t1249 * t203 - 0.16e2 / 0.3e1 * t81 * t1278 * t85 - 0.8e1 / 0.3e1 * t81 * params->a2 * t1249 * t85 - 0.4e1 * t562 * t578 - 0.32e2 / 0.3e1 * t568 * t1336 + 0.16e2 / 0.3e1 * t218 * t1339 + 0.8e1 / 0.3e1 * t218 * t1342 + 0.4e1 * t1346 * t220;
  t1350 = t1294 + t1349;
  t1355 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1221 * t97 - 0.3e1 / 0.8e1 * t1166 - 0.9e1 / 0.8e1 * t5 * t506 * t223 + t1099 / 0.4e1 - 0.3e1 / 0.4e1 * t1173 - 0.9e1 / 0.8e1 * t5 * t190 * t581 - t1023 + t1110 / 0.4e1 - 0.3e1 / 0.8e1 * t1181 - 0.3e1 / 0.8e1 * t5 * t72 * t1350);
  tv3rho33 = 0.3e1 * t495 + 0.3e1 * t586 + t6 * (t1208 + t1355);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1363 = t5 * t300 * t250;
  t1370 = t5 * t309 * t250 / 0.12e2;
  t1372 = t5 * t116 * t635;
  t1374 = t42 * t888;
  t1375 = t318 * t231;
  t1376 = t1375 * t46;
  t1380 = t621 * t143 * params->a9;
  t1384 = t245 * t373 * t375;
  t1391 = t379 * t1375;
  t1394 = t383 * t1375;
  t1397 = t864 * t318;
  t1404 = t876 * t318;
  t1411 = -0.8e1 / 0.9e1 * t49 * t1397 * t231 - 0.2e1 / 0.3e1 * t49 * t353 * t231 + 0.8e1 / 0.9e1 * t51 * t1404 * t231 + 0.2e1 / 0.3e1 * t51 * t360 * t231;
  t1415 = t127 * params->a3 * t318 * t130;
  t1419 = t338 * t607 * t318;
  t1424 = t231 * t913;
  t1426 = t911 * t1424 * t318;
  t1429 = 0.8e1 / 0.9e1 * t1374 * t1376 + 0.8e1 / 0.3e1 * t1380 * t147 + 0.32e2 / 0.9e1 * t1384 * t380 - 0.16e2 / 0.9e1 * t624 * t384 - t957 * t247 / 0.2e1 + 0.4e1 / 0.3e1 * t376 * t1391 - 0.2e1 / 0.3e1 * t145 * t1394 + t1411 * t56 - 0.2e1 * t601 * t1415 + 0.2e1 / 0.3e1 * t336 * t1419 + 0.2e1 / 0.3e1 * t349 * t1419 - 0.16e2 / 0.9e1 * t925 * t1426;
  t1431 = t126 * t888 * t318;
  t1432 = t231 * t46;
  t1433 = params->a4 * params->a3;
  t1434 = t1433 * t130;
  t1435 = t1432 * t1434;
  t1438 = t888 * t231;
  t1439 = t333 * t1438;
  t1441 = t337 * t318 * t340;
  t1442 = t335 * t1441;
  t1445 = t127 * t1441;
  t1460 = t973 * t1375;
  t1463 = t977 * t1375;
  t1466 = t981 * t1375;
  t1469 = -0.56e2 / 0.9e1 * t1431 * t1435 + 0.16e2 / 0.3e1 * t1439 * t1442 + 0.16e2 / 0.3e1 * t1439 * t1445 - 0.8e1 / 0.9e1 * t909 * t1426 - 0.8e1 / 0.3e1 * t918 * t1426 + 0.2e1 / 0.3e1 * t595 * t1376 - 0.4e1 / 0.3e1 * t624 * t387 - 0.8e1 / 0.3e1 * t961 * t629 + 0.4e1 / 0.3e1 * t369 * t632 - 0.16e2 / 0.3e1 * t970 * t1460 + 0.16e2 / 0.3e1 * t376 * t1463 - 0.8e1 / 0.9e1 * t145 * t1466;
  t1470 = t1429 + t1469;
  t1475 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t296 * t250 - t1363 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t110 * t635 + t1370 - t1372 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t1470);
  tv3rho2sigma0 = t6 * t1475 + 0.2e1 * t640;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1482 = t5 * t413 * t274;
  t1486 = t5 * t417 * t274 / 0.12e2;
  t1488 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t409 * t274 - t1482 / 0.4e1 + t1486);
  tv3rho2sigma2 = t6 * t1488 + 0.2e1 * t649;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1494 = t5 * t438 * t250;
  t1502 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t434 * t250 - t1494 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t179 * t635 - t1363 / 0.8e1 + t1370 - t1372 / 0.8e1);
  tv3rho2sigma3 = t6 * t1502 + t640 + t655;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1508 = t5 * t462 * t274;
  t1515 = t5 * t166 * t700;
  t1518 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t458 * t274 - t1508 / 0.8e1 - t1482 / 0.8e1 + t1486 - 0.3e1 / 0.8e1 * t5 * t162 * t700 - t1515 / 0.8e1);
  tv3rho2sigma5 = t6 * t1518 + t649 + t705;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1526 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t489 * t250 - t1494 / 0.4e1 + t1370);
  tv3rho2sigma6 = t6 * t1526 + 0.2e1 * t655;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1537 = t81 * t888;
  t1538 = t516 * t255;
  t1539 = t1538 * t85;
  t1543 = t686 * t216 * params->a9;
  t1547 = t269 * t566 * t375;
  t1554 = t570 * t1538;
  t1557 = t574 * t1538;
  t1560 = t864 * t516;
  t1567 = t876 * t516;
  t1574 = -0.8e1 / 0.9e1 * t88 * t1560 * t255 - 0.2e1 / 0.3e1 * t88 * t547 * t255 + 0.8e1 / 0.9e1 * t90 * t1567 * t255 + 0.2e1 / 0.3e1 * t90 * t553 * t255;
  t1577 = t338 * t672 * t516;
  t1584 = t201 * params->a3 * t516 * t203;
  t1587 = t255 * t1269;
  t1589 = t911 * t1587 * t516;
  t1592 = 0.8e1 / 0.9e1 * t1537 * t1539 + 0.8e1 / 0.3e1 * t1543 * t220 + 0.32e2 / 0.9e1 * t1547 * t571 - 0.16e2 / 0.9e1 * t689 * t575 - t1346 * t271 / 0.2e1 + 0.4e1 / 0.3e1 * t568 * t1554 - 0.2e1 / 0.3e1 * t218 * t1557 + t1574 * t95 + 0.2e1 / 0.3e1 * t533 * t1577 + 0.2e1 / 0.3e1 * t544 * t1577 - 0.2e1 * t666 * t1584 - 0.8e1 / 0.9e1 * t1291 * t1589;
  t1599 = t255 * t85;
  t1601 = t1599 * t1433 * t203;
  t1604 = t888 * t255;
  t1605 = t531 * t1604;
  t1607 = t337 * t516 * t535;
  t1608 = t532 * t1607;
  t1611 = t201 * t1607;
  t1622 = t1247 * t1538;
  t1625 = t1253 * t1538;
  t1628 = t1257 * t1538;
  t1631 = -0.8e1 / 0.3e1 * t1295 * t1589 - 0.16e2 / 0.9e1 * t1267 * t1589 - 0.56e2 / 0.9e1 * t200 * t888 * t516 * t1601 + 0.16e2 / 0.3e1 * t1605 * t1608 + 0.16e2 / 0.3e1 * t1605 * t1611 + 0.2e1 / 0.3e1 * t660 * t1539 - 0.4e1 / 0.3e1 * t689 * t578 - 0.8e1 / 0.3e1 * t1237 * t694 + 0.4e1 / 0.3e1 * t562 * t697 - 0.16e2 / 0.3e1 * t1245 * t1622 + 0.16e2 / 0.3e1 * t568 * t1625 - 0.8e1 / 0.9e1 * t218 * t1628;
  t1632 = t1592 + t1631;
  t1637 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t506 * t274 - t1508 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t190 * t700 + t1486 - t1515 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t72 * t1632);
  tv3rho2sigma8 = t6 * t1637 + 0.2e1 * t705;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1644 = t5 * t116 * t754 / 0.8e1;
  t1645 = t120 * t708;
  t1646 = t1645 * t46;
  t1652 = t742 * t143 * params->a9;
  t1662 = t864 * t120;
  t1669 = t876 * t120;
  t1676 = t49 * t1662 * t708 / 0.3e1 - 0.2e1 / 0.3e1 * t49 * t614 * t708 - t51 * t1669 * t708 / 0.3e1 + 0.2e1 / 0.3e1 * t51 * t617 * t708;
  t1678 = t708 * t913;
  t1680 = t911 * t1678 * t120;
  t1683 = t888 * t708;
  t1684 = t333 * t1683;
  t1685 = t898 * t120;
  t1686 = t335 * t1685;
  t1689 = t127 * t1685;
  t1694 = -t1374 * t1646 / 0.3e1 + 0.2e1 / 0.3e1 * t595 * t1646 + 0.4e1 / 0.3e1 * t1652 * t147 - t1380 * t247 + t961 * t745 / 0.2e1 - t369 * t748 / 0.4e1 + t369 * t751 / 0.2e1 + t1676 * t56 + 0.2e1 / 0.3e1 * t925 * t1680 - 0.2e1 * t1684 * t1686 - 0.2e1 * t1684 * t1689 + t909 * t1680 / 0.3e1;
  t1697 = t338 * t720 * t120;
  t1711 = t973 * t1645;
  t1714 = t977 * t1645;
  t1717 = t981 * t1645;
  t1720 = t379 * t1645;
  t1723 = t383 * t1645;
  t1726 = t918 * t1680 + 0.2e1 / 0.3e1 * t336 * t1697 + 0.2e1 / 0.3e1 * t349 * t1697 + 0.7e1 / 0.3e1 * t126 * t1683 * t604 - 0.2e1 * t717 * t604 - 0.8e1 / 0.3e1 * t1384 * t629 + 0.4e1 / 0.3e1 * t624 * t632 + 0.2e1 * t970 * t1711 - 0.2e1 * t376 * t1714 + t145 * t1717 / 0.3e1 + 0.4e1 / 0.3e1 * t376 * t1720 - 0.2e1 / 0.3e1 * t145 * t1723;
  t1727 = t1694 + t1726;
  t1732 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t754 - t1644 - 0.3e1 / 0.8e1 * t5 * t27 * t1727);
  tv3rhosigma20 = t6 * t1732 + t758;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1739 = t5 * t166 * t806 / 0.8e1;
  t1741 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t806 - t1739);
  tv3rhosigma25 = t6 * t1741 + t810;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1747 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t754 - t1644);
  tv3rhosigma26 = t6 * t1747 + t758;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1752 = t760 * t1269;
  t1754 = t911 * t1752 * t194;
  t1757 = t888 * t760;
  t1758 = t531 * t1757;
  t1759 = t1283 * t194;
  t1760 = t532 * t1759;
  t1763 = t201 * t1759;
  t1770 = t338 * t772 * t194;
  t1775 = t200 * t1757;
  t1780 = t194 * t760;
  t1781 = t1780 * t85;
  t1787 = t794 * t216 * params->a9;
  t1790 = 0.2e1 / 0.3e1 * t1267 * t1754 - 0.2e1 * t1758 * t1760 - 0.2e1 * t1758 * t1763 + t1291 * t1754 / 0.3e1 + t1295 * t1754 + 0.2e1 / 0.3e1 * t533 * t1770 + 0.2e1 / 0.3e1 * t544 * t1770 + 0.7e1 / 0.3e1 * t1775 * t669 - 0.2e1 * t769 * t669 - t1537 * t1781 / 0.3e1 + 0.2e1 / 0.3e1 * t660 * t1781 + 0.4e1 / 0.3e1 * t1787 * t220;
  t1798 = t864 * t194;
  t1805 = t876 * t194;
  t1812 = t88 * t1798 * t760 / 0.3e1 - 0.2e1 / 0.3e1 * t88 * t679 * t760 - t90 * t1805 * t760 / 0.3e1 + 0.2e1 / 0.3e1 * t90 * t682 * t760;
  t1818 = t1247 * t1780;
  t1821 = t1253 * t1780;
  t1824 = t1257 * t1780;
  t1827 = t570 * t1780;
  t1830 = t574 * t1780;
  t1833 = -t1543 * t271 + t1237 * t797 / 0.2e1 - t562 * t800 / 0.4e1 + t562 * t803 / 0.2e1 + t1812 * t95 - 0.8e1 / 0.3e1 * t1547 * t694 + 0.4e1 / 0.3e1 * t689 * t697 + 0.2e1 * t1245 * t1818 - 0.2e1 * t568 * t1821 + t218 * t1824 / 0.3e1 + 0.4e1 / 0.3e1 * t568 * t1827 - 0.2e1 / 0.3e1 * t218 * t1830;
  t1834 = t1790 + t1833;
  t1839 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t806 - t1739 - 0.3e1 / 0.8e1 * t5 * t72 * t1834);
  tv3rhosigma211 = t6 * t1839 + t810;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1842 = 0.1e1 / t707 / sigma[0];
  t1859 = -t49 * t864 * t1842 / 0.8e1 + 0.3e1 / 0.4e1 * t49 * t352 * t1842 - t49 * params->a6 * t1842 + t51 * t876 * t1842 / 0.8e1 - 0.3e1 / 0.4e1 * t51 * t359 * t1842 + t51 * params->a8 * t1842;
  t1861 = t1842 * t130;
  t1864 = t1842 * t340;
  t1865 = t338 * t1864;
  t1868 = t981 * t1842;
  t1871 = t316 * t1842;
  t1884 = t973 * t1842;
  t1887 = t977 * t1842;
  t1890 = t888 * t1842;
  t1891 = t333 * t1890;
  t1894 = t1859 * t56 - t128 * t129 * t1861 - 0.3e1 / 0.4e1 * t336 * t1865 - t145 * t1868 / 0.8e1 - 0.3e1 / 0.4e1 * t42 * t1871 * t46 + t42 * params->a2 * t1842 * t46 - 0.3e1 / 0.2e1 * t1652 * t247 + 0.3e1 / 0.2e1 * t1384 * t745 - 0.3e1 / 0.4e1 * t624 * t748 - 0.3e1 / 0.4e1 * t970 * t1884 + 0.3e1 / 0.4e1 * t376 * t1887 + 0.3e1 / 0.4e1 * t1891 * t899;
  t1897 = t1842 * t913;
  t1898 = t911 * t1897;
  t1907 = t126 * t1890;
  t1918 = t379 * t1842;
  t1921 = t383 * t1842;
  t1924 = t146 * t1842;
  t1926 = 0.3e1 / 0.4e1 * t1891 * t902 - t909 * t1898 / 0.8e1 - 0.3e1 / 0.8e1 * t918 * t1898 - 0.3e1 / 0.4e1 * t349 * t1865 - t925 * t1898 / 0.4e1 - 0.7e1 / 0.8e1 * t1907 * t329 + 0.9e1 / 0.4e1 * t126 * t1871 * t329 + t42 * t1890 * t46 / 0.8e1 + 0.3e1 / 0.2e1 * t624 * t751 - 0.3e1 / 0.2e1 * t376 * t1918 + 0.3e1 / 0.4e1 * t145 * t1921 - t145 * t1924;
  t1927 = t1894 + t1926;
  t1931 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1927);
  tv3sigma30 = t6 * t1931;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1933 = 0.1e1 / t759 / sigma[2];
  t1934 = t888 * t1933;
  t1954 = -t88 * t864 * t1933 / 0.8e1 + 0.3e1 / 0.4e1 * t88 * t352 * t1933 - t88 * params->a6 * t1933 + t90 * t876 * t1933 / 0.8e1 - 0.3e1 / 0.4e1 * t90 * t359 * t1933 + t90 * params->a8 * t1933;
  t1956 = t1933 * t535;
  t1957 = t338 * t1956;
  t1960 = t1933 * t203;
  t1963 = t316 * t1933;
  t1976 = t1247 * t1933;
  t1979 = t1253 * t1933;
  t1982 = t1257 * t1933;
  t1985 = t81 * t1934 * t85 / 0.8e1 + t1954 * t95 - 0.3e1 / 0.4e1 * t533 * t1957 - t202 * t129 * t1960 - 0.3e1 / 0.4e1 * t81 * t1963 * t85 + t81 * params->a2 * t1933 * t85 - 0.3e1 / 0.2e1 * t1787 * t271 + 0.3e1 / 0.2e1 * t1547 * t797 - 0.3e1 / 0.4e1 * t689 * t800 - 0.3e1 / 0.4e1 * t1245 * t1976 + 0.3e1 / 0.4e1 * t568 * t1979 - t218 * t1982 / 0.8e1;
  t1988 = t1933 * t1269;
  t1989 = t911 * t1988;
  t1992 = t200 * t1934;
  t1998 = t531 * t1934;
  t2009 = t570 * t1933;
  t2012 = t574 * t1933;
  t2015 = t219 * t1933;
  t2017 = -0.3e1 / 0.4e1 * t544 * t1957 - t1267 * t1989 / 0.4e1 - 0.7e1 / 0.8e1 * t1992 * t527 + 0.9e1 / 0.4e1 * t200 * t1963 * t527 + 0.3e1 / 0.4e1 * t1998 * t1284 + 0.3e1 / 0.4e1 * t1998 * t1287 - t1291 * t1989 / 0.8e1 - 0.3e1 / 0.8e1 * t1295 * t1989 + 0.3e1 / 0.2e1 * t689 * t803 - 0.3e1 / 0.2e1 * t568 * t2009 + 0.3e1 / 0.4e1 * t218 * t2012 - t218 * t2015;
  t2018 = t1985 + t2017;
  t2022 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * t2018);
  tv3sigma39 = t6 * t2022;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t2027 = t5 * t830 * t115 * t58;
  t2031 = t5 * t295 * t308 * t58;
  t2035 = t5 * t109 * t853 * t58;
  t2038 = 0.1e1 / t114 / t286;
  t2042 = 0.1e2 / 0.27e2 * t5 * t25 * t2038 * t58;
  t2043 = t19 * t19;
  t2045 = 0.1e1 / t281 / t2043;
  t2046 = t283 * t283;
  t2052 = t291 * t291;
  t2058 = 0.1e1 / t821 / t6;
  t2059 = t16 * t2058;
  t2062 = my_piecewise5(t10, 0, t14, 0, -0.24e2 * t822 + 0.24e2 * t2059);
  t2066 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t2045 * t2046 - 0.16e2 / 0.9e1 * t814 * t283 * t291 + 0.4e1 / 0.3e1 * t282 * t2052 + 0.16e2 / 0.9e1 * t818 * t826 + 0.4e1 / 0.3e1 * t23 * t2062);
  t2075 = t5 * t835 * t150;
  t2081 = t5 * t842 * t150;
  t2083 = t5 * t300 * t390;
  t2089 = t5 * t854 * t150;
  t2092 = t5 * t309 * t390;
  t2095 = t5 * t116 * t986;
  t2098 = t366 * t373 * t375;
  t2104 = t140 * t967 * t969;
  t2114 = t375 * t375;
  t2115 = t52 / t966 / t55 * t2114;
  t2116 = t377 * t377;
  t2117 = t378 * t378;
  t2118 = t2116 * t2117;
  t2119 = t317 * t317;
  t2120 = 0.1e1 / t2119;
  t2124 = t971 * t2117;
  t2128 = t377 * t2117;
  t2132 = t53 * t2117;
  t2137 = t886 * t143 * params->a9;
  t2142 = 0.64e2 / 0.3e1 * t2098 * t380 - 0.32e2 / 0.3e1 * t957 * t384 + 0.512e3 / 0.9e1 * t2104 * t974 - 0.512e3 / 0.9e1 * t961 * t978 + 0.256e3 / 0.27e2 * t369 * t982 + 0.2048e4 / 0.27e2 * t2115 * t2118 * t2120 - 0.1024e4 / 0.9e1 * t970 * t2124 * t2120 + 0.3584e4 / 0.81e2 * t376 * t2128 * t2120 - 0.256e3 / 0.81e2 * t145 * t2132 * t2120 + 0.16e2 / 0.3e1 * t2137 * t147 - 0.8e1 * t957 * t387;
  t2168 = t338 * t2120 * t340;
  t2175 = -0.128e3 / 0.3e1 * t961 * t940 + 0.64e2 / 0.3e1 * t369 * t943 - 0.256e3 / 0.3e1 * t970 * t973 * t2120 + 0.256e3 / 0.3e1 * t376 * t977 * t2120 - 0.128e3 / 0.9e1 * t145 * t981 * t2120 + 0.32e2 / 0.3e1 * t369 * t946 + 0.352e3 / 0.9e1 * t376 * t379 * t2120 - 0.176e3 / 0.9e1 * t145 * t383 * t2120 - 0.8e1 * t145 * t146 * t2120 + 0.176e3 / 0.9e1 * t336 * t2168 - 0.8e1 * t128 * t129 * t2120 * t130;
  t2178 = t911 * t2120 * t913;
  t2183 = t316 * t2120;
  t2190 = params->a1 * t905 * t41;
  t2191 = t2190 * t127;
  t2192 = t337 * t337;
  t2193 = t316 * t316;
  t2194 = t2192 * t2193;
  t2195 = t339 * t339;
  t2196 = 0.1e1 / t2195;
  t2198 = t2194 * t2120 * t2196;
  t2201 = t888 * t2120;
  t2202 = t333 * t2201;
  t2207 = t2193 * t2120;
  t2208 = t333 * t2207;
  t2211 = t906 * t2207;
  t2212 = t910 * t913;
  t2213 = t908 * t2212;
  t2216 = t335 * t2212;
  t2221 = -0.128e3 / 0.3e1 * t918 * t2178 + 0.176e3 / 0.9e1 * t349 * t2168 - 0.176e3 / 0.3e1 * t126 * t2183 * t329 - 0.128e3 / 0.9e1 * t909 * t2178 + 0.512e3 / 0.27e2 * t2191 * t2198 + 0.256e3 / 0.3e1 * t2202 * t899 + 0.256e3 / 0.3e1 * t2202 * t902 + 0.64e4 / 0.81e2 * t2208 * t899 - 0.256e4 / 0.81e2 * t2211 * t2213 - 0.256e4 / 0.27e2 * t2211 * t2216 + 0.64e4 / 0.81e2 * t2208 * t902;
  t2222 = t127 * t2212;
  t2225 = t334 * t334;
  t2227 = t2190 * t46 * t2225;
  t2230 = t2190 * t908;
  t2233 = t2190 * t335;
  t2257 = t352 * t352;
  t2270 = t359 * t359;
  t2285 = -0.512e4 / 0.81e2 * t2211 * t2222 + 0.256e3 / 0.81e2 * t2227 * t2198 + 0.512e3 / 0.27e2 * t2230 * t2198 + 0.2816e4 / 0.81e2 * t2233 * t2198 - 0.256e3 / 0.9e1 * t925 * t2178 - 0.128e4 / 0.27e2 * t126 * t2207 * t329 - 0.896e3 / 0.9e1 * t126 * t2201 * t329 + 0.176e3 / 0.9e1 * t42 * t2183 * t46 + 0.8e1 * t42 * params->a2 * t2120 * t46 + 0.256e3 / 0.81e2 * t42 * t2207 * t46 + 0.128e3 / 0.9e1 * t42 * t2201 * t46 + (-0.256e3 / 0.81e2 * t49 * t2257 * t2120 - 0.128e3 / 0.9e1 * t49 * t864 * t2120 - 0.176e3 / 0.9e1 * t49 * t352 * t2120 - 0.8e1 * t49 * params->a6 * t2120 + 0.256e3 / 0.81e2 * t51 * t2270 * t2120 + 0.128e3 / 0.9e1 * t51 * t876 * t2120 + 0.176e3 / 0.9e1 * t51 * t359 * t2120 + 0.8e1 * t51 * params->a8 * t2120) * t56;
  t2291 = -t2027 / 0.2e1 + t2031 / 0.2e1 - 0.5e1 / 0.9e1 * t2035 + t2042 - 0.3e1 / 0.8e1 * t5 * t2066 * t26 * t58 - 0.3e1 / 0.2e1 * t5 * t831 * t150 - 0.3e1 / 0.2e1 * t2075 - 0.9e1 / 0.4e1 * t5 * t296 * t390 + t2081 - 0.3e1 / 0.2e1 * t2083 - 0.3e1 / 0.2e1 * t5 * t110 * t986 - 0.5e1 / 0.9e1 * t2089 + t2092 / 0.2e1 - t2095 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t27 * (t2142 + t2175 + t2221 + t2285);
  t2292 = my_piecewise3(t1, 0, t2291);
  t2293 = t67 * t67;
  t2295 = 0.1e1 / t396 / t2293;
  t2296 = t398 * t398;
  t2302 = t404 * t404;
  t2307 = t64 * t2058;
  t2310 = my_piecewise5(t14, 0, t10, 0, 0.24e2 * t822 + 0.24e2 * t2307);
  t2314 = my_piecewise3(t68, 0, 0.4e2 / 0.81e2 * t2295 * t2296 - 0.16e2 / 0.9e1 * t993 * t398 * t404 + 0.4e1 / 0.3e1 * t397 * t2302 + 0.16e2 / 0.9e1 * t997 * t1003 + 0.4e1 / 0.3e1 * t69 * t2310);
  t2321 = t5 * t1007 * t115 * t97;
  t2325 = t5 * t408 * t308 * t97;
  t2329 = t5 * t161 * t853 * t97;
  t2334 = 0.1e2 / 0.27e2 * t5 * t71 * t2038 * t97;
  t2336 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t2314 * t26 * t97 - t2321 / 0.2e1 + t2325 / 0.2e1 - 0.5e1 / 0.9e1 * t2329 + t2334);
  tv4rho40 = 0.4e1 * t991 + 0.4e1 * t1025 + t6 * (t2292 + t2336);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t2343 = t5 * t1045 * t115 * t58;
  t2347 = t5 * t433 * t308 * t58;
  t2348 = t2347 / 0.4e1;
  t2351 = t5 * t178 * t853 * t58;
  t2372 = 0.12e2 * t822;
  t2373 = 0.24e2 * t2059;
  t2375 = my_piecewise5(t10, 0, t14, 0, -t2372 + t2373);
  t2379 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t2045 * t175 * t815 - 0.8e1 / 0.9e1 * t814 * t429 * t283 - 0.8e1 / 0.9e1 * t1030 * t106 * t291 + 0.4e1 / 0.3e1 * t282 * t1041 * t106 + 0.4e1 / 0.3e1 * t1033 * t291 + 0.4e1 / 0.9e1 * t425 * t826 + 0.4e1 / 0.3e1 * t23 * t2375);
  t2388 = t5 * t1050 * t150;
  t2394 = t5 * t1057 * t150;
  t2395 = t2394 / 0.4e1;
  t2397 = t5 * t438 * t390;
  t2408 = -0.3e1 / 0.8e1 * t2343 + t2348 - 0.5e1 / 0.36e2 * t2351 - t2027 / 0.8e1 + t2031 / 0.4e1 - 0.5e1 / 0.12e2 * t2035 + t2042 - 0.3e1 / 0.8e1 * t5 * t2379 * t26 * t58 - 0.9e1 / 0.8e1 * t5 * t1046 * t150 - 0.3e1 / 0.4e1 * t2388 - 0.9e1 / 0.8e1 * t5 * t434 * t390 + t2395 - 0.3e1 / 0.8e1 * t2397 - 0.3e1 / 0.8e1 * t5 * t179 * t986 - 0.3e1 / 0.8e1 * t2075 + t2081 / 0.2e1 - 0.3e1 / 0.8e1 * t2083 - 0.5e1 / 0.12e2 * t2089 + t2092 / 0.4e1 - t2095 / 0.8e1;
  t2409 = my_piecewise3(t1, 0, t2408);
  t2426 = 0.24e2 * t2307;
  t2428 = my_piecewise5(t14, 0, t10, 0, t2372 + t2426);
  t2432 = my_piecewise3(t68, 0, 0.4e2 / 0.81e2 * t2295 * t186 * t994 - 0.8e1 / 0.9e1 * t993 * t453 * t398 - 0.8e1 / 0.9e1 * t1074 * t158 * t404 + 0.4e1 / 0.3e1 * t397 * t1084 * t158 + 0.4e1 / 0.3e1 * t1077 * t404 + 0.4e1 / 0.9e1 * t449 * t1003 + 0.4e1 / 0.3e1 * t69 * t2428);
  t2439 = t5 * t1088 * t115 * t97;
  t2443 = t5 * t457 * t308 * t97;
  t2444 = t2443 / 0.4e1;
  t2447 = t5 * t189 * t853 * t97;
  t2456 = t5 * t1012 * t223;
  t2459 = t5 * t1016 * t223;
  t2460 = t2459 / 0.4e1;
  t2462 = t5 * t1020 * t223;
  t2464 = -0.3e1 / 0.8e1 * t5 * t2432 * t26 * t97 - 0.3e1 / 0.8e1 * t2439 + t2444 - 0.5e1 / 0.36e2 * t2447 - t2321 / 0.8e1 + t2325 / 0.4e1 - 0.5e1 / 0.12e2 * t2329 + t2334 - 0.3e1 / 0.8e1 * t5 * t1008 * t223 - 0.3e1 / 0.8e1 * t2456 + t2460 - 0.5e1 / 0.36e2 * t2462;
  t2465 = my_piecewise3(t63, 0, t2464);
  tv4rho41 = t991 + t1025 + 0.3e1 * t1073 + 0.3e1 * t1113 + t6 * (t2409 + t2465);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t2474 = t5 * t1129 * t115 * t58;
  t2478 = t5 * t488 * t308 * t58;
  t2493 = t429 * t429;
  t2506 = my_piecewise5(t10, 0, t14, 0, t2373);
  t2510 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t2045 * t479 * t283 - 0.32e2 / 0.27e2 * t1030 * t106 * t429 - 0.8e1 / 0.27e2 * t1116 * t291 + 0.8e1 / 0.9e1 * t282 * t2493 + 0.8e1 / 0.9e1 * t425 * t1041 - 0.8e1 / 0.27e2 * t814 * t484 * t283 + 0.8e1 / 0.9e1 * t282 * t1125 * t106 + 0.4e1 / 0.9e1 * t1121 * t291 + 0.4e1 / 0.3e1 * t23 * t2506);
  t2519 = t5 * t1134 * t150;
  t2530 = -t2474 / 0.4e1 + t2478 / 0.12e2 - t2343 / 0.4e1 + t2347 / 0.3e1 - 0.5e1 / 0.18e2 * t2351 + t2031 / 0.12e2 - 0.5e1 / 0.18e2 * t2035 + t2042 - 0.3e1 / 0.8e1 * t5 * t2510 * t26 * t58 - 0.3e1 / 0.4e1 * t5 * t1130 * t150 - t2519 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t489 * t390 - t2388 / 0.2e1 + t2394 / 0.3e1 - t2397 / 0.4e1 + t2081 / 0.6e1 - 0.5e1 / 0.18e2 * t2089 + t2092 / 0.12e2;
  t2531 = my_piecewise3(t1, 0, t2530);
  t2540 = t453 * t453;
  t2553 = my_piecewise5(t14, 0, t10, 0, t2426);
  t2557 = my_piecewise3(t68, 0, 0.4e2 / 0.81e2 * t2295 * t496 * t398 - 0.32e2 / 0.27e2 * t1074 * t158 * t453 - 0.8e1 / 0.27e2 * t1146 * t404 + 0.8e1 / 0.9e1 * t397 * t2540 + 0.8e1 / 0.9e1 * t449 * t1084 - 0.8e1 / 0.27e2 * t993 * t501 * t398 + 0.8e1 / 0.9e1 * t397 * t1155 * t158 + 0.4e1 / 0.9e1 * t1151 * t404 + 0.4e1 / 0.3e1 * t69 * t2553);
  t2564 = t5 * t1159 * t115 * t97;
  t2568 = t5 * t505 * t308 * t97;
  t2577 = t5 * t1093 * t223;
  t2580 = t5 * t1097 * t223;
  t2591 = t5 * t413 * t581;
  t2594 = t5 * t417 * t581;
  t2596 = -0.3e1 / 0.8e1 * t5 * t2557 * t26 * t97 - t2564 / 0.4e1 + t2568 / 0.12e2 - t2439 / 0.4e1 + t2443 / 0.3e1 - 0.5e1 / 0.18e2 * t2447 - 0.3e1 / 0.4e1 * t5 * t1089 * t223 - t2577 / 0.2e1 + t2580 / 0.6e1 + t2325 / 0.12e2 - 0.5e1 / 0.18e2 * t2329 + t2334 - t2456 / 0.4e1 + t2459 / 0.3e1 - 0.5e1 / 0.18e2 * t2462 - 0.3e1 / 0.8e1 * t5 * t409 * t581 - t2591 / 0.4e1 + t2594 / 0.12e2;
  t2597 = my_piecewise3(t63, 0, t2596);
  tv4rho42 = 0.2e1 * t1073 + 0.2e1 * t1113 + 0.2e1 * t1145 + 0.2e1 * t1184 + t6 * (t2531 + t2597);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t2618 = my_piecewise5(t10, 0, t14, 0, t2372 + t2373);
  t2622 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t2045 * t1189 * t106 - 0.8e1 / 0.9e1 * t1116 * t429 - 0.8e1 / 0.9e1 * t1030 * t484 * t106 + 0.4e1 / 0.3e1 * t1033 * t484 + 0.4e1 / 0.3e1 * t425 * t1125 + 0.4e1 / 0.9e1 * t282 * t1196 * t106 + 0.4e1 / 0.3e1 * t23 * t2618);
  t2629 = t5 * t1200 * t115 * t58;
  t2640 = -0.3e1 / 0.8e1 * t5 * t2622 * t26 * t58 - t2629 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t1201 * t150 - 0.3e1 / 0.8e1 * t2474 + t2478 / 0.4e1 - 0.3e1 / 0.8e1 * t2519 + t2348 - 0.5e1 / 0.12e2 * t2351 + t2395 - 0.5e1 / 0.36e2 * t2035 + t2042 - 0.5e1 / 0.36e2 * t2089;
  t2641 = my_piecewise3(t1, 0, t2640);
  t2658 = my_piecewise5(t14, 0, t10, 0, -t2372 + t2426);
  t2662 = my_piecewise3(t68, 0, 0.4e2 / 0.81e2 * t2295 * t1209 * t158 - 0.8e1 / 0.9e1 * t1146 * t453 - 0.8e1 / 0.9e1 * t1074 * t501 * t158 + 0.4e1 / 0.3e1 * t1077 * t501 + 0.4e1 / 0.3e1 * t449 * t1155 + 0.4e1 / 0.9e1 * t397 * t1216 * t158 + 0.4e1 / 0.3e1 * t69 * t2658);
  t2669 = t5 * t1220 * t115 * t97;
  t2677 = t5 * t1164 * t223;
  t2686 = t5 * t462 * t581;
  t2696 = t5 * t166 * t1350;
  t2698 = -0.3e1 / 0.8e1 * t5 * t2662 * t26 * t97 - t2669 / 0.8e1 - 0.3e1 / 0.8e1 * t2564 + t2568 / 0.4e1 - 0.9e1 / 0.8e1 * t5 * t1160 * t223 - 0.3e1 / 0.8e1 * t2677 + t2444 - 0.5e1 / 0.12e2 * t2447 - 0.3e1 / 0.4e1 * t2577 + t2580 / 0.2e1 - 0.9e1 / 0.8e1 * t5 * t458 * t581 - 0.3e1 / 0.8e1 * t2686 - 0.5e1 / 0.36e2 * t2329 + t2334 + t2460 - 0.5e1 / 0.12e2 * t2462 - 0.3e1 / 0.8e1 * t2591 + t2594 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t162 * t1350 - t2696 / 0.8e1;
  t2699 = my_piecewise3(t63, 0, t2698);
  tv4rho43 = 0.3e1 * t1145 + 0.3e1 * t1184 + t1208 + t1355 + t6 * (t2641 + t2699);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t2704 = t479 * t479;
  t2709 = t484 * t484;
  t2716 = my_piecewise5(t10, 0, t14, 0, 0.24e2 * t822 + 0.24e2 * t2059);
  t2720 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t2045 * t2704 - 0.16e2 / 0.9e1 * t1116 * t484 + 0.4e1 / 0.3e1 * t282 * t2709 + 0.16e2 / 0.9e1 * t425 * t1196 + 0.4e1 / 0.3e1 * t23 * t2716);
  t2729 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t2720 * t26 * t58 - t2629 / 0.2e1 + t2478 / 0.2e1 - 0.5e1 / 0.9e1 * t2351 + t2042);
  t2741 = t515 * t515;
  t2742 = 0.1e1 / t2741;
  t2743 = t2193 * t2742;
  t2747 = t888 * t2742;
  t2751 = t316 * t2742;
  t2760 = params->a1 * t1265 * t80;
  t2762 = t2760 * t85 * t2225;
  t2763 = t534 * t534;
  t2764 = 0.1e1 / t2763;
  t2766 = t2194 * t2742 * t2764;
  t2769 = t2760 * t1290;
  t2772 = t2742 * t535;
  t2773 = t338 * t2772;
  t2783 = t2742 * t1269;
  t2784 = t911 * t2783;
  t2789 = 0.256e3 / 0.81e2 * t81 * t2743 * t85 + 0.128e3 / 0.9e1 * t81 * t2747 * t85 + 0.176e3 / 0.9e1 * t81 * t2751 * t85 + 0.8e1 * t81 * params->a2 * t2742 * t85 + 0.256e3 / 0.81e2 * t2762 * t2766 + 0.512e3 / 0.27e2 * t2769 * t2766 + 0.176e3 / 0.9e1 * t533 * t2773 - 0.8e1 * t202 * t129 * t2742 * t203 - 0.176e3 / 0.3e1 * t200 * t2751 * t527 - 0.128e3 / 0.9e1 * t1291 * t2784 + 0.176e3 / 0.9e1 * t544 * t2773;
  t2793 = t910 * t2193;
  t2797 = t2760 * t532;
  t2800 = t2760 * t201;
  t2806 = t531 * t2743;
  t2814 = t1266 * t2743;
  t2815 = t910 * t1269;
  t2816 = t1290 * t2815;
  t2819 = t532 * t2815;
  t2822 = t337 * t888;
  t2826 = -0.896e3 / 0.9e1 * t200 * t2747 * t527 - 0.512e4 / 0.81e2 * t1267 * t2793 * t2783 + 0.2816e4 / 0.81e2 * t2797 * t2766 + 0.512e3 / 0.27e2 * t2800 * t2766 - 0.128e4 / 0.27e2 * t200 * t2743 * t527 + 0.64e4 / 0.81e2 * t2806 * t1284 + 0.64e4 / 0.81e2 * t2806 * t1287 + 0.256e3 / 0.3e1 * t531 * t2747 * t1284 - 0.256e4 / 0.81e2 * t2814 * t2816 - 0.256e4 / 0.27e2 * t2814 * t2819 + 0.256e3 / 0.3e1 * t544 * t2822 * t2772;
  t2880 = -0.128e3 / 0.3e1 * t1295 * t2784 - 0.256e3 / 0.9e1 * t1267 * t2784 + (-0.256e3 / 0.81e2 * t88 * t2257 * t2742 - 0.128e3 / 0.9e1 * t88 * t864 * t2742 - 0.176e3 / 0.9e1 * t88 * t352 * t2742 - 0.8e1 * t88 * params->a6 * t2742 + 0.256e3 / 0.81e2 * t90 * t2270 * t2742 + 0.128e3 / 0.9e1 * t90 * t876 * t2742 + 0.176e3 / 0.9e1 * t90 * t359 * t2742 + 0.8e1 * t90 * params->a8 * t2742) * t95 - 0.176e3 / 0.9e1 * t218 * t574 * t2742 - 0.8e1 * t218 * t219 * t2742 - 0.256e3 / 0.3e1 * t1245 * t1247 * t2742 + 0.256e3 / 0.3e1 * t568 * t1253 * t2742 - 0.128e3 / 0.9e1 * t218 * t1257 * t2742 + 0.32e2 / 0.3e1 * t562 * t1342 + 0.352e3 / 0.9e1 * t568 * t570 * t2742 - 0.128e3 / 0.3e1 * t1237 * t1336;
  t2884 = t1316 * t216 * params->a9;
  t2890 = t559 * t566 * t375;
  t2894 = t213 * t1243 * t969;
  t2906 = t91 / t1242 / t94 * t2114;
  t2907 = t569 * t569;
  t2908 = t2907 * t2117;
  t2912 = t1246 * t2117;
  t2916 = t569 * t2117;
  t2920 = t92 * t2117;
  t2924 = 0.64e2 / 0.3e1 * t562 * t1339 + 0.16e2 / 0.3e1 * t2884 * t220 - 0.8e1 * t1346 * t578 + 0.64e2 / 0.3e1 * t2890 * t571 + 0.512e3 / 0.9e1 * t2894 * t1250 - 0.512e3 / 0.9e1 * t1237 * t1254 - 0.32e2 / 0.3e1 * t1346 * t575 + 0.256e3 / 0.27e2 * t562 * t1258 + 0.2048e4 / 0.27e2 * t2906 * t2908 * t2742 - 0.1024e4 / 0.9e1 * t1245 * t2912 * t2742 + 0.3584e4 / 0.81e2 * t568 * t2916 * t2742 - 0.256e3 / 0.81e2 * t218 * t2920 * t2742;
  t2930 = t496 * t496;
  t2935 = t501 * t501;
  t2942 = my_piecewise5(t14, 0, t10, 0, -0.24e2 * t822 + 0.24e2 * t2307);
  t2946 = my_piecewise3(t68, 0, 0.4e2 / 0.81e2 * t2295 * t2930 - 0.16e2 / 0.9e1 * t1146 * t501 + 0.4e1 / 0.3e1 * t397 * t2935 + 0.16e2 / 0.9e1 * t449 * t1216 + 0.4e1 / 0.3e1 * t69 * t2942);
  t2957 = t2580 + t2594 / 0.2e1 - t2669 / 0.2e1 - 0.3e1 / 0.2e1 * t2677 - 0.3e1 / 0.2e1 * t2686 - t2696 / 0.2e1 - 0.5e1 / 0.9e1 * t2447 - 0.5e1 / 0.9e1 * t2462 + t2568 / 0.2e1 + t2334 - 0.3e1 / 0.2e1 * t5 * t190 * t1350 - 0.3e1 / 0.8e1 * t5 * t72 * (t2789 + t2826 + t2880 + t2924) - 0.3e1 / 0.8e1 * t5 * t2946 * t26 * t97 - 0.3e1 / 0.2e1 * t5 * t1221 * t223 - 0.9e1 / 0.4e1 * t5 * t506 * t581;
  t2958 = my_piecewise3(t63, 0, t2957);
  tv4rho44 = 0.4e1 * t1208 + 0.4e1 * t1355 + t6 * (t2729 + t2958);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t2966 = t5 * t835 * t250;
  t2972 = t5 * t842 * t250;
  t2975 = t5 * t300 * t635;
  t2982 = 0.5e1 / 0.36e2 * t5 * t854 * t250;
  t2984 = t5 * t309 * t635;
  t2987 = t5 * t116 * t1470;
  t3011 = t2193 * t866;
  t3012 = t333 * t3011;
  t3013 = t334 * t337;
  t3018 = params->a4 * t337;
  t3024 = t906 * t2193 * t231;
  t3026 = t910 * t866 * t913;
  t3039 = t127 * params->a3 * t866 * t130;
  t3043 = t337 * t866 * t340;
  t3050 = t1424 * t866;
  t3051 = t911 * t3050;
  t3058 = (0.32e2 / 0.27e2 * t49 * t2257 * t866 * t231 + 0.8e1 / 0.3e1 * t49 * t867 * t231 + 0.4e1 / 0.3e1 * t49 * t870 * t231 - 0.32e2 / 0.27e2 * t51 * t2270 * t866 * t231 - 0.8e1 / 0.3e1 * t51 * t877 * t231 - 0.4e1 / 0.3e1 * t51 * t880 * t231) * t56 - 0.8e3 / 0.27e2 * t3012 * t1432 * t3013 * t340 - 0.8e3 / 0.27e2 * t3012 * t1432 * t3018 * t340 + 0.32e3 / 0.27e2 * t3024 * t908 * t3026 + 0.32e3 / 0.9e1 * t3024 * t335 * t3026 + 0.16e3 / 0.9e1 * t126 * t3011 * t1435 + 0.56e2 / 0.3e1 * t126 * t1438 * t3039 - 0.16e2 * t1439 * t335 * t3043 - 0.16e2 * t1439 * t127 * t3043 + 0.8e1 / 0.3e1 * t909 * t3051 + 0.8e1 * t918 * t3051 + 0.16e2 / 0.3e1 * t925 * t3051;
  t3062 = t338 * t607 * t866;
  t3069 = t2194 * t231 * t2196 * t866;
  t3081 = t231 * t866;
  t3097 = 0.4e1 * t601 * t3039 - 0.4e1 / 0.3e1 * t336 * t3062 - 0.4e1 / 0.3e1 * t349 * t3062 - 0.32e2 / 0.27e2 * t2227 * t3069 - 0.64e2 / 0.9e1 * t2230 * t3069 + 0.64e3 / 0.27e2 * t925 * t2793 * t3050 - 0.352e3 / 0.27e2 * t2233 * t3069 - 0.64e2 / 0.9e1 * t2191 * t3069 - 0.8e1 / 0.3e1 * t376 * t379 * t3081 + 0.4e1 / 0.3e1 * t145 * t383 * t3081 - 0.256e3 / 0.9e1 * t2115 * t2118 * t3081 + 0.128e3 / 0.3e1 * t970 * t2124 * t3081 - 0.448e3 / 0.27e2 * t376 * t2128 * t3081;
  t3125 = t3081 * t46;
  t3128 = 0.32e2 / 0.27e2 * t145 * t2132 * t3081 - 0.4e1 * t2098 * t629 + 0.2e1 * t957 * t632 + 0.4e1 * t961 * t1391 + 0.16e2 * t970 * t973 * t3081 - 0.16e2 * t376 * t977 * t3081 - 0.2e1 * t369 * t1394 + 0.8e1 / 0.3e1 * t145 * t981 * t3081 - 0.16e2 * t2104 * t1460 + 0.16e2 * t961 * t1463 - 0.8e1 / 0.3e1 * t369 * t1466 - 0.4e1 / 0.3e1 * t595 * t3125;
  t3140 = t1411 * t143 * params->a9;
  t3144 = t621 * t373 * t375;
  t3150 = t245 * t967 * t969;
  t3159 = t42 * t2193;
  t3162 = 0.8e1 / 0.3e1 * t624 * t946 - 0.8e1 / 0.3e1 * t1374 * t3125 - 0.4e1 * t1380 * t387 - 0.32e2 / 0.3e1 * t1384 * t940 + 0.16e2 / 0.3e1 * t624 * t943 + 0.4e1 * t3140 * t147 + 0.32e2 / 0.3e1 * t3144 * t380 - 0.16e2 / 0.3e1 * t1380 * t384 + 0.128e3 / 0.9e1 * t3150 * t974 - 0.128e3 / 0.9e1 * t1384 * t978 + 0.64e2 / 0.27e2 * t624 * t982 - t2137 * t247 / 0.2e1 - 0.32e2 / 0.27e2 * t3159 * t3125;
  t3169 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t831 * t250 - 0.3e1 / 0.8e1 * t2966 - 0.9e1 / 0.8e1 * t5 * t296 * t635 + t2972 / 0.4e1 - 0.3e1 / 0.4e1 * t2975 - 0.9e1 / 0.8e1 * t5 * t110 * t1470 - t2982 + t2984 / 0.4e1 - 0.3e1 / 0.8e1 * t2987 - 0.3e1 / 0.8e1 * t5 * t27 * (t3058 + t3097 + t3128 + t3162));
  tv4rho3sigma0 = t6 * t3169 + 0.3e1 * t1475;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t3176 = t5 * t1012 * t274;
  t3179 = t5 * t1016 * t274;
  t3183 = 0.5e1 / 0.36e2 * t5 * t1020 * t274;
  t3185 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1008 * t274 - 0.3e1 / 0.8e1 * t3176 + t3179 / 0.4e1 - t3183);
  tv4rho3sigma2 = t6 * t3185 + 0.3e1 * t1488;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t3187 = 0.2e1 * t1502;
  t3193 = t5 * t1050 * t250 / 0.4e1;
  t3198 = t5 * t1057 * t250;
  t3202 = t5 * t438 * t635 / 0.4e1;
  t3211 = -0.3e1 / 0.8e1 * t5 * t1046 * t250 - t3193 - 0.3e1 / 0.4e1 * t5 * t434 * t635 + t3198 / 0.12e2 - t3202 - 0.3e1 / 0.8e1 * t5 * t179 * t1470 - t2966 / 0.8e1 + t2972 / 0.6e1 - t2975 / 0.4e1 - t2982 + t2984 / 0.6e1 - t2987 / 0.8e1;
  t3212 = my_piecewise3(t1, 0, t3211);
  tv4rho3sigma3 = t6 * t3212 + t1475 + t3187;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t3214 = 0.2e1 * t1518;
  t3220 = t5 * t1093 * t274 / 0.4e1;
  t3222 = t5 * t1097 * t274;
  t3231 = t5 * t413 * t700 / 0.4e1;
  t3233 = t5 * t417 * t700;
  t3236 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1089 * t274 - t3220 + t3222 / 0.12e2 - t3176 / 0.8e1 + t3179 / 0.6e1 - t3183 - 0.3e1 / 0.8e1 * t5 * t409 * t700 - t3231 + t3233 / 0.12e2);
  tv4rho3sigma5 = t6 * t3236 + t1488 + t3214;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t3242 = t5 * t1134 * t250;
  t3251 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1130 * t250 - t3242 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t489 * t635 - t3193 + t3198 / 0.6e1 - t3202 + t2972 / 0.12e2 - t2982 + t2984 / 0.12e2);
  tv4rho3sigma6 = t6 * t3251 + t1526 + t3187;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t3257 = t5 * t1164 * t274;
  t3264 = t5 * t462 * t700;
  t3272 = t5 * t166 * t1632;
  t3274 = -0.3e1 / 0.8e1 * t5 * t1160 * t274 - t3257 / 0.8e1 - t3220 + t3222 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t458 * t700 - t3264 / 0.4e1 + t3179 / 0.12e2 - t3183 - t3231 + t3233 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t162 * t1632 - t3272 / 0.8e1;
  t3275 = my_piecewise3(t63, 0, t3274);
  tv4rho3sigma8 = t6 * t3275 + t1637 + t3214;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t3284 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1201 * t250 - 0.3e1 / 0.8e1 * t3242 + t3198 / 0.4e1 - t2982);
  tv4rho3sigma9 = t6 * t3284 + 0.3e1 * t1526;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t3301 = t1249 * t255;
  t3332 = 0.4e1 / 0.3e1 * t218 * t574 * t3301 - 0.8e1 / 0.3e1 * t568 * t570 * t3301 - 0.16e2 * t2894 * t1622 + 0.16e2 * t1237 * t1625 - 0.8e1 / 0.3e1 * t562 * t1628 - 0.256e3 / 0.9e1 * t2906 * t2908 * t3301 + 0.128e3 / 0.3e1 * t1245 * t2912 * t3301 - 0.448e3 / 0.27e2 * t568 * t2916 * t3301 + 0.32e2 / 0.27e2 * t218 * t2920 * t3301 - 0.4e1 * t2890 * t694 + 0.2e1 * t1346 * t697 + 0.4e1 * t1237 * t1554;
  t3346 = t2194 * t255 * t2764 * t1249;
  t3349 = t2193 * t1249;
  t3350 = t531 * t3349;
  t3359 = t672 * t1249;
  t3360 = t2822 * t3359;
  t3363 = t1587 * t1249;
  t3364 = t911 * t3363;
  t3370 = t201 * params->a3 * t1249 * t203;
  t3373 = t2793 * t3363;
  t3380 = 0.16e2 * t1245 * t1247 * t3301 - 0.16e2 * t568 * t1253 * t3301 - 0.2e1 * t562 * t1557 + 0.8e1 / 0.3e1 * t218 * t1257 * t3301 - 0.64e2 / 0.9e1 * t2800 * t3346 - 0.8e3 / 0.27e2 * t3350 * t1599 * t3013 * t535 - 0.8e3 / 0.27e2 * t3350 * t1599 * t3018 * t535 - 0.16e2 * t544 * t3360 + 0.16e2 / 0.3e1 * t1267 * t3364 + 0.56e2 / 0.3e1 * t200 * t1604 * t3370 + 0.32e3 / 0.27e2 * t1291 * t3373 - 0.32e2 / 0.27e2 * t2762 * t3346 - 0.64e2 / 0.9e1 * t2769 * t3346;
  t3397 = t338 * t3359;
  t3406 = t81 * t2193;
  t3407 = t3301 * t85;
  t3410 = 0.32e3 / 0.9e1 * t1295 * t3373 - 0.352e3 / 0.27e2 * t2797 * t3346 + 0.64e3 / 0.27e2 * t1267 * t3373 + 0.16e3 / 0.9e1 * t200 * t3349 * t1601 - 0.16e2 * t533 * t3360 + 0.8e1 / 0.3e1 * t1291 * t3364 + 0.8e1 * t1295 * t3364 - 0.4e1 / 0.3e1 * t533 * t3397 - 0.4e1 / 0.3e1 * t544 * t3397 + 0.4e1 * t666 * t3370 - t2884 * t271 / 0.2e1 - 0.32e2 / 0.27e2 * t3406 * t3407;
  t3412 = t1574 * t216 * params->a9;
  t3416 = t686 * t566 * t375;
  t3422 = t269 * t1243 * t969;
  t3463 = 0.4e1 * t3412 * t220 + 0.32e2 / 0.3e1 * t3416 * t571 - 0.16e2 / 0.3e1 * t1543 * t575 + 0.128e3 / 0.9e1 * t3422 * t1250 - 0.128e3 / 0.9e1 * t1547 * t1254 - 0.4e1 / 0.3e1 * t660 * t3407 + 0.8e1 / 0.3e1 * t689 * t1342 - 0.8e1 / 0.3e1 * t1537 * t3407 - 0.4e1 * t1543 * t578 - 0.32e2 / 0.3e1 * t1547 * t1336 + 0.16e2 / 0.3e1 * t689 * t1339 + 0.64e2 / 0.27e2 * t689 * t1258 + (0.32e2 / 0.27e2 * t88 * t2257 * t1249 * t255 + 0.8e1 / 0.3e1 * t88 * t1298 * t255 + 0.4e1 / 0.3e1 * t88 * t1301 * t255 - 0.32e2 / 0.27e2 * t90 * t2270 * t1249 * t255 - 0.8e1 / 0.3e1 * t90 * t1307 * t255 - 0.4e1 / 0.3e1 * t90 * t1310 * t255) * t95;
  t3470 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t1221 * t274 - 0.3e1 / 0.8e1 * t3257 - 0.9e1 / 0.8e1 * t5 * t506 * t700 + t3222 / 0.4e1 - 0.3e1 / 0.4e1 * t3264 - 0.9e1 / 0.8e1 * t5 * t190 * t1632 - t3183 + t3233 / 0.4e1 - 0.3e1 / 0.8e1 * t3272 - 0.3e1 / 0.8e1 * t5 * t72 * (t3332 + t3380 + t3410 + t3463));
  tv4rho3sigma11 = t6 * t3470 + 0.3e1 * t1637;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t3477 = t5 * t300 * t754;
  t3484 = t5 * t309 * t754 / 0.12e2;
  t3486 = t5 * t116 * t1727;
  t3490 = t708 * t318;
  t3522 = -0.4e1 / 0.3e1 * t624 * t1394 + 0.1e2 / 0.3e1 * t970 * t973 * t3490 - 0.1e2 / 0.3e1 * t376 * t977 * t3490 + 0.5e1 / 0.9e1 * t145 * t981 * t3490 + 0.8e1 / 0.3e1 * t961 * t1720 - 0.4e1 / 0.3e1 * t369 * t1723 - 0.32e2 / 0.3e1 * t3150 * t1460 + 0.32e2 / 0.3e1 * t1384 * t1463 - 0.16e2 / 0.9e1 * t624 * t1466 + 0.32e2 / 0.3e1 * t2115 * t2118 * t3490 - 0.16e2 * t970 * t2124 * t3490 + 0.56e2 / 0.9e1 * t376 * t2128 * t3490 - 0.4e1 / 0.9e1 * t145 * t2132 * t3490;
  t3543 = t2194 * t708 * t2196 * t318;
  t3549 = t708 * t46 * t1434;
  t3554 = t1678 * t318;
  t3560 = -0.16e2 / 0.3e1 * t3144 * t629 + 0.8e1 / 0.3e1 * t1380 * t632 + 0.4e1 * t2104 * t1711 - 0.4e1 * t961 * t1714 + 0.2e1 / 0.3e1 * t369 * t1717 - 0.4e1 / 0.3e1 * t376 * t379 * t3490 + 0.2e1 / 0.3e1 * t145 * t383 * t3490 + 0.8e1 / 0.3e1 * t1384 * t1391 + 0.8e1 / 0.3e1 * t2230 * t3543 - 0.2e2 / 0.3e1 * t126 * t2193 * t318 * t3549 + 0.35e2 / 0.9e1 * t1431 * t3549 - 0.8e2 / 0.9e1 * t925 * t2793 * t3554 + 0.44e2 / 0.9e1 * t2233 * t3543;
  t3564 = t2193 * t708;
  t3565 = t333 * t3564;
  t3568 = t906 * t3564;
  t3569 = t2212 * t318;
  t3574 = t338 * t720 * t318;
  t3579 = t911 * t3554;
  t3597 = 0.8e1 / 0.3e1 * t2191 * t3543 + 0.1e3 / 0.9e1 * t3565 * t1442 - 0.4e2 / 0.9e1 * t3568 * t908 * t3569 - 0.2e1 / 0.3e1 * t349 * t3574 + 0.2e1 * t717 * t1415 + 0.5e1 / 0.9e1 * t909 * t3579 + 0.5e1 / 0.3e1 * t918 * t3579 - 0.2e1 / 0.3e1 * t336 * t3574 + 0.1e2 / 0.9e1 * t925 * t3579 - 0.1e2 / 0.3e1 * t1684 * t1442 - 0.1e2 / 0.3e1 * t1684 * t1445 - 0.4e2 / 0.3e1 * t3568 * t335 * t3569 + 0.1e3 / 0.9e1 * t3565 * t1445;
  t3606 = t3490 * t46;
  t3610 = t1676 * t143 * params->a9;
  t3614 = t742 * t373 * t375;
  t3648 = 0.4e1 / 0.9e1 * t2227 * t3543 + t2098 * t745 / 0.2e1 - t957 * t748 / 0.4e1 + t957 * t751 / 0.2e1 + 0.4e1 / 0.9e1 * t3159 * t3606 + 0.8e1 / 0.3e1 * t3610 * t147 + 0.32e2 / 0.9e1 * t3614 * t380 - 0.16e2 / 0.9e1 * t1652 * t384 - t3140 * t247 - 0.5e1 / 0.9e1 * t1374 * t3606 - 0.2e1 / 0.3e1 * t595 * t3606 - 0.4e1 / 0.3e1 * t1652 * t387 + (-0.4e1 / 0.9e1 * t49 * t2257 * t318 * t708 + 0.5e1 / 0.9e1 * t49 * t1397 * t708 + 0.2e1 / 0.3e1 * t49 * t353 * t708 + 0.4e1 / 0.9e1 * t51 * t2270 * t318 * t708 - 0.5e1 / 0.9e1 * t51 * t1404 * t708 - 0.2e1 / 0.3e1 * t51 * t360 * t708) * t56;
  t3655 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t296 * t754 - t3477 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t110 * t1727 + t3484 - t3486 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * (t3522 + t3560 + t3597 + t3648));
  tv4rho2sigma20 = t6 * t3655 + 0.2e1 * t1732;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t3662 = t5 * t413 * t806;
  t3666 = t5 * t417 * t806 / 0.12e2;
  t3668 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t409 * t806 - t3662 / 0.4e1 + t3666);
  tv4rho2sigma25 = t6 * t3668 + 0.2e1 * t1741;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t3674 = t5 * t438 * t754;
  t3682 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t434 * t754 - t3674 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t179 * t1727 - t3477 / 0.8e1 + t3484 - t3486 / 0.8e1);
  tv4rho2sigma26 = t6 * t3682 + t1732 + t1747;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t3688 = t5 * t462 * t806;
  t3695 = t5 * t166 * t1834;
  t3698 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t458 * t806 - t3688 / 0.8e1 - t3662 / 0.8e1 + t3666 - 0.3e1 / 0.8e1 * t5 * t162 * t1834 - t3695 / 0.8e1);
  tv4rho2sigma211 = t6 * t3698 + t1741 + t1839;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t3706 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t489 * t754 - t3674 / 0.4e1 + t3484);
  tv4rho2sigma212 = t6 * t3706 + 0.2e1 * t1747;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t3717 = t516 * t760;
  t3750 = 0.2e1 / 0.3e1 * t218 * t574 * t3717 + 0.8e1 / 0.3e1 * t1547 * t1554 - 0.4e1 / 0.3e1 * t689 * t1557 + 0.1e2 / 0.3e1 * t1245 * t1247 * t3717 - 0.1e2 / 0.3e1 * t568 * t1253 * t3717 + 0.5e1 / 0.9e1 * t218 * t1257 * t3717 + 0.56e2 / 0.9e1 * t568 * t2916 * t3717 - 0.4e1 / 0.9e1 * t218 * t2920 * t3717 + 0.4e1 * t2894 * t1818 - 0.4e1 * t1237 * t1821 + 0.2e1 / 0.3e1 * t562 * t1824 + 0.8e1 / 0.3e1 * t1237 * t1827 - 0.4e1 / 0.3e1 * t562 * t1830;
  t3771 = t1812 * t216 * params->a9;
  t3775 = t794 * t566 * t375;
  t3783 = -0.32e2 / 0.3e1 * t3422 * t1622 + 0.32e2 / 0.3e1 * t1547 * t1625 - 0.16e2 / 0.9e1 * t689 * t1628 + 0.32e2 / 0.3e1 * t2906 * t2908 * t3717 - 0.16e2 * t1245 * t2912 * t3717 - 0.16e2 / 0.3e1 * t3416 * t694 + 0.8e1 / 0.3e1 * t1543 * t697 - 0.4e1 / 0.3e1 * t568 * t570 * t3717 + 0.8e1 / 0.3e1 * t3771 * t220 + 0.32e2 / 0.9e1 * t3775 * t571 - 0.16e2 / 0.9e1 * t1787 * t575 - t3412 * t271 + t2890 * t797 / 0.2e1;
  t3789 = t3717 * t85;
  t3822 = t2194 * t760 * t2764 * t516;
  t3825 = t1752 * t516;
  t3834 = t338 * t772 * t516;
  t3839 = -t1346 * t800 / 0.4e1 + t1346 * t803 / 0.2e1 + 0.4e1 / 0.9e1 * t3406 * t3789 - 0.5e1 / 0.9e1 * t1537 * t3789 - 0.2e1 / 0.3e1 * t660 * t3789 - 0.4e1 / 0.3e1 * t1787 * t578 + (-0.4e1 / 0.9e1 * t88 * t2257 * t516 * t760 + 0.5e1 / 0.9e1 * t88 * t1560 * t760 + 0.2e1 / 0.3e1 * t88 * t547 * t760 + 0.4e1 / 0.9e1 * t90 * t2270 * t516 * t760 - 0.5e1 / 0.9e1 * t90 * t1567 * t760 - 0.2e1 / 0.3e1 * t90 * t553 * t760) * t95 + 0.8e1 / 0.3e1 * t2769 * t3822 - 0.8e2 / 0.9e1 * t1267 * t2793 * t3825 + 0.44e2 / 0.9e1 * t2797 * t3822 + 0.8e1 / 0.3e1 * t2800 * t3822 - 0.2e1 / 0.3e1 * t533 * t3834 - 0.2e1 / 0.3e1 * t544 * t3834;
  t3846 = t911 * t3825;
  t3855 = t2193 * t760;
  t3859 = t531 * t3855;
  t3862 = t1266 * t3855;
  t3863 = t2815 * t516;
  t3874 = 0.35e2 / 0.9e1 * t1775 * t1584 + 0.2e1 * t769 * t1584 - 0.1e2 / 0.3e1 * t1758 * t1611 + 0.5e1 / 0.9e1 * t1291 * t3846 + 0.5e1 / 0.3e1 * t1295 * t3846 + 0.1e2 / 0.9e1 * t1267 * t3846 - 0.1e2 / 0.3e1 * t1758 * t1608 - 0.2e2 / 0.3e1 * t200 * t3855 * t1584 + 0.1e3 / 0.9e1 * t3859 * t1608 - 0.4e2 / 0.9e1 * t3862 * t1290 * t3863 - 0.4e2 / 0.3e1 * t3862 * t532 * t3863 + 0.1e3 / 0.9e1 * t3859 * t1611 + 0.4e1 / 0.9e1 * t2762 * t3822;
  t3881 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t506 * t806 - t3688 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t190 * t1834 + t3666 - t3695 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t72 * (t3750 + t3783 + t3839 + t3874));
  tv4rho2sigma217 = t6 * t3881 + 0.2e1 * t1839;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t3888 = t5 * t116 * t1927 / 0.8e1;
  t3891 = t1842 * t120;
  t3918 = -0.2e1 * t624 * t1723 - 0.6e1 * t970 * t973 * t3891 + 0.6e1 * t376 * t977 * t3891 - t145 * t981 * t3891 - 0.8e1 / 0.3e1 * t376 * t379 * t3891 + 0.4e1 / 0.3e1 * t145 * t383 * t3891 - 0.4e1 * t3614 * t629 + 0.2e1 * t1652 * t632 + 0.6e1 * t3150 * t1711 - 0.6e1 * t1384 * t1714 + t624 * t1717 - 0.4e1 * t2115 * t2118 * t3891;
  t3938 = t3891 * t46;
  t3948 = 0.6e1 * t970 * t2124 * t3891 - 0.7e1 / 0.3e1 * t376 * t2128 * t3891 + t145 * t2132 * t3891 / 0.6e1 + 0.4e1 * t1384 * t1720 + 0.3e1 / 0.2e1 * t3144 * t745 - 0.3e1 / 0.4e1 * t1380 * t748 - 0.3e1 / 0.4e1 * t2104 * t1884 + 0.3e1 / 0.4e1 * t961 * t1887 - t3159 * t3938 / 0.6e1 + 0.3e1 / 0.2e1 * t1380 * t751 - 0.3e1 / 0.2e1 * t961 * t1918 + 0.3e1 / 0.4e1 * t369 * t1921 - t369 * t1924;
  t3951 = t1859 * t143 * params->a9;
  t3982 = t911 * t1897 * t120;
  t3988 = t2193 * t1842;
  t3989 = t333 * t3988;
  t3992 = t906 * t3988;
  t3993 = t2212 * t120;
  t4000 = 0.4e1 / 0.3e1 * t3951 * t147 - t369 * t1868 / 0.8e1 + t1374 * t3938 - 0.4e1 / 0.3e1 * t595 * t3938 - 0.3e1 / 0.2e1 * t3610 * t247 + (t49 * t2257 * t120 * t1842 / 0.6e1 - t49 * t1662 * t1842 + 0.4e1 / 0.3e1 * t49 * t614 * t1842 - t51 * t2270 * t120 * t1842 / 0.6e1 + t51 * t1669 * t1842 - 0.4e1 / 0.3e1 * t51 * t617 * t1842) * t56 - t909 * t3982 - 0.3e1 * t918 * t3982 - 0.7e1 * t1907 * t604 - 0.25e2 / 0.6e1 * t3989 * t1686 + 0.5e1 / 0.3e1 * t3992 * t908 * t3993 + 0.5e1 * t3992 * t335 * t3993;
  t4001 = params->a3 * t316;
  t4006 = t1864 * t120;
  t4007 = t338 * t4006;
  t4012 = t2822 * t4006;
  t4019 = t2194 * t1842 * t2196 * t120;
  t4036 = 0.4e1 * t128 * t4001 * t1861 * t120 - 0.4e1 / 0.3e1 * t336 * t4007 - 0.4e1 / 0.3e1 * t349 * t4007 + 0.6e1 * t349 * t4012 - 0.2e1 * t925 * t3982 - t2191 * t4019 + 0.5e1 / 0.2e1 * t126 * t3988 * t604 - 0.25e2 / 0.6e1 * t3989 * t1689 + 0.1e2 / 0.3e1 * t3992 * t127 * t3993 - t2227 * t4019 / 0.6e1 - t2230 * t4019 - 0.11e2 / 0.6e1 * t2233 * t4019 + 0.6e1 * t336 * t4012;
  t4043 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t1927 - t3888 - 0.3e1 / 0.8e1 * t5 * t27 * (t3918 + t3948 + t4000 + t4036));
  tv4rhosigma30 = t6 * t4043 + t1931;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t4050 = t5 * t166 * t2018 / 0.8e1;
  t4052 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t162 * t2018 - t4050);
  tv4rhosigma39 = t6 * t4052 + t2022;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t4058 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t179 * t1927 - t3888);
  tv4rhosigma310 = t6 * t4058 + t1931;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t4063 = t1933 * t194;
  t4093 = 0.6e1 * t568 * t1253 * t4063 - t218 * t1257 * t4063 - 0.8e1 / 0.3e1 * t568 * t570 * t4063 + 0.4e1 / 0.3e1 * t218 * t574 * t4063 - 0.4e1 * t3775 * t694 + 0.2e1 * t1787 * t697 + 0.6e1 * t3422 * t1818 - 0.6e1 * t1547 * t1821 + t689 * t1824 - 0.4e1 * t2906 * t2908 * t4063 + 0.6e1 * t1245 * t2912 * t4063 - 0.7e1 / 0.3e1 * t568 * t2916 * t4063;
  t4130 = t4063 * t85;
  t4135 = t1954 * t216 * params->a9;
  t4141 = t218 * t2920 * t4063 / 0.6e1 + 0.4e1 * t1547 * t1827 - 0.2e1 * t689 * t1830 - 0.6e1 * t1245 * t1247 * t4063 + (t88 * t2257 * t194 * t1933 / 0.6e1 - t88 * t1798 * t1933 + 0.4e1 / 0.3e1 * t88 * t679 * t1933 - t90 * t2270 * t194 * t1933 / 0.6e1 + t90 * t1805 * t1933 - 0.4e1 / 0.3e1 * t90 * t682 * t1933) * t95 + 0.3e1 / 0.2e1 * t1543 * t803 - 0.3e1 / 0.2e1 * t1237 * t2009 + 0.3e1 / 0.4e1 * t562 * t2012 - t3406 * t4130 / 0.6e1 - t562 * t2015 + 0.4e1 / 0.3e1 * t4135 * t220 + t1537 * t4130 - 0.4e1 / 0.3e1 * t660 * t4130;
  t4157 = t2194 * t1933 * t2764 * t194;
  t4161 = t2193 * t1933;
  t4162 = t531 * t4161;
  t4167 = t1266 * t4161;
  t4168 = t2815 * t194;
  t4175 = -0.3e1 / 0.2e1 * t3771 * t271 + 0.3e1 / 0.2e1 * t3416 * t797 - 0.3e1 / 0.4e1 * t1543 * t800 - 0.3e1 / 0.4e1 * t2894 * t1976 + 0.3e1 / 0.4e1 * t1237 * t1979 - t562 * t1982 / 0.8e1 - t2762 * t4157 / 0.6e1 - t2769 * t4157 - 0.25e2 / 0.6e1 * t4162 * t1760 - 0.25e2 / 0.6e1 * t4162 * t1763 + 0.5e1 / 0.3e1 * t4167 * t1290 * t4168 + 0.5e1 * t4167 * t532 * t4168;
  t4176 = t1956 * t194;
  t4177 = t338 * t4176;
  t4182 = t2822 * t4176;
  t4185 = t1988 * t194;
  t4186 = t911 * t4185;
  t4209 = -0.4e1 / 0.3e1 * t544 * t4177 - 0.7e1 * t1992 * t669 + 0.6e1 * t544 * t4182 - 0.2e1 * t1267 * t4186 + 0.1e2 / 0.3e1 * t1267 * t2793 * t4185 - 0.11e2 / 0.6e1 * t2797 * t4157 - t2800 * t4157 + 0.5e1 / 0.2e1 * t200 * t4161 * t669 + 0.6e1 * t533 * t4182 - t1291 * t4186 - 0.3e1 * t1295 * t4186 + 0.4e1 * t202 * t4001 * t1960 * t194 - 0.4e1 / 0.3e1 * t533 * t4177;
  t4216 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t190 * t2018 - t4050 - 0.3e1 / 0.8e1 * t5 * t72 * (t4093 + t4141 + t4175 + t4209));
  tv4rhosigma319 = t6 * t4216 + t2022;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t4218 = t707 * t707;
  t4219 = 0.1e1 / t4218;
  t4228 = t888 * t4219;
  t4232 = t2193 * t4219;
  t4278 = 0.11e2 / 0.4e1 * t42 * t316 * t4219 * t46 - 0.3e1 * t42 * params->a2 * t4219 * t46 - 0.3e1 / 0.4e1 * t42 * t4228 * t46 + t42 * t4232 * t46 / 0.16e2 + (-t49 * t2257 * t4219 / 0.16e2 + 0.3e1 / 0.4e1 * t49 * t864 * t4219 - 0.11e2 / 0.4e1 * t49 * t352 * t4219 + 0.3e1 * t49 * params->a6 * t4219 + t51 * t2270 * t4219 / 0.16e2 - 0.3e1 / 0.4e1 * t51 * t876 * t4219 + 0.11e2 / 0.4e1 * t51 * t359 * t4219 - 0.3e1 * t51 * params->a8 * t4219) * t56 + 0.11e2 / 0.2e1 * t376 * t379 * t4219 - 0.11e2 / 0.4e1 * t145 * t383 * t4219 + 0.3e1 * t145 * t146 * t4219 + 0.3e1 / 0.4e1 * t145 * t981 * t4219 + 0.3e1 * t1652 * t751 - 0.6e1 * t1384 * t1918;
  t4305 = 0.3e1 * t624 * t1921 + 0.9e1 / 0.2e1 * t970 * t973 * t4219 - 0.9e1 / 0.2e1 * t376 * t977 * t4219 - 0.4e1 * t624 * t1924 + 0.3e1 * t3614 * t745 - 0.3e1 / 0.2e1 * t1652 * t748 - 0.3e1 * t3150 * t1884 + 0.3e1 * t1384 * t1887 + 0.3e1 / 0.2e1 * t2115 * t2118 * t4219 - 0.9e1 / 0.4e1 * t970 * t2124 * t4219 - 0.2e1 * t3951 * t247;
  t4316 = t911 * t4219 * t913;
  t4325 = t4219 * t130;
  t4332 = t2194 * t4219 * t2196;
  t4338 = t333 * t4232;
  t4341 = -t624 * t1868 / 0.2e1 + 0.7e1 / 0.8e1 * t376 * t2128 * t4219 - t145 * t2132 * t4219 / 0.16e2 + 0.9e1 / 0.4e1 * t918 * t4316 + 0.21e2 / 0.4e1 * t126 * t4228 * t329 - 0.9e1 / 0.2e1 * t333 * t4228 * t902 + 0.3e1 * t128 * t129 * t4325 + 0.3e1 / 0.2e1 * t925 * t4316 + 0.3e1 / 0.8e1 * t2191 * t4332 - 0.15e2 / 0.16e2 * t126 * t4232 * t329 + 0.25e2 / 0.16e2 * t4338 * t899;
  t4342 = t906 * t4232;
  t4360 = t4219 * t340;
  t4361 = t338 * t4360;
  t4371 = -0.5e1 / 0.8e1 * t4342 * t2213 - 0.15e2 / 0.8e1 * t4342 * t2216 + 0.25e2 / 0.16e2 * t4338 * t902 - 0.5e1 / 0.4e1 * t4342 * t2222 + t2227 * t4332 / 0.16e2 + 0.3e1 / 0.8e1 * t2230 * t4332 + 0.11e2 / 0.16e2 * t2233 * t4332 - 0.33e2 / 0.4e1 * t128 * t4001 * t4325 + 0.11e2 / 0.4e1 * t336 * t4361 + 0.11e2 / 0.4e1 * t349 * t4361 - 0.9e1 / 0.2e1 * t336 * t2822 * t4360 + 0.3e1 / 0.4e1 * t909 * t4316;
  t4377 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t4278 + t4305 + t4341 + t4371));
  tv4sigma40 = t6 * t4377;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t4378 = t759 * t759;
  t4379 = 0.1e1 / t4378;
  t4388 = t2193 * t4379;
  t4392 = t888 * t4379;
  t4437 = 0.11e2 / 0.4e1 * t81 * t316 * t4379 * t85 - 0.3e1 * t81 * params->a2 * t4379 * t85 + t81 * t4388 * t85 / 0.16e2 - 0.3e1 / 0.4e1 * t81 * t4392 * t85 + (-t88 * t2257 * t4379 / 0.16e2 + 0.3e1 / 0.4e1 * t88 * t864 * t4379 - 0.11e2 / 0.4e1 * t88 * t352 * t4379 + 0.3e1 * t88 * params->a6 * t4379 + t90 * t2270 * t4379 / 0.16e2 - 0.3e1 / 0.4e1 * t90 * t876 * t4379 + 0.11e2 / 0.4e1 * t90 * t359 * t4379 - 0.3e1 * t90 * params->a8 * t4379) * t95 - 0.4e1 * t689 * t2015 + 0.11e2 / 0.2e1 * t568 * t570 * t4379 - 0.11e2 / 0.4e1 * t218 * t574 * t4379 + 0.3e1 * t218 * t219 * t4379 + 0.3e1 * t1787 * t803 - 0.6e1 * t1547 * t2009;
  t4464 = 0.3e1 * t689 * t2012 + 0.3e1 * t3775 * t797 - 0.3e1 / 0.2e1 * t1787 * t800 - 0.3e1 * t3422 * t1976 + 0.3e1 * t1547 * t1979 - t689 * t1982 / 0.2e1 + 0.3e1 / 0.2e1 * t2906 * t2908 * t4379 - 0.9e1 / 0.4e1 * t1245 * t2912 * t4379 + 0.7e1 / 0.8e1 * t568 * t2916 * t4379 - t218 * t2920 * t4379 / 0.16e2 - 0.2e1 * t4135 * t271;
  t4475 = t4379 * t535;
  t4476 = t338 * t4475;
  t4482 = t2822 * t4475;
  t4485 = t4379 * t1269;
  t4486 = t911 * t4485;
  t4498 = 0.9e1 / 0.2e1 * t1245 * t1247 * t4379 - 0.9e1 / 0.2e1 * t568 * t1253 * t4379 + 0.3e1 / 0.4e1 * t218 * t1257 * t4379 + 0.11e2 / 0.4e1 * t544 * t4476 + 0.21e2 / 0.4e1 * t200 * t4392 * t527 - 0.9e1 / 0.2e1 * t544 * t4482 + 0.3e1 / 0.2e1 * t1267 * t4486 - 0.15e2 / 0.16e2 * t200 * t4388 * t527 - 0.9e1 / 0.2e1 * t533 * t4482 + 0.3e1 / 0.4e1 * t1291 * t4486 + 0.11e2 / 0.4e1 * t533 * t4476;
  t4499 = t4379 * t203;
  t4504 = t2194 * t4379 * t2764;
  t4516 = t531 * t4388;
  t4521 = t1266 * t4388;
  t4531 = 0.3e1 * t202 * t129 * t4499 + t2762 * t4504 / 0.16e2 + 0.3e1 / 0.8e1 * t2769 * t4504 - 0.5e1 / 0.4e1 * t1267 * t2793 * t4485 + 0.11e2 / 0.16e2 * t2797 * t4504 + 0.3e1 / 0.8e1 * t2800 * t4504 + 0.25e2 / 0.16e2 * t4516 * t1284 + 0.25e2 / 0.16e2 * t4516 * t1287 - 0.5e1 / 0.8e1 * t4521 * t2816 - 0.15e2 / 0.8e1 * t4521 * t2819 + 0.9e1 / 0.4e1 * t1295 * t4486 - 0.33e2 / 0.4e1 * t202 * t4001 * t4499;
  t4537 = my_piecewise3(t63, 0, -0.3e1 / 0.8e1 * t5 * t72 * (t4437 + t4464 + t4498 + t4531));
  tv4sigma414 = t6 * t4537;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

