/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - scanner_init
 * - core_yylex_init
 * - core_yyalloc
 * - yy_init_globals
 * - core_yyset_extra
 * - backslash_quote
 * - escape_string_warning
 * - standard_conforming_strings
 * - core_yy_scan_buffer
 * - core_yy_switch_to_buffer
 * - core_yyensure_buffer_stack
 * - core_yyrealloc
 * - core_yy_load_buffer_state
 * - yy_fatal_error
 * - fprintf_to_ereport
 * - ScanKeywordTokens
 * - core_yylex
 * - core_yy_create_buffer
 * - core_yy_init_buffer
 * - core_yy_flush_buffer
 * - core_yyrestart
 * - yy_start_state_list
 * - yy_transition
 * - addlitchar
 * - addlit
 * - litbufdup
 * - check_escape_warning
 * - addunicode
 * - setup_scanner_errposition_callback
 * - scb_error_callback
 * - cancel_scanner_errposition_callback
 * - check_string_escape_warning
 * - unescape_single_char
 * - process_integer_literal
 * - yy_get_previous_state
 * - yy_try_NUL_trans
 * - yy_get_next_buffer
 * - scanner_errposition
 * - scanner_yyerror
 * - scanner_finish
 *--------------------------------------------------------------------
 */

#line 1 "scan.c"
/*-------------------------------------------------------------------------
 *
 * scan.l
 *	  lexical scanner for PostgreSQL
 *
 * NOTE NOTE NOTE:
 *
 * The rules in this file must be kept in sync with src/fe_utils/psqlscan.l
 * and src/interfaces/ecpg/preproc/pgc.l!
 *
 * The rules are designed so that the scanner never has to backtrack,
 * in the sense that there is always a rule that can match the input
 * consumed so far (the rule action may internally throw back some input
 * with yyless(), however).  As explained in the flex manual, this makes
 * for a useful speed increase --- several percent faster when measuring
 * raw parsing (Flex + Bison).  The extra complexity is mostly in the rules
 * for handling float numbers and continued string literals.  If you change
 * the lexical rules, verify that you haven't broken the no-backtrack
 * property by running flex with the "-b" option and checking that the
 * resulting "lex.backup" file says that no backing up is needed.  (As of
 * Postgres 9.2, this check is made automatically by the Makefile.)
 *
 *
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/backend/parser/scan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <ctype.h>
#include <unistd.h>

#include "common/string.h"
#include "parser/gramparse.h"
#include "parser/parser.h"		/* only needed for GUC variables */
#include "parser/scansup.h"
#include "port/pg_bitutils.h"
#include "mb/pg_wchar.h"

#line 45 "scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define core_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer core_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define core_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer core_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define core_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer core_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define core_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string core_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define core_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes core_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define core_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer core_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define core_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer core_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define core_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state core_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define core_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer core_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define core_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state core_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define core_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state core_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define core_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack core_yyensure_buffer_stack
#endif

#ifdef yylex
#define core_yylex_ALREADY_DEFINED
#else
#define yylex core_yylex
#endif

#ifdef yyrestart
#define core_yyrestart_ALREADY_DEFINED
#else
#define yyrestart core_yyrestart
#endif

#ifdef yylex_init
#define core_yylex_init_ALREADY_DEFINED
#else
#define yylex_init core_yylex_init
#endif

#ifdef yylex_init_extra
#define core_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra core_yylex_init_extra
#endif

#ifdef yylex_destroy
#define core_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy core_yylex_destroy
#endif

#ifdef yyget_debug
#define core_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug core_yyget_debug
#endif

#ifdef yyset_debug
#define core_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug core_yyset_debug
#endif

#ifdef yyget_extra
#define core_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra core_yyget_extra
#endif

#ifdef yyset_extra
#define core_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra core_yyset_extra
#endif

#ifdef yyget_in
#define core_yyget_in_ALREADY_DEFINED
#else
#define yyget_in core_yyget_in
#endif

#ifdef yyset_in
#define core_yyset_in_ALREADY_DEFINED
#else
#define yyset_in core_yyset_in
#endif

#ifdef yyget_out
#define core_yyget_out_ALREADY_DEFINED
#else
#define yyget_out core_yyget_out
#endif

#ifdef yyset_out
#define core_yyset_out_ALREADY_DEFINED
#else
#define yyset_out core_yyset_out
#endif

#ifdef yyget_leng
#define core_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng core_yyget_leng
#endif

#ifdef yyget_text
#define core_yyget_text_ALREADY_DEFINED
#else
#define yyget_text core_yyget_text
#endif

#ifdef yyget_lineno
#define core_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno core_yyget_lineno
#endif

#ifdef yyset_lineno
#define core_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno core_yyset_lineno
#endif

#ifdef yyget_column
#define core_yyget_column_ALREADY_DEFINED
#else
#define yyget_column core_yyget_column
#endif

#ifdef yyset_column
#define core_yyset_column_ALREADY_DEFINED
#else
#define yyset_column core_yyset_column
#endif

#ifdef yywrap
#define core_yywrap_ALREADY_DEFINED
#else
#define yywrap core_yywrap
#endif

#ifdef yyget_lval
#define core_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval core_yyget_lval
#endif

#ifdef yyset_lval
#define core_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval core_yyset_lval
#endif

#ifdef yyget_lloc
#define core_yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc core_yyget_lloc
#endif

#ifdef yyset_lloc
#define core_yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc core_yyset_lloc
#endif

#ifdef yyalloc
#define core_yyalloc_ALREADY_DEFINED
#else
#define yyalloc core_yyalloc
#endif

#ifdef yyrealloc
#define core_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc core_yyrealloc
#endif

#ifdef yyfree
#define core_yyfree_ALREADY_DEFINED
#else
#define yyfree core_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
typedef uint64_t flex_uint64_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, yy_size_t len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define core_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (yy_size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 68
#define YY_END_OF_BUFFER 69
struct yy_trans_info
	{
	flex_int16_t yy_verify;
	flex_int16_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[19331] =
    {
 {   0,   0 }, {   0,19075 }, {   0,   0 }, {   0,19073 }, {   1,6192 },
 {   2,6192 }, {   3,6192 }, {   4,6192 }, {   5,6192 }, {   6,6192 },
 {   7,6192 }, {   8,6192 }, {   9,6194 }, {  10,6199 }, {  11,6192 },
 {  12,6194 }, {  13,6194 }, {  14,6192 }, {  15,6192 }, {  16,6192 },
 {  17,6192 }, {  18,6192 }, {  19,6192 }, {  20,6192 }, {  21,6192 },
 {  22,6192 }, {  23,6192 }, {  24,6192 }, {  25,6192 }, {  26,6192 },
 {  27,6192 }, {  28,6192 }, {  29,6192 }, {  30,6192 }, {  31,6192 },
 {  32,6194 }, {  33,6201 }, {  34,6196 }, {  35,6241 }, {  36,6307 },
 {  37,6564 }, {  38,6241 }, {  39,6214 }, {  40,6216 }, {  41,6216 },
 {  42,6564 }, {  43,6564 }, {  44,6216 }, {  45,6575 }, {  46,6594 },

 {  47,6665 }, {  48,6697 }, {  49,6697 }, {  50,6697 }, {  51,6697 },
 {  52,6697 }, {  53,6697 }, {  54,6697 }, {  55,6697 }, {  56,6697 },
 {  57,6697 }, {  58,6219 }, {  59,6216 }, {  60,6954 }, {  61,6965 },
 {  62,7032 }, {  63,6241 }, {  64,6241 }, {  65,7064 }, {  66,7321 },
 {  67,7064 }, {  68,7064 }, {  69,7578 }, {  70,7064 }, {  71,7064 },
 {  72,7064 }, {  73,7064 }, {  74,7064 }, {  75,7064 }, {  76,7064 },
 {  77,7064 }, {  78,7835 }, {  79,7064 }, {  80,7064 }, {  81,7064 },
 {  82,7064 }, {  83,7064 }, {  84,7064 }, {  85,8092 }, {  86,7064 },
 {  87,7064 }, {  88,8349 }, {  89,7064 }, {  90,7064 }, {  91,6216 },
 {  92,6192 }, {  93,6216 }, {  94,6564 }, {  95,7064 }, {  96,6241 },

 {  97,7064 }, {  98,7321 }, {  99,7064 }, { 100,7064 }, { 101,7578 },
 { 102,7064 }, { 103,7064 }, { 104,7064 }, { 105,7064 }, { 106,7064 },
 { 107,7064 }, { 108,7064 }, { 109,7064 }, { 110,7835 }, { 111,7064 },
 { 112,7064 }, { 113,7064 }, { 114,7064 }, { 115,7064 }, { 116,7064 },
 { 117,8092 }, { 118,7064 }, { 119,7064 }, { 120,8349 }, { 121,7064 },
 { 122,7064 }, { 123,6192 }, { 124,6241 }, { 125,6192 }, { 126,6241 },
 { 127,6192 }, { 128,7064 }, { 129,7064 }, { 130,7064 }, { 131,7064 },
 { 132,7064 }, { 133,7064 }, { 134,7064 }, { 135,7064 }, { 136,7064 },
 { 137,7064 }, { 138,7064 }, { 139,7064 }, { 140,7064 }, { 141,7064 },
 { 142,7064 }, { 143,7064 }, { 144,7064 }, { 145,7064 }, { 146,7064 },

 { 147,7064 }, { 148,7064 }, { 149,7064 }, { 150,7064 }, { 151,7064 },
 { 152,7064 }, { 153,7064 }, { 154,7064 }, { 155,7064 }, { 156,7064 },
 { 157,7064 }, { 158,7064 }, { 159,7064 }, { 160,7064 }, { 161,7064 },
 { 162,7064 }, { 163,7064 }, { 164,7064 }, { 165,7064 }, { 166,7064 },
 { 167,7064 }, { 168,7064 }, { 169,7064 }, { 170,7064 }, { 171,7064 },
 { 172,7064 }, { 173,7064 }, { 174,7064 }, { 175,7064 }, { 176,7064 },
 { 177,7064 }, { 178,7064 }, { 179,7064 }, { 180,7064 }, { 181,7064 },
 { 182,7064 }, { 183,7064 }, { 184,7064 }, { 185,7064 }, { 186,7064 },
 { 187,7064 }, { 188,7064 }, { 189,7064 }, { 190,7064 }, { 191,7064 },
 { 192,7064 }, { 193,7064 }, { 194,7064 }, { 195,7064 }, { 196,7064 },

 { 197,7064 }, { 198,7064 }, { 199,7064 }, { 200,7064 }, { 201,7064 },
 { 202,7064 }, { 203,7064 }, { 204,7064 }, { 205,7064 }, { 206,7064 },
 { 207,7064 }, { 208,7064 }, { 209,7064 }, { 210,7064 }, { 211,7064 },
 { 212,7064 }, { 213,7064 }, { 214,7064 }, { 215,7064 }, { 216,7064 },
 { 217,7064 }, { 218,7064 }, { 219,7064 }, { 220,7064 }, { 221,7064 },
 { 222,7064 }, { 223,7064 }, { 224,7064 }, { 225,7064 }, { 226,7064 },
 { 227,7064 }, { 228,7064 }, { 229,7064 }, { 230,7064 }, { 231,7064 },
 { 232,7064 }, { 233,7064 }, { 234,7064 }, { 235,7064 }, { 236,7064 },
 { 237,7064 }, { 238,7064 }, { 239,7064 }, { 240,7064 }, { 241,7064 },
 { 242,7064 }, { 243,7064 }, { 244,7064 }, { 245,7064 }, { 246,7064 },

 { 247,7064 }, { 248,7064 }, { 249,7064 }, { 250,7064 }, { 251,7064 },
 { 252,7064 }, { 253,7064 }, { 254,7064 }, { 255,7064 }, { 256,6192 },
 {   0,   0 }, {   0,18815 }, {   1,5934 }, {   2,5934 }, {   3,5934 },
 {   4,5934 }, {   5,5934 }, {   6,5934 }, {   7,5934 }, {   8,5934 },
 {   9,5936 }, {  10,5941 }, {  11,5934 }, {  12,5936 }, {  13,5936 },
 {  14,5934 }, {  15,5934 }, {  16,5934 }, {  17,5934 }, {  18,5934 },
 {  19,5934 }, {  20,5934 }, {  21,5934 }, {  22,5934 }, {  23,5934 },
 {  24,5934 }, {  25,5934 }, {  26,5934 }, {  27,5934 }, {  28,5934 },
 {  29,5934 }, {  30,5934 }, {  31,5934 }, {  32,5936 }, {  33,5943 },
 {  34,5938 }, {  35,5983 }, {  36,6049 }, {  37,6306 }, {  38,5983 },

 {  39,5956 }, {  40,5958 }, {  41,5958 }, {  42,6306 }, {  43,6306 },
 {  44,5958 }, {  45,6317 }, {  46,6336 }, {  47,6407 }, {  48,6439 },
 {  49,6439 }, {  50,6439 }, {  51,6439 }, {  52,6439 }, {  53,6439 },
 {  54,6439 }, {  55,6439 }, {  56,6439 }, {  57,6439 }, {  58,5961 },
 {  59,5958 }, {  60,6696 }, {  61,6707 }, {  62,6774 }, {  63,5983 },
 {  64,5983 }, {  65,6806 }, {  66,7063 }, {  67,6806 }, {  68,6806 },
 {  69,7320 }, {  70,6806 }, {  71,6806 }, {  72,6806 }, {  73,6806 },
 {  74,6806 }, {  75,6806 }, {  76,6806 }, {  77,6806 }, {  78,7577 },
 {  79,6806 }, {  80,6806 }, {  81,6806 }, {  82,6806 }, {  83,6806 },
 {  84,6806 }, {  85,7834 }, {  86,6806 }, {  87,6806 }, {  88,8091 },

 {  89,6806 }, {  90,6806 }, {  91,5958 }, {  92,5934 }, {  93,5958 },
 {  94,6306 }, {  95,6806 }, {  96,5983 }, {  97,6806 }, {  98,7063 },
 {  99,6806 }, { 100,6806 }, { 101,7320 }, { 102,6806 }, { 103,6806 },
 { 104,6806 }, { 105,6806 }, { 106,6806 }, { 107,6806 }, { 108,6806 },
 { 109,6806 }, { 110,7577 }, { 111,6806 }, { 112,6806 }, { 113,6806 },
 { 114,6806 }, { 115,6806 }, { 116,6806 }, { 117,7834 }, { 118,6806 },
 { 119,6806 }, { 120,8091 }, { 121,6806 }, { 122,6806 }, { 123,5934 },
 { 124,5983 }, { 125,5934 }, { 126,5983 }, { 127,5934 }, { 128,6806 },
 { 129,6806 }, { 130,6806 }, { 131,6806 }, { 132,6806 }, { 133,6806 },
 { 134,6806 }, { 135,6806 }, { 136,6806 }, { 137,6806 }, { 138,6806 },

 { 139,6806 }, { 140,6806 }, { 141,6806 }, { 142,6806 }, { 143,6806 },
 { 144,6806 }, { 145,6806 }, { 146,6806 }, { 147,6806 }, { 148,6806 },
 { 149,6806 }, { 150,6806 }, { 151,6806 }, { 152,6806 }, { 153,6806 },
 { 154,6806 }, { 155,6806 }, { 156,6806 }, { 157,6806 }, { 158,6806 },
 { 159,6806 }, { 160,6806 }, { 161,6806 }, { 162,6806 }, { 163,6806 },
 { 164,6806 }, { 165,6806 }, { 166,6806 }, { 167,6806 }, { 168,6806 },
 { 169,6806 }, { 170,6806 }, { 171,6806 }, { 172,6806 }, { 173,6806 },
 { 174,6806 }, { 175,6806 }, { 176,6806 }, { 177,6806 }, { 178,6806 },
 { 179,6806 }, { 180,6806 }, { 181,6806 }, { 182,6806 }, { 183,6806 },
 { 184,6806 }, { 185,6806 }, { 186,6806 }, { 187,6806 }, { 188,6806 },

 { 189,6806 }, { 190,6806 }, { 191,6806 }, { 192,6806 }, { 193,6806 },
 { 194,6806 }, { 195,6806 }, { 196,6806 }, { 197,6806 }, { 198,6806 },
 { 199,6806 }, { 200,6806 }, { 201,6806 }, { 202,6806 }, { 203,6806 },
 { 204,6806 }, { 205,6806 }, { 206,6806 }, { 207,6806 }, { 208,6806 },
 { 209,6806 }, { 210,6806 }, { 211,6806 }, { 212,6806 }, { 213,6806 },
 { 214,6806 }, { 215,6806 }, { 216,6806 }, { 217,6806 }, { 218,6806 },
 { 219,6806 }, { 220,6806 }, { 221,6806 }, { 222,6806 }, { 223,6806 },
 { 224,6806 }, { 225,6806 }, { 226,6806 }, { 227,6806 }, { 228,6806 },
 { 229,6806 }, { 230,6806 }, { 231,6806 }, { 232,6806 }, { 233,6806 },
 { 234,6806 }, { 235,6806 }, { 236,6806 }, { 237,6806 }, { 238,6806 },

 { 239,6806 }, { 240,6806 }, { 241,6806 }, { 242,6806 }, { 243,6806 },
 { 244,6806 }, { 245,6806 }, { 246,6806 }, { 247,6806 }, { 248,6806 },
 { 249,6806 }, { 250,6806 }, { 251,6806 }, { 252,6806 }, { 253,6806 },
 { 254,6806 }, { 255,6806 }, { 256,5934 }, {   0,  11 }, {   0,18557 },
 {   1,8090 }, {   2,8090 }, {   3,8090 }, {   4,8090 }, {   5,8090 },
 {   6,8090 }, {   7,8090 }, {   8,8090 }, {   9,8090 }, {  10,8090 },
 {  11,8090 }, {  12,8090 }, {  13,8090 }, {  14,8090 }, {  15,8090 },
 {  16,8090 }, {  17,8090 }, {  18,8090 }, {  19,8090 }, {  20,8090 },
 {  21,8090 }, {  22,8090 }, {  23,8090 }, {  24,8090 }, {  25,8090 },
 {  26,8090 }, {  27,8090 }, {  28,8090 }, {  29,8090 }, {  30,8090 },

 {  31,8090 }, {  32,8090 }, {  33,8090 }, {  34,8090 }, {  35,8090 },
 {  36,8090 }, {  37,8090 }, {  38,8090 }, {  39,5705 }, {  40,8090 },
 {  41,8090 }, {  42,8090 }, {  43,8090 }, {  44,8090 }, {  45,8090 },
 {  46,8090 }, {  47,8090 }, {  48,8090 }, {  49,8090 }, {  50,8090 },
 {  51,8090 }, {  52,8090 }, {  53,8090 }, {  54,8090 }, {  55,8090 },
 {  56,8090 }, {  57,8090 }, {  58,8090 }, {  59,8090 }, {  60,8090 },
 {  61,8090 }, {  62,8090 }, {  63,8090 }, {  64,8090 }, {  65,8090 },
 {  66,8090 }, {  67,8090 }, {  68,8090 }, {  69,8090 }, {  70,8090 },
 {  71,8090 }, {  72,8090 }, {  73,8090 }, {  74,8090 }, {  75,8090 },
 {  76,8090 }, {  77,8090 }, {  78,8090 }, {  79,8090 }, {  80,8090 },

 {  81,8090 }, {  82,8090 }, {  83,8090 }, {  84,8090 }, {  85,8090 },
 {  86,8090 }, {  87,8090 }, {  88,8090 }, {  89,8090 }, {  90,8090 },
 {  91,8090 }, {  92,8090 }, {  93,8090 }, {  94,8090 }, {  95,8090 },
 {  96,8090 }, {  97,8090 }, {  98,8090 }, {  99,8090 }, { 100,8090 },
 { 101,8090 }, { 102,8090 }, { 103,8090 }, { 104,8090 }, { 105,8090 },
 { 106,8090 }, { 107,8090 }, { 108,8090 }, { 109,8090 }, { 110,8090 },
 { 111,8090 }, { 112,8090 }, { 113,8090 }, { 114,8090 }, { 115,8090 },
 { 116,8090 }, { 117,8090 }, { 118,8090 }, { 119,8090 }, { 120,8090 },
 { 121,8090 }, { 122,8090 }, { 123,8090 }, { 124,8090 }, { 125,8090 },
 { 126,8090 }, { 127,8090 }, { 128,8090 }, { 129,8090 }, { 130,8090 },

 { 131,8090 }, { 132,8090 }, { 133,8090 }, { 134,8090 }, { 135,8090 },
 { 136,8090 }, { 137,8090 }, { 138,8090 }, { 139,8090 }, { 140,8090 },
 { 141,8090 }, { 142,8090 }, { 143,8090 }, { 144,8090 }, { 145,8090 },
 { 146,8090 }, { 147,8090 }, { 148,8090 }, { 149,8090 }, { 150,8090 },
 { 151,8090 }, { 152,8090 }, { 153,8090 }, { 154,8090 }, { 155,8090 },
 { 156,8090 }, { 157,8090 }, { 158,8090 }, { 159,8090 }, { 160,8090 },
 { 161,8090 }, { 162,8090 }, { 163,8090 }, { 164,8090 }, { 165,8090 },
 { 166,8090 }, { 167,8090 }, { 168,8090 }, { 169,8090 }, { 170,8090 },
 { 171,8090 }, { 172,8090 }, { 173,8090 }, { 174,8090 }, { 175,8090 },
 { 176,8090 }, { 177,8090 }, { 178,8090 }, { 179,8090 }, { 180,8090 },

 { 181,8090 }, { 182,8090 }, { 183,8090 }, { 184,8090 }, { 185,8090 },
 { 186,8090 }, { 187,8090 }, { 188,8090 }, { 189,8090 }, { 190,8090 },
 { 191,8090 }, { 192,8090 }, { 193,8090 }, { 194,8090 }, { 195,8090 },
 { 196,8090 }, { 197,8090 }, { 198,8090 }, { 199,8090 }, { 200,8090 },
 { 201,8090 }, { 202,8090 }, { 203,8090 }, { 204,8090 }, { 205,8090 },
 { 206,8090 }, { 207,8090 }, { 208,8090 }, { 209,8090 }, { 210,8090 },
 { 211,8090 }, { 212,8090 }, { 213,8090 }, { 214,8090 }, { 215,8090 },
 { 216,8090 }, { 217,8090 }, { 218,8090 }, { 219,8090 }, { 220,8090 },
 { 221,8090 }, { 222,8090 }, { 223,8090 }, { 224,8090 }, { 225,8090 },
 { 226,8090 }, { 227,8090 }, { 228,8090 }, { 229,8090 }, { 230,8090 },

 { 231,8090 }, { 232,8090 }, { 233,8090 }, { 234,8090 }, { 235,8090 },
 { 236,8090 }, { 237,8090 }, { 238,8090 }, { 239,8090 }, { 240,8090 },
 { 241,8090 }, { 242,8090 }, { 243,8090 }, { 244,8090 }, { 245,8090 },
 { 246,8090 }, { 247,8090 }, { 248,8090 }, { 249,8090 }, { 250,8090 },
 { 251,8090 }, { 252,8090 }, { 253,8090 }, { 254,8090 }, { 255,8090 },
 { 256,8090 }, {   0,  11 }, {   0,18299 }, {   1,7832 }, {   2,7832 },
 {   3,7832 }, {   4,7832 }, {   5,7832 }, {   6,7832 }, {   7,7832 },
 {   8,7832 }, {   9,7832 }, {  10,7832 }, {  11,7832 }, {  12,7832 },
 {  13,7832 }, {  14,7832 }, {  15,7832 }, {  16,7832 }, {  17,7832 },
 {  18,7832 }, {  19,7832 }, {  20,7832 }, {  21,7832 }, {  22,7832 },

 {  23,7832 }, {  24,7832 }, {  25,7832 }, {  26,7832 }, {  27,7832 },
 {  28,7832 }, {  29,7832 }, {  30,7832 }, {  31,7832 }, {  32,7832 },
 {  33,7832 }, {  34,7832 }, {  35,7832 }, {  36,7832 }, {  37,7832 },
 {  38,7832 }, {  39,5447 }, {  40,7832 }, {  41,7832 }, {  42,7832 },
 {  43,7832 }, {  44,7832 }, {  45,7832 }, {  46,7832 }, {  47,7832 },
 {  48,7832 }, {  49,7832 }, {  50,7832 }, {  51,7832 }, {  52,7832 },
 {  53,7832 }, {  54,7832 }, {  55,7832 }, {  56,7832 }, {  57,7832 },
 {  58,7832 }, {  59,7832 }, {  60,7832 }, {  61,7832 }, {  62,7832 },
 {  63,7832 }, {  64,7832 }, {  65,7832 }, {  66,7832 }, {  67,7832 },
 {  68,7832 }, {  69,7832 }, {  70,7832 }, {  71,7832 }, {  72,7832 },

 {  73,7832 }, {  74,7832 }, {  75,7832 }, {  76,7832 }, {  77,7832 },
 {  78,7832 }, {  79,7832 }, {  80,7832 }, {  81,7832 }, {  82,7832 },
 {  83,7832 }, {  84,7832 }, {  85,7832 }, {  86,7832 }, {  87,7832 },
 {  88,7832 }, {  89,7832 }, {  90,7832 }, {  91,7832 }, {  92,7832 },
 {  93,7832 }, {  94,7832 }, {  95,7832 }, {  96,7832 }, {  97,7832 },
 {  98,7832 }, {  99,7832 }, { 100,7832 }, { 101,7832 }, { 102,7832 },
 { 103,7832 }, { 104,7832 }, { 105,7832 }, { 106,7832 }, { 107,7832 },
 { 108,7832 }, { 109,7832 }, { 110,7832 }, { 111,7832 }, { 112,7832 },
 { 113,7832 }, { 114,7832 }, { 115,7832 }, { 116,7832 }, { 117,7832 },
 { 118,7832 }, { 119,7832 }, { 120,7832 }, { 121,7832 }, { 122,7832 },

 { 123,7832 }, { 124,7832 }, { 125,7832 }, { 126,7832 }, { 127,7832 },
 { 128,7832 }, { 129,7832 }, { 130,7832 }, { 131,7832 }, { 132,7832 },
 { 133,7832 }, { 134,7832 }, { 135,7832 }, { 136,7832 }, { 137,7832 },
 { 138,7832 }, { 139,7832 }, { 140,7832 }, { 141,7832 }, { 142,7832 },
 { 143,7832 }, { 144,7832 }, { 145,7832 }, { 146,7832 }, { 147,7832 },
 { 148,7832 }, { 149,7832 }, { 150,7832 }, { 151,7832 }, { 152,7832 },
 { 153,7832 }, { 154,7832 }, { 155,7832 }, { 156,7832 }, { 157,7832 },
 { 158,7832 }, { 159,7832 }, { 160,7832 }, { 161,7832 }, { 162,7832 },
 { 163,7832 }, { 164,7832 }, { 165,7832 }, { 166,7832 }, { 167,7832 },
 { 168,7832 }, { 169,7832 }, { 170,7832 }, { 171,7832 }, { 172,7832 },

 { 173,7832 }, { 174,7832 }, { 175,7832 }, { 176,7832 }, { 177,7832 },
 { 178,7832 }, { 179,7832 }, { 180,7832 }, { 181,7832 }, { 182,7832 },
 { 183,7832 }, { 184,7832 }, { 185,7832 }, { 186,7832 }, { 187,7832 },
 { 188,7832 }, { 189,7832 }, { 190,7832 }, { 191,7832 }, { 192,7832 },
 { 193,7832 }, { 194,7832 }, { 195,7832 }, { 196,7832 }, { 197,7832 },
 { 198,7832 }, { 199,7832 }, { 200,7832 }, { 201,7832 }, { 202,7832 },
 { 203,7832 }, { 204,7832 }, { 205,7832 }, { 206,7832 }, { 207,7832 },
 { 208,7832 }, { 209,7832 }, { 210,7832 }, { 211,7832 }, { 212,7832 },
 { 213,7832 }, { 214,7832 }, { 215,7832 }, { 216,7832 }, { 217,7832 },
 { 218,7832 }, { 219,7832 }, { 220,7832 }, { 221,7832 }, { 222,7832 },

 { 223,7832 }, { 224,7832 }, { 225,7832 }, { 226,7832 }, { 227,7832 },
 { 228,7832 }, { 229,7832 }, { 230,7832 }, { 231,7832 }, { 232,7832 },
 { 233,7832 }, { 234,7832 }, { 235,7832 }, { 236,7832 }, { 237,7832 },
 { 238,7832 }, { 239,7832 }, { 240,7832 }, { 241,7832 }, { 242,7832 },
 { 243,7832 }, { 244,7832 }, { 245,7832 }, { 246,7832 }, { 247,7832 },
 { 248,7832 }, { 249,7832 }, { 250,7832 }, { 251,7832 }, { 252,7832 },
 { 253,7832 }, { 254,7832 }, { 255,7832 }, { 256,7832 }, {   0,   0 },
 {   0,18041 }, {   1,7832 }, {   2,7832 }, {   3,7832 }, {   4,7832 },
 {   5,7832 }, {   6,7832 }, {   7,7832 }, {   8,7832 }, {   9,7832 },
 {  10,7832 }, {  11,7832 }, {  12,7832 }, {  13,7832 }, {  14,7832 },

 {  15,7832 }, {  16,7832 }, {  17,7832 }, {  18,7832 }, {  19,7832 },
 {  20,7832 }, {  21,7832 }, {  22,7832 }, {  23,7832 }, {  24,7832 },
 {  25,7832 }, {  26,7832 }, {  27,7832 }, {  28,7832 }, {  29,7832 },
 {  30,7832 }, {  31,7832 }, {  32,7832 }, {  33,8090 }, {  34,7832 },
 {  35,8090 }, {  36,7832 }, {  37,8090 }, {  38,8090 }, {  39,7832 },
 {  40,7832 }, {  41,7832 }, {  42,5192 }, {  43,8090 }, {  44,7832 },
 {  45,8090 }, {  46,7832 }, {  47,5196 }, {  48,7832 }, {  49,7832 },
 {  50,7832 }, {  51,7832 }, {  52,7832 }, {  53,7832 }, {  54,7832 },
 {  55,7832 }, {  56,7832 }, {  57,7832 }, {  58,7832 }, {  59,7832 },
 {  60,8090 }, {  61,8090 }, {  62,8090 }, {  63,8090 }, {  64,8090 },

 {  65,7832 }, {  66,7832 }, {  67,7832 }, {  68,7832 }, {  69,7832 },
 {  70,7832 }, {  71,7832 }, {  72,7832 }, {  73,7832 }, {  74,7832 },
 {  75,7832 }, {  76,7832 }, {  77,7832 }, {  78,7832 }, {  79,7832 },
 {  80,7832 }, {  81,7832 }, {  82,7832 }, {  83,7832 }, {  84,7832 },
 {  85,7832 }, {  86,7832 }, {  87,7832 }, {  88,7832 }, {  89,7832 },
 {  90,7832 }, {  91,7832 }, {  92,7832 }, {  93,7832 }, {  94,8090 },
 {  95,7832 }, {  96,8090 }, {  97,7832 }, {  98,7832 }, {  99,7832 },
 { 100,7832 }, { 101,7832 }, { 102,7832 }, { 103,7832 }, { 104,7832 },
 { 105,7832 }, { 106,7832 }, { 107,7832 }, { 108,7832 }, { 109,7832 },
 { 110,7832 }, { 111,7832 }, { 112,7832 }, { 113,7832 }, { 114,7832 },

 { 115,7832 }, { 116,7832 }, { 117,7832 }, { 118,7832 }, { 119,7832 },
 { 120,7832 }, { 121,7832 }, { 122,7832 }, { 123,7832 }, { 124,8090 },
 { 125,7832 }, { 126,8090 }, { 127,7832 }, { 128,7832 }, { 129,7832 },
 { 130,7832 }, { 131,7832 }, { 132,7832 }, { 133,7832 }, { 134,7832 },
 { 135,7832 }, { 136,7832 }, { 137,7832 }, { 138,7832 }, { 139,7832 },
 { 140,7832 }, { 141,7832 }, { 142,7832 }, { 143,7832 }, { 144,7832 },
 { 145,7832 }, { 146,7832 }, { 147,7832 }, { 148,7832 }, { 149,7832 },
 { 150,7832 }, { 151,7832 }, { 152,7832 }, { 153,7832 }, { 154,7832 },
 { 155,7832 }, { 156,7832 }, { 157,7832 }, { 158,7832 }, { 159,7832 },
 { 160,7832 }, { 161,7832 }, { 162,7832 }, { 163,7832 }, { 164,7832 },

 { 165,7832 }, { 166,7832 }, { 167,7832 }, { 168,7832 }, { 169,7832 },
 { 170,7832 }, { 171,7832 }, { 172,7832 }, { 173,7832 }, { 174,7832 },
 { 175,7832 }, { 176,7832 }, { 177,7832 }, { 178,7832 }, { 179,7832 },
 { 180,7832 }, { 181,7832 }, { 182,7832 }, { 183,7832 }, { 184,7832 },
 { 185,7832 }, { 186,7832 }, { 187,7832 }, { 188,7832 }, { 189,7832 },
 { 190,7832 }, { 191,7832 }, { 192,7832 }, { 193,7832 }, { 194,7832 },
 { 195,7832 }, { 196,7832 }, { 197,7832 }, { 198,7832 }, { 199,7832 },
 { 200,7832 }, { 201,7832 }, { 202,7832 }, { 203,7832 }, { 204,7832 },
 { 205,7832 }, { 206,7832 }, { 207,7832 }, { 208,7832 }, { 209,7832 },
 { 210,7832 }, { 211,7832 }, { 212,7832 }, { 213,7832 }, { 214,7832 },

 { 215,7832 }, { 216,7832 }, { 217,7832 }, { 218,7832 }, { 219,7832 },
 { 220,7832 }, { 221,7832 }, { 222,7832 }, { 223,7832 }, { 224,7832 },
 { 225,7832 }, { 226,7832 }, { 227,7832 }, { 228,7832 }, { 229,7832 },
 { 230,7832 }, { 231,7832 }, { 232,7832 }, { 233,7832 }, { 234,7832 },
 { 235,7832 }, { 236,7832 }, { 237,7832 }, { 238,7832 }, { 239,7832 },
 { 240,7832 }, { 241,7832 }, { 242,7832 }, { 243,7832 }, { 244,7832 },
 { 245,7832 }, { 246,7832 }, { 247,7832 }, { 248,7832 }, { 249,7832 },
 { 250,7832 }, { 251,7832 }, { 252,7832 }, { 253,7832 }, { 254,7832 },
 { 255,7832 }, { 256,7832 }, {   0,   0 }, {   0,17783 }, {   1,7574 },
 {   2,7574 }, {   3,7574 }, {   4,7574 }, {   5,7574 }, {   6,7574 },

 {   7,7574 }, {   8,7574 }, {   9,7574 }, {  10,7574 }, {  11,7574 },
 {  12,7574 }, {  13,7574 }, {  14,7574 }, {  15,7574 }, {  16,7574 },
 {  17,7574 }, {  18,7574 }, {  19,7574 }, {  20,7574 }, {  21,7574 },
 {  22,7574 }, {  23,7574 }, {  24,7574 }, {  25,7574 }, {  26,7574 },
 {  27,7574 }, {  28,7574 }, {  29,7574 }, {  30,7574 }, {  31,7574 },
 {  32,7574 }, {  33,7832 }, {  34,7574 }, {  35,7832 }, {  36,7574 },
 {  37,7832 }, {  38,7832 }, {  39,7574 }, {  40,7574 }, {  41,7574 },
 {  42,4934 }, {  43,7832 }, {  44,7574 }, {  45,7832 }, {  46,7574 },
 {  47,4938 }, {  48,7574 }, {  49,7574 }, {  50,7574 }, {  51,7574 },
 {  52,7574 }, {  53,7574 }, {  54,7574 }, {  55,7574 }, {  56,7574 },

 {  57,7574 }, {  58,7574 }, {  59,7574 }, {  60,7832 }, {  61,7832 },
 {  62,7832 }, {  63,7832 }, {  64,7832 }, {  65,7574 }, {  66,7574 },
 {  67,7574 }, {  68,7574 }, {  69,7574 }, {  70,7574 }, {  71,7574 },
 {  72,7574 }, {  73,7574 }, {  74,7574 }, {  75,7574 }, {  76,7574 },
 {  77,7574 }, {  78,7574 }, {  79,7574 }, {  80,7574 }, {  81,7574 },
 {  82,7574 }, {  83,7574 }, {  84,7574 }, {  85,7574 }, {  86,7574 },
 {  87,7574 }, {  88,7574 }, {  89,7574 }, {  90,7574 }, {  91,7574 },
 {  92,7574 }, {  93,7574 }, {  94,7832 }, {  95,7574 }, {  96,7832 },
 {  97,7574 }, {  98,7574 }, {  99,7574 }, { 100,7574 }, { 101,7574 },
 { 102,7574 }, { 103,7574 }, { 104,7574 }, { 105,7574 }, { 106,7574 },

 { 107,7574 }, { 108,7574 }, { 109,7574 }, { 110,7574 }, { 111,7574 },
 { 112,7574 }, { 113,7574 }, { 114,7574 }, { 115,7574 }, { 116,7574 },
 { 117,7574 }, { 118,7574 }, { 119,7574 }, { 120,7574 }, { 121,7574 },
 { 122,7574 }, { 123,7574 }, { 124,7832 }, { 125,7574 }, { 126,7832 },
 { 127,7574 }, { 128,7574 }, { 129,7574 }, { 130,7574 }, { 131,7574 },
 { 132,7574 }, { 133,7574 }, { 134,7574 }, { 135,7574 }, { 136,7574 },
 { 137,7574 }, { 138,7574 }, { 139,7574 }, { 140,7574 }, { 141,7574 },
 { 142,7574 }, { 143,7574 }, { 144,7574 }, { 145,7574 }, { 146,7574 },
 { 147,7574 }, { 148,7574 }, { 149,7574 }, { 150,7574 }, { 151,7574 },
 { 152,7574 }, { 153,7574 }, { 154,7574 }, { 155,7574 }, { 156,7574 },

 { 157,7574 }, { 158,7574 }, { 159,7574 }, { 160,7574 }, { 161,7574 },
 { 162,7574 }, { 163,7574 }, { 164,7574 }, { 165,7574 }, { 166,7574 },
 { 167,7574 }, { 168,7574 }, { 169,7574 }, { 170,7574 }, { 171,7574 },
 { 172,7574 }, { 173,7574 }, { 174,7574 }, { 175,7574 }, { 176,7574 },
 { 177,7574 }, { 178,7574 }, { 179,7574 }, { 180,7574 }, { 181,7574 },
 { 182,7574 }, { 183,7574 }, { 184,7574 }, { 185,7574 }, { 186,7574 },
 { 187,7574 }, { 188,7574 }, { 189,7574 }, { 190,7574 }, { 191,7574 },
 { 192,7574 }, { 193,7574 }, { 194,7574 }, { 195,7574 }, { 196,7574 },
 { 197,7574 }, { 198,7574 }, { 199,7574 }, { 200,7574 }, { 201,7574 },
 { 202,7574 }, { 203,7574 }, { 204,7574 }, { 205,7574 }, { 206,7574 },

 { 207,7574 }, { 208,7574 }, { 209,7574 }, { 210,7574 }, { 211,7574 },
 { 212,7574 }, { 213,7574 }, { 214,7574 }, { 215,7574 }, { 216,7574 },
 { 217,7574 }, { 218,7574 }, { 219,7574 }, { 220,7574 }, { 221,7574 },
 { 222,7574 }, { 223,7574 }, { 224,7574 }, { 225,7574 }, { 226,7574 },
 { 227,7574 }, { 228,7574 }, { 229,7574 }, { 230,7574 }, { 231,7574 },
 { 232,7574 }, { 233,7574 }, { 234,7574 }, { 235,7574 }, { 236,7574 },
 { 237,7574 }, { 238,7574 }, { 239,7574 }, { 240,7574 }, { 241,7574 },
 { 242,7574 }, { 243,7574 }, { 244,7574 }, { 245,7574 }, { 246,7574 },
 { 247,7574 }, { 248,7574 }, { 249,7574 }, { 250,7574 }, { 251,7574 },
 { 252,7574 }, { 253,7574 }, { 254,7574 }, { 255,7574 }, { 256,7574 },

 {   0,   0 }, {   0,17525 }, {   1,7832 }, {   2,7832 }, {   3,7832 },
 {   4,7832 }, {   5,7832 }, {   6,7832 }, {   7,7832 }, {   8,7832 },
 {   9,7832 }, {  10,7832 }, {  11,7832 }, {  12,7832 }, {  13,7832 },
 {  14,7832 }, {  15,7832 }, {  16,7832 }, {  17,7832 }, {  18,7832 },
 {  19,7832 }, {  20,7832 }, {  21,7832 }, {  22,7832 }, {  23,7832 },
 {  24,7832 }, {  25,7832 }, {  26,7832 }, {  27,7832 }, {  28,7832 },
 {  29,7832 }, {  30,7832 }, {  31,7832 }, {  32,7832 }, {  33,7832 },
 {  34,4685 }, {  35,7832 }, {  36,7832 }, {  37,7832 }, {  38,7832 },
 {  39,7832 }, {  40,7832 }, {  41,7832 }, {  42,7832 }, {  43,7832 },
 {  44,7832 }, {  45,7832 }, {  46,7832 }, {  47,7832 }, {  48,7832 },

 {  49,7832 }, {  50,7832 }, {  51,7832 }, {  52,7832 }, {  53,7832 },
 {  54,7832 }, {  55,7832 }, {  56,7832 }, {  57,7832 }, {  58,7832 },
 {  59,7832 }, {  60,7832 }, {  61,7832 }, {  62,7832 }, {  63,7832 },
 {  64,7832 }, {  65,7832 }, {  66,7832 }, {  67,7832 }, {  68,7832 },
 {  69,7832 }, {  70,7832 }, {  71,7832 }, {  72,7832 }, {  73,7832 },
 {  74,7832 }, {  75,7832 }, {  76,7832 }, {  77,7832 }, {  78,7832 },
 {  79,7832 }, {  80,7832 }, {  81,7832 }, {  82,7832 }, {  83,7832 },
 {  84,7832 }, {  85,7832 }, {  86,7832 }, {  87,7832 }, {  88,7832 },
 {  89,7832 }, {  90,7832 }, {  91,7832 }, {  92,7832 }, {  93,7832 },
 {  94,7832 }, {  95,7832 }, {  96,7832 }, {  97,7832 }, {  98,7832 },

 {  99,7832 }, { 100,7832 }, { 101,7832 }, { 102,7832 }, { 103,7832 },
 { 104,7832 }, { 105,7832 }, { 106,7832 }, { 107,7832 }, { 108,7832 },
 { 109,7832 }, { 110,7832 }, { 111,7832 }, { 112,7832 }, { 113,7832 },
 { 114,7832 }, { 115,7832 }, { 116,7832 }, { 117,7832 }, { 118,7832 },
 { 119,7832 }, { 120,7832 }, { 121,7832 }, { 122,7832 }, { 123,7832 },
 { 124,7832 }, { 125,7832 }, { 126,7832 }, { 127,7832 }, { 128,7832 },
 { 129,7832 }, { 130,7832 }, { 131,7832 }, { 132,7832 }, { 133,7832 },
 { 134,7832 }, { 135,7832 }, { 136,7832 }, { 137,7832 }, { 138,7832 },
 { 139,7832 }, { 140,7832 }, { 141,7832 }, { 142,7832 }, { 143,7832 },
 { 144,7832 }, { 145,7832 }, { 146,7832 }, { 147,7832 }, { 148,7832 },

 { 149,7832 }, { 150,7832 }, { 151,7832 }, { 152,7832 }, { 153,7832 },
 { 154,7832 }, { 155,7832 }, { 156,7832 }, { 157,7832 }, { 158,7832 },
 { 159,7832 }, { 160,7832 }, { 161,7832 }, { 162,7832 }, { 163,7832 },
 { 164,7832 }, { 165,7832 }, { 166,7832 }, { 167,7832 }, { 168,7832 },
 { 169,7832 }, { 170,7832 }, { 171,7832 }, { 172,7832 }, { 173,7832 },
 { 174,7832 }, { 175,7832 }, { 176,7832 }, { 177,7832 }, { 178,7832 },
 { 179,7832 }, { 180,7832 }, { 181,7832 }, { 182,7832 }, { 183,7832 },
 { 184,7832 }, { 185,7832 }, { 186,7832 }, { 187,7832 }, { 188,7832 },
 { 189,7832 }, { 190,7832 }, { 191,7832 }, { 192,7832 }, { 193,7832 },
 { 194,7832 }, { 195,7832 }, { 196,7832 }, { 197,7832 }, { 198,7832 },

 { 199,7832 }, { 200,7832 }, { 201,7832 }, { 202,7832 }, { 203,7832 },
 { 204,7832 }, { 205,7832 }, { 206,7832 }, { 207,7832 }, { 208,7832 },
 { 209,7832 }, { 210,7832 }, { 211,7832 }, { 212,7832 }, { 213,7832 },
 { 214,7832 }, { 215,7832 }, { 216,7832 }, { 217,7832 }, { 218,7832 },
 { 219,7832 }, { 220,7832 }, { 221,7832 }, { 222,7832 }, { 223,7832 },
 { 224,7832 }, { 225,7832 }, { 226,7832 }, { 227,7832 }, { 228,7832 },
 { 229,7832 }, { 230,7832 }, { 231,7832 }, { 232,7832 }, { 233,7832 },
 { 234,7832 }, { 235,7832 }, { 236,7832 }, { 237,7832 }, { 238,7832 },
 { 239,7832 }, { 240,7832 }, { 241,7832 }, { 242,7832 }, { 243,7832 },
 { 244,7832 }, { 245,7832 }, { 246,7832 }, { 247,7832 }, { 248,7832 },

 { 249,7832 }, { 250,7832 }, { 251,7832 }, { 252,7832 }, { 253,7832 },
 { 254,7832 }, { 255,7832 }, { 256,7832 }, {   0,   0 }, {   0,17267 },
 {   1,7574 }, {   2,7574 }, {   3,7574 }, {   4,7574 }, {   5,7574 },
 {   6,7574 }, {   7,7574 }, {   8,7574 }, {   9,7574 }, {  10,7574 },
 {  11,7574 }, {  12,7574 }, {  13,7574 }, {  14,7574 }, {  15,7574 },
 {  16,7574 }, {  17,7574 }, {  18,7574 }, {  19,7574 }, {  20,7574 },
 {  21,7574 }, {  22,7574 }, {  23,7574 }, {  24,7574 }, {  25,7574 },
 {  26,7574 }, {  27,7574 }, {  28,7574 }, {  29,7574 }, {  30,7574 },
 {  31,7574 }, {  32,7574 }, {  33,7574 }, {  34,4427 }, {  35,7574 },
 {  36,7574 }, {  37,7574 }, {  38,7574 }, {  39,7574 }, {  40,7574 },

 {  41,7574 }, {  42,7574 }, {  43,7574 }, {  44,7574 }, {  45,7574 },
 {  46,7574 }, {  47,7574 }, {  48,7574 }, {  49,7574 }, {  50,7574 },
 {  51,7574 }, {  52,7574 }, {  53,7574 }, {  54,7574 }, {  55,7574 },
 {  56,7574 }, {  57,7574 }, {  58,7574 }, {  59,7574 }, {  60,7574 },
 {  61,7574 }, {  62,7574 }, {  63,7574 }, {  64,7574 }, {  65,7574 },
 {  66,7574 }, {  67,7574 }, {  68,7574 }, {  69,7574 }, {  70,7574 },
 {  71,7574 }, {  72,7574 }, {  73,7574 }, {  74,7574 }, {  75,7574 },
 {  76,7574 }, {  77,7574 }, {  78,7574 }, {  79,7574 }, {  80,7574 },
 {  81,7574 }, {  82,7574 }, {  83,7574 }, {  84,7574 }, {  85,7574 },
 {  86,7574 }, {  87,7574 }, {  88,7574 }, {  89,7574 }, {  90,7574 },

 {  91,7574 }, {  92,7574 }, {  93,7574 }, {  94,7574 }, {  95,7574 },
 {  96,7574 }, {  97,7574 }, {  98,7574 }, {  99,7574 }, { 100,7574 },
 { 101,7574 }, { 102,7574 }, { 103,7574 }, { 104,7574 }, { 105,7574 },
 { 106,7574 }, { 107,7574 }, { 108,7574 }, { 109,7574 }, { 110,7574 },
 { 111,7574 }, { 112,7574 }, { 113,7574 }, { 114,7574 }, { 115,7574 },
 { 116,7574 }, { 117,7574 }, { 118,7574 }, { 119,7574 }, { 120,7574 },
 { 121,7574 }, { 122,7574 }, { 123,7574 }, { 124,7574 }, { 125,7574 },
 { 126,7574 }, { 127,7574 }, { 128,7574 }, { 129,7574 }, { 130,7574 },
 { 131,7574 }, { 132,7574 }, { 133,7574 }, { 134,7574 }, { 135,7574 },
 { 136,7574 }, { 137,7574 }, { 138,7574 }, { 139,7574 }, { 140,7574 },

 { 141,7574 }, { 142,7574 }, { 143,7574 }, { 144,7574 }, { 145,7574 },
 { 146,7574 }, { 147,7574 }, { 148,7574 }, { 149,7574 }, { 150,7574 },
 { 151,7574 }, { 152,7574 }, { 153,7574 }, { 154,7574 }, { 155,7574 },
 { 156,7574 }, { 157,7574 }, { 158,7574 }, { 159,7574 }, { 160,7574 },
 { 161,7574 }, { 162,7574 }, { 163,7574 }, { 164,7574 }, { 165,7574 },
 { 166,7574 }, { 167,7574 }, { 168,7574 }, { 169,7574 }, { 170,7574 },
 { 171,7574 }, { 172,7574 }, { 173,7574 }, { 174,7574 }, { 175,7574 },
 { 176,7574 }, { 177,7574 }, { 178,7574 }, { 179,7574 }, { 180,7574 },
 { 181,7574 }, { 182,7574 }, { 183,7574 }, { 184,7574 }, { 185,7574 },
 { 186,7574 }, { 187,7574 }, { 188,7574 }, { 189,7574 }, { 190,7574 },

 { 191,7574 }, { 192,7574 }, { 193,7574 }, { 194,7574 }, { 195,7574 },
 { 196,7574 }, { 197,7574 }, { 198,7574 }, { 199,7574 }, { 200,7574 },
 { 201,7574 }, { 202,7574 }, { 203,7574 }, { 204,7574 }, { 205,7574 },
 { 206,7574 }, { 207,7574 }, { 208,7574 }, { 209,7574 }, { 210,7574 },
 { 211,7574 }, { 212,7574 }, { 213,7574 }, { 214,7574 }, { 215,7574 },
 { 216,7574 }, { 217,7574 }, { 218,7574 }, { 219,7574 }, { 220,7574 },
 { 221,7574 }, { 222,7574 }, { 223,7574 }, { 224,7574 }, { 225,7574 },
 { 226,7574 }, { 227,7574 }, { 228,7574 }, { 229,7574 }, { 230,7574 },
 { 231,7574 }, { 232,7574 }, { 233,7574 }, { 234,7574 }, { 235,7574 },
 { 236,7574 }, { 237,7574 }, { 238,7574 }, { 239,7574 }, { 240,7574 },

 { 241,7574 }, { 242,7574 }, { 243,7574 }, { 244,7574 }, { 245,7574 },
 { 246,7574 }, { 247,7574 }, { 248,7574 }, { 249,7574 }, { 250,7574 },
 { 251,7574 }, { 252,7574 }, { 253,7574 }, { 254,7574 }, { 255,7574 },
 { 256,7574 }, {   0,  10 }, {   0,17009 }, {   1,7574 }, {   2,7574 },
 {   3,7574 }, {   4,7574 }, {   5,7574 }, {   6,7574 }, {   7,7574 },
 {   8,7574 }, {   9,7574 }, {  10,7574 }, {  11,7574 }, {  12,7574 },
 {  13,7574 }, {  14,7574 }, {  15,7574 }, {  16,7574 }, {  17,7574 },
 {  18,7574 }, {  19,7574 }, {  20,7574 }, {  21,7574 }, {  22,7574 },
 {  23,7574 }, {  24,7574 }, {  25,7574 }, {  26,7574 }, {  27,7574 },
 {  28,7574 }, {  29,7574 }, {  30,7574 }, {  31,7574 }, {  32,7574 },

 {  33,7574 }, {  34,7574 }, {  35,7574 }, {  36,7574 }, {  37,7574 },
 {  38,7574 }, {  39,4157 }, {  40,7574 }, {  41,7574 }, {  42,7574 },
 {  43,7574 }, {  44,7574 }, {  45,7574 }, {  46,7574 }, {  47,7574 },
 {  48,7574 }, {  49,7574 }, {  50,7574 }, {  51,7574 }, {  52,7574 },
 {  53,7574 }, {  54,7574 }, {  55,7574 }, {  56,7574 }, {  57,7574 },
 {  58,7574 }, {  59,7574 }, {  60,7574 }, {  61,7574 }, {  62,7574 },
 {  63,7574 }, {  64,7574 }, {  65,7574 }, {  66,7574 }, {  67,7574 },
 {  68,7574 }, {  69,7574 }, {  70,7574 }, {  71,7574 }, {  72,7574 },
 {  73,7574 }, {  74,7574 }, {  75,7574 }, {  76,7574 }, {  77,7574 },
 {  78,7574 }, {  79,7574 }, {  80,7574 }, {  81,7574 }, {  82,7574 },

 {  83,7574 }, {  84,7574 }, {  85,7574 }, {  86,7574 }, {  87,7574 },
 {  88,7574 }, {  89,7574 }, {  90,7574 }, {  91,7574 }, {  92,7574 },
 {  93,7574 }, {  94,7574 }, {  95,7574 }, {  96,7574 }, {  97,7574 },
 {  98,7574 }, {  99,7574 }, { 100,7574 }, { 101,7574 }, { 102,7574 },
 { 103,7574 }, { 104,7574 }, { 105,7574 }, { 106,7574 }, { 107,7574 },
 { 108,7574 }, { 109,7574 }, { 110,7574 }, { 111,7574 }, { 112,7574 },
 { 113,7574 }, { 114,7574 }, { 115,7574 }, { 116,7574 }, { 117,7574 },
 { 118,7574 }, { 119,7574 }, { 120,7574 }, { 121,7574 }, { 122,7574 },
 { 123,7574 }, { 124,7574 }, { 125,7574 }, { 126,7574 }, { 127,7574 },
 { 128,7574 }, { 129,7574 }, { 130,7574 }, { 131,7574 }, { 132,7574 },

 { 133,7574 }, { 134,7574 }, { 135,7574 }, { 136,7574 }, { 137,7574 },
 { 138,7574 }, { 139,7574 }, { 140,7574 }, { 141,7574 }, { 142,7574 },
 { 143,7574 }, { 144,7574 }, { 145,7574 }, { 146,7574 }, { 147,7574 },
 { 148,7574 }, { 149,7574 }, { 150,7574 }, { 151,7574 }, { 152,7574 },
 { 153,7574 }, { 154,7574 }, { 155,7574 }, { 156,7574 }, { 157,7574 },
 { 158,7574 }, { 159,7574 }, { 160,7574 }, { 161,7574 }, { 162,7574 },
 { 163,7574 }, { 164,7574 }, { 165,7574 }, { 166,7574 }, { 167,7574 },
 { 168,7574 }, { 169,7574 }, { 170,7574 }, { 171,7574 }, { 172,7574 },
 { 173,7574 }, { 174,7574 }, { 175,7574 }, { 176,7574 }, { 177,7574 },
 { 178,7574 }, { 179,7574 }, { 180,7574 }, { 181,7574 }, { 182,7574 },

 { 183,7574 }, { 184,7574 }, { 185,7574 }, { 186,7574 }, { 187,7574 },
 { 188,7574 }, { 189,7574 }, { 190,7574 }, { 191,7574 }, { 192,7574 },
 { 193,7574 }, { 194,7574 }, { 195,7574 }, { 196,7574 }, { 197,7574 },
 { 198,7574 }, { 199,7574 }, { 200,7574 }, { 201,7574 }, { 202,7574 },
 { 203,7574 }, { 204,7574 }, { 205,7574 }, { 206,7574 }, { 207,7574 },
 { 208,7574 }, { 209,7574 }, { 210,7574 }, { 211,7574 }, { 212,7574 },
 { 213,7574 }, { 214,7574 }, { 215,7574 }, { 216,7574 }, { 217,7574 },
 { 218,7574 }, { 219,7574 }, { 220,7574 }, { 221,7574 }, { 222,7574 },
 { 223,7574 }, { 224,7574 }, { 225,7574 }, { 226,7574 }, { 227,7574 },
 { 228,7574 }, { 229,7574 }, { 230,7574 }, { 231,7574 }, { 232,7574 },

 { 233,7574 }, { 234,7574 }, { 235,7574 }, { 236,7574 }, { 237,7574 },
 { 238,7574 }, { 239,7574 }, { 240,7574 }, { 241,7574 }, { 242,7574 },
 { 243,7574 }, { 244,7574 }, { 245,7574 }, { 246,7574 }, { 247,7574 },
 { 248,7574 }, { 249,7574 }, { 250,7574 }, { 251,7574 }, { 252,7574 },
 { 253,7574 }, { 254,7574 }, { 255,7574 }, { 256,7574 }, {   0,  10 },
 {   0,16751 }, {   1,7316 }, {   2,7316 }, {   3,7316 }, {   4,7316 },
 {   5,7316 }, {   6,7316 }, {   7,7316 }, {   8,7316 }, {   9,7316 },
 {  10,7316 }, {  11,7316 }, {  12,7316 }, {  13,7316 }, {  14,7316 },
 {  15,7316 }, {  16,7316 }, {  17,7316 }, {  18,7316 }, {  19,7316 },
 {  20,7316 }, {  21,7316 }, {  22,7316 }, {  23,7316 }, {  24,7316 },

 {  25,7316 }, {  26,7316 }, {  27,7316 }, {  28,7316 }, {  29,7316 },
 {  30,7316 }, {  31,7316 }, {  32,7316 }, {  33,7316 }, {  34,7316 },
 {  35,7316 }, {  36,7316 }, {  37,7316 }, {  38,7316 }, {  39,3899 },
 {  40,7316 }, {  41,7316 }, {  42,7316 }, {  43,7316 }, {  44,7316 },
 {  45,7316 }, {  46,7316 }, {  47,7316 }, {  48,7316 }, {  49,7316 },
 {  50,7316 }, {  51,7316 }, {  52,7316 }, {  53,7316 }, {  54,7316 },
 {  55,7316 }, {  56,7316 }, {  57,7316 }, {  58,7316 }, {  59,7316 },
 {  60,7316 }, {  61,7316 }, {  62,7316 }, {  63,7316 }, {  64,7316 },
 {  65,7316 }, {  66,7316 }, {  67,7316 }, {  68,7316 }, {  69,7316 },
 {  70,7316 }, {  71,7316 }, {  72,7316 }, {  73,7316 }, {  74,7316 },

 {  75,7316 }, {  76,7316 }, {  77,7316 }, {  78,7316 }, {  79,7316 },
 {  80,7316 }, {  81,7316 }, {  82,7316 }, {  83,7316 }, {  84,7316 },
 {  85,7316 }, {  86,7316 }, {  87,7316 }, {  88,7316 }, {  89,7316 },
 {  90,7316 }, {  91,7316 }, {  92,7316 }, {  93,7316 }, {  94,7316 },
 {  95,7316 }, {  96,7316 }, {  97,7316 }, {  98,7316 }, {  99,7316 },
 { 100,7316 }, { 101,7316 }, { 102,7316 }, { 103,7316 }, { 104,7316 },
 { 105,7316 }, { 106,7316 }, { 107,7316 }, { 108,7316 }, { 109,7316 },
 { 110,7316 }, { 111,7316 }, { 112,7316 }, { 113,7316 }, { 114,7316 },
 { 115,7316 }, { 116,7316 }, { 117,7316 }, { 118,7316 }, { 119,7316 },
 { 120,7316 }, { 121,7316 }, { 122,7316 }, { 123,7316 }, { 124,7316 },

 { 125,7316 }, { 126,7316 }, { 127,7316 }, { 128,7316 }, { 129,7316 },
 { 130,7316 }, { 131,7316 }, { 132,7316 }, { 133,7316 }, { 134,7316 },
 { 135,7316 }, { 136,7316 }, { 137,7316 }, { 138,7316 }, { 139,7316 },
 { 140,7316 }, { 141,7316 }, { 142,7316 }, { 143,7316 }, { 144,7316 },
 { 145,7316 }, { 146,7316 }, { 147,7316 }, { 148,7316 }, { 149,7316 },
 { 150,7316 }, { 151,7316 }, { 152,7316 }, { 153,7316 }, { 154,7316 },
 { 155,7316 }, { 156,7316 }, { 157,7316 }, { 158,7316 }, { 159,7316 },
 { 160,7316 }, { 161,7316 }, { 162,7316 }, { 163,7316 }, { 164,7316 },
 { 165,7316 }, { 166,7316 }, { 167,7316 }, { 168,7316 }, { 169,7316 },
 { 170,7316 }, { 171,7316 }, { 172,7316 }, { 173,7316 }, { 174,7316 },

 { 175,7316 }, { 176,7316 }, { 177,7316 }, { 178,7316 }, { 179,7316 },
 { 180,7316 }, { 181,7316 }, { 182,7316 }, { 183,7316 }, { 184,7316 },
 { 185,7316 }, { 186,7316 }, { 187,7316 }, { 188,7316 }, { 189,7316 },
 { 190,7316 }, { 191,7316 }, { 192,7316 }, { 193,7316 }, { 194,7316 },
 { 195,7316 }, { 196,7316 }, { 197,7316 }, { 198,7316 }, { 199,7316 },
 { 200,7316 }, { 201,7316 }, { 202,7316 }, { 203,7316 }, { 204,7316 },
 { 205,7316 }, { 206,7316 }, { 207,7316 }, { 208,7316 }, { 209,7316 },
 { 210,7316 }, { 211,7316 }, { 212,7316 }, { 213,7316 }, { 214,7316 },
 { 215,7316 }, { 216,7316 }, { 217,7316 }, { 218,7316 }, { 219,7316 },
 { 220,7316 }, { 221,7316 }, { 222,7316 }, { 223,7316 }, { 224,7316 },

 { 225,7316 }, { 226,7316 }, { 227,7316 }, { 228,7316 }, { 229,7316 },
 { 230,7316 }, { 231,7316 }, { 232,7316 }, { 233,7316 }, { 234,7316 },
 { 235,7316 }, { 236,7316 }, { 237,7316 }, { 238,7316 }, { 239,7316 },
 { 240,7316 }, { 241,7316 }, { 242,7316 }, { 243,7316 }, { 244,7316 },
 { 245,7316 }, { 246,7316 }, { 247,7316 }, { 248,7316 }, { 249,7316 },
 { 250,7316 }, { 251,7316 }, { 252,7316 }, { 253,7316 }, { 254,7316 },
 { 255,7316 }, { 256,7316 }, {   0,   0 }, {   0,16493 }, {   1,7316 },
 {   2,7316 }, {   3,7316 }, {   4,7316 }, {   5,7316 }, {   6,7316 },
 {   7,7316 }, {   8,7316 }, {   9,7316 }, {  10,7316 }, {  11,7316 },
 {  12,7316 }, {  13,7316 }, {  14,7316 }, {  15,7316 }, {  16,7316 },

 {  17,7316 }, {  18,7316 }, {  19,7316 }, {  20,7316 }, {  21,7316 },
 {  22,7316 }, {  23,7316 }, {  24,7316 }, {  25,7316 }, {  26,7316 },
 {  27,7316 }, {  28,7316 }, {  29,7316 }, {  30,7316 }, {  31,7316 },
 {  32,7316 }, {  33,7316 }, {  34,7316 }, {  35,7316 }, {  36,7316 },
 {  37,7316 }, {  38,7316 }, {  39,3670 }, {  40,7316 }, {  41,7316 },
 {  42,7316 }, {  43,7316 }, {  44,7316 }, {  45,7316 }, {  46,7316 },
 {  47,7316 }, {  48,7316 }, {  49,7316 }, {  50,7316 }, {  51,7316 },
 {  52,7316 }, {  53,7316 }, {  54,7316 }, {  55,7316 }, {  56,7316 },
 {  57,7316 }, {  58,7316 }, {  59,7316 }, {  60,7316 }, {  61,7316 },
 {  62,7316 }, {  63,7316 }, {  64,7316 }, {  65,7316 }, {  66,7316 },

 {  67,7316 }, {  68,7316 }, {  69,7316 }, {  70,7316 }, {  71,7316 },
 {  72,7316 }, {  73,7316 }, {  74,7316 }, {  75,7316 }, {  76,7316 },
 {  77,7316 }, {  78,7316 }, {  79,7316 }, {  80,7316 }, {  81,7316 },
 {  82,7316 }, {  83,7316 }, {  84,7316 }, {  85,7316 }, {  86,7316 },
 {  87,7316 }, {  88,7316 }, {  89,7316 }, {  90,7316 }, {  91,7316 },
 {  92,7316 }, {  93,7316 }, {  94,7316 }, {  95,7316 }, {  96,7316 },
 {  97,7316 }, {  98,7316 }, {  99,7316 }, { 100,7316 }, { 101,7316 },
 { 102,7316 }, { 103,7316 }, { 104,7316 }, { 105,7316 }, { 106,7316 },
 { 107,7316 }, { 108,7316 }, { 109,7316 }, { 110,7316 }, { 111,7316 },
 { 112,7316 }, { 113,7316 }, { 114,7316 }, { 115,7316 }, { 116,7316 },

 { 117,7316 }, { 118,7316 }, { 119,7316 }, { 120,7316 }, { 121,7316 },
 { 122,7316 }, { 123,7316 }, { 124,7316 }, { 125,7316 }, { 126,7316 },
 { 127,7316 }, { 128,7316 }, { 129,7316 }, { 130,7316 }, { 131,7316 },
 { 132,7316 }, { 133,7316 }, { 134,7316 }, { 135,7316 }, { 136,7316 },
 { 137,7316 }, { 138,7316 }, { 139,7316 }, { 140,7316 }, { 141,7316 },
 { 142,7316 }, { 143,7316 }, { 144,7316 }, { 145,7316 }, { 146,7316 },
 { 147,7316 }, { 148,7316 }, { 149,7316 }, { 150,7316 }, { 151,7316 },
 { 152,7316 }, { 153,7316 }, { 154,7316 }, { 155,7316 }, { 156,7316 },
 { 157,7316 }, { 158,7316 }, { 159,7316 }, { 160,7316 }, { 161,7316 },
 { 162,7316 }, { 163,7316 }, { 164,7316 }, { 165,7316 }, { 166,7316 },

 { 167,7316 }, { 168,7316 }, { 169,7316 }, { 170,7316 }, { 171,7316 },
 { 172,7316 }, { 173,7316 }, { 174,7316 }, { 175,7316 }, { 176,7316 },
 { 177,7316 }, { 178,7316 }, { 179,7316 }, { 180,7316 }, { 181,7316 },
 { 182,7316 }, { 183,7316 }, { 184,7316 }, { 185,7316 }, { 186,7316 },
 { 187,7316 }, { 188,7316 }, { 189,7316 }, { 190,7316 }, { 191,7316 },
 { 192,7316 }, { 193,7316 }, { 194,7316 }, { 195,7316 }, { 196,7316 },
 { 197,7316 }, { 198,7316 }, { 199,7316 }, { 200,7316 }, { 201,7316 },
 { 202,7316 }, { 203,7316 }, { 204,7316 }, { 205,7316 }, { 206,7316 },
 { 207,7316 }, { 208,7316 }, { 209,7316 }, { 210,7316 }, { 211,7316 },
 { 212,7316 }, { 213,7316 }, { 214,7316 }, { 215,7316 }, { 216,7316 },

 { 217,7316 }, { 218,7316 }, { 219,7316 }, { 220,7316 }, { 221,7316 },
 { 222,7316 }, { 223,7316 }, { 224,7316 }, { 225,7316 }, { 226,7316 },
 { 227,7316 }, { 228,7316 }, { 229,7316 }, { 230,7316 }, { 231,7316 },
 { 232,7316 }, { 233,7316 }, { 234,7316 }, { 235,7316 }, { 236,7316 },
 { 237,7316 }, { 238,7316 }, { 239,7316 }, { 240,7316 }, { 241,7316 },
 { 242,7316 }, { 243,7316 }, { 244,7316 }, { 245,7316 }, { 246,7316 },
 { 247,7316 }, { 248,7316 }, { 249,7316 }, { 250,7316 }, { 251,7316 },
 { 252,7316 }, { 253,7316 }, { 254,7316 }, { 255,7316 }, { 256,7316 },
 {   0,   0 }, {   0,16235 }, {   1,7058 }, {   2,7058 }, {   3,7058 },
 {   4,7058 }, {   5,7058 }, {   6,7058 }, {   7,7058 }, {   8,7058 },

 {   9,7058 }, {  10,7058 }, {  11,7058 }, {  12,7058 }, {  13,7058 },
 {  14,7058 }, {  15,7058 }, {  16,7058 }, {  17,7058 }, {  18,7058 },
 {  19,7058 }, {  20,7058 }, {  21,7058 }, {  22,7058 }, {  23,7058 },
 {  24,7058 }, {  25,7058 }, {  26,7058 }, {  27,7058 }, {  28,7058 },
 {  29,7058 }, {  30,7058 }, {  31,7058 }, {  32,7058 }, {  33,7058 },
 {  34,7058 }, {  35,7058 }, {  36,7058 }, {  37,7058 }, {  38,7058 },
 {  39,3412 }, {  40,7058 }, {  41,7058 }, {  42,7058 }, {  43,7058 },
 {  44,7058 }, {  45,7058 }, {  46,7058 }, {  47,7058 }, {  48,7058 },
 {  49,7058 }, {  50,7058 }, {  51,7058 }, {  52,7058 }, {  53,7058 },
 {  54,7058 }, {  55,7058 }, {  56,7058 }, {  57,7058 }, {  58,7058 },

 {  59,7058 }, {  60,7058 }, {  61,7058 }, {  62,7058 }, {  63,7058 },
 {  64,7058 }, {  65,7058 }, {  66,7058 }, {  67,7058 }, {  68,7058 },
 {  69,7058 }, {  70,7058 }, {  71,7058 }, {  72,7058 }, {  73,7058 },
 {  74,7058 }, {  75,7058 }, {  76,7058 }, {  77,7058 }, {  78,7058 },
 {  79,7058 }, {  80,7058 }, {  81,7058 }, {  82,7058 }, {  83,7058 },
 {  84,7058 }, {  85,7058 }, {  86,7058 }, {  87,7058 }, {  88,7058 },
 {  89,7058 }, {  90,7058 }, {  91,7058 }, {  92,7058 }, {  93,7058 },
 {  94,7058 }, {  95,7058 }, {  96,7058 }, {  97,7058 }, {  98,7058 },
 {  99,7058 }, { 100,7058 }, { 101,7058 }, { 102,7058 }, { 103,7058 },
 { 104,7058 }, { 105,7058 }, { 106,7058 }, { 107,7058 }, { 108,7058 },

 { 109,7058 }, { 110,7058 }, { 111,7058 }, { 112,7058 }, { 113,7058 },
 { 114,7058 }, { 115,7058 }, { 116,7058 }, { 117,7058 }, { 118,7058 },
 { 119,7058 }, { 120,7058 }, { 121,7058 }, { 122,7058 }, { 123,7058 },
 { 124,7058 }, { 125,7058 }, { 126,7058 }, { 127,7058 }, { 128,7058 },
 { 129,7058 }, { 130,7058 }, { 131,7058 }, { 132,7058 }, { 133,7058 },
 { 134,7058 }, { 135,7058 }, { 136,7058 }, { 137,7058 }, { 138,7058 },
 { 139,7058 }, { 140,7058 }, { 141,7058 }, { 142,7058 }, { 143,7058 },
 { 144,7058 }, { 145,7058 }, { 146,7058 }, { 147,7058 }, { 148,7058 },
 { 149,7058 }, { 150,7058 }, { 151,7058 }, { 152,7058 }, { 153,7058 },
 { 154,7058 }, { 155,7058 }, { 156,7058 }, { 157,7058 }, { 158,7058 },

 { 159,7058 }, { 160,7058 }, { 161,7058 }, { 162,7058 }, { 163,7058 },
 { 164,7058 }, { 165,7058 }, { 166,7058 }, { 167,7058 }, { 168,7058 },
 { 169,7058 }, { 170,7058 }, { 171,7058 }, { 172,7058 }, { 173,7058 },
 { 174,7058 }, { 175,7058 }, { 176,7058 }, { 177,7058 }, { 178,7058 },
 { 179,7058 }, { 180,7058 }, { 181,7058 }, { 182,7058 }, { 183,7058 },
 { 184,7058 }, { 185,7058 }, { 186,7058 }, { 187,7058 }, { 188,7058 },
 { 189,7058 }, { 190,7058 }, { 191,7058 }, { 192,7058 }, { 193,7058 },
 { 194,7058 }, { 195,7058 }, { 196,7058 }, { 197,7058 }, { 198,7058 },
 { 199,7058 }, { 200,7058 }, { 201,7058 }, { 202,7058 }, { 203,7058 },
 { 204,7058 }, { 205,7058 }, { 206,7058 }, { 207,7058 }, { 208,7058 },

 { 209,7058 }, { 210,7058 }, { 211,7058 }, { 212,7058 }, { 213,7058 },
 { 214,7058 }, { 215,7058 }, { 216,7058 }, { 217,7058 }, { 218,7058 },
 { 219,7058 }, { 220,7058 }, { 221,7058 }, { 222,7058 }, { 223,7058 },
 { 224,7058 }, { 225,7058 }, { 226,7058 }, { 227,7058 }, { 228,7058 },
 { 229,7058 }, { 230,7058 }, { 231,7058 }, { 232,7058 }, { 233,7058 },
 { 234,7058 }, { 235,7058 }, { 236,7058 }, { 237,7058 }, { 238,7058 },
 { 239,7058 }, { 240,7058 }, { 241,7058 }, { 242,7058 }, { 243,7058 },
 { 244,7058 }, { 245,7058 }, { 246,7058 }, { 247,7058 }, { 248,7058 },
 { 249,7058 }, { 250,7058 }, { 251,7058 }, { 252,7058 }, { 253,7058 },
 { 254,7058 }, { 255,7058 }, { 256,7058 }, {   0,  19 }, {   0,15977 },

 {   1,3156 }, {   2,3156 }, {   3,3156 }, {   4,3156 }, {   5,3156 },
 {   6,3156 }, {   7,3156 }, {   8,3156 }, {   9,7058 }, {  10,7063 },
 {  11,3156 }, {  12,7058 }, {  13,7079 }, {  14,3156 }, {  15,3156 },
 {  16,3156 }, {  17,3156 }, {  18,3156 }, {  19,3156 }, {  20,3156 },
 {  21,3156 }, {  22,3156 }, {  23,3156 }, {  24,3156 }, {  25,3156 },
 {  26,3156 }, {  27,3156 }, {  28,3156 }, {  29,3156 }, {  30,3156 },
 {  31,3156 }, {  32,7058 }, {  33,3156 }, {  34,3156 }, {  35,3156 },
 {  36,3156 }, {  37,3156 }, {  38,3156 }, {  39,3156 }, {  40,3156 },
 {  41,3156 }, {  42,3156 }, {  43,3156 }, {  44,3156 }, {  45,3158 },
 {  46,3156 }, {  47,3156 }, {  48,3156 }, {  49,3156 }, {  50,3156 },

 {  51,3156 }, {  52,3156 }, {  53,3156 }, {  54,3156 }, {  55,3156 },
 {  56,3156 }, {  57,3156 }, {  58,3156 }, {  59,3156 }, {  60,3156 },
 {  61,3156 }, {  62,3156 }, {  63,3156 }, {  64,3156 }, {  65,3156 },
 {  66,3156 }, {  67,3156 }, {  68,3156 }, {  69,3156 }, {  70,3156 },
 {  71,3156 }, {  72,3156 }, {  73,3156 }, {  74,3156 }, {  75,3156 },
 {  76,3156 }, {  77,3156 }, {  78,3156 }, {  79,3156 }, {  80,3156 },
 {  81,3156 }, {  82,3156 }, {  83,3156 }, {  84,3156 }, {  85,3156 },
 {  86,3156 }, {  87,3156 }, {  88,3156 }, {  89,3156 }, {  90,3156 },
 {  91,3156 }, {  92,3156 }, {  93,3156 }, {  94,3156 }, {  95,3156 },
 {  96,3156 }, {  97,3156 }, {  98,3156 }, {  99,3156 }, { 100,3156 },

 { 101,3156 }, { 102,3156 }, { 103,3156 }, { 104,3156 }, { 105,3156 },
 { 106,3156 }, { 107,3156 }, { 108,3156 }, { 109,3156 }, { 110,3156 },
 { 111,3156 }, { 112,3156 }, { 113,3156 }, { 114,3156 }, { 115,3156 },
 { 116,3156 }, { 117,3156 }, { 118,3156 }, { 119,3156 }, { 120,3156 },
 { 121,3156 }, { 122,3156 }, { 123,3156 }, { 124,3156 }, { 125,3156 },
 { 126,3156 }, { 127,3156 }, { 128,3156 }, { 129,3156 }, { 130,3156 },
 { 131,3156 }, { 132,3156 }, { 133,3156 }, { 134,3156 }, { 135,3156 },
 { 136,3156 }, { 137,3156 }, { 138,3156 }, { 139,3156 }, { 140,3156 },
 { 141,3156 }, { 142,3156 }, { 143,3156 }, { 144,3156 }, { 145,3156 },
 { 146,3156 }, { 147,3156 }, { 148,3156 }, { 149,3156 }, { 150,3156 },

 { 151,3156 }, { 152,3156 }, { 153,3156 }, { 154,3156 }, { 155,3156 },
 { 156,3156 }, { 157,3156 }, { 158,3156 }, { 159,3156 }, { 160,3156 },
 { 161,3156 }, { 162,3156 }, { 163,3156 }, { 164,3156 }, { 165,3156 },
 { 166,3156 }, { 167,3156 }, { 168,3156 }, { 169,3156 }, { 170,3156 },
 { 171,3156 }, { 172,3156 }, { 173,3156 }, { 174,3156 }, { 175,3156 },
 { 176,3156 }, { 177,3156 }, { 178,3156 }, { 179,3156 }, { 180,3156 },
 { 181,3156 }, { 182,3156 }, { 183,3156 }, { 184,3156 }, { 185,3156 },
 { 186,3156 }, { 187,3156 }, { 188,3156 }, { 189,3156 }, { 190,3156 },
 { 191,3156 }, { 192,3156 }, { 193,3156 }, { 194,3156 }, { 195,3156 },
 { 196,3156 }, { 197,3156 }, { 198,3156 }, { 199,3156 }, { 200,3156 },

 { 201,3156 }, { 202,3156 }, { 203,3156 }, { 204,3156 }, { 205,3156 },
 { 206,3156 }, { 207,3156 }, { 208,3156 }, { 209,3156 }, { 210,3156 },
 { 211,3156 }, { 212,3156 }, { 213,3156 }, { 214,3156 }, { 215,3156 },
 { 216,3156 }, { 217,3156 }, { 218,3156 }, { 219,3156 }, { 220,3156 },
 { 221,3156 }, { 222,3156 }, { 223,3156 }, { 224,3156 }, { 225,3156 },
 { 226,3156 }, { 227,3156 }, { 228,3156 }, { 229,3156 }, { 230,3156 },
 { 231,3156 }, { 232,3156 }, { 233,3156 }, { 234,3156 }, { 235,3156 },
 { 236,3156 }, { 237,3156 }, { 238,3156 }, { 239,3156 }, { 240,3156 },
 { 241,3156 }, { 242,3156 }, { 243,3156 }, { 244,3156 }, { 245,3156 },
 { 246,3156 }, { 247,3156 }, { 248,3156 }, { 249,3156 }, { 250,3156 },

 { 251,3156 }, { 252,3156 }, { 253,3156 }, { 254,3156 }, { 255,3156 },
 { 256,3156 }, {   0,  19 }, {   0,15719 }, {   1,2898 }, {   2,2898 },
 {   3,2898 }, {   4,2898 }, {   5,2898 }, {   6,2898 }, {   7,2898 },
 {   8,2898 }, {   9,6800 }, {  10,6805 }, {  11,2898 }, {  12,6800 },
 {  13,6821 }, {  14,2898 }, {  15,2898 }, {  16,2898 }, {  17,2898 },
 {  18,2898 }, {  19,2898 }, {  20,2898 }, {  21,2898 }, {  22,2898 },
 {  23,2898 }, {  24,2898 }, {  25,2898 }, {  26,2898 }, {  27,2898 },
 {  28,2898 }, {  29,2898 }, {  30,2898 }, {  31,2898 }, {  32,6800 },
 {  33,2898 }, {  34,2898 }, {  35,2898 }, {  36,2898 }, {  37,2898 },
 {  38,2898 }, {  39,2898 }, {  40,2898 }, {  41,2898 }, {  42,2898 },

 {  43,2898 }, {  44,2898 }, {  45,2900 }, {  46,2898 }, {  47,2898 },
 {  48,2898 }, {  49,2898 }, {  50,2898 }, {  51,2898 }, {  52,2898 },
 {  53,2898 }, {  54,2898 }, {  55,2898 }, {  56,2898 }, {  57,2898 },
 {  58,2898 }, {  59,2898 }, {  60,2898 }, {  61,2898 }, {  62,2898 },
 {  63,2898 }, {  64,2898 }, {  65,2898 }, {  66,2898 }, {  67,2898 },
 {  68,2898 }, {  69,2898 }, {  70,2898 }, {  71,2898 }, {  72,2898 },
 {  73,2898 }, {  74,2898 }, {  75,2898 }, {  76,2898 }, {  77,2898 },
 {  78,2898 }, {  79,2898 }, {  80,2898 }, {  81,2898 }, {  82,2898 },
 {  83,2898 }, {  84,2898 }, {  85,2898 }, {  86,2898 }, {  87,2898 },
 {  88,2898 }, {  89,2898 }, {  90,2898 }, {  91,2898 }, {  92,2898 },

 {  93,2898 }, {  94,2898 }, {  95,2898 }, {  96,2898 }, {  97,2898 },
 {  98,2898 }, {  99,2898 }, { 100,2898 }, { 101,2898 }, { 102,2898 },
 { 103,2898 }, { 104,2898 }, { 105,2898 }, { 106,2898 }, { 107,2898 },
 { 108,2898 }, { 109,2898 }, { 110,2898 }, { 111,2898 }, { 112,2898 },
 { 113,2898 }, { 114,2898 }, { 115,2898 }, { 116,2898 }, { 117,2898 },
 { 118,2898 }, { 119,2898 }, { 120,2898 }, { 121,2898 }, { 122,2898 },
 { 123,2898 }, { 124,2898 }, { 125,2898 }, { 126,2898 }, { 127,2898 },
 { 128,2898 }, { 129,2898 }, { 130,2898 }, { 131,2898 }, { 132,2898 },
 { 133,2898 }, { 134,2898 }, { 135,2898 }, { 136,2898 }, { 137,2898 },
 { 138,2898 }, { 139,2898 }, { 140,2898 }, { 141,2898 }, { 142,2898 },

 { 143,2898 }, { 144,2898 }, { 145,2898 }, { 146,2898 }, { 147,2898 },
 { 148,2898 }, { 149,2898 }, { 150,2898 }, { 151,2898 }, { 152,2898 },
 { 153,2898 }, { 154,2898 }, { 155,2898 }, { 156,2898 }, { 157,2898 },
 { 158,2898 }, { 159,2898 }, { 160,2898 }, { 161,2898 }, { 162,2898 },
 { 163,2898 }, { 164,2898 }, { 165,2898 }, { 166,2898 }, { 167,2898 },
 { 168,2898 }, { 169,2898 }, { 170,2898 }, { 171,2898 }, { 172,2898 },
 { 173,2898 }, { 174,2898 }, { 175,2898 }, { 176,2898 }, { 177,2898 },
 { 178,2898 }, { 179,2898 }, { 180,2898 }, { 181,2898 }, { 182,2898 },
 { 183,2898 }, { 184,2898 }, { 185,2898 }, { 186,2898 }, { 187,2898 },
 { 188,2898 }, { 189,2898 }, { 190,2898 }, { 191,2898 }, { 192,2898 },

 { 193,2898 }, { 194,2898 }, { 195,2898 }, { 196,2898 }, { 197,2898 },
 { 198,2898 }, { 199,2898 }, { 200,2898 }, { 201,2898 }, { 202,2898 },
 { 203,2898 }, { 204,2898 }, { 205,2898 }, { 206,2898 }, { 207,2898 },
 { 208,2898 }, { 209,2898 }, { 210,2898 }, { 211,2898 }, { 212,2898 },
 { 213,2898 }, { 214,2898 }, { 215,2898 }, { 216,2898 }, { 217,2898 },
 { 218,2898 }, { 219,2898 }, { 220,2898 }, { 221,2898 }, { 222,2898 },
 { 223,2898 }, { 224,2898 }, { 225,2898 }, { 226,2898 }, { 227,2898 },
 { 228,2898 }, { 229,2898 }, { 230,2898 }, { 231,2898 }, { 232,2898 },
 { 233,2898 }, { 234,2898 }, { 235,2898 }, { 236,2898 }, { 237,2898 },
 { 238,2898 }, { 239,2898 }, { 240,2898 }, { 241,2898 }, { 242,2898 },

 { 243,2898 }, { 244,2898 }, { 245,2898 }, { 246,2898 }, { 247,2898 },
 { 248,2898 }, { 249,2898 }, { 250,2898 }, { 251,2898 }, { 252,2898 },
 { 253,2898 }, { 254,2898 }, { 255,2898 }, { 256,2898 }, {   0,   0 },
 {   0,15461 }, {   1,6610 }, {   2,6610 }, {   3,6610 }, {   4,6610 },
 {   5,6610 }, {   6,6610 }, {   7,6610 }, {   8,6610 }, {   9,6610 },
 {  10,6868 }, {  11,6610 }, {  12,6610 }, {  13,6610 }, {  14,6610 },
 {  15,6610 }, {  16,6610 }, {  17,6610 }, {  18,6610 }, {  19,6610 },
 {  20,6610 }, {  21,6610 }, {  22,6610 }, {  23,6610 }, {  24,6610 },
 {  25,6610 }, {  26,6610 }, {  27,6610 }, {  28,6610 }, {  29,6610 },
 {  30,6610 }, {  31,6610 }, {  32,6610 }, {  33,6610 }, {  34,6610 },

 {  35,6610 }, {  36,6610 }, {  37,6610 }, {  38,6610 }, {  39,2645 },
 {  40,6610 }, {  41,6610 }, {  42,6610 }, {  43,6610 }, {  44,6610 },
 {  45,6610 }, {  46,6610 }, {  47,6610 }, {  48,6610 }, {  49,6610 },
 {  50,6610 }, {  51,6610 }, {  52,6610 }, {  53,6610 }, {  54,6610 },
 {  55,6610 }, {  56,6610 }, {  57,6610 }, {  58,6610 }, {  59,6610 },
 {  60,6610 }, {  61,6610 }, {  62,6610 }, {  63,6610 }, {  64,6610 },
 {  65,6610 }, {  66,6610 }, {  67,6610 }, {  68,6610 }, {  69,6610 },
 {  70,6610 }, {  71,6610 }, {  72,6610 }, {  73,6610 }, {  74,6610 },
 {  75,6610 }, {  76,6610 }, {  77,6610 }, {  78,6610 }, {  79,6610 },
 {  80,6610 }, {  81,6610 }, {  82,6610 }, {  83,6610 }, {  84,6610 },

 {  85,6610 }, {  86,6610 }, {  87,6610 }, {  88,6610 }, {  89,6610 },
 {  90,6610 }, {  91,6610 }, {  92,7126 }, {  93,6610 }, {  94,6610 },
 {  95,6610 }, {  96,6610 }, {  97,6610 }, {  98,6610 }, {  99,6610 },
 { 100,6610 }, { 101,6610 }, { 102,6610 }, { 103,6610 }, { 104,6610 },
 { 105,6610 }, { 106,6610 }, { 107,6610 }, { 108,6610 }, { 109,6610 },
 { 110,6610 }, { 111,6610 }, { 112,6610 }, { 113,6610 }, { 114,6610 },
 { 115,6610 }, { 116,6610 }, { 117,6610 }, { 118,6610 }, { 119,6610 },
 { 120,6610 }, { 121,6610 }, { 122,6610 }, { 123,6610 }, { 124,6610 },
 { 125,6610 }, { 126,6610 }, { 127,6610 }, { 128,6610 }, { 129,6610 },
 { 130,6610 }, { 131,6610 }, { 132,6610 }, { 133,6610 }, { 134,6610 },

 { 135,6610 }, { 136,6610 }, { 137,6610 }, { 138,6610 }, { 139,6610 },
 { 140,6610 }, { 141,6610 }, { 142,6610 }, { 143,6610 }, { 144,6610 },
 { 145,6610 }, { 146,6610 }, { 147,6610 }, { 148,6610 }, { 149,6610 },
 { 150,6610 }, { 151,6610 }, { 152,6610 }, { 153,6610 }, { 154,6610 },
 { 155,6610 }, { 156,6610 }, { 157,6610 }, { 158,6610 }, { 159,6610 },
 { 160,6610 }, { 161,6610 }, { 162,6610 }, { 163,6610 }, { 164,6610 },
 { 165,6610 }, { 166,6610 }, { 167,6610 }, { 168,6610 }, { 169,6610 },
 { 170,6610 }, { 171,6610 }, { 172,6610 }, { 173,6610 }, { 174,6610 },
 { 175,6610 }, { 176,6610 }, { 177,6610 }, { 178,6610 }, { 179,6610 },
 { 180,6610 }, { 181,6610 }, { 182,6610 }, { 183,6610 }, { 184,6610 },

 { 185,6610 }, { 186,6610 }, { 187,6610 }, { 188,6610 }, { 189,6610 },
 { 190,6610 }, { 191,6610 }, { 192,6610 }, { 193,6610 }, { 194,6610 },
 { 195,6610 }, { 196,6610 }, { 197,6610 }, { 198,6610 }, { 199,6610 },
 { 200,6610 }, { 201,6610 }, { 202,6610 }, { 203,6610 }, { 204,6610 },
 { 205,6610 }, { 206,6610 }, { 207,6610 }, { 208,6610 }, { 209,6610 },
 { 210,6610 }, { 211,6610 }, { 212,6610 }, { 213,6610 }, { 214,6610 },
 { 215,6610 }, { 216,6610 }, { 217,6610 }, { 218,6610 }, { 219,6610 },
 { 220,6610 }, { 221,6610 }, { 222,6610 }, { 223,6610 }, { 224,6610 },
 { 225,6610 }, { 226,6610 }, { 227,6610 }, { 228,6610 }, { 229,6610 },
 { 230,6610 }, { 231,6610 }, { 232,6610 }, { 233,6610 }, { 234,6610 },

 { 235,6610 }, { 236,6610 }, { 237,6610 }, { 238,6610 }, { 239,6610 },
 { 240,6610 }, { 241,6610 }, { 242,6610 }, { 243,6610 }, { 244,6610 },
 { 245,6610 }, { 246,6610 }, { 247,6610 }, { 248,6610 }, { 249,6610 },
 { 250,6610 }, { 251,6610 }, { 252,6610 }, { 253,6610 }, { 254,6610 },
 { 255,6610 }, { 256,6610 }, {   0,   0 }, {   0,15203 }, {   1,6352 },
 {   2,6352 }, {   3,6352 }, {   4,6352 }, {   5,6352 }, {   6,6352 },
 {   7,6352 }, {   8,6352 }, {   9,6352 }, {  10,6610 }, {  11,6352 },
 {  12,6352 }, {  13,6352 }, {  14,6352 }, {  15,6352 }, {  16,6352 },
 {  17,6352 }, {  18,6352 }, {  19,6352 }, {  20,6352 }, {  21,6352 },
 {  22,6352 }, {  23,6352 }, {  24,6352 }, {  25,6352 }, {  26,6352 },

 {  27,6352 }, {  28,6352 }, {  29,6352 }, {  30,6352 }, {  31,6352 },
 {  32,6352 }, {  33,6352 }, {  34,6352 }, {  35,6352 }, {  36,6352 },
 {  37,6352 }, {  38,6352 }, {  39,2387 }, {  40,6352 }, {  41,6352 },
 {  42,6352 }, {  43,6352 }, {  44,6352 }, {  45,6352 }, {  46,6352 },
 {  47,6352 }, {  48,6352 }, {  49,6352 }, {  50,6352 }, {  51,6352 },
 {  52,6352 }, {  53,6352 }, {  54,6352 }, {  55,6352 }, {  56,6352 },
 {  57,6352 }, {  58,6352 }, {  59,6352 }, {  60,6352 }, {  61,6352 },
 {  62,6352 }, {  63,6352 }, {  64,6352 }, {  65,6352 }, {  66,6352 },
 {  67,6352 }, {  68,6352 }, {  69,6352 }, {  70,6352 }, {  71,6352 },
 {  72,6352 }, {  73,6352 }, {  74,6352 }, {  75,6352 }, {  76,6352 },

 {  77,6352 }, {  78,6352 }, {  79,6352 }, {  80,6352 }, {  81,6352 },
 {  82,6352 }, {  83,6352 }, {  84,6352 }, {  85,6352 }, {  86,6352 },
 {  87,6352 }, {  88,6352 }, {  89,6352 }, {  90,6352 }, {  91,6352 },
 {  92,6868 }, {  93,6352 }, {  94,6352 }, {  95,6352 }, {  96,6352 },
 {  97,6352 }, {  98,6352 }, {  99,6352 }, { 100,6352 }, { 101,6352 },
 { 102,6352 }, { 103,6352 }, { 104,6352 }, { 105,6352 }, { 106,6352 },
 { 107,6352 }, { 108,6352 }, { 109,6352 }, { 110,6352 }, { 111,6352 },
 { 112,6352 }, { 113,6352 }, { 114,6352 }, { 115,6352 }, { 116,6352 },
 { 117,6352 }, { 118,6352 }, { 119,6352 }, { 120,6352 }, { 121,6352 },
 { 122,6352 }, { 123,6352 }, { 124,6352 }, { 125,6352 }, { 126,6352 },

 { 127,6352 }, { 128,6352 }, { 129,6352 }, { 130,6352 }, { 131,6352 },
 { 132,6352 }, { 133,6352 }, { 134,6352 }, { 135,6352 }, { 136,6352 },
 { 137,6352 }, { 138,6352 }, { 139,6352 }, { 140,6352 }, { 141,6352 },
 { 142,6352 }, { 143,6352 }, { 144,6352 }, { 145,6352 }, { 146,6352 },
 { 147,6352 }, { 148,6352 }, { 149,6352 }, { 150,6352 }, { 151,6352 },
 { 152,6352 }, { 153,6352 }, { 154,6352 }, { 155,6352 }, { 156,6352 },
 { 157,6352 }, { 158,6352 }, { 159,6352 }, { 160,6352 }, { 161,6352 },
 { 162,6352 }, { 163,6352 }, { 164,6352 }, { 165,6352 }, { 166,6352 },
 { 167,6352 }, { 168,6352 }, { 169,6352 }, { 170,6352 }, { 171,6352 },
 { 172,6352 }, { 173,6352 }, { 174,6352 }, { 175,6352 }, { 176,6352 },

 { 177,6352 }, { 178,6352 }, { 179,6352 }, { 180,6352 }, { 181,6352 },
 { 182,6352 }, { 183,6352 }, { 184,6352 }, { 185,6352 }, { 186,6352 },
 { 187,6352 }, { 188,6352 }, { 189,6352 }, { 190,6352 }, { 191,6352 },
 { 192,6352 }, { 193,6352 }, { 194,6352 }, { 195,6352 }, { 196,6352 },
 { 197,6352 }, { 198,6352 }, { 199,6352 }, { 200,6352 }, { 201,6352 },
 { 202,6352 }, { 203,6352 }, { 204,6352 }, { 205,6352 }, { 206,6352 },
 { 207,6352 }, { 208,6352 }, { 209,6352 }, { 210,6352 }, { 211,6352 },
 { 212,6352 }, { 213,6352 }, { 214,6352 }, { 215,6352 }, { 216,6352 },
 { 217,6352 }, { 218,6352 }, { 219,6352 }, { 220,6352 }, { 221,6352 },
 { 222,6352 }, { 223,6352 }, { 224,6352 }, { 225,6352 }, { 226,6352 },

 { 227,6352 }, { 228,6352 }, { 229,6352 }, { 230,6352 }, { 231,6352 },
 { 232,6352 }, { 233,6352 }, { 234,6352 }, { 235,6352 }, { 236,6352 },
 { 237,6352 }, { 238,6352 }, { 239,6352 }, { 240,6352 }, { 241,6352 },
 { 242,6352 }, { 243,6352 }, { 244,6352 }, { 245,6352 }, { 246,6352 },
 { 247,6352 }, { 248,6352 }, { 249,6352 }, { 250,6352 }, { 251,6352 },
 { 252,6352 }, { 253,6352 }, { 254,6352 }, { 255,6352 }, { 256,6352 },
 {   0,   0 }, {   0,14945 }, {   1,6868 }, {   2,6868 }, {   3,6868 },
 {   4,6868 }, {   5,6868 }, {   6,6868 }, {   7,6868 }, {   8,6868 },
 {   9,6868 }, {  10,7126 }, {  11,6868 }, {  12,6868 }, {  13,6868 },
 {  14,6868 }, {  15,6868 }, {  16,6868 }, {  17,6868 }, {  18,6868 },

 {  19,6868 }, {  20,6868 }, {  21,6868 }, {  22,6868 }, {  23,6868 },
 {  24,6868 }, {  25,6868 }, {  26,6868 }, {  27,6868 }, {  28,6868 },
 {  29,6868 }, {  30,6868 }, {  31,6868 }, {  32,6868 }, {  33,6868 },
 {  34,6868 }, {  35,6868 }, {  36,7384 }, {  37,6868 }, {  38,6868 },
 {  39,6868 }, {  40,6868 }, {  41,6868 }, {  42,6868 }, {  43,6868 },
 {  44,6868 }, {  45,6868 }, {  46,6868 }, {  47,6868 }, {  48,6868 },
 {  49,6868 }, {  50,6868 }, {  51,6868 }, {  52,6868 }, {  53,6868 },
 {  54,6868 }, {  55,6868 }, {  56,6868 }, {  57,6868 }, {  58,6868 },
 {  59,6868 }, {  60,6868 }, {  61,6868 }, {  62,6868 }, {  63,6868 },
 {  64,6868 }, {  65,6868 }, {  66,6868 }, {  67,6868 }, {  68,6868 },

 {  69,6868 }, {  70,6868 }, {  71,6868 }, {  72,6868 }, {  73,6868 },
 {  74,6868 }, {  75,6868 }, {  76,6868 }, {  77,6868 }, {  78,6868 },
 {  79,6868 }, {  80,6868 }, {  81,6868 }, {  82,6868 }, {  83,6868 },
 {  84,6868 }, {  85,6868 }, {  86,6868 }, {  87,6868 }, {  88,6868 },
 {  89,6868 }, {  90,6868 }, {  91,6868 }, {  92,6868 }, {  93,6868 },
 {  94,6868 }, {  95,6868 }, {  96,6868 }, {  97,6868 }, {  98,6868 },
 {  99,6868 }, { 100,6868 }, { 101,6868 }, { 102,6868 }, { 103,6868 },
 { 104,6868 }, { 105,6868 }, { 106,6868 }, { 107,6868 }, { 108,6868 },
 { 109,6868 }, { 110,6868 }, { 111,6868 }, { 112,6868 }, { 113,6868 },
 { 114,6868 }, { 115,6868 }, { 116,6868 }, { 117,6868 }, { 118,6868 },

 { 119,6868 }, { 120,6868 }, { 121,6868 }, { 122,6868 }, { 123,6868 },
 { 124,6868 }, { 125,6868 }, { 126,6868 }, { 127,6868 }, { 128,6868 },
 { 129,6868 }, { 130,6868 }, { 131,6868 }, { 132,6868 }, { 133,6868 },
 { 134,6868 }, { 135,6868 }, { 136,6868 }, { 137,6868 }, { 138,6868 },
 { 139,6868 }, { 140,6868 }, { 141,6868 }, { 142,6868 }, { 143,6868 },
 { 144,6868 }, { 145,6868 }, { 146,6868 }, { 147,6868 }, { 148,6868 },
 { 149,6868 }, { 150,6868 }, { 151,6868 }, { 152,6868 }, { 153,6868 },
 { 154,6868 }, { 155,6868 }, { 156,6868 }, { 157,6868 }, { 158,6868 },
 { 159,6868 }, { 160,6868 }, { 161,6868 }, { 162,6868 }, { 163,6868 },
 { 164,6868 }, { 165,6868 }, { 166,6868 }, { 167,6868 }, { 168,6868 },

 { 169,6868 }, { 170,6868 }, { 171,6868 }, { 172,6868 }, { 173,6868 },
 { 174,6868 }, { 175,6868 }, { 176,6868 }, { 177,6868 }, { 178,6868 },
 { 179,6868 }, { 180,6868 }, { 181,6868 }, { 182,6868 }, { 183,6868 },
 { 184,6868 }, { 185,6868 }, { 186,6868 }, { 187,6868 }, { 188,6868 },
 { 189,6868 }, { 190,6868 }, { 191,6868 }, { 192,6868 }, { 193,6868 },
 { 194,6868 }, { 195,6868 }, { 196,6868 }, { 197,6868 }, { 198,6868 },
 { 199,6868 }, { 200,6868 }, { 201,6868 }, { 202,6868 }, { 203,6868 },
 { 204,6868 }, { 205,6868 }, { 206,6868 }, { 207,6868 }, { 208,6868 },
 { 209,6868 }, { 210,6868 }, { 211,6868 }, { 212,6868 }, { 213,6868 },
 { 214,6868 }, { 215,6868 }, { 216,6868 }, { 217,6868 }, { 218,6868 },

 { 219,6868 }, { 220,6868 }, { 221,6868 }, { 222,6868 }, { 223,6868 },
 { 224,6868 }, { 225,6868 }, { 226,6868 }, { 227,6868 }, { 228,6868 },
 { 229,6868 }, { 230,6868 }, { 231,6868 }, { 232,6868 }, { 233,6868 },
 { 234,6868 }, { 235,6868 }, { 236,6868 }, { 237,6868 }, { 238,6868 },
 { 239,6868 }, { 240,6868 }, { 241,6868 }, { 242,6868 }, { 243,6868 },
 { 244,6868 }, { 245,6868 }, { 246,6868 }, { 247,6868 }, { 248,6868 },
 { 249,6868 }, { 250,6868 }, { 251,6868 }, { 252,6868 }, { 253,6868 },
 { 254,6868 }, { 255,6868 }, { 256,6868 }, {   0,   0 }, {   0,14687 },
 {   1,6610 }, {   2,6610 }, {   3,6610 }, {   4,6610 }, {   5,6610 },
 {   6,6610 }, {   7,6610 }, {   8,6610 }, {   9,6610 }, {  10,6868 },

 {  11,6610 }, {  12,6610 }, {  13,6610 }, {  14,6610 }, {  15,6610 },
 {  16,6610 }, {  17,6610 }, {  18,6610 }, {  19,6610 }, {  20,6610 },
 {  21,6610 }, {  22,6610 }, {  23,6610 }, {  24,6610 }, {  25,6610 },
 {  26,6610 }, {  27,6610 }, {  28,6610 }, {  29,6610 }, {  30,6610 },
 {  31,6610 }, {  32,6610 }, {  33,6610 }, {  34,6610 }, {  35,6610 },
 {  36,7126 }, {  37,6610 }, {  38,6610 }, {  39,6610 }, {  40,6610 },
 {  41,6610 }, {  42,6610 }, {  43,6610 }, {  44,6610 }, {  45,6610 },
 {  46,6610 }, {  47,6610 }, {  48,6610 }, {  49,6610 }, {  50,6610 },
 {  51,6610 }, {  52,6610 }, {  53,6610 }, {  54,6610 }, {  55,6610 },
 {  56,6610 }, {  57,6610 }, {  58,6610 }, {  59,6610 }, {  60,6610 },

 {  61,6610 }, {  62,6610 }, {  63,6610 }, {  64,6610 }, {  65,6610 },
 {  66,6610 }, {  67,6610 }, {  68,6610 }, {  69,6610 }, {  70,6610 },
 {  71,6610 }, {  72,6610 }, {  73,6610 }, {  74,6610 }, {  75,6610 },
 {  76,6610 }, {  77,6610 }, {  78,6610 }, {  79,6610 }, {  80,6610 },
 {  81,6610 }, {  82,6610 }, {  83,6610 }, {  84,6610 }, {  85,6610 },
 {  86,6610 }, {  87,6610 }, {  88,6610 }, {  89,6610 }, {  90,6610 },
 {  91,6610 }, {  92,6610 }, {  93,6610 }, {  94,6610 }, {  95,6610 },
 {  96,6610 }, {  97,6610 }, {  98,6610 }, {  99,6610 }, { 100,6610 },
 { 101,6610 }, { 102,6610 }, { 103,6610 }, { 104,6610 }, { 105,6610 },
 { 106,6610 }, { 107,6610 }, { 108,6610 }, { 109,6610 }, { 110,6610 },

 { 111,6610 }, { 112,6610 }, { 113,6610 }, { 114,6610 }, { 115,6610 },
 { 116,6610 }, { 117,6610 }, { 118,6610 }, { 119,6610 }, { 120,6610 },
 { 121,6610 }, { 122,6610 }, { 123,6610 }, { 124,6610 }, { 125,6610 },
 { 126,6610 }, { 127,6610 }, { 128,6610 }, { 129,6610 }, { 130,6610 },
 { 131,6610 }, { 132,6610 }, { 133,6610 }, { 134,6610 }, { 135,6610 },
 { 136,6610 }, { 137,6610 }, { 138,6610 }, { 139,6610 }, { 140,6610 },
 { 141,6610 }, { 142,6610 }, { 143,6610 }, { 144,6610 }, { 145,6610 },
 { 146,6610 }, { 147,6610 }, { 148,6610 }, { 149,6610 }, { 150,6610 },
 { 151,6610 }, { 152,6610 }, { 153,6610 }, { 154,6610 }, { 155,6610 },
 { 156,6610 }, { 157,6610 }, { 158,6610 }, { 159,6610 }, { 160,6610 },

 { 161,6610 }, { 162,6610 }, { 163,6610 }, { 164,6610 }, { 165,6610 },
 { 166,6610 }, { 167,6610 }, { 168,6610 }, { 169,6610 }, { 170,6610 },
 { 171,6610 }, { 172,6610 }, { 173,6610 }, { 174,6610 }, { 175,6610 },
 { 176,6610 }, { 177,6610 }, { 178,6610 }, { 179,6610 }, { 180,6610 },
 { 181,6610 }, { 182,6610 }, { 183,6610 }, { 184,6610 }, { 185,6610 },
 { 186,6610 }, { 187,6610 }, { 188,6610 }, { 189,6610 }, { 190,6610 },
 { 191,6610 }, { 192,6610 }, { 193,6610 }, { 194,6610 }, { 195,6610 },
 { 196,6610 }, { 197,6610 }, { 198,6610 }, { 199,6610 }, { 200,6610 },
 { 201,6610 }, { 202,6610 }, { 203,6610 }, { 204,6610 }, { 205,6610 },
 { 206,6610 }, { 207,6610 }, { 208,6610 }, { 209,6610 }, { 210,6610 },

 { 211,6610 }, { 212,6610 }, { 213,6610 }, { 214,6610 }, { 215,6610 },
 { 216,6610 }, { 217,6610 }, { 218,6610 }, { 219,6610 }, { 220,6610 },
 { 221,6610 }, { 222,6610 }, { 223,6610 }, { 224,6610 }, { 225,6610 },
 { 226,6610 }, { 227,6610 }, { 228,6610 }, { 229,6610 }, { 230,6610 },
 { 231,6610 }, { 232,6610 }, { 233,6610 }, { 234,6610 }, { 235,6610 },
 { 236,6610 }, { 237,6610 }, { 238,6610 }, { 239,6610 }, { 240,6610 },
 { 241,6610 }, { 242,6610 }, { 243,6610 }, { 244,6610 }, { 245,6610 },
 { 246,6610 }, { 247,6610 }, { 248,6610 }, { 249,6610 }, { 250,6610 },
 { 251,6610 }, { 252,6610 }, { 253,6610 }, { 254,6610 }, { 255,6610 },
 { 256,6610 }, {   0,   0 }, {   0,14429 }, {   1,4736 }, {   2,4736 },

 {   3,4736 }, {   4,4736 }, {   5,4736 }, {   6,4736 }, {   7,4736 },
 {   8,4736 }, {   9,4736 }, {  10,4736 }, {  11,4736 }, {  12,4736 },
 {  13,4736 }, {  14,4736 }, {  15,4736 }, {  16,4736 }, {  17,4736 },
 {  18,4736 }, {  19,4736 }, {  20,4736 }, {  21,4736 }, {  22,4736 },
 {  23,4736 }, {  24,4736 }, {  25,4736 }, {  26,4736 }, {  27,4736 },
 {  28,4736 }, {  29,4736 }, {  30,4736 }, {  31,4736 }, {  32,4736 },
 {  33,4736 }, {  34,1615 }, {  35,4736 }, {  36,4736 }, {  37,4736 },
 {  38,4736 }, {  39,4736 }, {  40,4736 }, {  41,4736 }, {  42,4736 },
 {  43,4736 }, {  44,4736 }, {  45,4736 }, {  46,4736 }, {  47,4736 },
 {  48,4736 }, {  49,4736 }, {  50,4736 }, {  51,4736 }, {  52,4736 },

 {  53,4736 }, {  54,4736 }, {  55,4736 }, {  56,4736 }, {  57,4736 },
 {  58,4736 }, {  59,4736 }, {  60,4736 }, {  61,4736 }, {  62,4736 },
 {  63,4736 }, {  64,4736 }, {  65,4736 }, {  66,4736 }, {  67,4736 },
 {  68,4736 }, {  69,4736 }, {  70,4736 }, {  71,4736 }, {  72,4736 },
 {  73,4736 }, {  74,4736 }, {  75,4736 }, {  76,4736 }, {  77,4736 },
 {  78,4736 }, {  79,4736 }, {  80,4736 }, {  81,4736 }, {  82,4736 },
 {  83,4736 }, {  84,4736 }, {  85,4736 }, {  86,4736 }, {  87,4736 },
 {  88,4736 }, {  89,4736 }, {  90,4736 }, {  91,4736 }, {  92,4736 },
 {  93,4736 }, {  94,4736 }, {  95,4736 }, {  96,4736 }, {  97,4736 },
 {  98,4736 }, {  99,4736 }, { 100,4736 }, { 101,4736 }, { 102,4736 },

 { 103,4736 }, { 104,4736 }, { 105,4736 }, { 106,4736 }, { 107,4736 },
 { 108,4736 }, { 109,4736 }, { 110,4736 }, { 111,4736 }, { 112,4736 },
 { 113,4736 }, { 114,4736 }, { 115,4736 }, { 116,4736 }, { 117,4736 },
 { 118,4736 }, { 119,4736 }, { 120,4736 }, { 121,4736 }, { 122,4736 },
 { 123,4736 }, { 124,4736 }, { 125,4736 }, { 126,4736 }, { 127,4736 },
 { 128,4736 }, { 129,4736 }, { 130,4736 }, { 131,4736 }, { 132,4736 },
 { 133,4736 }, { 134,4736 }, { 135,4736 }, { 136,4736 }, { 137,4736 },
 { 138,4736 }, { 139,4736 }, { 140,4736 }, { 141,4736 }, { 142,4736 },
 { 143,4736 }, { 144,4736 }, { 145,4736 }, { 146,4736 }, { 147,4736 },
 { 148,4736 }, { 149,4736 }, { 150,4736 }, { 151,4736 }, { 152,4736 },

 { 153,4736 }, { 154,4736 }, { 155,4736 }, { 156,4736 }, { 157,4736 },
 { 158,4736 }, { 159,4736 }, { 160,4736 }, { 161,4736 }, { 162,4736 },
 { 163,4736 }, { 164,4736 }, { 165,4736 }, { 166,4736 }, { 167,4736 },
 { 168,4736 }, { 169,4736 }, { 170,4736 }, { 171,4736 }, { 172,4736 },
 { 173,4736 }, { 174,4736 }, { 175,4736 }, { 176,4736 }, { 177,4736 },
 { 178,4736 }, { 179,4736 }, { 180,4736 }, { 181,4736 }, { 182,4736 },
 { 183,4736 }, { 184,4736 }, { 185,4736 }, { 186,4736 }, { 187,4736 },
 { 188,4736 }, { 189,4736 }, { 190,4736 }, { 191,4736 }, { 192,4736 },
 { 193,4736 }, { 194,4736 }, { 195,4736 }, { 196,4736 }, { 197,4736 },
 { 198,4736 }, { 199,4736 }, { 200,4736 }, { 201,4736 }, { 202,4736 },

 { 203,4736 }, { 204,4736 }, { 205,4736 }, { 206,4736 }, { 207,4736 },
 { 208,4736 }, { 209,4736 }, { 210,4736 }, { 211,4736 }, { 212,4736 },
 { 213,4736 }, { 214,4736 }, { 215,4736 }, { 216,4736 }, { 217,4736 },
 { 218,4736 }, { 219,4736 }, { 220,4736 }, { 221,4736 }, { 222,4736 },
 { 223,4736 }, { 224,4736 }, { 225,4736 }, { 226,4736 }, { 227,4736 },
 { 228,4736 }, { 229,4736 }, { 230,4736 }, { 231,4736 }, { 232,4736 },
 { 233,4736 }, { 234,4736 }, { 235,4736 }, { 236,4736 }, { 237,4736 },
 { 238,4736 }, { 239,4736 }, { 240,4736 }, { 241,4736 }, { 242,4736 },
 { 243,4736 }, { 244,4736 }, { 245,4736 }, { 246,4736 }, { 247,4736 },
 { 248,4736 }, { 249,4736 }, { 250,4736 }, { 251,4736 }, { 252,4736 },

 { 253,4736 }, { 254,4736 }, { 255,4736 }, { 256,4736 }, {   0,   0 },
 {   0,14171 }, {   1,4478 }, {   2,4478 }, {   3,4478 }, {   4,4478 },
 {   5,4478 }, {   6,4478 }, {   7,4478 }, {   8,4478 }, {   9,4478 },
 {  10,4478 }, {  11,4478 }, {  12,4478 }, {  13,4478 }, {  14,4478 },
 {  15,4478 }, {  16,4478 }, {  17,4478 }, {  18,4478 }, {  19,4478 },
 {  20,4478 }, {  21,4478 }, {  22,4478 }, {  23,4478 }, {  24,4478 },
 {  25,4478 }, {  26,4478 }, {  27,4478 }, {  28,4478 }, {  29,4478 },
 {  30,4478 }, {  31,4478 }, {  32,4478 }, {  33,4478 }, {  34,1357 },
 {  35,4478 }, {  36,4478 }, {  37,4478 }, {  38,4478 }, {  39,4478 },
 {  40,4478 }, {  41,4478 }, {  42,4478 }, {  43,4478 }, {  44,4478 },

 {  45,4478 }, {  46,4478 }, {  47,4478 }, {  48,4478 }, {  49,4478 },
 {  50,4478 }, {  51,4478 }, {  52,4478 }, {  53,4478 }, {  54,4478 },
 {  55,4478 }, {  56,4478 }, {  57,4478 }, {  58,4478 }, {  59,4478 },
 {  60,4478 }, {  61,4478 }, {  62,4478 }, {  63,4478 }, {  64,4478 },
 {  65,4478 }, {  66,4478 }, {  67,4478 }, {  68,4478 }, {  69,4478 },
 {  70,4478 }, {  71,4478 }, {  72,4478 }, {  73,4478 }, {  74,4478 },
 {  75,4478 }, {  76,4478 }, {  77,4478 }, {  78,4478 }, {  79,4478 },
 {  80,4478 }, {  81,4478 }, {  82,4478 }, {  83,4478 }, {  84,4478 },
 {  85,4478 }, {  86,4478 }, {  87,4478 }, {  88,4478 }, {  89,4478 },
 {  90,4478 }, {  91,4478 }, {  92,4478 }, {  93,4478 }, {  94,4478 },

 {  95,4478 }, {  96,4478 }, {  97,4478 }, {  98,4478 }, {  99,4478 },
 { 100,4478 }, { 101,4478 }, { 102,4478 }, { 103,4478 }, { 104,4478 },
 { 105,4478 }, { 106,4478 }, { 107,4478 }, { 108,4478 }, { 109,4478 },
 { 110,4478 }, { 111,4478 }, { 112,4478 }, { 113,4478 }, { 114,4478 },
 { 115,4478 }, { 116,4478 }, { 117,4478 }, { 118,4478 }, { 119,4478 },
 { 120,4478 }, { 121,4478 }, { 122,4478 }, { 123,4478 }, { 124,4478 },
 { 125,4478 }, { 126,4478 }, { 127,4478 }, { 128,4478 }, { 129,4478 },
 { 130,4478 }, { 131,4478 }, { 132,4478 }, { 133,4478 }, { 134,4478 },
 { 135,4478 }, { 136,4478 }, { 137,4478 }, { 138,4478 }, { 139,4478 },
 { 140,4478 }, { 141,4478 }, { 142,4478 }, { 143,4478 }, { 144,4478 },

 { 145,4478 }, { 146,4478 }, { 147,4478 }, { 148,4478 }, { 149,4478 },
 { 150,4478 }, { 151,4478 }, { 152,4478 }, { 153,4478 }, { 154,4478 },
 { 155,4478 }, { 156,4478 }, { 157,4478 }, { 158,4478 }, { 159,4478 },
 { 160,4478 }, { 161,4478 }, { 162,4478 }, { 163,4478 }, { 164,4478 },
 { 165,4478 }, { 166,4478 }, { 167,4478 }, { 168,4478 }, { 169,4478 },
 { 170,4478 }, { 171,4478 }, { 172,4478 }, { 173,4478 }, { 174,4478 },
 { 175,4478 }, { 176,4478 }, { 177,4478 }, { 178,4478 }, { 179,4478 },
 { 180,4478 }, { 181,4478 }, { 182,4478 }, { 183,4478 }, { 184,4478 },
 { 185,4478 }, { 186,4478 }, { 187,4478 }, { 188,4478 }, { 189,4478 },
 { 190,4478 }, { 191,4478 }, { 192,4478 }, { 193,4478 }, { 194,4478 },

 { 195,4478 }, { 196,4478 }, { 197,4478 }, { 198,4478 }, { 199,4478 },
 { 200,4478 }, { 201,4478 }, { 202,4478 }, { 203,4478 }, { 204,4478 },
 { 205,4478 }, { 206,4478 }, { 207,4478 }, { 208,4478 }, { 209,4478 },
 { 210,4478 }, { 211,4478 }, { 212,4478 }, { 213,4478 }, { 214,4478 },
 { 215,4478 }, { 216,4478 }, { 217,4478 }, { 218,4478 }, { 219,4478 },
 { 220,4478 }, { 221,4478 }, { 222,4478 }, { 223,4478 }, { 224,4478 },
 { 225,4478 }, { 226,4478 }, { 227,4478 }, { 228,4478 }, { 229,4478 },
 { 230,4478 }, { 231,4478 }, { 232,4478 }, { 233,4478 }, { 234,4478 },
 { 235,4478 }, { 236,4478 }, { 237,4478 }, { 238,4478 }, { 239,4478 },
 { 240,4478 }, { 241,4478 }, { 242,4478 }, { 243,4478 }, { 244,4478 },

 { 245,4478 }, { 246,4478 }, { 247,4478 }, { 248,4478 }, { 249,4478 },
 { 250,4478 }, { 251,4478 }, { 252,4478 }, { 253,4478 }, { 254,4478 },
 { 255,4478 }, { 256,4478 }, {   0,   0 }, {   0,13913 }, {   1,4736 },
 {   2,4736 }, {   3,4736 }, {   4,4736 }, {   5,4736 }, {   6,4736 },
 {   7,4736 }, {   8,4736 }, {   9,4736 }, {  10,4736 }, {  11,4736 },
 {  12,4736 }, {  13,4736 }, {  14,4736 }, {  15,4736 }, {  16,4736 },
 {  17,4736 }, {  18,4736 }, {  19,4736 }, {  20,4736 }, {  21,4736 },
 {  22,4736 }, {  23,4736 }, {  24,4736 }, {  25,4736 }, {  26,4736 },
 {  27,4736 }, {  28,4736 }, {  29,4736 }, {  30,4736 }, {  31,4736 },
 {  32,4736 }, {  33,4736 }, {  34,4736 }, {  35,4736 }, {  36,4736 },

 {  37,4736 }, {  38,4736 }, {  39,1090 }, {  40,4736 }, {  41,4736 },
 {  42,4736 }, {  43,4736 }, {  44,4736 }, {  45,4736 }, {  46,4736 },
 {  47,4736 }, {  48,4736 }, {  49,4736 }, {  50,4736 }, {  51,4736 },
 {  52,4736 }, {  53,4736 }, {  54,4736 }, {  55,4736 }, {  56,4736 },
 {  57,4736 }, {  58,4736 }, {  59,4736 }, {  60,4736 }, {  61,4736 },
 {  62,4736 }, {  63,4736 }, {  64,4736 }, {  65,4736 }, {  66,4736 },
 {  67,4736 }, {  68,4736 }, {  69,4736 }, {  70,4736 }, {  71,4736 },
 {  72,4736 }, {  73,4736 }, {  74,4736 }, {  75,4736 }, {  76,4736 },
 {  77,4736 }, {  78,4736 }, {  79,4736 }, {  80,4736 }, {  81,4736 },
 {  82,4736 }, {  83,4736 }, {  84,4736 }, {  85,4736 }, {  86,4736 },

 {  87,4736 }, {  88,4736 }, {  89,4736 }, {  90,4736 }, {  91,4736 },
 {  92,4736 }, {  93,4736 }, {  94,4736 }, {  95,4736 }, {  96,4736 },
 {  97,4736 }, {  98,4736 }, {  99,4736 }, { 100,4736 }, { 101,4736 },
 { 102,4736 }, { 103,4736 }, { 104,4736 }, { 105,4736 }, { 106,4736 },
 { 107,4736 }, { 108,4736 }, { 109,4736 }, { 110,4736 }, { 111,4736 },
 { 112,4736 }, { 113,4736 }, { 114,4736 }, { 115,4736 }, { 116,4736 },
 { 117,4736 }, { 118,4736 }, { 119,4736 }, { 120,4736 }, { 121,4736 },
 { 122,4736 }, { 123,4736 }, { 124,4736 }, { 125,4736 }, { 126,4736 },
 { 127,4736 }, { 128,4736 }, { 129,4736 }, { 130,4736 }, { 131,4736 },
 { 132,4736 }, { 133,4736 }, { 134,4736 }, { 135,4736 }, { 136,4736 },

 { 137,4736 }, { 138,4736 }, { 139,4736 }, { 140,4736 }, { 141,4736 },
 { 142,4736 }, { 143,4736 }, { 144,4736 }, { 145,4736 }, { 146,4736 },
 { 147,4736 }, { 148,4736 }, { 149,4736 }, { 150,4736 }, { 151,4736 },
 { 152,4736 }, { 153,4736 }, { 154,4736 }, { 155,4736 }, { 156,4736 },
 { 157,4736 }, { 158,4736 }, { 159,4736 }, { 160,4736 }, { 161,4736 },
 { 162,4736 }, { 163,4736 }, { 164,4736 }, { 165,4736 }, { 166,4736 },
 { 167,4736 }, { 168,4736 }, { 169,4736 }, { 170,4736 }, { 171,4736 },
 { 172,4736 }, { 173,4736 }, { 174,4736 }, { 175,4736 }, { 176,4736 },
 { 177,4736 }, { 178,4736 }, { 179,4736 }, { 180,4736 }, { 181,4736 },
 { 182,4736 }, { 183,4736 }, { 184,4736 }, { 185,4736 }, { 186,4736 },

 { 187,4736 }, { 188,4736 }, { 189,4736 }, { 190,4736 }, { 191,4736 },
 { 192,4736 }, { 193,4736 }, { 194,4736 }, { 195,4736 }, { 196,4736 },
 { 197,4736 }, { 198,4736 }, { 199,4736 }, { 200,4736 }, { 201,4736 },
 { 202,4736 }, { 203,4736 }, { 204,4736 }, { 205,4736 }, { 206,4736 },
 { 207,4736 }, { 208,4736 }, { 209,4736 }, { 210,4736 }, { 211,4736 },
 { 212,4736 }, { 213,4736 }, { 214,4736 }, { 215,4736 }, { 216,4736 },
 { 217,4736 }, { 218,4736 }, { 219,4736 }, { 220,4736 }, { 221,4736 },
 { 222,4736 }, { 223,4736 }, { 224,4736 }, { 225,4736 }, { 226,4736 },
 { 227,4736 }, { 228,4736 }, { 229,4736 }, { 230,4736 }, { 231,4736 },
 { 232,4736 }, { 233,4736 }, { 234,4736 }, { 235,4736 }, { 236,4736 },

 { 237,4736 }, { 238,4736 }, { 239,4736 }, { 240,4736 }, { 241,4736 },
 { 242,4736 }, { 243,4736 }, { 244,4736 }, { 245,4736 }, { 246,4736 },
 { 247,4736 }, { 248,4736 }, { 249,4736 }, { 250,4736 }, { 251,4736 },
 { 252,4736 }, { 253,4736 }, { 254,4736 }, { 255,4736 }, { 256,4736 },
 {   0,   0 }, {   0,13655 }, {   1,4478 }, {   2,4478 }, {   3,4478 },
 {   4,4478 }, {   5,4478 }, {   6,4478 }, {   7,4478 }, {   8,4478 },
 {   9,4478 }, {  10,4478 }, {  11,4478 }, {  12,4478 }, {  13,4478 },
 {  14,4478 }, {  15,4478 }, {  16,4478 }, {  17,4478 }, {  18,4478 },
 {  19,4478 }, {  20,4478 }, {  21,4478 }, {  22,4478 }, {  23,4478 },
 {  24,4478 }, {  25,4478 }, {  26,4478 }, {  27,4478 }, {  28,4478 },

 {  29,4478 }, {  30,4478 }, {  31,4478 }, {  32,4478 }, {  33,4478 },
 {  34,4478 }, {  35,4478 }, {  36,4478 }, {  37,4478 }, {  38,4478 },
 {  39, 832 }, {  40,4478 }, {  41,4478 }, {  42,4478 }, {  43,4478 },
 {  44,4478 }, {  45,4478 }, {  46,4478 }, {  47,4478 }, {  48,4478 },
 {  49,4478 }, {  50,4478 }, {  51,4478 }, {  52,4478 }, {  53,4478 },
 {  54,4478 }, {  55,4478 }, {  56,4478 }, {  57,4478 }, {  58,4478 },
 {  59,4478 }, {  60,4478 }, {  61,4478 }, {  62,4478 }, {  63,4478 },
 {  64,4478 }, {  65,4478 }, {  66,4478 }, {  67,4478 }, {  68,4478 },
 {  69,4478 }, {  70,4478 }, {  71,4478 }, {  72,4478 }, {  73,4478 },
 {  74,4478 }, {  75,4478 }, {  76,4478 }, {  77,4478 }, {  78,4478 },

 {  79,4478 }, {  80,4478 }, {  81,4478 }, {  82,4478 }, {  83,4478 },
 {  84,4478 }, {  85,4478 }, {  86,4478 }, {  87,4478 }, {  88,4478 },
 {  89,4478 }, {  90,4478 }, {  91,4478 }, {  92,4478 }, {  93,4478 },
 {  94,4478 }, {  95,4478 }, {  96,4478 }, {  97,4478 }, {  98,4478 },
 {  99,4478 }, { 100,4478 }, { 101,4478 }, { 102,4478 }, { 103,4478 },
 { 104,4478 }, { 105,4478 }, { 106,4478 }, { 107,4478 }, { 108,4478 },
 { 109,4478 }, { 110,4478 }, { 111,4478 }, { 112,4478 }, { 113,4478 },
 { 114,4478 }, { 115,4478 }, { 116,4478 }, { 117,4478 }, { 118,4478 },
 { 119,4478 }, { 120,4478 }, { 121,4478 }, { 122,4478 }, { 123,4478 },
 { 124,4478 }, { 125,4478 }, { 126,4478 }, { 127,4478 }, { 128,4478 },

 { 129,4478 }, { 130,4478 }, { 131,4478 }, { 132,4478 }, { 133,4478 },
 { 134,4478 }, { 135,4478 }, { 136,4478 }, { 137,4478 }, { 138,4478 },
 { 139,4478 }, { 140,4478 }, { 141,4478 }, { 142,4478 }, { 143,4478 },
 { 144,4478 }, { 145,4478 }, { 146,4478 }, { 147,4478 }, { 148,4478 },
 { 149,4478 }, { 150,4478 }, { 151,4478 }, { 152,4478 }, { 153,4478 },
 { 154,4478 }, { 155,4478 }, { 156,4478 }, { 157,4478 }, { 158,4478 },
 { 159,4478 }, { 160,4478 }, { 161,4478 }, { 162,4478 }, { 163,4478 },
 { 164,4478 }, { 165,4478 }, { 166,4478 }, { 167,4478 }, { 168,4478 },
 { 169,4478 }, { 170,4478 }, { 171,4478 }, { 172,4478 }, { 173,4478 },
 { 174,4478 }, { 175,4478 }, { 176,4478 }, { 177,4478 }, { 178,4478 },

 { 179,4478 }, { 180,4478 }, { 181,4478 }, { 182,4478 }, { 183,4478 },
 { 184,4478 }, { 185,4478 }, { 186,4478 }, { 187,4478 }, { 188,4478 },
 { 189,4478 }, { 190,4478 }, { 191,4478 }, { 192,4478 }, { 193,4478 },
 { 194,4478 }, { 195,4478 }, { 196,4478 }, { 197,4478 }, { 198,4478 },
 { 199,4478 }, { 200,4478 }, { 201,4478 }, { 202,4478 }, { 203,4478 },
 { 204,4478 }, { 205,4478 }, { 206,4478 }, { 207,4478 }, { 208,4478 },
 { 209,4478 }, { 210,4478 }, { 211,4478 }, { 212,4478 }, { 213,4478 },
 { 214,4478 }, { 215,4478 }, { 216,4478 }, { 217,4478 }, { 218,4478 },
 { 219,4478 }, { 220,4478 }, { 221,4478 }, { 222,4478 }, { 223,4478 },
 { 224,4478 }, { 225,4478 }, { 226,4478 }, { 227,4478 }, { 228,4478 },

 { 229,4478 }, { 230,4478 }, { 231,4478 }, { 232,4478 }, { 233,4478 },
 { 234,4478 }, { 235,4478 }, { 236,4478 }, { 237,4478 }, { 238,4478 },
 { 239,4478 }, { 240,4478 }, { 241,4478 }, { 242,4478 }, { 243,4478 },
 { 244,4478 }, { 245,4478 }, { 246,4478 }, { 247,4478 }, { 248,4478 },
 { 249,4478 }, { 250,4478 }, { 251,4478 }, { 252,4478 }, { 253,4478 },
 { 254,4478 }, { 255,4478 }, { 256,4478 }, {   0,   0 }, {   0,13397 },
 {   1, 593 }, {   2, 593 }, {   3, 593 }, {   4, 593 }, {   5, 593 },
 {   6, 593 }, {   7, 593 }, {   8, 593 }, {   9, 593 }, {  10, 597 },
 {  11, 593 }, {  12, 593 }, {  13, 593 }, {  14, 593 }, {  15, 593 },
 {  16, 593 }, {  17, 593 }, {  18, 593 }, {  19, 593 }, {  20, 593 },

 {  21, 593 }, {  22, 593 }, {  23, 593 }, {  24, 593 }, {  25, 593 },
 {  26, 593 }, {  27, 593 }, {  28, 593 }, {  29, 593 }, {  30, 593 },
 {  31, 593 }, {  32, 593 }, {  33, 593 }, {  34, 593 }, {  35, 593 },
 {  36, 593 }, {  37, 593 }, {  38, 593 }, {  39, 593 }, {  40, 593 },
 {  41, 593 }, {  42, 593 }, {  43, 593 }, {  44, 593 }, {  45, 593 },
 {  46, 593 }, {  47, 593 }, {  48, 593 }, {  49, 593 }, {  50, 593 },
 {  51, 593 }, {  52, 593 }, {  53, 593 }, {  54, 593 }, {  55, 593 },
 {  56, 593 }, {  57, 593 }, {  58, 593 }, {  59, 593 }, {  60, 593 },
 {  61, 593 }, {  62, 593 }, {  63, 593 }, {  64, 593 }, {  65, 593 },
 {  66, 593 }, {  67, 593 }, {  68, 593 }, {  69, 593 }, {  70, 593 },

 {  71, 593 }, {  72, 593 }, {  73, 593 }, {  74, 593 }, {  75, 593 },
 {  76, 593 }, {  77, 593 }, {  78, 593 }, {  79, 593 }, {  80, 593 },
 {  81, 593 }, {  82, 593 }, {  83, 593 }, {  84, 593 }, {  85, 593 },
 {  86, 593 }, {  87, 593 }, {  88, 593 }, {  89, 593 }, {  90, 593 },
 {  91, 593 }, {  92, 637 }, {  93, 593 }, {  94, 593 }, {  95, 593 },
 {  96, 593 }, {  97, 593 }, {  98, 593 }, {  99, 593 }, { 100, 593 },
 { 101, 593 }, { 102, 593 }, { 103, 593 }, { 104, 593 }, { 105, 593 },
 { 106, 593 }, { 107, 593 }, { 108, 593 }, { 109, 593 }, { 110, 593 },
 { 111, 593 }, { 112, 593 }, { 113, 593 }, { 114, 593 }, { 115, 593 },
 { 116, 593 }, { 117, 593 }, { 118, 593 }, { 119, 593 }, { 120, 593 },

 { 121, 593 }, { 122, 593 }, { 123, 593 }, { 124, 593 }, { 125, 593 },
 { 126, 593 }, { 127, 593 }, { 128, 593 }, { 129, 593 }, { 130, 593 },
 { 131, 593 }, { 132, 593 }, { 133, 593 }, { 134, 593 }, { 135, 593 },
 { 136, 593 }, { 137, 593 }, { 138, 593 }, { 139, 593 }, { 140, 593 },
 { 141, 593 }, { 142, 593 }, { 143, 593 }, { 144, 593 }, { 145, 593 },
 { 146, 593 }, { 147, 593 }, { 148, 593 }, { 149, 593 }, { 150, 593 },
 { 151, 593 }, { 152, 593 }, { 153, 593 }, { 154, 593 }, { 155, 593 },
 { 156, 593 }, { 157, 593 }, { 158, 593 }, { 159, 593 }, { 160, 593 },
 { 161, 593 }, { 162, 593 }, { 163, 593 }, { 164, 593 }, { 165, 593 },
 { 166, 593 }, { 167, 593 }, { 168, 593 }, { 169, 593 }, { 170, 593 },

 { 171, 593 }, { 172, 593 }, { 173, 593 }, { 174, 593 }, { 175, 593 },
 { 176, 593 }, { 177, 593 }, { 178, 593 }, { 179, 593 }, { 180, 593 },
 { 181, 593 }, { 182, 593 }, { 183, 593 }, { 184, 593 }, { 185, 593 },
 { 186, 593 }, { 187, 593 }, { 188, 593 }, { 189, 593 }, { 190, 593 },
 { 191, 593 }, { 192, 593 }, { 193, 593 }, { 194, 593 }, { 195, 593 },
 { 196, 593 }, { 197, 593 }, { 198, 593 }, { 199, 593 }, { 200, 593 },
 { 201, 593 }, { 202, 593 }, { 203, 593 }, { 204, 593 }, { 205, 593 },
 { 206, 593 }, { 207, 593 }, { 208, 593 }, { 209, 593 }, { 210, 593 },
 { 211, 593 }, { 212, 593 }, { 213, 593 }, { 214, 593 }, { 215, 593 },
 { 216, 593 }, { 217, 593 }, { 218, 593 }, { 219, 593 }, { 220, 593 },

 { 221, 593 }, { 222, 593 }, { 223, 593 }, { 224, 593 }, { 225, 593 },
 { 226, 593 }, { 227, 593 }, { 228, 593 }, { 229, 593 }, { 230, 593 },
 { 231, 593 }, { 232, 593 }, { 233, 593 }, { 234, 593 }, { 235, 593 },
 { 236, 593 }, { 237, 593 }, { 238, 593 }, { 239, 593 }, { 240, 593 },
 { 241, 593 }, { 242, 593 }, { 243, 593 }, { 244, 593 }, { 245, 593 },
 { 246, 593 }, { 247, 593 }, { 248, 593 }, { 249, 593 }, { 250, 593 },
 { 251, 593 }, { 252, 593 }, { 253, 593 }, { 254, 593 }, { 255, 593 },
 { 256, 593 }, {   0,   0 }, {   0,13139 }, {   1, 335 }, {   2, 335 },
 {   3, 335 }, {   4, 335 }, {   5, 335 }, {   6, 335 }, {   7, 335 },
 {   8, 335 }, {   9, 335 }, {  10, 339 }, {  11, 335 }, {  12, 335 },

 {  13, 335 }, {  14, 335 }, {  15, 335 }, {  16, 335 }, {  17, 335 },
 {  18, 335 }, {  19, 335 }, {  20, 335 }, {  21, 335 }, {  22, 335 },
 {  23, 335 }, {  24, 335 }, {  25, 335 }, {  26, 335 }, {  27, 335 },
 {  28, 335 }, {  29, 335 }, {  30, 335 }, {  31, 335 }, {  32, 335 },
 {  33, 335 }, {  34, 335 }, {  35, 335 }, {  36, 335 }, {  37, 335 },
 {  38, 335 }, {  39, 335 }, {  40, 335 }, {  41, 335 }, {  42, 335 },
 {  43, 335 }, {  44, 335 }, {  45, 335 }, {  46, 335 }, {  47, 335 },
 {  48, 335 }, {  49, 335 }, {  50, 335 }, {  51, 335 }, {  52, 335 },
 {  53, 335 }, {  54, 335 }, {  55, 335 }, {  56, 335 }, {  57, 335 },
 {  58, 335 }, {  59, 335 }, {  60, 335 }, {  61, 335 }, {  62, 335 },

 {  63, 335 }, {  64, 335 }, {  65, 335 }, {  66, 335 }, {  67, 335 },
 {  68, 335 }, {  69, 335 }, {  70, 335 }, {  71, 335 }, {  72, 335 },
 {  73, 335 }, {  74, 335 }, {  75, 335 }, {  76, 335 }, {  77, 335 },
 {  78, 335 }, {  79, 335 }, {  80, 335 }, {  81, 335 }, {  82, 335 },
 {  83, 335 }, {  84, 335 }, {  85, 335 }, {  86, 335 }, {  87, 335 },
 {  88, 335 }, {  89, 335 }, {  90, 335 }, {  91, 335 }, {  92, 379 },
 {  93, 335 }, {  94, 335 }, {  95, 335 }, {  96, 335 }, {  97, 335 },
 {  98, 335 }, {  99, 335 }, { 100, 335 }, { 101, 335 }, { 102, 335 },
 { 103, 335 }, { 104, 335 }, { 105, 335 }, { 106, 335 }, { 107, 335 },
 { 108, 335 }, { 109, 335 }, { 110, 335 }, { 111, 335 }, { 112, 335 },

 { 113, 335 }, { 114, 335 }, { 115, 335 }, { 116, 335 }, { 117, 335 },
 { 118, 335 }, { 119, 335 }, { 120, 335 }, { 121, 335 }, { 122, 335 },
 { 123, 335 }, { 124, 335 }, { 125, 335 }, { 126, 335 }, { 127, 335 },
 { 128, 335 }, { 129, 335 }, { 130, 335 }, { 131, 335 }, { 132, 335 },
 { 133, 335 }, { 134, 335 }, { 135, 335 }, { 136, 335 }, { 137, 335 },
 { 138, 335 }, { 139, 335 }, { 140, 335 }, { 141, 335 }, { 142, 335 },
 { 143, 335 }, { 144, 335 }, { 145, 335 }, { 146, 335 }, { 147, 335 },
 { 148, 335 }, { 149, 335 }, { 150, 335 }, { 151, 335 }, { 152, 335 },
 { 153, 335 }, { 154, 335 }, { 155, 335 }, { 156, 335 }, { 157, 335 },
 { 158, 335 }, { 159, 335 }, { 160, 335 }, { 161, 335 }, { 162, 335 },

 { 163, 335 }, { 164, 335 }, { 165, 335 }, { 166, 335 }, { 167, 335 },
 { 168, 335 }, { 169, 335 }, { 170, 335 }, { 171, 335 }, { 172, 335 },
 { 173, 335 }, { 174, 335 }, { 175, 335 }, { 176, 335 }, { 177, 335 },
 { 178, 335 }, { 179, 335 }, { 180, 335 }, { 181, 335 }, { 182, 335 },
 { 183, 335 }, { 184, 335 }, { 185, 335 }, { 186, 335 }, { 187, 335 },
 { 188, 335 }, { 189, 335 }, { 190, 335 }, { 191, 335 }, { 192, 335 },
 { 193, 335 }, { 194, 335 }, { 195, 335 }, { 196, 335 }, { 197, 335 },
 { 198, 335 }, { 199, 335 }, { 200, 335 }, { 201, 335 }, { 202, 335 },
 { 203, 335 }, { 204, 335 }, { 205, 335 }, { 206, 335 }, { 207, 335 },
 { 208, 335 }, { 209, 335 }, { 210, 335 }, { 211, 335 }, { 212, 335 },

 { 213, 335 }, { 214, 335 }, { 215, 335 }, { 216, 335 }, { 217, 335 },
 { 218, 335 }, { 219, 335 }, { 220, 335 }, { 221, 335 }, { 222, 335 },
 { 223, 335 }, { 224, 335 }, { 225, 335 }, { 226, 335 }, { 227, 335 },
 { 228, 335 }, { 229, 335 }, { 230, 335 }, { 231, 335 }, { 232, 335 },
 { 233, 335 }, { 234, 335 }, { 235, 335 }, { 236, 335 }, { 237, 335 },
 { 238, 335 }, { 239, 335 }, { 240, 335 }, { 241, 335 }, { 242, 335 },
 { 243, 335 }, { 244, 335 }, { 245, 335 }, { 246, 335 }, { 247, 335 },
 { 248, 335 }, { 249, 335 }, { 250, 335 }, { 251, 335 }, { 252, 335 },
 { 253, 335 }, { 254, 335 }, { 255, 335 }, { 256, 335 }, {   0,  67 },
 {   0,12881 }, {   0,   1 }, {   0,12879 }, {   0,  39 }, {   0,12877 },

 {   0,   0 }, {   0,   1 }, {   0,12874 }, {   0,  55 }, {   0,12872 },
 {   0,   0 }, {   9,5320 }, {  10,5320 }, {   0,   0 }, {  12,5320 },
 {  13,5320 }, {   9,5315 }, {  10,5315 }, {   0,   0 }, {  12,5315 },
 {  13,5315 }, {   0,  14 }, {   0,12859 }, {   0,  54 }, {   0,12857 },
 {   0,   0 }, {   0,  54 }, {   0,12854 }, {   0,  17 }, {   0,12852 },
 {   0,   0 }, {   0,   7 }, {   0,12849 }, {   0,   0 }, {  32,5320 },
 {   0,   7 }, {   0,12845 }, {   0,   0 }, {   0,   0 }, {  32,5315 },
 {   0,  41 }, {   0,12840 }, {  33,5568 }, {   0,   0 }, {  35,5568 },
 {   0,   0 }, {  37,5568 }, {  38,5568 }, {   0,  55 }, {   0,12832 },
 {   0,   0 }, {  42,5568 }, {  43,5568 }, {   0,   0 }, {  45,5568 },

 {   0,   0 }, {  47,5568 }, {   0,  17 }, {   0,12823 }, {   0,  20 },
 {   0,12821 }, {   0,  19 }, {   0,12819 }, {   0,   0 }, {   0,  17 },
 {   0,12816 }, {   0,  42 }, {   0,12814 }, {   0,   0 }, {  60,5568 },
 {  61,5579 }, {  62,5568 }, {  63,5568 }, {  64,5568 }, {  42, 348 },
 {  34, 346 }, {   0,  26 }, {   0,12804 }, {  42,8188 }, {  47, 353 },
 {   0,  27 }, {   0,12800 }, {  33,5528 }, {   0,   0 }, {  35,5528 },
 {  58, 102 }, {  37,5528 }, {  38,5528 }, {  61, 104 }, {   0,   0 },
 {   0,   0 }, {  42,5528 }, {  43,5528 }, {   0,   0 }, {  45,5528 },
 {   0,   0 }, {  47,5528 }, {  39, 331 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  34, 320 }, {   0,   0 }, {  94,5568 }, {  39, 324 },

 {  96,5568 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5528 },
 {  61,5528 }, {  62,5528 }, {  63,5528 }, {  64,5528 }, {   0,  67 },
 {   0,12766 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  26 }, {   0,12760 }, {   0,  33 }, {   0,12758 }, {   0,  47 },
 {   0,12756 }, {   0,  63 }, {   0,12754 }, {   0,  46 }, {   0,12752 },
 {   0,  48 }, {   0,12750 }, {   0,   0 }, { 124,5568 }, {   0,   0 },
 { 126,5568 }, {   0,   9 }, {   0,12744 }, {   0,  15 }, {   0,12742 },
 {   0,  13 }, {   0,12740 }, {   0,   0 }, {  94,5528 }, {   0,   0 },
 {  96,5528 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   8 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5552 }, {  49,5552 },
 {  50,5552 }, {  51,5552 }, {  52,5552 }, {  53,5552 }, {  54,5552 },
 {  55,5552 }, {  56,5552 }, {  57,5552 }, { 124,5528 }, {   0,   0 },
 { 126,5528 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5809 }, {  66,5809 }, {  67,5809 }, {  68,5809 }, {  69,5809 },
 {  70,5809 }, {  71,5809 }, {  72,5809 }, {  73,5809 }, {  74,5809 },
 {  75,5809 }, {  76,5809 }, {  77,5809 }, {  78,5809 }, {  79,5809 },
 {  80,5809 }, {  81,5809 }, {  82,5809 }, {  83,5809 }, {  84,5809 },
 {  85,5809 }, {  86,5809 }, {  87,5809 }, {  88,5809 }, {  89,5809 },

 {  90,5809 }, {  85,10019 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5809 }, {   0,   0 }, {  97,5809 }, {  98,5809 }, {  99,5809 },
 { 100,5809 }, { 101,5809 }, { 102,5809 }, { 103,5809 }, { 104,5809 },
 { 105,5809 }, { 106,5809 }, { 107,5809 }, { 108,5809 }, { 109,5809 },
 { 110,5809 }, { 111,5809 }, { 112,5809 }, { 113,5809 }, { 114,5809 },
 { 115,5809 }, { 116,5809 }, { 117,5809 }, { 118,5809 }, { 119,5809 },
 { 120,5809 }, { 121,5809 }, { 122,5809 }, { 117,10042 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5809 }, { 129,5809 },
 { 130,5809 }, { 131,5809 }, { 132,5809 }, { 133,5809 }, { 134,5809 },
 { 135,5809 }, { 136,5809 }, { 137,5809 }, { 138,5809 }, { 139,5809 },

 { 140,5809 }, { 141,5809 }, { 142,5809 }, { 143,5809 }, { 144,5809 },
 { 145,5809 }, { 146,5809 }, { 147,5809 }, { 148,5809 }, { 149,5809 },
 { 150,5809 }, { 151,5809 }, { 152,5809 }, { 153,5809 }, { 154,5809 },
 { 155,5809 }, { 156,5809 }, { 157,5809 }, { 158,5809 }, { 159,5809 },
 { 160,5809 }, { 161,5809 }, { 162,5809 }, { 163,5809 }, { 164,5809 },
 { 165,5809 }, { 166,5809 }, { 167,5809 }, { 168,5809 }, { 169,5809 },
 { 170,5809 }, { 171,5809 }, { 172,5809 }, { 173,5809 }, { 174,5809 },
 { 175,5809 }, { 176,5809 }, { 177,5809 }, { 178,5809 }, { 179,5809 },
 { 180,5809 }, { 181,5809 }, { 182,5809 }, { 183,5809 }, { 184,5809 },
 { 185,5809 }, { 186,5809 }, { 187,5809 }, { 188,5809 }, { 189,5809 },

 { 190,5809 }, { 191,5809 }, { 192,5809 }, { 193,5809 }, { 194,5809 },
 { 195,5809 }, { 196,5809 }, { 197,5809 }, { 198,5809 }, { 199,5809 },
 { 200,5809 }, { 201,5809 }, { 202,5809 }, { 203,5809 }, { 204,5809 },
 { 205,5809 }, { 206,5809 }, { 207,5809 }, { 208,5809 }, { 209,5809 },
 { 210,5809 }, { 211,5809 }, { 212,5809 }, { 213,5809 }, { 214,5809 },
 { 215,5809 }, { 216,5809 }, { 217,5809 }, { 218,5809 }, { 219,5809 },
 { 220,5809 }, { 221,5809 }, { 222,5809 }, { 223,5809 }, { 224,5809 },
 { 225,5809 }, { 226,5809 }, { 227,5809 }, { 228,5809 }, { 229,5809 },
 { 230,5809 }, { 231,5809 }, { 232,5809 }, { 233,5809 }, { 234,5809 },
 { 235,5809 }, { 236,5809 }, { 237,5809 }, { 238,5809 }, { 239,5809 },

 { 240,5809 }, { 241,5809 }, { 242,5809 }, { 243,5809 }, { 244,5809 },
 { 245,5809 }, { 246,5809 }, { 247,5809 }, { 248,5809 }, { 249,5809 },
 { 250,5809 }, { 251,5809 }, { 252,5809 }, { 253,5809 }, { 254,5809 },
 { 255,5809 }, {   0,  54 }, {   0,12509 }, {   0,  45 }, {   0,12507 },
 {   0,  12 }, {   0,12505 }, {   0,   0 }, {   0,   0 }, {   0,   8 },
 {   0,12501 }, {   0,   0 }, {   0,  54 }, {   0,12498 }, {   0,   5 },
 {   0,12496 }, {   0,  43 }, {   0,12494 }, {   0,  21 }, {   0,12492 },
 {   0,  19 }, {   0,12490 }, {   0,  18 }, {   0,12488 }, {   0,  29 },
 {   0,12486 }, {   0,  35 }, {   0,12484 }, {   0,  57 }, {   0,12482 },
 {   0,   0 }, {   0,  54 }, {   0,12479 }, {   0,  64 }, {   0,12477 },

 {  33,5205 }, {   0,   0 }, {  35,5205 }, {  34,  50 }, {  37,5205 },
 {  38,5205 }, {   0,  60 }, {   0,12469 }, {  39,  64 }, {  42,5205 },
 {  43,5205 }, {  33,5194 }, {  45,5205 }, {  35,5194 }, {  47,5205 },
 {  37,5194 }, {  38,5194 }, {  42,   0 }, {   0,  40 }, {   0,12457 },
 {  42,5194 }, {  43,5194 }, {  47,   5 }, {  45,5798 }, {   0,   0 },
 {  47,5194 }, {   0,   0 }, {  60,5205 }, {  61,5205 }, {  62,5205 },
 {  63,5205 }, {  64,5205 }, {   0,  16 }, {   0,12443 }, {   0,  65 },
 {   0,12441 }, {   0,  30 }, {   0,12439 }, {  60,5194 }, {  61,5194 },
 {  62,5194 }, {  63,5194 }, {  64,5194 }, {  46,-277 }, {   0,   0 },
 {  48,6037 }, {  49,6037 }, {  50,6037 }, {  51,6037 }, {  52,6037 },

 {  53,6037 }, {  54,6037 }, {  55,6037 }, {  56,6037 }, {  57,6037 },
 {   0,  31 }, {   0,12420 }, {   0,  24 }, {   0,12418 }, {   0,  25 },
 {   0,12416 }, {  94,5205 }, {   0,   0 }, {  96,5205 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  54 }, {   0,12408 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5194 }, {   0,   0 }, {  96,5194 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,5205 }, {   0,   0 }, { 126,5205 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  58 },

 {   0,12376 }, {  33,5104 }, { 124,5194 }, {  35,5104 }, { 126,5194 },
 {  37,5104 }, {  38,5104 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,6223 }, {  43,5104 }, {   0,   0 }, {  45,5104 }, {   0,   0 },
 {  47,5104 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5104 }, {  61,5104 },
 {  62,5104 }, {  63,5104 }, {  64,5104 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,6223 }, {   0,   0 }, {  48,6480 }, {  49,6480 },

 {  50,6480 }, {  51,6480 }, {  52,6480 }, {  53,6480 }, {  54,6480 },
 {  55,6480 }, {  56,6480 }, {  57,6480 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5104 }, {   0,   0 }, {  96,5104 },
 {  65,-378 }, {  66,-378 }, {  67,-378 }, {  68,-378 }, {  69,6737 },
 {  70,-378 }, {  71,-378 }, {  72,-378 }, {  73,-378 }, {  74,-378 },
 {  75,-378 }, {  76,-378 }, {  77,-378 }, {  78,-378 }, {  79,-378 },
 {  80,-378 }, {  81,-378 }, {  82,-378 }, {  83,-378 }, {  84,-378 },
 {  85,-378 }, {  86,-378 }, {  87,-378 }, {  88,-378 }, {  89,-378 },
 {  90,-378 }, {   0,   0 }, { 124,5104 }, {   0,   0 }, { 126,5104 },
 {  95,-378 }, {   0,   0 }, {  97,-378 }, {  98,-378 }, {  99,-378 },

 { 100,-378 }, { 101,6737 }, { 102,-378 }, { 103,-378 }, { 104,-378 },
 { 105,-378 }, { 106,-378 }, { 107,-378 }, { 108,-378 }, { 109,-378 },
 { 110,-378 }, { 111,-378 }, { 112,-378 }, { 113,-378 }, { 114,-378 },
 { 115,-378 }, { 116,-378 }, { 117,-378 }, { 118,-378 }, { 119,-378 },
 { 120,-378 }, { 121,-378 }, { 122,-378 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-378 }, { 129,-378 },
 { 130,-378 }, { 131,-378 }, { 132,-378 }, { 133,-378 }, { 134,-378 },
 { 135,-378 }, { 136,-378 }, { 137,-378 }, { 138,-378 }, { 139,-378 },
 { 140,-378 }, { 141,-378 }, { 142,-378 }, { 143,-378 }, { 144,-378 },
 { 145,-378 }, { 146,-378 }, { 147,-378 }, { 148,-378 }, { 149,-378 },

 { 150,-378 }, { 151,-378 }, { 152,-378 }, { 153,-378 }, { 154,-378 },
 { 155,-378 }, { 156,-378 }, { 157,-378 }, { 158,-378 }, { 159,-378 },
 { 160,-378 }, { 161,-378 }, { 162,-378 }, { 163,-378 }, { 164,-378 },
 { 165,-378 }, { 166,-378 }, { 167,-378 }, { 168,-378 }, { 169,-378 },
 { 170,-378 }, { 171,-378 }, { 172,-378 }, { 173,-378 }, { 174,-378 },
 { 175,-378 }, { 176,-378 }, { 177,-378 }, { 178,-378 }, { 179,-378 },
 { 180,-378 }, { 181,-378 }, { 182,-378 }, { 183,-378 }, { 184,-378 },
 { 185,-378 }, { 186,-378 }, { 187,-378 }, { 188,-378 }, { 189,-378 },
 { 190,-378 }, { 191,-378 }, { 192,-378 }, { 193,-378 }, { 194,-378 },
 { 195,-378 }, { 196,-378 }, { 197,-378 }, { 198,-378 }, { 199,-378 },

 { 200,-378 }, { 201,-378 }, { 202,-378 }, { 203,-378 }, { 204,-378 },
 { 205,-378 }, { 206,-378 }, { 207,-378 }, { 208,-378 }, { 209,-378 },
 { 210,-378 }, { 211,-378 }, { 212,-378 }, { 213,-378 }, { 214,-378 },
 { 215,-378 }, { 216,-378 }, { 217,-378 }, { 218,-378 }, { 219,-378 },
 { 220,-378 }, { 221,-378 }, { 222,-378 }, { 223,-378 }, { 224,-378 },
 { 225,-378 }, { 226,-378 }, { 227,-378 }, { 228,-378 }, { 229,-378 },
 { 230,-378 }, { 231,-378 }, { 232,-378 }, { 233,-378 }, { 234,-378 },
 { 235,-378 }, { 236,-378 }, { 237,-378 }, { 238,-378 }, { 239,-378 },
 { 240,-378 }, { 241,-378 }, { 242,-378 }, { 243,-378 }, { 244,-378 },
 { 245,-378 }, { 246,-378 }, { 247,-378 }, { 248,-378 }, { 249,-378 },

 { 250,-378 }, { 251,-378 }, { 252,-378 }, { 253,-378 }, { 254,-378 },
 { 255,-378 }, {   0,  54 }, {   0,12119 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  54 }, {   0,12108 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,4815 }, {   0,   0 }, {  35,4815 }, {   0,   0 }, {  37,4815 },
 {  38,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4815 },

 {  43,4815 }, {  33,4804 }, {  45,4815 }, {  35,4804 }, {  47,4815 },
 {  37,4804 }, {  38,4804 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,4804 }, {  43,4804 }, {   0,   0 }, {  45,4804 }, {   0,   0 },
 {  47,4804 }, {   0,   0 }, {  60,4815 }, {  61,6505 }, {  62,6516 },
 {  63,4815 }, {  64,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,4804 }, {  61,4804 },
 {  62,6572 }, {  63,4804 }, {  64,4804 }, {   0,   0 }, {   0,  54 },
 {   0,12041 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  94,4815 }, {   0,   0 }, {  96,4815 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,4804 }, {   0,   0 }, {  96,4804 },
 {   0,   0 }, {   0,  66 }, {   0,12009 }, {  33,4737 }, {   0,   0 },
 {  35,4737 }, {   0,   0 }, {  37,4737 }, {  38,4737 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,4737 }, {  43,4737 }, {   0,   0 },
 {  45,4737 }, { 124,4815 }, {  47,4737 }, { 126,4815 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 124,4804 }, {   0,   0 }, { 126,4804 },
 {  60,4737 }, {  61,6545 }, {  62,4737 }, {  63,4737 }, {  64,4737 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,6579 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,6579 }, {  49,6579 }, {  50,6579 }, {  51,6579 }, {  52,6579 },
 {  53,6579 }, {  54,6579 }, {  55,6579 }, {  56,6579 }, {  57,6579 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4737 },
 {   0,   0 }, {  96,4737 }, {  65,6579 }, {  66,6579 }, {  67,6579 },
 {  68,6579 }, {  69,6579 }, {  70,6579 }, {  71,6579 }, {  72,6579 },
 {  73,6579 }, {  74,6579 }, {  75,6579 }, {  76,6579 }, {  77,6579 },
 {  78,6579 }, {  79,6579 }, {  80,6579 }, {  81,6579 }, {  82,6579 },

 {  83,6579 }, {  84,6579 }, {  85,6579 }, {  86,6579 }, {  87,6579 },
 {  88,6579 }, {  89,6579 }, {  90,6579 }, {   0,   0 }, { 124,4737 },
 {   0,   0 }, { 126,4737 }, {  95,6579 }, {   0,   0 }, {  97,6579 },
 {  98,6579 }, {  99,6579 }, { 100,6579 }, { 101,6579 }, { 102,6579 },
 { 103,6579 }, { 104,6579 }, { 105,6579 }, { 106,6579 }, { 107,6579 },
 { 108,6579 }, { 109,6579 }, { 110,6579 }, { 111,6579 }, { 112,6579 },
 { 113,6579 }, { 114,6579 }, { 115,6579 }, { 116,6579 }, { 117,6579 },
 { 118,6579 }, { 119,6579 }, { 120,6579 }, { 121,6579 }, { 122,6579 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,6579 }, { 129,6579 }, { 130,6579 }, { 131,6579 }, { 132,6579 },

 { 133,6579 }, { 134,6579 }, { 135,6579 }, { 136,6579 }, { 137,6579 },
 { 138,6579 }, { 139,6579 }, { 140,6579 }, { 141,6579 }, { 142,6579 },
 { 143,6579 }, { 144,6579 }, { 145,6579 }, { 146,6579 }, { 147,6579 },
 { 148,6579 }, { 149,6579 }, { 150,6579 }, { 151,6579 }, { 152,6579 },
 { 153,6579 }, { 154,6579 }, { 155,6579 }, { 156,6579 }, { 157,6579 },
 { 158,6579 }, { 159,6579 }, { 160,6579 }, { 161,6579 }, { 162,6579 },
 { 163,6579 }, { 164,6579 }, { 165,6579 }, { 166,6579 }, { 167,6579 },
 { 168,6579 }, { 169,6579 }, { 170,6579 }, { 171,6579 }, { 172,6579 },
 { 173,6579 }, { 174,6579 }, { 175,6579 }, { 176,6579 }, { 177,6579 },
 { 178,6579 }, { 179,6579 }, { 180,6579 }, { 181,6579 }, { 182,6579 },

 { 183,6579 }, { 184,6579 }, { 185,6579 }, { 186,6579 }, { 187,6579 },
 { 188,6579 }, { 189,6579 }, { 190,6579 }, { 191,6579 }, { 192,6579 },
 { 193,6579 }, { 194,6579 }, { 195,6579 }, { 196,6579 }, { 197,6579 },
 { 198,6579 }, { 199,6579 }, { 200,6579 }, { 201,6579 }, { 202,6579 },
 { 203,6579 }, { 204,6579 }, { 205,6579 }, { 206,6579 }, { 207,6579 },
 { 208,6579 }, { 209,6579 }, { 210,6579 }, { 211,6579 }, { 212,6579 },
 { 213,6579 }, { 214,6579 }, { 215,6579 }, { 216,6579 }, { 217,6579 },
 { 218,6579 }, { 219,6579 }, { 220,6579 }, { 221,6579 }, { 222,6579 },
 { 223,6579 }, { 224,6579 }, { 225,6579 }, { 226,6579 }, { 227,6579 },
 { 228,6579 }, { 229,6579 }, { 230,6579 }, { 231,6579 }, { 232,6579 },

 { 233,6579 }, { 234,6579 }, { 235,6579 }, { 236,6579 }, { 237,6579 },
 { 238,6579 }, { 239,6579 }, { 240,6579 }, { 241,6579 }, { 242,6579 },
 { 243,6579 }, { 244,6579 }, { 245,6579 }, { 246,6579 }, { 247,6579 },
 { 248,6579 }, { 249,6579 }, { 250,6579 }, { 251,6579 }, { 252,6579 },
 { 253,6579 }, { 254,6579 }, { 255,6579 }, {   0,  66 }, {   0,11752 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,6322 }, {   0,   0 }, {   0,   0 }, {  39,-992 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6322 }, {  49,6322 }, {  50,6322 },
 {  51,6322 }, {  52,6322 }, {  53,6322 }, {  54,6322 }, {  55,6322 },
 {  56,6322 }, {  57,6322 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6322 },
 {  66,6322 }, {  67,6322 }, {  68,6322 }, {  69,6322 }, {  70,6322 },
 {  71,6322 }, {  72,6322 }, {  73,6322 }, {  74,6322 }, {  75,6322 },

 {  76,6322 }, {  77,6322 }, {  78,6322 }, {  79,6322 }, {  80,6322 },
 {  81,6322 }, {  82,6322 }, {  83,6322 }, {  84,6322 }, {  85,6322 },
 {  86,6322 }, {  87,6322 }, {  88,6322 }, {  89,6322 }, {  90,6322 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6322 },
 {   0,   0 }, {  97,6322 }, {  98,6322 }, {  99,6322 }, { 100,6322 },
 { 101,6322 }, { 102,6322 }, { 103,6322 }, { 104,6322 }, { 105,6322 },
 { 106,6322 }, { 107,6322 }, { 108,6322 }, { 109,6322 }, { 110,6322 },
 { 111,6322 }, { 112,6322 }, { 113,6322 }, { 114,6322 }, { 115,6322 },
 { 116,6322 }, { 117,6322 }, { 118,6322 }, { 119,6322 }, { 120,6322 },
 { 121,6322 }, { 122,6322 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,6322 }, { 129,6322 }, { 130,6322 },
 { 131,6322 }, { 132,6322 }, { 133,6322 }, { 134,6322 }, { 135,6322 },
 { 136,6322 }, { 137,6322 }, { 138,6322 }, { 139,6322 }, { 140,6322 },
 { 141,6322 }, { 142,6322 }, { 143,6322 }, { 144,6322 }, { 145,6322 },
 { 146,6322 }, { 147,6322 }, { 148,6322 }, { 149,6322 }, { 150,6322 },
 { 151,6322 }, { 152,6322 }, { 153,6322 }, { 154,6322 }, { 155,6322 },
 { 156,6322 }, { 157,6322 }, { 158,6322 }, { 159,6322 }, { 160,6322 },
 { 161,6322 }, { 162,6322 }, { 163,6322 }, { 164,6322 }, { 165,6322 },
 { 166,6322 }, { 167,6322 }, { 168,6322 }, { 169,6322 }, { 170,6322 },
 { 171,6322 }, { 172,6322 }, { 173,6322 }, { 174,6322 }, { 175,6322 },

 { 176,6322 }, { 177,6322 }, { 178,6322 }, { 179,6322 }, { 180,6322 },
 { 181,6322 }, { 182,6322 }, { 183,6322 }, { 184,6322 }, { 185,6322 },
 { 186,6322 }, { 187,6322 }, { 188,6322 }, { 189,6322 }, { 190,6322 },
 { 191,6322 }, { 192,6322 }, { 193,6322 }, { 194,6322 }, { 195,6322 },
 { 196,6322 }, { 197,6322 }, { 198,6322 }, { 199,6322 }, { 200,6322 },
 { 201,6322 }, { 202,6322 }, { 203,6322 }, { 204,6322 }, { 205,6322 },
 { 206,6322 }, { 207,6322 }, { 208,6322 }, { 209,6322 }, { 210,6322 },
 { 211,6322 }, { 212,6322 }, { 213,6322 }, { 214,6322 }, { 215,6322 },
 { 216,6322 }, { 217,6322 }, { 218,6322 }, { 219,6322 }, { 220,6322 },
 { 221,6322 }, { 222,6322 }, { 223,6322 }, { 224,6322 }, { 225,6322 },

 { 226,6322 }, { 227,6322 }, { 228,6322 }, { 229,6322 }, { 230,6322 },
 { 231,6322 }, { 232,6322 }, { 233,6322 }, { 234,6322 }, { 235,6322 },
 { 236,6322 }, { 237,6322 }, { 238,6322 }, { 239,6322 }, { 240,6322 },
 { 241,6322 }, { 242,6322 }, { 243,6322 }, { 244,6322 }, { 245,6322 },
 { 246,6322 }, { 247,6322 }, { 248,6322 }, { 249,6322 }, { 250,6322 },
 { 251,6322 }, { 252,6322 }, { 253,6322 }, { 254,6322 }, { 255,6322 },
 {   0,  66 }, {   0,11495 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,6065 }, {   0,   0 }, {   0,   0 },
 {  39,-1247 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6065 },
 {  49,6065 }, {  50,6065 }, {  51,6065 }, {  52,6065 }, {  53,6065 },
 {  54,6065 }, {  55,6065 }, {  56,6065 }, {  57,6065 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6065 }, {  66,6065 }, {  67,6065 }, {  68,6065 },

 {  69,6065 }, {  70,6065 }, {  71,6065 }, {  72,6065 }, {  73,6065 },
 {  74,6065 }, {  75,6065 }, {  76,6065 }, {  77,6065 }, {  78,6065 },
 {  79,6065 }, {  80,6065 }, {  81,6065 }, {  82,6065 }, {  83,6065 },
 {  84,6065 }, {  85,6065 }, {  86,6065 }, {  87,6065 }, {  88,6065 },
 {  89,6065 }, {  90,6065 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,6065 }, {   0,   0 }, {  97,6065 }, {  98,6065 },
 {  99,6065 }, { 100,6065 }, { 101,6065 }, { 102,6065 }, { 103,6065 },
 { 104,6065 }, { 105,6065 }, { 106,6065 }, { 107,6065 }, { 108,6065 },
 { 109,6065 }, { 110,6065 }, { 111,6065 }, { 112,6065 }, { 113,6065 },
 { 114,6065 }, { 115,6065 }, { 116,6065 }, { 117,6065 }, { 118,6065 },

 { 119,6065 }, { 120,6065 }, { 121,6065 }, { 122,6065 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6065 },
 { 129,6065 }, { 130,6065 }, { 131,6065 }, { 132,6065 }, { 133,6065 },
 { 134,6065 }, { 135,6065 }, { 136,6065 }, { 137,6065 }, { 138,6065 },
 { 139,6065 }, { 140,6065 }, { 141,6065 }, { 142,6065 }, { 143,6065 },
 { 144,6065 }, { 145,6065 }, { 146,6065 }, { 147,6065 }, { 148,6065 },
 { 149,6065 }, { 150,6065 }, { 151,6065 }, { 152,6065 }, { 153,6065 },
 { 154,6065 }, { 155,6065 }, { 156,6065 }, { 157,6065 }, { 158,6065 },
 { 159,6065 }, { 160,6065 }, { 161,6065 }, { 162,6065 }, { 163,6065 },
 { 164,6065 }, { 165,6065 }, { 166,6065 }, { 167,6065 }, { 168,6065 },

 { 169,6065 }, { 170,6065 }, { 171,6065 }, { 172,6065 }, { 173,6065 },
 { 174,6065 }, { 175,6065 }, { 176,6065 }, { 177,6065 }, { 178,6065 },
 { 179,6065 }, { 180,6065 }, { 181,6065 }, { 182,6065 }, { 183,6065 },
 { 184,6065 }, { 185,6065 }, { 186,6065 }, { 187,6065 }, { 188,6065 },
 { 189,6065 }, { 190,6065 }, { 191,6065 }, { 192,6065 }, { 193,6065 },
 { 194,6065 }, { 195,6065 }, { 196,6065 }, { 197,6065 }, { 198,6065 },
 { 199,6065 }, { 200,6065 }, { 201,6065 }, { 202,6065 }, { 203,6065 },
 { 204,6065 }, { 205,6065 }, { 206,6065 }, { 207,6065 }, { 208,6065 },
 { 209,6065 }, { 210,6065 }, { 211,6065 }, { 212,6065 }, { 213,6065 },
 { 214,6065 }, { 215,6065 }, { 216,6065 }, { 217,6065 }, { 218,6065 },

 { 219,6065 }, { 220,6065 }, { 221,6065 }, { 222,6065 }, { 223,6065 },
 { 224,6065 }, { 225,6065 }, { 226,6065 }, { 227,6065 }, { 228,6065 },
 { 229,6065 }, { 230,6065 }, { 231,6065 }, { 232,6065 }, { 233,6065 },
 { 234,6065 }, { 235,6065 }, { 236,6065 }, { 237,6065 }, { 238,6065 },
 { 239,6065 }, { 240,6065 }, { 241,6065 }, { 242,6065 }, { 243,6065 },
 { 244,6065 }, { 245,6065 }, { 246,6065 }, { 247,6065 }, { 248,6065 },
 { 249,6065 }, { 250,6065 }, { 251,6065 }, { 252,6065 }, { 253,6065 },
 { 254,6065 }, { 255,6065 }, {   0,  66 }, {   0,11238 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5808 },
 {   0,   0 }, {   0,   0 }, {  39,-1502 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,5808 }, {  49,5808 }, {  50,5808 }, {  51,5808 },
 {  52,5808 }, {  53,5808 }, {  54,5808 }, {  55,5808 }, {  56,5808 },
 {  57,5808 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5808 }, {  66,5808 },
 {  67,5808 }, {  68,5808 }, {  69,5808 }, {  70,5808 }, {  71,5808 },
 {  72,5808 }, {  73,5808 }, {  74,5808 }, {  75,5808 }, {  76,5808 },
 {  77,5808 }, {  78,5808 }, {  79,5808 }, {  80,5808 }, {  81,5808 },
 {  82,5808 }, {  83,5808 }, {  84,5808 }, {  85,5808 }, {  86,5808 },
 {  87,5808 }, {  88,5808 }, {  89,5808 }, {  90,5808 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5808 }, {   0,   0 },
 {  97,5808 }, {  98,5808 }, {  99,5808 }, { 100,5808 }, { 101,5808 },
 { 102,5808 }, { 103,5808 }, { 104,5808 }, { 105,5808 }, { 106,5808 },
 { 107,5808 }, { 108,5808 }, { 109,5808 }, { 110,5808 }, { 111,5808 },

 { 112,5808 }, { 113,5808 }, { 114,5808 }, { 115,5808 }, { 116,5808 },
 { 117,5808 }, { 118,5808 }, { 119,5808 }, { 120,5808 }, { 121,5808 },
 { 122,5808 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,5808 }, { 129,5808 }, { 130,5808 }, { 131,5808 },
 { 132,5808 }, { 133,5808 }, { 134,5808 }, { 135,5808 }, { 136,5808 },
 { 137,5808 }, { 138,5808 }, { 139,5808 }, { 140,5808 }, { 141,5808 },
 { 142,5808 }, { 143,5808 }, { 144,5808 }, { 145,5808 }, { 146,5808 },
 { 147,5808 }, { 148,5808 }, { 149,5808 }, { 150,5808 }, { 151,5808 },
 { 152,5808 }, { 153,5808 }, { 154,5808 }, { 155,5808 }, { 156,5808 },
 { 157,5808 }, { 158,5808 }, { 159,5808 }, { 160,5808 }, { 161,5808 },

 { 162,5808 }, { 163,5808 }, { 164,5808 }, { 165,5808 }, { 166,5808 },
 { 167,5808 }, { 168,5808 }, { 169,5808 }, { 170,5808 }, { 171,5808 },
 { 172,5808 }, { 173,5808 }, { 174,5808 }, { 175,5808 }, { 176,5808 },
 { 177,5808 }, { 178,5808 }, { 179,5808 }, { 180,5808 }, { 181,5808 },
 { 182,5808 }, { 183,5808 }, { 184,5808 }, { 185,5808 }, { 186,5808 },
 { 187,5808 }, { 188,5808 }, { 189,5808 }, { 190,5808 }, { 191,5808 },
 { 192,5808 }, { 193,5808 }, { 194,5808 }, { 195,5808 }, { 196,5808 },
 { 197,5808 }, { 198,5808 }, { 199,5808 }, { 200,5808 }, { 201,5808 },
 { 202,5808 }, { 203,5808 }, { 204,5808 }, { 205,5808 }, { 206,5808 },
 { 207,5808 }, { 208,5808 }, { 209,5808 }, { 210,5808 }, { 211,5808 },

 { 212,5808 }, { 213,5808 }, { 214,5808 }, { 215,5808 }, { 216,5808 },
 { 217,5808 }, { 218,5808 }, { 219,5808 }, { 220,5808 }, { 221,5808 },
 { 222,5808 }, { 223,5808 }, { 224,5808 }, { 225,5808 }, { 226,5808 },
 { 227,5808 }, { 228,5808 }, { 229,5808 }, { 230,5808 }, { 231,5808 },
 { 232,5808 }, { 233,5808 }, { 234,5808 }, { 235,5808 }, { 236,5808 },
 { 237,5808 }, { 238,5808 }, { 239,5808 }, { 240,5808 }, { 241,5808 },
 { 242,5808 }, { 243,5808 }, { 244,5808 }, { 245,5808 }, { 246,5808 },
 { 247,5808 }, { 248,5808 }, { 249,5808 }, { 250,5808 }, { 251,5808 },
 { 252,5808 }, { 253,5808 }, { 254,5808 }, { 255,5808 }, {   0,  66 },
 {   0,10981 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,5551 }, {   0,   0 }, {  38,-1526 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5551 }, {  49,5551 },
 {  50,5551 }, {  51,5551 }, {  52,5551 }, {  53,5551 }, {  54,5551 },

 {  55,5551 }, {  56,5551 }, {  57,5551 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5551 }, {  66,5551 }, {  67,5551 }, {  68,5551 }, {  69,5551 },
 {  70,5551 }, {  71,5551 }, {  72,5551 }, {  73,5551 }, {  74,5551 },
 {  75,5551 }, {  76,5551 }, {  77,5551 }, {  78,5551 }, {  79,5551 },
 {  80,5551 }, {  81,5551 }, {  82,5551 }, {  83,5551 }, {  84,5551 },
 {  85,5551 }, {  86,5551 }, {  87,5551 }, {  88,5551 }, {  89,5551 },
 {  90,5551 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5551 }, {   0,   0 }, {  97,5551 }, {  98,5551 }, {  99,5551 },
 { 100,5551 }, { 101,5551 }, { 102,5551 }, { 103,5551 }, { 104,5551 },

 { 105,5551 }, { 106,5551 }, { 107,5551 }, { 108,5551 }, { 109,5551 },
 { 110,5551 }, { 111,5551 }, { 112,5551 }, { 113,5551 }, { 114,5551 },
 { 115,5551 }, { 116,5551 }, { 117,5551 }, { 118,5551 }, { 119,5551 },
 { 120,5551 }, { 121,5551 }, { 122,5551 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5551 }, { 129,5551 },
 { 130,5551 }, { 131,5551 }, { 132,5551 }, { 133,5551 }, { 134,5551 },
 { 135,5551 }, { 136,5551 }, { 137,5551 }, { 138,5551 }, { 139,5551 },
 { 140,5551 }, { 141,5551 }, { 142,5551 }, { 143,5551 }, { 144,5551 },
 { 145,5551 }, { 146,5551 }, { 147,5551 }, { 148,5551 }, { 149,5551 },
 { 150,5551 }, { 151,5551 }, { 152,5551 }, { 153,5551 }, { 154,5551 },

 { 155,5551 }, { 156,5551 }, { 157,5551 }, { 158,5551 }, { 159,5551 },
 { 160,5551 }, { 161,5551 }, { 162,5551 }, { 163,5551 }, { 164,5551 },
 { 165,5551 }, { 166,5551 }, { 167,5551 }, { 168,5551 }, { 169,5551 },
 { 170,5551 }, { 171,5551 }, { 172,5551 }, { 173,5551 }, { 174,5551 },
 { 175,5551 }, { 176,5551 }, { 177,5551 }, { 178,5551 }, { 179,5551 },
 { 180,5551 }, { 181,5551 }, { 182,5551 }, { 183,5551 }, { 184,5551 },
 { 185,5551 }, { 186,5551 }, { 187,5551 }, { 188,5551 }, { 189,5551 },
 { 190,5551 }, { 191,5551 }, { 192,5551 }, { 193,5551 }, { 194,5551 },
 { 195,5551 }, { 196,5551 }, { 197,5551 }, { 198,5551 }, { 199,5551 },
 { 200,5551 }, { 201,5551 }, { 202,5551 }, { 203,5551 }, { 204,5551 },

 { 205,5551 }, { 206,5551 }, { 207,5551 }, { 208,5551 }, { 209,5551 },
 { 210,5551 }, { 211,5551 }, { 212,5551 }, { 213,5551 }, { 214,5551 },
 { 215,5551 }, { 216,5551 }, { 217,5551 }, { 218,5551 }, { 219,5551 },
 { 220,5551 }, { 221,5551 }, { 222,5551 }, { 223,5551 }, { 224,5551 },
 { 225,5551 }, { 226,5551 }, { 227,5551 }, { 228,5551 }, { 229,5551 },
 { 230,5551 }, { 231,5551 }, { 232,5551 }, { 233,5551 }, { 234,5551 },
 { 235,5551 }, { 236,5551 }, { 237,5551 }, { 238,5551 }, { 239,5551 },
 { 240,5551 }, { 241,5551 }, { 242,5551 }, { 243,5551 }, { 244,5551 },
 { 245,5551 }, { 246,5551 }, { 247,5551 }, { 248,5551 }, { 249,5551 },
 { 250,5551 }, { 251,5551 }, { 252,5551 }, { 253,5551 }, { 254,5551 },

 { 255,5551 }, {   0,  66 }, {   0,10724 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5294 }, {   0,   0 },
 {   0,   0 }, {  39,-1781 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,5294 }, {  49,5294 }, {  50,5294 }, {  51,5294 }, {  52,5294 },
 {  53,5294 }, {  54,5294 }, {  55,5294 }, {  56,5294 }, {  57,5294 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5294 }, {  66,5294 }, {  67,5294 },
 {  68,5294 }, {  69,5294 }, {  70,5294 }, {  71,5294 }, {  72,5294 },
 {  73,5294 }, {  74,5294 }, {  75,5294 }, {  76,5294 }, {  77,5294 },
 {  78,5294 }, {  79,5294 }, {  80,5294 }, {  81,5294 }, {  82,5294 },
 {  83,5294 }, {  84,5294 }, {  85,5294 }, {  86,5294 }, {  87,5294 },
 {  88,5294 }, {  89,5294 }, {  90,5294 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5294 }, {   0,   0 }, {  97,5294 },

 {  98,5294 }, {  99,5294 }, { 100,5294 }, { 101,5294 }, { 102,5294 },
 { 103,5294 }, { 104,5294 }, { 105,5294 }, { 106,5294 }, { 107,5294 },
 { 108,5294 }, { 109,5294 }, { 110,5294 }, { 111,5294 }, { 112,5294 },
 { 113,5294 }, { 114,5294 }, { 115,5294 }, { 116,5294 }, { 117,5294 },
 { 118,5294 }, { 119,5294 }, { 120,5294 }, { 121,5294 }, { 122,5294 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5294 }, { 129,5294 }, { 130,5294 }, { 131,5294 }, { 132,5294 },
 { 133,5294 }, { 134,5294 }, { 135,5294 }, { 136,5294 }, { 137,5294 },
 { 138,5294 }, { 139,5294 }, { 140,5294 }, { 141,5294 }, { 142,5294 },
 { 143,5294 }, { 144,5294 }, { 145,5294 }, { 146,5294 }, { 147,5294 },

 { 148,5294 }, { 149,5294 }, { 150,5294 }, { 151,5294 }, { 152,5294 },
 { 153,5294 }, { 154,5294 }, { 155,5294 }, { 156,5294 }, { 157,5294 },
 { 158,5294 }, { 159,5294 }, { 160,5294 }, { 161,5294 }, { 162,5294 },
 { 163,5294 }, { 164,5294 }, { 165,5294 }, { 166,5294 }, { 167,5294 },
 { 168,5294 }, { 169,5294 }, { 170,5294 }, { 171,5294 }, { 172,5294 },
 { 173,5294 }, { 174,5294 }, { 175,5294 }, { 176,5294 }, { 177,5294 },
 { 178,5294 }, { 179,5294 }, { 180,5294 }, { 181,5294 }, { 182,5294 },
 { 183,5294 }, { 184,5294 }, { 185,5294 }, { 186,5294 }, { 187,5294 },
 { 188,5294 }, { 189,5294 }, { 190,5294 }, { 191,5294 }, { 192,5294 },
 { 193,5294 }, { 194,5294 }, { 195,5294 }, { 196,5294 }, { 197,5294 },

 { 198,5294 }, { 199,5294 }, { 200,5294 }, { 201,5294 }, { 202,5294 },
 { 203,5294 }, { 204,5294 }, { 205,5294 }, { 206,5294 }, { 207,5294 },
 { 208,5294 }, { 209,5294 }, { 210,5294 }, { 211,5294 }, { 212,5294 },
 { 213,5294 }, { 214,5294 }, { 215,5294 }, { 216,5294 }, { 217,5294 },
 { 218,5294 }, { 219,5294 }, { 220,5294 }, { 221,5294 }, { 222,5294 },
 { 223,5294 }, { 224,5294 }, { 225,5294 }, { 226,5294 }, { 227,5294 },
 { 228,5294 }, { 229,5294 }, { 230,5294 }, { 231,5294 }, { 232,5294 },
 { 233,5294 }, { 234,5294 }, { 235,5294 }, { 236,5294 }, { 237,5294 },
 { 238,5294 }, { 239,5294 }, { 240,5294 }, { 241,5294 }, { 242,5294 },
 { 243,5294 }, { 244,5294 }, { 245,5294 }, { 246,5294 }, { 247,5294 },

 { 248,5294 }, { 249,5294 }, { 250,5294 }, { 251,5294 }, { 252,5294 },
 { 253,5294 }, { 254,5294 }, { 255,5294 }, {   0,  11 }, {   0,10467 },
 {   1,5294 }, {   2,5294 }, {   3,5294 }, {   4,5294 }, {   5,5294 },
 {   6,5294 }, {   7,5294 }, {   8,5294 }, {   9,5294 }, {  10,5294 },
 {  11,5294 }, {  12,5294 }, {  13,5294 }, {  14,5294 }, {  15,5294 },
 {  16,5294 }, {  17,5294 }, {  18,5294 }, {  19,5294 }, {  20,5294 },
 {  21,5294 }, {  22,5294 }, {  23,5294 }, {  24,5294 }, {  25,5294 },
 {  26,5294 }, {  27,5294 }, {  28,5294 }, {  29,5294 }, {  30,5294 },
 {  31,5294 }, {  32,5294 }, {  33,5294 }, {  34,5294 }, {  35,5294 },
 {  36,5294 }, {  37,5294 }, {  38,5294 }, {   0,   0 }, {  40,5294 },

 {  41,5294 }, {  42,5294 }, {  43,5294 }, {  44,5294 }, {  45,5294 },
 {  46,5294 }, {  47,5294 }, {  48,5294 }, {  49,5294 }, {  50,5294 },
 {  51,5294 }, {  52,5294 }, {  53,5294 }, {  54,5294 }, {  55,5294 },
 {  56,5294 }, {  57,5294 }, {  58,5294 }, {  59,5294 }, {  60,5294 },
 {  61,5294 }, {  62,5294 }, {  63,5294 }, {  64,5294 }, {  65,5294 },
 {  66,5294 }, {  67,5294 }, {  68,5294 }, {  69,5294 }, {  70,5294 },
 {  71,5294 }, {  72,5294 }, {  73,5294 }, {  74,5294 }, {  75,5294 },
 {  76,5294 }, {  77,5294 }, {  78,5294 }, {  79,5294 }, {  80,5294 },
 {  81,5294 }, {  82,5294 }, {  83,5294 }, {  84,5294 }, {  85,5294 },
 {  86,5294 }, {  87,5294 }, {  88,5294 }, {  89,5294 }, {  90,5294 },

 {  91,5294 }, {  92,5294 }, {  93,5294 }, {  94,5294 }, {  95,5294 },
 {  96,5294 }, {  97,5294 }, {  98,5294 }, {  99,5294 }, { 100,5294 },
 { 101,5294 }, { 102,5294 }, { 103,5294 }, { 104,5294 }, { 105,5294 },
 { 106,5294 }, { 107,5294 }, { 108,5294 }, { 109,5294 }, { 110,5294 },
 { 111,5294 }, { 112,5294 }, { 113,5294 }, { 114,5294 }, { 115,5294 },
 { 116,5294 }, { 117,5294 }, { 118,5294 }, { 119,5294 }, { 120,5294 },
 { 121,5294 }, { 122,5294 }, { 123,5294 }, { 124,5294 }, { 125,5294 },
 { 126,5294 }, { 127,5294 }, { 128,5294 }, { 129,5294 }, { 130,5294 },
 { 131,5294 }, { 132,5294 }, { 133,5294 }, { 134,5294 }, { 135,5294 },
 { 136,5294 }, { 137,5294 }, { 138,5294 }, { 139,5294 }, { 140,5294 },

 { 141,5294 }, { 142,5294 }, { 143,5294 }, { 144,5294 }, { 145,5294 },
 { 146,5294 }, { 147,5294 }, { 148,5294 }, { 149,5294 }, { 150,5294 },
 { 151,5294 }, { 152,5294 }, { 153,5294 }, { 154,5294 }, { 155,5294 },
 { 156,5294 }, { 157,5294 }, { 158,5294 }, { 159,5294 }, { 160,5294 },
 { 161,5294 }, { 162,5294 }, { 163,5294 }, { 164,5294 }, { 165,5294 },
 { 166,5294 }, { 167,5294 }, { 168,5294 }, { 169,5294 }, { 170,5294 },
 { 171,5294 }, { 172,5294 }, { 173,5294 }, { 174,5294 }, { 175,5294 },
 { 176,5294 }, { 177,5294 }, { 178,5294 }, { 179,5294 }, { 180,5294 },
 { 181,5294 }, { 182,5294 }, { 183,5294 }, { 184,5294 }, { 185,5294 },
 { 186,5294 }, { 187,5294 }, { 188,5294 }, { 189,5294 }, { 190,5294 },

 { 191,5294 }, { 192,5294 }, { 193,5294 }, { 194,5294 }, { 195,5294 },
 { 196,5294 }, { 197,5294 }, { 198,5294 }, { 199,5294 }, { 200,5294 },
 { 201,5294 }, { 202,5294 }, { 203,5294 }, { 204,5294 }, { 205,5294 },
 { 206,5294 }, { 207,5294 }, { 208,5294 }, { 209,5294 }, { 210,5294 },
 { 211,5294 }, { 212,5294 }, { 213,5294 }, { 214,5294 }, { 215,5294 },
 { 216,5294 }, { 217,5294 }, { 218,5294 }, { 219,5294 }, { 220,5294 },
 { 221,5294 }, { 222,5294 }, { 223,5294 }, { 224,5294 }, { 225,5294 },
 { 226,5294 }, { 227,5294 }, { 228,5294 }, { 229,5294 }, { 230,5294 },
 { 231,5294 }, { 232,5294 }, { 233,5294 }, { 234,5294 }, { 235,5294 },
 { 236,5294 }, { 237,5294 }, { 238,5294 }, { 239,5294 }, { 240,5294 },

 { 241,5294 }, { 242,5294 }, { 243,5294 }, { 244,5294 }, { 245,5294 },
 { 246,5294 }, { 247,5294 }, { 248,5294 }, { 249,5294 }, { 250,5294 },
 { 251,5294 }, { 252,5294 }, { 253,5294 }, { 254,5294 }, { 255,5294 },
 { 256,5294 }, {   0,   6 }, {   0,10209 }, {   1,5294 }, {   2,5294 },
 {   3,5294 }, {   4,5294 }, {   5,5294 }, {   6,5294 }, {   7,5294 },
 {   8,5294 }, {   9,5294 }, {  10,5294 }, {  11,5294 }, {  12,5294 },
 {  13,5294 }, {  14,5294 }, {  15,5294 }, {  16,5294 }, {  17,5294 },
 {  18,5294 }, {  19,5294 }, {  20,5294 }, {  21,5294 }, {  22,5294 },
 {  23,5294 }, {  24,5294 }, {  25,5294 }, {  26,5294 }, {  27,5294 },
 {  28,5294 }, {  29,5294 }, {  30,5294 }, {  31,5294 }, {  32,5294 },

 {  33,5294 }, {  34,5294 }, {  35,5294 }, {  36,5294 }, {  37,5294 },
 {  38,5294 }, {  39,5294 }, {  40,5294 }, {  41,5294 }, {   0,   0 },
 {  43,5294 }, {  44,5294 }, {  45,5294 }, {  46,5294 }, {   0,   0 },
 {  48,5294 }, {  49,5294 }, {  50,5294 }, {  51,5294 }, {  52,5294 },
 {  53,5294 }, {  54,5294 }, {  55,5294 }, {  56,5294 }, {  57,5294 },
 {  58,5294 }, {  59,5294 }, {  60,5294 }, {  61,5294 }, {  62,5294 },
 {  63,5294 }, {  64,5294 }, {  65,5294 }, {  66,5294 }, {  67,5294 },
 {  68,5294 }, {  69,5294 }, {  70,5294 }, {  71,5294 }, {  72,5294 },
 {  73,5294 }, {  74,5294 }, {  75,5294 }, {  76,5294 }, {  77,5294 },
 {  78,5294 }, {  79,5294 }, {  80,5294 }, {  81,5294 }, {  82,5294 },

 {  83,5294 }, {  84,5294 }, {  85,5294 }, {  86,5294 }, {  87,5294 },
 {  88,5294 }, {  89,5294 }, {  90,5294 }, {  91,5294 }, {  92,5294 },
 {  93,5294 }, {  94,5294 }, {  95,5294 }, {  96,5294 }, {  97,5294 },
 {  98,5294 }, {  99,5294 }, { 100,5294 }, { 101,5294 }, { 102,5294 },
 { 103,5294 }, { 104,5294 }, { 105,5294 }, { 106,5294 }, { 107,5294 },
 { 108,5294 }, { 109,5294 }, { 110,5294 }, { 111,5294 }, { 112,5294 },
 { 113,5294 }, { 114,5294 }, { 115,5294 }, { 116,5294 }, { 117,5294 },
 { 118,5294 }, { 119,5294 }, { 120,5294 }, { 121,5294 }, { 122,5294 },
 { 123,5294 }, { 124,5294 }, { 125,5294 }, { 126,5294 }, { 127,5294 },
 { 128,5294 }, { 129,5294 }, { 130,5294 }, { 131,5294 }, { 132,5294 },

 { 133,5294 }, { 134,5294 }, { 135,5294 }, { 136,5294 }, { 137,5294 },
 { 138,5294 }, { 139,5294 }, { 140,5294 }, { 141,5294 }, { 142,5294 },
 { 143,5294 }, { 144,5294 }, { 145,5294 }, { 146,5294 }, { 147,5294 },
 { 148,5294 }, { 149,5294 }, { 150,5294 }, { 151,5294 }, { 152,5294 },
 { 153,5294 }, { 154,5294 }, { 155,5294 }, { 156,5294 }, { 157,5294 },
 { 158,5294 }, { 159,5294 }, { 160,5294 }, { 161,5294 }, { 162,5294 },
 { 163,5294 }, { 164,5294 }, { 165,5294 }, { 166,5294 }, { 167,5294 },
 { 168,5294 }, { 169,5294 }, { 170,5294 }, { 171,5294 }, { 172,5294 },
 { 173,5294 }, { 174,5294 }, { 175,5294 }, { 176,5294 }, { 177,5294 },
 { 178,5294 }, { 179,5294 }, { 180,5294 }, { 181,5294 }, { 182,5294 },

 { 183,5294 }, { 184,5294 }, { 185,5294 }, { 186,5294 }, { 187,5294 },
 { 188,5294 }, { 189,5294 }, { 190,5294 }, { 191,5294 }, { 192,5294 },
 { 193,5294 }, { 194,5294 }, { 195,5294 }, { 196,5294 }, { 197,5294 },
 { 198,5294 }, { 199,5294 }, { 200,5294 }, { 201,5294 }, { 202,5294 },
 { 203,5294 }, { 204,5294 }, { 205,5294 }, { 206,5294 }, { 207,5294 },
 { 208,5294 }, { 209,5294 }, { 210,5294 }, { 211,5294 }, { 212,5294 },
 { 213,5294 }, { 214,5294 }, { 215,5294 }, { 216,5294 }, { 217,5294 },
 { 218,5294 }, { 219,5294 }, { 220,5294 }, { 221,5294 }, { 222,5294 },
 { 223,5294 }, { 224,5294 }, { 225,5294 }, { 226,5294 }, { 227,5294 },
 { 228,5294 }, { 229,5294 }, { 230,5294 }, { 231,5294 }, { 232,5294 },

 { 233,5294 }, { 234,5294 }, { 235,5294 }, { 236,5294 }, { 237,5294 },
 { 238,5294 }, { 239,5294 }, { 240,5294 }, { 241,5294 }, { 242,5294 },
 { 243,5294 }, { 244,5294 }, { 245,5294 }, { 246,5294 }, { 247,5294 },
 { 248,5294 }, { 249,5294 }, { 250,5294 }, { 251,5294 }, { 252,5294 },
 { 253,5294 }, { 254,5294 }, { 255,5294 }, { 256,5294 }, {   0,   6 },
 {   0,9951 }, {   1,5036 }, {   2,5036 }, {   3,5036 }, {   4,5036 },
 {   5,5036 }, {   6,5036 }, {   7,5036 }, {   8,5036 }, {   9,5036 },
 {  10,5036 }, {  11,5036 }, {  12,5036 }, {  13,5036 }, {  14,5036 },
 {  15,5036 }, {  16,5036 }, {  17,5036 }, {  18,5036 }, {  19,5036 },
 {  20,5036 }, {  21,5036 }, {  22,5036 }, {  23,5036 }, {  24,5036 },

 {  25,5036 }, {  26,5036 }, {  27,5036 }, {  28,5036 }, {  29,5036 },
 {  30,5036 }, {  31,5036 }, {  32,5036 }, {  33,5036 }, {  34,5036 },
 {  35,5036 }, {  36,5036 }, {  37,5036 }, {  38,5036 }, {  39,5036 },
 {  40,5036 }, {  41,5036 }, {   0,   0 }, {  43,5036 }, {  44,5036 },
 {  45,5036 }, {  46,5036 }, {   0,   0 }, {  48,5036 }, {  49,5036 },
 {  50,5036 }, {  51,5036 }, {  52,5036 }, {  53,5036 }, {  54,5036 },
 {  55,5036 }, {  56,5036 }, {  57,5036 }, {  58,5036 }, {  59,5036 },
 {  60,5036 }, {  61,5036 }, {  62,5036 }, {  63,5036 }, {  64,5036 },
 {  65,5036 }, {  66,5036 }, {  67,5036 }, {  68,5036 }, {  69,5036 },
 {  70,5036 }, {  71,5036 }, {  72,5036 }, {  73,5036 }, {  74,5036 },

 {  75,5036 }, {  76,5036 }, {  77,5036 }, {  78,5036 }, {  79,5036 },
 {  80,5036 }, {  81,5036 }, {  82,5036 }, {  83,5036 }, {  84,5036 },
 {  85,5036 }, {  86,5036 }, {  87,5036 }, {  88,5036 }, {  89,5036 },
 {  90,5036 }, {  91,5036 }, {  92,5036 }, {  93,5036 }, {  94,5036 },
 {  95,5036 }, {  96,5036 }, {  97,5036 }, {  98,5036 }, {  99,5036 },
 { 100,5036 }, { 101,5036 }, { 102,5036 }, { 103,5036 }, { 104,5036 },
 { 105,5036 }, { 106,5036 }, { 107,5036 }, { 108,5036 }, { 109,5036 },
 { 110,5036 }, { 111,5036 }, { 112,5036 }, { 113,5036 }, { 114,5036 },
 { 115,5036 }, { 116,5036 }, { 117,5036 }, { 118,5036 }, { 119,5036 },
 { 120,5036 }, { 121,5036 }, { 122,5036 }, { 123,5036 }, { 124,5036 },

 { 125,5036 }, { 126,5036 }, { 127,5036 }, { 128,5036 }, { 129,5036 },
 { 130,5036 }, { 131,5036 }, { 132,5036 }, { 133,5036 }, { 134,5036 },
 { 135,5036 }, { 136,5036 }, { 137,5036 }, { 138,5036 }, { 139,5036 },
 { 140,5036 }, { 141,5036 }, { 142,5036 }, { 143,5036 }, { 144,5036 },
 { 145,5036 }, { 146,5036 }, { 147,5036 }, { 148,5036 }, { 149,5036 },
 { 150,5036 }, { 151,5036 }, { 152,5036 }, { 153,5036 }, { 154,5036 },
 { 155,5036 }, { 156,5036 }, { 157,5036 }, { 158,5036 }, { 159,5036 },
 { 160,5036 }, { 161,5036 }, { 162,5036 }, { 163,5036 }, { 164,5036 },
 { 165,5036 }, { 166,5036 }, { 167,5036 }, { 168,5036 }, { 169,5036 },
 { 170,5036 }, { 171,5036 }, { 172,5036 }, { 173,5036 }, { 174,5036 },

 { 175,5036 }, { 176,5036 }, { 177,5036 }, { 178,5036 }, { 179,5036 },
 { 180,5036 }, { 181,5036 }, { 182,5036 }, { 183,5036 }, { 184,5036 },
 { 185,5036 }, { 186,5036 }, { 187,5036 }, { 188,5036 }, { 189,5036 },
 { 190,5036 }, { 191,5036 }, { 192,5036 }, { 193,5036 }, { 194,5036 },
 { 195,5036 }, { 196,5036 }, { 197,5036 }, { 198,5036 }, { 199,5036 },
 { 200,5036 }, { 201,5036 }, { 202,5036 }, { 203,5036 }, { 204,5036 },
 { 205,5036 }, { 206,5036 }, { 207,5036 }, { 208,5036 }, { 209,5036 },
 { 210,5036 }, { 211,5036 }, { 212,5036 }, { 213,5036 }, { 214,5036 },
 { 215,5036 }, { 216,5036 }, { 217,5036 }, { 218,5036 }, { 219,5036 },
 { 220,5036 }, { 221,5036 }, { 222,5036 }, { 223,5036 }, { 224,5036 },

 { 225,5036 }, { 226,5036 }, { 227,5036 }, { 228,5036 }, { 229,5036 },
 { 230,5036 }, { 231,5036 }, { 232,5036 }, { 233,5036 }, { 234,5036 },
 { 235,5036 }, { 236,5036 }, { 237,5036 }, { 238,5036 }, { 239,5036 },
 { 240,5036 }, { 241,5036 }, { 242,5036 }, { 243,5036 }, { 244,5036 },
 { 245,5036 }, { 246,5036 }, { 247,5036 }, { 248,5036 }, { 249,5036 },
 { 250,5036 }, { 251,5036 }, { 252,5036 }, { 253,5036 }, { 254,5036 },
 { 255,5036 }, { 256,5036 }, {   0,  44 }, {   0,9693 }, {   1,5164 },
 {   2,5164 }, {   3,5164 }, {   4,5164 }, {   5,5164 }, {   6,5164 },
 {   7,5164 }, {   8,5164 }, {   9,5164 }, {  10,5164 }, {  11,5164 },
 {  12,5164 }, {  13,5164 }, {  14,5164 }, {  15,5164 }, {  16,5164 },

 {  17,5164 }, {  18,5164 }, {  19,5164 }, {  20,5164 }, {  21,5164 },
 {  22,5164 }, {  23,5164 }, {  24,5164 }, {  25,5164 }, {  26,5164 },
 {  27,5164 }, {  28,5164 }, {  29,5164 }, {  30,5164 }, {  31,5164 },
 {  32,5164 }, {  33,5164 }, {   0,   0 }, {  35,5164 }, {  36,5164 },
 {  37,5164 }, {  38,5164 }, {  39,5164 }, {  40,5164 }, {  41,5164 },
 {  42,5164 }, {  43,5164 }, {  44,5164 }, {  45,5164 }, {  46,5164 },
 {  47,5164 }, {  48,5164 }, {  49,5164 }, {  50,5164 }, {  51,5164 },
 {  52,5164 }, {  53,5164 }, {  54,5164 }, {  55,5164 }, {  56,5164 },
 {  57,5164 }, {  58,5164 }, {  59,5164 }, {  60,5164 }, {  61,5164 },
 {  62,5164 }, {  63,5164 }, {  64,5164 }, {  65,5164 }, {  66,5164 },

 {  67,5164 }, {  68,5164 }, {  69,5164 }, {  70,5164 }, {  71,5164 },
 {  72,5164 }, {  73,5164 }, {  74,5164 }, {  75,5164 }, {  76,5164 },
 {  77,5164 }, {  78,5164 }, {  79,5164 }, {  80,5164 }, {  81,5164 },
 {  82,5164 }, {  83,5164 }, {  84,5164 }, {  85,5164 }, {  86,5164 },
 {  87,5164 }, {  88,5164 }, {  89,5164 }, {  90,5164 }, {  91,5164 },
 {  92,5164 }, {  93,5164 }, {  94,5164 }, {  95,5164 }, {  96,5164 },
 {  97,5164 }, {  98,5164 }, {  99,5164 }, { 100,5164 }, { 101,5164 },
 { 102,5164 }, { 103,5164 }, { 104,5164 }, { 105,5164 }, { 106,5164 },
 { 107,5164 }, { 108,5164 }, { 109,5164 }, { 110,5164 }, { 111,5164 },
 { 112,5164 }, { 113,5164 }, { 114,5164 }, { 115,5164 }, { 116,5164 },

 { 117,5164 }, { 118,5164 }, { 119,5164 }, { 120,5164 }, { 121,5164 },
 { 122,5164 }, { 123,5164 }, { 124,5164 }, { 125,5164 }, { 126,5164 },
 { 127,5164 }, { 128,5164 }, { 129,5164 }, { 130,5164 }, { 131,5164 },
 { 132,5164 }, { 133,5164 }, { 134,5164 }, { 135,5164 }, { 136,5164 },
 { 137,5164 }, { 138,5164 }, { 139,5164 }, { 140,5164 }, { 141,5164 },
 { 142,5164 }, { 143,5164 }, { 144,5164 }, { 145,5164 }, { 146,5164 },
 { 147,5164 }, { 148,5164 }, { 149,5164 }, { 150,5164 }, { 151,5164 },
 { 152,5164 }, { 153,5164 }, { 154,5164 }, { 155,5164 }, { 156,5164 },
 { 157,5164 }, { 158,5164 }, { 159,5164 }, { 160,5164 }, { 161,5164 },
 { 162,5164 }, { 163,5164 }, { 164,5164 }, { 165,5164 }, { 166,5164 },

 { 167,5164 }, { 168,5164 }, { 169,5164 }, { 170,5164 }, { 171,5164 },
 { 172,5164 }, { 173,5164 }, { 174,5164 }, { 175,5164 }, { 176,5164 },
 { 177,5164 }, { 178,5164 }, { 179,5164 }, { 180,5164 }, { 181,5164 },
 { 182,5164 }, { 183,5164 }, { 184,5164 }, { 185,5164 }, { 186,5164 },
 { 187,5164 }, { 188,5164 }, { 189,5164 }, { 190,5164 }, { 191,5164 },
 { 192,5164 }, { 193,5164 }, { 194,5164 }, { 195,5164 }, { 196,5164 },
 { 197,5164 }, { 198,5164 }, { 199,5164 }, { 200,5164 }, { 201,5164 },
 { 202,5164 }, { 203,5164 }, { 204,5164 }, { 205,5164 }, { 206,5164 },
 { 207,5164 }, { 208,5164 }, { 209,5164 }, { 210,5164 }, { 211,5164 },
 { 212,5164 }, { 213,5164 }, { 214,5164 }, { 215,5164 }, { 216,5164 },

 { 217,5164 }, { 218,5164 }, { 219,5164 }, { 220,5164 }, { 221,5164 },
 { 222,5164 }, { 223,5164 }, { 224,5164 }, { 225,5164 }, { 226,5164 },
 { 227,5164 }, { 228,5164 }, { 229,5164 }, { 230,5164 }, { 231,5164 },
 { 232,5164 }, { 233,5164 }, { 234,5164 }, { 235,5164 }, { 236,5164 },
 { 237,5164 }, { 238,5164 }, { 239,5164 }, { 240,5164 }, { 241,5164 },
 { 242,5164 }, { 243,5164 }, { 244,5164 }, { 245,5164 }, { 246,5164 },
 { 247,5164 }, { 248,5164 }, { 249,5164 }, { 250,5164 }, { 251,5164 },
 { 252,5164 }, { 253,5164 }, { 254,5164 }, { 255,5164 }, { 256,5164 },
 {   0,  10 }, {   0,9435 }, {   1,5164 }, {   2,5164 }, {   3,5164 },
 {   4,5164 }, {   5,5164 }, {   6,5164 }, {   7,5164 }, {   8,5164 },

 {   9,5164 }, {  10,5164 }, {  11,5164 }, {  12,5164 }, {  13,5164 },
 {  14,5164 }, {  15,5164 }, {  16,5164 }, {  17,5164 }, {  18,5164 },
 {  19,5164 }, {  20,5164 }, {  21,5164 }, {  22,5164 }, {  23,5164 },
 {  24,5164 }, {  25,5164 }, {  26,5164 }, {  27,5164 }, {  28,5164 },
 {  29,5164 }, {  30,5164 }, {  31,5164 }, {  32,5164 }, {  33,5164 },
 {  34,5164 }, {  35,5164 }, {  36,5164 }, {  37,5164 }, {  38,5164 },
 {   0,   0 }, {  40,5164 }, {  41,5164 }, {  42,5164 }, {  43,5164 },
 {  44,5164 }, {  45,5164 }, {  46,5164 }, {  47,5164 }, {  48,5164 },
 {  49,5164 }, {  50,5164 }, {  51,5164 }, {  52,5164 }, {  53,5164 },
 {  54,5164 }, {  55,5164 }, {  56,5164 }, {  57,5164 }, {  58,5164 },

 {  59,5164 }, {  60,5164 }, {  61,5164 }, {  62,5164 }, {  63,5164 },
 {  64,5164 }, {  65,5164 }, {  66,5164 }, {  67,5164 }, {  68,5164 },
 {  69,5164 }, {  70,5164 }, {  71,5164 }, {  72,5164 }, {  73,5164 },
 {  74,5164 }, {  75,5164 }, {  76,5164 }, {  77,5164 }, {  78,5164 },
 {  79,5164 }, {  80,5164 }, {  81,5164 }, {  82,5164 }, {  83,5164 },
 {  84,5164 }, {  85,5164 }, {  86,5164 }, {  87,5164 }, {  88,5164 },
 {  89,5164 }, {  90,5164 }, {  91,5164 }, {  92,5164 }, {  93,5164 },
 {  94,5164 }, {  95,5164 }, {  96,5164 }, {  97,5164 }, {  98,5164 },
 {  99,5164 }, { 100,5164 }, { 101,5164 }, { 102,5164 }, { 103,5164 },
 { 104,5164 }, { 105,5164 }, { 106,5164 }, { 107,5164 }, { 108,5164 },

 { 109,5164 }, { 110,5164 }, { 111,5164 }, { 112,5164 }, { 113,5164 },
 { 114,5164 }, { 115,5164 }, { 116,5164 }, { 117,5164 }, { 118,5164 },
 { 119,5164 }, { 120,5164 }, { 121,5164 }, { 122,5164 }, { 123,5164 },
 { 124,5164 }, { 125,5164 }, { 126,5164 }, { 127,5164 }, { 128,5164 },
 { 129,5164 }, { 130,5164 }, { 131,5164 }, { 132,5164 }, { 133,5164 },
 { 134,5164 }, { 135,5164 }, { 136,5164 }, { 137,5164 }, { 138,5164 },
 { 139,5164 }, { 140,5164 }, { 141,5164 }, { 142,5164 }, { 143,5164 },
 { 144,5164 }, { 145,5164 }, { 146,5164 }, { 147,5164 }, { 148,5164 },
 { 149,5164 }, { 150,5164 }, { 151,5164 }, { 152,5164 }, { 153,5164 },
 { 154,5164 }, { 155,5164 }, { 156,5164 }, { 157,5164 }, { 158,5164 },

 { 159,5164 }, { 160,5164 }, { 161,5164 }, { 162,5164 }, { 163,5164 },
 { 164,5164 }, { 165,5164 }, { 166,5164 }, { 167,5164 }, { 168,5164 },
 { 169,5164 }, { 170,5164 }, { 171,5164 }, { 172,5164 }, { 173,5164 },
 { 174,5164 }, { 175,5164 }, { 176,5164 }, { 177,5164 }, { 178,5164 },
 { 179,5164 }, { 180,5164 }, { 181,5164 }, { 182,5164 }, { 183,5164 },
 { 184,5164 }, { 185,5164 }, { 186,5164 }, { 187,5164 }, { 188,5164 },
 { 189,5164 }, { 190,5164 }, { 191,5164 }, { 192,5164 }, { 193,5164 },
 { 194,5164 }, { 195,5164 }, { 196,5164 }, { 197,5164 }, { 198,5164 },
 { 199,5164 }, { 200,5164 }, { 201,5164 }, { 202,5164 }, { 203,5164 },
 { 204,5164 }, { 205,5164 }, { 206,5164 }, { 207,5164 }, { 208,5164 },

 { 209,5164 }, { 210,5164 }, { 211,5164 }, { 212,5164 }, { 213,5164 },
 { 214,5164 }, { 215,5164 }, { 216,5164 }, { 217,5164 }, { 218,5164 },
 { 219,5164 }, { 220,5164 }, { 221,5164 }, { 222,5164 }, { 223,5164 },
 { 224,5164 }, { 225,5164 }, { 226,5164 }, { 227,5164 }, { 228,5164 },
 { 229,5164 }, { 230,5164 }, { 231,5164 }, { 232,5164 }, { 233,5164 },
 { 234,5164 }, { 235,5164 }, { 236,5164 }, { 237,5164 }, { 238,5164 },
 { 239,5164 }, { 240,5164 }, { 241,5164 }, { 242,5164 }, { 243,5164 },
 { 244,5164 }, { 245,5164 }, { 246,5164 }, { 247,5164 }, { 248,5164 },
 { 249,5164 }, { 250,5164 }, { 251,5164 }, { 252,5164 }, { 253,5164 },
 { 254,5164 }, { 255,5164 }, { 256,5164 }, {   0,  22 }, {   0,9177 },

 {   1,5164 }, {   2,5164 }, {   3,5164 }, {   4,5164 }, {   5,5164 },
 {   6,5164 }, {   7,5164 }, {   8,5164 }, {   9,5164 }, {  10,5164 },
 {  11,5164 }, {  12,5164 }, {  13,5164 }, {  14,5164 }, {  15,5164 },
 {  16,5164 }, {  17,5164 }, {  18,5164 }, {  19,5164 }, {  20,5164 },
 {  21,5164 }, {  22,5164 }, {  23,5164 }, {  24,5164 }, {  25,5164 },
 {  26,5164 }, {  27,5164 }, {  28,5164 }, {  29,5164 }, {  30,5164 },
 {  31,5164 }, {  32,5164 }, {  33,5164 }, {  34,5164 }, {  35,5164 },
 {  36,5164 }, {  37,5164 }, {  38,5164 }, {   0,   0 }, {  40,5164 },
 {  41,5164 }, {  42,5164 }, {  43,5164 }, {  44,5164 }, {  45,5164 },
 {  46,5164 }, {  47,5164 }, {  48,5164 }, {  49,5164 }, {  50,5164 },

 {  51,5164 }, {  52,5164 }, {  53,5164 }, {  54,5164 }, {  55,5164 },
 {  56,5164 }, {  57,5164 }, {  58,5164 }, {  59,5164 }, {  60,5164 },
 {  61,5164 }, {  62,5164 }, {  63,5164 }, {  64,5164 }, {  65,5164 },
 {  66,5164 }, {  67,5164 }, {  68,5164 }, {  69,5164 }, {  70,5164 },
 {  71,5164 }, {  72,5164 }, {  73,5164 }, {  74,5164 }, {  75,5164 },
 {  76,5164 }, {  77,5164 }, {  78,5164 }, {  79,5164 }, {  80,5164 },
 {  81,5164 }, {  82,5164 }, {  83,5164 }, {  84,5164 }, {  85,5164 },
 {  86,5164 }, {  87,5164 }, {  88,5164 }, {  89,5164 }, {  90,5164 },
 {  91,5164 }, {  92,5164 }, {  93,5164 }, {  94,5164 }, {  95,5164 },
 {  96,5164 }, {  97,5164 }, {  98,5164 }, {  99,5164 }, { 100,5164 },

 { 101,5164 }, { 102,5164 }, { 103,5164 }, { 104,5164 }, { 105,5164 },
 { 106,5164 }, { 107,5164 }, { 108,5164 }, { 109,5164 }, { 110,5164 },
 { 111,5164 }, { 112,5164 }, { 113,5164 }, { 114,5164 }, { 115,5164 },
 { 116,5164 }, { 117,5164 }, { 118,5164 }, { 119,5164 }, { 120,5164 },
 { 121,5164 }, { 122,5164 }, { 123,5164 }, { 124,5164 }, { 125,5164 },
 { 126,5164 }, { 127,5164 }, { 128,5164 }, { 129,5164 }, { 130,5164 },
 { 131,5164 }, { 132,5164 }, { 133,5164 }, { 134,5164 }, { 135,5164 },
 { 136,5164 }, { 137,5164 }, { 138,5164 }, { 139,5164 }, { 140,5164 },
 { 141,5164 }, { 142,5164 }, { 143,5164 }, { 144,5164 }, { 145,5164 },
 { 146,5164 }, { 147,5164 }, { 148,5164 }, { 149,5164 }, { 150,5164 },

 { 151,5164 }, { 152,5164 }, { 153,5164 }, { 154,5164 }, { 155,5164 },
 { 156,5164 }, { 157,5164 }, { 158,5164 }, { 159,5164 }, { 160,5164 },
 { 161,5164 }, { 162,5164 }, { 163,5164 }, { 164,5164 }, { 165,5164 },
 { 166,5164 }, { 167,5164 }, { 168,5164 }, { 169,5164 }, { 170,5164 },
 { 171,5164 }, { 172,5164 }, { 173,5164 }, { 174,5164 }, { 175,5164 },
 { 176,5164 }, { 177,5164 }, { 178,5164 }, { 179,5164 }, { 180,5164 },
 { 181,5164 }, { 182,5164 }, { 183,5164 }, { 184,5164 }, { 185,5164 },
 { 186,5164 }, { 187,5164 }, { 188,5164 }, { 189,5164 }, { 190,5164 },
 { 191,5164 }, { 192,5164 }, { 193,5164 }, { 194,5164 }, { 195,5164 },
 { 196,5164 }, { 197,5164 }, { 198,5164 }, { 199,5164 }, { 200,5164 },

 { 201,5164 }, { 202,5164 }, { 203,5164 }, { 204,5164 }, { 205,5164 },
 { 206,5164 }, { 207,5164 }, { 208,5164 }, { 209,5164 }, { 210,5164 },
 { 211,5164 }, { 212,5164 }, { 213,5164 }, { 214,5164 }, { 215,5164 },
 { 216,5164 }, { 217,5164 }, { 218,5164 }, { 219,5164 }, { 220,5164 },
 { 221,5164 }, { 222,5164 }, { 223,5164 }, { 224,5164 }, { 225,5164 },
 { 226,5164 }, { 227,5164 }, { 228,5164 }, { 229,5164 }, { 230,5164 },
 { 231,5164 }, { 232,5164 }, { 233,5164 }, { 234,5164 }, { 235,5164 },
 { 236,5164 }, { 237,5164 }, { 238,5164 }, { 239,5164 }, { 240,5164 },
 { 241,5164 }, { 242,5164 }, { 243,5164 }, { 244,5164 }, { 245,5164 },
 { 246,5164 }, { 247,5164 }, { 248,5164 }, { 249,5164 }, { 250,5164 },

 { 251,5164 }, { 252,5164 }, { 253,5164 }, { 254,5164 }, { 255,5164 },
 { 256,5164 }, {   0,  19 }, {   0,8919 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  19 }, {   0,8914 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,5164 }, {  10,5169 }, {   0,   0 }, {  12,5164 },
 {  13,5169 }, {   9,5180 }, {  10,5180 }, {   0,   0 }, {  12,5180 },
 {  13,5180 }, {   0,   0 }, {   0,  19 }, {   0,8898 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,5164 }, {  10,5164 }, {  32,5164 },
 {  12,5164 }, {  13,5164 }, {   0,   0 }, {   0,   0 }, {  32,5180 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  39,-3574 }, {  45,-3571 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-3576 }, {   0,   0 }, {   0,   0 },
 {  32,5164 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-3590 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-3592 }, {   0,  23 },
 {   0,8851 }, {   1,5164 }, {   2,5164 }, {   3,5164 }, {   4,5164 },
 {   5,5164 }, {   6,5164 }, {   7,5164 }, {   8,5164 }, {   9,5164 },
 {  10,5164 }, {  11,5164 }, {  12,5164 }, {  13,5164 }, {  14,5164 },
 {  15,5164 }, {  16,5164 }, {  17,5164 }, {  18,5164 }, {  19,5164 },
 {  20,5164 }, {  21,5164 }, {  22,5164 }, {  23,5164 }, {  24,5164 },

 {  25,5164 }, {  26,5164 }, {  27,5164 }, {  28,5164 }, {  29,5164 },
 {  30,5164 }, {  31,5164 }, {  32,5164 }, {  33,5164 }, {  34,5164 },
 {  35,5164 }, {  36,5164 }, {  37,5164 }, {  38,5164 }, {   0,   0 },
 {  40,5164 }, {  41,5164 }, {  42,5164 }, {  43,5164 }, {  44,5164 },
 {  45,5164 }, {  46,5164 }, {  47,5164 }, {  48,5164 }, {  49,5164 },
 {  50,5164 }, {  51,5164 }, {  52,5164 }, {  53,5164 }, {  54,5164 },
 {  55,5164 }, {  56,5164 }, {  57,5164 }, {  58,5164 }, {  59,5164 },
 {  60,5164 }, {  61,5164 }, {  62,5164 }, {  63,5164 }, {  64,5164 },
 {  65,5164 }, {  66,5164 }, {  67,5164 }, {  68,5164 }, {  69,5164 },
 {  70,5164 }, {  71,5164 }, {  72,5164 }, {  73,5164 }, {  74,5164 },

 {  75,5164 }, {  76,5164 }, {  77,5164 }, {  78,5164 }, {  79,5164 },
 {  80,5164 }, {  81,5164 }, {  82,5164 }, {  83,5164 }, {  84,5164 },
 {  85,5164 }, {  86,5164 }, {  87,5164 }, {  88,5164 }, {  89,5164 },
 {  90,5164 }, {  91,5164 }, {   0,   0 }, {  93,5164 }, {  94,5164 },
 {  95,5164 }, {  96,5164 }, {  97,5164 }, {  98,5164 }, {  99,5164 },
 { 100,5164 }, { 101,5164 }, { 102,5164 }, { 103,5164 }, { 104,5164 },
 { 105,5164 }, { 106,5164 }, { 107,5164 }, { 108,5164 }, { 109,5164 },
 { 110,5164 }, { 111,5164 }, { 112,5164 }, { 113,5164 }, { 114,5164 },
 { 115,5164 }, { 116,5164 }, { 117,5164 }, { 118,5164 }, { 119,5164 },
 { 120,5164 }, { 121,5164 }, { 122,5164 }, { 123,5164 }, { 124,5164 },

 { 125,5164 }, { 126,5164 }, { 127,5164 }, { 128,5164 }, { 129,5164 },
 { 130,5164 }, { 131,5164 }, { 132,5164 }, { 133,5164 }, { 134,5164 },
 { 135,5164 }, { 136,5164 }, { 137,5164 }, { 138,5164 }, { 139,5164 },
 { 140,5164 }, { 141,5164 }, { 142,5164 }, { 143,5164 }, { 144,5164 },
 { 145,5164 }, { 146,5164 }, { 147,5164 }, { 148,5164 }, { 149,5164 },
 { 150,5164 }, { 151,5164 }, { 152,5164 }, { 153,5164 }, { 154,5164 },
 { 155,5164 }, { 156,5164 }, { 157,5164 }, { 158,5164 }, { 159,5164 },
 { 160,5164 }, { 161,5164 }, { 162,5164 }, { 163,5164 }, { 164,5164 },
 { 165,5164 }, { 166,5164 }, { 167,5164 }, { 168,5164 }, { 169,5164 },
 { 170,5164 }, { 171,5164 }, { 172,5164 }, { 173,5164 }, { 174,5164 },

 { 175,5164 }, { 176,5164 }, { 177,5164 }, { 178,5164 }, { 179,5164 },
 { 180,5164 }, { 181,5164 }, { 182,5164 }, { 183,5164 }, { 184,5164 },
 { 185,5164 }, { 186,5164 }, { 187,5164 }, { 188,5164 }, { 189,5164 },
 { 190,5164 }, { 191,5164 }, { 192,5164 }, { 193,5164 }, { 194,5164 },
 { 195,5164 }, { 196,5164 }, { 197,5164 }, { 198,5164 }, { 199,5164 },
 { 200,5164 }, { 201,5164 }, { 202,5164 }, { 203,5164 }, { 204,5164 },
 { 205,5164 }, { 206,5164 }, { 207,5164 }, { 208,5164 }, { 209,5164 },
 { 210,5164 }, { 211,5164 }, { 212,5164 }, { 213,5164 }, { 214,5164 },
 { 215,5164 }, { 216,5164 }, { 217,5164 }, { 218,5164 }, { 219,5164 },
 { 220,5164 }, { 221,5164 }, { 222,5164 }, { 223,5164 }, { 224,5164 },

 { 225,5164 }, { 226,5164 }, { 227,5164 }, { 228,5164 }, { 229,5164 },
 { 230,5164 }, { 231,5164 }, { 232,5164 }, { 233,5164 }, { 234,5164 },
 { 235,5164 }, { 236,5164 }, { 237,5164 }, { 238,5164 }, { 239,5164 },
 { 240,5164 }, { 241,5164 }, { 242,5164 }, { 243,5164 }, { 244,5164 },
 { 245,5164 }, { 246,5164 }, { 247,5164 }, { 248,5164 }, { 249,5164 },
 { 250,5164 }, { 251,5164 }, { 252,5164 }, { 253,5164 }, { 254,5164 },
 { 255,5164 }, { 256,5164 }, {   0,  23 }, {   0,8593 }, {   1,4906 },
 {   2,4906 }, {   3,4906 }, {   4,4906 }, {   5,4906 }, {   6,4906 },
 {   7,4906 }, {   8,4906 }, {   9,4906 }, {  10,4906 }, {  11,4906 },
 {  12,4906 }, {  13,4906 }, {  14,4906 }, {  15,4906 }, {  16,4906 },

 {  17,4906 }, {  18,4906 }, {  19,4906 }, {  20,4906 }, {  21,4906 },
 {  22,4906 }, {  23,4906 }, {  24,4906 }, {  25,4906 }, {  26,4906 },
 {  27,4906 }, {  28,4906 }, {  29,4906 }, {  30,4906 }, {  31,4906 },
 {  32,4906 }, {  33,4906 }, {  34,4906 }, {  35,4906 }, {  36,4906 },
 {  37,4906 }, {  38,4906 }, {   0,   0 }, {  40,4906 }, {  41,4906 },
 {  42,4906 }, {  43,4906 }, {  44,4906 }, {  45,4906 }, {  46,4906 },
 {  47,4906 }, {  48,4906 }, {  49,4906 }, {  50,4906 }, {  51,4906 },
 {  52,4906 }, {  53,4906 }, {  54,4906 }, {  55,4906 }, {  56,4906 },
 {  57,4906 }, {  58,4906 }, {  59,4906 }, {  60,4906 }, {  61,4906 },
 {  62,4906 }, {  63,4906 }, {  64,4906 }, {  65,4906 }, {  66,4906 },

 {  67,4906 }, {  68,4906 }, {  69,4906 }, {  70,4906 }, {  71,4906 },
 {  72,4906 }, {  73,4906 }, {  74,4906 }, {  75,4906 }, {  76,4906 },
 {  77,4906 }, {  78,4906 }, {  79,4906 }, {  80,4906 }, {  81,4906 },
 {  82,4906 }, {  83,4906 }, {  84,4906 }, {  85,4906 }, {  86,4906 },
 {  87,4906 }, {  88,4906 }, {  89,4906 }, {  90,4906 }, {  91,4906 },
 {   0,   0 }, {  93,4906 }, {  94,4906 }, {  95,4906 }, {  96,4906 },
 {  97,4906 }, {  98,4906 }, {  99,4906 }, { 100,4906 }, { 101,4906 },
 { 102,4906 }, { 103,4906 }, { 104,4906 }, { 105,4906 }, { 106,4906 },
 { 107,4906 }, { 108,4906 }, { 109,4906 }, { 110,4906 }, { 111,4906 },
 { 112,4906 }, { 113,4906 }, { 114,4906 }, { 115,4906 }, { 116,4906 },

 { 117,4906 }, { 118,4906 }, { 119,4906 }, { 120,4906 }, { 121,4906 },
 { 122,4906 }, { 123,4906 }, { 124,4906 }, { 125,4906 }, { 126,4906 },
 { 127,4906 }, { 128,4906 }, { 129,4906 }, { 130,4906 }, { 131,4906 },
 { 132,4906 }, { 133,4906 }, { 134,4906 }, { 135,4906 }, { 136,4906 },
 { 137,4906 }, { 138,4906 }, { 139,4906 }, { 140,4906 }, { 141,4906 },
 { 142,4906 }, { 143,4906 }, { 144,4906 }, { 145,4906 }, { 146,4906 },
 { 147,4906 }, { 148,4906 }, { 149,4906 }, { 150,4906 }, { 151,4906 },
 { 152,4906 }, { 153,4906 }, { 154,4906 }, { 155,4906 }, { 156,4906 },
 { 157,4906 }, { 158,4906 }, { 159,4906 }, { 160,4906 }, { 161,4906 },
 { 162,4906 }, { 163,4906 }, { 164,4906 }, { 165,4906 }, { 166,4906 },

 { 167,4906 }, { 168,4906 }, { 169,4906 }, { 170,4906 }, { 171,4906 },
 { 172,4906 }, { 173,4906 }, { 174,4906 }, { 175,4906 }, { 176,4906 },
 { 177,4906 }, { 178,4906 }, { 179,4906 }, { 180,4906 }, { 181,4906 },
 { 182,4906 }, { 183,4906 }, { 184,4906 }, { 185,4906 }, { 186,4906 },
 { 187,4906 }, { 188,4906 }, { 189,4906 }, { 190,4906 }, { 191,4906 },
 { 192,4906 }, { 193,4906 }, { 194,4906 }, { 195,4906 }, { 196,4906 },
 { 197,4906 }, { 198,4906 }, { 199,4906 }, { 200,4906 }, { 201,4906 },
 { 202,4906 }, { 203,4906 }, { 204,4906 }, { 205,4906 }, { 206,4906 },
 { 207,4906 }, { 208,4906 }, { 209,4906 }, { 210,4906 }, { 211,4906 },
 { 212,4906 }, { 213,4906 }, { 214,4906 }, { 215,4906 }, { 216,4906 },

 { 217,4906 }, { 218,4906 }, { 219,4906 }, { 220,4906 }, { 221,4906 },
 { 222,4906 }, { 223,4906 }, { 224,4906 }, { 225,4906 }, { 226,4906 },
 { 227,4906 }, { 228,4906 }, { 229,4906 }, { 230,4906 }, { 231,4906 },
 { 232,4906 }, { 233,4906 }, { 234,4906 }, { 235,4906 }, { 236,4906 },
 { 237,4906 }, { 238,4906 }, { 239,4906 }, { 240,4906 }, { 241,4906 },
 { 242,4906 }, { 243,4906 }, { 244,4906 }, { 245,4906 }, { 246,4906 },
 { 247,4906 }, { 248,4906 }, { 249,4906 }, { 250,4906 }, { 251,4906 },
 { 252,4906 }, { 253,4906 }, { 254,4906 }, { 255,4906 }, { 256,4906 },
 {   0,  32 }, {   0,8335 }, {   1,-4151 }, {   2,-4151 }, {   3,-4151 },
 {   4,-4151 }, {   5,-4151 }, {   6,-4151 }, {   7,-4151 }, {   8,-4151 },

 {   9,-4151 }, {  10,-4151 }, {  11,-4151 }, {  12,-4151 }, {  13,-4151 },
 {  14,-4151 }, {  15,-4151 }, {  16,-4151 }, {  17,-4151 }, {  18,-4151 },
 {  19,-4151 }, {  20,-4151 }, {  21,-4151 }, {  22,-4151 }, {  23,-4151 },
 {  24,-4151 }, {  25,-4151 }, {  26,-4151 }, {  27,-4151 }, {  28,-4151 },
 {  29,-4151 }, {  30,-4151 }, {  31,-4151 }, {  32,-4151 }, {  33,-4151 },
 {  34,-4151 }, {  35,-4151 }, {  36,-4151 }, {  37,-4151 }, {  38,-4151 },
 {  39,-4151 }, {  40,-4151 }, {  41,-4151 }, {  42,-4151 }, {  43,-4151 },
 {  44,-4151 }, {  45,-4151 }, {  46,-4151 }, {  47,-4151 }, {  48,4906 },
 {  49,4906 }, {  50,4906 }, {  51,4906 }, {  52,4906 }, {  53,4906 },
 {  54,4906 }, {  55,4906 }, {  56,-4151 }, {  57,-4151 }, {  58,-4151 },

 {  59,-4151 }, {  60,-4151 }, {  61,-4151 }, {  62,-4151 }, {  63,-4151 },
 {  64,-4151 }, {  65,-4151 }, {  66,-4151 }, {  67,-4151 }, {  68,-4151 },
 {  69,-4151 }, {  70,-4151 }, {  71,-4151 }, {  72,-4151 }, {  73,-4151 },
 {  74,-4151 }, {  75,-4151 }, {  76,-4151 }, {  77,-4151 }, {  78,-4151 },
 {  79,-4151 }, {  80,-4151 }, {  81,-4151 }, {  82,-4151 }, {  83,-4151 },
 {  84,-4151 }, {  85,4914 }, {  86,-4151 }, {  87,-4151 }, {  88,-4151 },
 {  89,-4151 }, {  90,-4151 }, {  91,-4151 }, {  92,-4151 }, {  93,-4151 },
 {  94,-4151 }, {  95,-4151 }, {  96,-4151 }, {  97,-4151 }, {  98,-4151 },
 {  99,-4151 }, { 100,-4151 }, { 101,-4151 }, { 102,-4151 }, { 103,-4151 },
 { 104,-4151 }, { 105,-4151 }, { 106,-4151 }, { 107,-4151 }, { 108,-4151 },

 { 109,-4151 }, { 110,-4151 }, { 111,-4151 }, { 112,-4151 }, { 113,-4151 },
 { 114,-4151 }, { 115,-4151 }, { 116,-4151 }, { 117,4937 }, { 118,-4151 },
 { 119,-4151 }, { 120,4975 }, { 121,-4151 }, { 122,-4151 }, { 123,-4151 },
 { 124,-4151 }, { 125,-4151 }, { 126,-4151 }, { 127,-4151 }, { 128,-4151 },
 { 129,-4151 }, { 130,-4151 }, { 131,-4151 }, { 132,-4151 }, { 133,-4151 },
 { 134,-4151 }, { 135,-4151 }, { 136,-4151 }, { 137,-4151 }, { 138,-4151 },
 { 139,-4151 }, { 140,-4151 }, { 141,-4151 }, { 142,-4151 }, { 143,-4151 },
 { 144,-4151 }, { 145,-4151 }, { 146,-4151 }, { 147,-4151 }, { 148,-4151 },
 { 149,-4151 }, { 150,-4151 }, { 151,-4151 }, { 152,-4151 }, { 153,-4151 },
 { 154,-4151 }, { 155,-4151 }, { 156,-4151 }, { 157,-4151 }, { 158,-4151 },

 { 159,-4151 }, { 160,-4151 }, { 161,-4151 }, { 162,-4151 }, { 163,-4151 },
 { 164,-4151 }, { 165,-4151 }, { 166,-4151 }, { 167,-4151 }, { 168,-4151 },
 { 169,-4151 }, { 170,-4151 }, { 171,-4151 }, { 172,-4151 }, { 173,-4151 },
 { 174,-4151 }, { 175,-4151 }, { 176,-4151 }, { 177,-4151 }, { 178,-4151 },
 { 179,-4151 }, { 180,-4151 }, { 181,-4151 }, { 182,-4151 }, { 183,-4151 },
 { 184,-4151 }, { 185,-4151 }, { 186,-4151 }, { 187,-4151 }, { 188,-4151 },
 { 189,-4151 }, { 190,-4151 }, { 191,-4151 }, { 192,-4151 }, { 193,-4151 },
 { 194,-4151 }, { 195,-4151 }, { 196,-4151 }, { 197,-4151 }, { 198,-4151 },
 { 199,-4151 }, { 200,-4151 }, { 201,-4151 }, { 202,-4151 }, { 203,-4151 },
 { 204,-4151 }, { 205,-4151 }, { 206,-4151 }, { 207,-4151 }, { 208,-4151 },

 { 209,-4151 }, { 210,-4151 }, { 211,-4151 }, { 212,-4151 }, { 213,-4151 },
 { 214,-4151 }, { 215,-4151 }, { 216,-4151 }, { 217,-4151 }, { 218,-4151 },
 { 219,-4151 }, { 220,-4151 }, { 221,-4151 }, { 222,-4151 }, { 223,-4151 },
 { 224,-4151 }, { 225,-4151 }, { 226,-4151 }, { 227,-4151 }, { 228,-4151 },
 { 229,-4151 }, { 230,-4151 }, { 231,-4151 }, { 232,-4151 }, { 233,-4151 },
 { 234,-4151 }, { 235,-4151 }, { 236,-4151 }, { 237,-4151 }, { 238,-4151 },
 { 239,-4151 }, { 240,-4151 }, { 241,-4151 }, { 242,-4151 }, { 243,-4151 },
 { 244,-4151 }, { 245,-4151 }, { 246,-4151 }, { 247,-4151 }, { 248,-4151 },
 { 249,-4151 }, { 250,-4151 }, { 251,-4151 }, { 252,-4151 }, { 253,-4151 },
 { 254,-4151 }, { 255,-4151 }, { 256,-4151 }, {   0,  36 }, {   0,8077 },

 {   1,4821 }, {   2,4821 }, {   3,4821 }, {   4,4821 }, {   5,4821 },
 {   6,4821 }, {   7,4821 }, {   8,4821 }, {   9,4821 }, {  10,4821 },
 {  11,4821 }, {  12,4821 }, {  13,4821 }, {  14,4821 }, {  15,4821 },
 {  16,4821 }, {  17,4821 }, {  18,4821 }, {  19,4821 }, {  20,4821 },
 {  21,4821 }, {  22,4821 }, {  23,4821 }, {  24,4821 }, {  25,4821 },
 {  26,4821 }, {  27,4821 }, {  28,4821 }, {  29,4821 }, {  30,4821 },
 {  31,4821 }, {  32,4821 }, {  33,4821 }, {  34,4821 }, {  35,4821 },
 {   0,   0 }, {  37,4821 }, {  38,4821 }, {  39,4821 }, {  40,4821 },
 {  41,4821 }, {  42,4821 }, {  43,4821 }, {  44,4821 }, {  45,4821 },
 {  46,4821 }, {  47,4821 }, {  48,4821 }, {  49,4821 }, {  50,4821 },

 {  51,4821 }, {  52,4821 }, {  53,4821 }, {  54,4821 }, {  55,4821 },
 {  56,4821 }, {  57,4821 }, {  58,4821 }, {  59,4821 }, {  60,4821 },
 {  61,4821 }, {  62,4821 }, {  63,4821 }, {  64,4821 }, {  65,4821 },
 {  66,4821 }, {  67,4821 }, {  68,4821 }, {  69,4821 }, {  70,4821 },
 {  71,4821 }, {  72,4821 }, {  73,4821 }, {  74,4821 }, {  75,4821 },
 {  76,4821 }, {  77,4821 }, {  78,4821 }, {  79,4821 }, {  80,4821 },
 {  81,4821 }, {  82,4821 }, {  83,4821 }, {  84,4821 }, {  85,4821 },
 {  86,4821 }, {  87,4821 }, {  88,4821 }, {  89,4821 }, {  90,4821 },
 {  91,4821 }, {  92,4821 }, {  93,4821 }, {  94,4821 }, {  95,4821 },
 {  96,4821 }, {  97,4821 }, {  98,4821 }, {  99,4821 }, { 100,4821 },

 { 101,4821 }, { 102,4821 }, { 103,4821 }, { 104,4821 }, { 105,4821 },
 { 106,4821 }, { 107,4821 }, { 108,4821 }, { 109,4821 }, { 110,4821 },
 { 111,4821 }, { 112,4821 }, { 113,4821 }, { 114,4821 }, { 115,4821 },
 { 116,4821 }, { 117,4821 }, { 118,4821 }, { 119,4821 }, { 120,4821 },
 { 121,4821 }, { 122,4821 }, { 123,4821 }, { 124,4821 }, { 125,4821 },
 { 126,4821 }, { 127,4821 }, { 128,4821 }, { 129,4821 }, { 130,4821 },
 { 131,4821 }, { 132,4821 }, { 133,4821 }, { 134,4821 }, { 135,4821 },
 { 136,4821 }, { 137,4821 }, { 138,4821 }, { 139,4821 }, { 140,4821 },
 { 141,4821 }, { 142,4821 }, { 143,4821 }, { 144,4821 }, { 145,4821 },
 { 146,4821 }, { 147,4821 }, { 148,4821 }, { 149,4821 }, { 150,4821 },

 { 151,4821 }, { 152,4821 }, { 153,4821 }, { 154,4821 }, { 155,4821 },
 { 156,4821 }, { 157,4821 }, { 158,4821 }, { 159,4821 }, { 160,4821 },
 { 161,4821 }, { 162,4821 }, { 163,4821 }, { 164,4821 }, { 165,4821 },
 { 166,4821 }, { 167,4821 }, { 168,4821 }, { 169,4821 }, { 170,4821 },
 { 171,4821 }, { 172,4821 }, { 173,4821 }, { 174,4821 }, { 175,4821 },
 { 176,4821 }, { 177,4821 }, { 178,4821 }, { 179,4821 }, { 180,4821 },
 { 181,4821 }, { 182,4821 }, { 183,4821 }, { 184,4821 }, { 185,4821 },
 { 186,4821 }, { 187,4821 }, { 188,4821 }, { 189,4821 }, { 190,4821 },
 { 191,4821 }, { 192,4821 }, { 193,4821 }, { 194,4821 }, { 195,4821 },
 { 196,4821 }, { 197,4821 }, { 198,4821 }, { 199,4821 }, { 200,4821 },

 { 201,4821 }, { 202,4821 }, { 203,4821 }, { 204,4821 }, { 205,4821 },
 { 206,4821 }, { 207,4821 }, { 208,4821 }, { 209,4821 }, { 210,4821 },
 { 211,4821 }, { 212,4821 }, { 213,4821 }, { 214,4821 }, { 215,4821 },
 { 216,4821 }, { 217,4821 }, { 218,4821 }, { 219,4821 }, { 220,4821 },
 { 221,4821 }, { 222,4821 }, { 223,4821 }, { 224,4821 }, { 225,4821 },
 { 226,4821 }, { 227,4821 }, { 228,4821 }, { 229,4821 }, { 230,4821 },
 { 231,4821 }, { 232,4821 }, { 233,4821 }, { 234,4821 }, { 235,4821 },
 { 236,4821 }, { 237,4821 }, { 238,4821 }, { 239,4821 }, { 240,4821 },
 { 241,4821 }, { 242,4821 }, { 243,4821 }, { 244,4821 }, { 245,4821 },
 { 246,4821 }, { 247,4821 }, { 248,4821 }, { 249,4821 }, { 250,4821 },

 { 251,4821 }, { 252,4821 }, { 253,4821 }, { 254,4821 }, { 255,4821 },
 { 256,4821 }, {   0,  36 }, {   0,7819 }, {   1,4563 }, {   2,4563 },
 {   3,4563 }, {   4,4563 }, {   5,4563 }, {   6,4563 }, {   7,4563 },
 {   8,4563 }, {   9,4563 }, {  10,4563 }, {  11,4563 }, {  12,4563 },
 {  13,4563 }, {  14,4563 }, {  15,4563 }, {  16,4563 }, {  17,4563 },
 {  18,4563 }, {  19,4563 }, {  20,4563 }, {  21,4563 }, {  22,4563 },
 {  23,4563 }, {  24,4563 }, {  25,4563 }, {  26,4563 }, {  27,4563 },
 {  28,4563 }, {  29,4563 }, {  30,4563 }, {  31,4563 }, {  32,4563 },
 {  33,4563 }, {  34,4563 }, {  35,4563 }, {   0,   0 }, {  37,4563 },
 {  38,4563 }, {  39,4563 }, {  40,4563 }, {  41,4563 }, {  42,4563 },

 {  43,4563 }, {  44,4563 }, {  45,4563 }, {  46,4563 }, {  47,4563 },
 {  48,4563 }, {  49,4563 }, {  50,4563 }, {  51,4563 }, {  52,4563 },
 {  53,4563 }, {  54,4563 }, {  55,4563 }, {  56,4563 }, {  57,4563 },
 {  58,4563 }, {  59,4563 }, {  60,4563 }, {  61,4563 }, {  62,4563 },
 {  63,4563 }, {  64,4563 }, {  65,4563 }, {  66,4563 }, {  67,4563 },
 {  68,4563 }, {  69,4563 }, {  70,4563 }, {  71,4563 }, {  72,4563 },
 {  73,4563 }, {  74,4563 }, {  75,4563 }, {  76,4563 }, {  77,4563 },
 {  78,4563 }, {  79,4563 }, {  80,4563 }, {  81,4563 }, {  82,4563 },
 {  83,4563 }, {  84,4563 }, {  85,4563 }, {  86,4563 }, {  87,4563 },
 {  88,4563 }, {  89,4563 }, {  90,4563 }, {  91,4563 }, {  92,4563 },

 {  93,4563 }, {  94,4563 }, {  95,4563 }, {  96,4563 }, {  97,4563 },
 {  98,4563 }, {  99,4563 }, { 100,4563 }, { 101,4563 }, { 102,4563 },
 { 103,4563 }, { 104,4563 }, { 105,4563 }, { 106,4563 }, { 107,4563 },
 { 108,4563 }, { 109,4563 }, { 110,4563 }, { 111,4563 }, { 112,4563 },
 { 113,4563 }, { 114,4563 }, { 115,4563 }, { 116,4563 }, { 117,4563 },
 { 118,4563 }, { 119,4563 }, { 120,4563 }, { 121,4563 }, { 122,4563 },
 { 123,4563 }, { 124,4563 }, { 125,4563 }, { 126,4563 }, { 127,4563 },
 { 128,4563 }, { 129,4563 }, { 130,4563 }, { 131,4563 }, { 132,4563 },
 { 133,4563 }, { 134,4563 }, { 135,4563 }, { 136,4563 }, { 137,4563 },
 { 138,4563 }, { 139,4563 }, { 140,4563 }, { 141,4563 }, { 142,4563 },

 { 143,4563 }, { 144,4563 }, { 145,4563 }, { 146,4563 }, { 147,4563 },
 { 148,4563 }, { 149,4563 }, { 150,4563 }, { 151,4563 }, { 152,4563 },
 { 153,4563 }, { 154,4563 }, { 155,4563 }, { 156,4563 }, { 157,4563 },
 { 158,4563 }, { 159,4563 }, { 160,4563 }, { 161,4563 }, { 162,4563 },
 { 163,4563 }, { 164,4563 }, { 165,4563 }, { 166,4563 }, { 167,4563 },
 { 168,4563 }, { 169,4563 }, { 170,4563 }, { 171,4563 }, { 172,4563 },
 { 173,4563 }, { 174,4563 }, { 175,4563 }, { 176,4563 }, { 177,4563 },
 { 178,4563 }, { 179,4563 }, { 180,4563 }, { 181,4563 }, { 182,4563 },
 { 183,4563 }, { 184,4563 }, { 185,4563 }, { 186,4563 }, { 187,4563 },
 { 188,4563 }, { 189,4563 }, { 190,4563 }, { 191,4563 }, { 192,4563 },

 { 193,4563 }, { 194,4563 }, { 195,4563 }, { 196,4563 }, { 197,4563 },
 { 198,4563 }, { 199,4563 }, { 200,4563 }, { 201,4563 }, { 202,4563 },
 { 203,4563 }, { 204,4563 }, { 205,4563 }, { 206,4563 }, { 207,4563 },
 { 208,4563 }, { 209,4563 }, { 210,4563 }, { 211,4563 }, { 212,4563 },
 { 213,4563 }, { 214,4563 }, { 215,4563 }, { 216,4563 }, { 217,4563 },
 { 218,4563 }, { 219,4563 }, { 220,4563 }, { 221,4563 }, { 222,4563 },
 { 223,4563 }, { 224,4563 }, { 225,4563 }, { 226,4563 }, { 227,4563 },
 { 228,4563 }, { 229,4563 }, { 230,4563 }, { 231,4563 }, { 232,4563 },
 { 233,4563 }, { 234,4563 }, { 235,4563 }, { 236,4563 }, { 237,4563 },
 { 238,4563 }, { 239,4563 }, { 240,4563 }, { 241,4563 }, { 242,4563 },

 { 243,4563 }, { 244,4563 }, { 245,4563 }, { 246,4563 }, { 247,4563 },
 { 248,4563 }, { 249,4563 }, { 250,4563 }, { 251,4563 }, { 252,4563 },
 { 253,4563 }, { 254,4563 }, { 255,4563 }, { 256,4563 }, {   0,  38 },
 {   0,7561 }, {   0,   1 }, {   0,7559 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,   0 }, {  10,   0 }, {   0,   0 }, {  12,   0 },
 {  13,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,   0 },

 {   0,   0 }, {  36,-4923 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4563 }, {  66,4563 }, {  67,4563 }, {  68,4563 }, {  69,4563 },
 {  70,4563 }, {  71,4563 }, {  72,4563 }, {  73,4563 }, {  74,4563 },
 {  75,4563 }, {  76,4563 }, {  77,4563 }, {  78,4563 }, {  79,4563 },
 {  80,4563 }, {  81,4563 }, {  82,4563 }, {  83,4563 }, {  84,4563 },

 {  85,4563 }, {  86,4563 }, {  87,4563 }, {  88,4563 }, {  89,4563 },
 {  90,4563 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,4563 }, {   0,   0 }, {  97,4563 }, {  98,4563 }, {  99,4563 },
 { 100,4563 }, { 101,4563 }, { 102,4563 }, { 103,4563 }, { 104,4563 },
 { 105,4563 }, { 106,4563 }, { 107,4563 }, { 108,4563 }, { 109,4563 },
 { 110,4563 }, { 111,4563 }, { 112,4563 }, { 113,4563 }, { 114,4563 },
 { 115,4563 }, { 116,4563 }, { 117,4563 }, { 118,4563 }, { 119,4563 },
 { 120,4563 }, { 121,4563 }, { 122,4563 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4563 }, { 129,4563 },
 { 130,4563 }, { 131,4563 }, { 132,4563 }, { 133,4563 }, { 134,4563 },

 { 135,4563 }, { 136,4563 }, { 137,4563 }, { 138,4563 }, { 139,4563 },
 { 140,4563 }, { 141,4563 }, { 142,4563 }, { 143,4563 }, { 144,4563 },
 { 145,4563 }, { 146,4563 }, { 147,4563 }, { 148,4563 }, { 149,4563 },
 { 150,4563 }, { 151,4563 }, { 152,4563 }, { 153,4563 }, { 154,4563 },
 { 155,4563 }, { 156,4563 }, { 157,4563 }, { 158,4563 }, { 159,4563 },
 { 160,4563 }, { 161,4563 }, { 162,4563 }, { 163,4563 }, { 164,4563 },
 { 165,4563 }, { 166,4563 }, { 167,4563 }, { 168,4563 }, { 169,4563 },
 { 170,4563 }, { 171,4563 }, { 172,4563 }, { 173,4563 }, { 174,4563 },
 { 175,4563 }, { 176,4563 }, { 177,4563 }, { 178,4563 }, { 179,4563 },
 { 180,4563 }, { 181,4563 }, { 182,4563 }, { 183,4563 }, { 184,4563 },

 { 185,4563 }, { 186,4563 }, { 187,4563 }, { 188,4563 }, { 189,4563 },
 { 190,4563 }, { 191,4563 }, { 192,4563 }, { 193,4563 }, { 194,4563 },
 { 195,4563 }, { 196,4563 }, { 197,4563 }, { 198,4563 }, { 199,4563 },
 { 200,4563 }, { 201,4563 }, { 202,4563 }, { 203,4563 }, { 204,4563 },
 { 205,4563 }, { 206,4563 }, { 207,4563 }, { 208,4563 }, { 209,4563 },
 { 210,4563 }, { 211,4563 }, { 212,4563 }, { 213,4563 }, { 214,4563 },
 { 215,4563 }, { 216,4563 }, { 217,4563 }, { 218,4563 }, { 219,4563 },
 { 220,4563 }, { 221,4563 }, { 222,4563 }, { 223,4563 }, { 224,4563 },
 { 225,4563 }, { 226,4563 }, { 227,4563 }, { 228,4563 }, { 229,4563 },
 { 230,4563 }, { 231,4563 }, { 232,4563 }, { 233,4563 }, { 234,4563 },

 { 235,4563 }, { 236,4563 }, { 237,4563 }, { 238,4563 }, { 239,4563 },
 { 240,4563 }, { 241,4563 }, { 242,4563 }, { 243,4563 }, { 244,4563 },
 { 245,4563 }, { 246,4563 }, { 247,4563 }, { 248,4563 }, { 249,4563 },
 { 250,4563 }, { 251,4563 }, { 252,4563 }, { 253,4563 }, { 254,4563 },
 { 255,4563 }, {   0,  55 }, {   0,7304 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  53 }, {   0,7293 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 },
 {  43,   0 }, {  33, -11 }, {  45,   0 }, {  35, -11 }, {  47,   0 },
 {  37, -11 }, {  38, -11 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42, -11 }, {  43, -11 }, {   0,   0 }, {  45, -11 }, {   0,   0 },
 {  47, -11 }, {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60, -11 }, {  61, -11 },
 {  62, -11 }, {  63, -11 }, {  64, -11 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  56 }, {   0,7214 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94, -11 }, {   0,   0 }, {  96, -11 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 124, -11 }, {   0,   0 }, { 126, -11 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-5268 }, {  66,-5268 }, {  67,-5268 },
 {  68,-5268 }, {  69,-5268 }, {  70,-5268 }, {  71,-5268 }, {  72,-5268 },
 {  73,-5268 }, {  74,-5268 }, {  75,-5268 }, {  76,-5268 }, {  77,-5268 },
 {  78,-5268 }, {  79,-5268 }, {  80,-5268 }, {  81,-5268 }, {  82,-5268 },
 {  83,-5268 }, {  84,-5268 }, {  85,-5268 }, {  86,-5268 }, {  87,-5268 },

 {  88,-5268 }, {  89,-5268 }, {  90,-5268 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-5268 }, {   0,   0 }, {  97,-5268 },
 {  98,-5268 }, {  99,-5268 }, { 100,-5268 }, { 101,-5268 }, { 102,-5268 },
 { 103,-5268 }, { 104,-5268 }, { 105,-5268 }, { 106,-5268 }, { 107,-5268 },
 { 108,-5268 }, { 109,-5268 }, { 110,-5268 }, { 111,-5268 }, { 112,-5268 },
 { 113,-5268 }, { 114,-5268 }, { 115,-5268 }, { 116,-5268 }, { 117,-5268 },
 { 118,-5268 }, { 119,-5268 }, { 120,-5268 }, { 121,-5268 }, { 122,-5268 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-5268 }, { 129,-5268 }, { 130,-5268 }, { 131,-5268 }, { 132,-5268 },
 { 133,-5268 }, { 134,-5268 }, { 135,-5268 }, { 136,-5268 }, { 137,-5268 },

 { 138,-5268 }, { 139,-5268 }, { 140,-5268 }, { 141,-5268 }, { 142,-5268 },
 { 143,-5268 }, { 144,-5268 }, { 145,-5268 }, { 146,-5268 }, { 147,-5268 },
 { 148,-5268 }, { 149,-5268 }, { 150,-5268 }, { 151,-5268 }, { 152,-5268 },
 { 153,-5268 }, { 154,-5268 }, { 155,-5268 }, { 156,-5268 }, { 157,-5268 },
 { 158,-5268 }, { 159,-5268 }, { 160,-5268 }, { 161,-5268 }, { 162,-5268 },
 { 163,-5268 }, { 164,-5268 }, { 165,-5268 }, { 166,-5268 }, { 167,-5268 },
 { 168,-5268 }, { 169,-5268 }, { 170,-5268 }, { 171,-5268 }, { 172,-5268 },
 { 173,-5268 }, { 174,-5268 }, { 175,-5268 }, { 176,-5268 }, { 177,-5268 },
 { 178,-5268 }, { 179,-5268 }, { 180,-5268 }, { 181,-5268 }, { 182,-5268 },
 { 183,-5268 }, { 184,-5268 }, { 185,-5268 }, { 186,-5268 }, { 187,-5268 },

 { 188,-5268 }, { 189,-5268 }, { 190,-5268 }, { 191,-5268 }, { 192,-5268 },
 { 193,-5268 }, { 194,-5268 }, { 195,-5268 }, { 196,-5268 }, { 197,-5268 },
 { 198,-5268 }, { 199,-5268 }, { 200,-5268 }, { 201,-5268 }, { 202,-5268 },
 { 203,-5268 }, { 204,-5268 }, { 205,-5268 }, { 206,-5268 }, { 207,-5268 },
 { 208,-5268 }, { 209,-5268 }, { 210,-5268 }, { 211,-5268 }, { 212,-5268 },
 { 213,-5268 }, { 214,-5268 }, { 215,-5268 }, { 216,-5268 }, { 217,-5268 },
 { 218,-5268 }, { 219,-5268 }, { 220,-5268 }, { 221,-5268 }, { 222,-5268 },
 { 223,-5268 }, { 224,-5268 }, { 225,-5268 }, { 226,-5268 }, { 227,-5268 },
 { 228,-5268 }, { 229,-5268 }, { 230,-5268 }, { 231,-5268 }, { 232,-5268 },
 { 233,-5268 }, { 234,-5268 }, { 235,-5268 }, { 236,-5268 }, { 237,-5268 },

 { 238,-5268 }, { 239,-5268 }, { 240,-5268 }, { 241,-5268 }, { 242,-5268 },
 { 243,-5268 }, { 244,-5268 }, { 245,-5268 }, { 246,-5268 }, { 247,-5268 },
 { 248,-5268 }, { 249,-5268 }, { 250,-5268 }, { 251,-5268 }, { 252,-5268 },
 { 253,-5268 }, { 254,-5268 }, { 255,-5268 }, {   0,  34 }, {   0,6957 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-5801 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,4298 }, {  49,4298 }, {  50,4298 },
 {  51,4298 }, {  52,4298 }, {  53,4298 }, {  54,4298 }, {  55,4298 },
 {  56,4298 }, {  57,4298 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4298 },
 {  66,4298 }, {  67,4298 }, {  68,4298 }, {  69,4298 }, {  70,4298 },
 {  71,4298 }, {  72,4298 }, {  73,4298 }, {  74,4298 }, {  75,4298 },
 {  76,4298 }, {  77,4298 }, {  78,4298 }, {  79,4298 }, {  80,4298 },

 {  81,4298 }, {  82,4298 }, {  83,4298 }, {  84,4298 }, {  85,4298 },
 {  86,4298 }, {  87,4298 }, {  88,4298 }, {  89,4298 }, {  90,4298 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4298 },
 {   0,   0 }, {  97,4298 }, {  98,4298 }, {  99,4298 }, { 100,4298 },
 { 101,4298 }, { 102,4298 }, { 103,4298 }, { 104,4298 }, { 105,4298 },
 { 106,4298 }, { 107,4298 }, { 108,4298 }, { 109,4298 }, { 110,4298 },
 { 111,4298 }, { 112,4298 }, { 113,4298 }, { 114,4298 }, { 115,4298 },
 { 116,4298 }, { 117,4298 }, { 118,4298 }, { 119,4298 }, { 120,4298 },
 { 121,4298 }, { 122,4298 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,4298 }, { 129,4298 }, { 130,4298 },

 { 131,4298 }, { 132,4298 }, { 133,4298 }, { 134,4298 }, { 135,4298 },
 { 136,4298 }, { 137,4298 }, { 138,4298 }, { 139,4298 }, { 140,4298 },
 { 141,4298 }, { 142,4298 }, { 143,4298 }, { 144,4298 }, { 145,4298 },
 { 146,4298 }, { 147,4298 }, { 148,4298 }, { 149,4298 }, { 150,4298 },
 { 151,4298 }, { 152,4298 }, { 153,4298 }, { 154,4298 }, { 155,4298 },
 { 156,4298 }, { 157,4298 }, { 158,4298 }, { 159,4298 }, { 160,4298 },
 { 161,4298 }, { 162,4298 }, { 163,4298 }, { 164,4298 }, { 165,4298 },
 { 166,4298 }, { 167,4298 }, { 168,4298 }, { 169,4298 }, { 170,4298 },
 { 171,4298 }, { 172,4298 }, { 173,4298 }, { 174,4298 }, { 175,4298 },
 { 176,4298 }, { 177,4298 }, { 178,4298 }, { 179,4298 }, { 180,4298 },

 { 181,4298 }, { 182,4298 }, { 183,4298 }, { 184,4298 }, { 185,4298 },
 { 186,4298 }, { 187,4298 }, { 188,4298 }, { 189,4298 }, { 190,4298 },
 { 191,4298 }, { 192,4298 }, { 193,4298 }, { 194,4298 }, { 195,4298 },
 { 196,4298 }, { 197,4298 }, { 198,4298 }, { 199,4298 }, { 200,4298 },
 { 201,4298 }, { 202,4298 }, { 203,4298 }, { 204,4298 }, { 205,4298 },
 { 206,4298 }, { 207,4298 }, { 208,4298 }, { 209,4298 }, { 210,4298 },
 { 211,4298 }, { 212,4298 }, { 213,4298 }, { 214,4298 }, { 215,4298 },
 { 216,4298 }, { 217,4298 }, { 218,4298 }, { 219,4298 }, { 220,4298 },
 { 221,4298 }, { 222,4298 }, { 223,4298 }, { 224,4298 }, { 225,4298 },
 { 226,4298 }, { 227,4298 }, { 228,4298 }, { 229,4298 }, { 230,4298 },

 { 231,4298 }, { 232,4298 }, { 233,4298 }, { 234,4298 }, { 235,4298 },
 { 236,4298 }, { 237,4298 }, { 238,4298 }, { 239,4298 }, { 240,4298 },
 { 241,4298 }, { 242,4298 }, { 243,4298 }, { 244,4298 }, { 245,4298 },
 { 246,4298 }, { 247,4298 }, { 248,4298 }, { 249,4298 }, { 250,4298 },
 { 251,4298 }, { 252,4298 }, { 253,4298 }, { 254,4298 }, { 255,4298 },
 {   0,   2 }, {   0,6700 }, {   1,4298 }, {   2,4298 }, {   3,4298 },
 {   4,4298 }, {   5,4298 }, {   6,4298 }, {   7,4298 }, {   8,4298 },
 {   9,4298 }, {   0,   0 }, {  11,4298 }, {  12,4298 }, {   0,   0 },
 {  14,4298 }, {  15,4298 }, {  16,4298 }, {  17,4298 }, {  18,4298 },
 {  19,4298 }, {  20,4298 }, {  21,4298 }, {  22,4298 }, {  23,4298 },

 {  24,4298 }, {  25,4298 }, {  26,4298 }, {  27,4298 }, {  28,4298 },
 {  29,4298 }, {  30,4298 }, {  31,4298 }, {  32,4298 }, {  33,4556 },
 {  34,4298 }, {  35,4556 }, {  36,4298 }, {  37,4556 }, {  38,4556 },
 {  39,4298 }, {  40,4298 }, {  41,4298 }, {  42,4556 }, {  43,4556 },
 {  44,4298 }, {  45,4556 }, {  46,4298 }, {  47,4556 }, {  48,4298 },
 {  49,4298 }, {  50,4298 }, {  51,4298 }, {  52,4298 }, {  53,4298 },
 {  54,4298 }, {  55,4298 }, {  56,4298 }, {  57,4298 }, {  58,4298 },
 {  59,4298 }, {  60,4556 }, {  61,4556 }, {  62,4556 }, {  63,4556 },
 {  64,4556 }, {  65,4298 }, {  66,4298 }, {  67,4298 }, {  68,4298 },
 {  69,4298 }, {  70,4298 }, {  71,4298 }, {  72,4298 }, {  73,4298 },

 {  74,4298 }, {  75,4298 }, {  76,4298 }, {  77,4298 }, {  78,4298 },
 {  79,4298 }, {  80,4298 }, {  81,4298 }, {  82,4298 }, {  83,4298 },
 {  84,4298 }, {  85,4298 }, {  86,4298 }, {  87,4298 }, {  88,4298 },
 {  89,4298 }, {  90,4298 }, {  91,4298 }, {  92,4298 }, {  93,4298 },
 {  94,4556 }, {  95,4298 }, {  96,4556 }, {  97,4298 }, {  98,4298 },
 {  99,4298 }, { 100,4298 }, { 101,4298 }, { 102,4298 }, { 103,4298 },
 { 104,4298 }, { 105,4298 }, { 106,4298 }, { 107,4298 }, { 108,4298 },
 { 109,4298 }, { 110,4298 }, { 111,4298 }, { 112,4298 }, { 113,4298 },
 { 114,4298 }, { 115,4298 }, { 116,4298 }, { 117,4298 }, { 118,4298 },
 { 119,4298 }, { 120,4298 }, { 121,4298 }, { 122,4298 }, { 123,4298 },

 { 124,4556 }, { 125,4298 }, { 126,4556 }, { 127,4298 }, { 128,4298 },
 { 129,4298 }, { 130,4298 }, { 131,4298 }, { 132,4298 }, { 133,4298 },
 { 134,4298 }, { 135,4298 }, { 136,4298 }, { 137,4298 }, { 138,4298 },
 { 139,4298 }, { 140,4298 }, { 141,4298 }, { 142,4298 }, { 143,4298 },
 { 144,4298 }, { 145,4298 }, { 146,4298 }, { 147,4298 }, { 148,4298 },
 { 149,4298 }, { 150,4298 }, { 151,4298 }, { 152,4298 }, { 153,4298 },
 { 154,4298 }, { 155,4298 }, { 156,4298 }, { 157,4298 }, { 158,4298 },
 { 159,4298 }, { 160,4298 }, { 161,4298 }, { 162,4298 }, { 163,4298 },
 { 164,4298 }, { 165,4298 }, { 166,4298 }, { 167,4298 }, { 168,4298 },
 { 169,4298 }, { 170,4298 }, { 171,4298 }, { 172,4298 }, { 173,4298 },

 { 174,4298 }, { 175,4298 }, { 176,4298 }, { 177,4298 }, { 178,4298 },
 { 179,4298 }, { 180,4298 }, { 181,4298 }, { 182,4298 }, { 183,4298 },
 { 184,4298 }, { 185,4298 }, { 186,4298 }, { 187,4298 }, { 188,4298 },
 { 189,4298 }, { 190,4298 }, { 191,4298 }, { 192,4298 }, { 193,4298 },
 { 194,4298 }, { 195,4298 }, { 196,4298 }, { 197,4298 }, { 198,4298 },
 { 199,4298 }, { 200,4298 }, { 201,4298 }, { 202,4298 }, { 203,4298 },
 { 204,4298 }, { 205,4298 }, { 206,4298 }, { 207,4298 }, { 208,4298 },
 { 209,4298 }, { 210,4298 }, { 211,4298 }, { 212,4298 }, { 213,4298 },
 { 214,4298 }, { 215,4298 }, { 216,4298 }, { 217,4298 }, { 218,4298 },
 { 219,4298 }, { 220,4298 }, { 221,4298 }, { 222,4298 }, { 223,4298 },

 { 224,4298 }, { 225,4298 }, { 226,4298 }, { 227,4298 }, { 228,4298 },
 { 229,4298 }, { 230,4298 }, { 231,4298 }, { 232,4298 }, { 233,4298 },
 { 234,4298 }, { 235,4298 }, { 236,4298 }, { 237,4298 }, { 238,4298 },
 { 239,4298 }, { 240,4298 }, { 241,4298 }, { 242,4298 }, { 243,4298 },
 { 244,4298 }, { 245,4298 }, { 246,4298 }, { 247,4298 }, { 248,4298 },
 { 249,4298 }, { 250,4298 }, { 251,4298 }, { 252,4298 }, { 253,4298 },
 { 254,4298 }, { 255,4298 }, { 256,4298 }, {   0,  59 }, {   0,6442 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-6035 },

 {  66,-6035 }, {  67,-6035 }, {  68,-6035 }, {  69,4556 }, {  70,-6035 },
 {  71,-6035 }, {  72,-6035 }, {  73,-6035 }, {  74,-6035 }, {  75,-6035 },
 {  76,-6035 }, {  77,-6035 }, {  78,-6035 }, {  79,-6035 }, {  80,-6035 },
 {  81,-6035 }, {  82,-6035 }, {  83,-6035 }, {  84,-6035 }, {  85,-6035 },
 {  86,-6035 }, {  87,-6035 }, {  88,-6035 }, {  89,-6035 }, {  90,-6035 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-6035 },
 {   0,   0 }, {  97,-6035 }, {  98,-6035 }, {  99,-6035 }, { 100,-6035 },
 { 101,4556 }, { 102,-6035 }, { 103,-6035 }, { 104,-6035 }, { 105,-6035 },
 { 106,-6035 }, { 107,-6035 }, { 108,-6035 }, { 109,-6035 }, { 110,-6035 },
 { 111,-6035 }, { 112,-6035 }, { 113,-6035 }, { 114,-6035 }, { 115,-6035 },

 { 116,-6035 }, { 117,-6035 }, { 118,-6035 }, { 119,-6035 }, { 120,-6035 },
 { 121,-6035 }, { 122,-6035 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-6035 }, { 129,-6035 }, { 130,-6035 },
 { 131,-6035 }, { 132,-6035 }, { 133,-6035 }, { 134,-6035 }, { 135,-6035 },
 { 136,-6035 }, { 137,-6035 }, { 138,-6035 }, { 139,-6035 }, { 140,-6035 },
 { 141,-6035 }, { 142,-6035 }, { 143,-6035 }, { 144,-6035 }, { 145,-6035 },
 { 146,-6035 }, { 147,-6035 }, { 148,-6035 }, { 149,-6035 }, { 150,-6035 },
 { 151,-6035 }, { 152,-6035 }, { 153,-6035 }, { 154,-6035 }, { 155,-6035 },
 { 156,-6035 }, { 157,-6035 }, { 158,-6035 }, { 159,-6035 }, { 160,-6035 },
 { 161,-6035 }, { 162,-6035 }, { 163,-6035 }, { 164,-6035 }, { 165,-6035 },

 { 166,-6035 }, { 167,-6035 }, { 168,-6035 }, { 169,-6035 }, { 170,-6035 },
 { 171,-6035 }, { 172,-6035 }, { 173,-6035 }, { 174,-6035 }, { 175,-6035 },
 { 176,-6035 }, { 177,-6035 }, { 178,-6035 }, { 179,-6035 }, { 180,-6035 },
 { 181,-6035 }, { 182,-6035 }, { 183,-6035 }, { 184,-6035 }, { 185,-6035 },
 { 186,-6035 }, { 187,-6035 }, { 188,-6035 }, { 189,-6035 }, { 190,-6035 },
 { 191,-6035 }, { 192,-6035 }, { 193,-6035 }, { 194,-6035 }, { 195,-6035 },
 { 196,-6035 }, { 197,-6035 }, { 198,-6035 }, { 199,-6035 }, { 200,-6035 },
 { 201,-6035 }, { 202,-6035 }, { 203,-6035 }, { 204,-6035 }, { 205,-6035 },
 { 206,-6035 }, { 207,-6035 }, { 208,-6035 }, { 209,-6035 }, { 210,-6035 },
 { 211,-6035 }, { 212,-6035 }, { 213,-6035 }, { 214,-6035 }, { 215,-6035 },

 { 216,-6035 }, { 217,-6035 }, { 218,-6035 }, { 219,-6035 }, { 220,-6035 },
 { 221,-6035 }, { 222,-6035 }, { 223,-6035 }, { 224,-6035 }, { 225,-6035 },
 { 226,-6035 }, { 227,-6035 }, { 228,-6035 }, { 229,-6035 }, { 230,-6035 },
 { 231,-6035 }, { 232,-6035 }, { 233,-6035 }, { 234,-6035 }, { 235,-6035 },
 { 236,-6035 }, { 237,-6035 }, { 238,-6035 }, { 239,-6035 }, { 240,-6035 },
 { 241,-6035 }, { 242,-6035 }, { 243,-6035 }, { 244,-6035 }, { 245,-6035 },
 { 246,-6035 }, { 247,-6035 }, { 248,-6035 }, { 249,-6035 }, { 250,-6035 },
 { 251,-6035 }, { 252,-6035 }, { 253,-6035 }, { 254,-6035 }, { 255,-6035 },
 {   0,   3 }, {   0,6185 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  59 }, {   0,6153 }, {  33,4324 },
 {   0,   0 }, {  35,4324 }, {   0,   0 }, {  37,4324 }, {  38,4324 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4324 }, {  43,4324 },
 {   0,   0 }, {  45,4324 }, {   0,   0 }, {  47,4324 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  60,4324 }, {  61,4324 }, {  62,4324 }, {  63,4324 },
 {  64,4324 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,-6316 },
 {   0,   0 }, {  48,4358 }, {  49,4358 }, {  50,4358 }, {  51,4358 },
 {  52,4358 }, {  53,4358 }, {  54,4358 }, {  55,4358 }, {  56,4358 },
 {  57,4358 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,4324 }, {   0,   0 }, {  96,4324 }, {  65,-6324 }, {  66,-6324 },
 {  67,-6324 }, {  68,-6324 }, {  69,4267 }, {  70,-6324 }, {  71,-6324 },
 {  72,-6324 }, {  73,-6324 }, {  74,-6324 }, {  75,-6324 }, {  76,-6324 },

 {  77,-6324 }, {  78,-6324 }, {  79,-6324 }, {  80,-6324 }, {  81,-6324 },
 {  82,-6324 }, {  83,-6324 }, {  84,-6324 }, {  85,-6324 }, {  86,-6324 },
 {  87,-6324 }, {  88,-6324 }, {  89,-6324 }, {  90,-6324 }, {   0,   0 },
 { 124,4324 }, {   0,   0 }, { 126,4324 }, {  95,-6324 }, {   0,   0 },
 {  97,-6324 }, {  98,-6324 }, {  99,-6324 }, { 100,-6324 }, { 101,4267 },
 { 102,-6324 }, { 103,-6324 }, { 104,-6324 }, { 105,-6324 }, { 106,-6324 },
 { 107,-6324 }, { 108,-6324 }, { 109,-6324 }, { 110,-6324 }, { 111,-6324 },
 { 112,-6324 }, { 113,-6324 }, { 114,-6324 }, { 115,-6324 }, { 116,-6324 },
 { 117,-6324 }, { 118,-6324 }, { 119,-6324 }, { 120,-6324 }, { 121,-6324 },
 { 122,-6324 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, { 128,-6324 }, { 129,-6324 }, { 130,-6324 }, { 131,-6324 },
 { 132,-6324 }, { 133,-6324 }, { 134,-6324 }, { 135,-6324 }, { 136,-6324 },
 { 137,-6324 }, { 138,-6324 }, { 139,-6324 }, { 140,-6324 }, { 141,-6324 },
 { 142,-6324 }, { 143,-6324 }, { 144,-6324 }, { 145,-6324 }, { 146,-6324 },
 { 147,-6324 }, { 148,-6324 }, { 149,-6324 }, { 150,-6324 }, { 151,-6324 },
 { 152,-6324 }, { 153,-6324 }, { 154,-6324 }, { 155,-6324 }, { 156,-6324 },
 { 157,-6324 }, { 158,-6324 }, { 159,-6324 }, { 160,-6324 }, { 161,-6324 },
 { 162,-6324 }, { 163,-6324 }, { 164,-6324 }, { 165,-6324 }, { 166,-6324 },
 { 167,-6324 }, { 168,-6324 }, { 169,-6324 }, { 170,-6324 }, { 171,-6324 },
 { 172,-6324 }, { 173,-6324 }, { 174,-6324 }, { 175,-6324 }, { 176,-6324 },

 { 177,-6324 }, { 178,-6324 }, { 179,-6324 }, { 180,-6324 }, { 181,-6324 },
 { 182,-6324 }, { 183,-6324 }, { 184,-6324 }, { 185,-6324 }, { 186,-6324 },
 { 187,-6324 }, { 188,-6324 }, { 189,-6324 }, { 190,-6324 }, { 191,-6324 },
 { 192,-6324 }, { 193,-6324 }, { 194,-6324 }, { 195,-6324 }, { 196,-6324 },
 { 197,-6324 }, { 198,-6324 }, { 199,-6324 }, { 200,-6324 }, { 201,-6324 },
 { 202,-6324 }, { 203,-6324 }, { 204,-6324 }, { 205,-6324 }, { 206,-6324 },
 { 207,-6324 }, { 208,-6324 }, { 209,-6324 }, { 210,-6324 }, { 211,-6324 },
 { 212,-6324 }, { 213,-6324 }, { 214,-6324 }, { 215,-6324 }, { 216,-6324 },
 { 217,-6324 }, { 218,-6324 }, { 219,-6324 }, { 220,-6324 }, { 221,-6324 },
 { 222,-6324 }, { 223,-6324 }, { 224,-6324 }, { 225,-6324 }, { 226,-6324 },

 { 227,-6324 }, { 228,-6324 }, { 229,-6324 }, { 230,-6324 }, { 231,-6324 },
 { 232,-6324 }, { 233,-6324 }, { 234,-6324 }, { 235,-6324 }, { 236,-6324 },
 { 237,-6324 }, { 238,-6324 }, { 239,-6324 }, { 240,-6324 }, { 241,-6324 },
 { 242,-6324 }, { 243,-6324 }, { 244,-6324 }, { 245,-6324 }, { 246,-6324 },
 { 247,-6324 }, { 248,-6324 }, { 249,-6324 }, { 250,-6324 }, { 251,-6324 },
 { 252,-6324 }, { 253,-6324 }, { 254,-6324 }, { 255,-6324 }, {   0,  58 },
 {   0,5896 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,-257 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-6858 }, {  66,-6858 }, {  67,-6858 }, {  68,-6858 }, {  69, 257 },

 {  70,-6858 }, {  71,-6858 }, {  72,-6858 }, {  73,-6858 }, {  74,-6858 },
 {  75,-6858 }, {  76,-6858 }, {  77,-6858 }, {  78,-6858 }, {  79,-6858 },
 {  80,-6858 }, {  81,-6858 }, {  82,-6858 }, {  83,-6858 }, {  84,-6858 },
 {  85,-6858 }, {  86,-6858 }, {  87,-6858 }, {  88,-6858 }, {  89,-6858 },
 {  90,-6858 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-6858 }, {   0,   0 }, {  97,-6858 }, {  98,-6858 }, {  99,-6858 },
 { 100,-6858 }, { 101, 257 }, { 102,-6858 }, { 103,-6858 }, { 104,-6858 },
 { 105,-6858 }, { 106,-6858 }, { 107,-6858 }, { 108,-6858 }, { 109,-6858 },
 { 110,-6858 }, { 111,-6858 }, { 112,-6858 }, { 113,-6858 }, { 114,-6858 },
 { 115,-6858 }, { 116,-6858 }, { 117,-6858 }, { 118,-6858 }, { 119,-6858 },

 { 120,-6858 }, { 121,-6858 }, { 122,-6858 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-6858 }, { 129,-6858 },
 { 130,-6858 }, { 131,-6858 }, { 132,-6858 }, { 133,-6858 }, { 134,-6858 },
 { 135,-6858 }, { 136,-6858 }, { 137,-6858 }, { 138,-6858 }, { 139,-6858 },
 { 140,-6858 }, { 141,-6858 }, { 142,-6858 }, { 143,-6858 }, { 144,-6858 },
 { 145,-6858 }, { 146,-6858 }, { 147,-6858 }, { 148,-6858 }, { 149,-6858 },
 { 150,-6858 }, { 151,-6858 }, { 152,-6858 }, { 153,-6858 }, { 154,-6858 },
 { 155,-6858 }, { 156,-6858 }, { 157,-6858 }, { 158,-6858 }, { 159,-6858 },
 { 160,-6858 }, { 161,-6858 }, { 162,-6858 }, { 163,-6858 }, { 164,-6858 },
 { 165,-6858 }, { 166,-6858 }, { 167,-6858 }, { 168,-6858 }, { 169,-6858 },

 { 170,-6858 }, { 171,-6858 }, { 172,-6858 }, { 173,-6858 }, { 174,-6858 },
 { 175,-6858 }, { 176,-6858 }, { 177,-6858 }, { 178,-6858 }, { 179,-6858 },
 { 180,-6858 }, { 181,-6858 }, { 182,-6858 }, { 183,-6858 }, { 184,-6858 },
 { 185,-6858 }, { 186,-6858 }, { 187,-6858 }, { 188,-6858 }, { 189,-6858 },
 { 190,-6858 }, { 191,-6858 }, { 192,-6858 }, { 193,-6858 }, { 194,-6858 },
 { 195,-6858 }, { 196,-6858 }, { 197,-6858 }, { 198,-6858 }, { 199,-6858 },
 { 200,-6858 }, { 201,-6858 }, { 202,-6858 }, { 203,-6858 }, { 204,-6858 },
 { 205,-6858 }, { 206,-6858 }, { 207,-6858 }, { 208,-6858 }, { 209,-6858 },
 { 210,-6858 }, { 211,-6858 }, { 212,-6858 }, { 213,-6858 }, { 214,-6858 },
 { 215,-6858 }, { 216,-6858 }, { 217,-6858 }, { 218,-6858 }, { 219,-6858 },

 { 220,-6858 }, { 221,-6858 }, { 222,-6858 }, { 223,-6858 }, { 224,-6858 },
 { 225,-6858 }, { 226,-6858 }, { 227,-6858 }, { 228,-6858 }, { 229,-6858 },
 { 230,-6858 }, { 231,-6858 }, { 232,-6858 }, { 233,-6858 }, { 234,-6858 },
 { 235,-6858 }, { 236,-6858 }, { 237,-6858 }, { 238,-6858 }, { 239,-6858 },
 { 240,-6858 }, { 241,-6858 }, { 242,-6858 }, { 243,-6858 }, { 244,-6858 },
 { 245,-6858 }, { 246,-6858 }, { 247,-6858 }, { 248,-6858 }, { 249,-6858 },
 { 250,-6858 }, { 251,-6858 }, { 252,-6858 }, { 253,-6858 }, { 254,-6858 },
 { 255,-6858 }, {   0,  63 }, {   0,5639 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  50 }, {   0,5614 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  52 }, {   0,5603 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  43,4101 }, {   0,   0 }, {  45,4101 }, {   0,   0 }, {   0,   0 },
 {  48,4111 }, {  49,4111 }, {  50,4111 }, {  51,4111 }, {  52,4111 },
 {  53,4111 }, {  54,4111 }, {  55,4111 }, {  56,4111 }, {  57,4111 },
 {  33,-1690 }, {   0,   0 }, {  35,-1690 }, {   0,   0 }, {  37,-1690 },

 {  38,-1690 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-1690 },
 {  43,-1690 }, {  33,-1701 }, {  45,-1690 }, {  35,-1701 }, {  47,-1690 },
 {  37,-1701 }, {  38,-1701 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,-1701 }, {  43,-1701 }, {   0,   0 }, {  45,-1701 }, {   0,   0 },
 {  47,-1701 }, {   0,   0 }, {  60,-1690 }, {  61,-1690 }, {  62,-1690 },
 {  63,-1690 }, {  64,-1690 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,-1701 }, {  61,-1701 },
 {  62,-1701 }, {  63,-1701 }, {  64,-1701 }, {   0,   0 }, {   0,  49 },
 {   0,5536 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-1690 }, {   0,   0 }, {  96,-1690 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-1701 }, {   0,   0 }, {  96,-1701 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-1768 }, {   0,   0 },
 {  35,-1768 }, {   0,   0 }, {  37,-1768 }, {  38,-1768 }, {   0,  51 },
 {   0,5496 }, {   0,   0 }, {  42,-1768 }, {  43,-1768 }, {   0,   0 },
 {  45,-1768 }, { 124,-1690 }, {  47,-1768 }, { 126,-1690 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 124,-1701 }, {   0,   0 }, { 126,-1701 },

 {  60,-1768 }, {  61,-1768 }, {  62,-1768 }, {  63,-1768 }, {  64,-1768 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-1808 }, {   0,   0 },
 {  35,-1808 }, {   0,   0 }, {  37,-1808 }, {  38,-1808 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,-1808 }, {  43,-1808 }, {   0,   0 },
 {  45,-1808 }, {   0,   0 }, {  47,-1808 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-1768 },
 {   0,   0 }, {  96,-1768 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,-1808 }, {  61,-1808 }, {  62,-1808 }, {  63,-1808 }, {  64,-1808 },
 {   0,  66 }, {   0,5430 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,-1768 },
 {   0,   0 }, { 126,-1768 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-1808 },
 {   0,   0 }, {  96,-1808 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },

 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, { 124,-1808 },
 {   0,   0 }, { 126,-1808 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },

 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },

 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },

 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },

 { 254,   0 }, { 255,   0 }, {   0,  11 }, {   0,5173 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },

 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },

 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },

 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },

 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },

 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,   6 }, {   0,4915 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },
 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },

 {  39,   0 }, {  40,   0 }, {  41,   0 }, {   0,   0 }, {  43,   0 },
 {  44,   0 }, {  45,   0 }, {  46,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },

 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },

 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },

 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },

 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,   4 }, {   0,4657 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  33,3386 }, {   0,   0 }, {  35,3386 },
 {   0,   0 }, {  37,3386 }, {  38,3386 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,3386 }, {  43,3386 }, {   0,   0 }, {  45,3386 },
 {   0,   0 }, {  47,3386 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,3386 },
 {  61,3386 }, {  62,3386 }, {  63,3386 }, {  64,3386 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,3386 }, {   0,   0 },
 {  96,3386 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,3386 }, {   0,   0 },
 { 126,3386 }, {   0,  44 }, {   0,4529 }, {   1,   0 }, {   2,   0 },

 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {   0,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },

 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },

 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },

 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },

 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },

 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  10 },
 {   0,4271 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },

 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },

 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },

 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },

 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },

 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  22 }, {   0,4013 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },

 {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },

 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },

 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },

 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },

 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  19 }, {   0,3755 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  19 }, {   0,3750 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,   0 }, {  10,   5 }, {   0,   0 }, {  12,   0 }, {  13,   5 },
 {   9,  16 }, {  10,  16 }, {   0,   0 }, {  12,  16 }, {  13,  16 },
 {   0,   0 }, {   0,  19 }, {   0,3734 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   9,   0 }, {  10,   0 }, {  32,   0 }, {  12,   0 },
 {  13,   0 }, {   0,   0 }, {   0,   0 }, {  32,  16 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-8738 }, {  45,-8735 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-8740 }, {   0,   0 }, {   0,   0 }, {  32,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-8754 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-8756 }, {   0,  23 }, {   0,3687 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },

 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },

 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {   0,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },

 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },

 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },

 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  30 }, {   0,3429 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 },
 {   0,3421 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,3398 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,2160 }, {  49,2160 }, {  50,2160 }, {  51,2160 }, {  52,2160 },

 {  53,2160 }, {  54,2160 }, {  55,2160 }, {  48,2167 }, {  49,2167 },
 {  50,2167 }, {  51,2167 }, {  52,2167 }, {  53,2167 }, {  54,2167 },
 {  55,2167 }, {  56,2167 }, {  57,2167 }, {   0,   0 }, {   0,   0 },
 {   0,  29 }, {   0,3360 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,2167 }, {  66,2167 }, {  67,2167 }, {  68,2167 }, {  69,2167 },
 {  70,2167 }, {  48,2206 }, {  49,2206 }, {  50,2206 }, {  51,2206 },
 {  52,2206 }, {  53,2206 }, {  54,2206 }, {  55,2206 }, {  56,2206 },
 {  57,2206 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2206 }, {  66,2206 },
 {  67,2206 }, {  68,2206 }, {  69,2206 }, {  70,2206 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  97,2167 }, {  98,2167 }, {  99,2167 },
 { 100,2167 }, { 101,2167 }, { 102,2167 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2191 },
 {  49,2191 }, {  50,2191 }, {  51,2191 }, {  52,2191 }, {  53,2191 },
 {  54,2191 }, {  55,2191 }, {  56,2191 }, {  57,2191 }, {   0,   0 },
 {  97,2206 }, {  98,2206 }, {  99,2206 }, { 100,2206 }, { 101,2206 },
 { 102,2206 }, {  65,2191 }, {  66,2191 }, {  67,2191 }, {  68,2191 },
 {  69,2191 }, {  70,2191 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,2191 }, {  98,2191 },
 {  99,2191 }, { 100,2191 }, { 101,2191 }, { 102,2191 }, {   0,  36 },
 {   0,3256 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },

 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },

 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },

 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },

 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },

 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  37 }, {   0,2998 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-9486 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,1888 }, {  49,1888 }, {  50,1888 }, {  51,1888 },
 {  52,1888 }, {  53,1888 }, {  54,1888 }, {  55,1888 }, {  56,1888 },
 {  57,1888 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1888 }, {  66,1888 },
 {  67,1888 }, {  68,1888 }, {  69,1888 }, {  70,1888 }, {  71,1888 },

 {  72,1888 }, {  73,1888 }, {  74,1888 }, {  75,1888 }, {  76,1888 },
 {  77,1888 }, {  78,1888 }, {  79,1888 }, {  80,1888 }, {  81,1888 },
 {  82,1888 }, {  83,1888 }, {  84,1888 }, {  85,1888 }, {  86,1888 },
 {  87,1888 }, {  88,1888 }, {  89,1888 }, {  90,1888 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,1888 }, {   0,   0 },
 {  97,1888 }, {  98,1888 }, {  99,1888 }, { 100,1888 }, { 101,1888 },
 { 102,1888 }, { 103,1888 }, { 104,1888 }, { 105,1888 }, { 106,1888 },
 { 107,1888 }, { 108,1888 }, { 109,1888 }, { 110,1888 }, { 111,1888 },
 { 112,1888 }, { 113,1888 }, { 114,1888 }, { 115,1888 }, { 116,1888 },
 { 117,1888 }, { 118,1888 }, { 119,1888 }, { 120,1888 }, { 121,1888 },

 { 122,1888 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,1888 }, { 129,1888 }, { 130,1888 }, { 131,1888 },
 { 132,1888 }, { 133,1888 }, { 134,1888 }, { 135,1888 }, { 136,1888 },
 { 137,1888 }, { 138,1888 }, { 139,1888 }, { 140,1888 }, { 141,1888 },
 { 142,1888 }, { 143,1888 }, { 144,1888 }, { 145,1888 }, { 146,1888 },
 { 147,1888 }, { 148,1888 }, { 149,1888 }, { 150,1888 }, { 151,1888 },
 { 152,1888 }, { 153,1888 }, { 154,1888 }, { 155,1888 }, { 156,1888 },
 { 157,1888 }, { 158,1888 }, { 159,1888 }, { 160,1888 }, { 161,1888 },
 { 162,1888 }, { 163,1888 }, { 164,1888 }, { 165,1888 }, { 166,1888 },
 { 167,1888 }, { 168,1888 }, { 169,1888 }, { 170,1888 }, { 171,1888 },

 { 172,1888 }, { 173,1888 }, { 174,1888 }, { 175,1888 }, { 176,1888 },
 { 177,1888 }, { 178,1888 }, { 179,1888 }, { 180,1888 }, { 181,1888 },
 { 182,1888 }, { 183,1888 }, { 184,1888 }, { 185,1888 }, { 186,1888 },
 { 187,1888 }, { 188,1888 }, { 189,1888 }, { 190,1888 }, { 191,1888 },
 { 192,1888 }, { 193,1888 }, { 194,1888 }, { 195,1888 }, { 196,1888 },
 { 197,1888 }, { 198,1888 }, { 199,1888 }, { 200,1888 }, { 201,1888 },
 { 202,1888 }, { 203,1888 }, { 204,1888 }, { 205,1888 }, { 206,1888 },
 { 207,1888 }, { 208,1888 }, { 209,1888 }, { 210,1888 }, { 211,1888 },
 { 212,1888 }, { 213,1888 }, { 214,1888 }, { 215,1888 }, { 216,1888 },
 { 217,1888 }, { 218,1888 }, { 219,1888 }, { 220,1888 }, { 221,1888 },

 { 222,1888 }, { 223,1888 }, { 224,1888 }, { 225,1888 }, { 226,1888 },
 { 227,1888 }, { 228,1888 }, { 229,1888 }, { 230,1888 }, { 231,1888 },
 { 232,1888 }, { 233,1888 }, { 234,1888 }, { 235,1888 }, { 236,1888 },
 { 237,1888 }, { 238,1888 }, { 239,1888 }, { 240,1888 }, { 241,1888 },
 { 242,1888 }, { 243,1888 }, { 244,1888 }, { 245,1888 }, { 246,1888 },
 { 247,1888 }, { 248,1888 }, { 249,1888 }, { 250,1888 }, { 251,1888 },
 { 252,1888 }, { 253,1888 }, { 254,1888 }, { 255,1888 }, {   0,  28 },
 {   0,2741 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,2718 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,1888 }, {  49,1888 },
 {  50,1888 }, {  51,1888 }, {  52,1888 }, {  53,1888 }, {  54,1888 },
 {  55,1888 }, {  56,1888 }, {  57,1888 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  65,1888 }, {  66,1888 }, {  67,1888 }, {  68,1888 }, {  69,1888 },
 {  70,1888 }, {  48,1888 }, {  49,1888 }, {  50,1888 }, {  51,1888 },
 {  52,1888 }, {  53,1888 }, {  54,1888 }, {  55,1888 }, {  56,1888 },
 {  57,1888 }, {   0,  34 }, {   0,2659 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1888 }, {  66,1888 },
 {  67,1888 }, {  68,1888 }, {  69,1888 }, {  70,1888 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,1888 }, {  98,1888 }, {  99,1888 },
 { 100,1888 }, { 101,1888 }, { 102,1888 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-10099 }, {   0,   0 },
 {  97,1888 }, {  98,1888 }, {  99,1888 }, { 100,1888 }, { 101,1888 },
 { 102,1888 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },

 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },

 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },

 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },

 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,   2 }, {   0,2402 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {   0,   0 },
 {  11,   0 }, {  12,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },

 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },

 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },

 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },

 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },

 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,   2 }, {   0,2144 }, {   1,-258 }, {   2,-258 },
 {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 },
 {   8,-258 }, {   9,-258 }, {   0,   0 }, {  11,-258 }, {  12,-258 },
 {   0,   0 }, {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 },

 {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 },
 {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 },
 {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,-258 },
 {  33,   0 }, {  34,-258 }, {  35,   0 }, {  36,-258 }, {  37,   0 },
 {  38,   0 }, {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,   0 },
 {  43,   0 }, {  44,-258 }, {  45,   0 }, {  46,-258 }, {  47,   0 },
 {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 },
 {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 },
 {  58,-258 }, {  59,-258 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 },

 {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 },
 {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 },
 {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 },
 {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 },
 {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 },
 {  93,-258 }, {  94,   0 }, {  95,-258 }, {  96,   0 }, {  97,-258 },
 {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 },
 { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 },
 { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 },
 { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 },

 { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 },
 { 123,-258 }, { 124,   0 }, { 125,-258 }, { 126,   0 }, { 127,-258 },
 { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 },
 { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 },
 { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 },
 { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 },
 { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 },
 { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 },
 { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 },
 { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 },

 { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 },
 { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 },
 { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 },
 { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 },
 { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 },
 { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 },
 { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 },
 { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 },
 { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 },
 { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 },

 { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 },
 { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 },
 { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 },
 { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 },
 { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 },
 { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 },
 { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 },
 { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  64 },
 {   0,1886 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   3 },
 {   0,1861 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  43, 348 }, {   0,   0 },
 {  45, 348 }, {   0,   0 }, {   0,   0 }, {  48, 358 }, {  49, 358 },
 {  50, 358 }, {  51, 358 }, {  52, 358 }, {  53, 358 }, {  54, 358 },
 {  55, 358 }, {  56, 358 }, {  57, 358 }, {  33,   0 }, {   0,   0 },

 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,   0 }, {  43,   0 }, {   0,   0 },
 {  45,   0 }, {   0,   0 }, {  47,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {   0,  59 }, {   0,1795 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 },
 {   0,   0 }, {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, { 124,   0 },
 {   0,   0 }, { 126,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-10682 }, {  66,-10682 }, {  67,-10682 }, {  68,-10682 },

 {  69, -91 }, {  70,-10682 }, {  71,-10682 }, {  72,-10682 }, {  73,-10682 },
 {  74,-10682 }, {  75,-10682 }, {  76,-10682 }, {  77,-10682 }, {  78,-10682 },
 {  79,-10682 }, {  80,-10682 }, {  81,-10682 }, {  82,-10682 }, {  83,-10682 },
 {  84,-10682 }, {  85,-10682 }, {  86,-10682 }, {  87,-10682 }, {  88,-10682 },
 {  89,-10682 }, {  90,-10682 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-10682 }, {   0,   0 }, {  97,-10682 }, {  98,-10682 },
 {  99,-10682 }, { 100,-10682 }, { 101, -91 }, { 102,-10682 }, { 103,-10682 },
 { 104,-10682 }, { 105,-10682 }, { 106,-10682 }, { 107,-10682 }, { 108,-10682 },
 { 109,-10682 }, { 110,-10682 }, { 111,-10682 }, { 112,-10682 }, { 113,-10682 },
 { 114,-10682 }, { 115,-10682 }, { 116,-10682 }, { 117,-10682 }, { 118,-10682 },

 { 119,-10682 }, { 120,-10682 }, { 121,-10682 }, { 122,-10682 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-10682 },
 { 129,-10682 }, { 130,-10682 }, { 131,-10682 }, { 132,-10682 }, { 133,-10682 },
 { 134,-10682 }, { 135,-10682 }, { 136,-10682 }, { 137,-10682 }, { 138,-10682 },
 { 139,-10682 }, { 140,-10682 }, { 141,-10682 }, { 142,-10682 }, { 143,-10682 },
 { 144,-10682 }, { 145,-10682 }, { 146,-10682 }, { 147,-10682 }, { 148,-10682 },
 { 149,-10682 }, { 150,-10682 }, { 151,-10682 }, { 152,-10682 }, { 153,-10682 },
 { 154,-10682 }, { 155,-10682 }, { 156,-10682 }, { 157,-10682 }, { 158,-10682 },
 { 159,-10682 }, { 160,-10682 }, { 161,-10682 }, { 162,-10682 }, { 163,-10682 },
 { 164,-10682 }, { 165,-10682 }, { 166,-10682 }, { 167,-10682 }, { 168,-10682 },

 { 169,-10682 }, { 170,-10682 }, { 171,-10682 }, { 172,-10682 }, { 173,-10682 },
 { 174,-10682 }, { 175,-10682 }, { 176,-10682 }, { 177,-10682 }, { 178,-10682 },
 { 179,-10682 }, { 180,-10682 }, { 181,-10682 }, { 182,-10682 }, { 183,-10682 },
 { 184,-10682 }, { 185,-10682 }, { 186,-10682 }, { 187,-10682 }, { 188,-10682 },
 { 189,-10682 }, { 190,-10682 }, { 191,-10682 }, { 192,-10682 }, { 193,-10682 },
 { 194,-10682 }, { 195,-10682 }, { 196,-10682 }, { 197,-10682 }, { 198,-10682 },
 { 199,-10682 }, { 200,-10682 }, { 201,-10682 }, { 202,-10682 }, { 203,-10682 },
 { 204,-10682 }, { 205,-10682 }, { 206,-10682 }, { 207,-10682 }, { 208,-10682 },
 { 209,-10682 }, { 210,-10682 }, { 211,-10682 }, { 212,-10682 }, { 213,-10682 },
 { 214,-10682 }, { 215,-10682 }, { 216,-10682 }, { 217,-10682 }, { 218,-10682 },

 { 219,-10682 }, { 220,-10682 }, { 221,-10682 }, { 222,-10682 }, { 223,-10682 },
 { 224,-10682 }, { 225,-10682 }, { 226,-10682 }, { 227,-10682 }, { 228,-10682 },
 { 229,-10682 }, { 230,-10682 }, { 231,-10682 }, { 232,-10682 }, { 233,-10682 },
 { 234,-10682 }, { 235,-10682 }, { 236,-10682 }, { 237,-10682 }, { 238,-10682 },
 { 239,-10682 }, { 240,-10682 }, { 241,-10682 }, { 242,-10682 }, { 243,-10682 },
 { 244,-10682 }, { 245,-10682 }, { 246,-10682 }, { 247,-10682 }, { 248,-10682 },
 { 249,-10682 }, { 250,-10682 }, { 251,-10682 }, { 252,-10682 }, { 253,-10682 },
 { 254,-10682 }, { 255,-10682 }, {   0,  62 }, {   0,1538 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  61 }, {   0,1528 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,  10 }, {  49,  10 }, {  50,  10 }, {  51,  10 },
 {  52,  10 }, {  53,  10 }, {  54,  10 }, {  55,  10 }, {  56,  10 },
 {  57,  10 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },

 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-10913 }, {  66,-10913 },
 {  67,-10913 }, {  68,-10913 }, {  69,-10913 }, {  70,-10913 }, {  71,-10913 },
 {  72,-10913 }, {  73,-10913 }, {  74,-10913 }, {  75,-10913 }, {  76,-10913 },
 {  77,-10913 }, {  78,-10913 }, {  79,-10913 }, {  80,-10913 }, {  81,-10913 },
 {  82,-10913 }, {  83,-10913 }, {  84,-10913 }, {  85,-10913 }, {  86,-10913 },
 {  87,-10913 }, {  88,-10913 }, {  89,-10913 }, {  90,-10913 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-10913 }, {   0,   0 },
 {  97,-10913 }, {  98,-10913 }, {  99,-10913 }, { 100,-10913 }, { 101,-10913 },

 { 102,-10913 }, { 103,-10913 }, { 104,-10913 }, { 105,-10913 }, { 106,-10913 },
 { 107,-10913 }, { 108,-10913 }, { 109,-10913 }, { 110,-10913 }, { 111,-10913 },
 { 112,-10913 }, { 113,-10913 }, { 114,-10913 }, { 115,-10913 }, { 116,-10913 },
 { 117,-10913 }, { 118,-10913 }, { 119,-10913 }, { 120,-10913 }, { 121,-10913 },
 { 122,-10913 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-10913 }, { 129,-10913 }, { 130,-10913 }, { 131,-10913 },
 { 132,-10913 }, { 133,-10913 }, { 134,-10913 }, { 135,-10913 }, { 136,-10913 },
 { 137,-10913 }, { 138,-10913 }, { 139,-10913 }, { 140,-10913 }, { 141,-10913 },
 { 142,-10913 }, { 143,-10913 }, { 144,-10913 }, { 145,-10913 }, { 146,-10913 },
 { 147,-10913 }, { 148,-10913 }, { 149,-10913 }, { 150,-10913 }, { 151,-10913 },

 { 152,-10913 }, { 153,-10913 }, { 154,-10913 }, { 155,-10913 }, { 156,-10913 },
 { 157,-10913 }, { 158,-10913 }, { 159,-10913 }, { 160,-10913 }, { 161,-10913 },
 { 162,-10913 }, { 163,-10913 }, { 164,-10913 }, { 165,-10913 }, { 166,-10913 },
 { 167,-10913 }, { 168,-10913 }, { 169,-10913 }, { 170,-10913 }, { 171,-10913 },
 { 172,-10913 }, { 173,-10913 }, { 174,-10913 }, { 175,-10913 }, { 176,-10913 },
 { 177,-10913 }, { 178,-10913 }, { 179,-10913 }, { 180,-10913 }, { 181,-10913 },
 { 182,-10913 }, { 183,-10913 }, { 184,-10913 }, { 185,-10913 }, { 186,-10913 },
 { 187,-10913 }, { 188,-10913 }, { 189,-10913 }, { 190,-10913 }, { 191,-10913 },
 { 192,-10913 }, { 193,-10913 }, { 194,-10913 }, { 195,-10913 }, { 196,-10913 },
 { 197,-10913 }, { 198,-10913 }, { 199,-10913 }, { 200,-10913 }, { 201,-10913 },

 { 202,-10913 }, { 203,-10913 }, { 204,-10913 }, { 205,-10913 }, { 206,-10913 },
 { 207,-10913 }, { 208,-10913 }, { 209,-10913 }, { 210,-10913 }, { 211,-10913 },
 { 212,-10913 }, { 213,-10913 }, { 214,-10913 }, { 215,-10913 }, { 216,-10913 },
 { 217,-10913 }, { 218,-10913 }, { 219,-10913 }, { 220,-10913 }, { 221,-10913 },
 { 222,-10913 }, { 223,-10913 }, { 224,-10913 }, { 225,-10913 }, { 226,-10913 },
 { 227,-10913 }, { 228,-10913 }, { 229,-10913 }, { 230,-10913 }, { 231,-10913 },
 { 232,-10913 }, { 233,-10913 }, { 234,-10913 }, { 235,-10913 }, { 236,-10913 },
 { 237,-10913 }, { 238,-10913 }, { 239,-10913 }, { 240,-10913 }, { 241,-10913 },
 { 242,-10913 }, { 243,-10913 }, { 244,-10913 }, { 245,-10913 }, { 246,-10913 },
 { 247,-10913 }, { 248,-10913 }, { 249,-10913 }, { 250,-10913 }, { 251,-10913 },

 { 252,-10913 }, { 253,-10913 }, { 254,-10913 }, { 255,-10913 }, {   0,   4 },
 {   0,1271 }, {   0,  30 }, {   0,1269 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0,1254 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 },
 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,   0 }, {  43,   0 }, {   0,   0 },

 {  45,   0 }, {   0,   0 }, {  47,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-11170 }, {  49,-11170 }, {  50,-11170 }, {  51,-11170 }, {  52,-11170 },
 {  53,-11170 }, {  54,-11170 }, {  55,-11170 }, {   0,   0 }, {   0,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  48, 462 }, {  49, 462 }, {  50, 462 }, {  51, 462 }, {  52, 462 },
 {  53, 462 }, {  54, 462 }, {  55, 462 }, {  56, 462 }, {  57, 462 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,1192 },
 {   0,   0 }, {   0,   0 }, {  65, 462 }, {  66, 462 }, {  67, 462 },
 {  68, 462 }, {  69, 462 }, {  70, 462 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 },

 {   0,   0 }, {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  31 }, {   0,1169 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 462 },
 {  98, 462 }, {  99, 462 }, { 100, 462 }, { 101, 462 }, { 102, 462 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,   0 },
 {   0,   0 }, { 126,   0 }, {  48, 423 }, {  49, 423 }, {  50, 423 },
 {  51, 423 }, {  52, 423 }, {  53, 423 }, {  54, 423 }, {  55, 423 },
 {  56, 423 }, {  57, 423 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 423 },

 {  66, 423 }, {  67, 423 }, {  68, 423 }, {  69, 423 }, {  70, 423 },
 {  48,-11251 }, {  49,-11251 }, {  50,-11251 }, {  51,-11251 }, {  52,-11251 },
 {  53,-11251 }, {  54,-11251 }, {  55,-11251 }, {  56,-11251 }, {  57,-11251 },
 {   0,  37 }, {   0,1110 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-11251 }, {  66,-11251 }, {  67,-11251 },
 {  68,-11251 }, {  69,-11251 }, {  70,-11251 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97, 423 }, {  98, 423 }, {  99, 423 }, { 100, 423 },
 { 101, 423 }, { 102, 423 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  36,-11374 }, {   0,   0 }, {  97,-11251 },
 {  98,-11251 }, {  99,-11251 }, { 100,-11251 }, { 101,-11251 }, { 102,-11251 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },

 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },

 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },

 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },

 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, {   0,  28 }, {   0, 853 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0, 830 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48, 143 }, {  49, 143 }, {  50, 143 }, {  51, 143 },
 {  52, 143 }, {  53, 143 }, {  54, 143 }, {  55, 143 }, {  56, 143 },
 {  57, 143 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0, 792 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 143 }, {  66, 143 },
 {  67, 143 }, {  68, 143 }, {  69, 143 }, {  70, 143 }, {  48, 143 },
 {  49, 143 }, {  50, 143 }, {  51, 143 }, {  52, 143 }, {  53, 143 },

 {  54, 143 }, {  55, 143 }, {  56, 143 }, {  57, 143 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0, 769 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65, 143 }, {  66, 143 }, {  67, 143 }, {  68, 143 },
 {  69, 143 }, {  70, 143 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97, 143 }, {  98, 143 }, {  99, 143 }, { 100, 143 }, { 101, 143 },
 { 102, 143 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48, 143 }, {  49, 143 }, {  50, 143 },
 {  51, 143 }, {  52, 143 }, {  53, 143 }, {  54, 143 }, {  55, 143 },
 {  56, 143 }, {  57, 143 }, {   0,   0 }, {  97, 143 }, {  98, 143 },
 {  99, 143 }, { 100, 143 }, { 101, 143 }, { 102, 143 }, {  65, 143 },

 {  66, 143 }, {  67, 143 }, {  68, 143 }, {  69, 143 }, {  70, 143 },
 {  48, 143 }, {  49, 143 }, {  50, 143 }, {  51, 143 }, {  52, 143 },
 {  53, 143 }, {  54, 143 }, {  55, 143 }, {  56, 143 }, {  57, 143 },
 {   0,  28 }, {   0, 710 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 143 }, {  66, 143 }, {  67, 143 },
 {  68, 143 }, {  69, 143 }, {  70, 143 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97, 143 }, {  98, 143 }, {  99, 143 }, { 100, 143 },
 { 101, 143 }, { 102, 143 }, {   0,   0 }, {   0,  28 }, {   0, 687 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 143 },
 {  98, 143 }, {  99, 143 }, { 100, 143 }, { 101, 143 }, { 102, 143 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48, 143 },
 {  49, 143 }, {  50, 143 }, {  51, 143 }, {  52, 143 }, {  53, 143 },
 {  54, 143 }, {  55, 143 }, {  56, 143 }, {  57, 143 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0, 649 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65, 143 }, {  66, 143 }, {  67, 143 }, {  68, 143 },
 {  69, 143 }, {  70, 143 }, {  48, 143 }, {  49, 143 }, {  50, 143 },
 {  51, 143 }, {  52, 143 }, {  53, 143 }, {  54, 143 }, {  55, 143 },
 {  56, 143 }, {  57, 143 }, {   0,   0 }, {   0,   0 }, {   0,  28 },

 {   0, 626 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 143 },
 {  66, 143 }, {  67, 143 }, {  68, 143 }, {  69, 143 }, {  70, 143 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 143 }, {  98, 143 },
 {  99, 143 }, { 100, 143 }, { 101, 143 }, { 102, 143 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48, 143 }, {  49, 143 }, {  50, 143 }, {  51, 143 }, {  52, 143 },
 {  53, 143 }, {  54, 143 }, {  55, 143 }, {  56, 143 }, {  57, 143 },
 {   0,   0 }, {  97, 143 }, {  98, 143 }, {  99, 143 }, { 100, 143 },
 { 101, 143 }, { 102, 143 }, {  65, 143 }, {  66, 143 }, {  67, 143 },
 {  68, 143 }, {  69, 143 }, {  70, 143 }, {  48,-11792 }, {  49,-11792 },

 {  50,-11792 }, {  51,-11792 }, {  52,-11792 }, {  53,-11792 }, {  54,-11792 },
 {  55,-11792 }, {  56,-11792 }, {  57,-11792 }, {   0,  28 }, {   0, 567 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-11792 }, {  66,-11792 }, {  67,-11792 }, {  68,-11792 }, {  69,-11792 },
 {  70,-11792 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 143 },
 {  98, 143 }, {  99, 143 }, { 100, 143 }, { 101, 143 }, { 102, 143 },
 {   0,   0 }, {   0,  28 }, {   0, 544 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,-11792 }, {  98,-11792 }, {  99,-11792 },

 { 100,-11792 }, { 101,-11792 }, { 102,-11792 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,  84 }, {  49,  84 }, {  50,  84 },
 {  51,  84 }, {  52,  84 }, {  53,  84 }, {  54,  84 }, {  55,  84 },
 {  56,  84 }, {  57,  84 }, {   0,   0 }, {   0,   0 }, {   0,  28 },
 {   0, 506 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  84 },
 {  66,  84 }, {  67,  84 }, {  68,  84 }, {  69,  84 }, {  70,  84 },
 {  48,-11872 }, {  49,-11872 }, {  50,-11872 }, {  51,-11872 }, {  52,-11872 },
 {  53,-11872 }, {  54,-11872 }, {  55,-11872 }, {  56,-11872 }, {  57,-11872 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0, 483 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-11872 }, {  66,-11872 }, {  67,-11872 },

 {  68,-11872 }, {  69,-11872 }, {  70,-11872 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,  84 }, {  98,  84 }, {  99,  84 }, { 100,  84 },
 { 101,  84 }, { 102,  84 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,  82 }, {  49,  82 },
 {  50,  82 }, {  51,  82 }, {  52,  82 }, {  53,  82 }, {  54,  82 },
 {  55,  82 }, {  56,  82 }, {  57,  82 }, {   0,   0 }, {  97,-11872 },
 {  98,-11872 }, {  99,-11872 }, { 100,-11872 }, { 101,-11872 }, { 102,-11872 },
 {  65,  82 }, {  66,  82 }, {  67,  82 }, {  68,  82 }, {  69,  82 },
 {  70,  82 }, {  48,  82 }, {  49,  82 }, {  50,  82 }, {  51,  82 },
 {  52,  82 }, {  53,  82 }, {  54,  82 }, {  55,  82 }, {  56,  82 },

 {  57,  82 }, {   0,  28 }, {   0, 424 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  82 }, {  66,  82 },
 {  67,  82 }, {  68,  82 }, {  69,  82 }, {  70,  82 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,  82 }, {  98,  82 }, {  99,  82 },
 { 100,  82 }, { 101,  82 }, { 102,  82 }, {   0,   0 }, {   0,  28 },
 {   0, 401 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,  82 }, {  98,  82 }, {  99,  82 }, { 100,  82 }, { 101,  82 },
 { 102,  82 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 },
 {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0, 363 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 },
 {  68,  61 }, {  69,  61 }, {  70,  61 }, {  48,  61 }, {  49,  61 },
 {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 }, {  54,  61 },
 {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0, 340 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 }, {  69,  61 },
 {  70,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  61 },

 {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,  82 }, {  49,  82 }, {  50,  82 }, {  51,  82 },
 {  52,  82 }, {  53,  82 }, {  54,  82 }, {  55,  82 }, {  56,  82 },
 {  57,  82 }, {   0,   0 }, {  97,  61 }, {  98,  61 }, {  99,  61 },
 { 100,  61 }, { 101,  61 }, { 102,  61 }, {  65,  82 }, {  66,  82 },
 {  67,  82 }, {  68,  82 }, {  69,  82 }, {  70,  82 }, {  48,  82 },
 {  49,  82 }, {  50,  82 }, {  51,  82 }, {  52,  82 }, {  53,  82 },
 {  54,  82 }, {  55,  82 }, {  56,  82 }, {  57,  82 }, {   0,  28 },
 {   0, 281 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,  82 }, {  66,  82 }, {  67,  82 }, {  68,  82 },
 {  69,  82 }, {  70,  82 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,  82 }, {  98,  82 }, {  99,  82 }, { 100,  82 }, { 101,  82 },
 { 102,  82 }, {   0,   0 }, {   0,  28 }, {   0, 258 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  82 }, {  98,  82 },
 {  99,  82 }, { 100,  82 }, { 101,  82 }, { 102,  82 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-12137 }, {  49,-12137 },
 {  50,-12137 }, {  51,-12137 }, {  52,-12137 }, {  53,-12137 }, {  54,-12137 },

 {  55,-12137 }, {  56,-12137 }, {  57,-12137 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-12137 }, {  66,-12137 }, {  67,-12137 }, {  68,-12137 }, {  69,-12137 },
 {  70,-12137 }, {  48,-12158 }, {  49,-12158 }, {  50,-12158 }, {  51,-12158 },
 {  52,-12158 }, {  53,-12158 }, {  54,-12158 }, {  55,-12158 }, {  56,-12158 },
 {  57,-12158 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-12158 }, {  66,-12158 },
 {  67,-12158 }, {  68,-12158 }, {  69,-12158 }, {  70,-12158 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,-12137 }, {  98,-12137 }, {  99,-12137 },
 { 100,-12137 }, { 101,-12137 }, { 102,-12137 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,-12158 }, {  98,-12158 }, {  99,-12158 }, { 100,-12158 }, { 101,-12158 },
 { 102,-12158 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 257,  69 }, {   1,   0 },    };

static __thread const struct yy_trans_info *yy_start_state_list[25] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],
    &yy_transition[2583],
    &yy_transition[2841],
    &yy_transition[3099],
    &yy_transition[3357],
    &yy_transition[3615],
    &yy_transition[3873],
    &yy_transition[4131],
    &yy_transition[4389],
    &yy_transition[4647],
    &yy_transition[4905],
    &yy_transition[5163],
    &yy_transition[5421],
    &yy_transition[5679],
    &yy_transition[5937],

    }
;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "scan.l"

#line 47 "scan.l"

/* LCOV_EXCL_START */

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/*
 * GUC variables.  This is a DIRECT violation of the warning given at the
 * head of gram.y, ie flex/bison code must not depend on any GUC variables;
 * as such, changing their values can induce very unintuitive behavior.
 * But we shall have to live with it until we can remove these variables.
 */
__thread int			backslash_quote = BACKSLASH_QUOTE_SAFE_ENCODING;

__thread bool		escape_string_warning = true;

__thread bool		standard_conforming_strings = true;


/*
 * Constant data exported from this file.  This array maps from the
 * zero-based keyword numbers returned by ScanKeywordLookup to the
 * Bison token numbers needed by gram.y.  This is exported because
 * callers need to pass it to scanner_init, if they are using the
 * standard keyword list ScanKeywords.
 */
#define PG_KEYWORD(kwname, value, category, collabel) value,

const uint16 ScanKeywordTokens[] = {
#include "parser/kwlist.h"
};

#undef PG_KEYWORD

/*
 * Set the type of YYSTYPE.
 */
#define YYSTYPE core_YYSTYPE

/*
 * Set the type of yyextra.  All state variables used by the scanner should
 * be in yyextra, *not* statically allocated.
 */
#define YY_EXTRA_TYPE core_yy_extra_type *

/*
 * Each call to yylex must set yylloc to the location of the found token
 * (expressed as a byte offset from the start of the input text).
 * When we parse a token that requires multiple lexer rules to process,
 * this should be done in the first such rule, else yylloc will point
 * into the middle of the token.
 */
#define SET_YYLLOC()  (*(yylloc) = yytext - yyextra->scanbuf)

/*
 * Advance yylloc by the given number of bytes.
 */
#define ADVANCE_YYLLOC(delta)  ( *(yylloc) += (delta) )

/*
 * Sometimes, we do want yylloc to point into the middle of a token; this is
 * useful for instance to throw an error about an escape sequence within a
 * string literal.  But if we find no error there, we want to revert yylloc
 * to the token start, so that that's the location reported to the parser.
 * Use PUSH_YYLLOC/POP_YYLLOC to save/restore yylloc around such code.
 * (Currently the implied "stack" is just one location, but someday we might
 * need to nest these.)
 */
#define PUSH_YYLLOC()	(yyextra->save_yylloc = *(yylloc))
#define POP_YYLLOC()	(*(yylloc) = yyextra->save_yylloc)

#define startlit()	( yyextra->literallen = 0 )
static void addlit(char *ytext, int yleng, core_yyscan_t yyscanner);
static void addlitchar(unsigned char ychar, core_yyscan_t yyscanner);
static char *litbufdup(core_yyscan_t yyscanner);
static unsigned char unescape_single_char(unsigned char c, core_yyscan_t yyscanner);
static int	process_integer_literal(const char *token, YYSTYPE *lval);
static void addunicode(pg_wchar c, yyscan_t yyscanner);

#define yyerror(msg)  scanner_yyerror(msg, yyscanner)

#define lexer_errposition()  scanner_errposition(*(yylloc), yyscanner)

static void check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner);
static void check_escape_warning(core_yyscan_t yyscanner);

/*
 * Work around a bug in flex 2.5.35: it emits a couple of functions that
 * it forgets to emit declarations for.  Since we use -Wmissing-prototypes,
 * this would cause warnings.  Providing our own declarations should be
 * harmless even when the bug gets fixed.
 */
extern int	core_yyget_column(yyscan_t yyscanner);
extern void core_yyset_column(int column_no, yyscan_t yyscanner);

#line 4965 "scan.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal byte string
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xeu> Unicode surrogate pair in extended quoted string
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {decimalfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 5115 "scan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xqs 6
#define xe 7
#define xdolq 8
#define xui 9
#define xus 10
#define xeu 11

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    yy_size_t yy_n_chars;
    yy_size_t yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			yy_size_t yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		yy_size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 423 "scan.l"


#line 5411 "scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 425 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 429 "scan.l"
{
					SET_YYLLOC();
					return SQL_COMMENT;
				}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 434 "scan.l"
{
					/* Set location in case of syntax error in comment */
					SET_YYLLOC();
					yyextra->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK

case 4:
YY_RULE_SETUP
#line 444 "scan.l"
{
					(yyextra->xcdepth)++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 450 "scan.l"
{
					if (yyextra->xcdepth <= 0)
					{
						BEGIN(INITIAL);
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return C_COMMENT;
					}
					else
						(yyextra->xcdepth)--;
				}
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 461 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 465 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 469 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 473 "scan.l"
{
					yyerror("unterminated /* comment");
				}
	YY_BREAK
/* <xc> */
case 9:
YY_RULE_SETUP
#line 478 "scan.l"
{
					/* Binary bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "b" on the string
					 * to mark it for the input routine as a binary string.
					 */
					SET_YYLLOC();
					BEGIN(xb);
					startlit();
					addlitchar('b', yyscanner);
				}
	YY_BREAK
case 10:
/* rule 10 can match eol */
#line 491 "scan.l"
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 491 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 494 "scan.l"
{ yyerror("unterminated bit string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 496 "scan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					SET_YYLLOC();
					BEGIN(xh);
					startlit();
					addlitchar('x', yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 508 "scan.l"
{ yyerror("unterminated hexadecimal string literal"); }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 510 "scan.l"
{
					/* National character.
					 * We will pass this along as a normal character string,
					 * but preceded with an internally-generated "NCHAR".
					 */
					int		kwnum;

					SET_YYLLOC();
					yyless(1);	/* eat only 'n' this time */

					kwnum = ScanKeywordLookup("nchar",
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}
					else
					{
						/* If NCHAR isn't a keyword, just return "n" */
						yylval->str = pstrdup("n");
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return IDENT;
					}
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 537 "scan.l"
{
					yyextra->warn_on_first_escape = true;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					if (yyextra->standard_conforming_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 547 "scan.l"
{
					yyextra->warn_on_first_escape = false;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 554 "scan.l"
{
					SET_YYLLOC();
					if (!yyextra->standard_conforming_strings)
						ereport(ERROR,
								(errcode(ERRCODE_FEATURE_NOT_SUPPORTED),
								 errmsg("unsafe use of string constant with Unicode escapes"),
								 errdetail("String constants with Unicode escapes cannot be used when standard_conforming_strings is off."),
								 lexer_errposition()));
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 566 "scan.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					yyextra->state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 578 "scan.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(yyextra->state_before_str_stop);
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 587 "scan.l"
case 20:
/* rule 20 can match eol */
#line 588 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 588 "scan.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(INITIAL);

					switch (yyextra->state_before_str_stop)
					{
						case xb:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return BCONST;
						case xh:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return XCONST;
						case xq:
						case xe:
							/*
							 * Check that the data remains valid, if it might
							 * have been made invalid by unescaping any chars.
							 */
							if (yyextra->saw_non_ascii)
								pg_verifymbstr(yyextra->literalbuf,
											   yyextra->literallen,
											   false);
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return SCONST;
						case xus:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return USCONST;
						default:
							yyerror("unhandled previous state in xqs");
					}
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 629 "scan.l"
{
					addlitchar('\'', yyscanner);
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 632 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 635 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 638 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/*
					 * For consistency with other productions, issue any
					 * escape warning with cursor pointing to start of string.
					 * We might want to change that, someday.
					 */
					check_escape_warning(yyscanner);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (is_utf16_surrogate_first(c))
					{
						yyextra->utf16_first_part = c;
						BEGIN(xeu);
					}
					else if (is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");
					else
						addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 666 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (!is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");

					c = surrogate_pair_to_codepoint(yyextra->utf16_first_part, c);

					addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();

					BEGIN(xe);
				}
	YY_BREAK
case 26:
#line 687 "scan.l"
case 27:
/* rule 27 can match eol */
#line 688 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xeu):
#line 688 "scan.l"
{
					/* Set the error cursor to point at missing esc seq */
					SET_YYLLOC();
					yyerror("invalid Unicode surrogate pair");
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 693 "scan.l"
{
					/* Set the error cursor to point at malformed esc seq */
					SET_YYLLOC();
					ereport(ERROR,
							(errcode(ERRCODE_INVALID_ESCAPE_SEQUENCE),
							 errmsg("invalid Unicode escape"),
							 errhint("Unicode escapes must be \\uXXXX or \\UXXXXXXXX."),
							 lexer_errposition()));
				}
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 702 "scan.l"
{
					if (yytext[1] == '\'')
					{
						if (yyextra->backslash_quote == BACKSLASH_QUOTE_OFF ||
							(yyextra->backslash_quote == BACKSLASH_QUOTE_SAFE_ENCODING &&
							 PG_ENCODING_IS_CLIENT_ONLY(pg_get_client_encoding())))
							ereport(ERROR,
									(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
									 errmsg("unsafe use of \\' in a string literal"),
									 errhint("Use '' to write quotes in strings. \\' is insecure in client-only encodings."),
									 lexer_errposition()));
					}
					check_string_escape_warning(yytext[1], yyscanner);
					addlitchar(unescape_single_char(yytext[1], yyscanner),
							   yyscanner);
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 718 "scan.l"
{
					unsigned char c = strtoul(yytext + 1, NULL, 8);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 726 "scan.l"
{
					unsigned char c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 734 "scan.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xus):
#line 738 "scan.l"
{ yyerror("unterminated quoted string"); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 740 "scan.l"
{
					SET_YYLLOC();
					yyextra->dolqstart = pstrdup(yytext);
					BEGIN(xdolq);
					startlit();
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 746 "scan.l"
{
					SET_YYLLOC();
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 753 "scan.l"
{
					if (strcmp(yytext, yyextra->dolqstart) == 0)
					{
						pfree(yyextra->dolqstart);
						yyextra->dolqstart = NULL;
						BEGIN(INITIAL);
						yylval->str = litbufdup(yyscanner);
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1, yyscanner);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 774 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 777 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 780 "scan.l"
{
					/* This is only needed for $ inside the quoted text */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 784 "scan.l"
{ yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 786 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 791 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 796 "scan.l"
{
					char	   *ident;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbufdup(yyscanner);
					if (yyextra->literallen >= NAMEDATALEN)
						truncate_identifier(ident, yyextra->literallen, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 809 "scan.l"
{
					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					/* can't truncate till after we de-escape the ident */
					yylval->str = litbufdup(yyscanner);
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return UIDENT;
				}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 818 "scan.l"
{
					addlitchar('"', yyscanner);
				}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 821 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 824 "scan.l"
{ yyerror("unterminated quoted identifier"); }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 826 "scan.l"
{
					char	   *ident;

					SET_YYLLOC();
					/* throw back all but the initial u/U */
					yyless(1);
					/* and treat it as {identifier} */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 839 "scan.l"
{
					SET_YYLLOC();
					return TYPECAST;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 844 "scan.l"
{
					SET_YYLLOC();
					return DOT_DOT;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 849 "scan.l"
{
					SET_YYLLOC();
					return COLON_EQUALS;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 854 "scan.l"
{
					SET_YYLLOC();
					return EQUALS_GREATER;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 859 "scan.l"
{
					SET_YYLLOC();
					return LESS_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 864 "scan.l"
{
					SET_YYLLOC();
					return GREATER_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 869 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 875 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 881 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 886 "scan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					SET_YYLLOC();

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					/*
					 * Complain if operator is too long.  Unlike the case
					 * for identifiers, we make this an error not a notice-
					 * and-truncate, because the odds are we are looking at
					 * a syntactic mistake anyway.
					 */
					if (nchars >= NAMEDATALEN)
						yyerror("operator too long");

					yylval->str = pstrdup(yytext);
					return Op;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 994 "scan.l"
{
					SET_YYLLOC();
					yylval->ival = atol(yytext + 1);
					return PARAM;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 999 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after parameter");
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 1004 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 1008 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 1013 "scan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 1019 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 1024 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 1028 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1032 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1036 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1042 "scan.l"
{
					int			kwnum;
					char	   *ident;

					SET_YYLLOC();

					/* Is it a keyword? */
					kwnum = ScanKeywordLookup(yytext,
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}

					/*
					 * No.  Convert the identifier to lower case, and truncate
					 * if necessary.
					 */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1068 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 1073 "scan.l"
{
					SET_YYLLOC();
					yyterminate();
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1078 "scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 6370 "scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			yy_size_t offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
   


/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */


/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */


/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */


/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */


#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        yy_size_t yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */


/** Get the current line number.
 * @param yyscanner The scanner object.
 */


/** Get the current column number.
 * @param yyscanner The scanner object.
 */


/** Get the input stream.
 * @param yyscanner The scanner object.
 */


/** Get the output stream.
 * @param yyscanner The scanner object.
 */


/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */


/** Get the current token.
 * @param yyscanner The scanner object.
 */



/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */


/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */


/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */








/* Accessor methods for yylval and yylloc */






    

    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */


static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */


/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1078 "scan.l"


/* LCOV_EXCL_STOP */

/*
 * Arrange access to yyextra for subroutines of the main yylex() function.
 * We expect each subroutine to have a yyscanner parameter.  Rather than
 * use the yyget_xxx functions, which might or might not get inlined by the
 * compiler, we cheat just a bit and cast yyscanner to the right type.
 */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

/* Likewise for a couple of other things we need. */
#undef yylloc
#define yylloc	(((struct yyguts_t *) yyscanner)->yylloc_r)
#undef yyleng
#define yyleng	(((struct yyguts_t *) yyscanner)->yyleng_r)


/*
 * scanner_errposition
 *		Report a lexer or grammar error cursor position, if possible.
 *
 * This is expected to be used within an ereport() call, or via an error
 * callback such as setup_scanner_errposition_callback().  The return value
 * is a dummy (always 0, in fact).
 *
 * Note that this can only be used for messages emitted during raw parsing
 * (essentially, scan.l, parser.c, and gram.y), since it requires the
 * yyscanner struct to still be available.
 */
int
scanner_errposition(int location, core_yyscan_t yyscanner)
{
	int			pos;

	if (location < 0)
		return 0;				/* no-op if location is unknown */

	/* Convert byte offset to character number */
	pos = pg_mbstrlen_with_len(yyextra->scanbuf, location) + 1;
	/* And pass it to the ereport mechanism */
	return errposition(pos);
}

/*
 * Error context callback for inserting scanner error location.
 *
 * Note that this will be called for *any* error occurring while the
 * callback is installed.  We avoid inserting an irrelevant error location
 * if the error is a query cancel --- are there any other important cases?
 */
static void
scb_error_callback(void *arg)
{
	ScannerCallbackState *scbstate = (ScannerCallbackState *) arg;

	if (geterrcode() != ERRCODE_QUERY_CANCELED)
		(void) scanner_errposition(scbstate->location, scbstate->yyscanner);
}

/*
 * setup_scanner_errposition_callback
 *		Arrange for non-scanner errors to report an error position
 *
 * Sometimes the scanner calls functions that aren't part of the scanner
 * subsystem and can't reasonably be passed the yyscanner pointer; yet
 * we would like any errors thrown in those functions to be tagged with an
 * error location.  Use this function to set up an error context stack
 * entry that will accomplish that.  Usage pattern:
 *
 *		declare a local variable "ScannerCallbackState scbstate"
 *		...
 *		setup_scanner_errposition_callback(&scbstate, yyscanner, location);
 *		call function that might throw error;
 *		cancel_scanner_errposition_callback(&scbstate);
 */
void
setup_scanner_errposition_callback(ScannerCallbackState *scbstate,
								   core_yyscan_t yyscanner,
								   int location)
{
	/* Setup error traceback support for ereport() */
	scbstate->yyscanner = yyscanner;
	scbstate->location = location;
	scbstate->errcallback.callback = scb_error_callback;
	scbstate->errcallback.arg = (void *) scbstate;
	scbstate->errcallback.previous = error_context_stack;
	error_context_stack = &scbstate->errcallback;
}

/*
 * Cancel a previously-set-up errposition callback.
 */
void
cancel_scanner_errposition_callback(ScannerCallbackState *scbstate)
{
	/* Pop the error context stack */
	error_context_stack = scbstate->errcallback.previous;
}

/*
 * scanner_yyerror
 *		Report a lexer or grammar error.
 *
 * The message's cursor position is whatever YYLLOC was last set to,
 * ie, the start of the current token if called within yylex(), or the
 * most recently lexed token if called from the grammar.
 * This is OK for syntax error messages from the Bison parser, because Bison
 * parsers report error as soon as the first unparsable token is reached.
 * Beware of using yyerror for other purposes, as the cursor position might
 * be misleading!
 */
void
scanner_yyerror(const char *message, core_yyscan_t yyscanner)
{
	const char *loc = yyextra->scanbuf + *yylloc;

	if (*loc == YY_END_OF_BUFFER_CHAR)
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically the translation of "syntax error" */
				 errmsg("%s at end of input", _(message)),
				 lexer_errposition()));
	}
	else
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically the translation of "syntax error" */
				 errmsg("%s at or near \"%s\"", _(message), loc),
				 lexer_errposition()));
	}
}


/*
 * Called before any actual parsing is done
 */
core_yyscan_t
scanner_init(const char *str,
			 core_yy_extra_type *yyext,
			 const ScanKeywordList *keywordlist,
			 const uint16 *keyword_tokens)
{
	Size		slen = strlen(str);
	yyscan_t	scanner;

	if (yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	core_yyset_extra(yyext, scanner);

	yyext->keywordlist = keywordlist;
	yyext->keyword_tokens = keyword_tokens;

	yyext->backslash_quote = backslash_quote;
	yyext->escape_string_warning = escape_string_warning;
	yyext->standard_conforming_strings = standard_conforming_strings;

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	yyext->scanbuf = (char *) palloc(slen + 2);
	yyext->scanbuflen = slen;
	memcpy(yyext->scanbuf, str, slen);
	yyext->scanbuf[slen] = yyext->scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	yy_scan_buffer(yyext->scanbuf, slen + 2, scanner);

	/* initialize literal buffer to a reasonable but expansible size */
	yyext->literalalloc = 1024;
	yyext->literalbuf = (char *) palloc(yyext->literalalloc);
	yyext->literallen = 0;

	return scanner;
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(core_yyscan_t yyscanner)
{
	/*
	 * We don't bother to call yylex_destroy(), because all it would do is
	 * pfree a small amount of control storage.  It's cheaper to leak the
	 * storage until the parsing context is destroyed.  The amount of space
	 * involved is usually negligible compared to the output parse tree
	 * anyway.
	 *
	 * We do bother to pfree the scanbuf and literal buffer, but only if they
	 * represent a nontrivial amount of space.  The 8K cutoff is arbitrary.
	 */
	if (yyextra->scanbuflen >= 8192)
		pfree(yyextra->scanbuf);
	if (yyextra->literalalloc >= 8192)
		pfree(yyextra->literalbuf);
}


static void
addlit(char *ytext, int yleng, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + yleng) >= yyextra->literalalloc)
	{
		yyextra->literalalloc = pg_nextpower2_32(yyextra->literallen + yleng + 1);
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	memcpy(yyextra->literalbuf + yyextra->literallen, ytext, yleng);
	yyextra->literallen += yleng;
}


static void
addlitchar(unsigned char ychar, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + 1) >= yyextra->literalalloc)
	{
		yyextra->literalalloc *= 2;
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	yyextra->literalbuf[yyextra->literallen] = ychar;
	yyextra->literallen += 1;
}


/*
 * Create a palloc'd copy of literalbuf, adding a trailing null.
 */
static char *
litbufdup(core_yyscan_t yyscanner)
{
	int			llen = yyextra->literallen;
	char	   *new;

	new = palloc(llen + 1);
	memcpy(new, yyextra->literalbuf, llen);
	new[llen] = '\0';
	return new;
}

/*
 * Process {integer}.  Note this will also do the right thing with {decimal},
 * ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(token, &endptr, 10);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = pstrdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
addunicode(pg_wchar c, core_yyscan_t yyscanner)
{
	ScannerCallbackState scbstate;
	char		buf[MAX_UNICODE_EQUIVALENT_STRING + 1];

	if (!is_valid_unicode_codepoint(c))
		yyerror("invalid Unicode escape value");

	/*
	 * We expect that pg_unicode_to_server() will complain about any
	 * unconvertible code point, so we don't have to set saw_non_ascii.
	 */
	setup_scanner_errposition_callback(&scbstate, yyscanner, *(yylloc));
	pg_unicode_to_server(c, (unsigned char *) buf);
	cancel_scanner_errposition_callback(&scbstate);
	addlit(buf, strlen(buf), yyscanner);
}

static unsigned char
unescape_single_char(unsigned char c, core_yyscan_t yyscanner)
{
	switch (c)
	{
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		default:
			/* check for backslash followed by non-7-bit-ASCII */
			if (c == '\0' || IS_HIGHBIT_SET(c))
				yyextra->saw_non_ascii = true;

			return c;
	}
}

static void
check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner)
{
	if (ychar == '\'')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\' in a string literal"),
					 errhint("Use '' to write quotes in strings, or use the escape string syntax (E'...')."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else if (ychar == '\\')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\\\ in a string literal"),
					 errhint("Use the escape string syntax for backslashes, e.g., E'\\\\'."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else
		check_escape_warning(yyscanner);
}

static void
check_escape_warning(core_yyscan_t yyscanner)
{
	if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
		ereport(WARNING,
				(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
				 errmsg("nonstandard use of escape in a string literal"),
		errhint("Use the escape string syntax for escapes, e.g., E'\\r\\n'."),
				 lexer_errposition()));
	yyextra->warn_on_first_escape = false;		/* warn only once per string */
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
core_yyalloc(yy_size_t bytes, core_yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
core_yyrealloc(void *ptr, yy_size_t bytes, core_yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}



