"""use JSON type in History and for private bin values

Revision ID: 29f85e56b6d4
Revises: fe3a02cb4bec
Create Date: 2025-05-02 11:20:11.555189

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "29f85e56b6d4"
down_revision = "fe3a02cb4bec"
branch_labels = None
depends_on = None


def upgrade():
    with op.batch_alter_table("history", schema=None) as batch_op:
        batch_op.alter_column(
            "extra", existing_type=sa.TEXT(), type_=sa.JSON(), existing_nullable=True
        )

    with op.batch_alter_table("private_gen_bin", schema=None) as batch_op:
        batch_op.alter_column(
            "value", existing_type=sa.TEXT(), type_=sa.JSON(), existing_nullable=True
        )

    with op.batch_alter_table("private_ind_bin", schema=None) as batch_op:
        batch_op.alter_column(
            "value", existing_type=sa.TEXT(), type_=sa.JSON(), existing_nullable=True
        )


def downgrade():
    with op.batch_alter_table("private_ind_bin", schema=None) as batch_op:
        batch_op.alter_column(
            "value", existing_type=sa.JSON(), type_=sa.TEXT(), existing_nullable=True
        )

    with op.batch_alter_table("private_gen_bin", schema=None) as batch_op:
        batch_op.alter_column(
            "value", existing_type=sa.JSON(), type_=sa.TEXT(), existing_nullable=True
        )

    with op.batch_alter_table("history", schema=None) as batch_op:
        batch_op.alter_column(
            "extra", existing_type=sa.JSON(), type_=sa.TEXT(), existing_nullable=True
        )
