/*
 * !!! DO NOT EDIT THIS FILE !!!
 *
 * This file was automagically crafted by GED's model parser.
 */


#ifndef GED_H
#define GED_H


#ifndef GED_VALIDATION_API
#define GED_VALIDATION_API 0
#endif // GED_VALIDATION_API

#ifndef GED_EXPERIMENTAL
#define GED_EXPERIMENTAL 0
#endif // GED_EXPERIMENTAL

#ifndef GED_CALLCONV
#define GED_CALLCONV
#endif // GED_CALLCONV
#include "ged_basic_types.h"
#include "ged_enum_types.h"
#include "ged_ins_field.h"
#include "ged_enumerations.h"

/*!
 * This is an opaque type for holding a GEN instruction. The data should be accessed using the APIs supplied in this header. Before
 * using a ged_ins_t object, one of @ref GED_DecodeIns or @ref GED_InitEmptyIns must be called. Calling any other function will result
 * in undefined behavior.
 */
typedef struct
{
    char _dummy[40]; // dummy, do not access directly
} ged_ins_t;

/*!
 * This enumeration holds the models supported by GED.
 */
typedef enum
{

    /*!
     * GEN Version: 7
     * Supported CPUs: ivb
     */
    GED_MODEL_GEN_7,

    /*!
     * GEN Version: 7.5
     * Supported CPUs: hsw
     */
    GED_MODEL_GEN_7_5,

    /*!
     * GEN Version: 8
     * Supported CPUs: bdw
     */
    GED_MODEL_GEN_8,

    /*!
     * GEN Version: 8.1
     * Supported CPUs: chv
     */
    GED_MODEL_GEN_8_1,

    /*!
     * GEN Version: 9
     * Supported CPUs: skl
     */
    GED_MODEL_GEN_9,

    /*!
     * GEN Version: 10
     * Supported CPUs: cnl
     */
    GED_MODEL_GEN_10,

    /*!
     * GEN Version: 11
     * Supported CPUs: icl
     */
    GED_MODEL_GEN_11,

    /*!
     * GEN Version: 12.1
     * Supported CPUs: DashG
     */
    GED_MODEL_GEN_12_1,
    GED_MODEL_INVALID
} GED_MODEL;

/*!
 * Get the Gen model version (in string form) for the given GED_MODEL Id.
 * If the Id is not valid, return an empty string
 *
 * @param[in]       model  The GEN model.
 *
 * @return      The requested string, otherwise an empty string.
 */
extern const char* GED_CALLCONV GED_GetModelVersionString(GED_MODEL model);

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

/*!
 * Get the string representation for the given GED_RETURN_VALUE enumerator.
 * If the value is not valid, return an empty string
 *
 * @param[in]       returnValue    The given GED_RETURN_VALUE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetReturnValueString(GED_RETURN_VALUE returnValue);

/*!
 * Get the padding of the GED_RETURN_VALUE enum's string representation in order for it to be aligned column-wise.
 * If the value is not valid, return an empty string
 *
 * @param[in]       returnValue    The given GED_RETURN_VALUE enumerator.
 *
 * @return      The requested pad.
 */
extern const char* GED_CALLCONV GED_GetReturnValuePad(GED_RETURN_VALUE returnValue);

/*!
 * Initialize an empty ged_ins_t object and set its opcode. Can be called to initialize a newly allocated object or to clear an
 * existing one. Typically, this function is used for encoding instructions from scratch. For decoding, one may call @ref
 * GED_DecodeIns directly without calling this function first.
 *
 * @param[in]       modelId    The GEN model for the instruction.
 * @param[in,out]   ins        Pointer to the ged_ins_t object to be initialized.
 * @param[in]       opcode     The new opcode.
 *
 * @return      GED_RETURN_VALUE indicating success or invalid opcode.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_InitEmptyIns(const GED_MODEL modelId, ged_ins_t* ins, GED_OPCODE opcode);

/*!
 * Decode a single instruction. If the array of raw bytes includes several instructions, only one instruction will be decoded and the
 * remaining bytes will be ignored.
 *
 * @param[in]       modelId    The GEN model for the instruction.
 * @param[in]       rawBytes   An array of size "size" with the raw bytes of the instruction to decode.
 * @param[in]       size       The number of bytes in the "rawBytes" array.
 * @param[out]      ins        Pointer in which to store the decoded instruction (must be preallocated by the calling function).
 *
 * @return      GED_RETURN_VALUE indicating success or decoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_DecodeIns(const GED_MODEL modelId, const unsigned char* rawBytes, const uint32_t size,
                                                   ged_ins_t* ins);

/*!
 * Encode the given instruction and store the raw bytes in the given array. If the instruction cannot be encoded as requested, the
 * array will remain unchanged. The array is expected to be preallocated and large enough to hold the requested instruction bytes. One
 * may provide a NULL pointer instead, in which case the encoding operation will occur, validating the instruction, but the encoded
 * bytes will not be stored.
 *
 * @param[in]       ins        Pointer to the instruction object.
 * @param[in]       insType    Determine if instruction should be compacted or not. If the instruction does not have a valid compact
 *                             form, the rawBytes buffer will remain unchanged and error will be returned.
 * @param[out]      rawBytes   A preallocated buffer in which to store the instruction bytes. The buffer is expected to be large
 *                             enough to hold the requested instruction bytes. One may pass a NULL pointer, in which case the encoded
 *                             instruction bytes will not be stored.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_EncodeIns(ged_ins_t* ins, const GED_INS_TYPE insType, unsigned char* rawBytes);

/*!
 * Get the size (in bytes) of the given instruction. See @ref GED_IsCompact for details.
 *
 * @param[in]       ins    Pointer to the instruction object.
 *
 * @return      The size (in bytes) of the given instruction.
 */
extern uint32_t GED_CALLCONV GED_InsSize(const ged_ins_t* ins);

/*!
 * Check if the given instruction was modified (i.e. on of the instruction field setter APIs was called) since it was last
 * decoded/encoded (i.e. since the last call to @ref GED_DecodeIns or @ref GED_EncodeIns).
 *
 * @param[in]       ins    Pointer to the instruction object.
 *
 * @return      TRUE if the instruction was modified since the last decode/encode operation.
 */
extern bool GED_CALLCONV GED_InsModified(const ged_ins_t* ins);

#if GED_VALIDATION_API

/*!
 * Count the amount of valid compact encodings the instruction has.
 *
 * @param[in]       ins    Pointer to the instruction object.
 * @param[out]      count  The number of valid compact encodings the instruction has. If an instruction does not have a valid compact
 *                         encoding, result is undefined.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_CountCompactEncodings(ged_ins_t* ins, unsigned int& count);

/*!
 * Generate all valid compact encodings of the instruction. The buffer is expected to be preallocated and large enough to hold the
 * requested instructions' bytes. Use @ref GED_CountCompactEncodings get the amount of expected compact encodings.
 *
 * @param[in]       ins                Pointer to the instruction object.
 * @param[in]       size               The size of the preallocated buffer compactBytesArray, in bytes.
 * @param[out]      compactBytesArray  A preallocated buffer in which to store the instruction bytes. The buffer is expected to be
 *                                     large enough to hold the requested instructions' bytes.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_GetCompactEncodings(ged_ins_t* ins, const unsigned int size, unsigned char*
                                                             compactBytesArray);

/*!
 * Print all bit positions and their mapping of given field in the instruction.If a field is invalid, print accordingly. If a fragment
 * of the field has a fixed value("padded"), print its fixed value
 *
 * @param[in]       ins    Pointer to the instruction object containing the field in question.
 * @param[in]       field  The requested field.
 *
 * @return      GED_RETURN_VALUE indicating success or decoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_PrintFieldBitLocation(const ged_ins_t* ins, const GED_INS_FIELD field);
#endif // GED_VALIDATION_API

/*!
 * Get the size (in bits) of the given field within the given instruction. If the field is invalid for the given instruction, the
 * function returns 0.
 *
 * @param[in]       ins    Pointer to the instruction object containing the field in question.
 * @param[in]       field  The requested field.
 *
 * @return      The field's size (in bits) if it is valid, 0 otherwise.
 */
extern uint32_t GED_CALLCONV GED_FieldSize(const ged_ins_t* ins, const GED_INS_FIELD field);

/*!
 * Get the given instruction's opcode. The function returns an enumeration value, use @ref GED_GetMnemonic to obtain the instruction's
 * string mnemonic.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 *
 * @return      Opcode enumeration value as defined in ged_enumerations.h.
 */
extern GED_OPCODE GED_CALLCONV GED_GetOpcode(const ged_ins_t* ins);

/*!
 * Get the given instruction's mnemonic.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 *
 * @return      String representation of the instruction's mnemonic.
 */
extern const char* GED_CALLCONV GED_GetMnemonic(const ged_ins_t* ins);

/*!
 * Set a new opcode in the given instruction. If the instruction layout changes due to the new opcode, all other bits will be cleared
 * (effectively invalidating all the instruction fields). If the layout does not change, all the other instruction fields' values will
 * remain unchanged.
 *
 * @param[in,out]   ins    Pointer to the decoded instruction object.
 * @param[in]       opcode The new opcode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetOpcode(ged_ins_t* ins, const GED_OPCODE opcode);

/*!
 * Check if the given instruction is compacted. For decoded instructions it reflects the state of the CmptCtrl bit. For Encoded
 * instructions, it reflects the encoded status. If @ref GED_EncodeIns was successfully called with compact=TRUE then the function
 * will return TRUE. If @ref GED_EncodeIns was successfully called with compact=FALSE, then the function will return FALSE regardless
 * of the validity of the instruction's compact form. This means that even if the instruction can be encoded as compact the function
 * will still return FALSE. If the instruction was modified since it was last decoded/encoded i.e. @ref GED_InsModified returns TRUE,
 * the behavior of this function is undefined and one must call @ref GED_EncodeIns in order to get a the correct result.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 *
 * @return      TRUE if the instruction is compacted i.e. in its compact form, FALSE, otherwise.
 */
extern bool GED_CALLCONV GED_IsCompact(const ged_ins_t* ins);

/*!
 * Get the value of the NumOfSourceOperands field in the given instruction. See @ref GED_INS_FIELD_NumOfSourceOperands for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetNumOfSourceOperands(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Get the value of the HasDestinationOperand field in the given instruction. See @ref GED_INS_FIELD_HasDestinationOperand for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetHasDestinationOperand(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Get the value of the AccessMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAccessModeString. See @ref GED_INS_FIELD_AccessMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      AccessMode's enumeration if the field is valid, GED_ACCESS_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ACCESS_MODE GED_CALLCONV GED_GetAccessMode(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the AccessMode field in the given instruction. See @ref GED_INS_FIELD_AccessMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetAccessMode(ged_ins_t* ins, const GED_ACCESS_MODE value);

/*!
 * Get the value of the MaskCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetMaskCtrlString. See @ref GED_INS_FIELD_MaskCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      MaskCtrl's enumeration if the field is valid, GED_MASK_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MASK_CTRL GED_CALLCONV GED_GetMaskCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MaskCtrl field in the given instruction. See @ref GED_INS_FIELD_MaskCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMaskCtrl(ged_ins_t* ins, const GED_MASK_CTRL value);

/*!
 * Get the value of the DepCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetDepCtrlString. See @ref GED_INS_FIELD_DepCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DepCtrl's enumeration if the field is valid, GED_DEP_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DEP_CTRL GED_CALLCONV GED_GetDepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DepCtrl field in the given instruction. See @ref GED_INS_FIELD_DepCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDepCtrl(ged_ins_t* ins, const GED_DEP_CTRL value);

/*!
 * Get the value of the ExecMaskOffsetCtrl field in the given instruction. The function returns an enumeration value. To obtain the
 * enum entry's string representation, use @ref GED_GetExecMaskOffsetCtrlString. See @ref GED_INS_FIELD_ExecMaskOffsetCtrl for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ExecMaskOffsetCtrl's enumeration if the field is valid, GED_EXEC_MASK_OFFSET_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_EXEC_MASK_OFFSET_CTRL GED_CALLCONV GED_GetExecMaskOffsetCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExecMaskOffsetCtrl field in the given instruction. See @ref GED_INS_FIELD_ExecMaskOffsetCtrl for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExecMaskOffsetCtrl(ged_ins_t* ins, const GED_EXEC_MASK_OFFSET_CTRL value);

/*!
 * Get the value of the ChannelOffset field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetChannelOffsetString. See @ref GED_INS_FIELD_ChannelOffset for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ChannelOffset's enumeration if the field is valid, GED_CHANNEL_OFFSET_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_CHANNEL_OFFSET GED_CALLCONV GED_GetChannelOffset(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ChannelOffset field in the given instruction. See @ref GED_INS_FIELD_ChannelOffset for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetChannelOffset(ged_ins_t* ins, const GED_CHANNEL_OFFSET value);

/*!
 * Get the value of the ThreadCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetThreadCtrlString. See @ref GED_INS_FIELD_ThreadCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ThreadCtrl's enumeration if the field is valid, GED_THREAD_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_THREAD_CTRL GED_CALLCONV GED_GetThreadCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ThreadCtrl field in the given instruction. See @ref GED_INS_FIELD_ThreadCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetThreadCtrl(ged_ins_t* ins, const GED_THREAD_CTRL value);

/*!
 * Get the value of the PredCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetPredCtrlString. See @ref GED_INS_FIELD_PredCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      PredCtrl's enumeration if the field is valid, GED_PRED_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_PRED_CTRL GED_CALLCONV GED_GetPredCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the PredCtrl field in the given instruction. See @ref GED_INS_FIELD_PredCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetPredCtrl(ged_ins_t* ins, const GED_PRED_CTRL value);

/*!
 * Get the value of the PredInv field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetPredInvString. See @ref GED_INS_FIELD_PredInv for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      PredInv's enumeration if the field is valid, GED_PRED_INV_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_PRED_INV GED_CALLCONV GED_GetPredInv(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the PredInv field in the given instruction. See @ref GED_INS_FIELD_PredInv for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetPredInv(ged_ins_t* ins, const GED_PRED_INV value);

/*!
 * Get the value of the ExecSize field in the given instruction. See @ref GED_INS_FIELD_ExecSize for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetExecSize(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExecSize field in the given instruction. See @ref GED_INS_FIELD_ExecSize for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExecSize(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the CondModifier field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetCondModifierString. See @ref GED_INS_FIELD_CondModifier for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      CondModifier's enumeration if the field is valid, GED_COND_MODIFIER_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_COND_MODIFIER GED_CALLCONV GED_GetCondModifier(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the CondModifier field in the given instruction. See @ref GED_INS_FIELD_CondModifier for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetCondModifier(ged_ins_t* ins, const GED_COND_MODIFIER value);

/*!
 * Get the value of the AccWrCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAccWrCtrlString. See @ref GED_INS_FIELD_AccWrCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      AccWrCtrl's enumeration if the field is valid, GED_ACC_WR_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ACC_WR_CTRL GED_CALLCONV GED_GetAccWrCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the AccWrCtrl field in the given instruction. See @ref GED_INS_FIELD_AccWrCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetAccWrCtrl(ged_ins_t* ins, const GED_ACC_WR_CTRL value);

/*!
 * Get the value of the DebugCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDebugCtrlString. See @ref GED_INS_FIELD_DebugCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DebugCtrl's enumeration if the field is valid, GED_DEBUG_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DEBUG_CTRL GED_CALLCONV GED_GetDebugCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DebugCtrl field in the given instruction. See @ref GED_INS_FIELD_DebugCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDebugCtrl(ged_ins_t* ins, const GED_DEBUG_CTRL value);

/*!
 * Get the value of the Saturate field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetSaturateString. See @ref GED_INS_FIELD_Saturate for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Saturate's enumeration if the field is valid, GED_SATURATE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SATURATE GED_CALLCONV GED_GetSaturate(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Saturate field in the given instruction. See @ref GED_INS_FIELD_Saturate for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSaturate(ged_ins_t* ins, const GED_SATURATE value);

/*!
 * Get the value of the DstRegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_DstRegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstRegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV GED_GetDstRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstRegFile field in the given instruction. See @ref GED_INS_FIELD_DstRegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstRegFile(ged_ins_t* ins, const GED_REG_FILE value);

/*!
 * Get the value of the DstDataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_DstDataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstDataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV GED_GetDstDataType(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstDataType field in the given instruction. See @ref GED_INS_FIELD_DstDataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstDataType(ged_ins_t* ins, const GED_DATA_TYPE value);

/*!
 * Get the value of the Src0RegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_Src0RegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0RegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV GED_GetSrc0RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0RegFile field in the given instruction. See @ref GED_INS_FIELD_Src0RegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0RegFile(ged_ins_t* ins, const GED_REG_FILE value);

/*!
 * Get the value of the Src0DataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_Src0DataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0DataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV GED_GetSrc0DataType(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0DataType field in the given instruction. See @ref GED_INS_FIELD_Src0DataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0DataType(ged_ins_t* ins, const GED_DATA_TYPE value);

/*!
 * Get the value of the Src1RegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_Src1RegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1RegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV GED_GetSrc1RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1RegFile field in the given instruction. See @ref GED_INS_FIELD_Src1RegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1RegFile(ged_ins_t* ins, const GED_REG_FILE value);

/*!
 * Get the value of the Src1DataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_Src1DataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1DataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV GED_GetSrc1DataType(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1DataType field in the given instruction. See @ref GED_INS_FIELD_Src1DataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1DataType(ged_ins_t* ins, const GED_DATA_TYPE value);

/*!
 * Get the value of the DstChanEn field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDstChanEnString. See @ref GED_INS_FIELD_DstChanEn for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstChanEn's enumeration if the field is valid, GED_DST_CHAN_EN_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DST_CHAN_EN GED_CALLCONV GED_GetDstChanEn(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstChanEn field in the given instruction. See @ref GED_INS_FIELD_DstChanEn for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstChanEn(ged_ins_t* ins, const GED_DST_CHAN_EN value);

/*!
 * Get the value of the DstSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DstSubRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDstSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DstSubRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstSubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DstAddrImm field in the given instruction. See @ref GED_INS_FIELD_DstAddrImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV GED_GetDstAddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstAddrImm field in the given instruction. See @ref GED_INS_FIELD_DstAddrImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstAddrImm(ged_ins_t* ins, const int32_t value);

/*!
 * Get the value of the DstRegNum field in the given instruction. See @ref GED_INS_FIELD_DstRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDstRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstRegNum field in the given instruction. See @ref GED_INS_FIELD_DstRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DstAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DstAddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDstAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DstAddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstAddrSubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DstHorzStride field in the given instruction. See @ref GED_INS_FIELD_DstHorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDstHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstHorzStride field in the given instruction. See @ref GED_INS_FIELD_DstHorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstHorzStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DstAddrMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAddrModeString. See @ref GED_INS_FIELD_DstAddrMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstAddrMode's enumeration if the field is valid, GED_ADDR_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV GED_GetDstAddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstAddrMode field in the given instruction. See @ref GED_INS_FIELD_DstAddrMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstAddrMode(ged_ins_t* ins, const GED_ADDR_MODE value);

/*!
 * Get the value of the Src0ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src0ChanSel for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src0ChanSel for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0ChanSel(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src0SubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src0SubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0SubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0AddrImm field in the given instruction. See @ref GED_INS_FIELD_Src0AddrImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV GED_GetSrc0AddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0AddrImm field in the given instruction. See @ref GED_INS_FIELD_Src0AddrImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0AddrImm(ged_ins_t* ins, const int32_t value);

/*!
 * Get the value of the Src0RegNum field in the given instruction. See @ref GED_INS_FIELD_Src0RegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0RegNum field in the given instruction. See @ref GED_INS_FIELD_Src0RegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0RegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0AddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src0AddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0AddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0AddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src0AddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0AddrSubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0SrcMod field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetSrcModString. See @ref GED_INS_FIELD_Src0SrcMod for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0SrcMod's enumeration if the field is valid, GED_SRC_MOD_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SRC_MOD GED_CALLCONV GED_GetSrc0SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0SrcMod field in the given instruction. See @ref GED_INS_FIELD_Src0SrcMod for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0SrcMod(ged_ins_t* ins, const GED_SRC_MOD value);

/*!
 * Get the value of the Src0AddrMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAddrModeString. See @ref GED_INS_FIELD_Src0AddrMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0AddrMode's enumeration if the field is valid, GED_ADDR_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV GED_GetSrc0AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0AddrMode field in the given instruction. See @ref GED_INS_FIELD_Src0AddrMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value);

/*!
 * Get the value of the Src0HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src0HorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src0HorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0HorzStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0Width field in the given instruction. See @ref GED_INS_FIELD_Src0Width for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0Width(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0Width field in the given instruction. See @ref GED_INS_FIELD_Src0Width for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0Width(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0VertStride field in the given instruction. See @ref GED_INS_FIELD_Src0VertStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0VertStride field in the given instruction. See @ref GED_INS_FIELD_Src0VertStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0VertStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the FlagSubRegNum field in the given instruction. See @ref GED_INS_FIELD_FlagSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetFlagSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the FlagSubRegNum field in the given instruction. See @ref GED_INS_FIELD_FlagSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetFlagSubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the FlagRegNum field in the given instruction. See @ref GED_INS_FIELD_FlagRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetFlagRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the FlagRegNum field in the given instruction. See @ref GED_INS_FIELD_FlagRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetFlagRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src1ChanSel for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src1ChanSel for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1ChanSel(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src1SubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src1SubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1SubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1AddrImm field in the given instruction. See @ref GED_INS_FIELD_Src1AddrImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV GED_GetSrc1AddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1AddrImm field in the given instruction. See @ref GED_INS_FIELD_Src1AddrImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1AddrImm(ged_ins_t* ins, const int32_t value);

/*!
 * Get the value of the Src1RegNum field in the given instruction. See @ref GED_INS_FIELD_Src1RegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1RegNum field in the given instruction. See @ref GED_INS_FIELD_Src1RegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1RegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1AddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src1AddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1AddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1AddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src1AddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1AddrSubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1SrcMod field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetSrcModString. See @ref GED_INS_FIELD_Src1SrcMod for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1SrcMod's enumeration if the field is valid, GED_SRC_MOD_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SRC_MOD GED_CALLCONV GED_GetSrc1SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1SrcMod field in the given instruction. See @ref GED_INS_FIELD_Src1SrcMod for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1SrcMod(ged_ins_t* ins, const GED_SRC_MOD value);

/*!
 * Get the value of the Src1AddrMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAddrModeString. See @ref GED_INS_FIELD_Src1AddrMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1AddrMode's enumeration if the field is valid, GED_ADDR_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV GED_GetSrc1AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1AddrMode field in the given instruction. See @ref GED_INS_FIELD_Src1AddrMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value);

/*!
 * Get the value of the Src1HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src1HorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src1HorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1HorzStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1Width field in the given instruction. See @ref GED_INS_FIELD_Src1Width for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1Width(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1Width field in the given instruction. See @ref GED_INS_FIELD_Src1Width for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1Width(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1VertStride field in the given instruction. See @ref GED_INS_FIELD_Src1VertStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1VertStride field in the given instruction. See @ref GED_INS_FIELD_Src1VertStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1VertStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Imm field in the given instruction. See @ref GED_INS_FIELD_Imm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint64_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint64_t GED_CALLCONV GED_GetImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Imm field in the given instruction. See @ref GED_INS_FIELD_Imm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetImm(ged_ins_t* ins, const uint64_t value);

/*!
 * Get the value of the Src2SrcMod field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetSrcModString. See @ref GED_INS_FIELD_Src2SrcMod for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2SrcMod's enumeration if the field is valid, GED_SRC_MOD_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SRC_MOD GED_CALLCONV GED_GetSrc2SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2SrcMod field in the given instruction. See @ref GED_INS_FIELD_Src2SrcMod for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2SrcMod(ged_ins_t* ins, const GED_SRC_MOD value);

/*!
 * Get the value of the SrcDataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_SrcDataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      SrcDataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV GED_GetSrcDataType(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SrcDataType field in the given instruction. See @ref GED_INS_FIELD_SrcDataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrcDataType(ged_ins_t* ins, const GED_DATA_TYPE value);

/*!
 * Get the value of the Src0RepCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRepCtrlString. See @ref GED_INS_FIELD_Src0RepCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0RepCtrl's enumeration if the field is valid, GED_REP_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REP_CTRL GED_CALLCONV GED_GetSrc0RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0RepCtrl field in the given instruction. See @ref GED_INS_FIELD_Src0RepCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value);

/*!
 * Get the value of the Src1RepCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRepCtrlString. See @ref GED_INS_FIELD_Src1RepCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1RepCtrl's enumeration if the field is valid, GED_REP_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REP_CTRL GED_CALLCONV GED_GetSrc1RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1RepCtrl field in the given instruction. See @ref GED_INS_FIELD_Src1RepCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value);

/*!
 * Get the value of the Src2RepCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRepCtrlString. See @ref GED_INS_FIELD_Src2RepCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2RepCtrl's enumeration if the field is valid, GED_REP_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REP_CTRL GED_CALLCONV GED_GetSrc2RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2RepCtrl field in the given instruction. See @ref GED_INS_FIELD_Src2RepCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value);

/*!
 * Get the value of the Src2ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src2ChanSel for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc2ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src2ChanSel for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2ChanSel(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src2SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src2SubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc2SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src2SubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2SubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src2RegNum field in the given instruction. See @ref GED_INS_FIELD_Src2RegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc2RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2RegNum field in the given instruction. See @ref GED_INS_FIELD_Src2RegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2RegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src2RegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_Src2RegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2RegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV GED_GetSrc2RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2RegFile field in the given instruction. See @ref GED_INS_FIELD_Src2RegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2RegFile(ged_ins_t* ins, const GED_REG_FILE value);

/*!
 * Get the value of the Src2AddrMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAddrModeString. See @ref GED_INS_FIELD_Src2AddrMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2AddrMode's enumeration if the field is valid, GED_ADDR_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV GED_GetSrc2AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2AddrMode field in the given instruction. See @ref GED_INS_FIELD_Src2AddrMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value);

/*!
 * Get the value of the Src2VertStride field in the given instruction. See @ref GED_INS_FIELD_Src2VertStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc2VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2VertStride field in the given instruction. See @ref GED_INS_FIELD_Src2VertStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2VertStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the SFID field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetSFIDString. See @ref GED_INS_FIELD_SFID for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      SFID's enumeration if the field is valid, GED_SFID_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SFID GED_CALLCONV GED_GetSFID(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SFID field in the given instruction. See @ref GED_INS_FIELD_SFID for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSFID(ged_ins_t* ins, const GED_SFID value);

/*!
 * Get the value of the DescRegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_DescRegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DescRegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV GED_GetDescRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DescRegFile field in the given instruction. See @ref GED_INS_FIELD_DescRegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDescRegFile(ged_ins_t* ins, const GED_REG_FILE value);

/*!
 * Get the value of the DescDataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_DescDataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DescDataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV GED_GetDescDataType(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DescDataType field in the given instruction. See @ref GED_INS_FIELD_DescDataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDescDataType(ged_ins_t* ins, const GED_DATA_TYPE value);

/*!
 * Get the value of the DescAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DescAddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDescAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DescAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DescAddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDescAddrSubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DescRegNum field in the given instruction. See @ref GED_INS_FIELD_DescRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDescRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DescRegNum field in the given instruction. See @ref GED_INS_FIELD_DescRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDescRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DescHorzStride field in the given instruction. See @ref GED_INS_FIELD_DescHorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDescHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DescHorzStride field in the given instruction. See @ref GED_INS_FIELD_DescHorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDescHorzStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DescWidth field in the given instruction. See @ref GED_INS_FIELD_DescWidth for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDescWidth(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DescWidth field in the given instruction. See @ref GED_INS_FIELD_DescWidth for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDescWidth(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DescVertStride field in the given instruction. See @ref GED_INS_FIELD_DescVertStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDescVertStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DescVertStride field in the given instruction. See @ref GED_INS_FIELD_DescVertStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDescVertStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the MsgDesc field in the given instruction. See @ref GED_INS_FIELD_MsgDesc for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetMsgDesc(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MsgDesc field in the given instruction. See @ref GED_INS_FIELD_MsgDesc for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMsgDesc(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the ExMsgDesc field in the given instruction. See @ref GED_INS_FIELD_ExMsgDesc for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetExMsgDesc(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExMsgDesc field in the given instruction. See @ref GED_INS_FIELD_ExMsgDesc for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExMsgDesc(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the EOT field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetEOTString. See @ref GED_INS_FIELD_EOT for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      EOT's enumeration if the field is valid, GED_EOT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_EOT GED_CALLCONV GED_GetEOT(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the EOT field in the given instruction. See @ref GED_INS_FIELD_EOT for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetEOT(ged_ins_t* ins, const GED_EOT value);

/*!
 * Get the value of the MathFC field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetMathFCString. See @ref GED_INS_FIELD_MathFC for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      MathFC's enumeration if the field is valid, GED_MATH_FC_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_FC GED_CALLCONV GED_GetMathFC(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MathFC field in the given instruction. See @ref GED_INS_FIELD_MathFC for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMathFC(ged_ins_t* ins, const GED_MATH_FC value);

/*!
 * Get the value of the JIP field in the given instruction. See @ref GED_INS_FIELD_JIP for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV GED_GetJIP(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the JIP field in the given instruction. See @ref GED_INS_FIELD_JIP for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetJIP(ged_ins_t* ins, const int32_t value);

/*!
 * Get the value of the UIP field in the given instruction. See @ref GED_INS_FIELD_UIP for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV GED_GetUIP(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the UIP field in the given instruction. See @ref GED_INS_FIELD_UIP for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetUIP(ged_ins_t* ins, const int32_t value);

/*!
 * Get the value of the ControlIndex field in the given instruction. See @ref GED_INS_FIELD_ControlIndex for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetControlIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ControlIndex field in the given instruction. See @ref GED_INS_FIELD_ControlIndex for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetControlIndex(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DataTypeIndex field in the given instruction. See @ref GED_INS_FIELD_DataTypeIndex for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDataTypeIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DataTypeIndex field in the given instruction. See @ref GED_INS_FIELD_DataTypeIndex for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDataTypeIndex(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the SubRegIndex field in the given instruction. See @ref GED_INS_FIELD_SubRegIndex for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSubRegIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SubRegIndex field in the given instruction. See @ref GED_INS_FIELD_SubRegIndex for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSubRegIndex(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0Index field in the given instruction. See @ref GED_INS_FIELD_Src0Index for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0Index(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0Index field in the given instruction. See @ref GED_INS_FIELD_Src0Index for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0Index(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1Index field in the given instruction. See @ref GED_INS_FIELD_Src1Index for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1Index(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1Index field in the given instruction. See @ref GED_INS_FIELD_Src1Index for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1Index(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the DescIndex field in the given instruction. See @ref GED_INS_FIELD_DescIndex for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDescIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DescIndex field in the given instruction. See @ref GED_INS_FIELD_DescIndex for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDescIndex(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the ExDescRegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_ExDescRegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ExDescRegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV GED_GetExDescRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExDescRegFile field in the given instruction. See @ref GED_INS_FIELD_ExDescRegFile for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExDescRegFile(ged_ins_t* ins, const GED_REG_FILE value);

/*!
 * Get the value of the DstMathMacroExt field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetMathMacroExtString. See @ref GED_INS_FIELD_DstMathMacroExt for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstMathMacroExt's enumeration if the field is valid, GED_MATH_MACRO_EXT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV GED_GetDstMathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DstMathMacroExt field in the given instruction. See @ref GED_INS_FIELD_DstMathMacroExt for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDstMathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value);

/*!
 * Get the value of the Src0MathMacroExt field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetMathMacroExtString. See @ref GED_INS_FIELD_Src0MathMacroExt for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0MathMacroExt's enumeration if the field is valid, GED_MATH_MACRO_EXT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV GED_GetSrc0MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0MathMacroExt field in the given instruction. See @ref GED_INS_FIELD_Src0MathMacroExt for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value);

/*!
 * Get the value of the Src1MathMacroExt field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetMathMacroExtString. See @ref GED_INS_FIELD_Src1MathMacroExt for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1MathMacroExt's enumeration if the field is valid, GED_MATH_MACRO_EXT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV GED_GetSrc1MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1MathMacroExt field in the given instruction. See @ref GED_INS_FIELD_Src1MathMacroExt for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value);

/*!
 * Get the value of the Src2MathMacroExt field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetMathMacroExtString. See @ref GED_INS_FIELD_Src2MathMacroExt for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2MathMacroExt's enumeration if the field is valid, GED_MATH_MACRO_EXT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV GED_GetSrc2MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2MathMacroExt field in the given instruction. See @ref GED_INS_FIELD_Src2MathMacroExt for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value);

/*!
 * Get the value of the BranchCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetBranchCtrlString. See @ref GED_INS_FIELD_BranchCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      BranchCtrl's enumeration if the field is valid, GED_BRANCH_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_BRANCH_CTRL GED_CALLCONV GED_GetBranchCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the BranchCtrl field in the given instruction. See @ref GED_INS_FIELD_BranchCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetBranchCtrl(ged_ins_t* ins, const GED_BRANCH_CTRL value);

/*!
 * Get the value of the SourceIndex field in the given instruction. See @ref GED_INS_FIELD_SourceIndex for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSourceIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SourceIndex field in the given instruction. See @ref GED_INS_FIELD_SourceIndex for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSourceIndex(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src2DataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_Src2DataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2DataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV GED_GetSrc2DataType(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2DataType field in the given instruction. See @ref GED_INS_FIELD_Src2DataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2DataType(ged_ins_t* ins, const GED_DATA_TYPE value);

/*!
 * Get the value of the NoSrcDepSet field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetNoSrcDepSetString. See @ref GED_INS_FIELD_NoSrcDepSet for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      NoSrcDepSet's enumeration if the field is valid, GED_NO_SRC_DEP_SET_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_NO_SRC_DEP_SET GED_CALLCONV GED_GetNoSrcDepSet(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the NoSrcDepSet field in the given instruction. See @ref GED_INS_FIELD_NoSrcDepSet for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetNoSrcDepSet(ged_ins_t* ins, const GED_NO_SRC_DEP_SET value);

/*!
 * Get the value of the ExFuncCtrl field in the given instruction. See @ref GED_INS_FIELD_ExFuncCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetExFuncCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExFuncCtrl field in the given instruction. See @ref GED_INS_FIELD_ExFuncCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExFuncCtrl(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the ExMsgLength field in the given instruction. See @ref GED_INS_FIELD_ExMsgLength for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetExMsgLength(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExMsgLength field in the given instruction. See @ref GED_INS_FIELD_ExMsgLength for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExMsgLength(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the ExDescAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_ExDescAddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetExDescAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExDescAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_ExDescAddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExDescAddrSubRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the ExDescRegNum field in the given instruction. See @ref GED_INS_FIELD_ExDescRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetExDescRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExDescRegNum field in the given instruction. See @ref GED_INS_FIELD_ExDescRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExDescRegNum(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the MsgDescCategory field in the given instruction. See @ref GED_INS_FIELD_MsgDescCategory for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetMsgDescCategory(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MsgDescCategory field in the given instruction. See @ref GED_INS_FIELD_MsgDescCategory for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMsgDescCategory(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the MsgDescScratchAddrOffset field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchAddrOffset for
 * the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetMsgDescScratchAddrOffset(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MsgDescScratchAddrOffset field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchAddrOffset for
 * the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMsgDescScratchAddrOffset(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the MsgDescScratchBlockSize field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchBlockSize for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetMsgDescScratchBlockSize(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MsgDescScratchBlockSize field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchBlockSize for the
 * field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMsgDescScratchBlockSize(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the MsgDescScratchInvalidateAfterRead field in the given instruction. See @ref
 * GED_INS_FIELD_MsgDescScratchInvalidateAfterRead for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetMsgDescScratchInvalidateAfterRead(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MsgDescScratchInvalidateAfterRead field in the given instruction. See @ref
 * GED_INS_FIELD_MsgDescScratchInvalidateAfterRead for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMsgDescScratchInvalidateAfterRead(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the MsgDescScratchChannelMode field in the given instruction. The function returns an enumeration value. To obtain
 * the enum entry's string representation, use @ref GED_GetChannelModeString. See @ref GED_INS_FIELD_MsgDescScratchChannelMode for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      MsgDescScratchChannelMode's enumeration if the field is valid, GED_CHANNEL_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_CHANNEL_MODE GED_CALLCONV GED_GetMsgDescScratchChannelMode(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MsgDescScratchChannelMode field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchChannelMode for
 * the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMsgDescScratchChannelMode(ged_ins_t* ins, const GED_CHANNEL_MODE value);

/*!
 * Get the value of the MsgDescScratchMessageType field in the given instruction. The function returns an enumeration value. To obtain
 * the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref GED_INS_FIELD_MsgDescScratchMessageType for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      MsgDescScratchMessageType's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMsgDescScratchMessageType(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MsgDescScratchMessageType field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchMessageType for
 * the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMsgDescScratchMessageType(ged_ins_t* ins, const GED_MESSAGE_TYPE value);

/*!
 * Get the value of the ExecutionDataType field in the given instruction. The function returns an enumeration value. To obtain the
 * enum entry's string representation, use @ref GED_GetExecutionDataTypeString. See @ref GED_INS_FIELD_ExecutionDataType for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ExecutionDataType's enumeration if the field is valid, GED_EXECUTION_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_EXECUTION_DATA_TYPE GED_CALLCONV GED_GetExecutionDataType(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExecutionDataType field in the given instruction. See @ref GED_INS_FIELD_ExecutionDataType for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExecutionDataType(ged_ins_t* ins, const GED_EXECUTION_DATA_TYPE value);

/*!
 * Get the value of the Src0TernaryImm field in the given instruction. See @ref GED_INS_FIELD_Src0TernaryImm for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint64_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint64_t GED_CALLCONV GED_GetSrc0TernaryImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0TernaryImm field in the given instruction. See @ref GED_INS_FIELD_Src0TernaryImm for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0TernaryImm(ged_ins_t* ins, const uint64_t value);

/*!
 * Get the value of the Src2TernaryImm field in the given instruction. See @ref GED_INS_FIELD_Src2TernaryImm for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint64_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint64_t GED_CALLCONV GED_GetSrc2TernaryImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2TernaryImm field in the given instruction. See @ref GED_INS_FIELD_Src2TernaryImm for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2TernaryImm(ged_ins_t* ins, const uint64_t value);

/*!
 * Get the value of the Src2HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src2HorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc2HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src2HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src2HorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc2HorzStride(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the SWSB field in the given instruction. See @ref GED_INS_FIELD_SWSB for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSWSB(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SWSB field in the given instruction. See @ref GED_INS_FIELD_SWSB for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSWSB(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src1IsImm field in the given instruction. See @ref GED_INS_FIELD_Src1IsImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc1IsImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src1IsImm field in the given instruction. See @ref GED_INS_FIELD_Src1IsImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc1IsImm(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0IsImm field in the given instruction. See @ref GED_INS_FIELD_Src0IsImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0IsImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0IsImm field in the given instruction. See @ref GED_INS_FIELD_Src0IsImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0IsImm(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the Src0SubRegNumByte field in the given instruction. See @ref GED_INS_FIELD_Src0SubRegNumByte for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetSrc0SubRegNumByte(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the Src0SubRegNumByte field in the given instruction. See @ref GED_INS_FIELD_Src0SubRegNumByte for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSrc0SubRegNumByte(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the SyncFC field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetSyncFCString. See @ref GED_INS_FIELD_SyncFC for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      SyncFC's enumeration if the field is valid, GED_SYNC_FC_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SYNC_FC GED_CALLCONV GED_GetSyncFC(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SyncFC field in the given instruction. See @ref GED_INS_FIELD_SyncFC for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSyncFC(ged_ins_t* ins, const GED_SYNC_FC value);

/*!
 * Get the value of the FusionCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetFusionCtrlString. See @ref GED_INS_FIELD_FusionCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      FusionCtrl's enumeration if the field is valid, GED_FUSION_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_FUSION_CTRL GED_CALLCONV GED_GetFusionCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the FusionCtrl field in the given instruction. See @ref GED_INS_FIELD_FusionCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetFusionCtrl(ged_ins_t* ins, const GED_FUSION_CTRL value);

/*!
 * Get the value of the DataTypeIndexNoDep field in the given instruction. See @ref GED_INS_FIELD_DataTypeIndexNoDep for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetDataTypeIndexNoDep(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the DataTypeIndexNoDep field in the given instruction. See @ref GED_INS_FIELD_DataTypeIndexNoDep for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetDataTypeIndexNoDep(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the CompactedImm field in the given instruction. See @ref GED_INS_FIELD_CompactedImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetCompactedImm(ged_ins_t* ins, GED_RETURN_VALUE* result);

/*!
 * Set the value of the CompactedImm field in the given instruction. See @ref GED_INS_FIELD_CompactedImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetCompactedImm(ged_ins_t* ins, const uint32_t value);

/*!
 * Get the value of the AddrImm field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrImm, @ref GED_INS_FIELD_Src1AddrImm for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV GED_GetIndexedSrcAddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the AddrImm field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrImm, @ref GED_INS_FIELD_Src1AddrImm for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcAddrImm(ged_ins_t* ins, const int32_t value, const uint8_t index);

/*!
 * Get the value of the AddrMode field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrMode, @ref GED_INS_FIELD_Src1AddrMode, @ref GED_INS_FIELD_Src2AddrMode for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      FusionCtrl's enumeration if the field is valid, GED_FUSION_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV GED_GetIndexedSrcAddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the AddrMode field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrMode, @ref GED_INS_FIELD_Src1AddrMode, @ref GED_INS_FIELD_Src2AddrMode for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcAddrMode(ged_ins_t* ins, const GED_ADDR_MODE value, const uint8_t index);

/*!
 * Get the value of the AddrSubRegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrSubRegNum, @ref GED_INS_FIELD_Src1AddrSubRegNum for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the AddrSubRegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrSubRegNum, @ref GED_INS_FIELD_Src1AddrSubRegNum for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcAddrSubRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the ChanSel field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0ChanSel, @ref GED_INS_FIELD_Src1ChanSel, @ref GED_INS_FIELD_Src2ChanSel for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the ChanSel field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0ChanSel, @ref GED_INS_FIELD_Src1ChanSel, @ref GED_INS_FIELD_Src2ChanSel for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcChanSel(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the DataType field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0DataType, @ref GED_INS_FIELD_Src1DataType, @ref GED_INS_FIELD_Src2DataType for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      FusionCtrl's enumeration if the field is valid, GED_FUSION_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV GED_GetIndexedSrcDataType(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the DataType field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0DataType, @ref GED_INS_FIELD_Src1DataType, @ref GED_INS_FIELD_Src2DataType for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcDataType(ged_ins_t* ins, const GED_DATA_TYPE value, const uint8_t index);

/*!
 * Get the value of the HorzStride field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0HorzStride, @ref GED_INS_FIELD_Src1HorzStride, @ref GED_INS_FIELD_Src2HorzStride for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the HorzStride field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0HorzStride, @ref GED_INS_FIELD_Src1HorzStride, @ref GED_INS_FIELD_Src2HorzStride for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcHorzStride(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the Index field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0Index, @ref GED_INS_FIELD_Src1Index for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcIndex(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the Index field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0Index, @ref GED_INS_FIELD_Src1Index for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcIndex(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the MathMacroExt field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0MathMacroExt, @ref GED_INS_FIELD_Src1MathMacroExt, @ref GED_INS_FIELD_Src2MathMacroExt for the fields'
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      FusionCtrl's enumeration if the field is valid, GED_FUSION_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV GED_GetIndexedSrcMathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the MathMacroExt field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0MathMacroExt, @ref GED_INS_FIELD_Src1MathMacroExt, @ref GED_INS_FIELD_Src2MathMacroExt for the fields'
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcMathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value, const uint8_t
                                                                   index);

/*!
 * Get the value of the RegFile field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RegFile, @ref GED_INS_FIELD_Src1RegFile, @ref GED_INS_FIELD_Src2RegFile for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      FusionCtrl's enumeration if the field is valid, GED_FUSION_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV GED_GetIndexedSrcRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the RegFile field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RegFile, @ref GED_INS_FIELD_Src1RegFile, @ref GED_INS_FIELD_Src2RegFile for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcRegFile(ged_ins_t* ins, const GED_REG_FILE value, const uint8_t index);

/*!
 * Get the value of the RegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RegNum, @ref GED_INS_FIELD_Src1RegNum, @ref GED_INS_FIELD_Src2RegNum for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the RegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RegNum, @ref GED_INS_FIELD_Src1RegNum, @ref GED_INS_FIELD_Src2RegNum for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the RepCtrl field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RepCtrl, @ref GED_INS_FIELD_Src1RepCtrl, @ref GED_INS_FIELD_Src2RepCtrl for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      FusionCtrl's enumeration if the field is valid, GED_FUSION_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REP_CTRL GED_CALLCONV GED_GetIndexedSrcRepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the RepCtrl field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RepCtrl, @ref GED_INS_FIELD_Src1RepCtrl, @ref GED_INS_FIELD_Src2RepCtrl for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcRepCtrl(ged_ins_t* ins, const GED_REP_CTRL value, const uint8_t index);

/*!
 * Get the value of the SrcMod field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SrcMod, @ref GED_INS_FIELD_Src1SrcMod, @ref GED_INS_FIELD_Src2SrcMod for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      FusionCtrl's enumeration if the field is valid, GED_FUSION_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SRC_MOD GED_CALLCONV GED_GetIndexedSrcSrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the SrcMod field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SrcMod, @ref GED_INS_FIELD_Src1SrcMod, @ref GED_INS_FIELD_Src2SrcMod for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcSrcMod(ged_ins_t* ins, const GED_SRC_MOD value, const uint8_t index);

/*!
 * Get the value of the SubRegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SubRegNum, @ref GED_INS_FIELD_Src1SubRegNum, @ref GED_INS_FIELD_Src2SubRegNum for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the SubRegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SubRegNum, @ref GED_INS_FIELD_Src1SubRegNum, @ref GED_INS_FIELD_Src2SubRegNum for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcSubRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the SubRegNumByte field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SubRegNumByte for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcSubRegNumByte(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the SubRegNumByte field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SubRegNumByte for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcSubRegNumByte(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the VertStride field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0VertStride, @ref GED_INS_FIELD_Src1VertStride, @ref GED_INS_FIELD_Src2VertStride for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcVertStride(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the VertStride field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0VertStride, @ref GED_INS_FIELD_Src1VertStride, @ref GED_INS_FIELD_Src2VertStride for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcVertStride(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the Width field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0Width, @ref GED_INS_FIELD_Src1Width for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV GED_GetIndexedSrcWidth(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);

/*!
 * Set the value of the Width field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0Width, @ref GED_INS_FIELD_Src1Width for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetIndexedSrcWidth(ged_ins_t* ins, const uint32_t value, const uint8_t index);

/*!
 * Get the value of the ArchReg field from the given register number (as obtained by @ref GED_GetDstRegNum, @ref GED_GetSrc0RegNum or
 * @ref GED_GetSrc1RegNum). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetArchRegString. See @ref GED_PSEUDO_FIELD_ArchReg for the field's description.
 *
 * @param[in]       regNum     The register number.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      ArchReg's enumeration if the field is valid, GED_ARCH_REG_INVALID otherwise.
 */
extern GED_ARCH_REG GED_CALLCONV GED_GetArchReg(const uint32_t regNum, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ArchReg field in the given register number. The latter can then be set to its appropriate fields (@ref
 * GED_SetDstRegNum, @ref GED_SetSrc0RegNum or @ref GED_SetSrc1RegNum). See @ref GED_PSEUDO_FIELD_ArchReg for the field's description.
 *
 * @param[in,out]   regNum     The register number.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       archReg    The architectural register.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetArchReg(uint32_t* regNum, const GED_MODEL modelId, const GED_ARCH_REG archReg);

/*!
 * Get the value of the ArchRegNum field from the given register number (as obtained by @ref GED_GetDstRegNum, @ref GED_GetSrc0RegNum
 * or @ref GED_GetSrc1RegNum). See @ref GED_PSEUDO_FIELD_ArchRegNum for the field's description.
 *
 * @param[in]       regNum     The register number.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The architectural register number if the field is valid, the unchanged regNum value otherwise.
 */
extern uint32_t GED_CALLCONV GED_GetArchRegNum(const uint32_t regNum, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ArchRegNum field in the given register number. The latter can then be set to its appropriate fields (@ref
 * GED_SetDstRegNum, @ref GED_SetSrc0RegNum or @ref GED_SetSrc1RegNum). See @ref GED_PSEUDO_FIELD_ArchRegNum for the field's
 * description.
 *
 * @param[in,out]   regNum     The register number.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       archRegNum The architectural register number.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetArchRegNum(uint32_t* regNum, const GED_MODEL modelId, const uint32_t archRegNum);

/*!
 * Get the value of the SwizzleX field from the given channel select (as obtained by @ref GED_GetSrc0ChanSel, @ref GED_GetSrc1ChanSel
 * or @ref GED_GetSrc2ChanSel). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetSwizzleString. See @ref GED_PSEUDO_FIELD_SwizzleX for the field's description.
 *
 * @param[in]       chanSel    The channel select.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SwizzleX's enumeration if the field is valid, GED_SWIZZLE_INVALID otherwise.
 */
extern GED_SWIZZLE GED_CALLCONV GED_GetSwizzleX(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SwizzleX field in the given channel select. The latter can then be set to its appropriate fields (@ref
 * GED_SetSrc0ChanSel, @ref GED_SetSrc1ChanSel or @ref GED_SetSrc2ChanSel). See @ref GED_PSEUDO_FIELD_SwizzleX for the field's
 * description.
 *
 * @param[in,out]   chanSel    The channel select.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       swizzle    The swizzle value.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSwizzleX(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle);

/*!
 * Get the value of the SwizzleY field from the given channel select (as obtained by @ref GED_GetSrc0ChanSel, @ref GED_GetSrc1ChanSel
 * or @ref GED_GetSrc2ChanSel). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetSwizzleString. See @ref GED_PSEUDO_FIELD_SwizzleY for the field's description.
 *
 * @param[in]       chanSel    The channel select.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SwizzleY's enumeration if the field is valid, GED_SWIZZLE_INVALID otherwise.
 */
extern GED_SWIZZLE GED_CALLCONV GED_GetSwizzleY(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SwizzleY field in the given channel select. The latter can then be set to its appropriate fields (@ref
 * GED_SetSrc0ChanSel, @ref GED_SetSrc1ChanSel or @ref GED_SetSrc2ChanSel). See @ref GED_PSEUDO_FIELD_SwizzleY for the field's
 * description.
 *
 * @param[in,out]   chanSel    The channel select.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       swizzle    The swizzle value.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSwizzleY(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle);

/*!
 * Get the value of the SwizzleZ field from the given channel select (as obtained by @ref GED_GetSrc0ChanSel, @ref GED_GetSrc1ChanSel
 * or @ref GED_GetSrc2ChanSel). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetSwizzleString. See @ref GED_PSEUDO_FIELD_SwizzleZ for the field's description.
 *
 * @param[in]       chanSel    The channel select.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SwizzleZ's enumeration if the field is valid, GED_SWIZZLE_INVALID otherwise.
 */
extern GED_SWIZZLE GED_CALLCONV GED_GetSwizzleZ(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SwizzleZ field in the given channel select. The latter can then be set to its appropriate fields (@ref
 * GED_SetSrc0ChanSel, @ref GED_SetSrc1ChanSel or @ref GED_SetSrc2ChanSel). See @ref GED_PSEUDO_FIELD_SwizzleZ for the field's
 * description.
 *
 * @param[in,out]   chanSel    The channel select.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       swizzle    The swizzle value.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSwizzleZ(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle);

/*!
 * Get the value of the SwizzleW field from the given channel select (as obtained by @ref GED_GetSrc0ChanSel, @ref GED_GetSrc1ChanSel
 * or @ref GED_GetSrc2ChanSel). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetSwizzleString. See @ref GED_PSEUDO_FIELD_SwizzleW for the field's description.
 *
 * @param[in]       chanSel    The channel select.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SwizzleW's enumeration if the field is valid, GED_SWIZZLE_INVALID otherwise.
 */
extern GED_SWIZZLE GED_CALLCONV GED_GetSwizzleW(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SwizzleW field in the given channel select. The latter can then be set to its appropriate fields (@ref
 * GED_SetSrc0ChanSel, @ref GED_SetSrc1ChanSel or @ref GED_SetSrc2ChanSel). See @ref GED_PSEUDO_FIELD_SwizzleW for the field's
 * description.
 *
 * @param[in,out]   chanSel    The channel select.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       swizzle    The swizzle value.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSwizzleW(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle);

/*!
 * Get the value of the MessageLength field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_MessageLength for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The message length if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV GED_GetMessageLength(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MessageLength field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageLength for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       length     The message length.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageLength(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t length);

/*!
 * Get the value of the ResponseLength field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_ResponseLength for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The response length if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV GED_GetResponseLength(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ResponseLength field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_ResponseLength for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       length     The response length.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetResponseLength(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t length);

/*!
 * Get the value of the HeaderPresent field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetHeaderPresentString. See @ref
 * GED_PSEUDO_FIELD_HeaderPresent for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      HeaderPresent's enumeration if the field is valid, GED_HEADER_PRESENT_INVALID otherwise.
 */
extern GED_HEADER_PRESENT GED_CALLCONV GED_GetHeaderPresent(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                            result);

/*!
 * Set the value of the HeaderPresent field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_HeaderPresent for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       headerPresent  The header present.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetHeaderPresent(uint32_t* msgDesc, const GED_MODEL modelId, const GED_HEADER_PRESENT
                                                          headerPresent);

/*!
 * Get the value of the MessageTypeDP_SAMPLER field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See
 * @ref GED_PSEUDO_FIELD_MessageTypeDP_SAMPLER for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_SAMPLER's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_SAMPLER(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                                  result);

/*!
 * Set the value of the MessageTypeDP_SAMPLER field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_SAMPLER for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port sampler message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_SAMPLER(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                                  messageType);

/*!
 * Get the value of the MessageTypeDP_RC field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_RC for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_RC's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_RC(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                             result);

/*!
 * Set the value of the MessageTypeDP_RC field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_RC for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port render cache message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_RC(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                             messageType);

/*!
 * Get the value of the MessageTypeDP_CC field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_CC for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_CC's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_CC(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                             result);

/*!
 * Set the value of the MessageTypeDP_CC field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_CC for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port constant cache message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_CC(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                             messageType);

/*!
 * Get the value of the MessageTypeDP_DC0 field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_DC0 for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC0's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_DC0(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                              result);

/*!
 * Set the value of the MessageTypeDP_DC0 field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0 for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port data cache 0 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_DC0(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                              messageType);

/*!
 * Get the value of the TypedSurfaceSlotGroup field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSlotGroupString. See @ref
 * GED_PSEUDO_FIELD_TypedSurfaceSlotGroup for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      TypedSurfaceSlotGroup's enumeration if the field is valid, GED_SLOT_GROUP_INVALID otherwise.
 */
extern GED_SLOT_GROUP GED_CALLCONV GED_GetTypedSurfaceSlotGroup(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                                result);

/*!
 * Set the value of the TypedSurfaceSlotGroup field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_TypedSurfaceSlotGroup for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       slotGroup  The typed surface slot group.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetTypedSurfaceSlotGroup(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SLOT_GROUP
                                                                  slotGroup);

/*!
 * Get the value of the TypedAtomicSlotGroup field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSlotGroupString. See @ref
 * GED_PSEUDO_FIELD_TypedAtomicSlotGroup for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      TypedAtomicSlotGroup's enumeration if the field is valid, GED_SLOT_GROUP_INVALID otherwise.
 */
extern GED_SLOT_GROUP GED_CALLCONV GED_GetTypedAtomicSlotGroup(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                               result);

/*!
 * Set the value of the TypedAtomicSlotGroup field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_TypedAtomicSlotGroup for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       slotGroup  The typed atomic slot group.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetTypedAtomicSlotGroup(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SLOT_GROUP
                                                                 slotGroup);

/*!
 * Get the value of the UntypedSurfaceSIMDMode field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSIMDModeString. See @ref
 * GED_PSEUDO_FIELD_UntypedSurfaceSIMDMode for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      UntypedSurfaceSIMDMode's enumeration if the field is valid, GED_SIMDMODE_INVALID otherwise.
 */
extern GED_SIMDMODE GED_CALLCONV GED_GetUntypedSurfaceSIMDMode(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                               result);

/*!
 * Set the value of the UntypedSurfaceSIMDMode field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_UntypedSurfaceSIMDMode for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       simdMode   The untyped surface SIMD mode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetUntypedSurfaceSIMDMode(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SIMDMODE
                                                                   simdMode);

/*!
 * Get the value of the UntypedAtomicSIMDMode field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSIMDModeString. See @ref
 * GED_PSEUDO_FIELD_UntypedAtomicSIMDMode for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      UntypedAtomicSIMDMode's enumeration if the field is valid, GED_SIMDMODE_INVALID otherwise.
 */
extern GED_SIMDMODE GED_CALLCONV GED_GetUntypedAtomicSIMDMode(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                              result);

/*!
 * Set the value of the UntypedAtomicSIMDMode field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_UntypedAtomicSIMDMode for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       simdMode   The untyped atomic SIMD mode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetUntypedAtomicSIMDMode(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SIMDMODE
                                                                  simdMode);

/*!
 * Get the value of the InvalidateAfterRead field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_InvalidateAfterRead for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The invalidate after read enable if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV GED_GetInvalidateAfterRead(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the InvalidateAfterRead field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_InvalidateAfterRead for the field's description.
 *
 * @param[in,out]   msgDesc                    The message descriptor.
 * @param[in]       modelId                    The GEN model by which to interpret.
 * @param[in]       invalidateAfterReadEnable  The invalidate after read enable.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetInvalidateAfterRead(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t
                                                                invalidateAfterReadEnable);

/*!
 * Get the value of the BlockSize field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetBlockSizeString. See @ref
 * GED_PSEUDO_FIELD_BlockSize for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      BlockSize's enumeration if the field is valid, GED_BLOCK_SIZE_INVALID otherwise.
 */
extern GED_BLOCK_SIZE GED_CALLCONV GED_GetBlockSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the BlockSize field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_BlockSize for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       blockSize  The block size.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetBlockSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_BLOCK_SIZE blockSize);

/*!
 * Get the value of the RedChannel field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetChannelMaskString. See @ref
 * GED_PSEUDO_FIELD_RedChannel for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      RedChannel's enumeration if the field is valid, GED_CHANNEL_MASK_INVALID otherwise.
 */
extern GED_CHANNEL_MASK GED_CALLCONV GED_GetRedChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the RedChannel field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_RedChannel for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       channel    The red channel.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetRedChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel);

/*!
 * Get the value of the GreenChannel field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetChannelMaskString. See @ref
 * GED_PSEUDO_FIELD_GreenChannel for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      GreenChannel's enumeration if the field is valid, GED_CHANNEL_MASK_INVALID otherwise.
 */
extern GED_CHANNEL_MASK GED_CALLCONV GED_GetGreenChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the GreenChannel field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_GreenChannel for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       channel    The green channel.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetGreenChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel);

/*!
 * Get the value of the BlueChannel field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetChannelMaskString. See @ref
 * GED_PSEUDO_FIELD_BlueChannel for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      BlueChannel's enumeration if the field is valid, GED_CHANNEL_MASK_INVALID otherwise.
 */
extern GED_CHANNEL_MASK GED_CALLCONV GED_GetBlueChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the BlueChannel field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_BlueChannel for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       channel    The blue channel.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetBlueChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel);

/*!
 * Get the value of the AlphaChannel field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetChannelMaskString. See @ref
 * GED_PSEUDO_FIELD_AlphaChannel for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      AlphaChannel's enumeration if the field is valid, GED_CHANNEL_MASK_INVALID otherwise.
 */
extern GED_CHANNEL_MASK GED_CALLCONV GED_GetAlphaChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the AlphaChannel field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_AlphaChannel for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       channel    The alpha channel.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetAlphaChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel);

/*!
 * Get the value of the ReturnDataControl field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetReturnDataControlString. See @ref
 * GED_PSEUDO_FIELD_ReturnDataControl for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      ReturnDataControl's enumeration if the field is valid, GED_RETURN_DATA_CONTROL_INVALID otherwise.
 */
extern GED_RETURN_DATA_CONTROL GED_CALLCONV GED_GetReturnDataControl(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                     GED_RETURN_VALUE* result);

/*!
 * Set the value of the ReturnDataControl field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_ReturnDataControl for the field's description.
 *
 * @param[in,out]   msgDesc            The message descriptor.
 * @param[in]       modelId            The GEN model by which to interpret.
 * @param[in]       returnDataControl  The return data control.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetReturnDataControl(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                              GED_RETURN_DATA_CONTROL returnDataControl);

/*!
 * Get the value of the AtomicOperationType field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetAtomicOperationTypeString. See @ref
 * GED_PSEUDO_FIELD_AtomicOperationType for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      AtomicOperationType's enumeration if the field is valid, GED_ATOMIC_OPERATION_TYPE_INVALID otherwise.
 */
extern GED_ATOMIC_OPERATION_TYPE GED_CALLCONV GED_GetAtomicOperationType(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                         GED_RETURN_VALUE* result);

/*!
 * Set the value of the AtomicOperationType field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_AtomicOperationType for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       operationType  The atomic operation type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetAtomicOperationType(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                                GED_ATOMIC_OPERATION_TYPE operationType);

/*!
 * Get the value of the AtomicCounterOperationType field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetAtomicOperationTypeString.
 * See @ref GED_PSEUDO_FIELD_AtomicCounterOperationType for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      AtomicCounterOperationType's enumeration if the field is valid, GED_ATOMIC_OPERATION_TYPE_INVALID otherwise.
 */
extern GED_ATOMIC_OPERATION_TYPE GED_CALLCONV GED_GetAtomicCounterOperationType(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                                GED_RETURN_VALUE* result);

/*!
 * Set the value of the AtomicCounterOperationType field in the given message descriptor. The latter can then be set to its
 * appropriate field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_AtomicCounterOperationType for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       operationType  The atomic counter operation type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetAtomicCounterOperationType(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                                       GED_ATOMIC_OPERATION_TYPE operationType);

/*!
 * Get the value of the SubFuncID field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSubFuncIDString. See @ref
 * GED_PSEUDO_FIELD_SubFuncID for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SubFuncID's enumeration if the field is valid, GED_SUB_FUNC_ID_INVALID otherwise.
 */
extern GED_SUB_FUNC_ID GED_CALLCONV GED_GetSubFuncID(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the SubFuncID field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_SubFuncID for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       subFuncID  The sub function.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetSubFuncID(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SUB_FUNC_ID subFuncID);

/*!
 * Get the value of the BindingTableIndex field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_BindingTableIndex for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The binding table index if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV GED_GetBindingTableIndex(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the BindingTableIndex field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_BindingTableIndex for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       bti        The binding table index.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetBindingTableIndex(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t bti);

/*!
 * Get the value of the FuncControl field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_FuncControl for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The function control if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV GED_GetFuncControl(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the FuncControl field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_FuncControl for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       fc         The function control.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetFuncControl(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t fc);

/*!
 * Get the value of the MessageTypeDP_DC1 field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_DC1 for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC1's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_DC1(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                              result);

/*!
 * Set the value of the MessageTypeDP_DC1 field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC1 for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port data cache 1 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_DC1(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                              messageType);

/*!
 * Get the value of the MessageTypeDP0Category field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP0Category for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The category of the data cache data port 0 message if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV GED_GetMessageTypeDP0Category(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the MessageTypeDP0Category field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP0Category for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       category   The category of the data cache data port 0 message.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP0Category(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t
                                                                   category);

/*!
 * Get the value of the MessageTypeDP_DC0Legacy field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See
 * @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0Legacy for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC0Legacy's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_DC0Legacy(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                                    result);

/*!
 * Set the value of the MessageTypeDP_DC0Legacy field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0Legacy for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port data cache 0 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_DC0Legacy(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                                    messageType);

/*!
 * Get the value of the MessageTypeDP_DC0ScratchBlock field from the given message descriptor (as obtained by @ref GED_GetMsgDesc).
 * The function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See
 * @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0ScratchBlock for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC0ScratchBlock's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_DC0ScratchBlock(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                          GED_RETURN_VALUE* result);

/*!
 * Set the value of the MessageTypeDP_DC0ScratchBlock field in the given message descriptor. The latter can then be set to its
 * appropriate field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0ScratchBlock for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port data cache 0 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_DC0ScratchBlock(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                                          GED_MESSAGE_TYPE messageType);

/*!
 * Get the value of the MessageTypeDP_DC2 field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_DC2 for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC2's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_DC2(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                              result);

/*!
 * Set the value of the MessageTypeDP_DC2 field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC2 for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port data cache 2 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_DC2(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                              messageType);

/*!
 * Get the value of the MessageTypeDP_DCRO field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_DCRO for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DCRO's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV GED_GetMessageTypeDP_DCRO(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                               result);

/*!
 * Set the value of the MessageTypeDP_DCRO field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DCRO for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GEN model by which to interpret.
 * @param[in]       messageType    The data port read only message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetMessageTypeDP_DCRO(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                               messageType);

/*!
 * Get the value of the ExMessageLength field from the given extended message descriptor (as obtained by @ref GED_GetExMsgDesc). See
 * @ref GED_PSEUDO_FIELD_ExMessageLength for the field's description.
 *
 * @param[in]       exMsgDesc  The extended message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The exmessage length if the field is valid, the unchanged exMsgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV GED_GetExMessageLength(const uint32_t exMsgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * Set the value of the ExMessageLength field in the given extended message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetExMsgDesc). See @ref GED_PSEUDO_FIELD_ExMessageLength for the field's description.
 *
 * @param[in,out]   exMsgDesc  The extended message descriptor.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[in]       length     The exmessage length.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetExMessageLength(uint32_t* exMsgDesc, const GED_MODEL modelId, const uint32_t length);

#if GED_EXPERIMENTAL

/*!
 * Set specific raw bits in native instruction, ignoring value restrictions and encoding masks
 *
 * @param[in]       ins    Pointer to the instruction object containing the field in question.
 * @param[in]       low    First bit of the area in the instruction asked to modify.
 * @param[in]       high   Last bit of the area in the instruction asked to modify.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 *
 * @note        Calling this function prevents the application of encoding masks when calling @ref GED_EncodeIns
 */
extern GED_RETURN_VALUE GED_CALLCONV GED_SetRawBits(ged_ins_t* ins, uint8_t low, uint8_t high, const uint64_t value);
#endif // GED_EXPERIMENTAL

/*!
 * Get the string representation for the given GED_ACCESS_MODE enumerator. The function returns a NULL pointer for
 * GED_ACCESS_MODE_INVALID.
 *
 * @param[in]       AccessModeValue    The given GED_ACCESS_MODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetAccessModeString(GED_ACCESS_MODE AccessModeValue);

/*!
 * Get the string representation for the given GED_ACC_WR_CTRL enumerator. The function returns a NULL pointer for
 * GED_ACC_WR_CTRL_INVALID.
 *
 * @param[in]       AccWrCtrlValue The given GED_ACC_WR_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetAccWrCtrlString(GED_ACC_WR_CTRL AccWrCtrlValue);

/*!
 * Get the string representation for the given GED_ADDR_MODE enumerator. The function returns a NULL pointer for
 * GED_ADDR_MODE_INVALID.
 *
 * @param[in]       AddrModeValue  The given GED_ADDR_MODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetAddrModeString(GED_ADDR_MODE AddrModeValue);

/*!
 * Get the string representation for the given GED_ARCH_REG enumerator. The function returns a NULL pointer for GED_ARCH_REG_INVALID.
 *
 * @param[in]       ArchRegValue   The given GED_ARCH_REG enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetArchRegString(GED_ARCH_REG ArchRegValue);

/*!
 * Get the string representation for the given GED_ATOMIC_OPERATION_TYPE enumerator. The function returns a NULL pointer for
 * GED_ATOMIC_OPERATION_TYPE_INVALID.
 *
 * @param[in]       AtomicOperationTypeValue   The given GED_ATOMIC_OPERATION_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetAtomicOperationTypeString(GED_ATOMIC_OPERATION_TYPE AtomicOperationTypeValue);

/*!
 * Get the string representation for the given GED_BLOCK_SIZE enumerator. The function returns a NULL pointer for
 * GED_BLOCK_SIZE_INVALID.
 *
 * @param[in]       BlockSizeValue The given GED_BLOCK_SIZE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetBlockSizeString(GED_BLOCK_SIZE BlockSizeValue);

/*!
 * Get the string representation for the given GED_BRANCH_CTRL enumerator. The function returns a NULL pointer for
 * GED_BRANCH_CTRL_INVALID.
 *
 * @param[in]       BranchCtrlValue    The given GED_BRANCH_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetBranchCtrlString(GED_BRANCH_CTRL BranchCtrlValue);

/*!
 * Get the string representation for the given GED_CHANNEL_MASK enumerator. The function returns a NULL pointer for
 * GED_CHANNEL_MASK_INVALID.
 *
 * @param[in]       ChannelMaskValue   The given GED_CHANNEL_MASK enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetChannelMaskString(GED_CHANNEL_MASK ChannelMaskValue);

/*!
 * Get the string representation for the given GED_CHANNEL_MODE enumerator. The function returns a NULL pointer for
 * GED_CHANNEL_MODE_INVALID.
 *
 * @param[in]       ChannelModeValue   The given GED_CHANNEL_MODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetChannelModeString(GED_CHANNEL_MODE ChannelModeValue);

/*!
 * Get the string representation for the given GED_CHANNEL_OFFSET enumerator. The function returns a NULL pointer for
 * GED_CHANNEL_OFFSET_INVALID.
 *
 * @param[in]       ChannelOffsetValue The given GED_CHANNEL_OFFSET enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetChannelOffsetString(GED_CHANNEL_OFFSET ChannelOffsetValue);

/*!
 * Get the string representation for the given GED_COND_MODIFIER enumerator. The function returns a NULL pointer for
 * GED_COND_MODIFIER_INVALID.
 *
 * @param[in]       CondModifierValue  The given GED_COND_MODIFIER enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetCondModifierString(GED_COND_MODIFIER CondModifierValue);

/*!
 * Get the string representation for the given GED_DATA_TYPE enumerator. The function returns a NULL pointer for
 * GED_DATA_TYPE_INVALID.
 *
 * @param[in]       DataTypeValue  The given GED_DATA_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetDataTypeString(GED_DATA_TYPE DataTypeValue);

/*!
 * Get the string representation for the given GED_DEBUG_CTRL enumerator. The function returns a NULL pointer for
 * GED_DEBUG_CTRL_INVALID.
 *
 * @param[in]       DebugCtrlValue The given GED_DEBUG_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetDebugCtrlString(GED_DEBUG_CTRL DebugCtrlValue);

/*!
 * Get the string representation for the given GED_DEP_CTRL enumerator. The function returns a NULL pointer for GED_DEP_CTRL_INVALID.
 *
 * @param[in]       DepCtrlValue   The given GED_DEP_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetDepCtrlString(GED_DEP_CTRL DepCtrlValue);

/*!
 * Get the string representation for the given GED_DST_CHAN_EN enumerator. The function returns a NULL pointer for
 * GED_DST_CHAN_EN_INVALID.
 *
 * @param[in]       DstChanEnValue The given GED_DST_CHAN_EN enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetDstChanEnString(GED_DST_CHAN_EN DstChanEnValue);

/*!
 * Get the string representation for the given GED_EOT enumerator. The function returns a NULL pointer for GED_EOT_INVALID.
 *
 * @param[in]       EOTValue   The given GED_EOT enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetEOTString(GED_EOT EOTValue);

/*!
 * Get the string representation for the given GED_EXEC_MASK_OFFSET_CTRL enumerator. The function returns a NULL pointer for
 * GED_EXEC_MASK_OFFSET_CTRL_INVALID.
 *
 * @param[in]       ExecMaskOffsetCtrlValue    The given GED_EXEC_MASK_OFFSET_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetExecMaskOffsetCtrlString(GED_EXEC_MASK_OFFSET_CTRL ExecMaskOffsetCtrlValue);

/*!
 * Get the string representation for the given GED_EXECUTION_DATA_TYPE enumerator. The function returns a NULL pointer for
 * GED_EXECUTION_DATA_TYPE_INVALID.
 *
 * @param[in]       ExecutionDataTypeValue The given GED_EXECUTION_DATA_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetExecutionDataTypeString(GED_EXECUTION_DATA_TYPE ExecutionDataTypeValue);

/*!
 * Get the string representation for the given GED_FUSION_CTRL enumerator. The function returns a NULL pointer for
 * GED_FUSION_CTRL_INVALID.
 *
 * @param[in]       FusionCtrlValue    The given GED_FUSION_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetFusionCtrlString(GED_FUSION_CTRL FusionCtrlValue);

/*!
 * Get the string representation for the given GED_HEADER_PRESENT enumerator. The function returns a NULL pointer for
 * GED_HEADER_PRESENT_INVALID.
 *
 * @param[in]       HeaderPresentValue The given GED_HEADER_PRESENT enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetHeaderPresentString(GED_HEADER_PRESENT HeaderPresentValue);

/*!
 * Get the string representation for the given GED_MASK_CTRL enumerator. The function returns a NULL pointer for
 * GED_MASK_CTRL_INVALID.
 *
 * @param[in]       MaskCtrlValue  The given GED_MASK_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetMaskCtrlString(GED_MASK_CTRL MaskCtrlValue);

/*!
 * Get the string representation for the given GED_MATH_FC enumerator. The function returns a NULL pointer for GED_MATH_FC_INVALID.
 *
 * @param[in]       MathFCValue    The given GED_MATH_FC enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetMathFCString(GED_MATH_FC MathFCValue);

/*!
 * Get the string representation for the given GED_MATH_MACRO_EXT enumerator. The function returns a NULL pointer for
 * GED_MATH_MACRO_EXT_INVALID.
 *
 * @param[in]       MathMacroExtValue  The given GED_MATH_MACRO_EXT enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetMathMacroExtString(GED_MATH_MACRO_EXT MathMacroExtValue);

/*!
 * Get the string representation for the given GED_MESSAGE_TYPE enumerator. The function returns a NULL pointer for
 * GED_MESSAGE_TYPE_INVALID.
 *
 * @param[in]       MessageTypeValue   The given GED_MESSAGE_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetMessageTypeString(GED_MESSAGE_TYPE MessageTypeValue);

/*!
 * Get the string representation for the given GED_NO_SRC_DEP_SET enumerator. The function returns a NULL pointer for
 * GED_NO_SRC_DEP_SET_INVALID.
 *
 * @param[in]       NoSrcDepSetValue   The given GED_NO_SRC_DEP_SET enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetNoSrcDepSetString(GED_NO_SRC_DEP_SET NoSrcDepSetValue);

/*!
 * Get the string representation for the given GED_OPCODE enumerator. The function returns a NULL pointer for GED_OPCODE_INVALID.
 *
 * @param[in]       OpcodeValue    The given GED_OPCODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetOpcodeString(GED_OPCODE OpcodeValue);

/*!
 * Get the string representation for the given GED_PRED_CTRL enumerator. The function returns a NULL pointer for
 * GED_PRED_CTRL_INVALID.
 *
 * @param[in]       PredCtrlValue  The given GED_PRED_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetPredCtrlString(GED_PRED_CTRL PredCtrlValue);

/*!
 * Get the string representation for the given GED_PRED_INV enumerator. The function returns a NULL pointer for GED_PRED_INV_INVALID.
 *
 * @param[in]       PredInvValue   The given GED_PRED_INV enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetPredInvString(GED_PRED_INV PredInvValue);

/*!
 * Get the string representation for the given GED_REG_FILE enumerator. The function returns a NULL pointer for GED_REG_FILE_INVALID.
 *
 * @param[in]       RegFileValue   The given GED_REG_FILE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetRegFileString(GED_REG_FILE RegFileValue);

/*!
 * Get the string representation for the given GED_REP_CTRL enumerator. The function returns a NULL pointer for GED_REP_CTRL_INVALID.
 *
 * @param[in]       RepCtrlValue   The given GED_REP_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetRepCtrlString(GED_REP_CTRL RepCtrlValue);

/*!
 * Get the string representation for the given GED_RETURN_DATA_CONTROL enumerator. The function returns a NULL pointer for
 * GED_RETURN_DATA_CONTROL_INVALID.
 *
 * @param[in]       ReturnDataControlValue The given GED_RETURN_DATA_CONTROL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetReturnDataControlString(GED_RETURN_DATA_CONTROL ReturnDataControlValue);

/*!
 * Get the string representation for the given GED_SATURATE enumerator. The function returns a NULL pointer for GED_SATURATE_INVALID.
 *
 * @param[in]       SaturateValue  The given GED_SATURATE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetSaturateString(GED_SATURATE SaturateValue);

/*!
 * Get the string representation for the given GED_SFID enumerator. The function returns a NULL pointer for GED_SFID_INVALID.
 *
 * @param[in]       SFIDValue  The given GED_SFID enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetSFIDString(GED_SFID SFIDValue);

/*!
 * Get the string representation for the given GED_SIMDMODE enumerator. The function returns a NULL pointer for GED_SIMDMODE_INVALID.
 *
 * @param[in]       SIMDModeValue  The given GED_SIMDMODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetSIMDModeString(GED_SIMDMODE SIMDModeValue);

/*!
 * Get the string representation for the given GED_SLOT_GROUP enumerator. The function returns a NULL pointer for
 * GED_SLOT_GROUP_INVALID.
 *
 * @param[in]       SlotGroupValue The given GED_SLOT_GROUP enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetSlotGroupString(GED_SLOT_GROUP SlotGroupValue);

/*!
 * Get the string representation for the given GED_SRC_MOD enumerator. The function returns a NULL pointer for GED_SRC_MOD_INVALID.
 *
 * @param[in]       SrcModValue    The given GED_SRC_MOD enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetSrcModString(GED_SRC_MOD SrcModValue);

/*!
 * Get the string representation for the given GED_SUB_FUNC_ID enumerator. The function returns a NULL pointer for
 * GED_SUB_FUNC_ID_INVALID.
 *
 * @param[in]       SubFuncIDValue The given GED_SUB_FUNC_ID enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetSubFuncIDString(GED_SUB_FUNC_ID SubFuncIDValue);

/*!
 * Get the string representation for the given GED_SWIZZLE enumerator. The function returns a NULL pointer for GED_SWIZZLE_INVALID.
 *
 * @param[in]       SwizzleValue   The given GED_SWIZZLE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetSwizzleString(GED_SWIZZLE SwizzleValue);

/*!
 * Get the string representation for the given GED_SYNC_FC enumerator. The function returns a NULL pointer for GED_SYNC_FC_INVALID.
 *
 * @param[in]       SyncFCValue    The given GED_SYNC_FC enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetSyncFCString(GED_SYNC_FC SyncFCValue);

/*!
 * Get the string representation for the given GED_THREAD_CTRL enumerator. The function returns a NULL pointer for
 * GED_THREAD_CTRL_INVALID.
 *
 * @param[in]       ThreadCtrlValue    The given GED_THREAD_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV GED_GetThreadCtrlString(GED_THREAD_CTRL ThreadCtrlValue);

/*!
 * Determine whether the given vertical stride represents Vx1 or VxH.
 *
 * @param[in]       vertstride The vertical stride to check.
 *
 * @return      TRUE if the given vertical stride represents Vx1 or VxH, FALSE otherwise.
 */
GED_INLINE bool GED_CALLCONV GED_IsVx1VxH(uint32_t vertstride)
{
    return (3 == vertstride);
}

/*!
 * The operand width, based on its data type.
 *
 * @param[in]       datatype   The @ref GED_DATA_TYPE enumerator to interpret.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The requested value.
 */
extern uint32_t GED_CALLCONV GED_GetOperandWidth(const GED_DATA_TYPE datatype, const GED_MODEL modelId, GED_RETURN_VALUE* result);

/*!
 * The numeric type in which to display an operand, based on its data type. Relevant only for immediate operands.
 *
 * @param[in]       datatype   The @ref GED_DATA_TYPE enumerator to interpret.
 * @param[in]       modelId    The GEN model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The requested value.
 */
extern uint32_t GED_CALLCONV GED_GetOperandNumericType(const GED_DATA_TYPE datatype, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                       result);

/*!
 *
 *                 Nibble Control. This field is used in some instructions along with QtrCtrl. See the description of
 * ExecMaskOffsetCtrl.
 *                 NibCtrl is only used for SIMD4 instructions.
 *
 *
 * @param[in]       execmaskoffsetctrl The @ref GED_EXEC_MASK_OFFSET_CTRL enumerator to interpret.
 * @param[in]       modelId            The GEN model by which to interpret.
 * @param[out]      result             If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the
 *                                     specific error which caused the failure.
 *
 * @return      The requested value.
 */
extern uint32_t GED_CALLCONV GED_GetNibCtrl(const GED_EXEC_MASK_OFFSET_CTRL execmaskoffsetctrl, const GED_MODEL modelId,
                                            GED_RETURN_VALUE* result);

#ifdef __cplusplus
}// extern "C"
#endif // __cplusplus
#endif // GED_H
