## [v0.11.0.0](https://github.com/LambdaHack/LambdaHack/compare/v0.10.3.0...v0.11.0.0)

- Partially work around regression in libsdl2 2.0.16 (https://github.com/LambdaHack/LambdaHack/issues/281); to also avoid deformed boxes around tiles on the game map, please switch to a different SDL2 version
- Deduplicate UI code for exiting game, with extra style points
- Create monadic test harness and use it for UI and other unit tests
- Validate empty content and fix other soundness issues revealed by unit tests
- Add extra hints in --more and similar lines when tutorial is on
- Show full history at SPACE press and let second SPACE close it
- Spawn insects in the swamp
- Remove slot letter display in menus and instead display subtle bullets
- Repurpose item slots to item roles
- Redo display and control of main menu and its submenus
- Make Teletype frontend a bit closer to playable
- Switch right pane item description display from mono to prop font
- Ensure score not zero if victory
- Add a custom SDL cursor, working around a bug in SDL2 bindings
- Gut out most content symbols; weren't used even in lore menus after all
- Add a flag to disable the costly optimizations (that give 15-25% speedup)
- Add faction kind content and redo game mode content to use it
- Display seen faction lore
- Simplify and fortify faction and client assignment code
- Make a few unique items that were identified meta-game identifiable instead
- Fix persistence of meta-game discoveries in save files
- When assigning a faction, first try the group actor was picked from
- When assigned faction is dead, don't spawn the actor
- Don't use benign weapons on projectiles not to lose the fun
- Make the unique harpoon worth saving for a unique foe
- Spawn enemies closer and fix too random spawning location
- Improve display of item's range
- Warn when SDL game windows is resized not via config file
- Ban or force sleep on levels
- Protect against unset or primitive OS locale
- Add temporary hearing aids
- Disallow generating a door beside an opening in room's wall
- Permit smaller caves and validate cave content more accurately
- Try harder to generate escape from dungeon in a level corner
- Avoid exit/escape confusion in content names and descriptions
- Extend LH game mode a descriptions since people play it instead of Allure
- Make sure every cave has a description
- Many fixes, refactorings and tweaks

## [v0.10.3.0](https://github.com/LambdaHack/LambdaHack/compare/v0.10.2.0...v0.10.3.0)

- Work around regression https://gitlab.freedesktop.org/freetype/freetype/-/issues/1076 by making the scalable square font the default as the map font; the tiny map fonts, for which there is no such workaround, won't work for anybody with freetype 2.11.0
- Enable display of details in right pane in many menus
- Switch mouse wheel to move selection now that it changes right pane display
- Make the line where messages wrap configurable in config file
- Remove rarely used options from config file and code
- Prepare client-server for delays when operating over the network
- Reveal all map at game over and make it explorable
- Don't run with -threaded, increasing speed by a couple dozen percent
- Don't show messages during enemy turn (except when under AI control)
- Spawn many actors at once with probability correlated to spawning at all
- Gut out Ubuntu Font Family fonts
- Default to more old-fashioned small fonts in LambdaHack the game
- Add a few tutorial messages, reword some in-game texts
- Move with CI from Travis to GitHub Actions (but GHA can't keep up as well)
- Add hlint to CI
- Make place content directly define legends instead of overriding them
- Add a warning that crosshair is out of flinging range
- Add ANSI display to SDL2 frontend; remove vty, hcurses and GTK frontends
- Make Teletype frontend more usable (input, speed, overlays)
- Remove sight malus from light sources to avoid micromanagement
- Keep convenience settings between new games
- Add an option to mark FOV area with grey background
- Refactor and clean up a lot of the code
- Unhardwire various constants (hat tip to Jamie)
- Fix a couple of bugs and improve documentation
- Add whole new kinds of tests (even greater hat tip to Jamie)

## [v0.10.2.0](https://github.com/LambdaHack/LambdaHack/compare/v0.9.5.0...v0.10.2.0)

- Let '?' scroll help
- Handle Alt and Shift modifiers together
- Advertise the C- Tab command instead of A-
- Ignore empty lines in history, just in case
- Don't keep trailing endlines in history
- Don't include placeholders in history.txt
- Retry explosions 10 instead of 100 times
- Point crosshair to a modified tile to easily get lore info
- Point crosshair to a bumped tile to easily get lore info
- Don't spam when reporting that crafting is forbidden
- Prevent AI from attempting to fling when challenge forbids it
- Hint about absolute paths to fonts
- Disable testing ubuntu fonts, because they can't be distributed in Debian
- If any savefile corrupted, move aside all
- Be more consistent about moving corrupted files aside
- Stop running when passing a door, etc.
- Make the game over lore headers sound more natual
- Do not mention embeds in minimal detail
- Tweak detail in one step to minimal
- Don't let distant taunts interrupt running
- Add a comment about fleeing from stash
- Help AI not to leave a scout guarding the stash
- Ensure some gems in escape scenario
- Don't show embed descriptions by default now that ~ does that easily
- Add one more typical organ symbol
- Avoid cut off descriptions of conditional effects
- Prefer weapons with burn or wound
- Pick up bad weapons if decent projectiles
- Slightly prefer weapons that have any effects
- Permit cycling through pointed-at lore with tilde
- Split chooseItemDialogMode into several functions
- Permit pointed-at lore display also outside aiming mode
- Reset the pointed at lore display sequence
- Maintain current state of lore display
- Save current state of being-aimed-at lore display
- Don't use timeout weapon if non-timeout as strong
- Add delay to pushed frames, to notice things shorter than a turn
- Pretty-print activationFlag to make it more understandable
- Replace the special periodic activation handling with effect conditions
- Replace the special effect handling under ranged with effect condition
- Set ActivationOnCombine in one case for now
- Replace EffOnSmash by ActivationOnSmash
- Add effect condition based on activation method
- Add Unless effect
- Introduce ActivationFlag in place of EffActivation type
- Make server check that melee is done with a legal weapon
- Add a failure about meleeing with not a weapon
- Get rid of a lot of spurious instances
- Don't say a hit was amusing if non-piercing damage was high
- Vary also the block messages when high armor
- Use 'a' and 'the' in dangerous item use confirmations
- Prevent safe spots near centres of big explosions
- Permit explosions to sometimes go off inside unwalkable terrain
- Don't sleep if the only friend on level is guarding the stash
- Shorten mreason text for crawl to fit in main menu with square fonts
- Don't hint to press '?' when it does nothing yet
- Avoid empty manual page at the end with square font
- Make sure spot crosshair description fits on the status line
- Don't display the aim mode prefix when inside a menu
- Experiment with item menu not insisting on selecting an item
- Talk about the relevant lore command in manual
- Hint about the relevant lore command
- Make lore display context sensitive in aiming mode
- Signal that lore command is sometimes context-sensitive
- Don't add the interruption message unless useful
- Don't wipe key status that opens main menu after automation
- Permit random flavour assignment with brightCol, etc.
- Don't make detection modal if not performed by player's faction
- Don't describe the goal tile when performing mouse goto
- Simplify turn display code, removing most of the newest additions
- Remove another spurious source of frames
- Remove spurious sources of frames
- Re-add refined *interrupted* via messages
- Ensure all frames when inside macro have one-line report only
- Display *interrupted* also when messages interrupt macros
- Factor out oneLineBasicFrame
- Declare the codebase lens-free
- Avoid distributing test.exe in Windows packages
- Use squareToUI for mouse handling in the browser
- Introduce game map coordinates: PointSquare
- Update wrt PointUI transition in other frontends
- Define UI screen coords in a separate file
- Silence messages about dead actors activating most embeds
- Make it possible to prevent the sleep effect
- Remove savefiles if config file too old
- Force savegame load result to catch errors ASAP
- Wait until browser finalizes Local Storage in the background
- Throw a Haskel exception when JS decompression fails on an old savefile
- Now that browser compresses savefiles, permit full history size
- Limit DOM keyboard focus highjacking, etc.
- Tell player when browser can be closed
- Use lz-string.js externs for minification
- Compress savefiles in GHCJS
- Bump base-compat bound to include Data.Semigroup compat
- Simplify containers for explosions
- Start embedded explosions inside the tile, not inside projectile
- Exclude meta game items from combat messages
- Move snxtScenario to session
- Avoid 'you are less more tidy'
- Don't count valuables inside organs to dungeon total
- Clarify that normal damage is piercing, as opposed to blunt wounding
- Change the misleading 'guards a hoard'
- When dropped, destroy any organs, not only conditions
- Don't hint to press ? when it would skip some messages
- Explain why the fadeout report is rendered in square font
- Show each tutorial hint at most once per game
- Require keypress when another faction killed off
- Don't show question marks in HUD for MinorAspects items
- Add MinorAspects flag
- Get rid of the mechanism for referring expressions across messages
- Commute freely messages about conditions lasting longer
- Add NopEffect
- Add AtMostOneOf effect constructor
- Assign stable faction IDs to teams with continuity
- Display also actor initial items, not only organs
- Use Condition flag, not group, for speed and simplicity
- Keep paragraphs of the same width, unless the first really short
- Add the 'stomachs' irregular plural
- Don't identify item if PutToSleep applied to sleeping actor
- Permit question marks in verb effects
- Do not announce item trigger if explicit and so already told
- Do not report conditions triggered when they vanish
- Inform differently when sleep induced by own organ, etc.
- Reflect that item triggering message appears after the fact
- Do not spam when backstory can't trigger yet
- Give more details in logs when item triggering does not work
- Do not spam about water being activated
- Prevent server failure when triggering a gold piece
- Log item application even from, e.g., periodic activation
- Don't announce that a dying actors stopped being hungry
- Add a temporary hack that prevents AI from stealing backstories in Allure
- Hardwire the player team continuity token
- Don't identify meta game items at game end
- Implement conditional effects
- At death, destroy all organs, not just the trunk
- Permit non-unique non-singleton flavours
- Render story flavours specially
- Announce identification even during melee
- Inform about discovering meta game organs
- Make sure heroes spawned in safari mode are properly numbered
- Add a few more hero names
- Improve the descritpion of MetaGame flag
- Record meta game gear for future games
- Consume current, not persistent team gear
- Create gear according to character preferences, if any
- Use server-assigned actor numbers in the client
- Assign index numbers to actors from continued teams
- Add continued team character counter
- Generalize hero gear to each team with continuity
- Store team continuity in a faction
- Add team continuity across scenarios to content
- Add persistent sheroGear to server state
- Add a comment about why aspects of meta game items are not preserved
- Keep flavour of MetaGame items between games
- Keep identity of MetaGame items between games
- Simplify and speed up serverDiscos
- Add a flag to keep item identified between games
- Make sure pushed actors never hit before flying away
- Use lookupActorTime instead of manually inlining
- Only activate the first effect with UnderRanged and UnderMelee
- Simplify deflection descriptions given they don't stack in practice, after all
- Describe the new challenges in the manual
- Implement disabled flinging challenge
- Implement disabled crafting challenge
- Add two more challenges
- Display tutorial hint only for bad temporary conditions
- Let AI use items with -1 speed, e.g., shields
- Improve valuing of SkDeflectRanged and SkDeflectMelee
- Try not to recompile dependencies between cabal-plan and LambdaHack
- Try to work around packages not updated for GHC 9.0.1
- Add deflection temporary conditions
- Add GHC 9.0.1 to travis and .cabal
- Implement skills for ranged and melee invulnerability
- Add skills for ranged and melee invulnerability
- Implement flags for applying when under attack
- Add flags for auto-activation when under attack
- Let AI with low skill target suspect terrain
- Prevent AI from trying to trigger blocked tiles
- Explain why we crop surface, not texture, even for prop font
- Explain the pointman/leader discrepancy
- Gut out the last remain of 'cabal list-bin'
- Add some list-bin debug to travis script
- Explain away a text rendering artifact
- Make sure speaking unique messages are not ignored
- Don't interrupt for taunt messages
- Move the tutorial hint about hearing taunts to the correct place
- Add tutorial hints about taking damage
- Only save to log any interruptible messages while in melee
- Add some more tutorial hint messages
- Write key names as on the keyboard, button names as in the button
- When leader stands over an item, say so, not 'notices item'
- Unify pluralization of skills and challenges
- Add some tutorial hint messages
- Add the first tutorial hint
- Start with tutorial hints, but not in screensaver mode
- Ignore tutorial hints, as needed
- Give a more informative message when detecting that AI stuck
- Move tutorial hint options from state to session because they are UI-only
- Keep the tutorial override option from game to game
- Implement the convenience option to override tutorial hint display
- Add a convenience option to override tutorial hint display
- Set tutorial messages according to game mode
- Toggle tutorial messages when starting a game
- Mark some game modes as tutorials
- Display manual at the end of help
- Keep the rest of the manual in content
- Split manual into paragraphs aware of some markdown formatting
- Simplify an address in manual not to spill over 80 columns
- Make duplicate errors more informative (fixes #204)
- Factor out movementDefinitions
- Hint in config file to disable the special movement keys
- Hint that stealth if possible and AI vs player symmetric
- Save after game over, to preserve history
- Limit mentions of 'playing' not to break immersion
- Delimit with colour the known endings section of F1 screen
- Change 'scenario' to 'adventure' to be more immersive
- Dedupe special item and lore menu overlay handling
- Strenghten the types in item and lore menu code
- Display scenario lore (fixes #157)
- Factor our scenario description code
- Mention that scale needs to be configured for high dpi displays, see #164
- Shorten some travis tests
- Make full map position info mode the default
- Refer to the inspected map position as 'here', not 'there'
- Use the actor pronoun when describing items at the same position (fixes #215)
- Don't switch the subject from enemy actor to self for the same map position
- Don't chain dependent sentences when examining map position
- Improve the wording of actor blurbs when inspecting map postions
- When inspecting map locations, make items subjects (see #215)
- Make it more obvious the game outcomes are fixed terms
- Compute BFS with Word16, not Word8; slower, but some paths are longs
- Be more careful avoiding 32bit overflows in frequencies (for JS)
- Don't interpret the common desktop-switching key combinations
- Clear the margins also when redrawing after viewpane changed
- Specify fullscreen in config file and override on commandline
- Implement both kinds of fullscreen
- Name variable same as record field
- Remove help comment regarding SDL-only
- Add fullscreen CLI option for SDL renderer
- Indent by 4, not 2, proportional spaces
- Disable brew-sdl2-osx in travis that now takes too long
- Don't configure the unused data directories when invoking cabal
- When installing don't create the now empty GameDefinition/fonts/
- Don't limit jobs to 1 now that cabal shows errors fine
- Don't embed the fonts in the web frontend version
- Get rid of datafiles from .cabal
- Kill the font license files that are duplicated in COPYLEFT file
- Get rid of the now unused fontDir option
- Use embedded fonts, unless absolute path is given
- Embed game-supplied font files
- Try to be more verbose where running cabal test in appveyor
- Don't create ~/.test directory when testing
- Version config file; fixes #220
- Don't error out if the effect-causing item is not seen by strangers
- Add assertionz that, normally, items are known by actors affected by them
- Hardwire a few less colours
- Mention the item responsible for an effect, unless spammy
- Get rid of a left over no-repetition message helper
- Pass on the item responsible for an effect
- Start main menus at the first normal item
- Open game homepage when clicked in Main Menu
- Write the homepage address in full in Main Menu
- Depend on open-browser package
- Make the game over messages more colourful; fixes #213
- Tweak the display of game over messages
- Make one kind of ending message more precise and colourful
- Display camped and restarted endings in F1 scenario screen
- Save which games are camped or restarted
- Add default messages for Restart and Camping; fixes #212
- Sort outcome constructors for best display in F1 scenario screen
- Colour only outcome name in game over header
- Refactor renderSection in preparation of multi-color lines
- Avoid 'restart in foggy mode'
- Unify rendering of game outcomes; fixes #210
- Remove a leftover mention of rmainMenuArt
- Improve the colours of the F1 scenario description screen
- Expose the meaning of colours for the use in other modules
- Specify also defeat endings
- Make headers in F1 scenario screen monospace
- Factor out attrLinesToFontMap
- Render F1 scenario screen better; fixes #208
- Add tests for many game modes in one session; fixes #228
- Add slowCrawl make target to observe AI in detail
- Mention in item description it's unique, because name may not underscore it
- Ignore the placeholder messages when displaying one message
- Don't overwrite prop with mono overlay even if the latter empty
- Add placeholders to history display, fixing #236
- Add a comment about historyMax divisible by screenful
- Improve message class of HP-affecting effects display
- Mark with dots if the show distinct messages different than the longer
- Implement distinct messages for becoming more affected by a condition
- Implement distinct messages for SfxTimerExtended
- Move messages that are hard to scrap to Distinct class, to fix it
- Prepare ppSfxMsg for Distinct messages
- Don't let ESC clear messages in aiming mode; was confusing
- Add Discord and Matrix addresses to the manual
- Add links to discord and matrix chat
- Let MsgRunStopReason suffice for running interruption
- Save spam, but don't show
- Clean up scraping messages
- Don't run if ordered to run into solid tile
- Reword the short post-action messages
- Don't show both terrain description and a warning about it in yellow
- Typeset one line of history view the same as whole history
- Make some messages longer to look better on a separate line
- Reverse history to match the order of messages shown on screen normally
- No longer specify initial repetition of a message
- Eliminate not saving and not repeating messages using counts
- Use allB in a couple more asserts
- Assert message constructors have proper length
- Get rid of message class GADT as designed by Alex Byaly, simplifying code
- Wrap first line of overlay at half the screen, not earlier
- Make indentSplitAttrString more accurate
- Tweak unique entities in content, adding 'the' as needed; fixes #214
- Don't capitalize and add 'the' to unique entities
- Be more verbose when displacing over laying items
- Align single high score lines
- Copy-paste-hacked enlarging line-wrap treshold if too long headers then fit
- Fine-tune display of too long reports
- Display message classes aligned
- Rename message class constructors for better display
- Display message class in grey
- Indent wrapped messages
- In messages, replace some magenta risks by bright red harms
- Be careful measuring length of multi-line texts for wrapping
- Use the config option for one message per line on screen
- Hide the implementation of Msg, again
- Display message class in history if one per line
- Don't report HP changes of projectiles
- Use the config option for one message per line in history
- Pass along the config option for one message per line in history
- Add config options for one message per line
- Rename the item spotting message
- Bring back filtering empty messages, to fix checking if report empty
- Add Show instance to history and its components for debugging
- Improve removing EOLs when deduplicating messages
- Remove MsgItemMoveLog now that one message class suffices for two components
- Get rid of isSavedToHistory and isDisplayed encoded now in the GADT
- Customize messages more comfortably
- Simplify restarting client
- Remove the code enabling multiple UI clients
- Don't spawn many UI clients, but re-assign a single one
- Make MsgClass a GADT
- Eliminate Binary instance of MsgClass in preparation of GADT
- In config file, specify prefixes of message class names
- Change colour of game start message to a nicer one
- Issue special messages when actor fall to sleep or wake up
- Tweak message class use and colour assignment again
- Remove abuse of MsgTileDisco
- Recolour enemy spotted animation according to colour meaning table
- Redo colour assignment to messages
- Update frontends to highlight changes
- Change the colour of names of sleeping actors to blue
- Reflect changes in highlighting in the manual
- Swap blue and green highlights
- Highlight dominated actors more distinctly, as proposed by @bulbousBullfrog
- Rename confusing message classes
- Make sure indented texts are wrapped at earlier position
- Make most texts wrap before full screen width
- Extend UI.Content.Screen validation
- Tweak texts to fit on screen easily with square font
- Permit wrapping messages after N columns
- Prefer stairs in bottom right corners to leave space for messages
- Prefer levels in bottom right corners to leave space for messages
- Update documentation to the config changes
- Prevent friendly AI from wasting time nosing around our stash
- Rename an identifier to a consistent form
- Limit the size of monospace prompts when keypress requested
- Redo message colours given that some colours get a very thin font, possibly
- Use a mixture of fonts in the challenges menu
- Comment the config file some more
- Render all titles in mono font
- Typeset mouse command table in varied font
- Gut out Ubuntu Family Fonts from Debian package, because non-free
- Beautify CREDITS
- Rand the fontsets differently
- Make the fontset tests more random
- Don't run noopt travis tests on normal length crawl
- Test all fontsets
- Extend client logging
- Make the game reentrant
- Prevent mangled newlines in concurrent screen writes
- Permit text usage in tests
- Refactor mkUIOptions to require less content
- Settile on 'auxiliary fonts' instead of 'long text'
- Hardwire GTK font size to fix breakage from config format change
- Simplify FontSetup
- Implement scaling all fonts easily and safely
- Add font scaling option to config and commandline
- Prevent overspill when prop font is, in fact, mono
- Remove the now unused portions of config and commandline
- Make getFontSetup more accurate (not used yet)
- Eliminate really the last dependency on old config file fields
- Add a comment about lack of optimization for duplicated fonts
- Eliminate one last dependency on old config file fields
- Hardwire the font families to use for GTK frontend
- Use the two weights of prop font
- Recover old SDL frontend functionality using new config
- Move font types to make importing them in ClientOptions legal
- Let fontset be chosen on commandline as well
- Extend config file with font and fontset definitions
- Molify Debian's lintian
- Legalize all the long text fonts even more
- Legalize all the long text fonts
- Add the ubuntu font family set of long text fonts
- Add another set of long text fonts
- Add new long text fonts based Adobe Source
- Remove old long text fonts
- Add commented out TTF.setHinting directive
- Crop too high fonts more at the top than bottom
- Get rid of the last traces of 'exploiting' terrain
- Simplify and speed up linearInterpolation (not benchmarked)
- Change which test is run in -O0 travis
- Make final version of integer casts hardening, using the type-level int-cast
- Explain the communication overhead concept
- Use toIntegralSized to crash when int wrap would occur during conversion
- Parse config at compile time
- Let foes occupiy exit in escape scenario, etc.
- Add missing cskip specifications
- If more info in history, end message with three dots
- Bump GHC versions for testing
- Bring back SPACE as clearning messages
- Update the default config wrt changes to RET keybinding
- Let ESC cancel the aiming line as well
- Keep the order, modulo abs, of factions as in the roster
- Don't switch level away from melee when positions not taken yet
- Improve valuing AI displace action a bit
- Increase expressiveness of initial actor generation
- Permit tiny rooms if no stairs variety
- Pick the sole actor for cwolf games ignoring empty specs
- Remove length that forces the whole psFree, even though most unused
- Don't drop initial actors if not enough initial faction positions
- Remove a code check that is already in mode content check
- Generate initial actors in the order given in content
- Prepare types for more faithful initial actor generation
- Rename ES.toList
- Simplify populateDungeon and catch similar overcomplications
- Generate initial actors in per-faction positions, not in alliances
- Make the use of integral conversion easier to verify
- Reword ESC description again
- Settle on apostrophes to denote one-letter keyboard keys
- Update command docs to command help changes
- Let only ESC clear messages
- Show newcomer aim mode help also when pressing ? in non-default detail level
- Simplify how the hint prompt works
- Align newcomer aiming help with ? help when aiming
- Try harder to display errors in appveyor runs
- Simplify and slightly fix linearInterpolation
- Extend debug information when summoning fails for lack of space
- Except for DetailLow, always show any description when examining
- Give feedback of detail level also when item selected
- Show item symbol in item lore view in square font
- Tweak and fix item examination messages one last time
- Change display of terrain more gradually as detail level rises
- Simplify two cases of sortBy emulating sortOn performance-wise
- Improve describing of items with words limit 1
- Use partItemWsDetail for item description when examining
- Make the second detail level the default
- Fine-tune shortest item examination message once more
- Move SPACE to CmdAim category
- Document that MMB and RMB cycle detail level
- Let RMB and MMB cycle detail level
- Add aiming help line for newcomers with SPACE hint
- Don't warn about our own actors
- Reformat lookAtActors
- Implement detail level for actor descriptions at position
- Show position description components according to detail level
- Show detail level in HUD
- Redraw after detail level changed
- Implement detail level for item descriptions at position
- Match the new order of descriptions in a couple more places
- Bind SPACE to cycle detail level in aiming mode
- Add DetailCycle human command
- Record detail level in the aiming mode state
- Add and improve headers for scenario endings messages
- Change sortBy to sortOn in a couple of places
- Optimize truncateOverlay with the best of the sortOn and sortBy worlds
- Replace some performance-wise wrong uses of sortOn with sortBy
- Mark the last major outcome in F1 scenario screen
- Change unique actor names to match the upcoming new convention
- Don't show even deafeat messages in F1 if not experienced
- Update the '?' hints to the new Tab semantics
- Add dumping history to a text file
- Advise to replay initial scenarios
- Adjust the order of spotting to match the order when exploring
- Swap the order of intrusion warning and enemy spotted message
- Announce specially foes that have non-trivial items equipped
- Clean up Content.Input.makeData
- Destroy the trunk when actor dies, for death effects
- Make sure embedded item desc stands out from the following activation info
- Make unique speech heard regardless of distance
- Let uniques taunt in a big way
- Add type signatures to AI action picking functions
- Reorder consistenly mode kind component definitions in the file
- Extend rarity specs to above 10 logical levels
- Improve comments and messages about Rarity datatype
- Avoid spoiling victory game over messges, until seen
- Factor out victoryOutcomes
- Display game over messages in F1 scenario screen
- Shorten a field name to avoid >80 length lines
- Colour header in the F1 scenario screen
- Disable a travis test that still panics
- Revert the scenario choice font frop prop to mono, for typographic consistency
- Shorten a flavour blurb to make it fit when font is square
- Extend wrong line break avoidance to colourful texts
- Display also flavour in scenario choice screen
- Don't attempt to display F1 scenario blurb in square fonts with two columns
- Don't display the extra TAB commands in item menu headers
- Mention the new TAB commands in manual and keys sheet
- Represent a key not appearing in help by empty categories, not CmdNoHelp
- Enable pointman cycling key bindings with Control
- Factor out the pointman cycling key bindings
- Make sure item spotting messages are of proper length
- When spotting new items, write short message to screen and long to history
- Don't merge messages with different classes
- Enable messages that are not displayed unless from history
- When spotting items, sort them only once
- Don't report each item located in stash in a separate sentence
- Add verbosity flag to UpdSpotItemBag and UpdLoseItemBag
- Make new Direction type more general so that it can be used in other cases
- Add direction type to make cycle function less verbose
- Add functionality of back-tabbing both across floors and within single levels
- Add bool flag to cyclying so that direction will be possible
- Change naming of member cycling in-code to be keypress agnostic
- Swap S-Tab for A-Tab as new binding for cycling members on the same level
- Swap descriptions in help file so that tab functionality matches description
- Swap funcionality of Tab and S-Tab without renaming in-code
- Reverse order of S-Tab so that it doesn't first cycle to another level
- Add up to two EOLs in tile examination message
- Order tile examination message elements by decreasing importance
- Make terrain names harder to confuse with items
- Improve messages and order of stores when moving items
- Make ItemNotCalm message applicable to flinging and triggering, too
- Tighten the result type of moveItems
- Add a comment to the default config with an example for rebinding a key
- Clarify that nominal values of burning and wounding are used
- Don't call robots living
- Don't display TMI about total condition time if come from explosions
- Let AI prefer a buckler over a fist
- Nag about the F1 screen when starting or resuming
- Display info about scenario in F1 screen
- Split mode note into motivation and hints to choose where text is displayed
- Restructure text displayed on challenge menu to make it more clear
- Add scenario rule notes to be displayed instead of full notes
- Don't let crosshair obscure terrain, items and actors
- Work around SDL treating tilde as paragraph on some Mac keyboards
- Speed up DOM rendering by ignoring highlights if possible
- Permit specifying seeds in the config file
- Make attacking animation more subtle to distinguish from harm animation
- Even in the subtle hit animation indicate who is the victim
- Add a missing space between 'modify terrain stat' and '5' with square font
- Make Burn as valuable as other damage for consistent UI display
- Show very good no-timeouts weapons at the correct position
- Partially hash-cons ItemQuant, with very modest effect
- Change some occurences of trivial Quant to quantSingle
- Simplify skill and place menu code
- Don't multiply initialPlaces when preparing place display
- Consume places for places menu more eagerly
- Eliminate space leak when creating items
- Avoid memory leak due to caves used for levels on a list
- Fit the short help blurb in 4 lines
- Start the game with a confirmation prompt
- Sort weapons wrt timeout and item kinds ID as well
- Simplify querying skills of the leader
- Avoid long animations before the extra burn or wound animations
- Change combat animations to easily distinguish attacker from attacked
- Let AI displace teammates when no risk of displacing back
- Restrict AI use of stash guards less harshly
- Add a comment about allies stealing each other's stashes
- Let AI keep fleeing if no support gained
- Remove a few redundant TypeFamilies pragmas
- Explain in a comment why on a level with stash many sleeping may accumulate
- Make safari scenario harder now that aliens are buffed up
- Let AI displace friends less often
- Unify the test for item being damaging
- Improve module haddocs for content
- Hide unneeded content group name patterns
- Add short-caves debug game mode
- Display melee damage even if there's no ranged damage
- Reduce the number of calls to foeRegularAssocs
- Make sure AI actions are not recursive, even shallowly
- Reduce the number of calls to currentSkillsClient
- Speed up skill arithmetic
- Math order of cases in processWatchfulness with the order in type definition
- Remove inlines that stopped helping in GHC 8.8 and that obstruct profiling
- Compute friendAssocs only once for each actor AI processing
- Limit and speed up invalidating BFS
- Speed up a few significantly expensive functions
- Use the JS splitmix optimization
- Tweak random numbers code a bit
- Improve haddocks of the dice mechanism
- Improve help display a bit
- Move ClientOptions.hs to adhere to the convention about module hierarchies
- Meld LH and Allure content, continued
- Port over oil explosions that harm the targeted actor from Allure
- Meld LH and Allure cave and item content
- State the number of item in equipment even when removing from it
- Explain the goofy handling of recharging in stash
- Regenerate tile even if kind not changed, but all embeds gone
- Permit altering tiles with items on them
- Don't leave stash unguarded if friends may spawn
- Add stash detection effect
- Cap stat bonuses when assigning AI value to items
- Value skill bonuses differently for each skill
- Be even more specific when describing what an actor does on a tile
- Adjust the SDL test to run without installing fonts, as Debian requires
- Don't let projectiles ever cause normal tile transitions
- Tweak pushing via an embed
- Add Q&A about hearing
- Tweak item valuations to make awkward armours wearable by AI
- When describing an actor, say if it's pushed
- Push towards embed, not in direction of previous movement
- Simplify key bindings display code
- Clean up naming of column offset in UI
- Ensure no missing space between columns of help text
- Prevent a trailing space
- Don't activate barrels via mist
- Don't treat blasts that damage through effects as mists
- Don't let on noise distance if nobody can hear it directly
- Differentiate the sound of projectile and actor hitting a tile
- Emit sound also when an actor hits a tile
- Display close and out-of-level noises with special colours
- Display noise distance information
- Send noise distance information
- Refactor hearing
- Mock up extended hearing
- Give better message when not enough skill to melee
- Disturb resting when calm enough again
- Don't summon by hitting a projectile
- Make actor aggresive if only one is not guarding stash on the level
- Ban teleporting immobile foes; they come back and their loot is lost
- Validate that item group names are short enough
- Cath too long group names
- Catch empty group names
- Let more actors start sleeping
- Consistently create on the ground all items looted from terrain
- Mark game modes already won in this difficulty
- Clear screen after start ASAP
- Use the AttrLine smart constructor or assertions as appropriate
- Rename firstParagraph
- Tweak types to work with the stricter smart constructor
- Move assertion about trailing whitespace to a smart constructor
- Eliminate trailing spaces in help and item menus
- Replace a momentarily trailing space with nbsp
- Don't define special messages with space, they are added automatically
- When splitting lines, remove the trailing spaces
- Simplify a condition in splitAttrPhrase
- Don't add a space when appending a report that starts with newline
- Don't produce backdrop on black background
- Optimize truncateAttrLine and truncateOverlay
- Mark assertions expensive in menus
- Make avoiding SDL frame drawing more fine-grained
- Simplify SDL frame drawing based on previous frame
- Optimize menu scrolling via an extra texture
- Don't waste healing items when HP low ceiling
- Don't display that foes don't know their weapon when only you don't
- Reflect keybindings change in the start scenario menu
- Permit hero AI to consume elixirs
- Don't flee if can kill a blocking enemy instead
- Make fast or hasted actors willing to close in for melee
- Compensate for overhead of animals when creating conditions
- Mark organs that are ready to expire once applyPeriodicLevel runs
- Avoid stating that an organ will last for 0s
- Tweak slightly AI item preferences
- Get rid of DropBestWeapon
- Don't rechare nor discharge projecile payloads
- Start dicharging with strongest weapons
- Let Discharge add to cooldown, not reset
- Discharge only items with a timeout
- Consider as support only actors that can harm in melee
- Make organs (minimally) accessible from triggering
- Let AI trigger items among organs
- Relax trigger stat 1 restrictions
- Tweak AI item use preferences valuation
- Improve the gameover item menu message
- Record duplication of items to avoid absurd gameover messages
- Discharge not only equipment, but also organs
- Don't paralyse the last AI stash guard
- Give AI stash guard more freedom if friends adjacent
- Make AI keep guarding even if teammates on the level may leave it
- Don't let AI leave stash unless foes harm it
- Don't abandon stash when teammates temporarily immobile
- Prevent displacing a stash guard
- Don't abandon stash if temporarily nonmoving
- Abandon stash if under heavy fire
- Don't abandon stash unless foes seen
- Don't use aidTgtToPos unless necessary
- If enemy in light, pelt him instead of leaving dark
- Don't stop fleeing into hideout after 5 turns even if foes appear
- Target dark if fleeing and no foes targetted
- Efficiently find closest hideout for AI
- Tabulate hideout tiles predicate
- Factor out distanceBfs
- Don't hog leadership just because weak and enemies close
- When fleeing and soon after target only actors that can't melee
- Stop fleeing if not hit and possibly friends managed to join
- Take into account recent fleeing when taking off light
- Simplify hinders
- In AI action choice use recent fleeing instead of this and last turn distress
- Don't overwrite fleeing record if fled recently
- Don't chase foes if fled recently
- GC fleeing record when actor lost
- Extend fleeing state from 1 to 5 turns
- Store not only fleeing position but also fleeing start time
- Reorder organs
- Make two organs not LH-specific
- Don't undervalue weapons with drop condition
- Make it possible for animals to mark levels as explored
- Make slack tactics AI less erratic when focused or distressed
- Add a comment about animals bad at changing levels
- Let AI displace any sleeping blockers
- Don't let AI actors fall asleep if not relaxed
- Don't force animals to change target just before reaching it
- Improve condAimCrucialM for vector targets
- Flesh out the crawl survival test scenario
- Make crafting act as if on bottom level
- Move skill checks from pathfinding to targetting and restrict immovable actors
- Forbid making missiles hungry, asleep, etc.
- Optimize processTileActions
- Make sure projectiles can modify terrain even if safe from effects
- Don't reset TVector target, because it's set manually
- Create a central staircase
- Display ranged damage even when limited space in menu line
- Shorten the display of weapons if not enough space
- Don't consider enemy projectiles for determining if AI is in melee
- Make poison less deadly in corridors
- Eliminate the stash domination exploit
- Make guessing if AI was hit by projectiles more accurate
- Prevent wounded animals from closing in agains mutliple enemies
- In messages tell discharge from recharge effects
- Make smell more important that stairs, again
- Clean up vector target code
- Melee non-targets if target not worth killing
- Don't perform all monadic actions that compute strategies before choosing one
- Don't retarget actor if blocked by the very actor and so can melee it
- Simplify target shoice for slack doctrine factions
- Sort items in lists in normal texts
- Help AI unlock the dungeon if stash guard helds the key
- Prevent animals from eating their own meat
- Prevent creating new items via throwing others, with ikit
- Signal specially when an item is located in a stash, as well
- Say when an item appears in a stash, etc.
- Don't warn if selected missile from stash can't be picked up
- Don't flee if back next turn
- When fleeing don't remember the last targetted enemy
- Move keybinding content definitions to match display order
- Prevent, in UI, removing from equipment if not calm
- Warn when illegal item movement attempted
- Display stash blurb also when switching the leader
- Don't let stash guards leave levels
- Don't prevent displacing a friend if only half of a loop is present
- Don't neglect guarding stash unless no buddies to help
- Tweak AI conditions
- Don't flee if own stash close unless completely overwhelmed
- Easily displace teammates that guard the stash
- Mention stash when walking over a tile
- Do not flee and be reluctant to chase when guarding stash
- Introduce guarding own stash
- Make isDoor more accurate
- Don't make a rumble when door closes
- Tabulate isOpenable and isClosable
- Make tall staircases more likely now that they are often broken
- Make types a bit more strict in stairs calculation
- Simplify stair number computation
- Rename cextraStairs
- Change the semantics of cextraStairs
- Separate stair number computation and level generation
- Compute abandoned stairs earlier
- Correct the documentation of cextraStairs
- Roll extra stairs earlier
- Roll cave kinds earlier
- Simplify shuffling caves
- When transforming walkable tiles, don't insist on embed activations
- Ban crafting and terrain transformation in the same action
- Try to make the terrain transformation specs more readable
- Prevent the exploit of using cover against non-moving shooters
- Make makeLine non-monadic
- Keep the data invariant of @arenas@ for longer
- Make the *interrupted* running display look less corrupted
- Add and tweak comments about item maps
- Update the manual and keybindings printout
- Tweak the wording of keybidings descriptions
- Prevent marking inert items as (charging)
- Add ANY_FLASK group
- Make sure impression is dropped before other conditions
- Handle failed bump-modification without embed activation
- Change the key for new game, not to mix up with 'n'o
- Remove misleading comment about tiles being explorable
- In message fits in one long line, don't wrap it into small lines
- Don't make consumables with Ascend effect worthless
- Change division by zero into an assertion failure
- Comment why 'seen' sometimes gets from 100% to 99%
- Validate HideAs in content instead of asserting its property later on
- Tweak (speedup the tiniest bit) updAlterTile
- Stop leader before leaving dark in a more useful way
- Don't equip light even if enemy only remembered
- Simplify the interesting target conditions for AI
- Flee through dark not only when starting in light
- Chase and flee through dark even if not starting from light
- Simplify the chasing ambient light condition
- Prefer leaders that don't step into light
- Detour when chasing, to avoid lit spots
- Prefer fleeing into dark spots
- Don't flee from projectiles if can't flee into the dark
- Prevent AI from vainly chasing fast shooters
- Tweak and simplify AI fleeing condition
- Help AI sidestep a blocking meleeing friend
- Let AI go towards enemy stash even if in melee
- Join melee from twice longer distance
- Rename CURIOUS_ITEM
- Don't display 0 ranged damages
- Add missing content group definitions
- Simplify content validation
- Check that content group names are all listed
- Let the draft detector emit noise and sound
- Tweak the engine to accomodate a detection device that pings
- Prevent non-humans from hogging key items and so blocking progress
- Reorder item definition to match those of Allure for diffing
- Don't emit server leader change messages if known to client
- Comment about the trade-offs of weapon benefit calculation
- Mark the lore screen with crafting recipes
- Don't confusingly refuse to display the pushing effect for shields
- Increase minimal damage taken, regardless of armor, to 5%
- Be pendantic when emitting messages about creating items
- Don't say that a projectile is wounded
- Show enemy HP under the selected item
- Simplify strongestMelee
- Add an alias for picking up all items, etc.
- Sort out naming of item and embed activations
- Simplify revCmdMap
- Warn when embeds activated, but transformation failed
- Check dangerous tools use even when nested in transformations
- Don't transform terrain when bumping
- Let pathfinding avoid vicinity of enemies
- Make it easy to discern an attack on teammate among many messages
- Don't display misleading condition drop messages
- Visually distinguish embed names and descriptions
- Permit fractional FPS, for debugging
- Colour-code map position descriptions
- Move the run macro to where all other engine macros are defined
- Permit unknown command, for testing
- Simplify and clarify the mock
- Unify repeatHumanTransition 1 and macroHumanTransition
- Reflect in types that macro frame stack is never empty
- Make more space for explicit import lists
- Rename components of the macro data structure
- Drive the point home that repeatHumanTransition 1 /= macroHumanTransition
- Add tests that illustrate not creating new buffers for in-game macros
- Touch up the macro code a bit
- Add tests showing lack of referential transparency of named macros
- Don't prompt about recording a macro it's part of macro replay
- Warn when pick up not to equipment due to low calm
- Display how many items in equipment when equipping
- Refuse to equip if equipment full
- Separate testing harness import from game content import
- Add a helper function to shorten tests
- Rename the semantics functions
- Implement the desired semantics of RepeatLast
- Sketch the desired semantics of RepeatLast via tests
- Use the same updateLastAction function in test mock
- Collect a more precise last action key
- Simplify slightly the mock
- Grey out more (all?) illegal commands
- Add special messages when illegally flinging or applying
- Go even through stores that all factions have empty
- Revert banning stores for all actors based on the first checked
- Add special messages when illegally moving items from or to eqp or ground
- Forbid unequipping items when not calm, again
- Don't ignore illegal stores if once shown
- Display the number of items in equipment even when not calm
- Write client RNG seed to UI RNG seed numbers at game restart
- Save UI random seed to avoid boring messages if many save/loads
- Add a comment about stealth viable for tactics, but not strategy
- Reset C-f when x-hair automatically changed
- Pick as leaders also the actors that could melee but should not
- Make animals unable to catch projectiles
- Don't cycle xhair through own stash
- Display slideshows normall unless really too long, not just excessively long
- Give more time to view a frame when frame level changes
- Be more verbose when kicking terrain
- Prevent the inability of taking off max calm draining items
- Re-assign action repeating keys
- Clean up macro command's texts
- Place ikit item in a semi-random way
- Tweak content group names for display
- Avoid 'of gain of gain' in item descriptions
- Don't talk about blocking when no kinetic damage dealt
- Match the order of game over lore screens with in-game lore menu
- Prevent AI from imbibing a potion of panic
- Don't call a tile alterable if embeds have no effects
- Prefer leaders that target enemy stashes
- Don't chase stashes of friends and neutrals
- When creating items on the floor during dungeon generation, create ikit items
- When embedding items in tiles, optionally generate more items
- Redesign so that charging items can be determined even if timeout unknown
- Clean up some instance deriving
- Factor out two more pure functions about macros to use in unit tests
- Permit creation of input content without parsing a config file
- Factor out pure function about macros to use in unit tests
- Record nested macros on stack
- Snatch enemy stash ASAP if adjacent
- Port tests to tasty
- Undo the attempt to end game when player kills window
- Remove a spurious recordHistory
- Make sure verifyCaches error doesn't obscure RNG seed of the crashing run
- Don't let big actors auto-craft at death
- In menus show how long conditions will last
- Tell how for long an actor is going to be slowed when first affected
- Tell how for long an actor is slowed in total after extra slowness, etc.
- Tell how much poisoned actor is in total after extra poison, etc.
- Don't display the mandatory turn frame if a frame already displayed this turn
- Don't draw (and printscreen) identical frames, even if small fonts used
- Don't trigger terrain if projectile has lost its payload
- Enable cooking of food thrown into fire
- Don't spam when blasts transform terrain
- Simplify dieSer
- Ensure the last step of projectile flight is shown
- Remove a repeated check
- Be more verbose when transforming items with scrolls
- Display level where the stash is, as a reminder
- Don't displace sleeping immobile actors
- Simplify checking if an item is identified
- Prevent AI from putting most weapons in reserve
- Let AI be eager to equip unidentified and good unique items
- Don't be too verbose with tile altering when leader stands on it
- Don't craft from equipment due to possible involuntary harm
- Remove altering via dropping items; too disaster-prone
- Refactor handleDir
- Permit indicating the zero vector with mouse
- Colour and reword the message about consuming items
- Be a bit more verbose about tile changes
- Don't inform about a projectile's equipment
- Avoid hitting 'feebly' with a heavy hammer
- Show, e.g., harpoon as an obvious choice for throwing despite usable for melee
- Don't summon by hitting a friend
- Don't hit delicately just because the weapon was not identified
- Prevent AI from wasting time throwing very weak projectiles
- Avoid 'chip of scientific explanation turns out to be', when identifying
- Improve item destruction messages
- Add OnUser effect constructor
- Avoid 'the pair turns out to be' when identifying
- When short name requested, don't append numbers and parens
- Prevent VerbMsgFail being repeated 99 times
- Describe how colours correspond to tile properties
- Let even unskilled actors take over stash
- Take over stash also when actor dominated or created
- Target enemy stash in preference even to enemy actors
- Add comments about salter and pathfinding
- Avoid 'controlled by Controlled foo'
- Avoid 'hits delicately' with a 14 HP wounding hammer
- Ensure in content that Burn is positive
- Mark weapon burning and wounding on HUD, to avoid hammers all look benign
- Clarify that chosen weapon needs not be optimal for a foe
- Improve display of places lore
- Pick up enemy summoning periodic items to deny them to foes
- Don't send the SfxTrigger messages to the client
- Mention that stats menu summarizes the organ menu
- Add sample cabal.project.local files
- Introduce VerbMsgFail effect
- Let crafting use up terrain, if successful
- Don't split tile properties description by description of things on the tile
- Avoid crafting via walking into a worshop tile
- Introduce SeqEffect to use for crafting creation in place of AndEffect
- Let components 'disappear', not 'be removed' during crafting
- Improve crafting recipe description
- Automatically identify crafted items
- When cratfing, use tools but destroy components
- Don't create items in equipment if not enough free slots
- When crafting, apply as many copies of durable items as required, not just one
- Don't crash if crafting fails due to unique already generated
- Improve debugging of item creation
- Don't display thrown damage for organs
- Flesh out projectiles opening terrain and flying through
- Require embed activation even for item-fueled terrain transformations
- Don't spam if recording is a part of a macro
- Make the summary of killed enemies less confusing
- Let some explosions destroy terrain
- Add black backdrop beneath prop font overlays, for readability
- Be even less verbose in descriptions of items with crafting
- Validate that item definitions have slots whenever expected
- Rename the Macro type
- Record also in-game menu navigation keys
- Recover macro's recording order invariant
- Document Macro, swap types in smacroBuffer's Either type
- Wrap the macro buffer into a newtype
- Encode recording state in type of macro buffer
- Be more precise when reporting OnCombine effects
- Format crafting recipes in a more readable way
- Gather effects application flags into one record, for redability
- Add an assertion that catches ItemQuant data invariant violation
- Ignore timeouts when using tools or transforming terrain
- Don't apply kinetic damage when using tools or transforming terrain
- Generalize printing crafting recipes to many products
- Rename the dagger item definition to match Allure
- Help parsing recipes with bullets
- Avoid spike 2d1 (cooldown 8) of cooldowns at 4
- Typeset crafting recipes slightly
- Rename the whetstone item definition to match Allure
- Don't repeat crafting recipes in OnCombine descriptions
- Show full crafting recipes only in lore menu, not when targeting
- Speed up and simplify the use of countIidConsumed
- Alter ConsumeItems and unify with ChangeWith
- Add optional count parameter to effect CreateItem
- Validate that item definition parameters in content are positive
- Display details of item crafting effects
- Add ConsumeItems effect
- Let AI ignore potentially unopenable entrances, to avoid AI loops
- Improve messages related to Discharge effect
- Simplify checking actor presence on a level
- Add the Discharge effect
- Be more verbose when loot created
- Don't complain about failed transformation if embedded item triggered
- Revert "Break thrown non-unique items, even if durable"
- Let projectiles trigger only easiest embeds and alterings
- In tile content specify if projectiles may trigger actions
- Display when ending a flight, to make harpoon a sensible weapon
- When actor lacks tools to transform a tile, inform him
- Break thrown non-unique items, even if durable
- Squash repeated terrain transformation tools in descriptions
- Confirm that a weapon is to be used for transformation
- List tools needed for transformation in terrain description
- Factor out client altering conditions
- Unify altering by bumping and altering by pointing and server conditions
- Don't waste turn when altering fails, but waste when embed triggering fails
- Factor out listToolsForAltering and subtractGrpfromBag
- Permit the use of tile altering tools with different durabilities
- Factor out parseTileAction
- Don't count repetitions in OneOf effect description
- Prefer non-durable altering tools, even in equipment
- Avoid message about triggering a 'way' without any more details
- Rename terrain patterns that denote possibly depleted resource
- Consider durable tools last for terrain alteration
- Process tile features in order to prefer trap disarming to triggering
- Prevent embeds triggering each other in a loop
- Simplify applying embeds
- Display untruncated (and mangled) messages in teletype mode
- Make frontendName to avoid losing message in teletype frontend
- Clean up the presentation of group name patterns again
- Verify that singleton group names are so
- Separate singleton kind group names
- Validate that some more kind groups are singletons
- Rename HideAs to PresentAs for item kinds
- Simplify individual content validation due to stronger global validation
- Check that group names unique and not void
- Supply group names to the content creation and validation function
- Improve special gameover messages
- Clean up the lists of hardwired patterns
- Get rid of OVER in pattern names
- Clean up the DEFENSELESS vs VULNERABLE mixup
- Remove foldl from prelude to prevent space leaks
- Group the patterns yet slightly differently
- Catch empty OneOf during item content validation
- Group the patterns slightly differently
- Be consistent in taking only first word as game mode name
- Rename PHD_DEFENSE_QUESTION to VULNERABILITY_BALM for diffing with Allure
- Group TileKind patterns
- Remove IsString instance of GroupName to catch typos
- Reorder code in content files
- Make embed content patterns different from tile patterns
- Use PatternSynonyms for all content
- Permit and use PatternSynonyms in some ItemKind-related code
- Don't crash when some items consumed during dropping
- Don't warn about untriggered embeds; altering may be the focus
- Don't report exploiting if not triggered
- Let terrain be changed with items even when embeds not untriggered
- Be less verbose when losing items
- Be more verbose when losing items due to tile altering
- Report which embedded item was exploited so that 'Nothing happens' makes sense
- Don't report items appearing under projectiles that are already spent
- Reword command category headings
- Don't move away staircase inhabitants if projectile is changing levels
- Let only visible projectiles discover hidden tiles, etc.
- Don't display vacuus menu mode switch symbols
- Waste items for altering only if voluntary or released as projectile
- Get rid of spam about inability to modify terrain
- Identify item lost in order to modify terrain
- Let projectiles alter terrain, but not when just flying over it
- Don't check alter skill when projectiles do the altering
- Improve comments about the 6 tile modifying constructors
- Don't modify terrain by just walking over it
- Permit the use of equipment for modifying terrain
- Warn when no items to modify terrain
- Prefer durable items for altering tiles
- Don't destroy but apply durable items used to alter tiles
- Add tile alteration that demands and consumes items
- Improve description of cooking effects
- Add OrEffect binary constructor
- Replace Composite by a binary constructor
- Display failure message when embed not under feet triggered vacuusly
- Don't light adjacent tiles for free
- Avoid 'you look less hungry' about the pointman
- When smashed item exhibits no effect, don't warn
- Report tile changes under a big actor
- Generally never alter tile if under feet and embed not triggered
- Detect when dropping or destroying items is vacuus
- Only alter tiles via walking on them if any embed triggered
- Don't spam when embed doesn't trigger when walked over
- Implement DestroyItem effect
- Let embedded items react to items dropped over them
- Explain away only pointman moving
- Inform about automatic melee in the in-game help
- Mention that all factions and actors are equal
- Reverse stars and underscores in HP bar in HUD
- Stress suvival in the game manual
- Make skill check for embedded items on the client consistent with server
- Give hints when terrain can't be entered nor modified
- Describe hunger removing items, etc., with more detail
- Mention leap frog in game manual
- When scrapping message repetitions, ignore trailing EOLs
- Don't spam about items underfoot at game start, when they are also 'located'
- Report moving player's stash on a new line, mostly for starting screen
- Bring back scenario notes at game start and resume
- Bring back notes in challenges menu
- Handle the meta note about scenario separately
- Mention challenges in the high score entries
- Remove the Show instance of ScoreRecord
- Invalidate inMelee when weapons dropped or picked up
- Use --assertExplored in makefile tests
- Verify the commandline assertion about explored level
- Don't assert exploration if another game started in a debug run
- Add a debug commandline option to verify explorers are not stuck
- Make projectile-less actors randomly more aggressive
- Add a bit of histeresis when fleeing
- Destroy proportional font textures to avoid freezes when they pile up
- Prevent AI from running away from helpless foe
- Stop targetting foes once they lose all weapons
- Let AI do more vs foe with HP <= 0 to avoid stalemate if foe regenerates fast
- Don't spuriously check if TEnemy is a foe
- Improve documentation of targeting
- Don't attack hapless nonmoving foes at range also
- Don't normally target nonmoving actors that can only melee
- Use actorWorthMelee in inMelee
- Melee a targeted foe even if not worth meleeing otherwise
- Don't target hapless uninteresting foes
- Don't melee a foe with only benign weapons
- Don't consider foes with benign weapons a threat
- Only consider actor in melee if adjacent foes worth meleeing
- Don't interrupt running if benign melee actor adjacent
- Introduce the count of benign weapons of an actor
- Make sure tutorial scenarios have enough melee weapons
- Avoid checking isModifiable once more, in verifyAlters
- Consistently check isModifiable together with embeds
- Mark the new request failures as impossible on the server
- Add some internal operations, for future easier profiling
- Removed TileOpenClosed error message
- Further enhancements in tile closing
- Removed TriggerTile
- Remove commandline default that forced Just that is interpreted as game reset
- Bring back the way dungeon generation perturbed random rolls
- Make 64bit native and 32bit browser games play the same with the same RNG seed
- Keep a separate random seed for UI
- Use bitmaskWithRejection form randomR
- Add some BENCHOPTS
- Use splitmix
- Suggest switching to another teammate if movement skill drained
- Turned off showing of default --maxFps value
- Additional logPriority value and defaultMaxFps
- Couple command line options are now clamped or checked before they're set
- Only run with selected actors that are not yet at goal
- Hint about menus in movement stst too low message
- Hint to wake up if movement skill drained by sleep
- Display also own asleep actors green on HUD
- Make the heading of item menu when inspecting an organ less confusing
- Tell that second 'f' projects
- Add a comment about the 'exploit' verb
- Do not mention 'trunk' in weapon strike messages
- Do not mention 'trunk' in armor blocking messages
- Suggest in history menu to press RET
- Get rid of Server.EndM
- Make sure closing window in rage at defeat/win saves game
- Mention in the manual that HP starts at half max
- Reformat game peculiarities list in the manual
- Don't announce pushing that has no effect
- Try to make the under AI control prefix less confusing
- Let animations be toggled in main menu
- Don't display buttons on a separate line unless message is very long
- Add a newline after scenario description
- Avoid blank lines in history
- Overhaul the order and blurbs of game modes
- Make raid scenario squad-based
- Display scenario descriptions in their submenu
- Don't show backstory in submenus of the main menu
- Rework new game start menus
- Add a visual separator between new games in history
- Reverse the order history messages are displayed in
- Copy the list of distinguishing features from Allure homepage
- Restructure chronologically the game manual with verbs as section titles
- Avoid empty paragraphs
- Ignore linebreaks when showing the condensed history line
- Underline that mouse is optional
- Make 'crosshair' on the status line uniform with other headers
- Bring back the help prompt that doesn't confusingly mention advancing
- Mark overful HP and Calm specially on HUD
- Add some blank lines when stacking command lists
- Stress that mouse is optional
- Move mouse help screens earlier
- Don't indent help parts by proportional space width
- Clarify the structure of help information
- Don't show 'crosshair' when not aiming
- Get rid of 'x-hair'
- Make collective running less prominent in help; tweak help
- Mark some text files as out of date
- Add a paragraph break before nearby item summary
- Accept longer menu messages
- Add a paragraph break before cave description
- Warn that over-max HP gain is transient
- Mark deaths with paragraphs and display 'Alas' already at incapacitation
- Add a line break after gameover identification of items
- Add a couple of line-breaks to reports
- Rename emptyAttrString, which was misleading
- Introduce a newtype of attribute lines with no linebreaks
- Prevent backstory overflow in main menu with proportional font
- Move O command just after I command in help
- When toggling autoplay, as with y/n, not SPACE/ESC
- Let left and right arrow keys move between sides of help screen
- Fine-tune helps screens for display side-by-side
- Naively cram help screens side by side
- Merge the two item command help pages
- Use proportional font for help, dashboard and item menu
- Use square font for movement scheme help paragraph
- Make it possible to use many fonts in help
- Get rid of MoveKeys.txt
- Set up main menu for both proportional and square fonts
- Remove backstory from help screens
- Add backstory to main menu, set up for square font, for now
- With square font, add extra space before item symbol
- Represent button width as a datatype
- Parameterize all typesetting by the font setup (multi or single)
- Pass along information about supported fonts
- Let sdl frontend really handle the setup with no prop nor mono font
- Gut out ascii art
- Add blank space around some lines of overlays
- Take all items with *, not !
- Update the item removal verb
- Switch a single place lore display to mono font
- Render skill menu and item lore menu with proper fonts
- Display item symbol in item menu in square font
- Display label and symbol in items overlay using square fonts
- Display at most 3 lines of buttons when too little space for menu
- Make a mouse misclick error easier to understand
- Don't wrap Mono keys after a prompt
- Overlay in square font when basic frame is under animations
- Introduce a separate UI coordinate system
- Make boxSize even
- Don't highlight wrong overlays when buttons highlighted
- Avoid proportional font in button-like UI areas
- Permit overlays with gaps
- Name font kinds consistently
- Display some overlays in monospace font
- Display history labels in mono font
- Specify fonts also in slideshows
- Move the definitions of DisplayFont and FontOverlayMap
- Propagate the choice of fonts for overlays
- Generalize drawOverlay to specify desired font for each overlay
- Generalize overlays to let them start at arbitrary X offsets
- Eliminate overlayFrameWithLines
- Document better the overlay types
- Move ColorMode to another module
- Specify when to use which kind of main font
- Add monospace rectangular font to game configuration
- Remove the old woff font
- Add new fonts, proportional and monospace
- Specify size of the message font separately
- Don't cursor highlight break up proportional font message chunks
- Don't let space break up prorpotional font message chunks
- Render the extra overlays in proportional font
- If message font supported, pass overlay over instead of rendering
- Initialize also the message font in SDL frontend
- Add message overlay font to game configuration
- Comment about why animals rarely eat food
- Rename tactics to doctrine
- Get rid of the henchman notion
- Rename leader to pointman
- Handle UpdTimeItem when container not visible (CStash), but item visible
- Improve command descriptions
- Redefine key bindings not to collide with new movement keys
- Detect collisions of keybindings with movement keys
- Use the keys freed by removing the right hand movement setup
- Replace right hand with left hand movement keys
- Main inventory the main store in game help and UI
- Move total value display to all posessions menu
- Identify items at any item move, in case they are thrown at stash
- Avoid spam about actors getting braced
- Mention in failure messages that hoard accessed when stading over it
- Mention in failure messages that too low Calm for Eqp
- Attempt to display handling of multiple items more succintly
- Bring back UpdMoveItem to have better messages
- Properly describe item move actions
- Lose access to stash when enemy steps on it
- Say who's stash is an item moved to, unless it's ours
- Announce that enemy stash found
- Make sure to let clients know even the human trinket items at gameover
- Let new stash correctly overwrite old, even if old not seen
- Introduce PosSightLevels and use for CStash containers
- Get rid of seenAtomicGeneralCli
- Simplify handleAndBroadcast
- Make updTimeItem more loose when enemy CStash is considered
- Don't carry item definitions in commands that don't create items
- Register on the client the items necessary for commands
- Analyze what items client needs to know to process a command
- Clean up creation vs spotting of actors and items
- Add UpdRegisterItems to be used instead of many ad-hoc calls currently
- Be permissive when performing atomic action wrt CStash
- Simplify SfxStrike, etc., and don't require access to store's bag
- Simplify PosFidAndSight
- Remove UpdMoveItem atomic command that is not too common without CInv any more
- Simplify handling of CStash action visiblity
- Display also enemy stashes in position description
- Let actors learn stash positions when they come into view
- Mark on the map enemy stashes as well
- Refactor UpdStashFaction to let enemies see it sometimes
- Add shared stash position to team's perception
- Say in position description that stash is there
- Mark own shared stash position with white box
- Remove gstash handling in atomic commands
- Move CStash in server code, not atomic commands
- Avoid catch-all in cmdAtomicSemSer
- Introduce UpdStashFaction
- Do not produce a now unused ItemFull for inventory
- When moving items, don't cycle to Ground, when over stash
- In UI don't try to use CGround when over CStash
- Don't let AI consider floor items at it shared stash location
- When scanning a map, don't consider own stash an ordinary pile of items
- Update atomic position information for shared stash
- Make eqp, not stash, unavailable when low Calm
- Make CStash the new implicit default when picking up items
- Gut out CInv and CSha and replace it with CStash represented on the map
- Remove the unused effect ActivateInv
- Bump version, anticipating major inventory logic overhaul
- Reword the MOwned item dialog mode blurbs
- Simplify the header of the lore menus
- Change meny keys / and ? to > and <
- Update scenario names in the manual
- Mention the ! key whenever KP_* is mentioned
- Simplify and fix placement of --more- prompts
- Change the AttrString word gluing operation and fix drawFrameStatus
- Slightly fix speed calculation to agree with what's on the wiki
- Fix a memory leak from tutorial hints repetition avoidance
- Fix no frames displayed while resting
- Fix missing dot at the end of taunt message
- Fix heroes starting on exit in escape scenario
- Fix the healing necklace better used from the backpack
- Fix which are considered minor effects
- Fix spurious double space suffix when rendring on blank
- Fix mouse in area help, wrongly typeset with square font
- Fix interruption message not appearing on screen, only in history
- Fix wrong order of words in the detection effect message
- Fix and simplify armor conditions message choice
- Fix good conditions displayed in red
- Fix broken combat description condition about armor
- Fix not updated tutorial switch when game won
- Fix a hint wrongly guessing the damage was piercing
- Fix failures not stopping macro playback
- Fix the lack of 'a' when hearing distant summoning
- Fix using the reserved number 0 for faction ID
- Fix backing up broken savegames
- Fix a spurious space before a sentence ending dot
- Fix lack of capitalization in verb messages
- Fix genetic flaw activated at death
- Fix a typo in identifier names
- Fix first lines of message wrapped too late
- Fix botched conditions for SfxFizzles, etc.
- Fix includeMetaGame computed twice
- Fix meta game identification not carrying through to the next game
- Fix accumulating meta game item kinds
- Fix scenarios with numbered actors but without continued team
- Fix an optimization two lines too low in shuffleExcept
- Fix a triple copy-pasto with Ability.MetaGame
- Fix discoMetaGame for clients with state held by server
- Fix displaying deflection when the perpetrator is not seen
- Fix tutorial hints disabling
- Fix a link to roguebasin
- Fix short wrapping of adventure lore
- Fix overflowing messages with more than 2 spaces
- Fix 4 spaces message indentation with square font
- Fix trash on fullscreen borders
- Fix not showing aiming line when changing epsilon
- Fix trying to describe an item that is not seen by the actor hit with it
- Fix whitespace in displayRespSfxAtomicUI
- Fix display of message log aligned to newest message
- Fix extra SPACE needed to see history after game save command
- Fix running broken due to vacuus MsgAtFeetMajor messages
- Fix MsgStopPlayback not stopping running
- Fix usage of two different widths in splitAttrString
- Fix history lines starting with EOL
- Fix monospace overlay whitespace spilling onto proportional
- Fix wrongly enabled display of MsgRunStop message class
- Fix deduplicating shown and saved messages separately
- Fix, again, leftover UI clients killing frontend after already killed
- Fix the numeric display of HP gain/loss
- Fix wrong SDL wrapping markers when using mono fonts only
- Fix a missing mouse command description
- Fix Tasty tests broken by frontend fixes
- Fix screensavers broken by UI faction not being the first
- Fix a bug with two UI clients interspersing frames
- Fix 'open main menu' command of Dashboard
- Fix the GTK frontend again
- Fix a syntax error in travis script
- Fix license name
- Fix linearInterpolation for inflated dungeon depths once more
- Fix running disturbed by many boring tiles at open levels
- Fix MsgItemMove messages not saved to history
- Fix unintentional cap on actor generation level
- Fix calling gameover and 'endgame'
- Fix lack of EOL before initial separation line of history
- Fix mouse coordinates in the browser
- Fix assigning number symbols to hero faction projectiles
- Fix and improve how deflections are displayed
- Fix a 32bit system bug that intCast detected
- Fix damage not displayed when other attributes are
- Fix flinging from item menu cancelling item selection
- Fix the comment about users able to overwrite keys
- Fix a crash when impossible command chosen
- Fix bitrot that corrupted curses frontend
- Fix 'the fallen falling' projectiles
- Fix wrong alignment of level percent seen
- Fix autoexplore with changing crosshair
- Fix goto not interrupted change of crosshair
- Fix the valuation of OnUser effect
- Fix the lack of the last backdrop line in the game greeting blurb
- Fix memory leak in placesFromState
- Fix double braced due the hack for skill-less yelling
- Fix order of using weapons inconsistent with HUD
- Fix actor that can't wait not ignored as a pointman even when inactive
- Fix stash guard preferred as pointman
- Fix AI leader choice to really prefer old leader and to avoid light more
- Fix raid scenario starting with two faction close to escape
- Fix random number out of range on 32bit JS
- Fix teleport effect from stash item not identifying it
- Fix warnings in gtk frontend
- Fix the extra blank menu line starting too late
- Fix section links in the game manual
- Fix and simplify rules for disabling tile transformation
- Fix missed blank prefixes of empty lines inside text
- Fix and simplify projectiles activating and transforming terrain, again
- Fix projectiles not able to lit up oil
- Fix padded empty string overwriting UI elements
- Fix the position of second column with square font
- Fix trailing spaces in dashboard
- Fix a trailing space in a message
- Fix disable extra empty shadow line at the bottom of menus
- Fix determining if item identified in permittedPrecious
- Fix an actor pulling himself
- Fix desynchronized copy-pasted actorVulnerable code
- Fix history message display header
- Fix Calm measurement code to match code documentation
- Fix sleeping stash guard not considered a guard
- Fix reaching escape from below when all levels explored
- Fix hero AI sometimes not exploring levels fully
- Fix weapon order of Smithhammer
- Fix messages about melee-only armor deflecting missiles
- Fix wrong condition, wrongly reducing fleeing behaviour
- Fix comments about slack doctrine targets
- Fix assertion failure when targetting a tile under oneself
- Fix code documentation about inventory stores
- Fix the unequipping failure message condition
- Fix wrong cave reversal when generating dungeon
- Fix non-pointman heroes meleeing healing geysers
- Fix poisons never activating and never running out
- Fix registering if altering failed due to bumping
- Fix a bushy patch that can block starting actors
- Fix diverging definitions of foes worth killing
- Fix barrels not destroyed by bumping
- Fix inability to open doors due to no embeds
- Fix projectiles not to bump off, but to transform terrain
- Fix the display of level in stash menu header
- Fix alliance placing to put heroes over stairs
- Fix a wrong message when displacing a waking foe
- Fix AI not eating and not removing other bad conditions
- Fix nested macros
- Fix wrong game mode started due to only the first word inspected
- Fix the result of AndEffect
- Fix the warning when flinging benign items
- Fix a loop when actor pushed to another level via stairs
- Fix melee disrupting pushed flight
- Fix unidentified weapons marked in HUD as without timeout
- Fix modelling wear and tear with DestroyItem
- Fix mixed up resistance conditions
- Fix item dropping crashes when OnSmash effects remove them while dropped
- Fix an AI loop when applying a recharging item
- Fix some no-fence places not appearing in statistics
- Fix display of empty lists of tools for terrain transformations
- Fix referring in the server code to definitions from the client internals
- Fix embedded items activated twice
- Fix an attempt to consume more items than there exist
- Fix broken running macro
- Fix activating embeds
- Fix repeating predefined macros
- Fix unsafe recording
- Fix in-game macro system
- Fix discharging an item that is not recharged
- Fix consumeItems missing in an export list
- Fix missing spaces in describeToolsAlternative
- Fix display of tool alternatives
- Fix random results of sortEmbeds
- Fix checks if actors in combat
- Fix the semantics of Discharge effect
- Fix a crash when updating invisible item timer
- Fix altering skill check in the client
- Fix omission of OpenWith when OpenTo is considered
- Fix unidentified embedded items impossible to trigger
- Fix usage of outdated state component when altering tiles
- Fix an attempt to apply a used up embedded item
- Fix the direction of < and > scrolling in ending screens
- Fix rubble tile definition wrt order of activated features
- Fix old actor body used after altering caused by collision with terrain
- Fix wrong condition for alien captured at victory message
- Fix moving only all or none items between containers
- Fix crash when actor not visible after triggering an item
- Fix crash when dopping previous may destroy next items
- Fix projectile altering a tile too many times at once
- Fix DropItem reporting no activation due to item vanishing earlier
- Fix off-by-one when picking projectiles with enough range
- Fix trying to destroy an empty item bag when modifying terrain with it
- Fix assumption that if last actor is alien, game is won
- Fix no identification message sometimes in the first turn
- Fix compilation without EXPOSE_INTERNAL
- Fix the trap of drain Calm item in equipment that can't be removed
- Fix tiles never altered via walking on them
- Fix articles incorrectly recognized in words that end similarly
- Fix wrong calculation of number of non-durable weapons
- Fix incorrect conjugation
- Fix a corruption of backstory text
- Fix first character of buttons sometimes overwritten by space
- Fix wrongly displaying a special ending for small scenarios
- Fix other frontends wrt engine and sdl2 frontend changes
- Fix proportional overlay overwriting first character of mono one
- Fix help setup for large screens
- Fix broken item menu with square font
- Fix wrong button initial position with square font
- Fix distant overlays wrongly getting a highlighted line
- Fix SDL frontend truncating proportional font lines
- Fix and tweak measuring texts in various fonts
- Fix empty menus in single font mode
- Fix spurious ending prompt in single-font setup
- Fix padding of line chunks overwriting subsequent chunks
- Fix display of history
- Fix buttons holding other locations of an item
- Fix not shown highlight of prop font lines
- Fix spurious empty line between header and menu
- Fix use of fromAscList where fromDistinctAscList would do
- Fix spacing in history display
- Fix off-by-one crash in history
- Fix mouse clicks on buttons in small font areas
- Fix updateLine for the case of multiple overlays
- Fix overrun in mouse help table
- Fix history highlight restricted to 80 columns
- Fix menu highlight splitting proportional text chunks
- Fix proportional texts never wiped out
- Fix horizontal starting points of message chunks
- Fix a syntax error stemming from wrong CPP
- Fix illegal containers creeping into item choice
- Fix cmdAtomicSemSer for UpdMoveItem
- Fix AI not sidestepping explosive tiles, even if it could
- Fix AI not sidestepping nearby actors
- Fix cmdAtomicSemSer in the presense of CStash that acts like CFloor
- Fix broken atomic commands assigned wrong LevelId
- Fix visible enemy stash position not updated, because foes not seen
- Fix countless typos
- Start using cabal-plan
- Fix and improve Makefile, cabal file and CI scripts
- Improve and update game manual and help texts wrt game changes
- Tweak travis scripts and building docs in README

## [v0.9.5.0](https://github.com/LambdaHack/LambdaHack/compare/v0.9.4.0...v0.9.5.0)

- Fix NumLock disabled in the browser
- In screen reader frontend, highlight active menu line with the cursor
- Clone the main main menu commands as map mode commands
- Add C-RMB and C-S-LMB as alternatives of MMB
- Announce prominently MMB binding for describing map positions
- Clean up the default config file, keeping compatibility
- Make scenario names longer and slighlty more informative
- Make Vi movement keys the default in addition to keypad and mouse
- Fix a bug where death prompt when autoplaying was capturing a keypress
- Let ESC from main menu return to insert coin mode, if applicable
- Make various small UI tweaks, especially to main menu and its submenu
- Let main menu lines have 35, not 30, characters
- Make the main menu ASCII art less intrusive (and easier for screen readers)
- Don't invalidate the score file due to game minor (only) version bump

## [v0.9.4.0](https://github.com/LambdaHack/LambdaHack/compare/v0.9.3.0...v0.9.4.0)

- In vty frontend highlight actors more
- Clean up actor highlighting
- Add yell/yawn to minimal command set, remove swerving the aiming line
- Invoke yell/yawn exclusively with '%', due tor Windows and terminal woes
- Move C-c command to C, not to mask C-c on console frontends
- Tweak and fix vty console frontends, for screen-readers
- React specially at gameover under certain special circumstances
- Simpliy assignSlot now that slots are auto-sorted
- Get rid of explicit item sorting; let lore and menu slots agree
- Make DetectExit non-modal
- Mark in a game end confirmation message that more treasure can be found
- Add a description to the escape embedded item
- Reword gameover text for raid scenario
- Be more verbose when confirming escape from the game
- Don't claim to summon, when not possible on this level
- Fix missing 'no longer poisoned' when applying antidote
- Don't ask confirmation for neutral (e.g., not IDed) items
- Fix 'you fall down; you stand on a sword'
- Prevent selecting regions via mouse down in web frontend
- Deselect item if player declines to apply or fling
- Hand-hold the player, warning if flung item is beneficial
- Hand-hold the player, warning if applied item is harmful
- Rewrite the condition in UI applyItem check
- Improve the lobable item skill failure message
- Let mouse buttons describe tiles, etc.
- Unblock S-MouseButton in SDL2 frontend
- Always describe things under mouse button
- Make the message when hitting dead foe more varied

## [v0.9.3.0, aka 'Velvet smoking jacket'](https://github.com/LambdaHack/LambdaHack/compare/v0.8.3.0...v0.9.3.0)

- Introduce message classes with configurable behaviour
- Create a new 16x16 font and use it everywhere; tweak smaller fonts
- Lock some levels or otherwise make ascending tricky
- Add cooldown to most melee weapons, display that in HUD, adjust AI
- Add per-scenario and per-outcome gameover messages in content
- Add duplicate and reroll item effects in preparation for crafting
- Add actor and item analytics as a preparation for XP gain quests
- Implement piercing projectiles that may share a tile with a big actor
- Increase the spawn speed now that monsters sleep a lot
- Introduce actors falling asleep and yelling
- Allow any level size and position
- Mention places when looking at tiles and add place lore menu
- Expand all kinds of content and rebalance
- Create and rework all item, cave and plot prose (Dan Keefe @Peritract)
- Make explosives in cramped spaces twice weaker
- Tweak player fling command
- Tweak equipping when equipment overfull
- Start cycling stores at equipment since that's the one mentioned in help
- Overhaul CI scripts
- Restructure and clean up codebase
- Extend balance debugging tools, using item and actor analytics, places, etc.
- Drop the gameplay option that first death means defeat
- Avoid idle-GC between slow keystrokes
- Put content data into a compact region to limit GC
- Remove the border around web frontend game screen; seems unneeded now
- Don't draw aiming line nor path in vty frontend
- Highlight xhair by cursor in vty frontend
- Highlight player by cursor in vty frontend
- Switch the default FPS to 24 for tradition's sake
- Highlight current high score
- Remove most stopPlayBack, now spurious, because message classes used
- Overhaul cabal file: define common options, split into internal libraries
- Fix confusion of nub and uniq
- Rename short wait to lurk and many lurks to heed
- Show a red message when HP or Calm dip too low or when foe appears
- Lose Calm and so alert AI even at weakest non-zero HP draining attacks
- Enable screenshots while in menus
- Rename config options related to fonts
- Recolour aiming line not to clash with the red crosshair
- Exchange the functions of yellow and red highlight
- Tweak all colours, in particular to differentiate blues/cyans
- Cap bright colours at 85 CIELAB Lightness at D65
- Normalize dark colours to be between 42 and 57 CIELAB Lightness at D65
- Get rid of colorIsBold option; KISS
- Tint white in alternating lines with different hue for long text readability
- Don't split lines at articles
- Set xhair to currently meleed foe to see his HP
- Display speed on HUD; tweak status lines in other ways
- Don't show description of leader target in HUD; TMI
- Help AI flee in a consistent direction over many turns
- Expose the save backup command, for browser games
- Don't display target info when item selected
- Let AI actors spawn even quite far from the player
- Auto-select all new team members, to help new players
- Replace O by zero on the map display; make zero distinct from O in all fonts
- Flesh out the initial ? prompt
- Add 'I' alias for pack-related commands, unless laptop key-scheme used
- Turn off movementLaptopKeys by default not to confuse new players
- Make sure AI attacks bosses even if distant and fleeing or non-moving
- Lower bonus HP at extreme difficulty
- Add a separate frame for each projectiles start
- Don't go modal at the frequent and weak hidden tile detection effect
- Make AI pick closest stairs more often
- Let apply-unskilled actors activate embedded items
- Don't boost damage by speed unless actor is projectile
- If everything else fails, let AI flee by opening doors
- Help AI actor prevent being dominated
- Make computing gameplay benefit to items more accurate
- Rename, clone and fine-tune effect Temporary
- Simplify code and content by getting rid of Recharging effect
- Let applying periodic items only produce the first effect
- Tweak item detection to help in skipping boring level portions and in stealth
- Invoke and display embedded items in the order specified in tile definitions
- Let lit trails illuminate colonnades
- Prevent an exploit for avoiding self-invoked firecrackers
- Don't let AI attempt summoning if not enough Calm
- Improve item label bracket codes in menus
- Pick randomly destination stairs if teleporting level
- Display the number of items in store
- Summarize value of player loot in shared stash menu's header
- Start history menu at the close-up of the last message
- Make fast-dying insects aggressive
- Overhaul game score DSL and particular scoring definitions in content
- Add and extend messages, e.g., tell if victim blocks and with what armor
- Extend and rework menu manipulation keys
- Remove specialized quaff, read and throw commands; KISS
- Split walls of text into more paragraphs and/or make them narrower
- Extend and update help and manual
- Don't let AI waste time looting distant lone projectiles
- Make Enum instances of Point and Vector contiguous, hackily
- Make dominated actor drop all his items, for ID and in case he defects ASAP
- Try to find a non-waiting action, if better AI leader can't be found
- Prevent summoning OoD actors
- Let animals eat food and add several foods
- Make Domination effect harder to activate
- Let only actors and items with SkOdor property leave smell and add perfumes
- Let spawning rate level out after a few dozen spawns
- Describe smell, if present in an inspected tile
- Let pushed actor fly after crashing a door open
- Show passing time and heard events even if no actors in the UI faction
- When movement impossible, describe the tile with SHIFT-direction
- Catch and steal projectiles when braced instead of when weaponless
- Let actors that are pushed perform any action in addition to movement
- Improve deduplication of messages
- When describing actor on map, tell if it has loot
- Represent being braced as having an organ; also add other pseudo-organs
- Overhaul hearing to facilitate triangulation based on sound cues
- Prefer to spawn aquatic actors on aquatic tiles
- Add swimming and flying skills and shallow water tile features
- Boost/drain skills via many new items
- Rework and extend skills and their effects as a preparation for XP rewards
- Enable specifying each side of outer cave fence separately
- Make definition of caves of a scenario more precise
- Specify more properties of levels in content
- Extend content validation
- Improve placement and fitting stairs and rooms on levels
- Don't hardwire level size
- Simplify game rules content
- Change the format of game client content
- Fix an arbitrary delay in killing dying actors
- Fix arbitrary branch of a corridor chosen when running
- Fix bush patches blocking off a level's corner
- Fix config file ignored at game reinit
- Fix running disturbed by flavours of walls
- Fix splitting lines one character too early
- Fix Calm drain from nearby foes occurring only every other turn
- Fix some AI looping movement, in particular when fleeing
- Fix running into own periodic explosions, e.g., from necklaces
- Fix 'she painfullies collide'
- Fix AI with vector targets unwilling to change them
- Fix crash when attempting to fling at a target on remote level
- Fix wrong timestamps in history
- Fix, again, various kinds of frames intruding between fadeout and fadein
- Fix wrong pluralization of some item names, compound and exceptions
- Fix disabled items benefit recalculation after item kind learned
- Fix in many ways too close initial faction and item positions
- Fix performance in many ways and places, particularly for JS translation
- Fix missing perception updates, causing missed AI actions concerning us
- Fix uninitialized sarenas, which was probably causing resume to change state
- Fix weak AI actors fleeing even if enemy can't melee
- Fix and optimize sifting free tiles for spawn/summon location
- Fix various cases of excessive summoning
- Fix recording of item first seen level
- Fix many problems with item descriptions and other messages
- Fix reporting of reduction and elimination of actor conditions
- Fix reading and interpreting old format config files
- Fix synced initial item timeouts and actor times, leading to artificial feel
- Fix actors erratically following their leader
- Fix lifts continuing as stars and the other way around
- Fix various 32bit overflows
- Fix other errors, probably not present or not visible in previous version

## [v0.8.3.0](https://github.com/LambdaHack/LambdaHack/compare/v0.8.1.2...v0.8.3.0)

- Add a hack to run SDL2 on the main thread, fixing the OS X crash
- Warn visually when impressed and Calm running low, risking domination
- Display actor as red when low Calm and impressed or when low HP
- Fix, complete and fine tune UI, AI and server skill and weapon checks
- Fix a bug where item aspects look different to clients than to the server
- Change the requirements for the main menu ASCII art

## [v0.8.1.2](https://github.com/LambdaHack/LambdaHack/compare/v0.8.1.1...v0.8.1.2)

- Fix typos detected by lintian
- Fix the code that runs in case of old async (bug introduced in v0.8.1.1)

## [v0.8.1.1](https://github.com/LambdaHack/LambdaHack/compare/v0.8.1.0...v0.8.1.1)

- no player-visible changes
- make it possible to compile with old async package
- rewrite copyright information according to Debian format
- make github display the correct main license

## [v0.8.1.0](https://github.com/LambdaHack/LambdaHack/compare/v0.8.0.0...v0.8.1.0)

- no player-visible changes
- significantly reduce RAM usage when compiling library
- update and extend CI

## [v0.8.0.0, aka 'Explosive dashboard'](https://github.com/LambdaHack/LambdaHack/compare/v0.7.1.0...v0.8.0.0)

- rework greying out menu items and permitting item application and projection
- rework history collection; merge message repetitions more aggressively
- display HP in red when below (configurable) warning threshold
- tweak AI: actors remember they are fleeing; better leader choice, etc.
- add to content specialized explosive projectiles; tune the effects
- calculate loot score component based on fraction of dungeon loot collected
- don't hardwire item price, but let it be specified in content
- let all valuables glitter in the dark to avoid complete level exploration
- teach AI to cure ailments and shake off impressions
- rework detection effects; add detection of items embedded in tiles
- automatically identify stolen items that only have minor effects
- let projectiles hit each other if fragile and substantial enough
- rework item kind identification code; change the way it's defined in content
- make more item kinds (including some traps) secret
- protect paralyzed actors with a stasis condition to avoid infinite paralysis
- implement dumping screenshots in SDL2 and create animated GIFs in Makefile
- generate most common consumables less often, but in depth-scaled bunches
- make pushed actors alter tiles and trigger effects of embedded items
- validate and cross-validate more content; reduce content creation boilerplate
- make summoning more varied and prevent chain-summoning
- add many ways to conditionally sequence effects
- create large, merged rooms more often
- generalize the terrain altering player command (C-c, mouse)
- let RET, SPACE and ESC clear pending messages, if any
- add dashboard with links to all menus and info screens
- scale some organ and trap power with level depth
- simplify level-scaled dice roll semantics
- change scaled dice notation 'dl' to 'dL' for readability in-game
- rebalance items and decrease dice variety to unclutter backpack
- colour-code beneficial and harmful conditions in menu and in HUD
- display item lore (also for organs, embedded items, explosions, etc.)
- display embedded item descriptions as if they were tile descriptions
- tweak blast visuals, lower particle counts, beautify their spread
- tweak projectile visuals, e.g., display an extra frame when projectile dies
- add intro screen and work on other ways to convey story
- simplify a lot of code, including a bit of game rules
- fix some bugs, tweak content, speed up some AI bottlenecks

## [v0.7.1.0, aka 'Ancient troubles'](https://github.com/LambdaHack/LambdaHack/compare/v0.7.0.0...v0.7.1.0)

- add amazing cave and item (actor, blast, organ) descriptions
- package for Windows as an installer and also as zip archives
- fix a crash from SDL frontend under some OpenGL drivers (no thread-safety)
- add WWW address to the Main Menu, for other sites that may run our JS blob

## [v0.7.0.0, aka 'The dice are cast'](https://github.com/LambdaHack/LambdaHack/compare/v0.6.2.0...v0.7.0.0)

- decouple tile searching from tile alteration
- refrain from identifying items that are not randomized
- switch away from incapacitated leader to let others revive him
- make rescue easier by not going into negative HP the first time
- fix crowd of friends on another level slowing even actors that melee
- fix missing report about items underneath an actor when changing levels
- API breakage: change the syntax of dice in content
- API addition: introduce cave descriptions
- keep all client states in the server and optimize communication with clients
- improve item choice for identification and item polymorphing
- reset embedded items when altering tile
- replace atomic command filtering with exception catching
- reimplement dice as symbolic expressions inducing multiple RNG calls
- switch to optparse-applicative and rewrite cli handling
- add stack and cabal new-build project files
- improve haddocks across the codebase

## [v0.6.2.0, aka 'Zoom out'](https://github.com/LambdaHack/LambdaHack/compare/v0.6.1.0...v0.6.2.0)

- make fireworks slower and so easier to spot
- make rattlesnake deeper but more common
- announce no effect of activation
- describe original and current faction of an actor
- highlight dominated actors
- mark organs with comma instead of percent and gems with dollar
- make the healing cave dangerous to prevent camping
- slightly balance various content
- by default move item the same as last time
- often spawn between heroes and stairs going deeper
- fix totalUsefulness computation for negative effects
- fix abandoning distant enemy target despite no alternatives
- fix slow pushing of actors
- fix a crash when many actors run towards stairs
- hotfix: Pass zoom keys through to the browser
- help players find the info about changing the font size
- depend on GHC >= 8.0 and new vector
- specialize client code already in SampleMonadClient.hs
- enable StrictData in all modules
- replace 'failure' with 'error' that now shows call stack

## [v0.6.1.0, aka 'Breaking one rule at a time'](https://github.com/LambdaHack/LambdaHack/compare/v0.6.0.0...v0.6.1.0)

- fix redrawing after window minimized and restored
- hack around vanishing texture on Windows
- hack around SDL backends not thread-safe on Windows
- the only breaking API change: specify font directory in game rules content
- let the game use its own fonts, not fonts from the sample game in library
- tweak some item creation to occur in character's pack, not on the ground
- slightly balance various content
- make sure the 'resolution' effect is not a drawback
- make artifact weapon rarities more regular
- avoid creating lit, open dungeon at the bottom, where foes have ranged weapons
- number scenarios in user descriptions
- correct, add and modify some in-game messages
- let player hear unseen summonings performed by other actors
- don't let actors hear blasts hitting walls, as opposed to hitting actors
- when moving item out of shared stash, reset its timeouts
- when ascending, shift timeouts of inventory as well
- when creating item not on the ground, discover it
- when dominating, auto-discover only if the item can't be discovered by use
- let henchmen take into account their targets, as described in PLAYING.md
- let only walkable tiles be explorable, for clear walls inside solid blocks
- move to API 2.0.0 of sdl2-ttf and depend on corrected sdl2 (builds on Windows)
- simplify code thanks to the new sdl2-ttf API
- tweak travis scripts and building docs in README

## [v0.6.0.0, aka 'Too much to tell'](https://github.com/LambdaHack/LambdaHack/compare/v0.5.0.0...v0.6.0.0)

- add and modify a lot of content: items, tiles, embedded items, scenarios
- improve AI: targeting, stealth, moving in groups, item use, fleeing, etc.
- make monsters more aggressive than animals
- tie scenarios into a loose, optional storyline
- add more level generators and more variety to room placement
- make stairs not walkable and use them by bumping
- align stair position on the levels they pass through
- introduce noctovision
- increase human vision to 12 so that normal speed missiles can be sidestepped
- tweak and document weapon damage calculation
- derive projectile damage mostly from their speed
- make heavy projectiles better vs armor but easier to sidestep
- improve hearing of unseen actions, actors and missiles impacts
- let some missiles lit up on impact
- make torches reusable flares and add blankets for dousing dynamic light
- add detection effects and use them in items and tiles
- make it possible to catch missiles, if not using weapons
- make it possible to wait 0.1 of a turn, at the cost of no bracing
- improve pathfinding, prefer less unknown, alterable and dark tiles on paths
- slow down actors when acting at the same time, for speed with large factions
- don't halve Calm at serious damage any more
- eliminate alternative FOV modes, for speed
- stop actors blocking FOV, for speed
- let actor move diagonally to and from doors, for speed
- improve blast (explosion) shapes visually and gameplay-wise
- add SDL2 frontend and deprecate GTK frontend
- add specialized square bitmap fonts and hack a scalable font
- use middle dot instead of period on the map (except in teletype frontend)
- add a browser frontend based on DOM, using ghcjs
- improve targeting UI, e.g., cycle among items on the map
- show an animation when actor teleports
- add character stats menu and stat description texts
- add item lore and organ lore menus
- add a command to sort item slots and perform the sort at startup
- add a single item manipulation menu and let it mark an item for later
- make history display a menu and improve display of individual messages
- display highscore dates according to the local timezone
- make the help screen a menu, execute actions directly from it
- rework the Main Menu
- rework special positions highlight in all frontends
- mark leader's target on the map (grey highlight)
- visually mark currently chosen menu item and grey out impossible items
- define mouse commands based on UI mode and screen area
- let the game be fully playable only with mouse, use mouse wheel
- pick menu items with mouse and with arrow keys
- add more sanity checks for content
- reorganize content in files to make rebasing on changed content easier
- rework keybinding definition machinery
- let clients, not the server, start frontends
- version savefiles and move them aside if versions don't match
- lots of bug fixes internal improvements and minor visual and text tweaks

## [v0.5.0.0, aka 'Halfway through space'](https://github.com/LambdaHack/LambdaHack/compare/v0.4.101.0...v0.5.0.0)

- let AI put excess items in shared stash and use them out of shared stash
- let UI multiple items pickup routine put items that don't fit into equipment into shared stash, if possible, not into inventory pack
- re-enable the ability to hear close, invisible foes
- add a few more AI and autonomous henchmen tactics (CTRL-T)
- keep difficulty setting over session restart
- change some game start keybindings
- replace the Duel game mode with the Raid game mode
- various bugfixes, minor improvements and balancing

## [v0.4.101.0, aka 'Officially fun'](https://github.com/LambdaHack/LambdaHack/compare/v0.4.100.0...v0.4.101.0)

- the game is now officially fun to play
- introduce unique boss monsters and unique artifact items
- add animals that heal the player
- let AI gang up, attempt stealth and react to player aggressiveness
- spawn actors fast and close to the enemy
- spawn actors less and less often on a given level, but with growing depth
- prefer weapons with effects, if recharged
- make the bracing melee bonus additive, not multiplicative
- let explosions buffet actors around
- make braced actors immune to translocation effects
- use mouse for movement, actor selection, aiming
- don't run straight with selected actors, but go-to cross-hair with them
- speed up default frame rate, slow down projectiles visually
- rework item manipulation UI
- you can pick up many items at once and it costs only one turn
- allow actors to apply and project from the shared stash
- reverse messages shown in player diary
- display actor organs and stats
- split highscore tables wrt game modes
- move score calculation formula to content
- don't keep the default/example config file commented out; was misleading
- I was naughty again and changed v0.5.0.0 of LambdaHack content API slightly
  one last time

## [v0.4.100.0, aka 'The last thaw'](https://github.com/LambdaHack/LambdaHack/compare/v0.4.99.0...v0.4.100.0)

- unexpectedly thaw and freeze again v0.5.0.0 of LambdaHack content API
- unexpectedly implement timeouts and temporary effects easily without FRP
- make a couple of skill levels meaningful and tweak skills of some actors
- make AI prefer exploration of easier levels
- permit overfull HP and Calm
- let non-projectile actors block view
- make colorful characters bold (if it resizes your fonts, turn off via colorIsBold = False in config file or --noColorIsBold on commandline)
- start the game with a screensaver safari mode
- add i386 Linux and Windows compilation targets to Makefile

## [v0.4.99.0, aka 'Player escapes'](https://github.com/LambdaHack/LambdaHack/compare/v0.2.14...v0.4.99.0)

- balance the example game content a bit (campaign still unbalanced)
- various code and documentation tweaks and fixes
- add cabal flag expose_internal that reveals internal library operations
- merge FactionKind into ModeKind and rework completely the semantics
- compatibility tweaks for Nixpkgs
- define AI tactics, expose them to UI and add one more: follow-the-leader
- share leader target between the UI and AI client of each faction
- specify monster spawn rate per-cave
- extend content validation and make it more user friendly
- freeze v0.5.0.0 of LambdaHack content API

## [v0.2.14, aka 'Out of balance'](https://github.com/LambdaHack/LambdaHack/compare/v0.2.12...v0.2.14)

- tons of new (unbalanced) content, content fields, effects and descriptions
- add a simple cabal test in addition to make-test and travis-test
- generate items and actors according to their rarities at various depths
- redo weapon choice, combat bonuses and introduce armor
- introduce skill levels for abilities (boolean for now, WIP)
- remove regeneration, re-add through periodically activating items
- ensure passable areas of randomly filled caves are well connected
- make secondary factions leaderless
- auto-tweak digital line epsilon to let projectiles evade obstacles
- add shrapnel (explosions) and organs (body parts)
- express actor kinds as item kinds (their trunk)
- add dynamic lights through items, actors, projectiles
- fix and improve item kind and item stats identification
- make aspects additive from all equipment and organ items
- split item effects into aspects, effects and item features
- rework AI and structure it according to the Ability type
- define Num instance for Dice to make writing it in content easier
- remove the shared screen multiplayer mode and all support code, for now
- rename all modules and nearly all other code entities
- check and consume HP when calling friends and Calm when summoning
- determine sight radius from items and cap it at current Calm/5
- introduce Calm; use to hear nearby enemies and limit item abuse before death
- let AI actors manage items and share them with party members
- completely revamp item manipulation UI
- add a command to cede control to AI
- separate actor inventory, 10-item actor equipment and shared party stash
- vi movement keys (hjklyubn) are now disabled by default
- new movement keyset: laptop movement keys (uk8o79jl)

## [v0.2.12](https://github.com/LambdaHack/LambdaHack/compare/v0.2.10...v0.2.12)

- improve and simplify dungeon generation
- simplify running and permit multi-actor runs
- let items explode and generate shrapnel projectiles
- add game difficulty setting (initial HP scaling right now)
- allow recording, playing back and looping commands
- implement pathfinding via per-actor BFS over the whole level
- extend setting targets for actors in UI tremendously
- implement autoexplore, go-to-target, etc., as macros
- let AI use pathfinding, switch leaders, pick levels to swarm to
- force level/leader changes on spawners (even when played by humans)
- extend and redesign UI bottom status lines
- get rid of CPS style monads, aborts and WriterT
- benchmark and optimize the code, in particular using Data.Vector
- split off and use the external library assert-failure
- simplify config files and limit the number of external dependencies

## [v0.2.10](https://github.com/LambdaHack/LambdaHack/compare/v0.2.8...v0.2.10)

- screensaver game modes (AI vs AI)
- improved AI (can now climbs stairs, etc.)
- multiple, multi-floor staircases
- multiple savefiles
- configurable framerate and combat animations

## [v0.2.8](https://github.com/LambdaHack/LambdaHack/compare/v0.2.6.5...v0.2.8)

- cooperative and competitive multiplayer (shared-screen only in this version)
- overhauled searching
- rewritten engine code to have a single server that sends restricted game state updates to many fat clients, while a thin frontend layer multiplexes visuals from a subset of the clients

## [v0.2.6.5](https://github.com/LambdaHack/LambdaHack/compare/v0.2.6...v0.2.6.5)

- this is a minor release, primarily intended to fix the broken haddock documentation on Hackage
- changes since 0.2.6 are mostly unrelated to gameplay:
    - strictly typed config files split into UI and rules
    - a switch from Text to String throughout the codebase
    - use of the external library miniutter for English sentence generation

## [v0.2.6](https://github.com/LambdaHack/LambdaHack/compare/v0.2.1...v0.2.6)

- the Main Menu
- improved and configurable mode of squad combat

## [v0.2.1](https://github.com/LambdaHack/LambdaHack/compare/v0.2.0...v0.2.1)

- missiles flying for three turns (by an old kosmikus' idea)
- visual feedback for targeting
- animations of combat and individual monster moves

## [v0.2.0](https://github.com/LambdaHack/LambdaHack/compare/release-0.1.20110918...v0.2.6)

- the LambdaHack engine becomes a Haskell library
- the LambdaHack game depends on the engine library
