//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// InstanceFailoverGroupsServer is a fake server for instances of the armsql.InstanceFailoverGroupsClient type.
type InstanceFailoverGroupsServer struct {
	// BeginCreateOrUpdate is the fake for method InstanceFailoverGroupsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string, parameters armsql.InstanceFailoverGroup, options *armsql.InstanceFailoverGroupsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.InstanceFailoverGroupsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method InstanceFailoverGroupsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string, options *armsql.InstanceFailoverGroupsClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.InstanceFailoverGroupsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginFailover is the fake for method InstanceFailoverGroupsClient.BeginFailover
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginFailover func(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string, options *armsql.InstanceFailoverGroupsClientBeginFailoverOptions) (resp azfake.PollerResponder[armsql.InstanceFailoverGroupsClientFailoverResponse], errResp azfake.ErrorResponder)

	// BeginForceFailoverAllowDataLoss is the fake for method InstanceFailoverGroupsClient.BeginForceFailoverAllowDataLoss
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginForceFailoverAllowDataLoss func(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string, options *armsql.InstanceFailoverGroupsClientBeginForceFailoverAllowDataLossOptions) (resp azfake.PollerResponder[armsql.InstanceFailoverGroupsClientForceFailoverAllowDataLossResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method InstanceFailoverGroupsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string, options *armsql.InstanceFailoverGroupsClientGetOptions) (resp azfake.Responder[armsql.InstanceFailoverGroupsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByLocationPager is the fake for method InstanceFailoverGroupsClient.NewListByLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocationPager func(resourceGroupName string, locationName string, options *armsql.InstanceFailoverGroupsClientListByLocationOptions) (resp azfake.PagerResponder[armsql.InstanceFailoverGroupsClientListByLocationResponse])
}

// NewInstanceFailoverGroupsServerTransport creates a new instance of InstanceFailoverGroupsServerTransport with the provided implementation.
// The returned InstanceFailoverGroupsServerTransport instance is connected to an instance of armsql.InstanceFailoverGroupsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewInstanceFailoverGroupsServerTransport(srv *InstanceFailoverGroupsServer) *InstanceFailoverGroupsServerTransport {
	return &InstanceFailoverGroupsServerTransport{
		srv:                             srv,
		beginCreateOrUpdate:             newTracker[azfake.PollerResponder[armsql.InstanceFailoverGroupsClientCreateOrUpdateResponse]](),
		beginDelete:                     newTracker[azfake.PollerResponder[armsql.InstanceFailoverGroupsClientDeleteResponse]](),
		beginFailover:                   newTracker[azfake.PollerResponder[armsql.InstanceFailoverGroupsClientFailoverResponse]](),
		beginForceFailoverAllowDataLoss: newTracker[azfake.PollerResponder[armsql.InstanceFailoverGroupsClientForceFailoverAllowDataLossResponse]](),
		newListByLocationPager:          newTracker[azfake.PagerResponder[armsql.InstanceFailoverGroupsClientListByLocationResponse]](),
	}
}

// InstanceFailoverGroupsServerTransport connects instances of armsql.InstanceFailoverGroupsClient to instances of InstanceFailoverGroupsServer.
// Don't use this type directly, use NewInstanceFailoverGroupsServerTransport instead.
type InstanceFailoverGroupsServerTransport struct {
	srv                             *InstanceFailoverGroupsServer
	beginCreateOrUpdate             *tracker[azfake.PollerResponder[armsql.InstanceFailoverGroupsClientCreateOrUpdateResponse]]
	beginDelete                     *tracker[azfake.PollerResponder[armsql.InstanceFailoverGroupsClientDeleteResponse]]
	beginFailover                   *tracker[azfake.PollerResponder[armsql.InstanceFailoverGroupsClientFailoverResponse]]
	beginForceFailoverAllowDataLoss *tracker[azfake.PollerResponder[armsql.InstanceFailoverGroupsClientForceFailoverAllowDataLossResponse]]
	newListByLocationPager          *tracker[azfake.PagerResponder[armsql.InstanceFailoverGroupsClientListByLocationResponse]]
}

// Do implements the policy.Transporter interface for InstanceFailoverGroupsServerTransport.
func (i *InstanceFailoverGroupsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "InstanceFailoverGroupsClient.BeginCreateOrUpdate":
		resp, err = i.dispatchBeginCreateOrUpdate(req)
	case "InstanceFailoverGroupsClient.BeginDelete":
		resp, err = i.dispatchBeginDelete(req)
	case "InstanceFailoverGroupsClient.BeginFailover":
		resp, err = i.dispatchBeginFailover(req)
	case "InstanceFailoverGroupsClient.BeginForceFailoverAllowDataLoss":
		resp, err = i.dispatchBeginForceFailoverAllowDataLoss(req)
	case "InstanceFailoverGroupsClient.Get":
		resp, err = i.dispatchGet(req)
	case "InstanceFailoverGroupsClient.NewListByLocationPager":
		resp, err = i.dispatchNewListByLocationPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *InstanceFailoverGroupsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := i.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceFailoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.InstanceFailoverGroup](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, locationNameParam, failoverGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		i.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		i.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		i.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (i *InstanceFailoverGroupsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := i.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceFailoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDelete(req.Context(), resourceGroupNameParam, locationNameParam, failoverGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		i.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		i.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		i.beginDelete.remove(req)
	}

	return resp, nil
}

func (i *InstanceFailoverGroupsServerTransport) dispatchBeginFailover(req *http.Request) (*http.Response, error) {
	if i.srv.BeginFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailover not implemented")}
	}
	beginFailover := i.beginFailover.get(req)
	if beginFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceFailoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginFailover(req.Context(), resourceGroupNameParam, locationNameParam, failoverGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailover = &respr
		i.beginFailover.add(req, beginFailover)
	}

	resp, err := server.PollerResponderNext(beginFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailover) {
		i.beginFailover.remove(req)
	}

	return resp, nil
}

func (i *InstanceFailoverGroupsServerTransport) dispatchBeginForceFailoverAllowDataLoss(req *http.Request) (*http.Response, error) {
	if i.srv.BeginForceFailoverAllowDataLoss == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginForceFailoverAllowDataLoss not implemented")}
	}
	beginForceFailoverAllowDataLoss := i.beginForceFailoverAllowDataLoss.get(req)
	if beginForceFailoverAllowDataLoss == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceFailoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/forceFailoverAllowDataLoss`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginForceFailoverAllowDataLoss(req.Context(), resourceGroupNameParam, locationNameParam, failoverGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginForceFailoverAllowDataLoss = &respr
		i.beginForceFailoverAllowDataLoss.add(req, beginForceFailoverAllowDataLoss)
	}

	resp, err := server.PollerResponderNext(beginForceFailoverAllowDataLoss, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginForceFailoverAllowDataLoss.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginForceFailoverAllowDataLoss) {
		i.beginForceFailoverAllowDataLoss.remove(req)
	}

	return resp, nil
}

func (i *InstanceFailoverGroupsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceFailoverGroups/(?P<failoverGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	failoverGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("failoverGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, locationNameParam, failoverGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).InstanceFailoverGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InstanceFailoverGroupsServerTransport) dispatchNewListByLocationPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocationPager not implemented")}
	}
	newListByLocationPager := i.newListByLocationPager.get(req)
	if newListByLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceFailoverGroups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByLocationPager(resourceGroupNameParam, locationNameParam, nil)
		newListByLocationPager = &resp
		i.newListByLocationPager.add(req, newListByLocationPager)
		server.PagerResponderInjectNextLinks(newListByLocationPager, req, func(page *armsql.InstanceFailoverGroupsClientListByLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocationPager) {
		i.newListByLocationPager.remove(req)
	}
	return resp, nil
}
