//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/applicationinsights/armapplicationinsights"
	"net/http"
	"net/url"
	"regexp"
)

// ComponentQuotaStatusServer is a fake server for instances of the armapplicationinsights.ComponentQuotaStatusClient type.
type ComponentQuotaStatusServer struct {
	// Get is the fake for method ComponentQuotaStatusClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceName string, options *armapplicationinsights.ComponentQuotaStatusClientGetOptions) (resp azfake.Responder[armapplicationinsights.ComponentQuotaStatusClientGetResponse], errResp azfake.ErrorResponder)
}

// NewComponentQuotaStatusServerTransport creates a new instance of ComponentQuotaStatusServerTransport with the provided implementation.
// The returned ComponentQuotaStatusServerTransport instance is connected to an instance of armapplicationinsights.ComponentQuotaStatusClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewComponentQuotaStatusServerTransport(srv *ComponentQuotaStatusServer) *ComponentQuotaStatusServerTransport {
	return &ComponentQuotaStatusServerTransport{srv: srv}
}

// ComponentQuotaStatusServerTransport connects instances of armapplicationinsights.ComponentQuotaStatusClient to instances of ComponentQuotaStatusServer.
// Don't use this type directly, use NewComponentQuotaStatusServerTransport instead.
type ComponentQuotaStatusServerTransport struct {
	srv *ComponentQuotaStatusServer
}

// Do implements the policy.Transporter interface for ComponentQuotaStatusServerTransport.
func (c *ComponentQuotaStatusServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ComponentQuotaStatusClient.Get":
		resp, err = c.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ComponentQuotaStatusServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/components/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/quotastatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ComponentQuotaStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
