/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/uhd/usrp_sink.h>
// pydoc.h is automatically generated in the build directory
#include <usrp_sink_pydoc.h>

void bind_usrp_sink(py::module& m)
{

    using usrp_sink = ::gr::uhd::usrp_sink;


    py::class_<usrp_sink,
               gr::uhd::usrp_block,
               gr::sync_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<usrp_sink>>(m, "usrp_sink", D(usrp_sink))

        .def(py::init((std::shared_ptr<gr::uhd::usrp_sink>(*)(const ::uhd::device_addr_t&,
                                                              const ::uhd::stream_args_t&,
                                                              const std::string&)) &
                      usrp_sink::make),
             py::arg("device_addr"),
             py::arg("stream_args"),
             py::arg("tsb_tag_name") = "",
             D(usrp_sink, make))

        .def(py::init((std::shared_ptr<gr::uhd::usrp_sink>(*)(const std::string&,
                                                              const ::uhd::stream_args_t&,
                                                              const std::string&)) &
                      usrp_sink::make),
             py::arg("device_addr"),
             py::arg("stream_args"),
             py::arg("tsb_tag_name") = "",
             D(usrp_sink, make))


        .def("set_start_time",
             &usrp_sink::set_start_time,
             py::arg("time"),
             D(usrp_sink, set_start_time))


        .def("get_lo_names",
             &usrp_sink::get_lo_names,
             py::arg("chan") = 0,
             D(usrp_sink, get_lo_names))


        .def("set_lo_source",
             &usrp_sink::set_lo_source,
             py::arg("src"),
             py::arg("name"),
             py::arg("chan") = 0,
             D(usrp_sink, set_lo_source))


        .def("get_lo_source",
             &usrp_sink::get_lo_source,
             py::arg("name"),
             py::arg("chan") = 0,
             D(usrp_sink, get_lo_source))


        .def("get_lo_sources",
             &usrp_sink::get_lo_sources,
             py::arg("name"),
             py::arg("chan") = 0,
             D(usrp_sink, get_lo_sources))


        .def("set_lo_export_enabled",
             &usrp_sink::set_lo_export_enabled,
             py::arg("enabled"),
             py::arg("name"),
             py::arg("chan") = 0,
             D(usrp_sink, set_lo_export_enabled))


        .def("get_lo_export_enabled",
             &usrp_sink::get_lo_export_enabled,
             py::arg("name"),
             py::arg("chan") = 0,
             D(usrp_sink, get_lo_export_enabled))


        .def("set_lo_freq",
             &usrp_sink::set_lo_freq,
             py::arg("freq"),
             py::arg("name"),
             py::arg("chan") = 0,
             D(usrp_sink, set_lo_freq))


        .def("get_lo_freq",
             &usrp_sink::get_lo_freq,
             py::arg("name"),
             py::arg("chan") = 0,
             D(usrp_sink, get_lo_freq))


        .def("get_lo_freq_range",
             &usrp_sink::get_lo_freq_range,
             py::arg("name"),
             py::arg("chan") = 0,
             D(usrp_sink, get_lo_freq_range))


        .def("set_dc_offset",
             &usrp_sink::set_dc_offset,
             py::arg("offset"),
             py::arg("chan") = 0,
             D(usrp_sink, set_dc_offset))


        .def("set_iq_balance",
             &usrp_sink::set_iq_balance,
             py::arg("correction"),
             py::arg("chan") = 0,
             D(usrp_sink, set_iq_balance))

        ;
}
