#!/bin/sh
#
#       fhist - file history and comparison tools
#       Copyright (C) 1997, 1998, 2003, 2004, 2008 Peter Miller
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 3 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see
#       <http://www.gnu.org/licenses/>.
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

pass()
{
        set +x
        echo PASSED 1>&2
        cd $here
        rm -rf $work
        exit 0
}
fail()
{
        set +x
        echo 'FAILED test of the fmerge functionality' 1>&2
        cd $here
        rm -rf $work
        exit 1
}
no_result()
{
        set +x
        echo 'NO RESULT for test of the fmerge functionality' 1>&2
        cd $here
        rm -rf $work
        exit 2
}
trap "no_result" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 2; fi
mkdir $work
if test $? -ne 0 ; then exit 2; fi
cd $work
if test $? -ne 0 ; then no_result; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the fmerge functionality
#
cat > f1 << 'fubar'
line1
line2
line3
line4
fubar
if test $? -ne 0 ; then no_result; fi

cat > f2 << 'fubar'
line1
line2
hello
line3
line4
fubar
if test $? -ne 0 ; then no_result; fi

cat > f3 << 'fubar'
line1
line2
There's one born every minute.
Actually, one every three senconds, now.
line3
line4
fubar
if test $? -ne 0 ; then no_result; fi

cat > test.ok << 'fubar'
line1
line2
/-/-/-/-/-/-/-/-/-/ BEGIN CONFLICT  [O3 A3 B3] /-/-/-/-/-/-/-/-/-/-/
hello
/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/
There's one born every minute.
Actually, one every three senconds, now.
/-/-/-/-/-/-/-/-/-/-/-/-/  END CONFLICT   /-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/
line3
line4
fubar
if test $? -ne 0 ; then no_result; fi

$bin/fmerge f1 f2 f3 -o test.out -c /dev/null 2> test.err
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
