/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/std_test_case.cpp
 *
 * @brief [LEVEL: beta] Implementation of @ref diagnostics::unittest::Std_Test_Case
 *
 * $Id: std_test_case.cpp,v 1.8 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/std_test_case.hpp>

#include <diagnostics/unittest/test_system_exception.hpp>
#include <diagnostics/unittest/name_separators.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

Std_Test_Case::~Std_Test_Case()
{
}

Std_Test_Case::Std_Test_Case(::std::string const & name,
			     int const timeout,
			     bool const is_rerunable,
			     bool const testable_at_prod,
			     bool const testable_at_debug,
			     bool const testable_at_audit) 
    : m_name(name),
      m_timeout(timeout),
      m_is_rerunable(is_rerunable),
      m_testable_at((testable_at_prod   ? (1 << LEVEL_PROD)  : 0)
		    |(testable_at_debug ? (1 << LEVEL_DEBUG) : 0)
		    |(testable_at_audit ? (1 << LEVEL_AUDIT) : 0))
{
    if(m_timeout<0) throw Test_System_Exception("Negative timeout value");

    if(name.size()==0) throw Test_System_Exception("Empty Name");

    if(!name_adheres_convention(name))
	throw Test_System_Exception("The Test_Suit name does not comply to the conventions");
}

bool Std_Test_Case::is_testable_at(Level_t const level) const 
{ 
    if(level==LEVEL_TEST) throw Test_System_Exception("LEVEL_TEST is not a build-level");
    
    return 0!=(m_testable_at&(1<<level)); 
}

 ::std::string const & Std_Test_Case::name() const 
{ 
    return m_name; 
}

 int Std_Test_Case::timeout() const { 
     return m_timeout; 
}
    
 bool Std_Test_Case::is_rerunable() const 
{ 
    return m_is_rerunable; 
}



UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


// vim:ts=4:sw=4
