/*
 * Copyright (c) 2016 Meinhard Ritscher <cyc1ingsir@gmail.com>
 *
 * This is based on the Qt code editor example line numbering view.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For more information on the GPL, please go to:
 * http://www.gnu.org/copyleft/gpl.html
 */

#include "timeview.h"
#include "datadisplay.h"

/*!
 * This class provides a column displaying the time a line
 * was added to a data display.
 * The actual painting is done within the data display itself.
 * \brief TimeView::TimeView
 * \param display
 */
TimeView::TimeView(DataDisplayPrivate *display)
    : QWidget(display)
{
    dataDisplay = display;
}

QSize TimeView::sizeHint() const { return QSize(dataDisplay->timeViewWidth(), 0); }

void TimeView::paintEvent(QPaintEvent *event) { dataDisplay->timeViewPaintEvent(event); }
