/*

Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/
module derelict.sdl.sdlfuncs;

private
{
    import derelict.util.compat;
    import derelict.sdl.sdltypes;

    version(Tango)
    {
        import tango.stdc.stdio;
    }
    else
    {
        import core.stdc.stdio;
    }
}

SDL_AudioSpec* SDL_LoadWAV(in char* file, SDL_AudioSpec* spec, Uint8** buf, Uint32* len)
{
    return SDL_LoadWAV_RW(SDL_RWFromFile(file, "rb"), 1, spec, buf, len);
}

int SDL_QuitRequested()
{
    SDL_PumpEvents();
    return SDL_PeepEvents(null, 0, SDL_PEEKEVENT, SDL_QUITMASK);
}

int SDL_LockMutex(SDL_mutex *mutex)
{
    return SDL_mutexP(mutex);
}

int SDL_UnlockMutex(SDL_mutex *mutex)
{
    return SDL_mutexV(mutex);
}

SDL_Surface* SDL_LoadBMP(in char* file)
{
    return SDL_LoadBMP_RW(SDL_RWFromFile(file, "rb"), 1);
}

int SDL_SaveBMP(SDL_Surface* surface, in char* file)
{
    return SDL_SaveBMP_RW(surface, SDL_RWFromFile(file,"wb"), 1);
}

version(D_Version2)
{
    mixin("alias const(SDL_VideoInfo*) SDLVIPTR;");
}
else
{
    alias SDL_VideoInfo* SDLVIPTR;
}


extern(C)
{
    // SDL.h
    alias int function(Uint32) da_SDL_Init;
    alias int function(Uint32) da_SDL_InitSubSystem;
    alias void function(Uint32) da_SDL_QuitSubSystem;
    alias Uint32 function(Uint32) da_SDL_WasInit;
    alias void function() da_SDL_Quit;

    // SDL_active.h
    alias Uint8 function() da_SDL_GetAppState;

    // SDL_audio.h
    alias int function(in char*) da_SDL_AudioInit;
    alias void function() da_SDL_AudioQuit;
    alias char* function(char*,int) da_SDL_AudioDriverName;
    alias int function(SDL_AudioSpec*,SDL_AudioSpec*) da_SDL_OpenAudio;
    alias SDL_audiostatus function() da_SDL_GetAudioStatus;
    alias void function(int) da_SDL_PauseAudio;
    alias SDL_AudioSpec* function(SDL_RWops*,int,SDL_AudioSpec*,Uint8**,Uint32*) da_SDL_LoadWAV_RW;
    alias void function(Uint8*) da_SDL_FreeWAV;
    alias int function(SDL_AudioCVT*,Uint16,Uint8,int,Uint16,Uint8,int) da_SDL_BuildAudioCVT;
    alias int function(SDL_AudioCVT*) da_SDL_ConvertAudio;
    alias void function(Uint8*,in Uint8*,Uint32,int) da_SDL_MixAudio;
    alias void function() da_SDL_LockAudio;
    alias void function() da_SDL_UnlockAudio;
    alias void function() da_SDL_CloseAudio;

    // SDL_cdrom.h
    alias int function() da_SDL_CDNumDrives;
    alias CCPTR function(int) da_SDL_CDName;
    alias SDL_CD* function(int) da_SDL_CDOpen;
    alias CDstatus function(SDL_CD*) da_SDL_CDStatus;
    alias int function(SDL_CD*,int,int,int,int) da_SDL_CDPlayTracks;
    alias int function(SDL_CD*,int,int) da_SDL_CDPlay;
    alias int function(SDL_CD*) da_SDL_CDPause;
    alias int function(SDL_CD*) da_SDL_CDResume;
    alias int function(SDL_CD*) da_SDL_CDStop;
    alias int function(SDL_CD*) da_SDL_CDEject;
    alias int function(SDL_CD*) da_SDL_CDClose;

    // SDL_cpuinfo.h
    alias SDL_bool function() da_SDL_HasRDTSC;
    alias SDL_bool function() da_SDL_HasMMX;
    alias SDL_bool function() da_SDL_HasMMXExt;
    alias SDL_bool function() da_SDL_Has3DNow;
    alias SDL_bool function() da_SDL_Has3DNowExt;
    alias SDL_bool function() da_SDL_HasSSE;
    alias SDL_bool function() da_SDL_HasSSE2;
    alias SDL_bool function() da_SDL_HasAltiVec;

    // SDL_error.h
    alias void function(in char*,...) da_SDL_SetError;
    alias char* function() da_SDL_GetError;
    alias void function() da_SDL_ClearError;

    // SDL_events.h
    alias void function() da_SDL_PumpEvents;
    alias int function(SDL_Event*,int,SDL_eventaction,Uint32) da_SDL_PeepEvents;
    alias int function(SDL_Event*) da_SDL_PollEvent;
    alias int function(SDL_Event*) da_SDL_WaitEvent;
    alias int function(SDL_Event*) da_SDL_PushEvent;
    alias void function(SDL_EventFilter) da_SDL_SetEventFilter;
    alias SDL_EventFilter function() da_SDL_GetEventFilter;
    alias Uint8 function(Uint8,int) da_SDL_EventState;

    // SDL_joystick.h
    alias int function() da_SDL_NumJoysticks;
    alias CCPTR function(int) da_SDL_JoystickName;
    alias SDL_Joystick* function(int) da_SDL_JoystickOpen;
    alias int function(int) da_SDL_JoystickOpened;
    alias int function(SDL_Joystick*) da_SDL_JoystickIndex;
    alias int function(SDL_Joystick*) da_SDL_JoystickNumAxes;
    alias int function(SDL_Joystick*) da_SDL_JoystickNumBalls;
    alias int function(SDL_Joystick*) da_SDL_JoystickNumHats;
    alias int function(SDL_Joystick*) da_SDL_JoystickNumButtons;
    alias void function() da_SDL_JoystickUpdate;
    alias int function(int) da_SDL_JoystickEventState;
    alias Sint16 function(SDL_Joystick*,int) da_SDL_JoystickGetAxis;
    alias Uint8 function(SDL_Joystick*,int) da_SDL_JoystickGetHat;
    alias int function(SDL_Joystick*,int,int*,int*) da_SDL_JoystickGetBall;
    alias Uint8 function(SDL_Joystick*,int) da_SDL_JoystickGetButton;
    alias void function(SDL_Joystick*) da_SDL_JoystickClose;

    // SDL_keyboard.h
    alias int function(int) da_SDL_EnableUNICODE;
    alias int function(int,int) da_SDL_EnableKeyRepeat;
    alias void function(int*,int*) da_SDL_GetKeyRepeat;
    alias Uint8* function(int*) da_SDL_GetKeyState;
    alias SDLMod function() da_SDL_GetModState;
    alias void function(SDLMod) da_SDL_SetModState;
    alias char* function(SDLKey key) da_SDL_GetKeyName;

    // SDL_loadso.h
    alias void* function(in char*) da_SDL_LoadObject;
    alias void* function(in void*,char*) da_SDL_LoadFunction;
    alias void function(void*) da_SDL_UnloadObject;

    // SDL_mouse.h
    alias Uint8 function(int*,int*) da_SDL_GetMouseState;
    alias Uint8 function(int*,int*) da_SDL_GetRelativeMouseState;
    alias void function(Uint16,Uint16) da_SDL_WarpMouse;
    alias SDL_Cursor* function(Uint8*,Uint8*,int,int,int,int) da_SDL_CreateCursor;
    alias void function(SDL_Cursor*) da_SDL_SetCursor;
    alias SDL_Cursor* function() da_SDL_GetCursor;
    alias void function(SDL_Cursor*) da_SDL_FreeCursor;
    alias int function(int) da_SDL_ShowCursor;

    // SDL_mutex.h
    alias SDL_mutex* function() da_SDL_CreateMutex;
    alias int function(SDL_mutex*) da_SDL_mutexP;
    alias int function(SDL_mutex*) da_SDL_mutexV;
    alias void function(SDL_mutex*) da_SDL_DestroyMutex;
    alias SDL_sem* function(Uint32) da_SDL_CreateSemaphore;
    alias void function(SDL_sem*) da_SDL_DestroySemaphore;
    alias int function(SDL_sem*) da_SDL_SemWait;
    alias int function(SDL_sem*) da_SDL_SemTryWait;
    alias int function(SDL_sem*,Uint32) da_SDL_SemWaitTimeout;
    alias int function(SDL_sem*) da_SDL_SemPost;
    alias Uint32 function(SDL_sem*) da_SDL_SemValue;
    alias SDL_cond* function() da_SDL_CreateCond;
    alias void function(SDL_cond*) da_SDL_DestroyCond;
    alias int function(SDL_cond*) da_SDL_CondSignal;
    alias int function(SDL_cond*) da_SDL_CondBroadcast;
    alias int function(SDL_cond*,SDL_mutex*) da_SDL_CondWait;
    alias int function(SDL_cond*,SDL_mutex*,Uint32) da_SDL_CondWaitTimeout;

    // SDL_rwops.h
    alias SDL_RWops* function(in char*,in char*) da_SDL_RWFromFile;
    alias SDL_RWops* function(FILE*,int) da_SDL_RWFromFP;
    alias SDL_RWops* function(void*,int) da_SDL_RWFromMem;
    alias SDL_RWops* function(in void*,int) da_SDL_RWFromConstMem;
    alias SDL_RWops* function() da_SDL_AllocRW;
    alias void function(SDL_RWops*) da_SDL_FreeRW;
    alias Uint16 function(SDL_RWops*) da_SDL_ReadLE16;
    alias Uint16 function(SDL_RWops*) da_SDL_ReadBE16;
    alias Uint32 function(SDL_RWops*) da_SDL_ReadLE32;
    alias Uint32 function(SDL_RWops*) da_SDL_ReadBE32;
    alias Uint64 function(SDL_RWops*) da_SDL_ReadLE64;
    alias Uint64 function(SDL_RWops*) da_SDL_ReadBE64;
    alias Uint16 function(SDL_RWops*,Uint16) da_SDL_WriteLE16;
    alias Uint16 function(SDL_RWops*,Uint16) da_SDL_WriteBE16;
    alias Uint32 function(SDL_RWops*,Uint32) da_SDL_WriteLE32;
    alias Uint32 function(SDL_RWops*,Uint32) da_SDL_WriteBE32;
    alias Uint64 function(SDL_RWops*,Uint64) da_SDL_WriteLE64;
    alias Uint64 function(SDL_RWops*,Uint64) da_SDL_WriteBE64;

    // SDL_version.h
    alias CSDLVERPTR function() da_SDL_Linked_Version;

    // SDL_syswm.h
    alias int function(SDL_SysWMinfo*) da_SDL_GetWMInfo;

    // SDL_thread.h
    alias SDL_Thread* function(int function(void*) fm, void*) da_SDL_CreateThread;
    alias Uint32 function() da_SDL_ThreadID;
    alias Uint32 function(SDL_Thread*) da_SDL_GetThreadID;
    alias void function(SDL_Thread*,int*) da_SDL_WaitThread;
    alias void function(SDL_Thread*) da_SDL_KillThread;

    // SDL_timer.h
    alias Uint32 function() da_SDL_GetTicks;
    alias void function(Uint32) da_SDL_Delay;
    alias int function(Uint32,SDL_TimerCallback) da_SDL_SetTimer;
    alias SDL_TimerID function(Uint32,SDL_NewTimerCallback,void*) da_SDL_AddTimer;
    alias SDL_bool function(SDL_TimerID) da_SDL_RemoveTimer;

    // SDL_video.h
    alias int function(in char*,Uint32) da_SDL_VideoInit;
    alias void function() da_SDL_VideoQuit;
    alias char* function(char*,int) da_SDL_VideoDriverName;
    alias SDL_Surface* function() da_SDL_GetVideoSurface;
    alias SDLVIPTR function() da_SDL_GetVideoInfo;
    alias int function(int,int,int,Uint32) da_SDL_VideoModeOK;
    alias SDL_Rect** function(SDL_PixelFormat*,Uint32) da_SDL_ListModes;
    alias SDL_Surface* function(int,int,int,Uint32) da_SDL_SetVideoMode;
    alias void function(SDL_Surface*,int,SDL_Rect*) da_SDL_UpdateRects;
    alias void function(SDL_Surface*,Sint32,Sint32,Uint32,Uint32) da_SDL_UpdateRect;
    alias int function(SDL_Surface*) da_SDL_Flip;
    alias int function(float,float,float) da_SDL_SetGamma;
    alias int function(in Uint16*,in Uint16*,in Uint16*) da_SDL_SetGammaRamp;
    alias int function(Uint16*,Uint16*,Uint16*) da_SDL_GetGammaRamp;
    alias int function(SDL_Surface*,SDL_Color*,int,int) da_SDL_SetColors;
    alias int function(SDL_Surface*,int,SDL_Color*,int,int) da_SDL_SetPalette;
    alias Uint32 function(in SDL_PixelFormat*,in Uint8,in Uint8,in Uint8) da_SDL_MapRGB;
    alias Uint32 function(in SDL_PixelFormat*, in Uint8,in Uint8,in Uint8,in Uint8) da_SDL_MapRGBA;
    alias void function(Uint32,SDL_PixelFormat*,Uint8*,Uint8*,Uint8*) da_SDL_GetRGB;
    alias void function(Uint32,SDL_PixelFormat*,Uint8*,Uint8*,Uint8*,Uint8*) da_SDL_GetRGBA;
    alias SDL_Surface* function(Uint32,int,int,int,Uint32,Uint32,Uint32,Uint32) da_SDL_CreateRGBSurface;
    alias SDL_Surface* function(void*,int,int,int,int,Uint32,Uint32,Uint32,Uint32) da_SDL_CreateRGBSurfaceFrom;
    alias void function(SDL_Surface*) da_SDL_FreeSurface;
    alias int function(SDL_Surface*) da_SDL_LockSurface;
    alias void function(SDL_Surface*) da_SDL_UnlockSurface;
    alias SDL_Surface* function(SDL_RWops*,int) da_SDL_LoadBMP_RW;
    alias int function(SDL_Surface*,SDL_RWops*,int) da_SDL_SaveBMP_RW;
    alias int function(SDL_Surface*,Uint32,Uint32) da_SDL_SetColorKey;
    alias int function(SDL_Surface*,Uint32,Uint8) da_SDL_SetAlpha;
    alias SDL_bool function(SDL_Surface*,in SDL_Rect*) da_SDL_SetClipRect;
    alias void function(SDL_Surface*,SDL_Rect*) da_SDL_GetClipRect;
    alias SDL_Surface* function(SDL_Surface*,SDL_PixelFormat*,Uint32) da_SDL_ConvertSurface;
    alias int function(SDL_Surface*,SDL_Rect*,SDL_Surface*,SDL_Rect*) da_SDL_UpperBlit;
    alias int function(SDL_Surface*,SDL_Rect*,SDL_Surface*,SDL_Rect*) da_SDL_LowerBlit;
    alias int function(SDL_Surface*,SDL_Rect*,Uint32) da_SDL_FillRect;
    alias SDL_Surface* function(SDL_Surface*) da_SDL_DisplayFormat;
    alias SDL_Surface* function(SDL_Surface*) da_SDL_DisplayFormatAlpha;
    alias SDL_Overlay* function(int,int,Uint32,SDL_Surface*) da_SDL_CreateYUVOverlay;
    alias int function(SDL_Overlay*) da_SDL_LockYUVOverlay;
    alias void function(SDL_Overlay*) da_SDL_UnlockYUVOverlay;
    alias int function(SDL_Overlay*,SDL_Rect*) da_SDL_DisplayYUVOverlay;
    alias void function(SDL_Overlay*) da_SDL_FreeYUVOverlay;
    alias int function(in char*) da_SDL_GL_LoadLibrary;
    alias void* function(in char*) da_SDL_GL_GetProcAddress;
    alias int function(SDL_GLattr,int) da_SDL_GL_SetAttribute;
    alias int function(SDL_GLattr,int*) da_SDL_GL_GetAttribute;
    alias void function() da_SDL_GL_SwapBuffers;
    alias void function(int,SDL_Rect*) da_SDL_GL_UpdateRects;
    alias void function() da_SDL_GL_Lock;
    alias void function() da_SDL_GL_Unlock;
    alias void function(in char*,in char*) da_SDL_WM_SetCaption;
    alias void function(char**,char**) da_SDL_WM_GetCaption;
    alias void function(SDL_Surface*,Uint8*) da_SDL_WM_SetIcon;
    alias int function() da_SDL_WM_IconifyWindow;
    alias int function(SDL_Surface*) da_SDL_WM_ToggleFullScreen;
    alias SDL_GrabMode function(SDL_GrabMode) da_SDL_WM_GrabInput;
}

mixin(gsharedString!() ~
"
da_SDL_Init SDL_Init;
da_SDL_InitSubSystem SDL_InitSubSystem;
da_SDL_QuitSubSystem SDL_QuitSubSystem;
da_SDL_WasInit SDL_WasInit;
da_SDL_Quit SDL_Quit;

da_SDL_GetAppState SDL_GetAppState;

da_SDL_AudioInit SDL_AudioInit;
da_SDL_AudioQuit SDL_AudioQuit;
da_SDL_AudioDriverName SDL_AudioDriverName;
da_SDL_OpenAudio SDL_OpenAudio;
da_SDL_GetAudioStatus SDL_GetAudioStatus;
da_SDL_PauseAudio SDL_PauseAudio;
da_SDL_LoadWAV_RW SDL_LoadWAV_RW;
da_SDL_FreeWAV SDL_FreeWAV;
da_SDL_BuildAudioCVT SDL_BuildAudioCVT;
da_SDL_ConvertAudio SDL_ConvertAudio;
da_SDL_MixAudio SDL_MixAudio;
da_SDL_LockAudio SDL_LockAudio;
da_SDL_UnlockAudio SDL_UnlockAudio;
da_SDL_CloseAudio SDL_CloseAudio;

da_SDL_CDNumDrives SDL_CDNumDrives;
da_SDL_CDName SDL_CDName;
da_SDL_CDOpen SDL_CDOpen;
da_SDL_CDStatus SDL_CDStatus;
da_SDL_CDPlayTracks SDL_CDPlayTracks;
da_SDL_CDPlay SDL_CDPlay;
da_SDL_CDPause SDL_CDPause;
da_SDL_CDResume SDL_CDResume;
da_SDL_CDStop SDL_CDStop;
da_SDL_CDEject SDL_CDEject;
da_SDL_CDClose SDL_CDClose;

da_SDL_HasRDTSC SDL_HasRDTSC;
da_SDL_HasMMX SDL_HasMMX;
da_SDL_HasMMXExt SDL_HasMMXExt;
da_SDL_Has3DNow SDL_Has3DNow;
da_SDL_Has3DNowExt SDL_Has3DNowExt;
da_SDL_HasSSE SDL_HasSSE;
da_SDL_HasSSE2 SDL_HasSSE2;
da_SDL_HasAltiVec SDL_HasAltiVec;

da_SDL_SetError SDL_SetError;
da_SDL_GetError SDL_GetError;
da_SDL_ClearError SDL_ClearError;

da_SDL_PumpEvents SDL_PumpEvents;
da_SDL_PeepEvents SDL_PeepEvents;
da_SDL_PollEvent SDL_PollEvent;
da_SDL_WaitEvent SDL_WaitEvent;
da_SDL_PushEvent SDL_PushEvent;
da_SDL_SetEventFilter SDL_SetEventFilter;
da_SDL_GetEventFilter SDL_GetEventFilter;
da_SDL_EventState SDL_EventState;

da_SDL_NumJoysticks SDL_NumJoysticks;
da_SDL_JoystickName SDL_JoystickName;
da_SDL_JoystickOpen SDL_JoystickOpen;
da_SDL_JoystickOpened SDL_JoystickOpened;
da_SDL_JoystickIndex SDL_JoystickIndex;
da_SDL_JoystickNumAxes SDL_JoystickNumAxes;
da_SDL_JoystickNumBalls SDL_JoystickNumBalls;
da_SDL_JoystickNumHats SDL_JoystickNumHats;
da_SDL_JoystickNumButtons SDL_JoystickNumButtons;
da_SDL_JoystickUpdate SDL_JoystickUpdate;
da_SDL_JoystickEventState SDL_JoystickEventState;
da_SDL_JoystickGetAxis SDL_JoystickGetAxis;
da_SDL_JoystickGetHat SDL_JoystickGetHat;
da_SDL_JoystickGetBall SDL_JoystickGetBall;
da_SDL_JoystickGetButton SDL_JoystickGetButton;
da_SDL_JoystickClose SDL_JoystickClose;

da_SDL_EnableUNICODE SDL_EnableUNICODE;
da_SDL_EnableKeyRepeat SDL_EnableKeyRepeat;
da_SDL_GetKeyRepeat SDL_GetKeyRepeat;
da_SDL_GetKeyState SDL_GetKeyState;
da_SDL_GetModState SDL_GetModState;
da_SDL_SetModState SDL_SetModState;
da_SDL_GetKeyName SDL_GetKeyName;

da_SDL_LoadObject SDL_LoadObject;
da_SDL_LoadFunction SDL_LoadFunction;
da_SDL_UnloadObject SDL_UnloadObject;

da_SDL_GetMouseState SDL_GetMouseState;
da_SDL_GetRelativeMouseState SDL_GetRelativeMouseState;
da_SDL_WarpMouse SDL_WarpMouse;
da_SDL_CreateCursor SDL_CreateCursor;
da_SDL_SetCursor SDL_SetCursor;
da_SDL_GetCursor SDL_GetCursor;
da_SDL_FreeCursor SDL_FreeCursor;
da_SDL_ShowCursor SDL_ShowCursor;

da_SDL_CreateMutex SDL_CreateMutex;
da_SDL_mutexP SDL_mutexP;
da_SDL_mutexV SDL_mutexV;
da_SDL_DestroyMutex SDL_DestroyMutex;
da_SDL_CreateSemaphore SDL_CreateSemaphore;
da_SDL_DestroySemaphore SDL_DestroySemaphore;
da_SDL_SemWait SDL_SemWait;
da_SDL_SemTryWait SDL_SemTryWait;
da_SDL_SemWaitTimeout SDL_SemWaitTimeout;
da_SDL_SemPost SDL_SemPost;
da_SDL_SemValue SDL_SemValue;
da_SDL_CreateCond SDL_CreateCond;
da_SDL_DestroyCond SDL_DestroyCond;
da_SDL_CondSignal SDL_CondSignal;
da_SDL_CondBroadcast SDL_CondBroadcast;
da_SDL_CondWait SDL_CondWait;
da_SDL_CondWaitTimeout SDL_CondWaitTimeout;

da_SDL_RWFromFile SDL_RWFromFile;
da_SDL_RWFromFP SDL_RWFromFP;
da_SDL_RWFromMem SDL_RWFromMem;
da_SDL_RWFromConstMem SDL_RWFromConstMem;
da_SDL_AllocRW SDL_AllocRW;
da_SDL_FreeRW SDL_FreeRW;
da_SDL_ReadLE16 SDL_ReadLE16;
da_SDL_ReadBE16 SDL_ReadBE16;
da_SDL_ReadLE32 SDL_ReadLE32;
da_SDL_ReadBE32 SDL_ReadBE32;
da_SDL_ReadLE64 SDL_ReadLE64;
da_SDL_ReadBE64 SDL_ReadBE64;
da_SDL_WriteLE16 SDL_WriteLE16;
da_SDL_WriteBE16 SDL_WriteBE16;
da_SDL_WriteLE32 SDL_WriteLE32;
da_SDL_WriteBE32 SDL_WriteBE32;
da_SDL_WriteLE64 SDL_WriteLE64;
da_SDL_WriteBE64 SDL_WriteBE64;

da_SDL_Linked_Version SDL_Linked_Version;

da_SDL_GetWMInfo SDL_GetWMInfo;

da_SDL_CreateThread SDL_CreateThread;
da_SDL_ThreadID SDL_ThreadID;
da_SDL_GetThreadID SDL_GetThreadID;
da_SDL_WaitThread SDL_WaitThread;
da_SDL_KillThread SDL_KillThread;

da_SDL_GetTicks SDL_GetTicks;
da_SDL_Delay SDL_Delay;
da_SDL_SetTimer SDL_SetTimer;
da_SDL_AddTimer SDL_AddTimer;
da_SDL_RemoveTimer SDL_RemoveTimer;

da_SDL_VideoInit SDL_VideoInit;
da_SDL_VideoQuit SDL_VideoQuit;
da_SDL_VideoDriverName SDL_VideoDriverName;
da_SDL_GetVideoSurface SDL_GetVideoSurface;
da_SDL_GetVideoInfo SDL_GetVideoInfo;
da_SDL_VideoModeOK SDL_VideoModeOK;
da_SDL_ListModes SDL_ListModes;
da_SDL_SetVideoMode SDL_SetVideoMode;
da_SDL_UpdateRects SDL_UpdateRects;
da_SDL_UpdateRect SDL_UpdateRect;
da_SDL_Flip SDL_Flip;
da_SDL_SetGamma SDL_SetGamma;
da_SDL_SetGammaRamp SDL_SetGammaRamp;
da_SDL_GetGammaRamp SDL_GetGammaRamp;
da_SDL_SetColors SDL_SetColors;
da_SDL_SetPalette SDL_SetPalette;
da_SDL_MapRGB SDL_MapRGB;
da_SDL_MapRGBA SDL_MapRGBA;
da_SDL_GetRGB SDL_GetRGB;
da_SDL_GetRGBA SDL_GetRGBA;
da_SDL_CreateRGBSurface SDL_CreateRGBSurface;
da_SDL_CreateRGBSurfaceFrom SDL_CreateRGBSurfaceFrom;
da_SDL_FreeSurface SDL_FreeSurface;
da_SDL_LockSurface SDL_LockSurface;
da_SDL_UnlockSurface SDL_UnlockSurface;
da_SDL_LoadBMP_RW SDL_LoadBMP_RW;
da_SDL_SaveBMP_RW SDL_SaveBMP_RW;
da_SDL_SetColorKey SDL_SetColorKey;
da_SDL_SetAlpha SDL_SetAlpha;
da_SDL_SetClipRect SDL_SetClipRect;
da_SDL_GetClipRect SDL_GetClipRect;
da_SDL_ConvertSurface SDL_ConvertSurface;
da_SDL_UpperBlit SDL_UpperBlit;
da_SDL_LowerBlit SDL_LowerBlit;
da_SDL_FillRect SDL_FillRect;
da_SDL_DisplayFormat SDL_DisplayFormat;
da_SDL_DisplayFormatAlpha SDL_DisplayFormatAlpha;
da_SDL_CreateYUVOverlay SDL_CreateYUVOverlay;
da_SDL_LockYUVOverlay SDL_LockYUVOverlay;
da_SDL_UnlockYUVOverlay SDL_UnlockYUVOverlay;
da_SDL_DisplayYUVOverlay SDL_DisplayYUVOverlay;
da_SDL_FreeYUVOverlay SDL_FreeYUVOverlay;
da_SDL_GL_LoadLibrary SDL_GL_LoadLibrary;
da_SDL_GL_GetProcAddress SDL_GL_GetProcAddress;
da_SDL_GL_SetAttribute SDL_GL_SetAttribute;
da_SDL_GL_GetAttribute SDL_GL_GetAttribute;
da_SDL_GL_SwapBuffers SDL_GL_SwapBuffers;
da_SDL_GL_UpdateRects SDL_GL_UpdateRects;
da_SDL_GL_Lock SDL_GL_Lock;
da_SDL_GL_Unlock SDL_GL_Unlock;
da_SDL_WM_SetCaption SDL_WM_SetCaption;
da_SDL_WM_GetCaption SDL_WM_GetCaption;
da_SDL_WM_SetIcon SDL_WM_SetIcon;
da_SDL_WM_IconifyWindow SDL_WM_IconifyWindow;
da_SDL_WM_ToggleFullScreen SDL_WM_ToggleFullScreen;
da_SDL_WM_GrabInput SDL_WM_GrabInput;
");

alias SDL_CreateRGBSurface SDL_AllocSurface;
alias SDL_UpperBlit SDL_BlitSurface;