/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <unistd.h>
#include <signal.h>
#include <iostream>
#include <string>
#include <gtk/gtk.h>
#include <stdio.h>
#include "BTTask.h"
#include "LiteWindow.h"
#include "NewTaskWindow.h"
#include "log.h"
#include "utils.h"

DEFINE_LOGGER("BitStorm");

void set_signal_handler(void);

int main(int argc,char** argv)
{
	bindtextdomain(PACKAGE_NAME, LOCALEDIR);
	bind_textdomain_codeset (PACKAGE_NAME, "UTF-8");
	textdomain(PACKAGE_NAME);

	setlocale (LC_ALL, "");

	gtk_init(&argc, &argv);
	set_signal_handler();
	log_load_config("log.cfg");
	LOG_INFO("BitStorm 0.2");	
	
	char* buf = new char[1024];
	LOG_DEBUG("sizeof(buf)="<<sizeof(buf));
	
	CBTTask task;
	std::string torrentFilePath;
	std::string destPath;	

	if(argc >= 2)
	{
		torrentFilePath = locale_to_utf8(argv[1]);
	}
	
	if(torrentFilePath.size() == 0)
	{
		torrentFilePath = locale_to_utf8(CLiteWindow::getUserInputTorrentFilePath().c_str());
		LOG_DEBUG("torrentFilePath="<<torrentFilePath);
		if(torrentFilePath.size() == 0)
		{
			return -1;
		}
	}
	
	task.setTorrentFilePath(torrentFilePath.c_str());
	if(!task.loadTorrentFile())
	{
		CLiteWindow::showMessage("Can not load the torrent file");
		return -1;
	}
	
	CNewTaskWindow dwindow;
	if(!dwindow.show(&task))
	{
		return -1;
	}

	if(!task.start())
	{
		CLiteWindow::showMessage(task.getErrorMessage().c_str());
		return -1;
	}

	CLiteWindow window;
	window.run(&task);
	
	task.stop();
	
	LOG_INFO("ByeBye");

	return 0;
}

void signal_handler(int signo)
{
	fprintf(stderr, "bitstorm lite recv signal %d\n", signo);
	exit(-1);
}

void set_signal_handler(void)
{
	struct sigaction act;

	act.sa_handler = signal_handler;
	act.sa_flags = 0;
	sigemptyset(&act.sa_mask);

	sigaction(SIGINT, &act, NULL);
	sigaction(SIGQUIT, &act, NULL);
	sigaction(SIGTERM, &act, NULL);
	
	sigaction(SIGBUS, &act, NULL);
	sigaction(SIGSEGV, &act, NULL);
	
	act.sa_handler = SIG_IGN;

	sigaction(SIGPIPE, &act, NULL);
	sigaction(SIGHUP, &act, NULL);
}
