/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgRelation;
import cz.startnet.utils.pgdiff.schema.PgRule;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PgDiffRules {
    public static void createRules(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgRelation pgRelation : pgSchema2.getRels()) {
            PgRelation pgRelation2 = pgSchema == null ? null : pgSchema.getRelation(pgRelation.getName());
            for (PgRule pgRule : PgDiffRules.getNewRules(pgRelation2, pgRelation)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgRule.getCreationSQL());
            }
        }
    }

    public static void dropRules(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgRelation pgRelation : pgSchema2.getRels()) {
            PgRelation pgRelation2 = pgSchema == null ? null : pgSchema.getRelation(pgRelation.getName());
            for (PgRule pgRule : PgDiffRules.dropRules(pgRelation2, pgRelation)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgRule.getDropSQL());
            }
        }
    }

    private static List<PgRule> dropRules(PgRelation pgRelation, PgRelation pgRelation2) {
        ArrayList<PgRule> arrayList = new ArrayList<PgRule>();
        if (pgRelation2 != null && pgRelation != null) {
            List<PgRule> list = pgRelation2.getRules();
            for (PgRule pgRule : pgRelation.getRules()) {
                if (list.contains(pgRule)) continue;
                arrayList.add(pgRule);
            }
        }
        return arrayList;
    }

    private static List<PgRule> getNewRules(PgRelation pgRelation, PgRelation pgRelation2) {
        ArrayList<PgRule> arrayList = new ArrayList<PgRule>();
        if (pgRelation2 != null) {
            if (pgRelation == null) {
                arrayList.addAll(pgRelation2.getRules());
            } else {
                for (PgRule pgRule : pgRelation2.getRules()) {
                    if (pgRelation.getRules().contains(pgRule)) continue;
                    arrayList.add(pgRule);
                }
            }
        }
        return arrayList;
    }

    private PgDiffRules() {
    }
}

